﻿Ext.define('Keysystems.Financ.Edit', {
	extend: 'Keysystems.Base.Edit',
	title: 'Финансирование',
	f: 'new',
	viewMinSize: [690, 510],
	bodyPadding: 0,
	readOnlyList: [
		'S_ORGP', 'S_ORGC', 'S_MINVO', 'S_PODRAZDEL', 'S_CST', 'S_RASH', 'S_ST',
		'S_VBUDJ', 'S_ADDBK', 'Period', 'DT', 'S_STATUS', 'SUMMA', 'S_NACPROJ'
	],

	createItems: function () {
		var me = this;
		return me.objs.allTab = Ext.create('Ext.tab.Panel',
			{
				plain: true,
				border: 0,
				flex: 1,
				userCls: me.basePanelCls,
				bodyCls: me.basePanelBodyCls,
				items: me.getTab('General')
			});
	},	
	createTabGeneral: function() {
		var me = this,
			objs = me.objs;

		objs.tabGeneral = Ext.create('Ext.panel.Panel',
			{
				title: 'Общие',
				layout: { type: 'vbox', align: 'stretch' },
				flex: 1,
				border: 0,
				bodyPadding: 10,
				items: [
					Ext.create('Ext.form.FieldContainer',
						{
							layout: { type: 'vbox', align: 'stretch' },
							padding: me.bodyPadding,
							items: [
								me.sksc('KBK',
									Ext.create('Ext.form.field.Text',
										{
											labelWidth: me.labelWidth,
											fieldLabel: 'КБК',
											hideTrigger: true,
											maxWidth: 330,
											maxLength: 20,
											enforceMaxLength: true,
											maskRe: /^[A-ZА-Я0-9]+$/i, //допускаем ввод только цифр и букв
											listeners: {
												blur: function() {
													var kbk = me.gksc('KBK').getValue();
													if (kbk.length === 20) {
														me.setKbk(kbk);
													}
												}
											}
										})),
								me.createDictEdit({
									key: 'S_ORGP',
									mode: 'SINGL',
									initWhereArgs: function() {
										let whereArgs = {
											SType: { value: '[3]', type: 'List_int' },
											HasFilterOnLoad: { value: 'false', type: 'bool' },
											Regions: { value: JSON.stringify(me.gksd('Regions')), type: 'List_int' }
										};
										if (window.isRfn)
											whereArgs['FinanceObject'] = {
												value: me.objs.S_ORGC.getLink(),
												type: 'int'
											};
										return whereArgs;
									},
									code: dnl.S_ORG,
									fieldLabel: 'Финансирующая'
								}),
								me.createDictEdit({
									key: 'S_ORGC',
									mode: 'SINGL',
									ksAllowEmpty: true,
									code: dnl.S_ORG,
									fieldLabel: 'Организация',
									ksSetValue: function(v) {
										this.setValue(v);
										me.fillFinOrgByMinvo();
									}
								}),
								me.createDictEdit({
									key: 'S_NPA',
									mode: 'SINGL',
									ksAllowEmpty: true,
									code: dnl.S_NPA,
									fieldLabel: 'НПА'
								}),
								me.createDictEdit({
									key: 'S_MINVO',
									mode: 'SINGL',
									code: dnl.S_MINVO,
									fieldLabel: 'Глава',
									ksSetValue: function(v) {
										this.setValue(v);
										me.getKbk();
									},
									initWhereArgs: function() {
										var dh = me.gksc('DT').getValue();

										return {
											DH1: {
												value: dh.dh1.toDateString(),
												type: 'Date'
											},
											DH2: {
												value: dh.dh2.toDateString(),
												type: 'Date'
											}
										};
									}
								}),
								me.createDictEdit({
									key: 'S_PODRAZDEL',
									mode: 'SINGL',
									code: dnl.S_PODRAZDEL,
									fieldLabel: 'Подраздел',
									ksSetValue: function(v) {
										this.setValue(v);
										me.getKbk();
									},
									initWhereArgs: function() {
										var dh = me.gksc('DT').getValue();

										return {
											DH1: {
												value: dh.dh1.toDateString(),
												type: 'Date'
											},
											DH2: {
												value: dh.dh2.toDateString(),
												type: 'Date'
											}
										};
									}
								}),
								me.createDictEdit({
									key: 'S_CST',
									mode: 'SINGL',
									code: dnl.S_CST,
									fieldLabel: 'Цел. статья',
									ksSetValue: function(v) {
										this.setValue(v);
										me.getKbk();
									},
									initWhereArgs: function() {
										var dh = me.gksc('DT').getValue();

										return {
											DH1: {
												value: dh.dh1.toDateString(),
												type: 'Date'
											},
											DH2: {
												value: dh.dh2.toDateString(),
												type: 'Date'
											}
										};
									}
								}),
								me.createDictEdit({
									key: 'S_RASH',
									mode: 'SINGL',
									code: dnl.S_RASH,
									fieldLabel: 'Вид расходов',
									ksSetValue: function(v) {
										this.setValue(v);
										me.getKbk();
									},
									initWhereArgs: function() {
										var dh = me.gksc('DT').getValue();

										return {
											DH1: {
												value: dh.dh1.toDateString(),
												type: 'Date'
											},
											DH2: {
												value: dh.dh2.toDateString(),
												type: 'Date'
											}
										};
									}
								}),
								me.createDictEdit({
									key: 'S_ST',
									mode: 'SINGL',
									ksSetValue: function(v) {
										this.setValue(v);
										me.getKbk();
									},
									code: dnl.S_ST,
									fieldLabel: 'КОСГУ',
									initWhereArgs: function() {
										var dh = me.gksc('DT').getValue();

										return {
											DH1: {
												value: dh.dh1.toDateString(),
												type: 'Date'
											},
											DH2: {
												value: dh.dh2.toDateString(),
												type: 'Date'
											}
										};
									}
								}),
								me.createDictEdit({
									key: 'S_VBUDJ',
									mode: 'SINGL',
									code: dnl.S_VBUDJ,
									fieldLabel: 'Вид средств',
									initWhereArgs: function() {
										var dh = me.gksc('DT').getValue();

										return {
											DH1: {
												value: dh.dh1.toDateString(),
												type: 'Date'
											},
											DH2: {
												value: dh.dh2.toDateString(),
												type: 'Date'
											}
										};
									}
								}),
								me.createDictEdit({
									key: 'S_NACPROJ',
									mode: 'SINGL',
									code: dnl.S_NACPROJ,
									fieldLabel: 'Нац. проект',
									initWhereArgs: function() {
										var dh = me.gksc('DT').getValue();

										return {
											DH1: {
												value: dh.dh1.toDateString(),
												type: 'Date'
											},
											DH2: {
												value: dh.dh2.toDateString(),
												type: 'Date'
											}
										};
									}
								}),
								me.createDictEdit({
									key: 'S_ADDBK',
									mode: 'SINGL',
									code: dnl.S_ADDBK,
									fieldLabel: 'Доп.классификация',
									initWhereArgs: function() {
										var dh = me.gksc('DT').getValue();

										return {
											DH1: {
												value: dh.dh1.toDateString(),
												type: 'Date'
											},
											DH2: {
												value: dh.dh2.toDateString(),
												type: 'Date'
											}
										};
									}
								}),
								Ext.create('Ext.form.FieldContainer',
									{
										layout: { type: 'hbox', align: 'stretch' },
										items: [
											me.sksc('Period',
												objs.Period = Ext.create('Ext.form.ComboBox',
													{
														value: 0,
														width: 305,
														labelWidth: me.labelWidth,
														fieldLabel: 'Периодичность',
														height:22,
														maxHeight:22,
														store: Ext.create('Ext.data.Store',
															{
																fields: ['index', 'text'],
																data: [
																	{ index: 0, text: 'Месяц' },
																	{ index: 1, text: 'Квартал' }
																],
																proxy: 'memory'
															}),
														editable: false,
														queryMode: 'local',
														displayField: 'text',
														valueField: 'index',
														listeners: {
															change: function(th, newVal, oldVal) {
																if (newVal != oldVal) {
																	me.objs.DT.setState(newVal === 0 ? 1 : 2);
																}
															}
														}
													})),
											'->',
											me.sksc('DT',
												objs.DT = Ext.create('Keysystems.Controls.KsPeriod',
													{
														startYear: me.startYear,
														fieldLabel: 'Период',
														padding:'0 0 0 5',
														labelWidth: 70,
														state: 1,
														allStates: 3,
														width: 350,
														listeners: {
															ksChange: function() {
																if (me.isLoaded) return;
																me.getKbk();
																me.enableST();
															}
														}
													}))
										]
									}),
								me.sksc('SUMMA',
									objs.SUMMA = Ext.create('Keysystems.Controls.CalcField',
										{
											labelWidth: me.labelWidth,
											fieldLabel: 'Сумма',
											minValue: 0,
											maxWidth: 300,
											ksAllowEmpty: true
										})),
								me.sksc('S_STATUS',
									objs.S_STATUS = Ext.create('Ext.form.field.ComboBox',
										{
											value: null,
											fieldLabel: 'Статус',
											ksAllowEmpty: true,
											labelWidth: me.labelWidth,
											editable: false,
											maxWidth: 300,
											queryMode: 'local',
											displayField: CBDataLib.displayField,
											valueField: CBDataLib.valueField,
											store: Ext.create('Ext.data.Store',
												{
													fields: CBDataLib.getFields(),
													data: me.revizFinancStatus ?? CBDataLib.get('FinancStatus'),
													proxy: 'memory'
												})
										}))
							]
						})
				]
			});
		return objs.tabGeneral;
	},
	//конструктор таба Реквизиты
	createTabProp: function() {
		let me = this,
			objs = me.objs;   

		return objs.tabProp = Ext.create('Keysystems.Panel.Prop',{
			border: 0, 
			parentView: me,
			readOnly: me.readOnly || objs.tabPropReadOnly ,
			decimalData: me.gksd('decimalData')
		});
	},
	afterGetExtra: function() {
		var me = this,
			objs = me.objs;

		if (me.data && me.f === 'new') {
			var data = me.data.data;

			let dict = me.isNpa ? objs.S_NPA : objs.S_ORGC;
			dict.setValue({
				LINK: data.S_ORG,
				CODE: data.S_ORG_CODE,
				NAME: data.S_ORG_NAME
			});

			objs.S_STATUS.setValue(me.isNpa  ? 0 : 3);
			objs.S_VBUDJ.setValue({
				LINK: data.S_VBUDJ,
				CODE: data.S_VBUDJ_CODE,
				NAME: data.S_VBUDJ_NAME
			});
		}

		me.enableST();
		me.callParent(arguments);
	},

	setKbk: function(kbk) {
		var me = this,
			params = me.dataCollector();
		

		params.KBK = kbk + '';
		const loadMask = new Ext.LoadMask({
			msg: KS.L10n.updating_data,
			view: me.objs.view,
			autoShow: true,
			rid: ajaxRequest({
				url: 'SFinanc/SetKbk_A',
				params: { gzipData: SignalR.pack(params) },
				success: function(value) {
					Ext.each(Object.keys(value), function(key) {
						me.gksc(key).ksSetValue(value[key]);
					});
				},
				callback: function() { loadMask.destroy(); }
			})
		});
	},

	fillFinOrgByMinvo: function() {
		var me = this,
			orgC = me.objs.S_ORGC.getLink(),
			fillByMinvo = me.gksd('FillFinorgByMinvo');

		if (!orgC) return;

		if (fillByMinvo) {
			const loadMask = new Ext.LoadMask({
				msg: KS.L10n.updating_data,
				view: me.objs.view,
				autoShow: true,
				rid: ajaxRequest({
					url: 'SFinanc/FillFinorgByMinvo_A',
					params: { orgLink: orgC },
					success: function(value) {
						if (value.SORGP && value.SORGP.data) {
							me.gksc('S_ORGP').setValue(value.SORGP.data);
						}
					},
					callback: function() { loadMask.destroy(); }
				})
			});
		} else {
			const loadMask = new Ext.LoadMask({
				msg: KS.L10n.updating_data,
				view: me.objs.view,
				autoShow: true,
				rid: ajaxRequest({
					url: 'SFinanc/GetFinOrg_A',
					params: { orgLink: orgC },
					success: function (value) {
						if (!value || !value.SORGP || !value.SORGP.data || value.SORGP.data.LINK === 0) return;

						let orgP = me.gksc('S_ORGP').getLink();
						if (value.SORGP && value.SORGP.data && orgP !== value.SORGP.data.LINK) {
							if (orgP === 0) {
								me.gksc('S_ORGP').setValue(value.SORGP.data);
								return;
							}
							selectDialogShow(KS.L10n.FinancEditView_dictOrg_Changed_Изменение_финансирующей_организации, 
								Ext.String.format(KS.L10n.FinancEditView_dictOrg_Changed_Изменить_финансирующую_организацию_на__0__1__, value.SORGP.data.NAME), function () {
								me.gksc('S_ORGP').setValue(value.SORGP.data);
							});
						}
					},
					callback: function () { loadMask.destroy(); }
				})
			});
		}
	},

	getKbk: function() {
		var me = this,
			str = '',
			dt = me.gksc('DT').getValue(),
			endFunc = function (value) {
				if (value && value.length > 20) value = value.substring(0, 20);
				me.gksc('KBK').setValue(value);
			};

		if (me.gksc('S_MINVO').isEmpty()) return endFunc();
		str += me.gksc('S_MINVO').getCode();

		if (me.gksc('S_PODRAZDEL').isEmpty()) return endFunc();
		str += me.gksc('S_PODRAZDEL').getCode();

		if (me.gksc('S_CST').isEmpty()) return endFunc();
		str += me.gksc('S_CST').getCode();

		if (me.gksc('S_RASH').isEmpty()) return endFunc();
		str += me.gksc('S_RASH').getCode();

		if (dt.dh1.getFullYear() <= 2015) {
			if (me.gksc('S_ST').isEmpty()) return endFunc();
			str += me.gksc('S_ST').getCode();
		}

		endFunc(str);
		return str;
	},

	getExtra: function(endFunc, link) {
		var me = this,
			objs = me.objs,
			orgLink = 0,
			npaLink = 0;
		
		if (me.data && me.data.data.S_ORG) {
			if (me.isNpa) {
				npaLink = me.data.data.S_ORG;
			} else {
				orgLink = me.data.data.S_ORG;
			}
		}

		me.baseGetExtra({
			link: link,
			orgLink: link > 0 ? 0 : orgLink,
			npaLink: link > 0 ? 0 : npaLink
		}, function(val) {
			let dt1 = me.getDateOrToday(val.DT1),
				dt2 = me.getDateOrToday(val.DT2);

			objs.Period.setValue(dt1.getMonth() === dt2.getMonth() ? 0 : 1);
			objs.DT.setValue(dt1, dt2);
			
			objs.S_ORGP.setValue(val.SORGP);
			objs.SUMMA.setValue(val.SUMMA);
			objs.S_STATUS.setValue(val.STATUS);
			objs.S_PODRAZDEL.setValue(val.S_PODRAZDEL);
			objs.S_MINVO.setValue(val.S_MINVO);
			objs.S_ST.setValue(val.S_ST);
			objs.S_CST.setValue(val.S_CST);
			objs.S_RASH.setValue(val.S_RASH);
			objs.S_NACPROJ.setValue(val.S_NACPROJ);
			objs.S_VBUDJ.setValue(val.S_VBUDJ);
			objs.S_ADDBK.setValue(val.S_ADDBK);
			me.sksd('decimalData', val.decimalData);
			me.sksd('FillFinorgByMinvo', val.FillFinorgByMinvo);
			me.sksd('Regions', val.Regions);
			
			objs.SUMMA.decimalData = val.decimalData;

			if (val.S_NPA.length) {				
				objs.S_ORGC.setVisible(false);
				objs.S_STATUS.setVisible(false);
				//todo скрыть и сдвинуть objs.Period.setVisible(false);				
				objs.S_NPA.setValue(val.S_NPA);
			}
			else {
				objs.S_ORGC.setValue(val.SORGC);
				objs.S_NPA.setVisible(false);
			}
			if (val.tabProp) {
				objs.isTabProp = true;
				if (me.isTabReadOnly(val.Tabs, 'PROP')) objs.tabPropReadOnly = true;
				objs.allTab.changeTab(me.getTab('Prop').loadData(val.tabProp), true);
			}
			if (me.readOnly || (me.data && me.data.data.readOnly)) me.setReadOnly(true);
			if (endFunc) endFunc();   
		});
	},
	isFilled: function() {
		var me = this,
			objs = me.objs;
		
		let res = true;

		if (me.isNpa){
			if (objs.S_NPA.isEmpty()) {				
				me.addToInvalidControls(objs.S_NPA);
				res = false;
			}
		}
		else {
			if (objs.S_ORGC.isEmpty()) {
				me.addToInvalidControls(objs.S_ORGC);
				res = false;
			}
		}
		if (!Ext.isNumber(objs.S_STATUS.getValue())) {
			me.addToInvalidControls(objs.S_STATUS);
			res = false;
		}

		if (window.isRfn && objs.S_ST.getLink() !== 0 && me.gksc('DT').getValue().dh1.getFullYear() >= 2016) {
			me.errorMessages.push(KS.L10n.FinancEditView_CheckSave_Поле_КОСГУ_с_2016_года_не_заполняется_);
		}
		if (objs.SUMMA.getNumValue() === 0) {
			me.addToInvalidControls(objs.SUMMA, {optional : true});
			me.warningMessages.push(KS.L10n.FinancEditView_CheckSave_Введена_нулевая_сумма_);			
		}
		return res;
	},
	dataCollector: function() {
		var me = this,
			objs = me.objs,
			dt = objs.DT.getValue();

		var data = me.callParent([false]);
		data.LINK = objs.link;
		data.SORGC = objs.S_ORGC.getLink();
		data.S_NPA = objs.S_NPA.getLink();
		data.SORGP = objs.S_ORGP.getLink();
		data.DT1 = dt.dh1.toDateString();
		data.DT2 = dt.dh2.toDateString();
		data.SUMMA = objs.SUMMA.getNumValue();
		data.STATUS = objs.S_STATUS.getValue();
		data.S_PODRAZDEL = objs.S_PODRAZDEL.getLink();
		data.S_MINVO = objs.S_MINVO.getLink();
		data.S_ST = objs.S_ST.getLink();
		data.S_CST = objs.S_CST.getLink();
		data.S_RASH = objs.S_RASH.getLink();
		data.S_NACPROJ = objs.S_NACPROJ.getLink();
		data.S_VBUDJ = objs.S_VBUDJ.getLink();
		data.S_ADDBK = objs.S_ADDBK.getLink();
		data.RelPlanrevizLinks = me.RelPlanrevizLinks;
		data.prop = objs.isTabProp ? me.getTab('Prop').getData(1) : _;
		me.getKbk();

		return data;
	},
	successSaveFunc: function (result, endFunc, params) {
		var me = this;
		if (!result.result && result.limitLinks) {
			var link = me.data.get('LINK');
			// Сначала блокирующее сообщение про связанные записи Мероприятия
			if (result.limitLinks.DOCUMENT_REVIZ) {
				var links = { DOCUMENT_REVIZ: result.limitLinks.DOCUMENT_REVIZ, DOCUMENT_PLANREVIZ: [0] };
				relationsMsg(me.code,
					[{ name: "()", text: KS.L10n.FinancEditView_AfterFailedSaveCompleted_Сохранение_невозможно__Изменения_затрагивают_связанные_записи_, related: true, link: link }],
					[link],
					false,
					me,
					links);
			}
			else if (result.limitLinks.DOCUMENT_PLANREVIZ) {
				// Затем предупредающее сообщение про связанные записи Планирования
				var links = { DOCUMENT_REVIZ: [0], DOCUMENT_PLANREVIZ: result.limitLinks.DOCUMENT_PLANREVIZ };
				relationsMsg(me.code,
					[{ name: "()", text: KS.L10n.FinancEditView_AfterFailedSaveCompleted_При_сохранении_факт_финансирования_будет_исключен_из_запланированных_КМ_, related: true, link: link }],
					[link],
					false,
					me,
					links,
					function () {
						me.RelPlanrevizLinks = result.limitLinks.DOCUMENT_PLANREVIZ;
						me.saveData();
					});
			}
		}
		this.callParent(arguments);
	},
	enableST: function() {
		if (!window.isRfn) return;
		let me = this,
			objs = me.objs, 
			dt = me.gksc('DT').getValue(),
			readOnly = (dt.dh1.getFullYear() >= 2016);

		objs.S_ST.setReadOnly(readOnly && objs.S_ST.getLink() === 0);
		objs.S_ST.colorizeBad(readOnly && objs.S_ST.getLink() !== 0);
	}
})