﻿Ext.define('Revizor.FilterView', {
	extend: 'Ext.window.Window',
	alias: 'widget.FilterView',
	modal: true,
	iconCls: 'x_btn_report_query',
	layout: 'border',
	width: 800,
	height: 600,
	minHeight: 200,
	maxHeight: 600,
	minWidth: 400,
	result: null,
	maximizable: true,
	defaultParams: [],
	labelWidth: 200,
	minButtonWidth: 30,
	resizable: true,
	code: null,
	selectListAction: null,
	checkChanges: true,
	variant: null,

	/**
	 * Сохранить параметры и закрыть форму
	 */
	submit: function () {
		let me = this;
		me.updateValues();
		me.saveVariant(me.SVARPARAM.getLink(), () => {
			me.checkChanges = false;
			delete me.filter.asString;
			me.ok && me.ok(me.filter, me.SVARPARAM.getLink());
			me.close();
		});
	},

	/**
	 * Очистить значения параметров
	 */
	reset: function () {
		let me = this;
		Ext.each(me.filter, el => me.controlClear(el));
	},

	/**
	 * Сохранить вариант
	 */
	saveVariant: function (variant, callback) {
		let me = this;
		if (!variant) {
			if (callback) callback(true);
			return;
		}

		let params = me.getParameters();

		this.setLoading(wmc.getMask('FilterParamsSaving'));
		ajaxRequest({
			url: '/Data/SaveParametersToVariant_A',
			params: {
				code: me.code,
				variant: variant,
				parameters: JSON.stringify(params),
			},
			success: (response) => {
				me.setLoading(false);
				me.oldData = JSON.stringify(params);
				if (callback) callback(true);
			},
			failure: function () {
				me.setLoading(false);
				showError(wmc.get('FilterParamsSavingError'));
				if (callback) callback(false);
			}
		});
	},
	updateValues: function () {
		let me = this;
		Ext.each(me.filter, function (el) {
			el.Condition = el.fieldCondition && el.fieldCondition.cbCondition ? el.fieldCondition.cbCondition.getValue() : -1;
			if (!el.fieldCondition) {
				console.error('el.fieldCondition');
				console.error(el);
				return;
			}
			let value;
			switch (el.ControlType) {
				case 11:
				case 12:
					value = 0;
					let vals = el.fieldCondition.elCondition.getValue()["rb"];
					if (vals) {
						if (!Array.isArray(vals))
							value = vals;
						else
							vals.forEach(v => value = value | parseInt(v));
					}
					break;
				default:
					value = el.fieldCondition.elCondition.getValue();
			}
			el.Value = value;
		});
	},

	getParameters: function () {
		let me = this,
			values = {};

		me.updateValues();
		me.filter.filter(par => +par.Condition >= 0).forEach(par => {
			let value;
			let controlType = miscTypes.ControlType[par.ControlType] ?? 0;
			switch (controlType) {
				case "NumericBox":
					value = {Value: par.Value, Type: 'int'};
					break;
				case "CurrencyBox":
					value = {Value: par.Value, Type: 'float'};
					break;
				case "DateBox":
					value = {Value: par.Value.toDateString(), Type: 'Date'};
					break;
				case "CheckBox":
					value = {Value: par.Value, Type: 'bool'};
					break;
				case "EditBox":
					value = {Value: par.Value, Type: 'string'};
					break;
				case "Dictionary":
					let links = par.Value.map(v => (v.data || v).LINK);
					value = {Value: JSON.stringify(links), Type: 'List_int'};
					break;
				case "ComboBox":
					value = {Value: par.Value, Type: 'List_int'};
					break;
				case "DatePeriod":
					value = {Value: JSON.stringify(par.Value), Type: 'Period'};
					break;
				case "DocType":
				case "DocTypes":
					value = {Value: par.Value, Type: 'int'};
					break;
				case "AutoPersonControl":
					value = {Value: par.Value, Type: 'int'};
					break;
				default:
					Log.sendLog("Не обработан параметр" + controlType);
					break;
			}
			if (value) value.Condition = par.Condition;
			values[par.Name] = value;
		});
		return values;
	},

	getFormName: function () {
		return `${this.code}Filter${this.selectListAction}`;
	},

	createButtons: function () {
		var me = this;
		return [
			me.SVARPARAM = Ext.create('widget.dictedit', {
				labelWidth: 150,
				fieldLabel: 'Вариант',
				layout: 'hbox',
				scope: this,
				flex: 1,
				Code: "DICTIONARY_SVARPARAM",
				Action: "SINGLE",
				ParentID: "dictVarParams",
				handler: function () {
					let oldVariant = me.SVARPARAM.getLink(),
						settings = {
							'mode': 'SINGLE',
							//'parentView': objs['view'],
							'code': me.SVARPARAM.Code,
							'whereArgs': {
								'FormName': {
									value: me.getFormName(),
									type: 'string'
								}
							},
							'inputDicts': [
								Ext.create('InputEditDict', {
									'name': 'FORMNAME',
									'data': me.getFormName()
								})
							],
							'checkList': me.SVARPARAM.getValue(),
							'control': me.SVARPARAM,
							'contextSearch': me.SVARPARAM.contextSearch
						};
					let functions = {
						//scope: null,
						'ok': function (value) {
							if (!value || !value.length) return;

							let newVariant = value[0].data.LINK;
							let hasChanges = oldVariant && oldVariant !== newVariant
								? JSON.stringify(me.getParameters()) !== me.oldData
								: false;
							if (hasChanges) {
								Ext.Msg.show({
									title: KS.L10n.attention,
									msg: wmc.get('SaveChanges'),
									buttons: Ext.MessageBox.YESNOCANCEL,
									icon: Ext.MessageBox.QUESTION,
									fn: function (buttonId) {
										if (buttonId === 'yes') {
											me.saveVariant(oldVariant, (saved) => {
												if (!saved) return;
												me.loadVariant(newVariant);
											});
										}
										if (buttonId === 'no') {
											me.loadVariant(newVariant);
										}
									}
								});
							} else me.loadVariant(newVariant);
						}
					};
					// из-за тригера! просто на 1 уровень выше будет сам элемент
					//functions.scope = this.up();
					dictFunc(settings, functions);
				}
			}),
			{iconCls: 'x_btn_clean', handler: me.reset, scope: this},
			{text: 'OK', width: 100, handler: me.submit, scope: this},
			{text: 'Отмена', width: 100, handler: me.close, scope: this},
			me.applyBtn = Ext.create('Ext.Button', {
				text: 'Применить',
				width: 100,
				handler: () => me.saveVariant(me.SVARPARAM.getLink()),
				scope: this,
				disabled: true
			})
		];

	},

	/**
	 * Загрузить вариант
	 * @param variant {number}
	 */
	loadVariant: function (variant) {
		let me = this;
		me.variant = variant;
		this.setLoading(wmc.getMask('FilterParamsLoading'));

		ajaxRequest({
			loadingMessage: wmc.getMask('FilterParamsLoading'),
			url: '/Data/GetParametersFromVariant_A',
			params: {
				code: me.code,
				variant: variant,
			},
			success: (response) => {
				this.setLoading(false);
				if (!response) return;

				if (!response.result) {
					showError(response.ErrorMsg);
					return;
				}

				me.reset();
				me.SVARPARAM.setValue(response.variant);
				response.values.filter(v => v.Condition).forEach(v => {
					let par = me.filter.filter(r => r.Name === v.Name)[0];
					if (!par) return;

					par.fieldCondition.cbCondition.setValue(v.Condition ?? -1);
					let controlType = miscTypes.ControlType[par.ControlType] ?? 0;
					switch (controlType) {
						case "DatePeriod":
							v.Value ? par.fieldCondition.elCondition.setValue(v.Value.dh1, v.Value.dh2)
								: par.fieldCondition.elCondition.setValue(longPeriod.begin, longPeriod.end);
							break;
						default:
							par.fieldCondition.elCondition.setValue(v.Value);
					}
				});
				me.oldData = JSON.stringify(me.getParameters());
				me.applyBtn.setDisabled(true);
			},
			failure: function () {
				me.setLoading(false);
				showError(wmc.get('ErrorGetData'));
			}
		});
	},

	initComponent: function () {
		var me = this;

		me.buttons = me.createButtons();
		me.items = [
			me.feedPanel = me.createFeedPanel(),
			me.paramsPanel = Ext.create('Ext.panel.Panel', {
				region: 'center',
				autoScroll: true,
				border: 0,
				frame: true,
				layout: {type: 'vbox', align: 'stretch'},
				groupMap: {},
				flex: 1,
				bodyPadding: 10
			})
		];
		me.generateElements(me.filter);
		if (me.variant) {
			me.loadVariant(me.variant);
		}
		me.oldData = JSON.stringify(me.getParameters());
		me.callParent(arguments);
	},

	listeners: {
		beforeclose: function () {
			let me = this;
			if (!me.checkChanges) return true;

			let newData = JSON.stringify(me.getParameters());
			if (me.oldData === newData) return true;
			Ext.Msg.show({
				title: KS.L10n.attention,
				msg: wmc.get('SaveChanges'),
				buttons: Ext.MessageBox.YESNOCANCEL,
				fn: function (buttonId) {
					if (buttonId === 'yes') {
						me.submit();
					}
					if (buttonId === 'no') {
						me.checkChanges = false;
						me.close();
					}
				},
				icon: Ext.MessageBox.QUESTION
			});
			return false;
		},
		afterrender: function () {
			//высоту рассчитываем ручками.
			//в layout: 'border' (как сейчас) у формы всегда должна быть задана фиксированная height.
			//а если использовать layout типа hbox, то ломается при исп-ии splitter'а между панелями при незаданной высоте 
			let groupCount = [...new Set(this.filter.filter(p => p.GroupName).map(p => p.GroupName))].length,
				height = this.filter.length * 30 + groupCount * 40 + 80;
			if (height > this.maxHeight) height = this.maxHeight;
			this.setHeight(height);
		}
	},

	createFeedPanel: function () {
		var me = this;
		return Ext.create('Ext.panel.Panel', {
			region: 'west',
			split: true,
			hidden: !!me.hideFeedPanel,
			width: 130,
			bodyCls: 'rks-panel-noborder rks-panel-border-bottom',
			items: [
				me.feedView = Ext.create('Ext.view.View', {
					store: me.feedStore = Ext.create('Ext.data.Store', {
						fields: ['title', 'cls', 'group'],
						data: []
					}),
					selModel: {
						mode: 'SINGLE',
						listeners: {
							selectionchange: function (th, sels) {
								var rec = sels[0];
								if (rec) {
									var group = rec.get('group');

									for (var groupName in me.paramsPanel.groupMap) {
										var g = me.paramsPanel.groupMap[groupName];
										!group || g === group ? g.show() : g.hide();
									}
								}
							}
						}
					},
					listeners: {
						viewready: function () {
							me.feedView.getSelectionModel().select(me.feedStore.first());
						}
					},
					//trackOver: true,
					collapsible: true,
					cls: 'feed-list',
					itemSelector: '.feed-list-item',
					overItemCls: 'feed-list-item-hover',
					tpl: '<tpl for="."><div class="feed-list-item {cls}">{title}</div></tpl>'
				})
			]
		});
	},

	genComboCondition: function (el, fieldLabel, labelWidth) {
		let me = this;
		return Ext.create('Keysystems.Controls.FilterOperator',
			{
				height: 24,
				width: 50 + labelWidth,
				padding: '0 5 0 0',
				labelWidth: labelWidth,
				fieldLabel: fieldLabel,
				editable: false,
				value: el.Condition === null ? -1 : el.Condition * 1,
				conditionMappings: miscTypes.ControlType[el.ControlType] === 'DatePeriod' ? {
					6: {name: 'Входит'},
					7: {name: 'Не входит'}
				} : {},
				allowedConditions: el.AllowedConditions,
				showDeleteBtn: false,
				listeners: {
					change: function (th) {
						th.group && me.markGroup(th.group);
						me.applyBtn && me.applyBtn.setDisabled(false);
					}
				}
			});
	},

	genControlByElement: function (el, comboCnd) {
		var me = this,
			v = el.Value,
			propertyValues = JSON.parse(el.PropertyValues);
		switch (miscTypes.ControlType[el.ControlType]) {
			case 'CurrencyBox':
			case 'NumericBox':
				return Ext.create('Ext.form.field.Number', {value: v});

			case 'DateBox':
				return Ext.create('Ext.form.field.Date', {value: v ? new Date(v) : _});

			case 'CheckBox':
				return Ext.create('Ext.form.field.Checkbox', {
					//boxLabel: el.Caption,
					value: v
				});

			case 'ComboBox':
				var cb = Ext.create('Keysystems.Controls.ComboBoxExtra', {
					maxWidth: 200,
					editable: false,
					multiSelect: propertyValues.UseCheckBoxStyle,
					displayField: CBDataLib.displayField,
					valueField: CBDataLib.valueField,
					store: window.miscTypes[propertyValues.Tag]
						? CBDataLib.getStore(CBDataLib.get(propertyValues.Tag, 1, _, -1))
						: CBDataLib.getStore(CBDataLib.get(_, 1, propertyValues.Tag, -1), el.DataType.toLowerCase() === 'string' ? 'string' : null)
				});
				cb.setValue(v);
				/*cb.on('change', function(th, v) {
					if (th.multiSelect) {
						if (!v.length) th.setValue([null]);
						if (v.length > 1) {
							Ext.each(v, function(v1, i) {
								if (v1 === null) {
									v.splice(i, 1);
									th.setValue(v);
									return false;
								}
								return true;
							});
						}
					}
				});*/
				cb.setValueSelectOrFrst();

				return cb;

			case 'Dictionary':
				let cfg = dictListController[propertyValues.Code];
				var dictEdit = Ext.create('Keysystems.Controls.Dict.Edit', {
					clear: function () {
						dictEdit.change && dictEdit.change();
					},
					value: v,
					code: propertyValues.Code,
					visibleFields: cfg.getVisibleFields ? cfg.getVisibleFields() : null,
					mode: el.mode ? el.mode : propertyValues.Action === 2 ? 'MULTI' : 'SINGL',
					handler: function () {
						dictFunc({
							code: propertyValues.Code,
							mode: dictEdit.mode,
							whereArgs: el.initWhereArgs ? el.initWhereArgs() : propertyValues.WhereArgs,
							checkList: dictEdit.getValue().slice(),
							parentView: me,
							control: dictEdit,
							contextSearch: dictEdit.contextSearch
						}, {
							ok: function (v) {
								dictEdit.setValue(v);
								dictEdit.change && dictEdit.change(dictEdit.getValue());
							}
						});
					}
				});
				return dictEdit;

			case 'DatePeriod':
				var datePeriod = Ext.create('Keysystems.Controls.PeriodEdit', {
					fieldLabel: '',
					maxWidth: 250,
					maxHeight: 24,
					isEmpty: function () {
						var d = this.getValue();
						return !((d.dh1 && Ext.isDate(d.dh1) && !Ext.Date.isEqual(d.dh1, longPeriod.begin)) || (d.dh2 && Ext.isDate(d.dh2) && !Ext.Date.isEqual(d.dh2, longPeriod.end)));
					}
				});
				v && datePeriod.setValue(new Date(v.dh1), new Date(v.dh2));
				return datePeriod;
			case 'EditBox':
				return Ext.create('Ext.form.field.Text', {value: v});

			case 'DocTypes':
			case 'DocType':
			case 12:
				let values = [];
				if (v & 1) values.push('1');
				if (v & 2) values.push('2');
				if (v & 4) values.push('4');
				
				let chbGroup = Ext.create('Ext.form.CheckboxGroup', {
					title: el.GroupName,
					comboId: comboCnd != null ? comboCnd.id : null,
					fieldLabel: '',
					boxLabel: '',
					labelWidth: 150,
					itemCls: 'rks-checkbox-group-item',
					items: [
						{
							boxLabel: 'внутренний',
							name: 'rb',
							inputValue: '4'
						},
						{
							boxLabel: 'входящий',
							name: 'rb',
							inputValue: '1'
						},
						{
							boxLabel: 'исходящий',
							name: 'rb',
							inputValue: '2'
						}
					],
					value: {"rb": values}
				});				
				return chbGroup;
			case "AutoPersonControl":
				let autoPersonControl = Ext.create('Keysystems.AutoPersonControl', {
					flex: el.flex ?? 1,
					comboWidth: el.comboWidth ?? 350,
				});
				autoPersonControl.setValue(v);
				return autoPersonControl;
			default:
				Log.sendLog('Новый контрол! ' + el.ControlType);
				break;
		}
	},

	controlChange: function (control, el) {
		if (control.isEmpty()) {
			control.cbCondition.setValue(-1);
		} else {
			var cbValue = control.cbCondition.getValue();
			if (cbValue === -1) {
				let defaultCond = control.cbCondition.store.getAt(0);
				if (el && el.Name === "CONTEXT") {
					let val = control.cbCondition.store.findRecord('name', 'Содержит');
					if (val) defaultCond = val;
				}
				control.cbCondition.setValue(defaultCond);
			}
		}
	},

	controlClear: function (el) {
		var control = el.fieldCondition.elCondition;
		switch (miscTypes.ControlType[el.ControlType]) {
			case 'Dictionary':
				control._clear();
				break;
			case 'DatePeriod':
				control.setValue(longPeriod.begin, longPeriod.end);
				break;
			case 'ComboBox':
				control.setValue(null);
				break;
			default:
				control.setValue();
		}
	},

	appendControlListeners: function (el, control) {
		var me = this;
		switch (miscTypes.ControlType[el.ControlType]) {
			case 'Dictionary':
				control.change = () => {
					me.controlChange(control, el);
					me.applyBtn && me.applyBtn.setDisabled(false);
				};
				break;
			case 'DatePeriod':
				control.on('kschange', () => {
					me.controlChange(control, el);
					me.applyBtn && me.applyBtn.setDisabled(false);
				});
				break;
			default:
				control.on('change', () => {
					me.controlChange(control, el);
					me.applyBtn && me.applyBtn.setDisabled(false);
				});
		}
	},

	markGroup: function (group) {
		var isFill = false;
		Ext.each(group.cbList, function (cb) {
			return !(isFill = cb.getValue() !== -1);
		});
		group.feedRecord.set('cls', isFill ? 'ks-report-full' : '');
	},

	generateElements: function (elements) {
		let me = this,
			groupMap = me.paramsPanel.groupMap;

		//me.suspendLayouts();

		me.paramsPanel.feedRecord = me.feedStore.add({title: 'Все параметры'})[0];
		me.paramsPanel.cbList = [];

		Ext.each(elements, function (el) {
			var group = groupMap[el.GroupName],
				labelWidth = 170;

			if (!el.GroupName) {
				labelWidth += 10;
				group = me.paramsPanel;
			}

			if (!group) {
				me.paramsPanel.add(group = groupMap[el.GroupName] = Ext.create('Ext.form.FieldSet', {
					title: el.GroupName,
					collapsible: true,
					cbList: [],
					layout: {type: 'vbox', align: 'stretch'}
				}));
				group.feedRecord = me.feedStore.add({title: el.GroupName, group: group})[0];
			}

			var elCondition = me.genControlByElement(el);
			if (elCondition) {
				if (el.ReadOnly && elCondition.setReadOnly) elCondition.setReadOnly(true);
				elCondition.flex = 1;

				var cbCondition = elCondition.cbCondition = me.genComboCondition(el, el.CaptionText, labelWidth);
				if (el.ReadOnly && cbCondition.setDisabled) cbCondition.setDisabled(true);
				
				cbCondition.group = group;
				group.cbList.push(cbCondition);

				me.appendControlListeners(el, elCondition);

				group.add(el.fieldCondition = Ext.create('Ext.form.FieldContainer', {
					layout: {type: 'hbox', align: 'middle'},
					cbCondition: cbCondition,
					elCondition: elCondition,
					items: [cbCondition, elCondition]
				}));
			}
		});

		me.markGroup(me.paramsPanel);
		for (var gn in groupMap) me.markGroup(groupMap[gn]);

		//me.resumeLayouts(true);
	}
});