﻿Ext.define('Keysystems.File', {
	extend: 'Ext.window.Window',
	title: 'Файл',
	iconCls: 'x_btn_new x_login_head',	
	width: 170,
	layout: { type: 'vbox', align: 'stretch' },
	resizable: false,
	modal: true,
	autoShow: true,
	checkRewriteFile: false,
	checkRewriteClick: true,
	deleteMessage: KS.L10n.delete_existing_file,
	constructor: function(cfg){
		Ext.apply(this, cfg);
		this.callParent(arguments);
	},
	initComponent: function() {
		var me = this;
		if (!me.btnsHide) me.btnsHide = {};
		me.items = me.createItems();
		me.callParent(arguments);
	},
	getFileId: function() {
		return 0;
	},
	docExists: function() {
		return false;
	},
	updRecord: Ext.emptyFn,
	createFile: Ext.emptyFn,
	downloadFile: Ext.emptyFn,
	downloadFileForEditor: Ext.emptyFn,
	uploadFile: function(file, isMain) {
		var me = this;
		UploaderLib.uploadFiles([file], _, function(id, ext, callback) {
			var fileObj = {
				id: id,
				ext: ext,
				name: arguments[3].name.match(regExt)[1]
			}
			me.updRecord(fileObj, 1);
			me.close();
			callback();
		}, undefined, isMain);
	},
	clearFile: Ext.emptyFn,
	mainFileExists: function(exist, noExist) {
		var me = this;
		me.fileExists(exist, noExist);
	},
	fileExists: function(exist, noExist) {
		var id = this.getFileId();
		(id && id !== '0' ? exist : noExist)();
	},
	btnClearHandler: function(exist, noExist) {
		this.fileExists(exist, noExist);
	},
	createItems: function() {
		var me = this,
			res = Ext.create('Ext.form.FieldContainer',
				{
					layout: {type: 'vbox', align: 'stretch'},
					padding: '3 3 0 3',
					items: [
						me.btnNew = Ext.create('Ext.Button', {
							text: 'Создать',
							iconCls: 'x_btn_new',
							cls: 'ks-button-image',
							hidden: me.btnsHide.new || !me.createFile,
							disabled: me.readOnly,
							handler: function() {
								const yesFunc = function() {
									me.hide();
									me.createFile(function(id, ext, name, descrLink, fileLink) {
										me.updRecord.apply(me, [{ id: id, ext: ext, name: name, descrLink: descrLink, fileLink: fileLink }, 1]);
										me.setIconCls(getExtStyle(ext));
										me.setEnableBtns();
									});
								};
								me.mainFileExists(function() {
									selectDialogShow(KS.L10n.attention, KS.L10n.rewrite_existing_file, yesFunc);
								}, yesFunc);
							}
						}),
						me.btnDocEdit = Ext.create('Ext.Button', {
							text: 'Документ',
							iconCls: 'x_btn_document',
							cls: 'ks-button-image',
							hidden: !me.docEdit,
							handler: function() {
								me.hide();
								me.docEdit();
							}
						}),
						me.btnSend = Ext.create('Ext.form.field.FileButton', {
							iconCls: 'x_btn_import',
							cls: 'ks-button-image',
							text: 'Выбрать',
							disabled: me.readOnly || me.disableBtnSend,
							hidden: me.btnsHide.send || !me.uploadFile,
							listeners: {
								change: function(th, e) {
									var files = e.target.files;
									me.uploadFile(files[0], 1);
								},
								afterrender: function(th) {
									UploaderLib.bind(th.el.dom, function(link, ext, callback) {
										me.updRecord({ id: link, ext: ext, name: arguments[3].name.match(regExt)[1] }, 0);
										me.close();
										callback();
									});
								},
								click: function(btn, e) {
									let noFunc = () => e.preventDefault(),
										yesFunc = function() {
											me.checkRewriteClick = false;
											me.btnSend.fileInputEl.dom.click();
										};
									
									if (me.checkRewriteFile) {
										if (me.checkRewriteClick) {
											me.fileExists(function () {
												selectDialogShow(KS.L10n.attention, KS.L10n.rewrite_existing_file, yesFunc, noFunc);
											}, yesFunc);
											e.preventDefault();
										} else {
											me.checkRewriteClick = true;
										}
									}
								}
							}
						}),
						me.btnOpen = Ext.create('Ext.Button', {
							text: 'Открыть',
							iconCls: 'x_btn_export',
							cls: 'ks-button-image',
							hidden: !me.downloadFile,
							handler: function() {
								me.downloadFile();
								me.hide();
							}
						}),
						me.btnOpenInEditor = Ext.create('Ext.Button', {
							text: 'Открыть в редакторе',
							iconCls: 'x_btn_export',
							cls: 'ks-button-image',
							hidden: true,
							disabled: me.readOnly,
							handler: function() {
								me.downloadFileForEditor();
							}
						}),
						me.btnClear = Ext.create('Ext.Button', {
							text: 'Очистить',
							iconCls: 'x_btn_clean',
							cls: 'ks-button-image',
							disabled: me.readOnly,
							hidden: me.btnsHide.clear || !me.clearFile,
							handler: function() {
								me.btnClearHandler(
									function() {
										selectDialogShow(KS.L10n.attention, me.deleteMessage, function() {
											me._clear();
										});
									},
									function() {
										me._clear();
									});
							}
						})
					]
			});

		me.setEnableBtns();
		return res;
	},
	_clear: function() {
		var me = this;
		me.setIconCls('');
		me.clearFile();
		me.setEnableBtns();
		me.close();
	},
	setEnableBtns: function() {
		var me = this;

		me.fileExists(function() {
			me.btnClear.setDisabled(me.readOnly);
			me.btnOpen.setDisabled(false);
			me.btnOpenInEditor.setDisabled(false);
		}, function() {
			me.btnClear.setDisabled(!me.docExists());
			me.btnOpen.setDisabled(true);
			me.btnOpenInEditor.setDisabled(true);
		});
	}
});