﻿Ext.define('Keysystems.File.List', {
	extend: 'Ext.grid.Panel',
	mixins: ['Keysystems.Base.Edit'],
	title: 'Файлы',	
	isWindow: true,
	flex: 1,
	f: 'edit',
	autoScroll: true,
	allowDeselect: false,
	autoRender: true,
	border: 0,
	bodyPadding: 0,
	columnLines: true,
	data: { data: {} },

	viewMinSize: [400, 350],

	fieldExt: 'EXTENTION',
	fieldMain: 'MAIN',
	ignoreCheckStamp: true,

	constructor: function(cfg){
		Ext.apply(this, cfg);
		this.data = { data: {} };
		this.callParent(arguments);
	},

	initComponent: function() {
		var me = this;

		me.beforeInitComponent();
		me.baseInitComponent();

		me.store = me.createStore();
		me.columns = me.getColumns();
		me.plugins = [
			Ext.create('Ext.grid.plugin.CellEditing', { clicksToEdit: 1 })
		];

		me.listeners = {
			selectionchange: (_, sels) => {
				me.enableTools(sels);
			}
		};
		me.tbar = me.createTBar();
		me.callParent(arguments);
		me.afterInitComponent();
	},

	enableTools: function(sels){
		const me = this;
		const sel = sels?.length ? sels[0] : null;
		const correctRow = sel?.get('FILES');
		const readOnly = me.getReadOnly();
		//для EDSSaveDocBehavior = 2 в вебе получается нет ограничений. потому как отредактировать в вебе просто нет возможности. можно только удалить и создать заново 
		const hasEDS = me.EDSSaveDocBehavior === 3 && sel?.get('TEMP_EDS_DATE');
		me.getToolbarItem('select')?.setDisabled(readOnly);
		me.getToolbarItem('delete')?.setDisabled(!correctRow ||readOnly|| hasEDS);
		me.getToolbarItem('journal')?.setDisabled(!window.user.isAdmin || !correctRow || !sel.get('LINK')); // !sels?.filter(r => r.get('FILES') && r.get('LINK')).length
		me.getToolbarItem('open')?.setDisabled(!correctRow);
		me.getToolbarItem('sign')?.setDisabled(!correctRow);
		me.subBtnSign?.setDisabled(readOnly || !correctRow || !sel.get('LINK'));
		me.subBtnUnSign?.setDisabled(readOnly || !correctRow || !sel.get('LINK'));
	},
	
	addFile: function(link, ext, callback, file) {
		var me = this,
			name = file.name.match(regExt)[1] || file.name,
			r = { NAME: name, DTCREATE: dbNow };

		r[me.fieldFile] = link;
		r[me.fieldMain] = 0;
		r[me.fieldExt] = ext;

		if (r) me.store.add(r);
		if (Ext.isFunction(me.afterAddFile)) me.afterAddFile(r);

		callback();
	},

	initEvents: function() {
		var me = this;
		me.callParent(arguments);
		if (!me.getReadOnly()) UploaderLib.bind(me.view.el.dom, me.addFile.bind(me), 1);
	},

	createTBar: function() {
		var me = this,
			res = [];
		res.push(me.setKsControl('btnAddFile', Ext.create('Keysystems.form.field.FileButtonMulti', {
				key: 'select',
				iconCls: 'x_btn_add',
				multiple: 1,
				tooltip: 'Выбрать',
				tooltipType: 'title',
				disabled: me.getReadOnly(),
				listeners: {
					change: function(th, e) { UploaderLib.uploadFiles(e.target.files, _, me.addFile.bind(me)); },
					afterrender: function(th) { if (!me.getReadOnly()) UploaderLib.bind(th.el.dom, me.addFile.bind(me), 1); }
				}
			})),
			Ext.create('Ext.Button', {
				key: 'open',
				iconCls: 'x_btn_export',
				tooltip: 'Открыть',
				tooltipType: 'title',
				handler: function() {
					const sel = me.getFrstSelect();
					if (!sel) return;
					
					me.downloadGridFile(sel, sel.get('NAME'));
				}
			}),
			me.setKsControl('btnDelFile', Ext.create('Ext.Button', {
				key: 'delete',
				iconCls: 'x_btn_delete',
				tooltip: 'Удалить',
				tooltipType: 'title',
				handler: function() { 
					me.removeSelection(null, function() { me.editingPlugin.cancelEdit(); }); 
				}
            })),

			Ext.create('Ext.Button', {
				disabled: true,
				hidden: !window.useEDS,
				key: 'sign',
				iconCls: 'x_btn_document_protect',
				menu: [
					{
						text: 'Электронная подпись',
						iconCls: 'x_btn_document_protect',
						handler: function () {
							const sel = me.getFrstSelect();
							if (!sel) return;

							const serviceModule = Ext.create('Keysystems.EDSServiceModule', {
								target: me.getLoadMaskTarget(),
								code: "FILES",
								links: [sel.data.LINK],
								code_eds_list: "FILES_EDS_LIST",
								mode: 'SIGN_LIST',
								modal: window.modalEdit || me.parentView !== window.tabView
							});
							serviceModule.execute();
						}
					},
					{
						text: 'Печать информации об ЭЦП',
						iconCls: 'x_btn_protocol',
						handler: function () {
							let sel = me.getFrstSelect();
							if (!sel) return;

							const link = sel.data.LINK;
							const serviceModule = Ext.create('Keysystems.EDSServiceModule', {
								target: me.getLoadMaskTarget(),
								code: "FILES",
								links: [link],
								mode: 'SIGNATURE_INFO_PROTOCOL'
							});
							serviceModule.execute();
						}
					},
					{ xtype: 'menuseparator', hidden: true },
					me.subBtnSign = Ext.create('Ext.Action', {
						text: 'Подписать',
						iconCls: 'x_btn_sign',
						handler: async function () {
							let sel = me.getFrstSelect();
							if (!sel) return;

							const link = sel.data.LINK;
							const serviceModule = Ext.create('Keysystems.EDSServiceModule', {
								target: me.getLoadMaskTarget(),
								code: "FILES",
								links: [link],
								mode: 'EDS_SET',
							});
							const result = await serviceModule.executeAsync();
							if (result) me.onSignCompleted(sel, result);
						}
					}),
					me.subBtnUnSign = Ext.create('Ext.Action', {
						text: 'Снять подпись',
						iconCls: 'x_btn_delete_sign',
						handler: async function () {
							let res = await selectDialogShowAsync(KS.L10n.attention, KS.L10n.ListTasks_UnSign_Снять_ЭП, 'no');
							if (res !== "yes") return;
							
							let sel = me.getFrstSelect();
							if (!sel) return;

							const link = sel.data.LINK;
							const serviceModule = Ext.create('Keysystems.EDSServiceModule', {
								target: me.getLoadMaskTarget(),
								code: "FILES",
								links: [link],
								mode: 'EDS_DELETE',
							});
							const result = await serviceModule.executeAsync();
							if (result) me.onSignCompleted(sel, result);
						}
					})
				]
			}),
            
            Ext.create('Ext.Button', {
	            key: 'journal',
                iconCls: 'x_btn_journal',
                tooltip: 'Журнал событий',
                tooltipType: 'title',
                handler: function () {
	                const sel = me.getFrstSelect();
	                if (!sel) return;

	                const loadMask = new Ext.LoadMask({
		                msg: KS.L10n.loading_data,
		                view: me,
		                rid: ajaxRequest({
			                params: {
				                code: 'FILES',
				                links: [sel.data[me.fieldLink]]
			                },
			                url: 'data/DetailEventsLog_A',
			                success: function (html) {
				                showDetailEventsLog({
					                html: html,
					                modal: true,
					                title: me.title
				                });
			                },
			                callback: () => loadMask.destroy()
		                })
	                });
	                loadMask.show();
                }
            })
        );
		return res;
	},

	/**
	 * Выполнить после подписи единичного файла
	 * @param sel строка грида с файлом
	 * @param result данные подписи с сервера
	 */
	onSignCompleted: function(sel, result){
		const me = this;
		if (result && result.rows?.length){
			sel.set('TEMP_EDS_DATE', result.rows[0].EDS_DATE);
			sel.set('TEMP_EDS_CNS', result.rows[0].EDS_CNS);
			me.enableTools([sel]);
			if (me.afterSignCompleted != null) me.afterSignCompleted(sel);
		}
	},

	/**
	 * Выполнить после подписи всех файлов в списке
	 * @param data
	 */
	onSignAllCompleted: function(data) {
		const me = this;
		data.forEach(rowUpd => {
			const rec = me.store.findRecord('LINK', rowUpd.LINK);
			if (rec) {
				rec.set('TEMP_EDS_DATE', rowUpd.EDS_DATE);
				rec.set('TEMP_EDS_CNS', rowUpd.EDS_CNS);
				me.view.refresh();
			}
		})
	},

	createStore: function() {
		const me = this;
		return me.setKsControl('store', Ext.create('Ext.data.Store', {
			fields: ['LINK', me.fieldMain, 'NAME', 'DTCREATE', 'FILES', me.fieldExt, "TEMP_EDS_DATE", "TEMP_EDS_CNS"],
			data: [],
			proxy: 'memory'
		}));
	},

	getColumns: function() {
		var me = this;
		return me.gridColumns || (me.gridColumns = [
			{
				text: 'Наименование',
				dataIndex: 'NAME',
				flex: 1
			},
			{
				text: 'Дата добавления',
				dataIndex: 'DTCREATE',
				xtype: 'datecolumn',
				format: 'd.m.Y',
				width: 120
			},
			{
				xtype: 'actioncolumn',
				text: 'Файл',
				dataIndex: me.fieldFile,
				width: 50,
				align: 'center',
				items: [
					{
						getClass: function (v, meta, rec) { return getExtStyle(rec.get(me.fieldExt)); },
						handler: function (grid, rowIndex) { me.fileGridEdit(grid.getStore().getAt(rowIndex)); }
					}
				],
			},
			{
				text: 'Дата ЭП',
				dataIndex: 'TEMP_EDS_DATE',
				hidden: !window.useEDS,
				xtype: 'datecolumn',
				format: 'd.m.Y',
				width: 120
			},
			{
				text: 'Владельцы ЭП',
				dataIndex: 'TEMP_EDS_CNS',
				hidden: !window.useEDS,
				width: 120
			},
			
		]);
	},

	fileGridEdit: function(rec, readOnly) {
		let me = this;
		const hasEDS = me.EDSSaveDocBehavior === 3 && rec.get('TEMP_EDS_DATE');
		Ext.create('Keysystems.File', {
			readOnly: me.readOnly || me.ksReadOnly || readOnly || hasEDS,
			iconCls: getExtStyle(rec.get(me.fieldExt)),
			createFile: null,
			updRecord: (fileObj) => me.updGridFileRecord(fileObj, rec),
			getFileId: () => rec.get(me.fieldFile),
			downloadFile: () => me.downloadGridFile(rec, rec.get('NAME')),
			clearFile: () => me.clearGridFile(rec)
		});
	},

	downloadFile: function(link, name) { UploaderLib.getFile(link, name); },

	getWindowCfg: function() {
		var res = this.callParent(arguments);
		res.iconCls = 'x_btn_folder_open';
		return res;
	},

	dataCollector: function() { return this.store.getDataExt(); },

	getExtra: function(callBack) {
		var me = this;

		me.baseGetExtra(_, function(value) {
			me.store.loadData(value);
			if (value.length) {
				me.getSelectionModel().deselectAll();
				me.extraSelectFrst();
			}
			else
				me.enableTools();
			if (callBack) callBack();
		});
	},

	isFilled: Ext.trueFn,

	baseGetExtra: function(p, callBack) { throw new Error(wmc.get('NeedOverride')); },

	afterGetExtra: function() {
		this.ownerCt.afterGetExtra.call(this.ownerCt);
	},
	showLoadMask: function(cfg) {
		this.ownerCt.showLoadMask.call(this.ownerCt, cfg);
	},
	hideLoadMask: function() {
		this.ownerCt.hideLoadMask.call(this.ownerCt);
	},
	setKsReadOnly: function(v) {
		//весь грид не дизейблим, работаем по флагу readOnly
		const me = this;
		me.readOnly = v;
		me.enableTools(this.getSelectionModel().getSelection());
	},
});