﻿Ext.define('Keysystems.FactNar.List.Tree', {
	extend: 'Keysystems.Base.List.Tree',
	startYear: (new Date()).getFullYear(),
	bodyPadding: 10,
	labelWidth: 150,
	viewCfg: function() {
		var me = this,
			cfg = me.callParent(arguments);

		cfg.layout = { type: 'vbox', align: 'stretch' };
		cfg.iconCls = me.head ? 'x_btn_document_error' : _;		
		return cfg;
	},
	profileListeners: [
		{ name: 'holdingPeriod', method: 'KsPeriodChange' },
		{ name: 'checkingPeriod', method: 'KsPeriodChange' },
		{ name: 'S_VBUDJ', method: 'ksDictChange' },
		{ name: 'S_NAR', method: 'ksDictChange' },
		{ name: 'footerPanel', method: 'resizeH_expandCollapse' },
	],
	setWhereArgs: function() {
		let me = this,
			objs = me.objs,	
			sVbudj = objs.S_VBUDJ.getLinks(),
			sNar = objs.S_NAR.getLinks(),
			dRev = me.objs.holdingPeriod.getValue(),
			dMoney = me.objs.checkingPeriod.getValue();
				
		if (me.isDis && sNar === _ && me.disLinks.length){
			sNar = me.disLinks;
			me.objs.S_NAR.setValue(me.disVal);
		}

		let whereArgs = {
				DBegin: {
					value: dRev.dh1,
					type: 'Date'
				},
				DEnd: {
					value: dRev.dh2,
					type: 'Date'
				},
				DBeginMoney: {
					value: dMoney.dh1,
					type: 'Date'
				},
				DEndMoney: {
					value: dMoney.dh2,
					type: 'Date'
				},
				SVBudjs: {
					value: sVbudj ? JSON.stringify(sVbudj) : JSON.stringify([]),
					type: 'List_int'
				},
				SNars: {
					value: sNar ? JSON.stringify(sNar) : JSON.stringify([]),
					type: 'List_int'
				}
			};

		if (me.isVfa)
			whereArgs.SWorks = {
				value: JSON.stringify(me.SWorks || []),
				type: 'List_int'
			};

		me.afterSetWhereArgs && me.afterSetWhereArgs(whereArgs);

		return Ext.apply(me.whereArgs, whereArgs);
	},
	

	createItems: function() {
		var me = this,
			objs = me.objs,
			items = me.callParent(arguments);

		me.isCreate = true;
		items.unshift(objs.filterPanel = Ext.create('Ext.panel.Panel', {
			layout: { type: 'vbox', align: 'stretch' },
			bodyPadding: !me.hideBottomPanel ? me.bodyPadding : ( me.bodyPadding + ' ' + me.bodyPadding + ' 0 ' + me.bodyPadding),
			border: 0,
			bodyBorder: 0,
			collapsible: !me.hideBottomPanel,
			userCls: 'rks-filter-panel',
			header: {
				title: 'Фильтр по Нарушениям',
				hidden: me.hideBottomPanel,
			},
			animCollapse: false,
			items: [
				objs.dtContainer = Ext.create('Ext.form.FieldContainer', {
					layout: { type: 'hbox', align: 'stretch' },
					items: [
						objs.holdingPeriod = Ext.create('Keysystems.Controls.KsPeriod', {
							startYear: me.startYear,
							state: 4,
							allStates: 12,
							width: 400,
							listeners: {
								ksChange: function() {
									if (me.isLoading) return;
									me.setDate();
								}
							}
						}),
						objs.S_VBUDJ = Ext.create('Keysystems.Controls.Dict.Edit', {
							fieldLabel: 'Виды средств',
							labelWidth: me.labelWidth,
							padding: '0 10 0 10',
							flex: 1,
							mode: 'MULTI',
							clear: function() {
								this._setValue();
								me.refresh();
							},
							_setValue: function(value) {
								if (me.isLoading) return;
								this.setValue(value);
								me.setWhereArgs();
							},
							handler: function() {
								dictFunc({
									mode: 'MULTI',
									parentView: objs.view,
									selectLinks: objs.S_VBUDJ.getValue(),
									code: dnl.S_VBUDJ,
									control: objs.S_VBUDJ,
									contextSearch: objs.S_VBUDJ.contextSearch
								}, {
									ok: function(value) {
										objs.S_VBUDJ._setValue(value);
										me.refresh();
									}
								});
							}
						})
					]
				}),
				objs.moneyContainer = Ext.create('Ext.form.FieldContainer', {
					layout: { type: 'hbox', align: 'stretch' },
					items: [
						objs.checkingPeriod = Ext.create('Keysystems.Controls.KsPeriod', {
							startYear: me.startYear,
							allStates: 12,
							width: 400,
							fieldLabel: 'Проверяемый период',
							listeners: {
								ksChange: function() {
									if (me.isLoading) return;
									me.setDate();
								}
							}
						})
					]
				})
			]
		}));
		items.push(objs.footerSplitter = Ext.create('Ext.resizer.Splitter'));
		items.push(objs.footerPanel = Ext.create('Ext.panel.Panel', {
			collapsible: true,
			collapseDirection: 'bottom',
			bodyPadding: me.bodyPadding,
			border: 0,
			header:{
				title: 'Характер и обстоятельства нарушения',
				border: 0
			},
			userCls: 'rks-filter-panel',
			layout: { type: 'vbox', align: 'stretch' },
			hidden: me.hideBottomPanel,
			items: [
				objs.NOTE = Ext.create('Ext.form.field.TextArea', {
					flex: 1,
					readOnly: true
				})
			]
		}));

		objs.S_NAR = Ext.create('Keysystems.Controls.Dict.Edit', {
			fieldLabel: 'Виды нарушений',
			labelWidth: me.labelWidth,
			padding: '0 10 0 10',
			flex: 1,
			mode: 'MULTI',
			clear: function() {
				this._setValue();
				me.refresh();
			},
			_setValue: function(value) {
				if (me.isLoading) return;
				this.setValue(value);
				me.setWhereArgs(objs.checkingPeriod.getYear(), objs.Quarter.getValue(), objs.S_VBUDJ.getLinks(), objs.S_NAR.getLinks());
			},
			handler: function() {
				dictFunc({
					mode: 'MULTI',
					parentView: objs.view,
					selectLinks: objs.S_NAR.getValue(),
					code: dnl.S_NAR,
					control: objs.S_NAR,
					contextSearch: objs.S_NAR.contextSearch,
					initWhereArgs: function() {
						var wa = {};

						if (me.isDis) {
							wa.InLinksOnly = { value: true, type: 'bool' };
							wa.InLinks = { value: JSON.stringify(me.disLinks), type: 'List_int' };
						}
						return wa;
					}
				}, {
					ok: function(value) {
						objs.S_NAR._setValue(value);
						me.refresh();
					}
				});
			}
		});

		objs.Grid.on('selectionchange', function(th, sels) { objs.NOTE.setValue(sels.length ? sels[0].data.CONTENT : _); });

		if (me.hideFilterPanel)
			objs.filterPanel.hide();
		
		if (me.hideBottomPanel) {
			objs.footerSplitter.hide();
			objs.footerPanel.hide();
		}

		objs.Year = objs.holdingPeriod.Quarter.holdingYear;
		objs.Quarter = objs.holdingPeriod.Quarter.holdingQuarter;
		
		me.isCreate = false;

		return objs.items;
	},
	setDate: function() {
		var me = this,
			objs = me.objs;

		me.setWhereArgs(objs.checkingPeriod.getYear(), objs.Quarter.getValue(), objs.S_VBUDJ.getLinks(), objs.S_NAR.getLinks());
		me.refresh();
	},
	getGridCfg: function(){
		let res = this.callParent(arguments);
		res.userCls = 'rks-grid-with-filter-panel';
		return res;
	},
	/** Task 'Revizor.Reviz.AlienEdit'
	 */
	doEditReviz: function() {
		let me = this,
			rec = me.Grid.getFrstSelect();
		if (!rec) return;

		const modalEdit = me.isModalEdit();
		let cfg = {
				f: 'edit',
				data: { data: { LINK: rec.data.REVIZ } },
				code: dnl.REVIZ,
				refreshFunc: function() { me.refresh(); },
				tabMode: !modalEdit,
				parentView: modalEdit ? me.objs.view : me.parentView
			};
		Ext.apply(cfg, dictListController.DOCUMENT_REVIZ);

		Ext.create(cfg.editClass, cfg);
	},
	loadData: function(data) {
		var me = this,
			grid = me.Grid;

		var tmpColumns = me.columnsAdapted(data.columns),
			pos = ArrayLib.find(tmpColumns, ['dataIndex'], 'M');

		data.columns = tmpColumns;
		tmpColumns.splice(pos, 1);
		grid.reconfigure(grid.store, tmpColumns);
		grid.store.setFields(me.fieldsAdapted(data.fields));

		if (grid.store.model.prototype.isNode) {
			delete grid.store.model.prototype.isNode;
		}

		grid.setRootNode({ expanded: true, children: data.data });
		return me;
	},
	baseGetData: function (endFunc, params) {
		var me = this;
		me.callParent([
			function (data) {
				var objs = me.objs; 
				objs.S_VBUDJ.setVisible(!data.data.hideSumNar);
				objs.moneyContainer.setVisible(!data.data.hideMoneyPeriod);

				if (data.data.hideSumNar) {
					objs.dtContainer.items.add(objs.S_NAR);
				} else {
					objs.moneyContainer.items.add(objs.S_NAR);
				}
				
				me.canCreateChildFactnar = data.data.canCreateChildFactnar; 
				
				if (endFunc) endFunc(data);
			}, params
		]);
	},

	beforeSetData: function(data, p) {
		const me = this;
		data.fields
			.filter(f => ['NUMBER', 'DELO', 'PPLAN'].indexOf(f.name) >= 0)
			.forEach(f => f.sortType = 'asNatural');

		me.callParent(arguments);
	},

	columnsAdapted: function(columns) {
		const me = this;
		const cols = me.callParent(arguments);
		if (!me.canCreateChildFactnar) {
			const idx = ArrayLib.find(cols, ['dataIndex'], 'tree');
			if (idx >= 0) {
				cols.splice(idx, 1);
				window.addRowNumbererClm(me.Grid, cols);
			}
		}
		return cols;
	}	
});