﻿Ext.define('Keysystems.FactNar.Edit', {
	extend: 'Keysystems.Base.Edit',
	config: {
		f: 'new', // 'new'/'copy'/'edit'
		data: undefined,
		refreshFunc: undefined,
		parentView: undefined,
		code: 'DOCUMENT_FACTNAR',
		DT: {},
		DTMONEY: {},
		inputDicts: [],
		okFunc: undefined,
		access: []
	},
	sRprogLinks: [],
	sPersonLinks: [],
	content: [],
	progData: [],
	recommendation: [],
	tRevizObjects: {},
	lockAudit: [],
	tRevizAudit: [],
	readOnlyList: ['AREA', 'UNITCOMBO'],
	_arrGeneralRow: ['SUMMA', 'DTDETECT', 'CONTENT', 'RECOMMENDATION', 'DTNAR', 'REPAYMENT', 'ORD', 'IGNORE_ACT', 'ACT_NUMBER', 'ACT_PAGE', 'ORD2'],
	_arrGeneralSingl: ['S_RPROG', 'S_NAR', 'S_PERSONP', 'T_REVIZ_OBJECTS', 'S_PERSONC', 'S_AUTHORITY'],
	_arrGeneralMulti: ['S_NPA_NAR', 'S_NPA_OTV', 'S_NPA_EXT', 'S_NARP', 'S_NARC'],
	bodyPadding: 0,
	viewMinSize: [700, 550],
	profileListeners: [{ name: 'view', method: 'FormParam' }],

	tSNarSNpaLink: -1,
	
	constructor: function(cfg){
		Ext.apply(this, cfg);
		this.callParent(arguments);
	},
	viewCfg: function() {
		var me = this,
			result = me.callParent(arguments);
		result.maximizable = true;
		result.resizable = true;
		result.bbar = [
			me.sksc('S_STATUS', Ext.create('Keysystems.Controls.ComboBoxExtra', {
				fieldLabel: 'Статус',
				editable: false,
				queryMode: 'local',
				value: 0,
				labelWidth: 50,
				displayField: CBDataLib.displayField,
				valueField: CBDataLib.valueField,
				padding: 5,
				listeners: {
					change: function(th, newValue) {
						var ro = me.readOnly;

						me.setReadOnly(me.gksd('readOnlyStatuses').indexOf(newValue) !== -1); //todo readOnly только у статусов с запретом редактирования
						me.readOnly = ro;

						me.gksc('saveBtn')?.setKsReadOnly(false);
						this.setKsReadOnly(false);
					}
				},
				setKsReadOnly: function() {
					var res = this.callParent(arguments);
					this.setDisabled(this.store.count() < 2);
					return res;
				},
				store: Ext.create('Ext.data.Store', {
					fields: CBDataLib.getFields(),
					data: [],
					proxy: 'memory'
				})
			}))
		];

		return result;
	},

	createItems: function() {
		var me = this;
		return me.objs.allTab = Ext.create('Ext.tab.Panel', {
			plain: true,
			border: 0,
			flex: 1,
			userCls: me.basePanelCls,
			bodyCls: me.basePanelBodyCls,
			items: me.objs.items = [me.getTab('General')]
		})
	},

	//конструктор таба Общие
	createTabGeneral: function() {
		var me = this,
			units = Ext.create('Ext.data.Store', { fields: ['val', 'name'],
				data: [{ "val": 1, "name": "Квадратный метр" }, { "val": 2, "name": "Гектар" }] }),
			objs = me.objs;

		me._arrGeneralRow.forEach(function(el) { me.readOnlyList.push(el) });
		me._arrGeneralSingl.forEach(function(el) { me.readOnlyList.push(el) });
		me._arrGeneralMulti.forEach(function(el) { me.readOnlyList.push(el) });

		return objs.tabGeneral = Ext.create('Ext.panel.Panel', {
			title: 'Общие',
			layout: { type: 'vbox', align: 'stretch' },
			bodyPadding: 10,
			flex: 1,
			border: 0,
			items: [
				me.createDictEdit({
					key: 'S_AUTHORITY',
					mode: 'SINGL',
					fieldLabel: 'Полномочие',
					code: dnl.S_AUTHORITY,
					beforeclear: function() {
						this.callParent(arguments);
					},
					initWhereArgs: function() {
						var whereArgs = {};

						whereArgs.DH1 = {
							value: me.DT.dh1.toDateString(),
							type: 'Date'
						};
						whereArgs.DH2 = {
							value: me.DT.dh2.toDateString(),
							type: 'Date'
						};

						if (me.sAuthorityLinks.length !== 0) {
							whereArgs.InLinks = {
								value: JSON.stringify(me.sAuthorityLinks || []),
								type: 'List_int'
							};
							whereArgs.InLinksOnly = {
								value: 'True',
								type: 'bool'
							};
						}

						return whereArgs;
					}
				}),
				me.createDictEdit({
					key: 'S_RPROG',
					mode: 'SINGL',
					fieldLabel: 'Вопрос программы',
					code: dnl.S_RPROG,
					initWhereArgs: function() {
						return {
							InLinks: {
								value: JSON.stringify(me.sRprogLinks || []),
								type: 'List_int'
							},
							InLinksOnly: {
								value: 'True',
								type: 'bool'
							}
						};
					},
					ksSetValue: function (value) {
						if (value && value.length && !objs.S_PERSONP.getLink()) {
							value = value[0];
							let rowTRP = me.progData.filter(r => r['S_RPROG'] === value.LINK &&
								r['T_REVIZ_OBJECTS'] === objs.T_REVIZ_OBJECTS.getLink());
							rowTRP = rowTRP.length ? rowTRP[0] : null;

							if (rowTRP) {
								var persons = ArrayLib.filter(me.progPerson, ['T_REVIZ_SRPROG'], rowTRP.LINK);

								if (persons && persons.length) {
									var persPos = ArrayLib.find(me.personData, ['S_PERSON'], persons[0].S_PERSON);
									if (persPos !== -1) {
										const fio = me.personData[persPos].TEMP_SPERSON_FIO?.split(' ') ?? [];
										objs.S_PERSONP.setValue({
											data: {
												LINK: me.personData[persPos].S_PERSON,
												CODE: me.personData[persPos].TEMP_SPERSON_CODE,
												NAME: me.personData[persPos].TEMP_SPERSON_FIO,
												LASTNAME: fio.length > 0 ? fio[0] : null,
												FIRSTNAME: fio.length > 1 ? fio[1] : null,
												PATRONYMIC: fio.length > 2 ? fio[2] : null												
											}
										});
									}
								}
							}
						}

						objs.S_RPROG.setValue(value);
					}
				}),
				me.createDictEdit({
					key: 'S_NAR',
					mode: 'SINGL',
					fieldLabel: 'Вид нарушения',
					code: dnl.S_NAR,
					beforeclear: function() {
						objs.S_NPA_NAR._clear();
						objs.S_NPA_NAR.setDisabled(me.limitNpa);
						objs.S_NPA_OTV._clear();
						objs.S_NPA_OTV.setDisabled(me.limitNpaOtv);
						this.callParent(arguments);
					},
					initWhereArgs: function() {
						var whereArgs = me.gksd('narWhereArgs') || {},
							inLinks = me.filterSNar && me.filterSNar.length ? me.filterSNar : [],
							len = inLinks.length,
							disLinks = me.gksd('disLinks') ?? [];

						whereArgs.DH1 = {
							value: me.DT.dh1.toDateString(),
							type: 'Date'
						};
						whereArgs.DH2 = {
							value: me.DT.dh2.toDateString(),
							type: 'Date'
						};
						
						if (me.isDis) {
							inLinks = inLinks.length ? inLinks.filter(function(l) { return disLinks.indexOf(l) !== -1; }) : disLinks;
						} else {
							whereArgs.NotInLinks = {
								value: JSON.stringify(disLinks),
								type: 'List_int'
							};
						}
						
						if (inLinks.length || len) {
							whereArgs.InLinksOnly = {
								value: true,
								type: 'bool'
							};
							whereArgs.InLinks = {
								value: JSON.stringify(inLinks),
								type: 'List_int'
							};
						}

						if (me.sWork) whereArgs.SWork = { value: me.sWork, type: 'int' };

						return whereArgs;
					},
					ksSetValue: function(value) {
						var v = value && value.length ? value[0] : value,
							link = v && (v.data ?? v).LINK;

						objs.S_NAR.setValue(value);

						// при открытии на редактирование не нужно GetSNarExtra вызывать
						if (!me.isLoaded && link) me.getSNarPC(link);

						objs.S_NPA_NAR.setDisabled(!v && me.limitNpa);
						objs.S_NPA_NAR.setValue([]);
						const articleNarListData = me.gksd('articleNarListData');
						if (!me.isLoaded && articleNarListData?.data) {
							articleNarListData.data = [];
							articleNarListData.checkedLinks = [];
						}

						objs.S_NPA_OTV.setDisabled(!v && me.limitNpaOtv);
						objs.S_NPA_OTV.setValue([]);
						var articleListData = me.gksd('articleListData');
						if (!me.isLoaded && articleListData && articleListData.data) {
							articleListData.data = [];
							articleListData.checkedLinks = [];
						}
					}
				}),
				me.createDictEdit({
					key: 'S_NPA_NAR',
					fieldLabel: 'НПА (наруш.)',
					code: dnl.S_NPA,
					disabled: true,
					controlName: 'sNarListFromFactNar',
					accessReadOnly: true,
					initWhereArgs: function () {
						const wa = { };
						if (me.limitNpa) wa.SNar = { value: objs.S_NAR.getLink(), type: 'int' };
						return wa;
					},
					listCfg: {
						useArticleGrid: true,
						articleMode: 'MULTI',
						multiSelectGridVisible: false,
						isItemDblClick: false,
						getArticleListData: function () { return me.gksd('articleNarListData'); }
					},
					_clear: function () {
						this.callParent(arguments);
						var articleListData = me.gksd('articleNarListData');
						if (articleListData) {
							articleListData.data = [];
							articleListData.checkedLinks = [];
						}
					},
					btnsHide: {
						exit: true
					},
					getNameLabelText: function (v) {
						if (!v || !v.length) return '';
						let articleData = me.gksd('articleNarListData');
						articleData = articleData?.data.filter(ra => articleData.checkedLinks.indexOf(ra.LINK) >= 0) ?? [];
						return me.getNPANameLabelText(v, articleData);
					}
				}),
				me.createDictEdit({
					key: 'S_NPA_OTV',
					fieldLabel: 'НПА (ответств.)',
					code: dnl.S_NPA,
					disabled: true,
					accessReadOnly: true,
					initWhereArgs: function () {
						var wa = { OtvOrNar: { value: 'True', type: 'bool' } };
						if (me.limitNpaOtv) wa.SNar = { value: objs.S_NAR.getLink(), type: 'int' };
						return wa;
					},
					listCfg: {
						useArticleGrid: true,
						multiSelectGridVisible: false,
						isItemDblClick: false,
						getArticleListData: function () { return me.gksd('articleListData'); }
					},
					_clear: function () {
						this.callParent(arguments);
						var articleListData = me.gksd('articleListData');
						articleListData.data = [];
						articleListData.checkedLinks = [];
					},
					btnsHide: {
						exit: true
					},
					getNameLabelText: function (v) {
						if (!v || !v.length) return '';
						let articleData = me.gksd('articleListData');
						articleData = articleData?.data.filter(ra => articleData.checkedLinks.indexOf(ra.LINK) >= 0) ?? [];
						return me.getNPANameLabelText(v, articleData);
					}
				}),
				me.createDictEdit({
					key: 'S_NPA_EXT',
					fieldLabel: 'НПА (доп.)',
					code: dnl.S_NPA,
					initWhereArgs: function() {
						let wa = {
							MainNPALinkForExt: {value: me.gksd('mainNPALinkForExt'), type: 'int' }
						};
						
						if (me.gksd('limitNpaExt')) {
							let objVal = objs.T_REVIZ_OBJECTS.getValue();
							if (objVal.length && objVal[0].TTABLE === "S_ORG") {
								wa.SOrg = {value: objVal[0].TLINK, type: 'int' }
							}
						}
						
						return wa;
					},
					listCfg: {
						useArticleGrid: true,
						multiSelectGridVisible: false,
						isItemDblClick: false,
						articleMode: 'MULTI',
						getArticleListData: function () { return me.gksd('extArticleListData'); }
					},
					_clear: function () {
						this.callParent(arguments);
						var extArticleListData = me.gksd('extArticleListData');
						extArticleListData.data = [];
						extArticleListData.checkedLinks = [];
					},
					btnsHide: {
						exit: true
					},
					getNameLabelText: function (v) {
						if (!v || !v.length) return '';
						let articleData = me.gksd('extArticleListData');
						articleData = articleData?.data.filter(ra => articleData.checkedLinks.indexOf(ra.LINK) >= 0) ?? [];
						return me.getNPANameLabelText(v, articleData);
					}
				}),
				me.createDictEdit({
					key: 'S_NARP',
					readOnly: true,
					initWhereArgs: function() {
						return {
							InLinks: {
								value: JSON.stringify(objs.S_NARP.getLinks()),
								type: 'List_int'
							},
							InLinksOnly: {
								value: 'True',
								type: 'bool'
							}
						};
					},
					cleaningKey: false,
					code: dnl.S_NAR,
					fieldLabel: 'Предшествующие',
					getRowClass: function(rec) { return me.getRowClass(rec, objs.S_NARC.getValue()); },
					checkListeners: { beforecheckchange: function(th, inx, check, rec) { return !rec.readOnly; } },
					checkRenderer: function(val, meta, rec) { if (rec.readOnly) meta.tdCls += ' ' + this.disabledCls; },
					className: 'Keysystems.Controls.DictName.Edit'
				}),
				me.createDictEdit({
					key: 'S_NARC',
					initWhereArgs: function() {
						return {
							InLinks: {
								value: JSON.stringify(objs.S_NARC.getLinks()),
								type: 'List_int'
							},
							InLinksOnly: {
								value: 'True',
								type: 'bool'
							}
						};
					},
					cleaningKey: false,
					readOnly: true,
					code: dnl.S_NAR,
					fieldLabel: 'Последующие',
					getRowClass: function(rec) { return me.getRowClass(rec, objs.S_NARP.getValue()); },
					checkListeners: { beforecheckchange: function(th, inx, check, rec) { return !rec.readOnly; } },
					checkRenderer: function(val, meta, rec) { if (rec.readOnly) meta.tdCls += ' ' + this.disabledCls; },
					className: 'Keysystems.Controls.DictName.Edit'
				}),
				objs.SUMMA = Ext.create('Keysystems.Controls.CalcField', {
					labelWidth: me.labelWidth,
					maxWidth: 285
				}),
				me.createDictEdit({
					key: 'S_PERSONP',
					mode: 'SINGL',
					initWhereArgs: function() {
						return {
							InLinks: {
								value: JSON.stringify(me.sPersonLinks),
								type: 'List_int'
							},
							InLinksOnly: {
								value: 'True',
								type: 'bool'
							},
							HasFilterOnLoad: {
								value: 'False',
								type: 'bool'
							}
						};
					},
					code: dnl.S_PERSON,
					fieldLabel: 'Выявил'
				}),
				objs.DTDETECT = Ext.create('Ext.form.field.Date', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Дата выявления',
					maxWidth: 285
				}),
				objs.CONTENT = Ext.create('Keysystems.form.field.TextAreaComboBox', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Характер',
					store: me.content || [],
					height: 100
				}),
				objs.RECOMMENDATION = Ext.create('Keysystems.form.field.TextAreaComboBox', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Выводы/рекомендации',
					store: me.recommendation || [],
					height: 100
				}),
				me.createDictEdit({
					key: 'T_REVIZ_OBJECTS',
					fieldLabel: 'Объект',
					className: 'Keysystems.Controls.DictName.Edit',
					ksAllowEmpty: true,
					nameField: 'TEMP_NAME',
					cleaningKey: false,
					handler: function() {
						Ext.create('Keysystems.Base.List', {
							parentView: objs.view,
							selectLinks: objs.T_REVIZ_OBJECTS.getValue(),
							mode: 'SINGL',
							title: 'Объекты контроля',
							pageSize: 10000,
							hidePagging: true,
							mainColumn: true,
							mainColumnEditable: false,
							readOnly: me.readOnly,
							functions: {
								getData: function(endFunc) {
									var d = me.tRevizObjects.data; //ArrayLib.filter(me.tRevizObjects.data, ['LINK_SELF'], null);
									endFunc({
										columns: me.tRevizObjects.columns,
										fields: me.tRevizObjects.fields,
										data: {
											data: d,
											total: d.length
										}
									});
								},
								refresh: function(endFunc) {
									var d = me.tRevizObjects.data; //ArrayLib.filter(me.tRevizObjects.data, ['LINK_SELF'], null);
									endFunc({ data: d, total: d.length });
								},
								ok: function(rec) {
									if (!rec.length) rec.push(me.tRevizObjects.data[0]);
									var d = rec[0].data || rec[0];
									d.TEMP_NAME = d.TEMP_NAME || d.TEMP_SNAME || d.TEMP_CODE;
									objs.T_REVIZ_OBJECTS.ksSetValue(d);
								}
							}
						});
					},
					ksSetValue: function(v) {
						objs.T_REVIZ_OBJECTS.setValue(v);
						objs.S_PERSONC.setValue([]);
						objs.S_PERSONC.setDisabled(!v);
						me.setFilterNar({});
					}
				}),
				me.createDictEdit({
					key: 'S_PERSONC',
					fieldLabel: 'Нарушил',
					code: dnl.S_PERSON,
					handler: function() {
						var ro = objs.T_REVIZ_OBJECTS.getValue(),
							whereArgs = {
								HasFilterOnLoad: {
									value: 'False',
									type: 'bool'
								}
							},
							table = ro[0].data ? ro[0].data.TTABLE : ro[0].TTABLE,
							tlink = ro[0].data ? ro[0].data.TLINK : ro[0].TLINK;

						switch (table) {
						case 'S_PERSON':
							whereArgs.InLinks = {
								value: JSON.stringify([tlink]),
								type: 'List_int'
							};
							break;
						case 'S_OTDEL':
							whereArgs.SOtdel = {
								value: JSON.stringify([tlink]),
								type: 'List_int'
							};
							break;
						default:
							whereArgs.SOrgs = {
								value: JSON.stringify([tlink]),
								type: 'List_int'
							};
							if ((ro[0].data ? ro[0].data.TYPE : ro[0].TYPE) === 4) {
								var iPos = ArrayLib.find(me.tRevizObjects.data, ['LINK_SELF'], ro[0].data ? ro[0].data.LINK : ro[0].LINK);
								if (iPos !== -1 && me.tRevizObjects.data[iPos].TTABLE === 'S_PERSON') {
									var val = me.tRevizObjects.data[iPos];
									whereArgs.InLinks = {
										value: JSON.stringify([val.TLINK]),
										type: 'List_int'
									};
								}
							}
							break;
						}

						ro = KsLib.objCopy(ro);
						Ext.each(ro, function(revObj) {
							revObj.CODE = revObj.TEMP_CODE;
							revObj.NAME = revObj.TEMP_NAME;
							revObj.LINK = revObj.TLINK;
						});

						dictFunc({
							mode: 'SINGL',
							parentView: objs.view,
							selectLinks: objs.S_PERSONC.getValue(),
							whereArgs: whereArgs,
							code: dnl.S_PERSON,
							inputDicts: [Ext.create('InputEditDict', { name: 'S_ORG', data: [ro[0]] })],
							readOnly: me.readOnly,
							accessReadOnly: me.readOnly,
							control: objs.S_PERSONC,
							contextSearch: objs.S_PERSONC.contextSearch
						}, {
							ok: function(value) { objs.S_PERSONC.setValue(value); }
						});
					}
				}),
				Ext.create('Ext.form.FieldContainer', {
					layout: 'hbox',
					items: [
						objs.DTNAR = Ext.create('Ext.form.field.Date', {
							labelWidth: me.labelWidth,
							width: 285,
							fieldLabel: 'Дата совершения'
						}),
						objs.REPAYMENT = Ext.create('Ext.form.field.Checkbox', {
							labelWidth: me.labelWidth,
							boxLabel: 'подлежит устранению',
							padding: '0 0 0 10'
						})
					]
				}),
				Ext.create('Ext.form.FieldContainer', {
					layout: 'hbox',
					items: [
						objs.ORD = Ext.create('Ext.form.field.Number', {
							labelWidth: me.labelWidth,
							width: 285,
							fieldLabel: 'Порядок следования в акте',
							minValue: 0,
							maxValue: 32767,
							listeners: {
								blur: function() {
									var me = this;
									if (me.getValue() < 0) me.setValue(me.getValue() * -1);
								},
								change: function(field, value) {
									if (parseInt(value, 10) > 32767) {
										field.setValue(32767);
									}
								}
							}
						}),
						objs.IGNORE_ACT = Ext.create('Ext.form.field.Checkbox', {
							labelWidth: me.labelWidth,
							boxLabel: 'не включать в акт',
							padding: '0 0 0 10',
							handler: function() {
								var checked = objs.IGNORE_ACT.getValue();

								if (checked && objs.IGNORE_ACT.ksAccessEdit) {
									objs.ORD.setValue(0);
								}

								objs.ORD.setDisabled(checked);
							}
						})
					]
				}),
				Ext.create('Ext.form.FieldContainer', {
					layout: 'hbox',
					items: [
							objs.ACT_NUMBER = Ext.create('Ext.form.field.Text', {
							labelWidth: me.labelWidth,
							width: 285,
							padding: '0 10 0 0',
							fieldLabel: 'Пункт акта',
							maxLength: 250
						}),
						objs.ACT_PAGE = Ext.create('Ext.form.field.Text', {
							labelWidth: me.labelWidth,
							width: 285,
							fieldLabel: 'Страница акта',
							maxLength: 250
						})
					]
				}),
				objs.ORD2 = Ext.create('Ext.form.field.Text', {
					labelWidth: me.labelWidth,
					width: 285,
					fieldLabel: 'Порядковый номер',
					maxLength: 20,
					listeners: {
						render: me.ord2_onRender.bind(me),
						blur: me.ord2_onBlur.bind(me)
					}
				}),
				me.sksc('FactNarArea', Ext.create('Ext.form.FieldContainer', {
					layout: 'hbox',
					hidden: true,
					border: 1,
					items: [
						me.sksc('AREA', objs.AREA = Ext.create('Ext.form.field.Number', {
							labelWidth: me.labelWidth,
							fieldLabel: 'Площадь нарушения',
							allowDecimals: true,
							width: 305,
							decimalSeparator: ".",
							decimalPrecision: 8,
							minValue: 0,
							maxValue: 999999999999.99999999
						})),
						Ext.create('Ext.form.Label', { padding: '4 10 0 10', text: 'Единица измерения:' }),
						me.sksc('UNITCOMBO', objs.UNITCOMBO = Ext.create('Ext.form.field.ComboBox', {
							editable: false,
							store: units,
							queryMode: 'local',
							displayField: 'name',
							valueField: 'val',
							listeners: {
								change: function(th, newValue, oldValue) {
									var area = objs.AREA.value;
									objs.AREA.decimalPrecision = newValue === 1 ? 2 : 6;
									if (oldValue && objs.AREA.value) {
										objs.AREA.setValue(newValue === 1 ? area * 10000 : area / 10000);
									}
								}
							}
						}))
					]
				}))
			]
		});
	},

	//#region таб Версии
	createTabVersions: function() {
		var me = this;

		return me.sksc('versionsPanel', Ext.create('Ext.panel.Panel', {
			title: 'Версии (журнал событий)',
			layout: { type: 'vbox', align: 'stretch' },
			flex: 1,
			border: 0,
			items: [
				me.sksc('versionsGrid', Ext.create('Ext.grid.Panel', {
					flex: 1,
					multiSelect: true,
					tbar: [
						me.sksc('versionOpenBtn', Ext.create('Ext.Button', {
							iconCls: 'x_btn_open',
							tooltip: 'Открыть',
							tooltipType: 'title',
							disabled: true,
							handler: function() {
								me.openSnapshot(me.gksc('versionsGrid').getFrstSelect());
							}
						})),
						Ext.create('Ext.Button', {
							iconCls: 'x_btn_refresh',
							tooltip: 'Обновить',
							tooltipType: 'title',
							handler: function() {
								me.showLoadMask({
									msg: KS.L10n.loading_data,
									view: me,
									rid: ajaxRequest({
										url: me.linkCode + '/RefreshVersions_A',
										params: { link: me.getLink() },
										success: function(res) {
											if (res) {
												me.gksc('versionsGrid').store.loadData(res.data);
											}
										},
										failure: function() {
											showError(wmc.get('ErrorGetData'));
										},
										callback: function() {
											me.hideLoadMask();
										}
									})
								});
							}
						})
					],
					features: [
						{
							ftype: 'summary',
							showSummaryRow: false
						}
					],
					listeners: {
						select: function(th1, rec) {
							me.gksc('versionOpenBtn').setDisabled(!rec.get('SNAPSHOT'));
						}
					},
					store: Ext.create('Ext.data.Store', {
						fields: [],
						data: [],
						proxy: 'memory'
					}),
					columnLines: true,
					columns: [],
					plugins: ['gridclipboard']
				}))
			],
			setKsReadOnly: function() {
				//нет смысли вызывать базовый метод, так как сам грид доступен только на просмотр
				return false;
			},
		}));
	},
	//#endregion таб Версии
	
	getNPANameLabelText: function(v, articleData) {
		const res = v.sort((r1, r2) => {
			r1 = r1.data || r1;
			r2 = r2.data || r2;
			let name1 = r1.SNAME || r1.NAME;
			let name2 = r2.SNAME || r2.NAME;
			return (name1 > name2) ? 1 : ((name2 > name1) ? -1 : 0);
		}).map(r => {
			r = r.data || r;
			let name = '';
			if (articleData.length) {
				const articles = articleData.filter(ra => ra.S_NPA === r.LINK);
				if (articles.length) {
					name = articles.sort((a1, a2) => {
						return (a1.CODE > a2.CODE) ? 1 : ((a2.CODE > a1.CODE) ? -1 : 0)
					}).map(a => a.CODE).join(', ');
					if (name) name += ' ';
				}
			}
			name += r.SNAME || r.NAME;
			return name;
		}).join('; ');
		return res;
	},

	//конструктор таба Реквизиты
	createTabProp: function() {
		var me = this,
			objs = me.objs;

		return objs.tabProp = Ext.create('Keysystems.Panel.Prop', {
			minHeight: 358,
			parentView: me,
			decimalData: me.gksd('decimalData'),
			calcParams: { REVIZ: me.revizLink || me.data.data.REVIZ }
		});
	},

	loadCopyEditData: function() {
		var me = this,
			objs = me.objs,
			data = me.data.data;

		me.setLink(data.LINK);
		objs.link = data.LINK;
		data.CONTENT = data.CONTENT && data.CONTENT.replace(/\r/g, '');
		data.RECOMMENDATION = data.RECOMMENDATION && data.RECOMMENDATION.replace(/\r/g, '');
		objs.CONTENT.setValue(data.CONTENT);
		objs.RECOMMENDATION.setValue(data.RECOMMENDATION);
		objs.DTDETECT.setValue(data.DTDETECT);
		objs.DTNAR.setValue(data.DTNAR);
		objs.SUMMA.setValue(data.SUMMA);
		objs.REPAYMENT.setValue(data.REPAYMENT);
	},
	getExtraNew: function(callBack) { 
		const me = this;
		if (!me.autoNumericMaskOrd2) {
			if (callBack) callBack();
			return;
		}
		me.fillNextNumOrd2(callBack);		
	},
	getExtra: function(endFunc) {
		var me = this,
			data = me.data.data,
			objs = me.objs;

		me.baseGetExtra({
			link: data.LINK,
			reviz: me.revizLink || data.REVIZ
		}, function(value) {
			if (value.resource) {
				Ext.apply(KS.L10n, value.resource);
			}
			me.sksd('decimalData', value.decimalData);
			me.isDis = value.isDis;
			if (me.isDis) {
				me.gksc('S_NAR').fieldLabel = 'Вид недостатка';
				me.gksc('S_NAR').setKsAllowEmpty(true);
			}
			me.sksd('disLinks', value.disLinks);
			me.limitNpa = value.limitNpa;
			me.limitNpaOtv = value.limitNpaOtv;
			me.sksd('articleNarListData', value.articleNarListData);
			me.sksd('articleListData', value.articleListData);
			me.sksd('extArticleListData', value.extArticleListData);
			me.sksd('mainNPALinkForExt', value.mainNPALinkForExt);
			me.sksd('limitNpaExt', value.limitNpaExt);
			me.autoNumericMaskOrd2 = value.autoNumericMaskOrd2;
			
			me.access = value.row._Access;
			me.setObjsValuesAndAccess(value.row, me.access, me._arrGeneralRow);
			me.setObjsValuesAndAccess(value, me.access, me._arrGeneralSingl);
			me.setObjsValuesAndAccess(value, me.access, me._arrGeneralMulti);
			
			objs.S_NPA_EXT.setValue(value.S_NPA_EXT);
			objs.SUMMA.decimalData = value.decimalData;

			var tro = value.T_REVIZ_OBJECT.length > 0 ? value.T_REVIZ_OBJECT : ArrayLib.filter(me.tRevizObjects.data, ['LINK'], value.T_REVIZ_AUDIT);
			if (tro && tro[0] && !tro[0].TEMP_NAME) tro[0].TEMP_NAME = tro[0].TEMP_SNAME;
			objs.T_REVIZ_OBJECTS.ksSetValue(tro);
			objs.S_PERSONC.setValue(value.S_PERSONC);

			//Площадь нарушения и единица измерения
			if (me.access.AREA) {
				me.gksc('FactNarArea').setVisible(true);
				objs.AREA.setValue(value.row.AREA);
				objs.UNITCOMBO.setValue(value.row.UNIT);
			}

			me.tRevizObjects = value.revizObj;
			me.maxSumm = value.maxSumm || me.maxSumm;
			me.lockAudit = value.lockAudit || [];
			me.sRprogLinks = value.sRprogLinks || [];
			me.sksd('revizMoneyData', value.revizMoney);
			me.sAuthorityLinks = value.sAuthorityLinks || [];

			me.DT = {
				dh1: new Date(value.DT.dh1),
				dh2: new Date(value.DT.dh2)
			};
			me.DTMONEY = {
				dh1: new Date(value.DTMONEY.dh1),
				dh2: new Date(value.DTMONEY.dh2)
			};

			for (var i = 0, len = value.sPerson.length; i < len; i++) {
				me.sPersonLinks.push(value.sPerson[i]["S_PERSON"]);
			}

			objs.ACT_NUMBER.setValue(value.row.ACT_NUMBER);
			objs.ACT_PAGE.setValue(value.row.ACT_PAGE);

			if (value.content && !objs.CONTENT.store.data.length) {
				var lst = [];
				Ext.each(value.content, function(c) { lst.push([c]); });
				objs.CONTENT.store.loadData(lst, true);
			}
			if (value.recommendation && !objs.RECOMMENDATION.store.data.length) {
				var lst = [];
				Ext.each(value.recommendation, function (r) { lst.push([r]); });
				objs.RECOMMENDATION.store.loadData(lst, true);
			}
			
			objs.S_NPA_NAR.setDisabled(!objs.S_NAR.getValue().length && me.limitNpa);
			objs.S_NPA_OTV.setDisabled(!objs.S_NAR.getValue().length && me.limitNpaOtv);

			me.gksc('S_STATUS').setHidden(!value.visibleStatus);
			if (value.visibleStatus) {
				me.sksd('readOnlyStatuses', value.readOnlyStatuses);
				me.sksd('sStatus', value.sStatus);
				me.gksc('S_STATUS').store.loadData(CBDataLib.get(_, value.status === 0, value.sStatus), false);
				me.gksc('S_STATUS').setValue(value.status);
			}
			
			me.sksd('STAMP', value.row.STAMP);		
			
			me.setFilterNar(value);
			me.getExtraProp(value);
			
			me.getExtraVersion(value);

			if (endFunc) endFunc();
		});
	},
	
	getExtraVersion: function(value){
		if (value.tabVersions) {
			var tabVersions = value.tabVersions,
				me = this,
				snapShots = {},
				snapCol = {
					xtype: 'actionimg',
					dataIndex: 'SNAPSHOT',
					visible: true,
					iconCls: 'x_btn_doc',
					text: 'Файл',
					imgHandler: function(grid, rec) {
						me.openSnapshot(rec);
					}
				},
				ind = ArrayLib.find(tabVersions.columns, ['dataIndex'], 'SNAPSHOT');

			me.sksd('snapshots', snapShots);
			me.objs.allTab.changeTab(me.getTab('Versions'), true);

			if (ind !== -1) {
				tabVersions.columns[ind] = snapCol;
			} else {
				tabVersions.columns.push(snapCol);
			}

			me.gksc('versionsGrid').setMetaDate(tabVersions, {
				profileCode: me.code,
				profileKey: 'versionsGridColumns',
				gateCode: 'edit',
				controlName: 'VersionsTab'
			});
		}
	},

	//загрузка данных таба "Реквизиты"
	getExtraProp: function(value) {
		if (value.tabProp) {
			var me = this,
				objs = me.objs;

			objs.allTab.changeTab(me.getTab('Prop').loadData(JSON.parse(JSON.stringify(value.tabProp))), true);
		}
	},

	dataCollector: function() {
		var me = this,
			res = {},
			objs = me.objs;

		res.isDis = me.isDis;
		res.link = objs.link;
		res.STAMP = me.gksd('STAMP');
		Ext.each(me._arrGeneralRow, function(key) {
			var c = objs[key];
			if (c) res[key] = c.getValue();
		});

		Ext.each(me._arrGeneralSingl, function(key) {
			var c = objs[key];
			if (c) res[key] = c.getLink();
		});

		if (!objs.T_REVIZ_OBJECTS.isEmpty()) {
			var d = objs.T_REVIZ_OBJECTS.getValue();
			d = d[0].data || d[0];

			var pos = ArrayLib.find(me.lockAudit, ['T_REVIZ_OBJECTS'], d.LINK);
			if (pos === -1) pos = 0;

			res.T_REVIZ_AUDIT = me.lockAudit[pos].LINK;
			res.T_REVIZ_OBJECTS = objs.T_REVIZ_OBJECTS.getLink();
			res.TEMP_CODE = d.TEMP_CODE;
			res.TEMP_NAME = d.TEMP_NAME;
			res.TEMP_SNAME = d.TEMP_SNAME;
		}

		l = [];
		Ext.each(me.objs.S_NPA_NAR.getValue(), function(v) { l.push({ S_NPA: v.LINK || v.data.LINK, S_ARTICLE: [] }); });
		var articleNarListData = me.gksd('articleNarListData');
		if (articleNarListData?.checkedLinks?.length) {
			Ext.each(articleNarListData.checkedLinks,
				function(link) {
					var article = ArrayLib.filter(articleNarListData.data, ['LINK'], link);
					if (article.length) {
						var npa = ArrayLib.filter(l, ['S_NPA'], article[0].S_NPA);
						if (npa.length) npa[0].S_ARTICLE.push({
							LINK: link,
							CODE: article[0].CODE,
							REF: article[0].REF
						});
					}
				});
		}
		res.npaArticle = JSON.stringify(l);

		// НПА-статьи (ответств)
		l = [];
		Ext.each(me.objs.S_NPA_OTV.getValue(), function(v) { l.push({ S_NPA: v.LINK || v.data.LINK, S_ARTICLE: [] }); });
		var articleListData = me.gksd('articleListData');
		if (articleListData && articleListData.checkedLinks && articleListData.checkedLinks.length) {
			Ext.each(articleListData.checkedLinks,
				function(link) {
					var article = ArrayLib.filter(articleListData.data, ['LINK'], link);
					if (article.length) {
						var npa = ArrayLib.filter(l, ['S_NPA'], article[0].S_NPA);
						if (npa.length) npa[0].S_ARTICLE.push({
							LINK: link,
							CODE: article[0].CODE,
							REF: article[0].REF
						});
					}
				});
		}
		res.npaArticleOtv = JSON.stringify(l);

		// НПА-статьи (доп)
		l = [];
		Ext.each(me.objs.S_NPA_EXT.getValue(), function(v) { l.push({ S_NPA: v.LINK || v.data.LINK, S_ARTICLE: [] }); });
		var extArticleListData = me.gksd('extArticleListData');
		if (extArticleListData && extArticleListData.checkedLinks && extArticleListData.checkedLinks.length) {
			Ext.each(extArticleListData.checkedLinks,
				function(link) {
					var article = ArrayLib.filter(extArticleListData.data, ['LINK'], link);
					if (article.length) {
						var npa = ArrayLib.filter(l, ['S_NPA'], article[0].S_NPA);
						if (npa.length) npa[0].S_ARTICLE.push(link);
					}
				});
		}
		res.npaArticleExt = JSON.stringify(l);

		res.tabProp = JSON.stringify(me.dataCollectorProp());
		res.revizLink = me.revizLink || me.data && me.data.data.REVIZ;
		res.UNIT = objs.UNITCOMBO.value;
		res.AREA = objs.AREA.getValue();

		// Данные для массива, хранящего нарушения в мероприятии
		res.articleNarListData = me.gksd('articleNarListData');
		res.articleListData = me.gksd('articleListData');
		res.extArticleListData = me.gksd('extArticleListData');
		res.limitNpa = me.limitNpa;
		res.limitNpaOtv = me.limitNpaOtv;
		
		res.S_STATUS = me.gksc('S_STATUS').getValue();

		return res;
	},

	//Сборка данных таба "Реквизиты"
	dataCollectorProp: function() {
		var me = this;

		return me.getTabVisible('Prop') ? me.getTab('Prop').getData() : _;
	},

	saveData: function(endFunc, inputParams) {
		var me = this,
			result = inputParams || me.dataCollector(),
			objs = me.objs,
			oldData = JSON.parse(me.oldData);

		if (!result.dataChangeStatus && result.link > 0 && result.S_STATUS !== oldData.S_STATUS){
			Ext.create('Keysystems.Comment',
				{
					title: 'Изменение статуса',
					labelText: 'Комментарий',
					initText: '',
					okFn: function () {
						result.dataChangeStatus = {OldStatus: oldData.S_STATUS, NewStatus: result.S_STATUS, Comment: this.textArea.getValue()};
						me.okFunc ? me.okFunc(result, function(link) { objs.link = link; }) : me.saveData(endFunc, result);
					}
				}).show();
		}
		else{
			me.okFunc ? me.okFunc(result, function(link) { objs.link = link; }) : me.baseSaveData(result, endFunc);
		}		

		if (endFunc) {
			endFunc();
		}
	},

	successSaveFunc: function(result, endFunc, params) {
		const me = this;

		if (result.sStatus)
			me.gksc('S_STATUS').store.loadData(CBDataLib.get(_, result.row.S_STATUS === 0, result.sStatus), false);
		if (result.CheckSaveResult) {
			me.parseCheckSaveResult(result.CheckSaveResult, function (checkSaveResult) {
				let chStatus = params.dataChangeStatus;
				params = me.dataCollector();
				params.processCheckSave = false;
				params.checkSaveResult = checkSaveResult;
				params.dataChangeStatus = chStatus;
				me.saveData(endFunc, params);
			})
			return;
		}

		me.callParent(arguments);
	},

	isFilled: function() {
		var me = this,
			objs = me.objs,
			dtMoney = objs.DTNAR.getValue(),
			dt = objs.DTDETECT.getValue(),
			cross;

		let res = true;
		if (me.isDis && objs.S_NAR.isEmpty()) {
			me.addToInvalidControls(objs.S_NAR);
			res = false;
		}
		
		if (objs.T_REVIZ_OBJECTS.isEmpty()) {
			me.addToInvalidControls(objs.T_REVIZ_OBJECTS);
			res = false;
		}
		
		//Дата выявления
		if (me.DT.dh1 && me.DT.dh2 && dt) {
			cross = PeriodLib.getPeriodsCross(me.DT, { dh1: dt, dh2: dt });
			if (!cross) {
				me.warningMessages.push(wmc.getString(KS.L10n.FormRowFactNar_CheckSave_Дата_выявления_не_входит_в_период_проведения_мероприятия__0_____1__,
					me.DT.dh1.toLocaleDateString(), me.DT.dh2.toLocaleDateString()));
			}
		}

		//Дата совершения
		if (me.DTMONEY.dh1 && me.DTMONEY.dh2 && dtMoney) {
			cross = PeriodLib.getPeriodsCross(me.DTMONEY, { dh1: dtMoney, dh2: dtMoney });
			if (!cross) {
				me.warningMessages.push(wmc.getString(KS.L10n.FormRowFactNar_CheckSave_Дата_совершения_нарушения_не_входит_в_проверяемый_период_мероприятия__0_____1__,
					me.DTMONEY.dh1.toLocaleDateString(), me.DTMONEY.dh2.toLocaleDateString()));				
			}
		}

		//Максимальная сумма (для дочерних)
		if (me.maxSumm && parseFloat((me.maxSumm + '').replace(regSpace, '')) < objs.SUMMA.getNumValue()) {
			me.warningMessages.push(me.factNarChild ? wmc.get('SubSumMoreWarninng') : KS.L10n.FormRowFactNar_CheckSave_Сумма_нарушения_больше_проверенной_);
		}

		//Дата совершения не больше даты выявления
		if (dt && dtMoney && (dt < dtMoney)) {
			me.errorMessages.push(KS.L10n.FormRowFactNar_CheckSave_Дата_совершения_не_может_быть_больше_даты_выявления_);
		}
		return res;
	},

	getSNarPC: function(sNarLink, endFunc) {
		var me = this,
			objs = me.objs;

		me.showLoadMask({
			msg: KS.L10n.updating_data,
			cancelFn: function () {
			}
		});

		ajaxRequest({
			url: 'SNar/GetSNarExtra_A',
			params: {
				link: sNarLink
			},
			success: function(res) {
				if (res.result) {
					res = res.result;
					objs.S_NARP.setValue(res.P);
					objs.S_NARC.setValue(res.C);

					me.limitNpa = res.limitNpa;
					me.limitNpaOtv = res.limitNpaOtv;
					me.sksd('articleListData', res.articleListData);
					me.sksd('articleNarListData', res.articleNarListData);

					objs.S_NPA_NAR.setValue(res.sNpaNar);
					objs.S_NPA_OTV.setValue(res.sNpaOtv);
					if (!objs.S_NPA_NAR.isHidden()) objs.S_NPA_NAR.setDisabled(!objs.S_NAR.getValue().length && me.limitNpa);
					if (!objs.S_NPA_NAR.isHidden()) objs.S_NPA_OTV.setDisabled(!objs.S_NAR.getValue().length && me.limitNpaOtv);
				}

				me.hideLoadMask();
				if (endFunc) endFunc();
			},
			failure: function() {}
		});
	},

	//Блокирует все компоненты кроме поля "Сумма" для случая создания подчиненого нарушения
	createChild: function() {
		var me = this,
			objs = me.objs;

		Ext.each(me._arrGeneralRow, function(name) {
			objs[name].setDisabled(true);
		});

		Ext.each(me._arrGeneralSingl, function(name) {
			objs[name].setDisabled(true);
		});

		Ext.each(me._arrGeneralMulti, function(name) {
			objs[name].setDisabled(true);
		});

		objs.SUMMA.setDisabled(false);
	},

	getRowClass: function(r, val) {
		var l = r.get('LINK');
		if (l === this.getLink()) {
			r.readOnly = true;
			return 'ks-snar-self';
		}
		var res = _;
		Ext.each(val, function(v) {
			if ((v.data || v).LINK === l) {
				res = 'ks-snar-useles';
				r.readOnly = true;
				return false;
			}
			return true;
		});
		return res;
	},

	setFilterNar: function(value) {
		var me = this,
			filterNar = value.filterNar || me.gksd('filterNar') || {},
			narWhereArgs = {},
			tro = me.objs.T_REVIZ_OBJECTS.getValue();

		if (filterNar.ObjType) {
			var type = 0;
			Ext.each(tro, function(ro) {
				type += ro.TYPE;
			});
			narWhereArgs.RevObjType = {
				value: type,
				type: 'int'
			};
		}

		if (filterNar.OrgType) {
			var orgType = [];
			Ext.each(tro, function(ro) {
				orgType = orgType.concat(ro.ORG_TYPE ? ro.ORG_TYPE.split(';') : ro.TYPE);
			});
			narWhereArgs.OrgType = {
				value: JSON.stringify(orgType),
				type: 'List_int'
			};
		}

		if (filterNar.VBUDJ) {
			var rMoney = me.gksd('revizMoneyData') && me.gksd('revizMoneyData')[0];
			if (rMoney)
				narWhereArgs.VBudj = {
					value: rMoney.S_VBUDJ || rMoney.S_VBUDJ_FINANC, 
					type: 'int'
				};
		}

		me.sksd('filterNar', filterNar);
		me.sksd('narWhereArgs', narWhereArgs);
	},

	//Открыть snapshot
	openSnapshot: function(rec) {
		let snapshotHtml = rec.get('SNAPSHOT'),
			code = this.code;
		Ext.create('Ext.window.Window', {
			height: 600,
			width: 800,
			minHeight: 600,
			minWidth: 800,
			modal: true,
			maximizable: true,
			scrollable: true,
			items: [
				Ext.create('Ext.panel.Panel', {
					layout: 'fit',
					border: 0,
					bodyStyle: 'border:0; padding: 0 5px;',
					html: snapshotHtml,
					tbar: [
						Ext.create('Ext.Button', {
							iconCls: 'x_btn_save',
							tooltip: 'Сохранить',
							tooltipType: 'title',
							handler: function () {
								let uploader = Ext.create('Keysystems.Uploader.DataUploader', {
									parseUrl: function (url) {
										return urlPrefix + parsUrl(url);
									}
								});
								uploader.getFileFromSnapshot(code, rec.get('LINK'));
							}
						}),
						Ext.create('Ext.Button', {
							iconCls: 'x_btn_print',
							tooltip: 'Печать',
							tooltipType: 'title',
							handler: function () {
								let win = window.open('', 'snapshot');
								win.document.open();
								win.document.write(snapshotHtml);
								win.document.close();
								win.print();
							}
						})
					]
				})
			]
		}).show();
	},
	
	fillNextNumOrd2(callback) {
		const me = this;
		me.showLoadMask({
				msg: KS.L10n.loading_data,
				rid: ajaxRequest({
					url: 'SFactNar/GetNextNumOrd2_A',
					params: {
						reviz: me.revizLink,
						isVfa: me.isVfa
					},
					success: function (result) {
						me.objs.ORD2.setValue(result.NextNum);
						me.fillRollBackData(result.RollBackData);
					},
					callback: function () {
						me.hideLoadMask();
						if (callback) callback();
					}
				})
			}
		)
	},

	ord2_onRender(e) {
		const me = this;		
		e.getEl().on('contextmenu', function (target) {
			if (!me.autoNumericMaskOrd2) return;
			target.stopEvent();
			new Ext.menu.Menu({
					items: [{
						text: 'Заполнить',
						listeners: {
							click: me.ord2_onContextMenuClick.bind(me)
						}
					}]
				}
			).showAt(target.getXY());
		}, e);
	},
	
	ord2_onContextMenuClick(){
		const me = this;
		const data = me.dataCollector();
		me.showLoadMask({
			msg: KS.L10n.updating_data,
			rid: ajaxRequest({
				url: 'SFactNar/CalculateOrd2_A',
				params: {
					gzipData: SignalR.pack(data),
					rollBackData: me.gksd('rollbackData') ? JSON.stringify(me.gksd('rollbackData')) : null
				},
				success: function (result) {
					if (!result) return;

					me.objs.ORD2.setValue(result.NextNum);
					me.fillRollBackData(result.RollBackData);
				},
				callback: function(){
					me.hideLoadMask();
				}
			})
		})		
	},

	ord2_onBlur() {
		const me = this;
		if (me.gksd('IgnoreNewAutoNumber')) return;

		const rollbackData = me.gksd('rollbackData');
		if (!rollbackData?.RollbackNumStr) return;

		const val = me.objs.ORD2.getValue();
		if (rollbackData.RollbackNumStr.toString() === val.toString()) return;

		ajaxRequest({
			url: me.linkCode + '/CheckAutoNumerExt_A',
			params: {
				strNumber: val,
				gzipData: SignalR.pack(rollbackData)
			},
			success: function (newNum) {
				if (newNum !== -1 && val === me.objs.ORD2.getValue()) {
					selectDialogShow(KS.L10n.attention, wmc.get('SaveNewAutoNumber', val),
						function () {
							ajaxRequest({
								url: me.linkCode + '/SaveNewAutoNumberExt_A',
								params: {
									strNumber: val,
									newNumber: newNum,
									gzipData: SignalR.pack(rollbackData)
								},
								success: function (updRollbackData) {
									me.fillRollBackData(updRollbackData);
								}
							});

						},
						function () {
							me.sksd('IgnoreNewAutoNumber', true);
						}
					);
				}
			}
		});
	},

	fillRollBackData: function (rollBackData) {
		if (!rollBackData) return;
		
		const me = this;
		me.sksd('rollbackData', rollBackData);
		//для Base.Edit.js и корректного отката
		me.sksd('rollbackNumLink', rollBackData.RollbackNumLink);
		me.sksd('rollbackNumVal', rollBackData.RollbackNumVal);
		me.sksd('rollbackMissed', rollBackData.RollbackMissed);
	}
});