﻿//Список журанала событий
Ext.define('Revizor.EventLog.List', {
	extend: 'Keysystems.Base.List',
	viewMode: 'tabShow',
	hidePagging: true,
	ignoreLoadNextPrevPages: true,
	//Уникальный признак того что это журнал событий
	isEventLog: true,
	checkModel: false,

	constructor: function(cfg) {
		var me = this;
		me.dictCode = cfg.code;
		me.code = '';
		me.callParent(arguments);
	},

	getGridStoreCfg: function() {
		var cfg = this.callParent(arguments);
		delete cfg.remoteSort;
		return cfg;
	},

	getData: function(reload) {
		let me = this;
		if (!me.dictCode) return;

		me.showLoadMask({
			msg: reload ? KS.L10n.updating_data : KS.L10n.loading_data,
			opaque: !reload,
			rid: ajaxRequest({
				params: { code: me.dictCode },
				url: 'data/GetEventsLog_A',
				success: function (value) {
					me.beforeSetData(value,
						{
							page: me.startPage,
							pageSize: me.gridStore.pageSize,
							reload: reload
						});
					me.setData(value);
				},
				callback: () => {
					me.hideLoadMask();
				}
			}),
			cancelFn: function () {
				me.objs.view.close();
			}
		});
	},
	createTBar: function() {
		var me = this;

		me.objs.tbar = [
			Ext.create('Ext.Button', {
				iconCls: 'x_btn_journal',
				tooltip: 'Детализация события',
				tooltipType: 'title',
				hidden: me.btnsHide.journal,
				scope: me,
				handler: () => {
					me.detailEvent(me.Grid.getSelectionModel().getSelection());
				}
			}),
			{ xtype: 'tbseparator' },
			Ext.create('Ext.Button', {
				iconCls: 'x_btn_print',
				tooltip: 'Печать',
				tooltipType: 'title',
				hidden: me.btnsHide.print,
				scope: me,
				handler: me.Print
			}),
			Ext.create('Ext.Button',
				{
					iconCls: 'x_btn_wrap',
					tooltip: wmc.get('Wrap'),
					tooltipType: 'title',
					handler: function() {
						var grid = me.objs.Grid;

						if (grid.autoheightrows) {
							grid.getEl().removeCls(me.autoheightrowsCls);
							this.setIconCls('x_btn_wrap');
							this.setTooltip(wmc.get('Wrap'));
						} else {
							grid.getEl().addCls(me.autoheightrowsCls);
							this.setIconCls('x_btn_nonwrap');
							this.setTooltip(wmc.get('NonWrap'));
						}

						grid.autoheightrows = !grid.autoheightrows;
					}
				}),	
			Ext.create('Ext.Button',
				{
					iconCls: 'x_btn_refresh',
					tooltip: 'Обновить',
					tooltipType: 'title',
					handler: function() { me.getData(true); }
				}),
			Ext.create('Ext.Button',
				{
					iconCls: 'x_btn_exit',
					tooltip: 'Выход',
					tooltipType: 'title',
					handler: function() { me.objs.view.close(); }
				})
		];
	},
	/**
	 * Получить детализацию по событиям
	 * @param sels 
	 */
	detailEvent: function (sels) {
		let me = this;
		if (!sels.length) return;

		let links = [];
		//см. EventsLogTasks.DetailEvents, различаются входные параметры для MS и PG
		if (sels[0].data.OBJECT) {
			sels.forEach(sel => links.push([sel.data.OBJECT, sel.data.LINK]));
		} else {
			sels.forEach(sel => links.push([sel.data.LINK]));
		}

		me.showLoadMask({
			msg: wmc.getMask('EventLogDetailLoading'),
			rid: ajaxRequest({
				params: {
					code: me.dictCode,
					links: JSON.stringify(links)
				},
				url: 'data/DetailEvents_A',
				success: function (html) {
					showDetailEventsLog({
						html: html,
						modal: true,
						title: me.title
					});					
				},
				callback: function () {
					me.hideLoadMask();
				}
			})
		})
	}
});