﻿Ext.define('Keysystems.Documents.Reviz.Report.List', {
	extend: 'Keysystems.Base.List',
	title: 'Отчет о выполнении плана',
	iconCls: 'x_btn_document',
	readOnly: true,
	btnsHide: { new: true, same: true, search: true },
	fileColumn: true,
	whereArgs: { HideEmptyReviz: { value: 'True', type: 'bool' } },
	labelWidth: 150,

	createItems: function() {
		var me = this,
			res = me.callParent(arguments);

		me.Grid.on('selectionchange', function(th, sels) { me.selectionChangeReviz(sels[0]); });

		return res;
	},

	edit: function(f, data, defCfg) {
		if (!defCfg) defCfg = {};
		defCfg.title = 'Планы устранения нарушений';
		this.callParent([f, data, defCfg]);
	},

	baseGetData: function(endFunc, params) {
		var me = this;

		params.whereArgs.isVfa = { value: (params.isVfa = me.isVfa) ? 'True' : 'False', type: 'bool' };
		me.whereArgs = params.whereArgs;

		return me.callParent([
			function(data) {
				me.docWhereArgs = {
					Reviz: { value: 0, type: 'int' },
					DocVid: { value: JSON.stringify([data.SDocVidReport]), type: 'List_int' },
					STasks: { value: JSON.stringify([data.STask]), type: 'List_int' },
					DRBegin: { value: longPeriod.begin, type: 'Date' },
					DBegin: { value: longPeriod.begin, type: 'Date' },
					DREnd: { value: longPeriod.end, type: 'Date' },
					DEnd: { value: longPeriod.end, type: 'Date' },
					IgnoreHierarchy: { value: 'True', type: 'bool' },
					SWorks: { value: '[]', type: 'List_int' },
					NotSWorks: { value: '[]', type: 'List_int' },
					BanTasks: { value: '[]', type: 'List_int' },
					LinkMaster: { value: 0, type: 'int' }
				};
				me.docWhereArgs[me.isVfa ? 'SWorks' : 'NotSWorks'].value = JSON.stringify(data.VfaWorks);
				if (endFunc) endFunc(data);
			}, params
		]);
	},

	selectionChangeReviz: function(rec) {
		var me = this;
		if (!rec) rec = me.getSelect()[0];
		me.getDocPanel().setVisible(!!rec);
		if (rec) {
			me.revizLink = rec.get('LINK');
			me.docLink = rec.get('DOCUMENTS_LINK');
			var dict = me.getDictDoc();
			dict.pagingTool.doRefresh();
			dict.initialConfig.revizLink = me.revizLink;
			dict.initialConfig.linkSelf = me.docLink;
			dict.initialConfig.tro = rec.get('T_REVIZ_OBJECTS');
		}
	},

	getDocPanel: function() {
		var me = this;
		if (!me.docPanel)
			me.objs.view.add(
				Ext.create('Ext.resizer.Splitter'),
				me.docPanel = Ext.create('Ext.panel.Panel', {
					layout: { type: 'vbox', align: 'stretch' },
					flex: 1
				})
			);
		return me.docPanel;
	},

	getDictDoc: function() {
		var me = this;
		if (!me.dictDoc) {
			me.dictDoc = Ext.create('Keysystems.Base.List', {
				editClass: 'Keysystems.Documents.Reviz.Report.Edit',
				closable: false,
				tabMode: true,
				checkModel: false,
				isVfa: me.isVfa,
				code: dnl.DOCUMENTS,
				parentView: me.getDocPanel(),
				title: 'Отчет о выполнении плана',
				hidePagging: true,
				pageSize: 100000,
				linkCode: 'SDocumentReviz',
				baseGetData: function(callBack) {
					if (callBack) {
						callBack({
							columns: me.getDocColumns(),
							fields: me.getDocFields(),
							data: { data: [], total: 0 }
						});
					}
				},
				updRecord: function() { me.dictDoc.refresh(); },
				baseRefresh: function(callBack) { 
					if (callBack) me.getDocData(me.revizLink, callBack, this.pagingTool.reload); 
				},
				getRowClass: function(r) { return r.get('ReadOnly') === false ? 'ks-editable' : ''; },
				GateCode: 'list',
				prefix: 'DocumentRevizReport',
				profileKey: 'Document',
				head: false,
				btnsHide: { search: true },
				readOnly: false,
				functions: {
					delete: function(links, callBack) {
						var me = this;
						me.ridDel = ajaxRequest({
							params: { links: links },
							url: 'SDocumentReviz/DeleteReport_A',
							success: function(value) {
								var notDel = value.notDel;
								if (notDel && notDel.length) {
									relationsMsg(me.code, notDel, value.notDelLinks, me.tabMode, me.parentView);
								}
								callBack(true);
							},
							failure: function() { callBack(false); },
							callback: function() { delete me.ridDel; }
						});
					}
				}
			});
		}
		return me.dictDoc;
	},

	getDocData: function(revizLink, callBack, reload) {
		var me = this,
			docData = me.docData || (me.docData = {});
		if (docData[revizLink] && !reload) {
			callBack(docData[revizLink]);
			return;
		}
		me.docWhereArgs.Reviz.value = me.revizLink;
		me.docWhereArgs.LinkMaster.value = me.docLink;
		var p = me.getDocPanel();
		if (p.el) {
			p.setLoading(KS.L10n.loading_data);
		} else {
			p.disable();
		}
		PageDataLib.get({
			linkCode: 'SDocuments',
			whereArgs: JSON.stringify(me.docWhereArgs),
			byDocumentReviz: true,
			reload: true,
			page: 1,
			pageSize: 1000
		}, function(data) {
			p.setLoading(false);
			callBack(docData[revizLink] = data);
			p.enable();
		});
	},

	getDocColumns: function() {
		return this.columns || [
			{ text: '№', dataIndex: 'NUMBER', flex: 1 },
			{ text: 'Дата', dataIndex: 'DT', flex: 1, xtype: 'datecolumn', format: 'd.m.Y' },
			{ text: 'Статус', dataIndex: 'S_STATUS_NAME', flex: 1 }
		];
	},

	getDocFields: function() { return this.fields || ['LINK', 'NUMBER', 'DT', 'S_STATUS_NAME', 'ReadOnly']; },

	fileEdit: function(rec) { this.downloadFile(rec); },

	getFileName: function(rec) {
		var d = rec.get('DT');
		return Ext.String.format('{0} № {1} от {2}', rec.get('NAME'), rec.get('NUMBER'), Ext.isDate(d) ? Ext.Date.format(d, 'd_m_Y') : d);
	}
});