﻿Ext.define('Keysystems.Documents.Reviz.Report.Edit', {
	extend: 'Keysystems.Base.Edit',
	title: 'Отчет о выполнении плана',
	profilePrefix: 'DocumentsRevizReport',
	isFileBtn: true,
	docLink: -1,
	narRemLink: -1,
	onlyMainFile: true,
	viewMinSize: [600, 300],

	createItems: function() {
		var me = this,
			objs = me.objs,
			items = [
				Ext.create('Ext.form.FieldContainer', {
					layout: 'hbox',
					items: [
						objs.NUMBER = Ext.create('Ext.form.field.Text', {
							width: 130,
							labelWidth: 30,
							disabledCls: '',
							fieldLabel: '№',
							maxLength: 25,
							enforceMaxLength: true
						}),
						objs.DT = Ext.create('Ext.form.field.Date', {
							width: 130,
							padding: '0 0 0 20',
							disabledCls: '',
							labelWidth: 30,
							ksAllowEmpty: true,
							allowEmpty: false,
							fieldLabel: 'от'
						}),
						'->',
						objs.S_STATUS = Ext.create('Ext.form.field.ComboBox', {
							editable: false,
							value: 0,
							queryMode: 'local',
							fieldLabel: 'Статус',
							disabledCls: '',
							labelWidth: 80,
							displayField: CBDataLib.displayField,
							valueField: CBDataLib.valueField,
							store: objs.statusStore = Ext.create('Ext.data.Store', {
								fields: CBDataLib.getFields(),
								data: [],
								proxy: 'memory'
							})
						})
					]
				}),
				objs.fsNarRemove = Ext.create('Ext.form.FieldSet', {
					title: 'Мероприятия по устранению',
					collapsible: true,
					minHeight: 220,
					height: 220,
					//width: 300,
					layout: { type: 'vbox', align: 'stretch' },
					//layout: 'anchor',
					flex: 1
				}),
				Ext.create('Ext.form.FieldSet', {
					title: 'Документы',
					collapsible: true,
					minHeight: 100,
					layout: { type: 'vbox', align: 'stretch' },
					minHeight: 220,
					flex: 1,
					items: [me.getDocGrid()]
				})
			];

		return me.callParent([items]);
	},

	//{Документ.Вид.Имя}+' № '+ {Документ.Номер} + ' от ' + ДАТАПРОП({Документ.Дата},4)
	getFileName: function() {
		var me = this,
			objs = me.objs,
			d = objs.DT.getValue();
		return Ext.String.format('{0} № {1} от {2}', me.NAME, objs.NUMBER.getValue(), Ext.isDate(d) ? Ext.Date.format(d, 'd_m_Y') : d);
	},

	fileEdit: function() {
		var me = this,
			objs = me.objs;
		if (objs.isDisable) {
			me.downloadFile();
		} else {
			me.callParent();
		}
	},

	createFile: function(link, callback) { this.runCreateFile(link, callback); },

	//сообщение о наличии несохраненных данных при создании файла
	createFileMsgShow: function(cfg) {
		Ext.Msg.show({
			title: wmc.get('Attention'),
			msg: wmc.get('NeedSaveChange'),
			buttons: Ext.MessageBox.OKCANCEL,
			buttonText: { ok: 'Сохранить', },
			fn: function(buttonId) {
				var fn = cfg[buttonId] || cfg.default;
				if (fn) fn();
			},
			icon: Ext.MessageBox.INFO
		});
	},

	runCreateFile: function(link, callback) { 
		if (this.beforeCreateFile(callback) !== false) {
			UploaderLib.newFile('DOCUMENTS', link, 0, -1, 0, this.getLoadMaskTarget(), callback);
		}
	},

	beforeCreateFile: function(callback) {
		var me = this;
		me.checkFilled(res => {
			if (!res) return;
			
			var newData = me.saveChangesFn();
			if (newData) {
				me.createFileMsgShow({ ok: function() { me.saveData(function() { me.runCreateFile(me.objs.link, callback); }, newData); } });
				return false;
			}	
		})		
		return _;
	},

	//#region Мероприятия по устранению

	getFactNarRec: function(factNar) { return ArrayLib.filter(this.objs.factNar, ['LINK'], factNar)[0]; },

	getNarRemoveColumns: function() {
		var me = this;
		return me.narRemoveColumns = [
			{
				text: 'Факт нарушения',
				dataIndex: 'FACTNAR',
				columns: [
					{
						text: 'Код',
						flex: 1,
						renderer: function(v, m, r) {
							var factNar = me.getFactNarRec(r.get('FACTNAR'));
							return factNar ? factNar.S_NAR_CODE : _;
						}
					},
					{
						text: 'Вид нарушения',
						flex: 3,
						renderer: function(v, m, r) {
							var factNar = me.getFactNarRec(r.get('FACTNAR'));
							return factNar ? factNar.S_NAR_NAME : _;
						}
					},
					{
						text: 'Сумма<br>нарушения',
						flex: 2,
						renderer: function(v, m, r) {
							var factNar = me.getFactNarRec(r.get('FACTNAR'));
							return factNar ? factNar.SUMMA : _;
						}
					}
				]
			},
			{
				text: 'Срок<br>устранения',
				dataIndex: 'DTSROK',
				xtype: 'datecolumn',
				format: 'd.m.Y',
				viewer: { xtype: 'datefield', editable: false }
			},
			{
				text: 'Мероприятия по<br>устранению',
				dataIndex: 'CONTENT',
				viewer: {
					xtype: 'triggertexteditor',
					editable: false,
					getEditorTitle: function() { return this.column.text; }
				}
			},
			{
				text: 'Исполнители',
				dataIndex: 'FIO',
				renderer: function(v, m, r) { return getFI(me.getNarRemPersons(r.get('LINK_SELF')), 'S_PERSON_'); },
				viewer: {
					xtype: 'trigger',
					triggerBaseCls: 'x-dict-trigger',
					triggerCls: 'x_btn_dict',
					triggerWidth: 22,
					editable: false,
					setValue: function(v) {
						var r = this.ownerCt && this.ownerCt.context ? this.ownerCt.context.record : _;
						this.__setValue(r ? getFI(me.getNarRemPersons(r.get('LINK_SELF')), 'S_PERSON_') : v);
					},
					onTriggerClick: function() {
						dictFunc({
							parentView: me,
							checkModel: false,
							inputDicts: [Ext.create('InputEditDict', { name: 'S_ORG', data: [user.org] })],
							whereArgs: {
								InLinksOnly: { value: 'True', type: 'bool' },
								InLinks: {
									value: ArrayLib.getLinks(me.getNarRemPersons(this.ownerCt.context.record.get('LINK_SELF')), 'S_PERSON', 1),
									type: 'List_int'
								}
							},
							code: dnl.S_PERSON
						});
					}
				}
			},
			{
				text: 'Примечание',
				dataIndex: 'COMMENT',
				viewer: {
					xtype: 'triggertexteditor',
					editable: false,
					getEditorTitle: function() { return this.column.text; }
				}
			},
			{
				text: 'Результат',
				dataIndex: 'RESULT',
				renderer: function(v, m) {
					if (!objs.isDisable && me.getNarRemoveDict && this === me.getNarRemoveDict().Grid) {
						m.innerCls = 'x_btn_edit';
						m.style += 'background-repeat: no-repeat; background-position: right; display: block;';
					}
					return v;
				},
				editor: {
					xtype: 'triggertexteditor',
					maxLength: 8000,
					getEditorTitle: function() { return this.column.text; }
				},
				viewer: {
					xtype: 'triggertexteditor',
					editable: false,
					getEditorTitle: function() { return this.column.text; }
				}
			},
			{
				text: 'Дата устранения',
				dataIndex: 'DTDONE',
				xtype: 'datecolumn',
				format: 'd.m.Y',
				renderer: function(v, m) {
					if (!objs.isDisable && me.getNarRemoveDict && this === me.getNarRemoveDict().Grid) {
						m.innerCls = 'x_btn_calendar';
						m.style += 'background-repeat: no-repeat; background-position: right; display: block;';
					}
					return Ext.util.Format.date(v, 'd.m.Y');
				},
				editor: 'datefield',
				viewer: { xtype: 'datefield', editable: false }
			},
			{
				text: 'Комментарии',
				dataIndex: 'COMMENT2',
				editor: {
					xtype: 'triggertexteditor',
					editable: false,
					getEditorTitle: function() { return this.column.text; }
				},
				viewer: {
					xtype: 'triggertexteditor',
					editable: false,
					getEditorTitle: function() { return this.column.text; }
				}
			}
		];
	},

	getNarRemPersons: Keysystems.Documents.Edit.Reviz.prototype.getNarRemPersons,

	getNarRemoveFields: function() {
		var me = this;
		return me.narRemoveFields || (me.narRemoveFields = ['LINK', 'LINK_SELF', 'FACTNAR', 'S_NAR', 'S_NAR_CODE', 'S_NAR_NAME', 'SUMMA', 'CONTENT', 'DTSROK', 'COMMENT', 'COMMENT2', 'RESULT', 'FIO', 'DTDONE']);
	},

	getNarRemoveTBar: function() {
		var me = this,
			objs = me.objs;
		return objs.narRemoveTBar || (objs.narRemoveTBar = [
			objs.btnOpenNarRemove = Ext.create('Ext.Button', {
				iconCls: 'x_btn_open',
				tooltip: 'Выбрать',
				tooltipType: 'title',
				handler: function() {
					var c = objs.DT,
						d = c.getValue();
					if (!(d && Ext.isDate(d))) {
						info(wmc.get(d ? 'NotDate' : 'InputDate', d), function() { c.focus(); });
						return;
					}
					me.getPlanDict();
				}
			})
		]);
	},

	getNarRemoveDict: function() {
		var me = this,
			objs = me.objs;

		if (!objs.narRemoveDict) {
			objs.narRemoveDict = Ext.create('Keysystems.Base.List.Tree', {
				code: dnl.DOCREVIZ,
				hidePagging: true,
				tabMode: true,
				head: false,
				closable: false,
				pageSize: 100000,
				parentView: objs.fsNarRemove,
				getGridCfg: function() {
					let res = this.callParent(arguments);

					(res.plugins || (res.plugins = [])).push(objs.isDisable
						? Ext.create('Keysystems.grid.plugin.RowEditing', { readOnly: true })
						: Ext.create('Ext.grid.plugin.CellEditing', {
							clicksToEdit: 1,
							createColumnField: function(col) {
								var pl = this,
									field = pl.callParent(arguments);
								if (['RESULT', 'DTDONE'].indexOf(col.dataIndex) !== -1) {
									field.on('change', function(th, v) {
										var rec = ArrayLib.getByPath(pl, 'context.record'),
											dataIndex = th.column.dataIndex;
										if (rec) {
											rec.set(dataIndex, v);
											var narRem = me.getNarRemByLink(objs.narRem, rec.get('LINK'));
											if (narRem) narRem[dataIndex] = v;
										}
									});
								}
								return field;
							}
						})
					);

					return res;
				},
				createTBar: function() {
					let tbar = this.callParent(arguments);
					Ext.each(me.getNarRemoveTBar(), function(b) { tbar.unshift(b); }, _, true);
					if (objs.isDisable) {
						objs.btnOpenNarRemove.disable();
						var tbarBtns = this.objs.tbarBtns;
						tbarBtns.delete.disable();
						tbarBtns.galka.disable();
						tbarBtns.unmark.disable();
					}
					return tbar;
				},
				baseGetData: function(callBack) {
					if (callBack) {
						callBack({
							columns: me.getNarRemoveColumns(),
							fields: me.getNarRemoveFields(),
							data: me.getNarRemoveData()
						});
					}
				},
				baseRefresh: function(callBack) { if (callBack) callBack(me.getNarRemoveData()); },
				GateCode: 'edit',
				prefix: 'Plan',
				profileKey: 'NarRemove',
				btnsHide: {
					new: true,
					same: true,
					edit: true,
					search: true,
					treeadd: true
				},
				checkListeners: {
					beforecheckchange: function(th, i, v, r) { return !(!me.docSel || objs.isDisable || (r.get('children') && r.get('children').length)); },
					checkchange: function(th, i, v, r) {
						if (!r.parentNode.isRoot()) {
							var v1 = false;
							Ext.each(r.parentNode.childNodes, function(el) {
								if (el.get('M')) v1 = true;
								return !v1;
							});
							if (r.parentNode.get('M') !== v1) objs.narRemoveDict.checkModelChange(v1, r.parentNode);
						}

						var docRec = me.getDocSel();
						if (docRec) {
							var narRem = JSON.parse(docRec.get('narRem'));
							narRem = me.bindData(
								narRem,
								objs.narRemoveDict.checkList,
								narRem.concat(),
								function(oldList, d) { return ArrayLib.find(oldList, ['LINK_SELF'], d.LINK); },
								function(d) { return { LINK: me.narRemLink--, LINK_SELF: d.LINK }; }
							);
							docRec.set('narRem', JSON.stringify(narRem));
						}
					}
				},
				checkRenderer: function(v, m, r) { if (!me.docSel || objs.isDisable || (r.get('children') && r.get('children').length)) m.tdCls += ' ' + this.disabledCls; },
				functions: {
					delete: function(remList, callback) {
						remList = Ext.Array.filter(objs.narRem, function(el) { return remList.indexOf(el.LINK) !== -1; });
						var len = remList.length;
						if (len) {
							ArrayLib.removeList(objs.narRem, remList);
							me.updActualNarRem();
						}
						callback(len);
					}
				}
			});
		}

		return objs.narRemoveDict;
	},

	getNarRemoveData: function() {
		var d = JSON.parse(JSON.stringify(this.objs.narRem));
		return { data: d, total: d.length };
	},

	//#region список мероприятий по устранению из соответствующего плана устранения

	getPlanNarRemoveColumns: function() {
		var me = this;
		return me.planNarRemoveColumns || (me.planNarRemoveColumns = [
			{
				text: 'Факт нарушения',
				dataIndex: 'FACTNAR',
				columns: [
					{
						text: 'Код',
						flex: 1,
						renderer: function(v, m, r) {
							var factNar = me.getFactNarRec(r.get('FACTNAR'));
							return factNar ? factNar.S_NAR_CODE : _;
						}
					},
					{
						text: 'Вид нарушения',
						flex: 3,
						renderer: function(v, m, r) {
							var factNar = me.getFactNarRec(r.get('FACTNAR'));
							return factNar ? factNar.S_NAR_NAME : _;
						}
					},
					{
						text: 'Сумма<br>нарушения',
						flex: 2,
						renderer: function(v, m, r) {
							var factNar = me.getFactNarRec(r.get('FACTNAR'));
							return factNar ? factNar.SUMMA : _;
						}
					}
				]
			},
			{ text: 'Мероприятия по<br>устранению', dataIndex: 'CONTENT' },
			{
				text: 'Исполнители',
				dataIndex: 'FIO',
				renderer: function(v, m, r) { return getFI(me.getNarRemPersons(r.get('LINK')), 'S_PERSON_'); }
			},
			{
				text: 'Срок<br>устранения',
				dataIndex: 'DTSROK',
				xtype: 'datecolumn',
				format: 'd.m.Y'
			},
			{ text: 'Примечание', dataIndex: 'COMMENT' }
		]);
	},

	getPlanDict: function() {
		var me = this,
			checkList = [];

		Ext.each(me.objs.narRem, function(r) { checkList.push({ LINK: r.LINK_SELF }); });

		return Ext.create('Keysystems.Base.List', {
			title: 'Мероприятия по устранению нарушений',
			code: dnl.DOCREVIZ,
			hidePagging: true,
			pageSize: 100000,
			checkList: checkList,
			baseGetData: function(callBack) {
				if (callBack) {
					callBack({
						columns: me.getPlanNarRemoveColumns(),
						fields: Keysystems.Documents.Edit.Reviz.prototype.getNarRemoveFields(),
						data: me.getPlanNarRemoveData()
					});
				}
			},
			baseRefresh: function(callBack) { if (callBack) callBack(me.getPlanNarRemoveData()); },
			GateCode: 'edit',
			prefix: 'Plan',
			profileKey: 'NarRemoveReport',
			btnsHide: {
				new: true,
				same: true,
				edit: true,
				delete: true,
				search: true
			},
			functions: {
				ok: function(value) {
					var narRem = [],
						dt = Ext.util.Format.date(me.objs.DT.getValue(), 'Y/m/d');
					Ext.each(value, function(v) {
						v = KsLib.objCopy(v.data || v);
						var i = ArrayLib.find(me.objs.narRem, ['LINK_SELF'], v.LINK);
						if (i === -1) {
							v.M = false;
							v.LINK_SELF = v.LINK;
							v.LINK = me.narRemLink--;
							v.children = me.factNarToNarRem(ArrayLib.filter(me.objs.factNar, ['LINK_SELF'], v.FACTNAR), v.LINK_SELF);
							v.leaf = !v.children;
							v.DTDONE = dt;
							delete v.COMMENT2;
						} else {
							v = me.objs.narRem[i];
						}
						narRem.push(v);
					});
					me.objs.narRem = narRem;
					me.updActualNarRem();
					me.getNarRemoveDict().refresh();
				}
			}
		});
	},

	getPlanNarRemoveData: function() {
		var d = JSON.parse(JSON.stringify(this.objs.narRemPlan));
		return { data: d, total: d.length };
	},

	//получение требования на основе нарушения
	factNarToNarRem: function(factRecs, planNarRemLink) {
		var me = this,
			res = [];
		Ext.each(factRecs, function(fr) {
			res.push({
				LINK_SELF: planNarRemLink,
				LINK: me.narRemLink--,
				leaf: true,
				FACTNAR: fr.LINK
			});
		});
		return res;
	},

	//#endregion список мероприятий по устранению из соответствующего плана устранения

	//#endregion Мероприятия по устранению

	//#region Документы

	getDocColumns: function() {
		var me = this;
		return me.docColumns || (me.docColumns = [
			{
				text: 'Вид документа',
				dataIndex: 'S_DOCVID_NAME',
				flex: 1
			},
			{
				text: '№',
				dataIndex: 'NUMBER',
				flex: 1
			},
			{
				text: 'Дата',
				flex: 1,
				dataIndex: 'DT',
				xtype: 'datecolumn',
				format: 'd.m.Y',
				editor: { xtype: 'datefield', format: 'd.m.Y' }
			}
		]);
	},

	getDocFields: function() {
		var me = this;
		return me.docFields || (me.docFields = ['LINK', 'S_DOCVID', 'S_DOCVID_CODE', 'S_DOCVID_NAME', 'DT', 'NUMBER', 'FILES', 'TEMP_EXT', 'narRem', 'T_REVIZ_OBJECTS']);
	},

	getDocSel: function() { return this.getDocGrid().getSelectionModel().getSelection()[0]; },

	getDocTBar: function() {
		var me = this,
			objs = me.objs;
		return objs.docTBar || (objs.docTBar = [
			objs.btnNewDoc = Ext.create('Ext.Button', {
				iconCls: 'x_btn_new',
				tooltip: 'Создать',
				tooltipType: 'title',
				handler: function() { me.docEdit('new'); }
			}),
			objs.btnCopyDoc = Ext.create('Ext.Button', {
				iconCls: 'x_btn_copy',
				tooltip: 'Создать подобную',
				tooltipType: 'title',
				disabled: true,
				handler: function() { me.docEdit('copy'); }
			}),
			objs.btnEditDoc = Ext.create('Ext.Button', {
				iconCls: 'x_btn_edit',
				tooltip: 'Редактировать',
				tooltipType: 'title',
				disabled: true,
				handler: function() { me.docEdit('edit'); }
			}),
			objs.btnDelDoc = Ext.create('Ext.Button', {
				iconCls: 'x_btn_delete',
				tooltip: 'Удалить',
				tooltipType: 'title',
				disabled: true,
				handler: function() { me.getDocGrid().removeSelection(); }
			})
		]);
	},

	getDocGrid: function() {
		var me = this,
			objs = me.objs;

		if (!objs.docGrid) {
			objs.docGrid = Ext.create('Ext.grid.Panel', {
				autoScroll: true,
				autoRender: true,
				columns: me.getDocColumns(),
				tbar: me.getDocTBar(),
				store: Ext.create('Ext.data.Store', {
					fields: me.getDocFields(),
					data: [],
					proxy: 'memory'
				}),
				columnLines: true,
				listeners: {
					itemdblclick: function(th, rec) { me.docEdit('edit', rec); },
					selectionchange: function(th, sels) { me.onDocSelectionChange(sels[0]); }
				},
				flex: 1,
				plugins: ['gridclipboard']
			});
		}

		return objs.docGrid;
	},

	updActualNarRem: function() {
		var me = this,
			narLinks = ArrayLib.getLinks(me.objs.narRem, _, _, 'children');

		me.getDocGrid().store.each(function(rec) {
			var list = rec.get('narRem');
			if (list) {
				list = JSON.parse(list);
				Ext.each(list, function(el, i) { if (narLinks.indexOf(el.LINK_SELF) === -1) list.splice(i, 1); }, _, true);
				rec.set('narRem', JSON.stringify(list));
			}
		});
	},

	docEdit: function(token, rec) {
		var me = this,
			objs = me.objs;
		if (token === 'new') {
			rec = { data: { FILES: 0, TEMP_EXT: '', narRem: '[]' } };
		} else {
			rec = rec || me.getDocSel();
		}
		Ext.create('Keysystems.Documents.Reviz.Report.Edit.Doc', {
			f: token,
			data: rec,
			tro: me.tro,
			planLink: me.linkSelf,
			revizLink: me.revizLink,
			docVidWhereArgs: objs.docVidWhereArgs,

			readOnly: objs.isDisable,

			factNar: objs.factNar,
			narRemReport: objs.narRem,
			narRemPersons: objs.narRemPersons,

			baseSaveData: function(params, callBack) {
				if (!params.link) this.objs.link = params.link = me.docLink--;
				this.oldData = JSON.stringify(params);
				params.LINK = params.link;
				if (token === 'edit') {
					rec.set(params);
				} else {
					rec = me.getDocGrid().store.add(params)[0];
					token = 'edit';
				}

				var list = [];
				Ext.each(JSON.parse(rec.get('narRem')), function(r) { list.push({ LINK: r.LINK_SELF }); });
				me.getNarRemoveDict().setChecks(list);

				this.f = 'edit';
				
				QuickMsgs.save();

				if (callBack) callBack();
			}
		});
	},

	onDocSelectionChange: function(rec) {
		var me = this,
			objs = me.objs;

		if (!objs.isDisable) {
			objs.btnCopyDoc.setDisabled(!rec);
			objs.btnDelDoc.setDisabled(!rec);
		}

		objs.btnEditDoc.setDisabled(!rec);

		var list = [];
		if (rec) Ext.each(JSON.parse(rec.get('narRem')), function(r) { list.push({ LINK: r.LINK_SELF }); });
		me.getNarRemoveDict().setChecks(list);

		me.docSel = rec;
		var grid = me.getNarRemoveDict().Grid;
		//grid.editingPlugin.cancelEdit();
		grid.view.refresh();
	},

	//#endregion Документы

	//конфигурация основого окна
	viewCfg: function() {
		var result = this.callParent(arguments);
		result.resizable = true;
		result.maximizable = true;
		result.minWidth = 600;
		result.minHeight = 300;
		result.width = this.width;
		return result;
	},

	getSaveUrl: function() { return this.linkCode + '/SaveReport_A'; },

	getNarRemByLink: function(source, link) {
		var me = this,
			res;
		Ext.each(source, function(el) {
			if (el.LINK === link) res = el;
			if (!res && el.children) res = me.getNarRemByLink(el.children, link);
			return !res;
		});
		return res;
	},

	getNarRem: function(narRem) {
		var me = this,
			res = [];
		Ext.each(narRem, function(r) {
			r.persons = JSON.stringify(ArrayLib.getLinks(me.getNarRemPersons(r.LINK_SELF), 'S_PERSON'));
			var children;
			if (r.children && r.children.length) {
				r = JSON.parse(JSON.stringify(r));
				children = me.getNarRem(r.children);
				delete r.children;
			}
			res.push(r);
			if (children) res = res.concat(children);
		});
		return res;
	},

	dataCollector: function() {
		var me = this,
			objs = me.objs,
			d = objs.DT.getValue();

		var data = me.callParent([false]);
		if (me.data) {
			var objData = me.data.data;
			data.REVIZ = me.revizLink;
			data.LINK_SELF = me.linkSelf;
			data.NUMBER = objs.NUMBER.getValue();
			data.DT = Ext.isDate(d) ? d.toDateString() : null;
			data.S_STATUS = objs.S_STATUS.getValue();
			data.FILES = objData.FILES;
			data.T_REVIZ_OBJECTS = me.tro;
			data.narRem = JSON.stringify(me.getNarRem(objs.narRem));
			data.docs = JSON.stringify(me.getDocGrid().store.getDataExt());
			data.isVfa = me.isVfa;
		}

		return data;
	},

	getExtra: function(callBack, link) {
		var me = this,
			objs = me.objs;

		if (!me.data) me.data = { data: { FILES: 0, TEMP_EXT: '' } };

		me.baseGetExtra({
			link: link,
			revizLink: me.revizLink,
			planLink: me.linkSelf,
			tro: me.tro,
			isVfa: !!me.isVfa
		}, function(value) {
			if (value.ErrorMsg) {
				showError(value.ErrorMsg);
				me.isExit = true;
				LoadMask.hide();
				return;
			}

			var status = '';
			for (var s in value.statusList) {
				status = s * 1;
				break;
			}
			if (me.readOnly || value.docVid === null || status === '') {
				objs.isDisable = true;
				objs.view.setTitle(me.getReadOnlyTitle());
				objs.NUMBER.disable();
				objs.DT.editable = false;
				objs.S_STATUS.disable();
				objs.saveBtn.disable();

				objs.btnNewDoc.disable();
				objs.btnCopyDoc.disable();
				objs.btnDelDoc.disable();
			}

			me.NAME = value.NAME;
			objs.NUMBER.setValue(value.NUMBER);
			objs.DT.setValue(value.DT ? new Date(value.DT) : _);
			me.data.data.FILES = value.FILES;
			me.data.data.TEMP_EXT = value.tempExt;
			objs.btnFile.setIconCls(getExtStyle(value.tempExt));

			//Статус
			if (value.sStatus) {
				value.statusList[value.sStatus.index] = value.sStatus.value;
				status = value.sStatus.index * 1;
			}
			objs.statusStore.loadData(CBDataLib.get(_, _, value.statusList), false);

			objs.S_STATUS.setValue(status);

			//#region Мероприятия по устранению

			objs.factNar = value.factNar;
			objs.narRem = value.narRem;
			objs.narRemPlan = value.narRemPlan;
			objs.narRemPersons = value.narRemPersons;

			me.getNarRemoveDict(); //.refresh();

			//#endregion Мероприятия по устранению

			//#region Документы

			me.getDocGrid().loadData(value.docs);
			objs.docVidWhereArgs = {
				InLinksOnly: { value: 'True', type: 'bool' },
				InLinks: { value: JSON.stringify(value.docVids), type: 'List_int' }
			};

			//#endregion Документы

			if (callBack) callBack();
		}, me.linkCode + '/GetExtraReport_A');
	},

	profileListeners: [{ name: 'view', method: 'FormParam' }],

	isFilled: function() {
		var me = this,
			c = me.objs.DT,
			d = c.getValue();
		
		let res = true;
		if (!(d && Ext.isDate(d))) {
			me.addToInvalidControls(c);
			res = false;
		}

		var doc;
		me.getDocGrid().store.each(function(rec) {
			var narRem = rec.get('narRem');
			if (!(narRem && JSON.parse(narRem).length)) doc = rec;
			return !doc;
		});
		if (doc) {
			me.errorMessages.push('Необходимо привязать документ');
			res = false;
		}

		return res;
	},
	
	getParamsForCancel: function() {
		let me = this,
			data = me.data.data,
			params = me.callParent(arguments);

		params.revizLink = me.revizLink;

		return params;
	}
});