﻿Ext.define('Keysystems.Documents.Reviz.Report.Edit.Doc', {
	extend: 'Keysystems.Base.Edit',
	title: 'Документы',
	profilePrefix: 'DocumentsRevizReportDoc',
	linkCode: 'SDocumentReviz',
	isFileBtn: true,
	autoheightrowsCls: 'ks-autoheightrows',
	narRemLink: -1,

	viewMinSize: [600, 300],

	createItems: function() {
		var me = this,
			objs = me.objs,
			items = [
				me.createDictEdit({
					key: 'S_DOCVID',
					mode: 'SINGL',
					disabledCls: '',
					listCfg: {
						fileColumn: false,
						btnsHide: { new: true, edit: true, same: true, delete: true }
					},
					//todo проверить под extjs71
					getFieldCfg: function() {
						var res = this.__getFieldCfg();
						res.disabledCls = '';
						return res;
					},
					getTextCfg: function() {
						var res = this.__getTextCfg();
						res.disabledCls = '';
						return res;
					},
					code: dnl.S_DOCVID,
					whereArgs: me.docVidWhereArgs,
					ksAllowEmpty: true,
					fieldLabel: 'Вид документа'
				}),
				Ext.create('Ext.form.FieldContainer', {
					layout: 'hbox',
					items: [
						objs.NUMBER = Ext.create('Ext.form.field.Text', {
							//width: 130,
							labelWidth: me.labelWidth,
							disabledCls: '',
							fieldLabel: '№',
							maxLength: 25,
							enforceMaxLength: true
						}),
						//'->',
						objs.DT = Ext.create('Ext.form.field.Date', {
							width: 130,
							padding: '0 0 0 20',
							disabledCls: '',
							labelWidth: 30,
							ksAllowEmpty: true,
							allowEmpty: false,
							//editable: false,
							fieldLabel: 'от'
						}) /*,
						'->',
						objs.S_STATUS = Ext.create('Ext.form.field.ComboBox', {
							editable: false,
							value: 0,
							queryMode: 'local',
							fieldLabel: 'Статус',
							labelWidth: 80,
							displayField: CBDataLib.displayField,
							valueField: CBDataLib.valueField,
							store: objs.statusStore = Ext.create('Ext.data.Store', {
								fields: CBDataLib.getFields(),
								data: [],
								proxy: 'memory'
							})
						})*/
					]
				}),
				Ext.create('Ext.form.FieldSet', {
					title: 'Мероприятия по устранению',
					collapsible: true,
					layout: { type: 'vbox', align: 'stretch' },
					flex: 1,
					items: [me.getNarRemoveGrid()]
				})
			];

		return me.callParent([items]);
	},

	//{Документ.Вид.Имя}+' № '+ {Документ.Номер} + ' от ' + ДАТАПРОП({Документ.Дата},4)
	getFileName: function() {
		var me = this,
			objs = me.objs,
			docvid = objs.S_DOCVID.getValue()[0],
			d = objs.DT.getValue();
		return Ext.String.format('{0} № {1} от {2}', docvid ? (docvid.data || docvid).NAME : '', objs.NUMBER.getValue(), Ext.isDate(d) ? Ext.Date.format(d, 'd_m_Y') : d);
	},

	fileEdit: function() {
		var me = this,
			objs = me.objs;
		if (objs.isDisable) {
			me.downloadFile();
		} else {
			me.callParent();
		}
	},

	//#region Мероприятия по устранению

	getFactNarRec: function(factNar) { return ArrayLib.filter(this.factNar, ['LINK'], factNar)[0]; },

	getNarRemReportRec: function(link, source) {
		var me = this,
			res;
		Ext.each(source || me.narRemReport, function(el) {
			if (el.LINK === link) res = el;
			if (!res && el.children) res = me.getNarRemReportRec(link, el.children);
			return !res;
		});
		return res;
	},

	getNarRemoveVal: function(field) {
		var r = field.ownerCt && field.ownerCt.context ? this.getNarRemReportRec(field.ownerCt.context.record.get('LINK_SELF')) : _;
		return r ? r[field.column.dataIndex] : _;
	},

	getNarRemoveColumns: function() {
		var me = this;
		return me.narRemoveColumns || (me.narRemoveColumns = [
			{
				text: 'Факт нарушения',
				dataIndex: 'FACTNAR',
				columns: [
					{
						text: 'Код',
						flex: 1,
						renderer: function(v, m, r) {
							r = me.getNarRemReportRec(r.get('LINK_SELF'));
							if (r) {
								var factNar = me.getFactNarRec(r.FACTNAR);
								if (factNar) return factNar.S_NAR_CODE;
							}
							return _;
						}
					},
					{
						text: 'Вид нарушения',
						flex: 3,
						renderer: function(v, m, r) {
							r = me.getNarRemReportRec(r.get('LINK_SELF'));
							if (r) {
								var factNar = me.getFactNarRec(r.FACTNAR);
								if (factNar) return factNar.S_NAR_NAME;
							}
							return _;
						}
					},
					{
						text: 'Сумма<br>нарушения',
						flex: 2,
						renderer: function(v, m, r) {
							r = me.getNarRemReportRec(r.get('LINK_SELF'));
							if (r) {
								var factNar = me.getFactNarRec(r.FACTNAR);
								if (factNar) return factNar.SUMMA;
							}
							return _;
						}
					}
				]
			},
			{
				text: 'Срок<br>устранения',
				dataIndex: 'DTSROK',
				renderer: function(v, m, r) {
					r = me.getNarRemReportRec(r.get('LINK_SELF'));
					return r && r.DTSROK ? Ext.Date.format(new Date(r.DTSROK), 'd.m.Y') : '';
				},
				viewer: {
					xtype: 'datefield',
					editable: false,
					setValue: function() { this.__setValue(me.getNarRemoveVal(this)); },
					getValue: function() { return me.getNarRemoveVal(this); }
				}
			},
			{
				text: 'Мероприятия по<br>устранению',
				dataIndex: 'CONTENT',
				renderer: function(v, m, r) {
					r = me.getNarRemReportRec(r.get('LINK_SELF'));
					return r ? r.CONTENT : '';
				},
				viewer: {
					xtype: 'triggertexteditor',
					editable: false,
					getEditorTitle: function() { return this.column.text; },
					setValue: function() { this.__setValue(me.getNarRemoveVal(this)); },
					getValue: function() { return me.getNarRemoveVal(this); }
				}
			},
			{
				text: 'Исполнители',
				dataIndex: 'FIO',
				renderer: function(v, m, r) {
					r = me.getNarRemReportRec(r.get('LINK_SELF'));
					return r ? getFI(me.getNarRemPersons(r.LINK_SELF), 'S_PERSON_') : '';
				},
				viewer: {
					xtype: 'trigger',
					triggerBaseCls: 'x-dict-trigger',
					triggerCls: 'x_btn_dict',
					triggerWidth: 22,
					editable: false,
					setValue: function(v) {
						var r = this.ownerCt && this.ownerCt.context ? me.getNarRemReportRec(this.ownerCt.context.record.get('LINK_SELF')) : _;
						this.__setValue(r ? getFI(me.getNarRemPersons(r.LINK_SELF), 'S_PERSON_') : v);
					},
					getValue: function() { return ''; },
					onTriggerClick: function() {
						var r = this.ownerCt && this.ownerCt.context ? me.getNarRemReportRec(this.ownerCt.context.record.get('LINK_SELF')) : _;
						if (!r) return;
						dictFunc({
							parentView: me,
							checkModel: false,
							inputDicts: [Ext.create('InputEditDict', { name: 'S_ORG', data: [user.org] })],
							whereArgs: {
								InLinksOnly: { value: 'True', type: 'bool' },
								InLinks: {
									value: ArrayLib.getLinks(me.getNarRemPersons(r.LINK_SELF), 'S_PERSON', 1),
									type: 'List_int'
								}
							},
							code: dnl.S_PERSON
						});
					}
				}
			},
			{
				text: 'Примечание',
				dataIndex: 'COMMENT',
				renderer: function(v, m, r) {
					r = me.getNarRemReportRec(r.get('LINK_SELF'));
					return r ? r.COMMENT : '';
				},
				viewer: {
					xtype: 'triggertexteditor',
					editable: false,
					getEditorTitle: function() { return this.column.text; },
					setValue: function() { this.__setValue(me.getNarRemoveVal(this)); },
					getValue: function() { return me.getNarRemoveVal(this); }
				}
			},
			{
				text: 'Результат',
				dataIndex: 'RESULT',
				renderer: function(v, m, r) {
					r = me.getNarRemReportRec(r.get('LINK_SELF'));
					return r ? r.RESULT : '';
				},
				viewer: {
					xtype: 'triggertexteditor',
					editable: false,
					getEditorTitle: function() { return this.column.text; },
					setValue: function() { this.__setValue(me.getNarRemoveVal(this)); },
					getValue: function() { return me.getNarRemoveVal(this); }
				}
			}
		]);
	},

	getNarRemPersons: function(link) { return ArrayLib.filter(this.narRemPersons, ['NARREMOVE'], link); },

	getNarRemoveFields: Keysystems.Documents.Reviz.Report.Edit.prototype.getNarRemoveFields,

	getNarRemoveTBar: function() {
		var me = this,
			objs = me.objs;
		return objs.narRemoveTBar || (objs.narRemoveTBar = [
			objs.btnOpenNarRemove = Ext.create('Ext.Button', {
				iconCls: 'x_btn_open',
				tooltip: 'Выбрать',
				tooltipType: 'title',
				handler: function() { me.getPlanDict(); }
			}),
			objs.btnDelNarRemove = Ext.create('Ext.Button', {
				iconCls: 'x_btn_delete',
				tooltip: 'Удалить',
				tooltipType: 'title',
				disabled: true,
				handler: function() { me.getNarRemoveGrid().removeSelection(); }
			}),
			Ext.create('Ext.Button', {
				iconCls: 'x_btn_wrap',
				tooltip: wmc.get('Wrap'),
				tooltipType: 'title',
				handler: function() {
					var grid = me.getNarRemoveGrid(),
						warp = this;
					if (grid.autoheightrows) {
						grid.removeCls(me.autoheightrowsCls);
						warp.setIconCls('x_btn_wrap');
						warp.setTooltip(wmc.get('Wrap'));
					} else {
						grid.addClass(me.autoheightrowsCls);
						warp.setIconCls('x_btn_nonwrap');
						warp.setTooltip(wmc.get('NonWrap'));
					}
					grid.autoheightrows = !grid.autoheightrows;
				}
			})
		]);
	},

	getNarRemoveGrid: function() {
		var me = this,
			objs = me.objs;

		if (!objs.NARREMOVE) {
			objs.NARREMOVE = Ext.create('Ext.grid.Panel', {
				autoScroll: true,
				autoRender: true,
				//plugins: [Ext.create('Keysystems.grid.plugin.RowEditing', { readOnly: true })],
				columns: me.getNarRemoveColumns(),
				tbar: me.getNarRemoveTBar(),
				store: Ext.create('Ext.data.Store', {
					fields: me.getNarRemoveFields(),
					data: [],
					sorters: [{ property: 'FACTNAR', direction: 'ASC' }],
					proxy: 'memory'
				}),
				columnLines: true,
				flex: 1,
				listeners: {
					selectionchange: function(th, sels) { me.onNarRemoveSelectionChange(sels[0]); }
				},
				plugins: ['gridclipboard']
			});

			Ext.each(me.getNarRemoveGrid().getColumnManager().getColumns(), function(col) { col.flex = col.dataIndex === 'FACTNAR' ? 3 : 1; });
		}

		return objs.NARREMOVE;
	},

	onNarRemoveSelectionChange: function(rec) {
		var me = this,
			objs = me.objs;

		if (!objs.isDisable) objs.btnDelNarRemove.setDisabled(!rec);
	},

	//#region список мероприятий по устранению из соответствующего плана устранения

	getPlanNarRemoveColumns: function() {
		var me = this;
		return me.planNarRemoveColumns || (me.planNarRemoveColumns = [
			{
				text: 'Факт нарушения',
				dataIndex: 'FACTNAR',
				columns: [
					{
						text: 'Код',
						flex: 1,
						renderer: function(v, m, r) {
							var factNar = me.getFactNarRec(r.get('FACTNAR'));
							return factNar ? factNar.S_NAR_CODE : _;
						}
					},
					{
						text: 'Вид нарушения',
						flex: 3,
						renderer: function(v, m, r) {
							var factNar = me.getFactNarRec(r.get('FACTNAR'));
							return factNar ? factNar.S_NAR_NAME : _;
						}
					},
					{
						text: 'Сумма<br>нарушения',
						flex: 2,
						renderer: function(v, m, r) {
							var factNar = me.getFactNarRec(r.get('FACTNAR'));
							return factNar ? factNar.SUMMA : _;
						}
					}
				]
			},
			{ text: 'Мероприятия по<br>устранению', dataIndex: 'CONTENT' },
			{
				text: 'Исполнители',
				dataIndex: 'FIO',
				renderer: function(v, m, r) { return getFI(me.getNarRemPersons(r.get('LINK')), 'S_PERSON_'); }
			},
			{
				text: 'Срок<br>устранения',
				dataIndex: 'DTSROK',
				xtype: 'datecolumn',
				format: 'd.m.Y'
			},
			{ text: 'Примечание', dataIndex: 'COMMENT' }
		]);
	},

	getPlanDict: function() {
		var me = this;
		return Ext.create('Keysystems.Base.List.Tree', {
			title: 'Мероприятия по устранению нарушений',
			code: dnl.DOCREVIZ,
			hidePagging: true,
			pageSize: 100000,
			checkList: me.getNarRemoveGrid().store.getDataExt(function(r) { return { LINK: r.LINK_SELF }; }),
			baseGetData: function(callBack) {
				if (callBack) {
					callBack({
						columns: Keysystems.Documents.Reviz.Report.Edit.prototype.getNarRemoveColumns.call(me),
						fields: Keysystems.Documents.Reviz.Report.Edit.prototype.getNarRemoveFields(),
						data: me.getPlanNarRemoveData()
					});
				}
			},
			baseRefresh: function(callBack) { if (callBack) callBack(me.getPlanNarRemoveData()); },
			GateCode: 'edit',
			prefix: 'Plan',
			profileKey: 'NarRemoveReport',
			btnsHide: {
				new: true,
				same: true,
				edit: true,
				delete: true,
				search: true
			},
			checkListeners: { beforecheckchange: function(th, i, v, r) { return !(objs.isDisable || (r.get('children') && r.get('children').length)); } },
			checkRenderer: function(v, m, r) { if (objs.isDisable || (r.get('children') && r.get('children').length)) m.tdCls += ' ' + this.disabledCls; },
			functions: {
				ok: function(value) {
					var narRem = [],
						grid = me.getNarRemoveGrid();
					Ext.each(value, function(v) {
						v = v.data || v;
						var i = grid.store.find('LINK_SELF', v.LINK);
						if (i === -1) {
							v = {
								LINK_SELF: v.LINK,
								LINK: me.narRemLink--
							};
						} else {
							v = grid.store.getAt(i).getData();
						}
						narRem.push(v);
					});
					grid.loadData(narRem);
				}
			}
		});
	},

	getPlanNarRemoveData: function() {
		var d = JSON.parse(JSON.stringify(this.narRemReport));
		return { data: d, total: d.length };
	},

	//#endregion список мероприятий по устранению из соответствующего плана устранения

	//#endregion Мероприятия по устранению

	//конфигурация основого окна
	viewCfg: function() {
		var result = this.callParent(arguments);
		result.resizable = true;
		result.maximizable = true;
		result.minWidth = 600;
		result.minHeight = 300;
		result.width = this.width;
		return result;
	},	
	
	dataCollector: function() {
		var me = this,
			objs = me.objs,
			data = me.callParent([false]),
			d = objs.DT.getValue(),
			docVid = objs.S_DOCVID.getValue()[0];

		if (docVid) {
			docVid = docVid.data || docVid;
			data.S_DOCVID = docVid.LINK;
			data.S_DOCVID_CODE = docVid.CODE;
			data.S_DOCVID_NAME = docVid.NAME;
		}

		data.T_REVIZ_OBJECTS = me.tro;
		data.NUMBER = objs.NUMBER.getValue();
		data.DT = Ext.isDate(d) ? d.toDateString() : null;
		data.FILES = me.data.data.FILES;
		data.TEMP_EXT = me.data.data.TEMP_EXT;
		data.narRem = JSON.stringify(me.getNarRemoveGrid().store.getDataExt(function(r) {
			r.persons = JSON.stringify(ArrayLib.getLinks(me.getNarRemPersons(r.LINK_SELF), 'S_PERSON'));
			return r;
		}));

		return data;
	},

	loadData: function() {
		var me = this,
			objs = me.objs,
			data = me.data.data;
		if (me.f !== 'edit') {
			data.FILES = 0;
			data.TEMP_EXT = '';
		}

		if (me.readOnly) {
			objs.isDisable = true;
			objs.view.setTitle(me.getReadOnlyTitle());

			objs.S_DOCVID.disable();
			objs.NUMBER.disable();
			objs.DT.editable = false;
			objs.saveBtn.disable();

			objs.btnOpenNarRemove.disable();
			objs.btnDelNarRemove.disable();
		}

		objs.S_DOCVID.setValue({ LINK: data.S_DOCVID, CODE: data.S_DOCVID_CODE, NAME: data.S_DOCVID_NAME });
		objs.NUMBER.setValue(data.NUMBER);
		objs.DT.setValue(data.DT ? new Date(data.DT) : _);
		objs.btnFile.setIconCls(getExtStyle(data.TEMP_EXT));

		objs.narRemPersons = me.getNarRemPersons;
		objs.factNar = me.factNar;
		var narRem = data.narRem ? JSON.parse(data.narRem) : [];

		me.getNarRemoveGrid().loadData(narRem);

		me.callParent(arguments);
	},

	profileListeners: [{ name: 'view', method: 'FormParam' }],

	isFilled: function() {
		var objs = this.objs,
			c = objs.DT,
			d = c.getValue();
		
		let res = true;
		if (!(d && Ext.isDate(d))) {
			me.addToInvalidControls(c);
			res = false;
		}
		if (objs.S_DOCVID.isEmpty()) {
			me.addToInvalidControls(objs.S_DOCVID);
			res = false;
		}
		return res;
	},

	getExtra: function(callback) { KsLib.tryRun(callback); }
});