﻿Ext.define('Keysystems.Documents.List', {
	extend: 'Keysystems.Base.List.Tree',
	iconCls: 'x_btn_document',
	startYear: new Date().getFullYear(),
	btnsHide: { 'new': true, 'same': true, 'add_slave': true},
	bodyPadding: 10,
	labelWidth: 150,
	title: 'Документы',
	code: 'DOCUMENTS',
	deleteCode: 'DOCUMENTS',
	profileListeners: [
		{ name: 'holdingPeriod', method: 'KsPeriodChange' },
		{ name: 'S_TASK', method: 'ksDictChange' },
		{ name: 'S_DOCVID', method: 'ksDictChange' }
	],
	fileColumn: true,
	createGridTBar: function() {
		var res = this.callParent(arguments);
		if (res[0]) res[0].hide();
		return _;
	},
	createGridListeners: function() {
		const me = this;
		me.callParent(arguments);
		me.objs.gridListeners.afteritemexpand = function (node){
			if (!node.childNodes?.length) return;
			const colTree = this.headerCt?.getGridColumns().filter(col => col.dataIndex === 'tree')[0];
			colTree?.autoSize();
		}
		me.objs.gridListeners.afteritemcollapse = function (){
			const colTree = this.headerCt?.getGridColumns().filter(col => col.dataIndex === 'tree')[0];
			colTree?.autoSize();
		}
	},
	getFileId: function(rec) { return rec.get('TEMP_EXT'); },
	setWhereArgs: function() {
		var me = this,
			objs = me.objs,	
			sTask = objs.S_TASK.getLinks() || [],
			sDocVid = objs.S_DOCVID.getLinks() || [],
			dRev = objs.holdingPeriod.getValue(),
			dMoney = objs.checkingPeriod.getValue(),
			whereArgs = {
				DRBegin: {
					value: dRev.dh1,
					type: 'Date'
				},
				DREnd: {
					value: dRev.dh2,
					type: 'Date'
				},
				DBeginMoney: {
					value: dMoney.dh1,
					type: 'Date'
				},
				DEndMoney: {
					value: dMoney.dh2,
					type: 'Date'
				},
				STasks: {
					value: JSON.stringify(sTask),
					type: 'List_int'
				},
				DocVid: {
					value: JSON.stringify(sDocVid),
					type: 'List_int'
				}
			};

		if (me.isVfa)
			whereArgs.SWorks = {
				value: JSON.stringify(me.SWorks || []),
				type: 'List_int'
			};

		me.afterSetWhereArgs && me.afterSetWhereArgs(whereArgs);

		return Ext.apply(me.whereArgs, whereArgs);
	},
	initializeFilter: function (){
		let me = this;
		if (!me.whereArgs) return;

		me.updateDateFromWhereArg(me.whereArgs.DRBegin.value, me.whereArgs.DREnd.value, me.objs.holdingPeriod);
		me.updateDateFromWhereArg(me.whereArgs.DBeginMoney.value, me.whereArgs.DEndMoney.value, me.objs.checkingPeriod);

		if (me.whereArgs.DocVid) {
			me.updateDictFromWhereArg(me.whereArgs.DocVid, me.objs.S_DOCVID);			
		}

		if (me.whereArgs.DFRegistered) {
			me.objs.S_DOCVID.setDisabled(+JSON.parse(me.whereArgs.DFRegistered.value) !== 0);
		}
	},
	beforeSetData: function (data, params) {
		const me = this;
		const res = me.callParent(arguments);
		me.sksd('EDSSaveDocBehavior', data.EDSSaveDocBehavior);
		return res;
	},

	columnsAdapted: function (columns) {
		let me = this,
			c = ArrayLib.find(columns, ['dataIndex'], 'HAS_DF_DOCUMENTS');

		if (c !== -1) {
			columns[c] = {
				xtype: 'actioncolumn',
				dataIndex: 'IMG_DF_RELATION_NEED',
				align: 'center',
				width: 150,
				text: 'Документооборот',
				tdCls: 'rks-action-col-noaction-td',
				items: [
					{
						getClass: function (v, meta, rec) {
							return rec.get('HAS_DF_DOCUMENTS') ? 'x_btn_message_new' : '';
						},
					}
				]
			};
		}
		return me.callParent([columns]);
	},
	
	/**Task Revizor.Reviz.AlienEdit	 
	 */
	doEditReviz: function() {
		let me = this,
			rec = me.objs.Grid.getFrstSelect();
		if (!rec) return;
		
		const modalEdit = me.isModalEdit();
		let cfg = {
				f: 'edit',
				data: { data: { LINK: rec.data.REVIZ } },
				code: dnl.REVIZ,
				refreshFunc: function() { me.refresh(); },
				tabMode: !modalEdit,
				parentView: modalEdit ? me.objs.view : me.parentView,
		};
		Ext.apply(cfg, dictListController.DOCUMENT_REVIZ);
		Ext.create(cfg.editClass, cfg);
	},
	createItems: function() {
		var me = this,
			objs = me.objs,
			items = me.callParent(arguments);
		me.isCreate = true;
		items.unshift(Ext.create('Ext.panel.Panel', {
			collapsible: true,
			title: 'Фильтр по Документам',
			userCls: 'rks-filter-panel',
			border: 0,
			bodyBorder: 0,
			layout: { type: 'vbox', align: 'stretch' },
			bodyPadding: me.bodyPadding + ' ' + me.bodyPadding + ' 0 ' + me.bodyPadding,
			animCollapse: false,
			items: [
				Ext.create('Ext.form.FieldContainer', {
					layout: { type: 'hbox', align: 'stretch' },
					items: [
						objs.holdingPeriod = Ext.create('Keysystems.Controls.KsPeriod', {
							startYear: me.startYear,
							state: 4,
							allStates: 12,
							width: 400,
							listeners: {
								ksChange: function () {
									if (me.isLoading) return;
									me.setDate();
								}
							}
						}),
						objs.S_TASK = Ext.create('Keysystems.Controls.Dict.Edit', {
							fieldLabel: 'Регламенты',
							labelWidth: 120,
							flex: 1,
							padding: '0 10 0 10',
							mode: 'MULTI',
							clear: function() {
								this._setValue();
								me.refresh();
							},
							_setValue: function(value) {
								if (me.isLoading) return;
								this.setValue(value);
								me.setWhereArgs();
							},
							handler: function() {
								dictFunc({
									mode: 'MULTI',
									parentView: objs.view,
									selectLinks: objs.S_TASK.getValue(),
									code: dnl.S_TASK,
									control: objs.S_TASK,
									contextSearch: objs.S_TASK.contextSearch
								}, {
									ok: function(value) {
										objs.S_TASK._setValue(value);
										me.refresh();
									}
								});
							}
						})
					]
				}),
				Ext.create('Ext.form.FieldContainer', {
					layout: { type: 'hbox', align: 'stretch' },
					items: [
						objs.checkingPeriod = Ext.create('Keysystems.Controls.KsPeriod', {
							startYear: me.startYear,
							allStates: 12,
							width: 400,
							hidden: !(window.user && window.user.isFinanc),
							fieldLabel: 'Проверяемый период',
							listeners: {
								ksChange: function () {
									if (me.isLoading) return;
									me.setDate();
								}
							}
						}),
						objs.S_DOCVID = Ext.create('Keysystems.Controls.Dict.Edit', {
							fieldLabel: 'Виды документов',
							labelWidth: (window.user && window.user.isFinanc) ? 120 : me.labelWidth,
							flex: 1,
							padding: (window.user && window.user.isFinanc) ? '0 10 0 10' : '',
							mode: 'MULTI',
							clear: function() {
								this._setValue();
								me.refresh();
							},
							_setValue: function(value) {
								if (me.isLoading) return;
								this.setValue(value);
								me.setWhereArgs();
							},
							handler: function() {
								dictFunc({
									mode: 'MULTI',
									parentView: objs.view,
									selectLinks: objs.S_DOCVID.getValue(),
									code: dnl.S_DOCVID,
									control: objs.S_DOCVID,
									contextSearch: objs.S_DOCVID.contextSearch
								}, {
									ok: function(value) {
										objs.S_DOCVID._setValue(value);
										me.refresh();
									}
								});
							}
						})
					]
				})
			]
		}));

		objs.Year = objs.holdingPeriod.Quarter.holdingYear;
		objs.Quarter = objs.holdingPeriod.Quarter.holdingQuarter;
		me.isCreate = false;

		return items;
	},
	setDate: function() {
		var me = this;
		me.setWhereArgs();
		me.refresh();
	},
	getRowClass: function(record) {
		var rowStyle = 'ks-document ks-document-list ';
		if (!record.data.DTUTV) {
			var sDtEnd = record.data.DTEND;
			rowStyle += (sDtEnd && (Ext.Date.clearTime(new Date(sDtEnd)) >= Ext.Date.clearTime(new Date()))
				? 'ks-notOverdue'
				: 'ks-overdue');
		}
		return rowStyle;
	},

	beforeDeleteFn (endFunc, sels) {
		let isContainsFile;

		Ext.each(sels, function (rec) {
			if (!isContainsFile) {
				isContainsFile = !!rec.data.TEMP_EXT;
			}
		});
		
		if (isContainsFile) {
			ChooseBox.ShowHTML({
				text: 'У удаляемого документа есть прикрепленные файлы во вкладке "Файлы"',
				warnOrErrorIcon: true,
				hasIgnoreButton: true,
				nextFn: function() {
					endFunc();
				}
			});
		} else {
			endFunc();
		}
	},
	getGridCfg: function(){
		let res = this.callParent(arguments);
		res.userCls = 'rks-grid-with-filter-panel';
		res.autoSizeOnExpandCollapse = false;
		return res;
	},

	sign: async function() {
		const me = this;
		const sels = me.objs.Grid.getSelectionModel().getSelection();
		if (!sels.length) return;
		const result = await me.signAsync(sels.map(sel => sel.data));
		if (result) {
			me.afterSignCompleted(result.doc);
			me.afterFileSignCompleted(result.files);
		}
	},
	signAsync: async function(data, fromEditMode) {
		const me = this;
		const links = data.map(r => r.LINK);
		let files = [];

		const hasFiles = data.filter(r => r.FILES).length;
		if (hasFiles) {
			const res = await selectDialogShowAsync(KS.L10n.attention, "Подписать вложения?");
			if (res !== "yes" && res !== "no") return;

			if (res === "yes") {
				files = await ajaxRequestAsync({
					params: {links: JSON.stringify(links), code: "DOCUMENTS"},
					url: 'SDocuments/GetFilesByDocs_A'
				});
			}
		}

		const serviceModule = Ext.create('Keysystems.EDSServiceModule');
		const responseDoc = await serviceModule.executeAsync({
			code: "DOCUMENTS",
			links: links,
			mode: 'EDS_SET',
			target: me.getLoadMaskTarget(),
			silentMode: true,
			fromEditMode: fromEditMode,
		});
		if (!responseDoc) return;

		let responseFiles = null;
		if (files?.length) {
			responseFiles = await serviceModule.executeAsync({
				code: "FILES",
				links: files,
				mode: 'EDS_SET',
				target: me.getLoadMaskTarget(),
				silentMode: true,
				fromEditMode: fromEditMode,
				certData: responseDoc.certData
			});
		}

		const cfg = {
			text: responseDoc.htmlProtocol,
			title: KS.L10n["BaseRevizorPresenter_OnSignCompleted_Протокол_выполнения"],
			hasIgnoreButton: false,
			noPreStyle: true,
			width: 800,
			height: 600
		};
		ChooseBox.ShowHTMLLog(cfg);

		return {doc: responseDoc, files: responseFiles};
	},
	
	unSign: async function() {
		const me = this;
		const sels = me.objs.Grid.getSelectionModel().getSelection();
		const data = sels.map(sel => sel.data);
		const result = await me.unSignAsync(data);
		if (result) {
			me.afterSignCompleted(result.doc);
			me.afterFileSignCompleted(result.files);
		}
	},
	unSignAsync: async function(data, fromEditMode) {
		const me = this;
		if (!data || !data.length) return;

		const hasFiles = data.filter(r => r.FILES).length;
		const links = data.map(r => r[me.fieldLink]);
		let dialogResult;
		let files = [];
		if (hasFiles) {
			dialogResult = await dialogShowAsync({
				msg: KS.L10n.ListTasks_UnSign_Снять_ЭП,
				title: KS.L10n.attention,
				buttons: Ext.MessageBox.YESNOCANCEL,
				buttonText: {
					yes: data.length > 1 ? KS.L10n.DocumentsTasks_ShowDocUnSignMessage_Документ : KS.L10n.DocumentsTasks_ShowDocUnSignMessage_Документы,
					no: Ext.String.format(KS.L10n.DocumentsTasks_ShowDocUnSignMessage_Документы_и_вложения, data.length > 1 ? KS.L10n.DocumentsTasks_ShowDocUnSignMessage_Документ : KS.L10n.DocumentsTasks_ShowDocUnSignMessage_Документы),
					cancel: KS.L10n.Нет
				},
			});
			if (dialogResult !== "yes" && dialogResult !== "no") return;

			if (dialogResult === "no") {
				files = await ajaxRequestAsync({
					params: {links: JSON.stringify(links), code: "DOCUMENTS"},
					url: 'SDocuments/GetFilesByDocs_A'
				});
			}
			
		} else {
			dialogResult = await selectDialogShowAsync(KS.L10n.attention, KS.L10n.ListTasks_UnSign_Снять_ЭП, 'no');
			if (dialogResult !== "yes") return;
		}

		const processFiles = dialogResult !== "yes";

		const serviceModule = Ext.create('Keysystems.EDSServiceModule', {
			target: me.getLoadMaskTarget(),
			mode: 'EDS_DELETE'
		});
		const responseDoc = await serviceModule.executeAsync({
			code: 'DOCUMENTS',
			links: links,
		});
		
		let responseFiles = null;
		if (processFiles && files.length){
			responseFiles = await serviceModule.executeAsync({
				code: 'FILES',
				links: files,
				silentMode: true
			});
		}
		return {doc: responseDoc, files: responseFiles};
	},

	/**
	 * Можно ли редактировать файл в колонке Файл
	 * @param rec
	 * @returns {boolean}
	 */
	getFileReadOnly: function (rec) {
		const me = this;
		const data = (rec.data || rec);
		if (data.EDS_DATE && me.gksd('EDSSaveDocBehavior') >= 2) {
			return true;
		}
		if (data.EDS_FILES && me.gksd('EDSSaveDocBehavior') === 3) {
			return true;
		}
		return false;
	},

	/**
	 * Выполнить после подписи файлов из списка докумемнтов (для варианта "подписать вложения" - "да")
	 * @param response
	 */
	afterFileSignCompleted: function (response) {
		const me = this;
		if (!response?.rows) return;
				
		response.rows.forEach(row => {
			const rowUpd = { IS_FILES : true };
			Object.assign(rowUpd, row);
			rowUpd.EDS_FILES = row.EDS_DATE ? 1 : 0;
			me.updateRecord(rowUpd);
		});		
	},

	/**
	 * Обновить запись списка
	 * @param row
	 */
	updateRecord: function(row){
		const me = this;
		if (row.IS_FILES) {
			const store = me.Grid.getStore();
			const rowDoc = store.findNode
				? store.findNode('FILES', (row.data || row).LINK)
				: store.findRecord('FILES', (row.data || row).LINK);
			if (rowDoc) {
				row.LINK = rowDoc.get('LINK');
				rowDoc.set(row);
			}
			return;
		}
		me.callParent(arguments);
	},
});