﻿Ext.define('Keysystems.Documents.Edit', {
	extend: 'Ext.tab.Panel',
	mixins: ['Keysystems.Base.Edit'],	
	title: 'Документы',
	isWindow: true,
	labelWidth: 170,
	flex: 1,
	responsLink: -1,
	narRemoveLink: -1,
	measureLink: -1,
	docMailLink: -1,
	isFileBtn: true,
	fieldName: 'NUMBER',
	code: 'DOCUMENTS',
	readOnly: false,
	sRDocLink: -1,
	bodyPadding: 0,
	linkCode: 'SDocuments',
	fieldExt: 'EXTENTION',
	fieldMain: 'MAIN',
	userCls: 'rks-panel-edit',
	bodyCls: 'rks-panel-edit-body',

	tabMappings: {
		'COMMON':'General',
		'DOCPROP': 'Prop',
		'DOCMAIL': 'DocMail',
		'DOCREQUEST': 'DocRequest',
		'NARREMOVE': 'NarRemove',
		'SUMMS':'FactNar'
	},
	batchProcess: false,
	constructor: function(cfg){
		Ext.apply(this, cfg);
		this.callParent(arguments);
	},
	initComponent: function() {
		var me = this;

		me.beforeInitComponent();
		me.baseInitComponent();

		me.callParent(arguments);

		me.afterInitComponent();
	},

	initKsData: function(data) {
		data.NAR_RESPONS_VALUES = {};
	},

	initKsControls: function(ksControls) { ksControls.allTab = this; },
	initEvents: function () {
		var me = this;
		me.callParent(arguments);

		me.on('tabchange', function (th, newTab, oldTab) {
			var notNew = th.ksData.link > 0,
				tab = (th.ksControls || th.objs)[th.getTabKey('DocRequest')];
			if (!notNew && tab && newTab === tab) {
				// при создании документа не даем перейти во вкладку, пока не сохраним документ
				warning(KS.L10n.DocumentsEditView_tcAll_ActiveTabChanged_Необходимо_сохранить_документ_);
				th.setActiveTab(oldTab);
			}
		});
	},
	loadNewData: function () {
		this.setLink(0);
	},
	createItems: function() {
		var me = this,
			objs = me.objs,
			ksControls = me.ksControls;

		objs.personTab = Ext.create('Ext.panel.Panel', {
			title: 'Участники',
			hidden: true,
			layout: { type: 'vbox', align: 'stretch' },
			items: [
				ksControls.ATTENDEE = objs.ATTENDEE = Ext.create('Ext.form.CheckboxGroup', {
					width: me.width,
					height: 400,
					columns: 1,
					padding: 5
				})
			]
		});

		return objs.items = [];
	},
	viewMinSize: [700, 450],
	profileListeners: [{ name: 'view', method: 'FormParam' }],

	createTBar: function () {
		const me = this;
		const tbar = this.callParent(arguments);

		me.btnSign = Ext.create('Ext.Button', {
				disabled: false,
				hidden: !window.useEDS,
				key: 'sign',
				iconCls: 'x_btn_document_protect',
				menu: [
					{
						text: 'Электронная подпись',
						iconCls: 'x_btn_document_protect',
						handler: function () {
							const serviceModule = Ext.create('Keysystems.EDSServiceModule', {
								target: me.parentView,
								code: "DOCUMENTS",
								links: [me.getLink()],
								code_eds_list: "DOCUMENTS_EDS_LIST",
								mode: 'SIGN_LIST',
								modal: window.modalEdit || me.parentView !== window.tabView
							});
							serviceModule.execute();
						}
					},
					{
						text: 'Печать информации об ЭЦП',
						iconCls: 'x_btn_protocol',
						handler: function () {
							const serviceModule = Ext.create('Keysystems.EDSServiceModule', {
								target: me.getLoadMaskTarget(),
								code: "DOCUMENTS",
								links: [me.getLink()],
								mode: 'SIGNATURE_INFO_PROTOCOL'
							});
							serviceModule.execute();
						}
					},
					{ xtype: 'menuseparator', hidden: true },
					me.subBtnSign = Ext.create('Ext.Action', {
						text: 'Подписать',
						iconCls: 'x_btn_sign',
						handler: async function () {
							const saved = await me.saveMessageShowAsync();
							if (!saved) return;
							
							const files = me.gksd('Files');
							const data = [{LINK: me.getLink(), FILES: files?.length ? files[0].FILES : 0}];
							const result = await Keysystems.Documents.List.prototype.signAsync.call(me, data, true);
							if (result) me.onSignCompleted(result);
						}
					}),
					me.subBtnUnSign = Ext.create('Ext.Action', {
						text: 'Снять подпись',
						iconCls: 'x_btn_delete_sign',
						handler: async function () {
							const saved = await me.saveMessageShowAsync();
							if (!saved) return;
							
							const files = me.gksd('Files');
							const data = [{LINK: me.getLink(), FILES: files?.length ? files[0].FILES : 0}];
							const result = await Keysystems.Documents.List.prototype.unSignAsync.call(me, data, true);
							if (result) me.onSignCompleted(result);
						}
					})
				]
			});		
		tbar.splice(1, 0, me.btnSign);
		return tbar;
	},
	
	onSignCompleted: async function(response) {
		if (!response) return;

		const me = this;
		if (response.doc) {
			const rowDocUpd = response.doc.rows[0];
			//обновим данные записи окна редактирования
			me.sksd('EDS', rowDocUpd.EDS);
			me.sksd('STAMP', rowDocUpd.STAMP);

			//обновим данные по ЭП документа в списке, откуда открыли
			me.updateRecord({
				LINK: rowDocUpd.LINK,
				EDS_DATE: rowDocUpd.EDS_DATE,
				EDS_CNS: rowDocUpd.EDS_CNS,
				STAMP: rowDocUpd.STAMP
			});
		}
		if (response.files) {
			//обновим данные вкладки Файлы окна редактирования
			let files = me.gksd('Files');
			files.forEach(file => {
				const rowUpd = response.files.rows.filter(r => r.LINK === file.LINK)[0];
				if (rowUpd) {
					file.TEMP_EDS_DATE = rowUpd.EDS_DATE;
					file.TEMP_EDS_CNS = rowUpd.EDS_CNS;
				}
			});			
			me.fileList?.onSignAllCompleted(response.files.rows);
			
			//обновим данные по ЭП файла в списке, откуда открыли
			response.files.rows.forEach(rowFilesUpd=>{
				me.updateRecord({
					LINK: rowFilesUpd.LINK,
					IS_FILES: true,					
					EDS_FILES: rowFilesUpd.EDS_DATE ? 1 : 0
				});
			})
		}

		me.oldData = JSON.stringify(me.dataCollector());

		const readOnlyResponse = await ajaxRequestAsync({
			url: me.linkCode + '/CanEditDoc_A',
			params: {link: me.getLink()}
		});

		if (!readOnlyResponse) return;
		me.sksd('readOnlyReasonExt', readOnlyResponse.readOnlyReasonExt);
		me.readOnly = readOnlyResponse.readOnly;
		me.setReadOnly(me.readOnly, readOnlyResponse.readOnlyReason);
		if (!me.readOnly) {
			me.checkClosePersonUpd();
		}
	},

	/**
	 * Вывод сообщения о сохранении при необходимости + сохранение 
	 * @returns {Promise<boolean>}
	 */
	saveMessageShowAsync: async function () {
		const me = this;
		if (!me.getLink() || me.saveChangesFn()) {
			const dialogResult = await dialogShowAsync({
				msg: "Для продолжения необходимо сохранить документ.",
				title: KS.L10n.attention,
				buttons: Ext.MessageBox.OKCANCEL,
				buttonText: {
					ok: 'Сохранить'
				},
			});

			if (dialogResult !== "ok") return false;

			const checkSaveResult = await me.checkFilledAsync();
			if (!checkSaveResult) return false;

			const saved = await me.saveDataAsync();
			if (!saved) return false;
		}
		return true;
	},
	
	//#region grid

	fileGridEdit: function(rec) {
		var me = this;
		Ext.create('Keysystems.File', {
			iconCls: getExtStyle(rec.get('TEMP_EXTEXAMPLE')),
			createFile: function(callBack) { me.createGridFile(rec.get('S_RDOC'), callBack); },
			updRecord: function (fileObj) { me.updGridFileRecord(fileObj, rec); },
			getFileId: function() { return rec.get('FILES_EXAMPLE'); },
			downloadFile: function() { me.downloadGridFile(rec); },
			clearFile: function() { me.clearGridFile(rec); }
		});
	},
	createGridFile: function(link, callBack) { UploaderLib.newFile('DICTIONARY_SRDOC', link, 0, -1, 0, this.getLoadMaskTarget(), callBack); },
	clearGridFile: function(rec) {
		rec.set('FILES_EXAMPLE', 0);
		rec.set('TEMP_EXTEXAMPLE', '');
	},
	updGridFileRecord: function(fileObj, rec) {
		rec.set('FILES_EXAMPLE', fileObj.id);
		rec.set('TEMP_EXTEXAMPLE', fileObj.ext);
	},
	downloadGridFile: function(rec) { UploaderLib.getFile(rec.get('FILES_EXAMPLE'), ''); },

	//#endregion

	setReadOnly: function(v, reason, fake) {
		let me = this,
			mailToolbar = me.gksc('mailToolbar');
		
		me.callParent(arguments);

		if (window.useEDS) {
			//не блокируем полностью кнопку Подписать
			me.btnSign?.setKsReadOnly(false);
			me.subBtnSign?.setDisabled(v);
			me.subBtnUnSign?.setDisabled(v);

			if (v) {
				//в случае, если причиной доступа только на чтение является ЭП, разрешаем подписывать и снимать подпись
				const readOnlyReasonExt = me.gksd('readOnlyReasonExt');
				if ((readOnlyReasonExt & +Ext.Object.getKey(miscTypes.ReadOnlyReasonEnum, 'EDS')) !== 0) {
					const otherReason = readOnlyReasonExt | ~+Ext.Object.getKey(miscTypes.ReadOnlyReasonEnum, 'EDS');
					if (otherReason <= 0) {
						me.subBtnSign?.setDisabled(false);
						me.subBtnUnSign?.setDisabled(false);
					}
				}
			}
		}
		
		if (mailToolbar) {
			mailToolbar.setHidden(v);

			let grid = me.gksc('mailGrid'),
				selRecs = grid.getSelectionModel().getSelection();
			
			if (selRecs.length) {
				me.selFunc(grid, selRecs[0]);
			}
		}

		me.checkClosePersonUpd();
	},
	
	checkClosePersonChange: function(v) {
		const me = this;
		const c = me.gksc('S_PERSON_CLOSED');

		c.setDisabled(!v);
		if (v && c.isEmpty()) c.setValue(window.user.person);
		if (!v && !c.isEmpty()) c.setValue(_);

		const personClosed = +c.getLink();
		if (v) v = personClosed !== window.user.person.data.LINK;
		me.setReadOnly(v, null, 1);

		//обновляем причину закрытия доступа на редактирование (добавляем либо убираем ReadOnlyReasonEnum.Closed)		
		const readOnlyReasonExt = me.gksd('readOnlyReasonExt');
		me.sksd('readOnlyReasonExt', personClosed 
			? (readOnlyReasonExt | +Ext.Object.getKey(miscTypes.ReadOnlyReasonEnum, 'Closed')) 
			: (readOnlyReasonExt & ~+Ext.Object.getKey(miscTypes.ReadOnlyReasonEnum, 'Closed')));

		!v && me.sStatusUpd(me.gksc('S_STATUS').getValue());
		me.checkClosePersonUpd();
	},

	/**	Выставить доступ к полю закрыл с учетом прав доступа к полю Закрыл и настройки "Закрыл - Блокировать редактирование для других пользователей"  
	 */
	checkClosePersonUpd: function() {
		const me = this;
		const personClosed = +me.gksc('S_PERSON_CLOSED').getLink();

		//смотрим на причину блокировки. если не только по полю Закрыл, то блокировку с полей не снимаем
		const readOnlyReasonExt = me.gksd('readOnlyReasonExt');	
		if ((readOnlyReasonExt & +Ext.Object.getKey(miscTypes.ReadOnlyReasonEnum, 'Closed')) === 0)
			return; 
		
		if ((readOnlyReasonExt & ~+Ext.Object.getKey(miscTypes.ReadOnlyReasonEnum, 'Closed')) > 0) 
			return;
		
		//выставляем доступ к полю Закрыл с учетом настройки "Документы - Закрыл - Блокировать редактирование для других пользователей"
		const personClosedAccess = me.gksd('personClosedDenyEdit') && personClosed !== 0 && personClosed !== window.user.person.data.LINK && !window.user.isAdmin
			? me.gksd('personClosedAccess') & ObjAccessMask.READ
			: me.gksd('personClosedAccess');
		const personClosedReadOnly = (personClosedAccess & ObjAccessMask.EDIT) === 0;
		me.gksc('CHECK_CLOSE_PERSON').setKsReadOnly(personClosedReadOnly);
		me.gksc('S_PERSON_CLOSED').setDisabled(personClosedReadOnly);
		me.gksc('S_PERSON_CLOSED').setKsReadOnly(personClosedReadOnly);
	},

	sStatusUpd: function(v) {
		const me = this;
		const readOnlyByStatus = me.gksd('statusReadOnly').indexOf(v) !== -1;

		me.setReadOnly(readOnlyByStatus, null, 1);
		me.gksc('S_STATUS').setKsReadOnly(false);

		//обновляем причину закрытия доступа на редактирование (добавляем либо убираем ReadOnlyReasonEnum.Status)
		const readOnlyReasonExt = me.gksd('readOnlyReasonExt');
		me.sksd('readOnlyReasonExt', readOnlyByStatus 
			? (readOnlyReasonExt | +Ext.Object.getKey(miscTypes.ReadOnlyReasonEnum, 'Status')) 
			: (readOnlyReasonExt & ~+Ext.Object.getKey(miscTypes.ReadOnlyReasonEnum, 'Status')));
	},

	sStatusChange: function() {
		var me = this;
		if (me.isLoaded) return;
		me.checkClosePersonChange(me.gksc('CHECK_CLOSE_PERSON').getValue());
		me.gksc('S_STATUS').setKsReadOnly(false);
	},

	createBtns: function() {
		var me = this,
			nowDt = Ext.Date.format(new Date(Date.now()), 'Y/m/d'),
			btns = [
				me.sksc('S_STATUS', Ext.create('Keysystems.Controls.ComboBoxExtra', {
					fieldLabel: 'Статус',
					labelWidth: 50,
					hidden: true, //без hidden странным образом рендерится выше окна загрузки и висит в процессе загрузки
					displayField: CBDataLib.displayField,
					valueField: CBDataLib.valueField,
					editable: false,
					setKsReadOnly: function() {
						var res = this.callParent(arguments);
						this.setDisabled(this.store.count() < 2);
						return res;
					},
					store: Ext.create('Ext.data.Store', {
						fields: CBDataLib.getFields(),
						data: CBDataLib.get(_, true, {}),
						proxy: 'memory'
					}),
					listeners: { change: me.sStatusChange.bind(me) }
				})),
				me.sksc('CHECK_CLOSE_PERSON', Ext.create('Ext.form.Checkbox', {
					boxLabel: 'Закрыл',
					listeners: { 
						change: function(th, v) {
							if (me.isLoaded) return;
							me.checkClosePersonChange(v);
						} 
					}
				})),
				me.createDictEdit({
					key: 'S_PERSON_CLOSED',
					disabled: true,
					flex: 1,
					mode: 'SINGLE',
					code: dnl.S_PERSON,
					whereArgs: {
						DH1: { value: nowDt, type: 'Date' },
						DH2: { value: nowDt, type: 'Date'},
						SOrgs: { value: JSON.stringify([window.user.org && window.user.org.data.LINK || 0]), type: 'List_int' } 
					},
					ksSetValue: function(value) {
						this.setValue(value);
						if (me.isLoaded) return;
						if (this.isEmpty()){
							me.gksc('CHECK_CLOSE_PERSON').setValue(false);
						}
						else{
							me.checkClosePersonChange(true);
						}
						me.gksc('CHECK_CLOSE_PERSON').setKsReadOnly(false);
						me.gksc('S_PERSON_CLOSED').setKsReadOnly(false);
					},
				})
			];

		return me.objs.btns = btns;
	},

	//#region Общие

	//#region конструктор таба

	createTabGeneral: function() {
		var me = this;

		return Ext.create('Ext.panel.Panel', {
			title: 'Общие',
			layout: { type: 'vbox', align: 'stretch' },
			bodyPadding: 10,
			border: 0,
			scrollable: true,
			flex: 1,
			items: [
				me.sksc('docVid', Ext.create('Keysystems.ImageText', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Вид документа'
				})),
				Ext.create('Ext.form.FieldContainer', {
					layout: { type: 'hbox', align: 'stretch' },
					items: [
						me.sksc('NUMBER', Ext.create('Keysystems.Controls.Text.AutoNumeric', {
							labelWidth: me.labelWidth,
							maxLength: 50,
							enforceMaxLength: true,
							fieldLabel: '№',
							sender: me
						})),
						me.sksc('DT', Ext.create('Ext.form.field.Date', {
							labelWidth: 35,
							width: 145,
							format: 'd.m.Y',
							ksAllowEmpty: true,
							fieldLabel: 'от:',
							padding: '0 0 0 15',
							minValue: longPeriod.begin,
							maxValue: longPeriod.end,
							value: now,
							enableColorize: true
						})),
						'->',
						me.sksc('DF_RELATION_NEED', Ext.create('Ext.form.field.Checkbox', {
							boxLabel: ' Зарегистрировать'
						}))
					]
				}),
				me.createDictEdit({
					key: 'S_ORG_OTV',
					code: dnl.S_ORG,
					mode: 'SINGL',
					ksAllowEmpty: true,
					height: 30,
					fieldLabel: 'Ответственная организация',
					whereArgs: { 
						SType: { value: JSON.stringify([Ext.Object.getKey(miscTypes.TypeOrg, 'Проверяющая')]), type: 'List_int' },
						HasFilterOnLoad: {value: false, type: 'bool'}
					}
				}),
				me.createDictEdit({
					key: 'S_PERSON',
					code: dnl.S_PERSON,
					mode: 'SINGL',
					fieldLabel: 'Ответственный сотрудник',
					initWhereArgs: function() {
						let wa = {};
						if (me.data.data.REVIZ) {
							wa = {
								DH1: { value: '1900/01/01', type: 'Date' },
								DH2: { value: '2100/12/31', type: 'Date' },
								HasFilterOnLoad: {value: false, type: 'bool'}
							};
							
							if (me.gksc('S_ORG_OTV').isEmpty()) {
								wa.InLinksOnly = { type: 'bool', value: 'True' };
								wa.InLinks = { type: 'List_int', value: '[]' };
							} else {
								wa.SOrgs = { type: 'List_int', value: me.gksc('S_ORG_OTV').getLinks(1) }
							}
						} else {
							wa = me.getPersonWhereArgs(false);
						}
						
						return wa;
					}
				}),
				Ext.create('Ext.form.FieldContainer', {
					layout: { type: 'hbox', align: 'stretch' },
					items: [
						me.createDictEdit({
							key: 'S_DELO',
							mode: 'SINGL',
							code: dnl.S_DELO,
							fieldLabel: 'Дело',
							flex: 1,
							initWhereArgs: function() {
								var wa = {
									Orgs: {
										value: (c = me.gksc('S_ORG_OTV')).isEmpty()
											? '[' + user.org.data.LINK + ']'
											: c.getLinks(1),
										type: 'List_int'
									}
								};

								if (me.gksd('restrictDeloByReviz')) {
									wa.Reviz = { value: me.data.data.REVIZ || 0, type: 'int' };
								}

								if (me.gksd('isRfnAp')) {
									wa.OnlyFree = {
										value: (c = me.gksc('S_DELO')).isEmpty()
											? '[' + user.org.data.LINK + ']'
											: c.getLinks(1),
										type: 'List_int'
									};
								}
								return wa;
							},
							listCfg: {
								edit: function(f, data, defCfg) {
									//Keysystems.Base.List.prototype.edit.call(this, f, data, concatDictionary(defCfg, { SNar: objs.S_NAR.getLink() }));
									return this.callParent([f, data, Ext.apply(defCfg || {}, {
										dataCollector: function() {
											var result = this.callParent(arguments);
											if (me.gksd('restrictDeloByReviz')) result.REVIZ = me.data.data.REVIZ;
											return result;
										}
									})]);
								}
							}
						}),
						me.sksc('VOL', Ext.create('Ext.form.field.Number', {
							fieldLabel: 'Том',
							labelWidth: 35,
							padding: '0 0 0 15',
							minValue: 0,
							maxValue: 100,
							width: 100
						}))
					]
				}),
				me.sksc('T_REVIZ_OBJECTS', Ext.create('Keysystems.Controls.DictName.Edit', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Объект',
					cleaningKey: false,
					getNameLabelText: function (val) {
						var res = '',
							names = [];
						if (val.length) {
							var type = val[0].data ? val[0].data.TYPE : val[0].TYPE,
								tro = me.gksd('tRevizObjects');
							Ext.each(val,
								function(v) {
									v = v.data ? v.data : v;
									var name = v.TEMP_NAME;
									// если тип 'ИП' или 'ДЛ'
									if (type === 2 || type === 8) {
										var troChild = tro.data.filter(function(i) {
											return i.LINK_SELF === v.LINK;
										});
										if (troChild.length) name += ' ' + troChild[0].TEMP_SNAME;
									}
									names.push(name);
								});
						}
						return names.length ? names.join(', ') : res;
					},
					handler: function() {
						Ext.create('Keysystems.Base.List', {
							parentView: objs.view,
							selectLinks: ArrayLib.copy(me.gksc('T_REVIZ_OBJECTS').getValue()),
							mode: me.gksd('multiObj') ? 'MULTI' : 'SINGL',
							title: 'Объекты контроля',
							pageSize: 10000,
							hidePagging: true,
							mainColumn: !me.data.data.PLANREVIZ,
							mainColumnEditable: false,
							checkModel: !me.data.data.PLANREVIZ,
							readOnly: me.gksc('T_REVIZ_OBJECTS').readOnly,
							isItemDblClick: !me.data.data.PLANREVIZ,
							functions: {
								getData: function(endFunc) {
									var tRevizObjects = me.gksd('tRevizObjects'),
										d = ArrayLib.filter(tRevizObjects.data, ['LINK_SELF'], null);
									endFunc({
										columns: tRevizObjects.columns,
										fields: tRevizObjects.fields,
										data: { data: d, total: d.length }
									});
								},
								refresh: function(endFunc) {
									var d = ArrayLib.filter(me.gksd('tRevizObjects').data, ['LINK_SELF'], null);
									endFunc({ data: d, total: d.length });
								},
								ok: function(v) {
									var rec = v[0];
									if (rec) rec.set('TEMP_NAME', rec.get('TEMP_NAME') || rec.get('TEMP_SNAME') || rec.get('TEMP_CODE'));

									var oldLinks = me.gksc('T_REVIZ_OBJECTS').getLinks();
									me.gksc('T_REVIZ_OBJECTS').setValue(v);
									var newLinks = me.gksc('T_REVIZ_OBJECTS').getLinks(),
										changed = JSON.stringify(oldLinks.sort()) !== JSON.stringify(newLinks.sort());

									if (changed && me.getTabVisible('FactNar')) {
										var grid = me.gksc('tabNarGrid'),
											store = grid.getStore();

										if (!newLinks.length) {
											// Нарушения
											store.removeAll();
											grid.checked.length = 0;
											grid.view.refresh();

											// Требования
											if (me.getTabVisible('NarRemove')) {
												var narremPersons = me.gksd('narRemove').narremPersons,
													narremFactnars = me.gksd('narRemove').narremFactnars,
													links = [],
													narremStore = me.gksc('dictNarRemove').getStore();

												for (var key in narremFactnars) {
													if (narremFactnars[key].length) links.push(+key);
												}

												var delRecords = narremStore.data.items.filter(function(d) {
													return links.indexOf(d.get('LINK')) !== -1;
												});
												narremStore.remove(delRecords);
												me.gksd('narRemove').narremFactnars = new Object();

												links.map(function(l) {
													if (narremPersons[l]) delete narremPersons[l];
												});
											}

											// Ответственность
											if (me.getTabVisible('Respons')) {
												var respStore = me.gksc('tabRespons').getStore(),
													respData = respStore.getDataExt(),
													indexes = [];
												for (var i = 0; i < respData.length; i++) {
													if (respData[i].FACTNAR !== 0) {
														indexes.push(i);
													}
												}
												respStore.remove(indexes);
											}
										} else {
											var factnarLinks = [];
											Ext.each(grid.checked, function(d) { factnarLinks.push(d.LINK ?? d.data.LINK); });

											// Обновляем данные Нарушений
											me.showLoadMask({
												msg: KS.L10n.loading_data,
												rid: ajaxRequest({
													url: me.linkCode + '/GetDataByObjects_A',
													params: {
														data: JSON.stringify({
															link: me.getLink(),
															linkSelf: me.ksData.row.LINK_SELF || 0,
															revizLink: me.ksData.row.REVIZ,
															task: me.data.data.S_TASK,
															taskDocLink: me.f === 'new' ? me.taskDocVidLink || 0 : 0,
															taskDocType: me.f === 'new' ? me.taskDocType || 0 : 0,
															osnov: me.osnov || 0,
															objLinks: newLinks,
															factnarLinks: factnarLinks
														})
													},
													success: function (res) {
														if (res.factNar) {
															var grid = me.gksc('tabNarGrid'),
																store = grid.getStore(),
																data = res.factNar.data,
																actualLinks = [],
																uncheckedLinks = [];

															// Нарушения
															store.getDataExt().filter(function(d) { return !d.CHECKED; })
																.map(function(d) { uncheckedLinks.push(d.LINK); });
															store.removeAll();
															grid.checked.length = 0;
															store.loadData(data, true);

															Ext.each(data, function(d) { actualLinks.push(d.LINK); });

															// Требования
															if (me.getTabVisible('NarRemove') && res.narrem) {
																me.updateNarremoveGrid(actualLinks);
															}

															// Ответственность
															if (me.getTabVisible('Respons')) {
																var respStore = me.gksc('tabRespons').getStore();

																// удаление неактуальных
																var respData = respStore.getDataExt(),
																	indexes = [];
																for (var i = 0; i < respData.length; i++) {
																	if (respData[i].FACTNAR !== 0 && actualLinks.indexOf(respData[i].FACTNAR) === -1) {
																		indexes.push(i);
																	}
																}
																respStore.remove(indexes);

																// добавление новых (записи по настройке "Штрафные санкции")
																if (res.respons && res.respons.data.length) {
																	var links = [];
																	Ext.each(respStore.getDataExt(), function(d) {
																			links.push(d.LINK);
																	});
																	var newData = res.respons.data.filter(function(d) {
																		return links.indexOf(d.LINK) === -1;
																	});

																	respStore.add(newData);
																}
															}

															var checkList = data.filter(function(d) {
																return d.CHECKED && uncheckedLinks.indexOf(d.LINK) === -1;
															});

															grid.checked = checkList;
															me.gksc('dictNar').checkList = checkList;
															me.gksc('dictNar').setChecks(checkList);
														}
													},
													callback: function(){
														me.hideLoadMask();
													}
												})
											});
										}
									}
									if (changed && me.getTabVisible('Corr')) {
										let newValue = me.gksc('T_REVIZ_OBJECTS').getValue();
										newValue = newValue.length ? (newValue[0].data || newValue[0]) : null;

										if (newValue) {
											var ksControls = me.ksControls,
												ksData = me.ksData,
												d = me.data.data;

											me.showLoadMask({
												msg: KS.L10n.loading_data,
												rid: ajaxRequest({
													url: me.linkCode + '/CalcCorr_A',
													params: {
														parameters: JSON.stringify({
															link: ksData.link,
															dt: ksControls.DT.getValue(),
															dtEnd: ksControls.DTEND.getValue(),
															dtUtv: ksControls.DTUTV.getValue(),
															revizLink: d.REVIZ || 0,
															task: d.S_TASK,
															planLink: d.PLANREVIZ || 0,
															sPlanProj: d.sPlanProj || 0,
															isVfa: me.isVfa,
															IFC_REGISTER: me.IFC_REGISTER,
															taskDocLink: me.f === 'new' ? me.taskDocVidLink || 0 : 0,
															taskDocType: me.f === 'new' ? me.taskDocType || 0 : 0,
															osnov: me.osnov || 0,
															linkSelf: d.LINK_SELF || 0,
															revizObjType: newValue.TYPE,
															org: newValue.TLINK,
															//для корректной работы с СП необходимо сначала доработать список объектов
															//он должен быть иерарахическим как в вине (либо с показом всех записей с LINK_SELF is not null)
															otdel: 0,
															orgCorr: me.objs.CORR_ORG.getLink(),
															otdelCorr: me.objs.CORR_OTDEL.getLink()
														})
													},
													success: function (res) {
														if (res.org) {
															selectDialogShow(KS.L10n.attention, res.message, function () {
																me.objs.CORR_ORG.setValue(res.org);
																me.objs.CORR_OTDEL.setValue(res.otdel);
																me.objs.CORR_PERSON.setValue(res.person);
															});
														}
													},
													callback: function (){
														me.hideLoadMask();
													}
												})
											});
										}
									}
								}
							}
						});
					}
				})),
				me.sksc('COMMENT', Ext.create('Ext.form.field.TextArea', {
					fieldLabel: 'Примечание',
					labelWidth: me.labelWidth,
					flex: 1,
					fieldCls: 'rks-textarea'
				})),
				Ext.create('Ext.form.FieldContainer', {
					layout: 'hbox',
					items: [
						me.sksc('DTUTV', Ext.create('Ext.form.field.Date', {
							fieldLabel: 'Дата исполнения',
							labelWidth: me.labelWidth,
							format: 'd.m.Y',
							minValue: '01.01.1900',
							maxValue: '31.12.2100',
							value: new Date(),
							width: me.labelWidth + 110
						})),
						me.sksc('DTEND', Ext.create('Ext.form.field.Date', {
							fieldLabel: 'Срок исполнения',
							ksAllowEmpty: true,
							labelWidth: 130,
							padding: '0 0 0 15',
							format: 'd.m.Y',
							minValue: '01.01.1900',
							maxValue: '31.12.2100',
							value: new Date(),
							width: me.labelWidth + 110
						}))
					]
				}),
				me.sksc('RESULT', Ext.create('Ext.form.field.TextArea', {
					fieldLabel: 'Результат',
					labelWidth: me.labelWidth,
					fieldCls: 'rks-textarea',
					flex: 1
				})),
				me.createDictEdit({
						key: 'S_PERSONP',
						codeWidth: 130,
						code: dnl.S_PERSON,
						fieldLabel: 'Подписал',
					initWhereArgs: function() {
							return me.getPersonWhereArgs(true);
						}
					})
			]
		});
	},

	getPersonWhereArgs: function(subscriber) {
		let me = this,
			wa = {},
			dt = Ext.Date.format(me.gksc('DT').getValue(), 'Y/m/d'),
			dt1 = '',
			dt2 = '',
			orgs = [],
			orgCorr = me.gksc('CORR_ORG') ? me.gksc('CORR_ORG').getValue() : [],
			signDolgs = me.gksd('signDolgs');

		if (subscriber && dt.length) {
			dt1 = dt2 = dt;
		} else {
			dt1 = '1900/01/01';
			dt2 = '2100/12/31';
		}

		// Внутренний, Исходящий
		if (!subscriber || [2, 4].indexOf(me.ksData.row.TYPE) !== -1) {
			orgs = me.gksd('auditOrgs');
			ArrayLib.addMissing(orgs, [window.user.org.data.LINK]);
		} else if (orgCorr.length) {
			orgs = [orgCorr[0].LINK || orgCorr[0].data.LINK];
		} else {
			Ext.each(me.gksc('T_REVIZ_OBJECTS').getValue(), o => {
				let obj = o.data || o;
				// ЮЛ, ИП, ДЛ, СП
				if ([1, 2, 8].indexOf(obj.TYPE) !== -1 || obj.TYPE === 64 && obj.LINK_SELF == null) {
					ArrayLib.addMissing(orgs, [obj.TLINK]);
				}
			});
		}

		wa.DH1 = { value: dt1, type: 'Date' };
		wa.DH2 = { value: dt2, type: 'Date' };
		wa.SOrgs = { value: JSON.stringify(orgs), type: 'List_int' };
		if (orgs.length) {
			wa.HasFilterOnLoad = {value: false, type: 'bool'};
		}

		if (signDolgs !== 0) {
			wa.DolgByNastr = { value: signDolgs, type: 'AutoSignMethod' };
		}

		return wa;
	},
	
	//#endregion конструктор таба

	//загрузка данных
	getExtraGeneral: function(value) {
		var me = this,
			tabValue = value.General;
		
		me.changeTab(me.getTab('General'), true);

		me.sksd('personWhereArgs', tabValue.personWhereArgs);
		me.sksd('multiObj', tabValue.multiObj);
		me.sksd('isRfnAp', tabValue.isRfnAp);
		me.sksd('restrictDeloByReviz', tabValue.RestrictDeloByReviz);
		me.sksd('isRegAp', tabValue.isRegAp);
		me.sksd('revizPeriod', tabValue.revizPeriod);
		me.sksd('needCheckUnicNumber', tabValue.needCheckUnicNumber);
		me.sksd('nastrChangeEхеcutionDate', tabValue.SettingChangeExecution);
		me.sksd('signDolgs', tabValue.signDolgs);
		me.sksd('auditOrgs', tabValue.auditOrgs);
		
		me.gksc('NUMBER').mask = tabValue.numMask; 

		var icons = { 1: 'document_in', 2: 'document_out', 4: 'document' };
		me.gksc('docVid').setValue('x_btn_' + icons[value.row.TYPE], tabValue.docVidName);

		me.sksd('S_DOCVID_NAME', tabValue.docVidName);
		
		me.setObjsValues(value.row, ['VOL', 'DT', 'DTEND', 'COMMENT', 'RESULT', 'DTUTV', 'NUMBER', 'DF_RELATION_NEED']);
		me.setObjsValues(tabValue, ['S_PERSONP', 'S_PERSON', 'S_DELO', 'S_ORG_OTV']);

		me.setFullObjsAccess(tabValue.accessObject, ['NUMBER', 'DT', 'S_PERSON', 'S_DELO', 'VOL', 'COMMENT', 'DTUTV', 'DTEND', 'RESULT','S_PERSONP', 'T_REVIZ_OBJECTS', 'DF_RELATION_NEED', 'S_STATUS']);

		if (me.gksd('isPlanProj')) {
			me.gksc('T_REVIZ_OBJECTS').setVisible(false);
		} else {
			if(tabValue.tRevizObjects) {
				me.sksd('tRevizObjects', tabValue.tRevizObjects);
				var tro = tabValue.tRevizObjects.data.filter(function (i) {
					return tabValue.objLinks.indexOf(i.LINK) !== -1;
				});
				if (tro.length) {
					Ext.each(tro, function (t) {
						t.TEMP_NAME = t.TEMP_NAME || t.TEMP_SNAME || t.TEMP_CODE
					});

					me.gksc('T_REVIZ_OBJECTS').setValue(tro);
				}
			}
		}

		if (tabValue.isAp) me.objs.S_DELO.fieldLabel = 'Дело об АП';

		if (!value.row.IFC_REGISTER) {
			// Статус
			var statusList = me.gksd('statusList') || {},
				sStatus = me.gksd('sStatus');
			if (sStatus) {
				sStatus = JSON.parse(sStatus);
				for (var sk in sStatus) statusList[sk] = sStatus[sk];
			}
			var statusCon = me.gksc('S_STATUS');
			statusCon.loadData(CBDataLib.get(_, !sStatus, statusList));
			statusCon.setValueSelectOrFrst();

			statusCon.setVisible(statusCon.getValue() || Object.keys(statusList).length);
			statusCon.setDisabled(statusCon.store.count() < 2);
		}
	},

	//Сборка данных
	dataCollectorGeneral: function() {
		var me = this;

		if (me.getTabVisible('General')) {
			var res = {};

			Ext.each(['VOL', 'COMMENT', 'RESULT', 'NUMBER', 'DF_RELATION_NEED'], key => res[key] = me.gksc(key).getValue());
			Ext.each(['DT', 'DTEND', 'DTUTV'], key => res[key] = me.gksc(key).getValue()?.toDateString());

			Ext.each(['S_PERSONP', 'S_PERSON', 'S_DELO', 'T_REVIZ_OBJECTS', 'S_ORG_OTV'], key => res[key] = me.gksc(key).getLinks(1));

			if (me.gksd('nastrChangeEхеcutionDate'))
				res['nastrChangeEхеcutionDate'] = me.gksd('nastrChangeEхеcutionDate');

			//if (me.gksd('isPlanProj')) delete res['T_REVIZ_OBJECTS'];
			return res;
		}
		return _;
	},

	/**
	 * Менялось ли поле дело
	 * @returns {boolean}
	 */
	isDeloChanged: function() {
		const me = this;
		if (me.oldData && me.gksd('isRegAp') && me.ksData.link > 0){
			const deloOriginal = JSON.parse(JSON.parse(me.oldData).tabGeneral).S_DELO;
			return JSON.stringify(deloOriginal) !== JSON.stringify(me.gksc('S_DELO').getLinks(1));
		}
		return false;
	},

	//#endregion Общие

	//#region Участники

	//#region конструктор таба

	createTabPerson: function() {
		let me = this;
		return Ext.create('Ext.panel.Panel', {
			title: 'Участники',
			layout: {type: 'vbox', align: 'stretch'},
			bodyPadding: 0,
			scrollable: true,
			border: 0,
			flex: 1,
			items: [
				me.sksc('chbPersonList', Ext.create('Ext.form.CheckboxGroup', {					
					flex: 1,
					columns: 1,
					padding: 5,
					closable: false
				}))]
		});
	},

	//#endregion конструктор таба

	//загрузка данных
	getExtraPerson: function(value) {
		var me = this,
			tabValue = value.Person;
		
		me.sksd('isPerson', true);		
		me.changeTab(me.getTab('Person'), true);		
		me.gksc('chbPersonList').add(tabValue);
	},

	//Сборка данных
	dataCollectorPerson: function() {
		var me = this;
		if (me.getTabVisible('Person')) {
			return me.gksc('chbPersonList').items.items.filter(r => r.checked).map(r => r.link);
		}
		return [];
	},

	//#endregion Общие

	//#region Нарушения

	//#region конструктор таба

	createTabFactNar: function() {
		var me = this,
			tmp,

			res = Ext.create('Ext.panel.Panel', {
				title: 'Нарушения',
				layout: { type: 'vbox', align: 'stretch' },
				scrollable: true,
				items: [
					tmp = Ext.create('Ext.panel.Panel', {
						border: 0,
						flex: 3,
						layout: { type: 'vbox', align: 'stretch' }
					}),
					Ext.create('Ext.panel.Panel', {
						flex: 1,
						layout: { type: 'vbox', align: 'stretch' },
						bodyPadding: 5,
						items: [
							me.sksc('narTextArea', Ext.create('Ext.form.field.TextArea', {
								flex: 1,
								fieldLabel: 'Характер и обстоятельства нарушения',
								readOnlyCls: '',
								readOnly: true
							}))
						]
					})
				]
			});

		me.sksc('tabNarGrid', me.sksc('dictNar', Ext.create('Keysystems.Base.List', {
			tabMode: true,
			readOnly: me.readOnly,
			closable: false,
			code: dnl.FACTNAR,
			title: 'Нарушения',
			linkCode: 'SFactNar',
			editClass: 'Keysystems.FactNar.Edit',
			GateCode: me.keyEdit,
			parentView: tmp,
			profileCode: me.code,
			profileKey: 'tabNar',
			selectLinks: ArrayLib.filter(me.gksd('factNar').data, ['CHECKED'], true),
			mode: 'MULTI',
			head: false,
			hidePagging: true,
			pageSize: 1000,
			needToolbar: false,
			createTBar: function() {
				const th = this;
				if (th.f === 'edit') {
					return this.callParent(arguments);
				}
				const res = [];
				res.push(Ext.create('Ext.Button', {
					iconCls: 'x_btn_galka',
					tooltipType: 'title',
					tooltip: 'Отметить все',
					handler: function() {
						me.batchProcess = true;
						th.checkAll();
						me.batchProcess = false;
					}
				}));
				res.push(Ext.create('Ext.Button', {
					iconCls: 'x_btn_unmark',
					tooltipType: 'title',
					tooltip: 'Разметить все',
					handler: function() {
						me.batchProcess = true;
						th.uncheckAll();
						me.batchProcess = false;
					}
				}));
				res.push(Ext.create('Ext.Button', {
					iconCls: 'x_btn_top',
					tooltipType: 'title',
					tooltip: 'В начало',
					hidden: !me.gksd('IsVisibleOrd'),
					handler: function() {
						me.factNarRowMove(function(rows, iPos) {
							if (iPos > 0) {
								var tmp = rows[iPos];
								rows.splice(iPos, 1);
								rows.unshift(tmp);
								return true;
							}
							return false;
						});
					}
				}));
				res.push(Ext.create('Ext.Button', {
					iconCls: 'x_btn_up',
					tooltipType: 'title',
					tooltip: 'Вверх',
					hidden: !me.gksd('IsVisibleOrd'),
					handler: function() {
						me.factNarRowMove(function(rows, iPos) {
							if (iPos > 0) {
								var tmp = rows[iPos];
								rows[iPos] = rows[iPos - 1];
								rows[iPos - 1] = tmp;
								return true;
							}
							return false;
						});
					}
				}));
				res.push(Ext.create('Ext.Button', {
					iconCls: 'x_btn_down',
					tooltipType: 'title',
					tooltip: 'Вниз',
					hidden: !me.gksd('IsVisibleOrd'),
					handler: function() {
						me.factNarRowMove(function(rows, iPos) {
							if (iPos < rows.length - 1) {
								var tmp = rows[iPos];
								rows[iPos] = rows[iPos + 1];
								rows[iPos + 1] = tmp;
								return true;
							}
							return false;
						});
					}
				}));
				res.push(Ext.create('Ext.Button', {
					iconCls: 'x_btn_bottom',
					tooltipType: 'title',
					tooltip: 'В конец',
					hidden: !me.gksd('IsVisibleOrd'),
					handler: function() {
						me.factNarRowMove(function(rows, iPos) {
							if (iPos < rows.length - 1) {
								var tmp = rows[iPos];
								rows.splice(iPos, 1);
								rows.push(tmp);
								return true;
							}
							return false;
						});
					}
				}));
				th.objs.tbar = res;
				return res;
			},
			viewCfg: function() {
				var r = this.callParent(arguments);
				r.flex = 1;
				return r;
			},
			getGridCfg: function() {
				var cfg = this.callParent();
				cfg.plugins.push(Ext.create('Ext.grid.plugin.CellEditing', { 
					clicksToEdit: 1,
					listeners: {
						beforeedit: function(editor, e) {
							if (e.field === 'SUMMA' && e.record.get('CHECKED') !== true) return false;
							return true;
						}
					}
				}));
				return cfg;
			},
			checkListeners: {
				checkchange: function (th, rowIndex, checked, rec) {
					// если форма или грид еще грузится
					if (me.isLoaded || th.ownerCt.ownerCt?.isLoaded) return;

					var callback = function() {
						var grid = th.ownerCt.ownerCt;

						rec.set('SUMMA', checked ? rec.get('SUMNAR') : 0);
						rec.set('CHECKED', checked);

						grid.checked = ArrayLib.filter(grid.getStore().getDataExt(), ['CHECKED'], true);

						if (me.getTabVisible('NarRemove')) {
							me.gksc('narRemFillBtn').setDisabled(!grid.checked.length);
						}

						// перенумеруем строки
						// если есть неотмеченные строки с номером, очистим номер
						var data = grid.getStore().getDataExt();
						
						Ext.each(ArrayLib.filter(data, ['CHECKED'], false), function(value) {
							if (value.ORD) value.ORD = 0;
						});
						
						// перенумеровываем все в правильном порядке от 1 и дальше
						var rowsNotOrdered = ArrayLib.filter(data, ['CHECKED'], true),
							ord = 0;

						rowsNotOrdered.sort(function(a, b) {
							return a.ORD - b.ORD;
						});

						Ext.each(rowsNotOrdered, function(value) {
							++ord;
							value.ORD = ord;
						});

						grid.getStore().each(rec=> {
							const rowUpd = data.filter(r => +r.LINK === +rec.get('LINK'))[0];
							if (rowUpd) rec.set('ORD', rowUpd.ORD);
						});
						grid.view.refresh();
					}

					if (!checked) {
						var factnarLink = rec.get('LINK'),
							narremToDel = [],
							responsToDel = [];
						
						// Проверка связанных Требований
						if (me.getTabVisible('NarRemove')) {
							var narremFactnars = me.gksd('narRemove').narremFactnars;
							for (var key in narremFactnars) {
								if (narremFactnars[key].indexOf(factnarLink) !== -1) narremToDel.push(+key);
							}
						}
						// Проверка связанных Ответственностей
						if (me.getTabVisible('Respons')) {
							var data = me.gksc('tabRespons').getStore().getDataExt();
							for (var i = 0; i < data.length; i++) {
								if (data[i].FACTNAR === factnarLink) {
									responsToDel.push(i);
								}
							}
						}

						let str = '';
						let childDocmoney = me.gksd('factNar').childData[rec.get('LINK')];
						let narRemove = narremToDel.length;
						let respons = responsToDel.length;
						let childNarRemove = childDocmoney && childDocmoney.narremove.length;
						let childRespons = childDocmoney && childDocmoney.respons.length;
						let doc = narRemove || respons;
						let childDoc = childNarRemove || childRespons || childDocmoney;

						// Метод по удалению связанных требований, ответственностей
						var removeChildNarData = function(){
							callback();
							// Нарушения
							delete me.gksd('factNar').childData[rec.get('LINK')];

							// Требования
							if (narremToDel.length) {
								var factnarLinks = [];
								me.gksc('tabNarGrid').checked.map(function(d) {
									factnarLinks.push(d.LINK);
								});
								var sel = me.gksc('dictNarRemove').getFrstSelect();

								me.updateNarremoveGrid(factnarLinks);

								// Дополнительные поля
								if (sel && narremToDel.indexOf(sel.get('LINK')) !== -1) {
									if (me.gksd('narRemove').multiNar) {
										me.filterExtNarremove(0);
									} else {
										me.gksc('narremTextArea').setValue();
									}
								}
							}
							// Ответственность
							if (responsToDel.length) {
								me.gksc('tabRespons').getStore().remove(responsToDel);
							}
						}
						
						if (!me.batchProcess){
							if (childDocmoney) {
								if (narRemove || respons || childNarRemove || childRespons) {
									str = (narRemove || childNarRemove) && (respons || childRespons)
										? doc
											? KS.L10n.DocumentsEditView_gridSumms_BeforeCellUpdate_Будут_размечены_нарушения_и_удалены_соответствующие_требования_и_ответственности_у_текущего_и_последующих_документов
											: KS.L10n.DocumentsEditView_gridSumms_BeforeCellUpdate_Будут_размечены_нарушения_и_удалены_соответствующие_требования_и_ответственности_у_последующих_документов
										: narRemove || childNarRemove
											? doc
												? KS.L10n.DocumentsEditView_gridSumms_BeforeCellUpdate_Будут_размечены_нарушения_и_удалены_соответствующие_требования_у_текущего_и_последующих_документов
												: KS.L10n.DocumentsEditView_gridSumms_BeforeCellUpdate_Будут_размечены_нарушения_и_удалены_соответствующие_требования_у_последующих_документов
											: doc
												? KS.L10n.DocumentsEditView_gridSumms_BeforeCellUpdate_Будут_размечены_нарушения_и_удалены_соответствующие_ответственности_у_текущего_и_последующих_документов
												: KS.L10n.DocumentsEditView_gridSumms_BeforeCellUpdate_Будут_размечены_нарушения_и_удалены_соответствующие_ответственности_у_последующих_документов;

								}
								else {
									str = KS.L10n.DocumentsEditView_gridSumms_BeforeCellUpdate_Будут_размечены_нарушения_у_последующих_документов;
								}
							}
							else {
								if (narRemove || respons || childNarRemove || childRespons) {
									str = (narRemove || childNarRemove) && (respons || childRespons)
										? doc && childDoc
											? KS.L10n.DocumentsEditView_gridSumms_BeforeCellUpdate_Будут_удалены_соответствующие_требования_и_ответственности_у_текущего_и_последующих_документов
											: doc
												? KS.L10n.DocumentsEditView_gridSumms_BeforeCellUpdate_Будут_удалены_соответствующие_требования_и_ответственности_у_текущего_документа
												: KS.L10n.DocumentsEditView_gridSumms_BeforeCellUpdate_Будут_удалены_соответствующие_требования_и_ответственности_у_последующих_документов
										: narRemove || childNarRemove
											? doc && childDoc
												? KS.L10n.DocumentsEditView_gridSumms_BeforeCellUpdate_Будут_удалены_соответствующие_требования_у_текущего_и_последующих_документов
												: doc
													? KS.L10n.DocumentsEditView_gridSumms_BeforeCellUpdate_Будут_удалены_соответствующие_требования_у_текущего_документа
													: KS.L10n.DocumentsEditView_gridSumms_BeforeCellUpdate_Будут_удалены_соответствующие_требования_у_последующих_документов
											: doc && childDoc
												? KS.L10n.DocumentsEditView_gridSumms_BeforeCellUpdate_Будут_удалены_соответствующие_ответственности_у_текущего_и_последующих_документов
												: doc
													? KS.L10n.DocumentsEditView_gridSumms_BeforeCellUpdate_Будут_удалены_соответствующие_ответственности_у_текущего_документа
													: KS.L10n.DocumentsEditView_gridSumms_BeforeCellUpdate_Будут_удалены_соответствующие_ответственности_у_последующих_документов;
								}
							}
							// Выводим сообщение для пользователя
							if (str.length) {
								Ext.Msg.show({
									title: KS.L10n.attention,
									msg: wmc.getContinueQuestion(str),
									buttons: Ext.MessageBox.OKCANCEL,
									buttonText: { ok: 'Да', cancel: 'Нет' },
									fn: function(buttonId) {
										if (buttonId === 'ok') {
											removeChildNarData();
										} else if (buttonId === 'cancel') {
											me.gksc('dictNar').checkRecord(rec);
										}
									},
									icon: Ext.MessageBox.WARNING
								});
							} else {
								callback();
							}
						}
						else
						{
							removeChildNarData();
						}
					} else {
						callback();
					}
				}
			},
			revizLink: me.data.data.REVIZ,
			IFC_REGISTER: me.data.data.IFC_REGISTER,
			setRecord: function(row, cmp) {
				row.SUMNAR = row.SUMMA;
				row.SUMMA = 0;
				cmp.data.set(row);
				// Вид нарушения
				cmp.data.set('CODE', row.S_NAR_CODE);
				cmp.data.set('NAME', row.S_NAR_NAME);

				me.gksc('narTextArea').setValue(row.CONTENT);

				// Вкладка Требования
				if (me.getTabVisible('NarRemove')) {
					// основной грид
					var narremLinks = [],
						narremFactnars = me.gksd('narRemove').narremFactnars;
					for (var key in narremFactnars) {
						// не учитываем записи, где отобрано несколько нарушений, т.к. в них не отображаем данные факта нарушения
						if (narremFactnars[key].length === 1 && narremFactnars[key][0] === row.LINK)
							narremLinks.push(+key);
					}
					var store = me.gksc('dictNarRemove').getStore(),
						records = store.data.items.filter(function(i) {
							return narremLinks.indexOf(i.data.LINK) !== -1;
						});
					if (records.length) {
						Ext.each(records, function (rec) {
							var r = rec.data;
							r.FACTNAR_CONTENT = row.CONTENT;
							r.ACT_NUMBER = row.ACT_NUMBER;
							r.ACT_PAGE = row.ACT_PAGE;
							r.SUMMA = row.SUMNAR;
							r.S_PERSONC_NAME = row.TEMP_SPERSONC_FIO;
							r.S_NAR_CODE = row.S_NAR_CODE;
							r.S_NAR_NAME = row.S_NAR_NAME;
						});
						store.loadData(records, true);
					}

					// дополнительные поля
					if (me.gksd('narRemove').multiNar) {
						// меняем в snapshot, из которого берутся данные при изменении фильтра
						var prefix,
							rec = me.gksc('narremExt').getStore().snapshot.items.filter(function(i) {
								return i.get('LINK') === row.LINK;
							});
						if (!rec.length) return;
						rec = rec[0].data;
						for (var key in rec) {
							if (row.hasOwnProperty(key) && rec[key] !== row[key]) {
								prefix = key === 'CODE' || key === 'NAME' ? 'S_NAR_' : '';
								rec[key] = row[prefix + key];
							}
						}
						me.gksc('narremExt').view.refresh();
					} else {
						var sel = me.gksc('dictNarRemove').selModel.getSelection();
						if (sel.length) {
							me.gksc('narremTextArea').setValue(sel[0].get('FACTNAR_CONTENT'));
						}
					}
				}
			},
			getGridStoreCfg: function() {
				//так как данные локальные, подменим прокси листа, иначе лезет на базу при инициализации и не может получить данные
				let cfg = this.callParent(arguments);
				cfg.proxy = 'memory';
				cfg.remoteSort = false;
				return cfg;
			},
			functions: {
				getData: function(endFunc) {
					const th = me.gksc('tabNarGrid');
					// чтобы checkchange не отработал при загрузке данных и не перезатер суммы
					th.isLoaded = true;
					th.localData = true;
					const factNar = me.gksd('factNar');
					factNar.fields.filter(f => f.name === 'ORD2').forEach(f => f.sortType = 'asNatural');
					
					endFunc({
						columns: me.adaptFactNarColumns(factNar.columns),
						fields: factNar.fields,
						data: {data: factNar.data, total: factNar.data.length}
					});
					//Чтобы заполнился factNarSelect
					me.oldData = JSON.stringify(me.dataCollector());
					th.isLoaded = false;
				},
				select: function (th, sel) { me.gksc('narTextArea').setValue(sel.get('CONTENT')); }
			},
			listeners: {
				ksAfterRefresh: function () {
					me.gksc('tabNarGrid').view.refresh();
				}
			},
		})).Grid);
		// работаем с checked без проверок на существование грида me.gksc('tabNarGrid'),
		// т.к.если не доступна вкладка Нарушения, то и остальные вкладки, использующие ее, тоже не доступны
		if (!me.gksc('tabNarGrid').checked) {
			me.gksc('tabNarGrid').checked = ArrayLib.filter(me.gksd('factNar').data, ['CHECKED'], true);
		}

		return res;
	},

	//#endregion конструктор таба

	//загрузка данных
	getExtraFactNar: function(value) {
		var me = this,
			tabValue = value.FactNar;

		me.sksd('IsVisibleOrd', value.IsVisibleOrd);
		me.sksd('factNar', tabValue);
		tabValue.data = tabValue.data || me.getFactNarData();

		var pos = ArrayLib.find(tabValue.columns, ['dataIndex'], 'CHECKED');
		if (pos !== -1) tabValue.columns.splice(pos, 1);

		me.changeTab(me.getTab('FactNar'), true);
	},

	//Сборка данных
	dataCollectorFactNar: function() {
		var me = this;
		if (me.getTabVisible('FactNar')) {
			let factNar = me.gksd('factNar'),
				sumdocmoney = 0,
				data = me.gksc('tabNarGrid').store.getDataExt(),
				rows = [],
				fn = function(d) {
					if (d.CHECKED) {
						sumdocmoney += d.SUMMA;
						rows.push(d);
					}
				};
			
			if (data.length) {
				Ext.each(data, d => fn(d));
			} else if (factNar.data.length) {
				Ext.each(factNar.data, f => fn(f));
			}
			
			return {
				factNarSelect: JSON.stringify(rows),
				SUMDOCMONEY: sumdocmoney
			};
		}
		
		return _;
	},

	//перемещение строки в таблице нарушений
	factNarRowMove: function(moveFunc) {
		var grid = this.ksControls.tabNarGrid,
			sel = grid.getSelectionModel().getSelection();

		if (!sel.length) return;
		sel = sel[0].data;

		var data = grid.store.getDataExt(),
			iPos = ArrayLib.find(data, ['LINK'], sel.LINK);

		if (moveFunc(data, iPos)) {
			for (var i = 0, len = data.length; i < len; i++) {
				data[i].ORD = i + 1;
			}
		}
		grid.store.loadData(data);
	},

	//#endregion Нарушения

	//#region Требования

	//#region конструктор таба

	createTabNarRemove: function() {
		var me = this,
			tabReadOnly = me.gksd('narRemoveReadOnly');

		return Ext.create('Ext.panel.Panel',
			{
				title: 'Требования',
				layout: { type: 'vbox', align: 'stretch' },
				scrollable: true,
				items: [
					me.sksc('dictNarRemove',
						Ext.create('Ext.grid.Panel',
							{
								height: 300,
								border: 0,
								readOnly: me.readOnly,
								tbar: [
									Ext.create('Ext.Button',
										{
											iconCls: 'x_btn_new',
											tooltip: KS.L10n.DocumentsEditView_InitializeComponent_Создать,
											tooltipType: 'title',
											disabled: tabReadOnly,
											handler: function() {
												var narremLink = me.narRemoveLink--,
													newRec = { LINK: narremLink },
													factnarLst = [];
													
												// если отобрано одно нарушение, то заполняем данные
												var select = me.gksc('tabNarGrid').checked;
												if (select && select.length === 1) {
													var sel = select[0];
													factnarLst.push(sel.LINK);
													newRec.S_NAR_CODE = sel.CODE;
													newRec.S_NAR_NAME = sel.NAME;
													newRec.FACTNAR_SUMMA = sel.SUMNAR;
													newRec.ACT_NUMBER = sel.ACT_NUMBER;
													newRec.ACT_PAGE = sel.ACT_PAGE;
													newRec.S_PERSONC_NAME = sel.TEMP_SPERSONC_FIO;
													newRec.FACTNAR_CONTENT = sel.CONTENT;
													newRec.S_NAR_TYPE = me.gksd('disadvantage').indexOf(sel.S_NAR) === -1
														? 'Факт нарушения'
														: 'Недостаток';
												}
												let grid = me.gksc('dictNarRemove');
												sel = grid.getStore().add(newRec);
												grid.getSelectionModel().select(sel);
												
												me.gksd('narRemove').narremPersons[narremLink] = [];
												me.gksd('narRemove').narremFactnars[narremLink] = factnarLst;
											}
										}),
									Ext.create('Ext.Button',
										{
											key: 'same',
											iconCls: 'x_btn_copy',
											tooltip: KS.L10n.DocumentsEditView_InitializeComponent_Создать_подобную,
											tooltipType: 'title',
											disabled: true,
											handler: function() {
												var selected = me.gksc('dictNarRemove').selModel.getSelection();
												if (selected.length) {
													var narremLink = me.narRemoveLink--,
														rec = {};
													Object.assign(rec, selected[0].getData());
													delete rec.id;

													me.gksd('narRemove').narremPersons[narremLink] =
														Ext.clone(me.gksd('narRemove').narremPersons[rec.LINK]);
													me.gksd('narRemove').narremFactnars[narremLink] =
														Ext.clone(me.gksd('narRemove').narremFactnars[rec.LINK]);

													rec.LINK = narremLink;
													let grid = me.gksc('dictNarRemove');
														sel = grid.getStore().add(rec);
													grid.getSelectionModel().select(sel);
												}
											}
										}),
									Ext.create('Ext.Button',
										{
											key: 'delete',
											iconCls: 'x_btn_delete',
											tooltip: KS.L10n.DocumentsEditView_InitializeComponent_Удалить,
											tooltipType: 'title',
											disabled: true,
											handler: function() {
												var sel = me.gksc('dictNarRemove').selModel.getSelection();
												 
												if (sel.length) {

													let measures = me.gksc('gridMeasure') ?
														me.gksc('gridMeasure').getStore().query('NARREMOVE', sel[0].get('LINK')).items
														:null;

													let funcDel = function () {
														me.gksc('dictNarRemove').getStore().remove(sel);
														delete me.gksd('narRemove').narremPersons[sel[0].get('LINK')];
														delete me.gksd('narRemove').narremFactnars[sel[0].get('LINK')];
														if (measures) {
															measures.forEach(r => me.gksc('gridMeasure').getStore().remove(r));
														}
													};
													
													if (measures && measures.length > 0) {
														selectDialogShow(KS.L10n.attention, wmc.getContinueQuestion(KS.L10n.DocumentsEditView_tsbDeleteNarRemove_Click_К_требованию_привязаны_меры__При_удалении_требования_меры_будут_удалены_), function () {
															funcDel();
														});
													}
													else
														funcDel();
													
												}
											}
										}),
									Ext.create('Ext.Button',
										{
											iconCls: 'x_btn_print',
											tooltip: KS.L10n.DocumentsEditView_InitializeComponent_Печать,
											tooltipType: 'title',
											scope: me,
											handler: function() {
												Ext.ux.grid.Printer.print(me.gksc('dictNarRemove'),
													{
														title: this.title,
														printLinkText: 'Отправить на печать',
														closeLinkText: 'Закрыть'
													});
											}
										}),
									me.sksc('narRemFillBtn', Ext.create('Ext.Button',
										{
											iconCls: 'x_btn_fill',
											tooltip: KS.L10n.DocumentsEditView_InitializeComponent_Заполнить_из_нарушений,
											tooltipType: 'title',											
											disabled: tabReadOnly || !me.gksc('tabNarGrid').checked.length,
											handler: function () {
												var rec = me.gksc('dictNarRemove').selModel.getSelection()[0];

												if (rec) {
													me.fillNarRemoveSelfDialogShow(
														function() { me.fillNarRemove(); },
														function() { me.fillNarRemove(rec); }
													);
												} else {
													me.fillNarRemoveDialogShow(function() { me.fillNarRemove(); });
												}
											}
										}))
								],
								plugins: [Ext.create('Ext.grid.plugin.CellEditing', 
									{ 
										clicksToEdit: 1,
										listeners: {
											beforeedit: function(){
												if (tabReadOnly)
													return false;												
											}
										}
									}),
									'gridclipboard'],
								features: [
									{
										ftype: 'summary',
										showSummaryRow: false
									}
								],
								store: Ext.create('Ext.data.Store',
									{
										fields: [],
										data: [],
										proxy: 'memory'
									}),
								columns: [],
								columnLines: true,
								listeners: {
									select: function(th, record, index, eOpts) {
										if (me.gksd('narRemove').multiNar) {
											me.filterExtNarremove(record.get('LINK'));
										} else {
											me.gksc('narremTextArea').setValue(record.get('FACTNAR_CONTENT'));
										}
									},
									selectionchange: (_, sels) => me.enableToolsGrid(me.gksc('dictNarRemove'), sels, tabReadOnly)
								}
							})),
					{ xtype: 'splitter' },
					me.getExtNarremoveControls()
				]
			});
	},
	getExtNarremoveControls: function() {
		var me = this,
			multiNar = me.gksd('narRemove').multiNar;
		return Ext.create('Ext.panel.Panel',
			{
				flex: 1,
				bodyPadding: multiNar ? 0 : 5,
				layout: { type: 'vbox', align: 'stretch' },
				items: [
					multiNar
					? me.sksc('narremExt',
						Ext.create('Ext.grid.Panel',
							{
								flex: 1,
								tbar: [],
								store: Ext.create('Ext.data.Store',
									{
										fields: [],
										data: [],
										proxy: 'memory'
									}),
								columns: [],
								columnLines: true,
								plugins: ['gridclipboard']
							}))
					: me.sksc('narremTextArea',
						Ext.create('Ext.form.field.TextArea',
							{
								flex: 1,
								fieldLabel: 'Характер и обстоятельства нарушения',
								readOnlyCls: '',
								readOnly: true
							}))
				]
			});
	},
	fillNarRemoveDialogShow: function(yesFunc, noFunc, callBack) {
		Ext.Msg.show({
			title: KS.L10n.DocumentsEditView_tsbFillNarRemove_Click_Заполнение_требований,
			msg: KS.L10n.DocumentsEditView_InitializeComponent_Заполнить_из_нарушений + '?',
			buttons: Ext.MessageBox.YESNO,
			buttonText: { yes: 'Да', no: 'Нет' },
			fn: function(buttonId) {
				if (buttonId === 'yes') {
					if (yesFunc) yesFunc();
				} else {
					if (noFunc) noFunc();
				}
				if (callBack) callBack();
			},
			icon: Ext.MessageBox.QUESTION
		});
	},

	fillNarRemoveSelfDialogShow: function(yesFunc, extraFunc, noFunc, callBack) {
		Ext.Msg.show({
			title: KS.L10n.DocumentsEditView_tsbFillNarRemove_Click_Заполнение_требований,
			msg: KS.L10n.DocumentsEditView_InitializeComponent_Заполнить_из_нарушений + '?',
			buttons: Ext.MessageBox.YESNOCANCEL,
			buttonText: { yes: 'Да', no: 'Текущий', cancel: 'Нет' },
			fn: function(buttonId) {
				switch (buttonId) {
					case 'yes':
						if (yesFunc) yesFunc();
						break;
					case 'no':
						if (extraFunc) extraFunc();
						break;
					default:
						if (noFunc) noFunc();
				}
				if (callBack) callBack();
			},
			icon: Ext.MessageBox.QUESTION
		});
	},

	fillNarRemove: function (rec){
		var me = this;
		// todo: можно оптимизировать, сохраняя только лишь при наличии изменений

		// Для рассчета у новых отмеченных записей в кладке Нарушения необходимо сохранить документ,
		// т.к. в вебе механизм ключевых слов не увидит записей "с отрицательными линками"
		Ext.Msg.show({
			title: KS.L10n.attention,
			msg: 'Документ будет сохранен!',
			buttons: Ext.MessageBox.OKCANCEL,
			buttonText: { ok: 'Продолжить', cancel: 'Отмена' },
			fn: function(buttonId) {
				if (buttonId === 'ok') {
					me.saveData(function() {
						var docmoneyLinks = [];
						Ext.each(me.gksc('tabNarGrid').checked,
							function(r) { docmoneyLinks.push(r.LINK); });

						// Долгая команда 										
						me.showLoadMaskLong({
							msg: KS.L10n.loading_data,
							url: me.linkCode + '/FillNarremove_A',
							params: {
								link: me.getLink(),
								revizLink: me.ksData.row.REVIZ,
								narRemoveLink: rec ? rec.data.LINK : 0,
								docmoneyLinks: JSON.stringify(docmoneyLinks)
							},
							success: function(res) {
								if (res.data) {
									// Требования
									me.gksc('dictNarRemove').getStore().clearData();
									me.gksc('dictNarRemove').getStore().loadData(res.data, true);
									// Нарушения
									me.gksd('narRemove').narremFactnars = res.narremFactnars;
									// Исполнители
									me.gksd('narRemove').narremPersons = new Object();
									// дополнительные поля
									if (me.gksd('narRemove').multiNar) {
										me.filterExtNarremove(0);
									} else {
										me.gksc('narremTextArea').setValue();
									}
								}
							}
						});
					});
				}
			},
			icon: Ext.MessageBox.WARNING
		});
	},

	//#endregion конструктор таба

	//загрузка данных
	getExtraNarRemove: function(value) {
		var me = this,
			tabValue = value.NarRemove;

		me.sksd('narRemove', tabValue);
		me.sksd('narRemoveReadOnly', me.isTabReadOnly(value.Tabs, 'NARREMOVE'));

		me.changeTab(me.getTab('NarRemove'), true);
		me.adaptNarRemColumns(tabValue.columns);
		me.gksc('dictNarRemove').setMetaDate(tabValue, {
			profileCode: me.code, 
			profileKey: 'tabNarRemove',
			gateCode: me.keyEdit
		});
		if (me.gksd('narRemove').multiNar) {
			me.addFinancCol(tabValue.ext.columns);
			me.gksc('narremExt').setMetaDate(tabValue.ext,{
				profileCode: me.code,
				profileKey: 'narremExt',
				gateCode: me.keyEdit
			});
			me.filterExtNarremove();
		}
	},

	//Сборка данных
	dataCollectorNarRemove: function() {
		var me = this;
		return me.getTabVisible('NarRemove')
			? {
				gridData: me.gksc('dictNarRemove').getStore().getDataExt(),
				narremPersons: me.gksd('narRemove').narremPersons,
				narremFactnars: me.gksd('narRemove').narremFactnars
			}
			: _;
	},
	
	adaptNarRemColumns: function (cols) {
		var me = this;

		var summaCol = ArrayLib.filter(cols, ['dataIndex'], 'SUMMA')[0];
		if (summaCol)
			summaCol.editor = {
				xtype: 'calcfield',
				fieldLabel: '',
				decimalData: me.gksd('decimalData')
			};
		
		// Исполнители
		var personCol = ArrayLib.filter(cols, ['dataIndex'], 'TEMP_SPERSON_FIO')[0];
		if (personCol) {
			personCol.mode = 'MULTI';
			personCol.cleaningKey = false;
			me.defineCodeColumn(personCol, 'S_PERSON');
			personCol.ksGetValue = function (rec) {
				return me.gksd('narRemove').narremPersons[rec.get('LINK')].map(function(l) { return { LINK: l }; });
			};
			personCol.ksSetValue = function(v, rec) {
				var th = this;
				me.gksd('narRemove').narremPersons[rec.get('LINK')] = v.map(function(d) { return d.data.LINK; });

				rec.beginEdit();
				rec.set(th.fieldName, v.map(function(d) { return d.data.NAME; }).toString());
				rec.endEdit();
			};
			var orgs = me.gksc('T_REVIZ_OBJECTS').getValue().map(function (v) { return v.TLINK; });
			personCol.whereArgs = {
				SOrgs: { value: JSON.stringify(orgs), type: 'List_int' },
				InLinksOnly: { value: orgs.length ? 'False' : 'True', type: 'bool' },
				SRegions: {
					value: JSON.stringify(me.gksd('narRemove').regionWA),
					type: 'List_int'
				}
			};
			personCol.beforeHandler = function (callback, rec) {
				var th = this;
				var orgs = me.gksc('T_REVIZ_OBJECTS').getValue().map(function(v) { return v.TLINK || v.data.TLINK; });
				th.whereArgs.SOrgs.value = JSON.stringify(orgs);
				th.whereArgs.InLinksOnly.value = orgs.length ? 'False' : 'True';
				KsLib.tryRun(callback);
			};
		}

		// CONTENT, RESULT, COMMENT, COMMENT2
		var store = me.gksd('narRemove').store;
		for (var colName in store) {
			var col = ArrayLib.filter(cols, ['dataIndex'], colName.toString())[0];
			if (col)
				col.editor.store = store[colName].length ? store[colName] : [];
		}

		// Факт нарушения
		var commonCol = ArrayLib.filter(cols, ['dataIndex'], 'FACTNAR')[0];
		if (commonCol) {
			var narCol = ArrayLib.filter(commonCol.columns, ['dataIndex'], 'S_NAR_CODE')[0];
			if (narCol) {
				me.defineCodeColumn(narCol, 'S_NAR');
				narCol.editor = Ext.create({
					xtype: 'triggerdict',
					cleaningKey: false,
					dataIndex: 'S_NAR_CODE',
					handler: function () {
						var c = this,
							fnLinks = [];

						Ext.each(me.gksc('tabNarGrid').checked, function(fn) { fnLinks.push(fn.LINK); });
						
						dictFunc({
							mode: me.gksd('narRemove').multiNar ? 'MULTI' : 'SINGLE',
							parentView: me.gksc('dictNarRemove'),
							selectLinks: narCol.ksGetValue.call(narCol, c.editRecord),
							code: dnl.FACTNAR,
							head: false,
							hidePagging: true,
							hideFilterPanel: true,
							hideBottomPanel: true,
							needRefreshAfterSetData: false, // чтобы не уходило в бесконечный цикл
							btnsHide: {
								new: true,
								same: true,
								edit: true,
								delete: true,
								nastr_grid: true,
								profile: true,
								wrap: true,
								search: true,
								relations: true,
								journal: true,
								galka: !me.gksd('narRemove').multiNar,
								unmark: !me.gksd('narRemove').multiNar,
								edit_reviz: true,
								add_slave: true,
								expandall: true,
								collapseall: true,
								make_child: true,
								make_parent: true
							},
							viewCfg: function () {
								var cfg = this.callParent(arguments);
								cfg.title = 'Факты нарушений';
								return cfg;
							},
							getGridStoreCfg: function() {
								let cfg = this.callParent(arguments);
								cfg.proxy = 'memory';
								cfg.remoteSort = false;
								return cfg;
							},
							functions:{
								getData: function(endFunc) {
									me.getRevizFactNar('TabNarrem', endFunc);
								}
							},
							refresh: function() {
								this.getData(true);
							}
						}, {
							ok: function (value) {
								narCol.ksSetValue.call(narCol, value, c.editRecord);
								let code = value[0] ? (value[0].data || value[0]).TEMP_S_NAR_CODE : '';
								c.setValue(code);
							}
						});
					}
				});
				narCol.ksGetValue = function (rec) {
					return me.gksd('narRemove').narremFactnars[rec.get('LINK')].map(function (l) { return { LINK: l }; });
				};
				narCol.ksSetValue = function (v, rec) {
					var th = this,
						count = v.length,
						actNumber = null,
						actPage = null,
						summa = null,
						personcName = '',
						code = '',
						name = '',
						content = '',
						type = '';

					me.gksd('narRemove').narremFactnars[rec.get('LINK')] = v.map(function (d) { return d.data.LINK; });

					if (count === 1) {
						var d = v[0].data;
						actNumber = d.ACT_NUMBER;
						actPage = d.ACT_PAGE;
						summa = d.SUMMA;
						if (d.TEMP_S_PERSONC_NAME) {
							var fio = d.TEMP_S_PERSONC_NAME.split(' ');
							personcName = fio[0] + ' ' + fio[1][0] + '.' + fio[2][0] + '.';
						}
						code = d.TEMP_S_NAR_CODE;
						name = d.TEMP_S_NAR_NAME;
						content = d.CONTENT;
						type = me.gksd('disadvantage').indexOf(d.S_NAR) === -1
							? 'Факт нарушения'
							: 'Недостаток';
					} else if (count > 1) {
						code = name = 'Отобрано: ' + count;
					}
					
					rec.beginEdit();

					rec.set(th.fieldName, name);
					rec.set(th.fieldCode, code);
					rec.set('ACT_NUMBER', actNumber);
					rec.set('ACT_PAGE', actPage);
					rec.set('S_PERSONC_NAME', personcName);
					rec.set('FACTNAR_SUMMA', summa);
					rec.set('FACTNAR_CONTENT', content);
					rec.set('S_NAR_TYPE', type);

					rec.endEdit();

					if (me.gksd('narRemove').multiNar) {
						me.filterExtNarremove(rec.get('LINK'));
					} else {
						me.gksc('narremTextArea').setValue(rec.get('FACTNAR_CONTENT'));
					}
				};
			}
		}

		return cols;
	},

	getRevizFactNar: function(key, endFunc) {
		const me = this;

		loadProfile({
			code: dnl.FACTNAR,
			prefix: 'documents' + key,
			gateCode: 'DOCUMENT_FACTNAR',
			profileKey: key
		});

		ajaxRequest({
			url: 'SDocuments/GetNarrenFactNar_A',
			params: {
				link: me.getLink(),
				revizLink: me.ksData.row.REVIZ,
				factnar: JSON.stringify(me.dataCollectorFactNar())
			},
			success: function (res) {
				if (!res) return;
				endFunc({
					columns: res.columns,
					fields: res.fields,
					data: {data: res.data, total: res.data.length}
				});
			},
			failure: function () {
				showError(wmc.get('ErrorGetData'));
			}
		});
	},
	
	filterExtNarremove: function(link) {
		var me = this,
			store = me.gksc('narremExt').getStore(),
			factnars = me.gksd('narRemove').narremFactnars[link] || [];
		// при загузке формы, если уже есть фильтры, то не ставим фильтр, который ничего не возвращает
		if (link === _ && store.getFilters().items.length) return;
		store.clearFilter();
		store.filter([
			function(rec) {
				return factnars.indexOf(rec.get('LINK')) !== -1;
			}
		]);
	},

	updateNarremoveGrid: function (factnarLinks) {
		var me = this,
			narremStore = me.gksc('dictNarRemove').getStore(),
			narremFactnars = me.gksd('narRemove').narremFactnars,
			narremPersons = me.gksd('narRemove').narremPersons,
			delRecords = [];

		for (var key in narremFactnars) {
			var count = narremFactnars[key].length;
			if (!count) continue;

			narremFactnars[key] = narremFactnars[key].filter(function(d) { return factnarLinks.indexOf(d) !== -1; });

			if (count !== narremFactnars[key].length) {
				count = narremFactnars[key].length;
				var record = narremStore.data.items.filter(function(d) { return d.get('LINK') === +key; })[0];

				if (count < 1) {
					delRecords.push(record);
					if (narremPersons[key]) delete narremPersons[key];
				} else if (count === 1) {
					var link = me.gksd('narRemove').narremFactnars[+key][0],
						newData = me.gksc('tabNarGrid').getStore().getDataExt().filter(function(d) {
							return d.LINK === link;
						})[0];
					record.set('S_PERSONC_NAME', newData.TEMP_SPERSONC_FIO);
					record.set('ACT_NUMBER', newData.ACT_NUMBER);
					record.set('ACT_PAGE', newData.ACT_PAGE);
					record.set('S_NAR_CODE', newData.CODE);
					record.set('S_NAR_NAME', newData.NAME);
					record.set('FACTNAR_SUMMA', newData.SUMNAR);
				} else {
					record.set('S_NAR_CODE', 'Отобрано:' + count);
					record.set('S_NAR_NAME', 'Отобрано:' + count);
				}
			}
		}
		
		narremStore.remove(delRecords);
	},

	//#endregion Требования

	//#region Меры
	
	createTabMeasure: function() {
		var me = this;
			tabReadOnly = me.gksd('measureReadOnly');
		var tabMeasure = Ext.create('Ext.panel.Panel',
			{
				title: 'Меры',
				layout: { type: 'vbox', align: 'stretch' },
				scrollable: true,
				items: [
					me.sksc('gridMeasure',
						Ext.create('Ext.grid.Panel',
							{
								flex: 1,
								readOnly: me.readOnly,
								border: 0,
								tbar: [
									Ext.create('Ext.Button',
										{
											iconCls: 'x_btn_new',
											tooltip: KS.L10n.DocumentsEditView_InitializeComponent_Создать,
											tooltipType: 'title',
											disabled: tabReadOnly,
											handler: function() {
												let measureLink = me.measureLink--,
													newRec = { LINK: measureLink };
												// если отобрано одно требование, то заполняем данные
												var rows = me.gksc('dictNarRemove') ? me.gksc('dictNarRemove').getStore().getDataExt() : null;
												if (rows && rows.length === 1) {
												 	newRec.NARREMOVE = rows[0].LINK;
													newRec.TEMP_NARREMOVE_CONTENT = rows[0].CONTENT;
												}
												let grid = me.gksc('gridMeasure'),
													sel = grid.getStore().add(newRec);
												grid.getSelectionModel().select(sel);
											}
										}),
									Ext.create('Ext.Button',
										{
											key: 'same',
											iconCls: 'x_btn_copy',
											tooltip: KS.L10n.DocumentsEditView_InitializeComponent_Создать_подобную,
											tooltipType: 'title',
											disabled: true,
											handler: function() {
												var selected = me.gksc('gridMeasure').selModel.getSelection();
												if (selected.length) {
													let measureLink = me.measureLink--,
														rec = {};
													Object.assign(rec, selected[0].getData());
													delete rec.id;
													rec.LINK = measureLink;

													let grid = me.gksc('gridMeasure'),
														sel = grid.getStore().add(rec);
													grid.view.refresh();
													grid.getSelectionModel().select(sel);
												}
											}
										}),
									Ext.create('Ext.Button',
										{
											key: 'delete',
											iconCls: 'x_btn_delete',
											tooltip: KS.L10n.DocumentsEditView_InitializeComponent_Удалить,
											tooltipType: 'title',
											disabled: true,
											handler: function() {
												var sel = me.gksc('gridMeasure').selModel.getSelection();
												if (sel.length) {
												 	me.gksc('gridMeasure').getStore().remove(sel);												
												}
											}
										}),
								],
								plugins: [
									Ext.create('Ext.grid.plugin.CellEditing',
										{
											clicksToEdit: 1,
											listeners: {
												beforeedit: function () {
													if (tabReadOnly)
														return false;
												}
											}
										}),
									'gridclipboard'
								],
								features: [
									{
										ftype: 'summary',
										showSummaryRow: false
									}
								],
								store: Ext.create('Ext.data.Store',
									{
										fields: [],
										data: [],
										proxy: 'memory'
									}),
								columns: [],
								columnLines: true,
								listeners: {
									selectionchange: (_, sels) => me.enableToolsGrid(me.gksc('gridMeasure'), sels, tabReadOnly)
								}
							}))
				]
			});		
		return tabMeasure;
	},

	//загрузка данных
	getExtraMeasure: function(value) {
		var me = this,
			tabValue = value.Measure;

		me.sksd('measure', tabValue);
		me.sksd('measureReadOnly', me.isTabReadOnly(value.Tabs, 'MEASURE'));
		me.sksd('restrictedMeasureLinks', tabValue.restrictedMeasureLinks);
		
		me.changeTab(me.getTab('Measure'), true);
		me.adaptMeasureColumns(tabValue.columns);
		me.gksc('gridMeasure').setMetaDate(tabValue, {
			profileCode: me.code,
			profileKey: 'tabMeasure',
			gateCode: me.keyEdit
		});		
	},

	//Сборка данных
	dataCollectorMeasure: function() {
		var me = this;
		return me.getTabVisible('Measure') ? me.gksc('gridMeasure').getStore().getDataExt() : _;
	},

	adaptMeasureColumns: function (cols) {
		var me = this;

		Ext.each(cols, function(col, i) {
			switch (col.dataIndex) {
				case 'SUMMA':
					col.editor = {
						xtype: 'calcfield',
						fieldLabel: '',
						decimalData: me.gksd('decimalData')
					};
					break;
				case 'CNT':
					col.editor = {
						xtype: 'calcfield',
						fieldLabel: '',
						notDecimal: true
					};
					break;
				case 'COMMENT':
					var storeComment = me.gksd('measure').storeComment;
					col.editor.store = storeComment.length ? storeComment : [];
					break;
				case "TEMP_NARREMOVE_CONTENT":
					break;
			}
		});

		let colMeasureHeader = ArrayLib.filter(cols, ['text'], "Тип меры")[0];
		let colMeasureCode = colMeasureHeader && colMeasureHeader.columns.length ? colMeasureHeader.columns[0] : null;
		if (colMeasureCode){
			colMeasureCode.width = 150;
			colMeasureCode.xtype = 'dictcolumn';
			colMeasureCode.code = dnl.S_MEASURE;
			colMeasureCode.mode = 'SINGL';
			colMeasureCode.disallowedToCheckLinks = me.gksd('restrictedMeasureLinks');
			colMeasureCode.renderer = function(v, m) {
				m.innerCls = 'x_btn_dict';
				m.style += ' background-repeat: no-repeat; background-position: right; display: block;';
				return v;
			};			
			colMeasureCode.defaultRenderer = function(v, m, r) { return (v || (r ? (r.data || r)["TEMP_SMEASURE_CODE"] : _)) || _; };
			colMeasureCode.ksGetValue = function (rec) {
				return [{LINK: rec.get("S_MEASURE")}];
			};
			colMeasureCode.ksSetValue = function (v, rec) {
				var d = v[0];
				d = d ? (d.data || d) : {};
				rec.beginEdit();
				rec.set('S_MEASURE', d.LINK);
				rec.set('TEMP_SMEASURE_CODE', d.CODE);
				rec.set('TEMP_SMEASURE_NAME', d.NAME);
				rec.endEdit();
			}			
		}

		var me = this;
		var nrCol = ArrayLib.filter(cols, ['dataIndex'], 'TEMP_NARREMOVE_CONTENT')[0];
		if (nrCol) {
			nrCol.xtype = 'dictcolumn';
			nrCol.code = 'DICTIONARY_NARREMOVE';
			nrCol.fieldLink = 'NARREMOVE';
			nrCol.fieldName = 'TEMP_NARREMOVE_CONTENT';
			
			nrCol.defaultRenderer = function(v, m, r) { return (v || (r ? (r.data || r)['TEMP_NARREMOVE_CONTENT'] : _)) || _; };
			nrCol.ksGetValue = function(rec) {
				var th = this;
				return [{ LINK: rec.get(th.fieldLink) }];
			};
			nrCol.ksSetValue = function(v, rec) {
				var th = this,
					d = v[0];

				if (d) {
					d = d.data || d;
				} else
				{
					d = { LINK: 0};
				}

				rec.beginEdit();
				rec.set(th.fieldLink, d.LINK);
				rec.set(th.fieldName, d.CONTENT);
				rec.endEdit();
			};
			
			nrCol.editor = Ext.create({
				xtype: 'triggerdict',
				cleaningKey: false,
				dataIndex: 'TEMP_NARREMOVE_CONTENT',
				trgClick: function () {
					var c = this;					
					dictFunc({
						mode: 'SINGLE',
						parentView: me.gksc('gridMeasure'),
						selectLinks: ArrayLib.copy(nrCol.ksGetValue.call(nrCol, c.editRecord)) ,
						code: 'DICTIONARY_NARREMOVE',
						head: false,
						hidePagging: true,
						footerPanel: false,
						isFake: true,
						btnsHide: {
							new: true,
							same: true,
							edit: true,
							delete: true,
							settings: true,
							profile: true,
							wrap: true,
							search: true,
							relations: true,
							journal: true,
							galka: true,
							unmark: true,
							edit_reviz: true,
							add_slave: true,
							expandall: true,
							collapseall: true,
							make_child: true,
							make_parent: true
						},
						viewCfg: function () {
							var cfg = this.callParent(arguments);
							cfg.title = 'Требования по устранению';
							return cfg;
						},										
						baseRefresh: function(callBack) { callBack(me.getNarRemoveListData().data); },
						baseGetData: function(callBack) { callBack(me.getNarRemoveListData()); },
						createItems: function () {
							let meList = this,
								multiNar = me.gksd('narRemove').multiNar,
								res = meList.callParent(arguments);
							if (this.f) return res;
							
							meList.factnarFC = Ext.create('Ext.panel.Panel',
								{
									flex: 1,
									bodyPadding: multiNar ? 0 : 5,
									layout: { type: 'vbox', align: 'stretch' },
									items: [
										multiNar
											? me.sksc('narRemoveExtraSelect_Grid',Ext.create('Ext.grid.Panel',
												{
													flex: 1,
													tbar: [],
													store: Ext.create('Ext.data.Store',
														{
															fields: [],
															data: [],
															proxy: 'memory'
														}),
													columns: [],
													columnLines: true,
													plugins: ['gridclipboard']
												}))
											: me.sksc('narRemoveExtraSelect_Text', Ext.create('Ext.form.field.TextArea',
												{
													flex: 1,
													fieldLabel: 'Характер и обстоятельства нарушения',
													readOnlyCls: '',
													readOnly: true
												}))
									]
								});

							res.splice(1, 0, meList.factnarFC);
							if (multiNar) {
								me.gksc('narRemoveExtraSelect_Grid').setMetaDate(me.gksd('narRemove').ext, {
									profileCode: me.code,
									profileKey: 'narRemoveExtraSelect_Grid',
									gateCode: me.keyEdit
								});
							}
						}
					}, {
						ok: function (value) {
							nrCol.ksSetValue.call(nrCol, value, c.editRecord);
							let code = value[0] ? (value[0].data || value[0]).CONTENT : '';
							c.setValue(code);
						},						
						select: function(th, rec){
							if (me.gksd('narRemove').multiNar) {
								let link = rec.get('LINK'),
									store = me.gksc('narRemoveExtraSelect_Grid').getStore(),
									factnars = me.gksd('narRemove').narremFactnars[link] || [];
								
								if (link === _ && store.getFilters().items.length) return;
								store.clearFilter();
								store.filter([
									function(rec) {
										return factnars.indexOf(rec.get('LINK')) !== -1;
									}
								]);
							} else {
								me.gksc('narRemoveExtraSelect_Text').setValue(rec.get('FACTNAR_CONTENT'));
							}
						}
					})
				}
			});
			nrCol.ksGetValue = function (rec) {
				var links = rec.get('NARREMOVE') 
					? [rec.get('NARREMOVE')].map(function (link) { return { LINK: link }; })
				: [];
				return links;
			};
			nrCol.ksSetValue = function (v, rec) {
				var d = v && v.length ? v[0].data : null;				
				rec.beginEdit();
				rec.set('NARREMOVE', d ? d.LINK : null);
				rec.set('TEMP_NARREMOVE_CONTENT', d ? d.CONTENT: null);
				rec.endEdit();				
			};
		}
	},

	//#endregion Меры
	
	getNarRemoveListData: function() {
		var me = this,
			listData = me.gksd('narRemove'),
			data = me.gksc('dictNarRemove').getStore().getDataExt(),
			cols = Ext.clone(listData.columns);
		cols.filter(col => col.dataIndex == 'FACTNAR' || col.dataIndex == 'TEMP_SPERSON_FIO').forEach(col => col.hidden = true);
		var res = { data: { data: data, total: 0 }, columns: cols, fields: listData.fields };
		return res;
	},	

	//#region Ответственность

	//#region конструктор таба

	createTabRespons: function() {
		var me = this,
			isOutDoc = me.gksd('IsOutDoc');
		return me.sksc('tabRespons', Ext.create('Ext.grid.Panel', {
			title: 'Ответственность',
			border: 0,
			scrollable: true,
			tbar: [
				me.sksc('tabResponsBtnNew', Ext.create('Ext.Button', {
					iconCls: 'x_btn_new',
					tooltip: KS.L10n.DocumentsEditView_InitializeComponent_Создать,
					disabled: isOutDoc,
					tooltipType: 'title',
					handler: function() {
						var grid = me.gksc('tabRespons'),
							fnSelect = me.gksc('tabNarGrid').checked,
							rec = grid.store.add({})[0];

						if (fnSelect && fnSelect.length === 1) {
							rec.set('FACTNAR', fnSelect[0].LINK);
							rec.set('FACTNAR_S_NAR_CODE', fnSelect[0].CODE);
							rec.set('FACTNAR_S_NAR_NAME', fnSelect[0].NAME);
							rec.set('FACTNAR_ACT_NUMBER', fnSelect[0].ACT_NUMBER);
							rec.set('FACTNAR_ACT_PAGE', fnSelect[0].ACT_PAGE);

							rec.set('FACTNAR_S_NAR_TYPE', me.gksd('disadvantage').indexOf(fnSelect[0].S_NAR) === -1
								? 'Факт нарушения'
								: 'Недостаток');
							
							if (fnSelect[0].S_RESPONS) {
								rec.set('S_RESPONS', fnSelect[0].S_RESPONS);
								rec.set('TEMP_SRESPONS_CODE', fnSelect[0].S_RESPONS_CODE);
								rec.set('TEMP_SRESPONS_NAME', fnSelect[0].S_RESPONS_NAME);
								me.responsFillSummDialog(rec);
							}

							me.getSArticleByFactNar(fnSelect[0].LINK, _, _, rec);
						}
						// по умолчанию ставим тип 'ЮЛ'
						rec.set('type', 1);
					}
				})),
				me.sksc('tabResponsBtnDel', Ext.create('Ext.Button', {
					iconCls: 'x_btn_delete',
					tooltip: KS.L10n.DocumentsEditView_InitializeComponent_Удалить,
					disabled: isOutDoc,
					tooltipType: 'title',
					handler: function() { me.gksc('tabRespons').removeSelection(); }
				}))
			],
			features: [
				{
					ftype: 'summary',
					showSummaryRow: false
				}
			],
			plugins: [Ext.create('Ext.grid.plugin.CellEditing', { clicksToEdit: 1 }), 'gridclipboard'],
			store: Ext.create('Ext.data.Store', {
				fields: [],
				data: [],
				proxy: 'memory'
			}),
			columns: [],
			columnLines: true
		}));
	},

	//#endregion конструктор таба

	defineCodeColumn: function(col, dataIndex, afterSet) {
		col.xtype = 'dictcolumn';
		col.code = dnl[dataIndex];
		col.renderer = function(v, m) {
			m.innerCls = 'x_btn_dict';
			m.style += ' background-repeat: no-repeat; background-position: right; display: block;';
			return v;
		};
		col.defaultRenderer = function(v, m, r) { 
			return (v || (r ? (r.data || r)[dataIndex] : _)) || _; 
		};
		col.ksGetValue = function(rec) {
			var th = this;
			return [{ LINK: rec.get(th.fieldLink), NAME: rec.get(th.fieldName), CODE: rec.get(th.fieldCode) }];
		};
		col.ksSetValue = function(v, rec) {
			var th = this,
				d = v[0];

			var extPrefix = dataIndex === 'FACTNAR_S_NAR' ? 'TEMP_S_NAR_' : '';

			if (d) {
				d = d.data || d;
			} else
			{
				d = { LINK: 0};
				d[extPrefix + 'NAME'] = '';
				d[extPrefix + 'CODE'] = '';
			}

			rec.beginEdit();
			rec.set(th.fieldLink, d.LINK);
			rec.set(th.fieldName, d[extPrefix + 'NAME']);
			rec.set(th.fieldCode, d[extPrefix + 'CODE']);
			if (dataIndex === 'FACTNAR_S_NAR') {
				rec.set('FACTNAR_ACT_NUMBER', d['ACT_NUMBER']);
				rec.set('FACTNAR_ACT_PAGE', d['ACT_PAGE']);
				rec.set('FACTNAR_S_NAR_TYPE', th.disadvantage.indexOf(d['S_NAR']) === -1
					? 'Факт нарушения'
					: 'Недостаток');
				
				rec.set('S_PERSON', d['S_PERSONC']);
				rec.set('TEMP_SPERSON_CODE', d['TEMP_S_PERSONC_CODE']);
				rec.set('TEMP_SPERSON_FIO', d['TEMP_S_PERSONC_NAME']);

				// очистка остальных данных
				Ext.each([
						'TEMP_SRESPONS_CODE', 'TEMP_SRESPONS_NAME',
						'TEMP_SNPA_CODE', 'TEMP_SNPA_NAME', 'VAL', 'maxDecimalVal', 'minDecimalVal', 'TEMP_SARTICLE_CODE'
					],
					function(i) {
						rec.set(i, '');
					});
				Ext.each(['S_ARTICLE', 'TEMP_SPERSON_LINK', 'S_RESPONS', 'TEMP_SNPA', 'unit'],
					function(i) {
						rec.set(i, 0);
					});
				rec.set('type', 1);
			}

			if (dataIndex === 'S_RESPONS') {
				// очистка данных Суммы
				Ext.each(['VAL', 'maxDecimalVal', 'minDecimalVal'], function(i) { rec.set(i, ''); });
				rec.set('unit', 0);
				rec.set('type', 1);
			}

			if (th.afterSet) th.afterSet(rec, d);

			rec.endEdit();
		};
		var names = { S_ARTICLE: 'TEMP_SARTICLE', S_RESPONS: 'TEMP_SRESPONS', S_PERSON: 'TEMP_SPERSON' };
		col.fieldLink = dataIndex === 'FACTNAR_S_NAR' ? 'FACTNAR' : dataIndex;
		col.fieldName = (names[dataIndex] || dataIndex) + '_' + (dataIndex === 'S_PERSON' ? 'FIO' : 'NAME');
		col.fieldCode = (names[dataIndex] || dataIndex) + '_' + 'CODE';
		col.afterSet = afterSet;
	},

	///<summary>
	/// Получить запись NAR_RESPONS_VALUES
	///</summary>
	///<param name="sNar">Ссылка на вид нарушения</param>startEdit
	///<param name="sRespons">Ссылка на вид ответственности</param>
	///<param name="type">Тип объекта</param>
	///<returns></returns>
	getNarResponsValueRow: function(sNar, sRespons, type, callBack) {
		var me = this,
			nrv = me.gksd('NAR_RESPONS_VALUES'),
			key = sNar + '_' + sRespons + '_' + type;
		if (nrv[key]) {
			KsLib.tryRun(callBack, me, nrv[key]);
		} else {
			ajaxRequest({
				url: 'SNar/GetNarResponsValueRow_A',
				params: { sNar: sNar, sRespons: sRespons, type: type },
				success: function(v) { KsLib.tryRun(callBack, me, nrv[key] = v); }
			});
		}
	},

	responsFillSummDialog: function(rec, v) {
		var me = this,
			fnLink = rec.get('FACTNAR'),
			fnRow = me.getFactNarRow(fnLink);

		if (fnRow) {
			me.getNarResponsValueRow(fnRow.S_NAR, rec.data.S_RESPONS, fnRow.OBJECT_TYPE, function (r) {
				if (!r) return
				rec.set('type', r.TYPE);
				var max = r.MAX_VAL,
					min = r.MIN_VAL,
					unit = r.UNIT,

					isMaxMin = Ext.isNumber(max) && Ext.isNumber(min);
				if (!isMaxMin) {
					max = r.MAX_VAL;
					min = r.MIN_VAL;
					unit = r.UNIT;
					isMaxMin = true;
				}

				if (isMaxMin) {
					var bt = {},
						btnTxt = ['Мин.', 'Макс.', 'Нет'],
						i = 0;

					for (i; i < 3; i++) bt[Ext.Msg.buttonIds[i]] = btnTxt[i];

					Ext.Msg.show({
						title: KS.L10n.DocumentsEditView_FillResponsVal_Заполнение_суммы_штрафа_срока,
						buttons: Ext.MessageBox.YESNO,
						buttonText: bt,
						msg: KS.L10n.DocumentsEditView_FillResponsVal_Заполнить_фактическое_значение_суммы_штрафа_срока_,
						fn: function(buttonId) {
							if (buttonId === 'ok') rec.set('VAL', min);
							if (buttonId === 'yes') rec.set('VAL', max);
						},
						icon: Ext.MessageBox.QUESTION
					});

					rec.set('maxDecimalVal', max);
					rec.set('minDecimalVal', min);
					rec.set('unit', unit);
				} else {
					rec.set('maxDecimalVal', 0);
					rec.set('minDecimalVal', 0);
					rec.set('unit', 0);
				}
			});
		}
	},

	responsColumnsAdapted: function(columns) {
		var me = this;

		//#region Сумма штрафа/срок/%

		var sumGroupCol = ArrayLib.filter(columns, ['dataIndex'], 'sumGroupCol')[0];
		var valCol = ArrayLib.filter(sumGroupCol.columns, ['dataIndex'], 'VAL')[0];
		if (valCol) {
			valCol.editor = {
				xtype: 'calcfield',
				fieldLabel: '',
				decimalData: me.gksd('decimalData'),
				listeners: {
					blur: function(th) {
						var grid = me.getTab('Respons'),
							sel = grid.getSelectionModel().getSelection()[0] ?? grid.store.getData().items[0],
							val = th.getNumValue(),
							max = this.parseTextToNum(sel.get('maxDecimalVal')),
							min = this.parseTextToNum(sel.get('minDecimalVal'));

						if (min > val || val > max) {
							selectDialogShow(KS.L10n, wmc.getContinueQuestion(min > val ? KS.L10n.DocumentsEditView_gridRespons_BeforeExitEditMode_Значение_меньше_минимального_ : KS.L10n.DocumentsEditView_gridRespons_BeforeExitEditMode_Значение_больше_максимального_), function () {
								th.setValue(val);
							}, function() {
								var cols = grid.headerCt && grid.headerCt.items && grid.headerCt.items.items,
									sumGroupCol = ArrayLib.filter(cols || [], ['dataIndex'], 'sumGroupCol')[0],
									col = ArrayLib.filter(sumGroupCol.gridDataColumns || [], ['dataIndex'], 'VAL')[0];
									
								if (col) grid.editingPlugin.startEdit(sel, col);
							});
						}
					}
				},
				getValue: function() {
					return this.rawToValue(this.processRawValue(this.getRawValue()));
				}
			};
		}

		//#endregion Сумма штрафа/срок/%

		//#region Статья НПА

		var artCol = ArrayLib.filter(columns, ['dataIndex'], 'S_ARTICLE')[0],
			artCodeCol = ArrayLib.filter(artCol.columns, ['dataIndex'], 'TEMP_SARTICLE_CODE')[0],
			npaCol = ArrayLib.filter(artCol.columns, ['dataIndex'], 'TEMP_SNPA_NAME')[0];
		artCol.text = 'Статья НПА';
		if (artCodeCol) {
			me.defineCodeColumn(artCodeCol, 'S_ARTICLE', function(rec, v) { rec.set('TEMP_SNPA_NAME', (v && v.S_NPA_NAME) || ''); });
			artCodeCol.whereArgs = { InLinks: { value: '[]', type: 'List_int' }, InLinksOnly: { value: 'True', type: 'bool' } };
			//todo можно на сам список повесить Factnar WhereArg 
			artCodeCol.beforeHandler = function(callback, rec) {
				var c = this;
				const loadMask = new Ext.LoadMask({
					msg: KS.L10n.loading_data,
					view: me,
					rid: me.getSArticleByFactNar(rec.data.FACTNAR,
						function(links) { c.whereArgs.InLinks.value = links; },
						function() {
							loadMask.destroy();
							KsLib.tryRun(callback);
						}, _)
				});
				loadMask.show();
			};
		}
		if (npaCol) npaCol.dataIndex = 'TEMP_SNPA_NAME';

		//#endregion Статья НПА

		//#region Вид ответственности

		var respCol = ArrayLib.filter(columns, ['dataIndex'], 'S_RESPONS')[0],
			respCodeCol = ArrayLib.filter(respCol.columns, ['dataIndex'], 'TEMP_SRESPONS_CODE')[0];
		if (respCodeCol) {
			me.defineCodeColumn(respCodeCol, 'S_RESPONS', function(rec, v, clear) {
				me.responsFillSummDialog(rec, v, clear);

				if (rec.get('S_PERSON') && rec.get('VAL') > 0) {
					selectDialogShow(KS.L10n.DocumentsEditView_FillResponsVal_Очистка_суммы_штрафа_срока, KS.L10n.DocumentsEditView_FillResponsVal_Очистить_фактическое_значение_суммы_штрафа_срока_, function () { rec.set('VAL', 0); });
				}
			});
			respCodeCol.initWhereArgs = function(rec) {
				var fnLink = rec.get('FACTNAR'),
					fn = me.getFactNarRow(fnLink);

				return fn && fn.S_NAR
					? {
						SNar: { value: fn.S_NAR, type: 'int' },
						Type: { value: fn.OBJECT_TYPE, type: 'int'}
					}
					: {
						InLinksOnly: { value: 'True', type: 'bool' },
						InLinks: { value: '[]', type: 'List_int' }
					};
			};
			respCodeCol.getInputDicts = function (rec) {
				var fnLink = rec.get('FACTNAR'),
					fn = me.getFactNarRow(fnLink);
				return [
					Ext.create('InputEditDict',
						{ name: 'S_NAR', data: fn ? fn.S_NAR : 0 })
				];
			};
		}

		//#endregion Вид ответственности

		//#region Нарушитель

		var persCol = ArrayLib.filter(columns, ['dataIndex'], 'S_PERSON')[0],
			persCodeCol = ArrayLib.filter(persCol.columns, ['dataIndex'], 'TEMP_SPERSON_CODE')[0];
		if (persCodeCol) {
			me.defineCodeColumn(persCodeCol, 'S_PERSON', function(rec, v, clear) {
				me.responsFillSummDialog(rec, v, clear);

				if (rec.get('S_PERSON') && rec.get('VAL') > 0) {
					selectDialogShow(KS.L10n.DocumentsEditView_FillResponsVal_Очистка_суммы_штрафа_срока, KS.L10n.DocumentsEditView_FillResponsVal_Очистить_фактическое_значение_суммы_штрафа_срока_, function () { rec.set('VAL', 0); }, Ext.emptyFn);
				}
			});
			persCodeCol.initWhereArgs = function() {
				var revizObj = _,
					SOrgs = [],
					inLinks = [],
					inLinkOnly = false;

				var sel = me.getTab('Respons').selModel.getSelection();
				if (sel.length) {
					var factnar = sel[0].get('FACTNAR');
					if (factnar !== 0) {
						var revizObj = me.gksd('tRevizObjects').data.filter(function(i) {
							return i.FACTNAR.indexOf(factnar) !== -1;
						});
						if (revizObj.length) {
							revizObj = revizObj[0];
						}
					}
				}

				if (revizObj) {
					if (revizObj.TTABLE === "S_ORG") {
						SOrgs.push(revizObj.TLINK);
					} else if (revizObj.TTABLE === "S_PERSON") {
						inLinks.push(revizObj.TLINK);
					}
				} else {
					inLinkOnly = true;
				}

				return {
					SOrgs: { value: JSON.stringify(SOrgs), type: 'List_int' },
					InLinksOnly: { value: inLinkOnly ? 'True' : 'False', type: 'bool' },
					InLinks: { value: JSON.stringify(inLinks), type: 'List_int' }
				}
			};
		}

		//#endregion Нарушитель

		//#region Факт нарушения

		var fnCol = ArrayLib.filter(columns, ['dataIndex'], 'FACTNAR')[0],
			fnCodeCol = ArrayLib.filter(fnCol.columns, ['dataIndex'], 'FACTNAR_S_NAR_CODE')[0];
		if (fnCodeCol) {
			me.defineCodeColumn(fnCodeCol, 'FACTNAR_S_NAR', function(rec, v, clear) {
				if (clear) {
					var clearArr = ['S_PERSON', 'S_RESPONS', 'TEMP_SNPA', 'S_ARTICLE'],
						fnLink = rec.get('FACTNAR'),
						fnCurrent = ArrayLib.filter(me.gksc('tabNarGrid').checked, ['LINK'], fnLink)[0];

					rec.beginEdit();
					Ext.each(clearArr, function(key) {
						rec.set(key, 0);
						rec.set(key + '_CODE', '');
						rec.set(key + '_NAME', '');
					});
					rec.endEdit();

					me.responsFillSummDialog(rec, v, clear);

					rec.set('VAL', fnCurrent.SUMMA);
				}

				var factNarRec = me.gksc('tabNarGrid').getStore().getDataExt().filter(function(i) {
					return i.LINK === rec.data.FACTNAR;
				});
				if (factNarRec.length && factNarRec[0].S_RESPONS) {
					rec.set('S_RESPONS', factNarRec[0].S_RESPONS);
					rec.set('TEMP_SRESPONS_CODE', factNarRec[0].S_RESPONS_CODE);
					rec.set('TEMP_SRESPONS_NAME', factNarRec[0].S_RESPONS_NAME);

					me.responsFillSummDialog(rec);
				}
			});

			fnCodeCol.editor = Ext.create({
				xtype: 'triggerdict',
				cleaningKey: false,
				dataIndex: 'FACTNAR_S_NAR_CODE',
				handler: function() {
					var c = this,
						fnLinks = [];

					Ext.each(me.gksc('tabNarGrid').checked, function(fn) { fnLinks.push(fn.LINK); });

					dictFunc({
						mode: 'SINGL',
						parentView: me.gksc('tabRespons'),
						selectLinks: fnCodeCol.ksGetValue.call(fnCodeCol, c.editRecord),
						code: dnl.FACTNAR,
						head: false,
						hidePagging: true,
						btnsHide: {
							new: true,
							same: true,
							edit: true,
							delete: true,
							settings: true,
							profile: true,
							wrap: true,
							search: true,
							relations: true,
							journal: true,
							galka: true,
							unmark: true,
							edit_reviz: true,
							add_slave: true,
							expandall: true,
							collapseall: true,
							make_child: true,
							make_parent: true
						},
						footerPanel: false,
						hideFilterPanel: true,
						needRefreshAfterSetData: false, // чтобы не уходило в бесконечный цикл
						viewCfg: function() {
							var cfg = this.callParent(arguments);
							cfg.title = 'Факты нарушений';
							return cfg;
						},						
						getGridStoreCfg: function() {
							let cfg = this.callParent(arguments);
							cfg.proxy = 'memory';
							cfg.remoteSort = false;
							return cfg;
						},
						functions:{
							getData: function(endFunc) {
								me.getRevizFactNar('TabRespons', endFunc);
							},
						},
						refresh: function() {
						 	this.getData(true);
						}
					}, {
						ok: function(value) {
							fnCodeCol.ksSetValue.call(fnCodeCol, value, c.editRecord);
							let val = value[0] ? value[0].data || value[0] : {},
								code = val.TEMP_S_NAR_CODE || '',
								link = val.LINK || 0;
							c.setValue(code);
							me.getSArticleByFactNar(link, _, _, c.editRecord);
						}
					});
				}
			});

			fnCodeCol.disadvantage = me.gksd('disadvantage');
		}

		//#endregion Факт нарушения
	},

	getSArticleByFactNar: function(factnar, success, callback, rec) {
		return ajaxRequest({
			url: 'SArticle/GetLinksByFactNar_A',
			params: { reviz: this.gksd('row').REVIZ, factnar: factnar * 1 },
			success: function(value) {
				if (value.error) {
					showError(value.error);
				} else {
					if (rec && value.row) {
						rec.set('S_ARTICLE', value.row.LINK);
						rec.set('TEMP_SARTICLE_CODE', value.row.CODE);
						rec.set('S_ARTICLE_NAME', value.row.NAME);
						rec.set('TEMP_SNPA_NAME', value.row.S_NPA_NAME || '');
					}
					success && success(JSON.stringify(value.links || []));
				}
			},
			callback: function(value) { callback && callback(value); }
		});
	},

	//загрузка данных
	getExtraRespons: function(value) {
		var me = this,
			tabValue = value.Respons;
		
		me.sksd('isRespons', true);
		me.sksd('ResponsTabValue', tabValue);
		me.responsColumnsAdapted(tabValue.columns);
		if (tabValue.fields.indexOf('unit') === -1) tabValue.fields.push('unit', 'minDecimalVal', 'maxDecimalVal', 'type');
		me.changeTab(me.getTab('Respons'), true);
		me.getTab('Respons').setMetaDate(tabValue, {
			profileCode: me.code,
			profileKey: 'tabRespons',
			gateCode: me.keyEdit
		});
	},

	//Сборка данных
	dataCollectorRespons: function() {
		var me = this;
		return me.getTabVisible('Respons') ? me.getTab('Respons').store.getDataExt() : _;
	},

	//#endregion Ответственность

	//#region Документы по запросу

	//#region конструктор таба

	createTabDocRequest: function() {
		var me = this;

		return Ext.create('Keysystems.Controls.GroupingGrid', {
			title: 'Документы по запросу',
			sortField: 'ORD',
			sortDirection: 'ASC',
			groupLinkField: 'S_RPROG',
			groupNameField: 'NAME',
			subNameField: 'S_RDOC_NAME',
			groupBoldTxt: false,
			viewConfig: { layout: { type: 'vbox', align: 'stretch' } },
			listeners: {
				beforeselect: function(th, record) {
					var grid = me.getTab('DocRequest'),
						selectedGroup = grid.selectedGroup || record.data.group,
						emptyRec = record.get('LINK') === 0;

					me.gksc('docReqBtnDict').setDisabled(!emptyRec);
					me.gksc('docReqBtnDel').setDisabled(emptyRec);
					grid.setGroupSelect(th.view.id, selectedGroup, emptyRec ? false : selectedGroup);
				}
			},
			tbar: [
				me.sksc('docReqBtnDict', Ext.create('Ext.Button', {
					iconCls: 'x_btn_dict',
					tooltip: KS.L10n.DocumentsEditView_InitializeComponent_Выбрать,
					disabled: true,
					tooltipType: 'title',
					handler: function() {
						var grid = me.getTab('DocRequest'),
							sel = grid.selModel.getSelection();

						if (!sel.length) sel = [grid.store.getAt(0)];

						if (sel && sel.length) {
							sel = sel[0];
							var list = [],
								groupName = sel.data.group,
								groupLink = sel.data.S_RPROG,
								gData = grid.store.getClearData(groupName),
								len = gData.length,
								i = 0;

							for (i; i < len; i++) {
								list.push({ data: { LINK: gData[i].S_RDOC, CODE: gData[i].S_RDOC_CODE, NAME: gData[i].S_RDOC_NAME } });
							}

							dictFunc(
								{ mode: 'MULTI', checkList: list, code: dnl.S_RDOC },
								{ ok: function(value) { me.setSRdoc(value, groupName, groupLink); } }
							);
						}
					}
				})),
				me.sksc('docReqBtnDel', Ext.create('Ext.Button', {
					iconCls: 'x_btn_delete',
					tooltip: KS.L10n.DocumentsEditView_InitializeComponent_Удалить,
					disabled: true,
					tooltipType: 'title',
					handler: function() {
						var grid = me.getTab('DocRequest'),
							sel = grid.selModel.getSelection();

						if (sel.length && sel[0].data.LINK !== 0) {
							sel = sel[0];
							selectDialogShow(KS.L10n.delete, wmc.get('DeleteMessage'), function () {
								sel.data.LINK === 0 ? grid.deleteGroupData(sel.data.group) : grid.store.remove(sel);
							});
						}
					}
				})),
				me.sksc('docReqBtnFill', Ext.create('Ext.Button', {
					iconCls: 'x_btn_fill',
					tooltip: KS.L10n.DocumentsEditView_InitializeComponent_Заполнить,
					tooltipType: 'title',
					handler: function() { me.fillDocReqGrid(false); }
				}))
			]
		});
	},

	//#endregion конструктор таба

	//Задать виды проверяемых документов вопросу программы
	setSRdoc: function(value, groupName, groupLink, group) {
		var me = this,
			newData = [],
			pos,
			grid = me.getTab('DocRequest'),
			store = grid.store;

		grid.getSelectionModel().deselectAll();

		if (!group) {
			var tmpGroup = ArrayLib.filter(grid.groups, ['LINK'], groupLink);
			group = tmpGroup.length ? tmpGroup[0] : grid.groups[0];
		}

		var oldData = store.getClearData(groupName);

		for (var i = 0, len = value.length; i < len; i++) {
			var val = value[i];
			if (val.data) val = val.data;
			pos = ArrayLib.find(oldData, ['S_RDOC'], val.LINK);
			if (pos === -1) {
				//Добавляем
				newData.push({
					LINK: me.sRDocLink--,
					DOCUMENTS: me.getLink(),
					S_RDOC: val.LINK,
					S_RDOC_NAME: val.NAME,
					S_RPROG: group.LINK,
					FILES_FILLED: val.FILES,
					group: group.NAME,
					TEMP_EXTEXAMPLE: val.TEMP_EXT
				});
			} else {
				newData.push(oldData[pos]);
			}
		}

		grid.deleteGroupData(groupName);
		store.loadData(newData, true);
	},

	//Заполнить виды проверяемых документов по вопросам программы
	fillDocReqGrid: function(save) {
		var me = this,
			tab = me.getTab('DocRequest');

		ajaxRequest({
			url: me.linkCode + '/FillDocRequest_A',
			params: { link: me.ksData.link, reviz: me.gksd('docRequestTabValue').revizLink, save: save },
			success: function(res) {
				if (res) {
					me.gksd('docRequestTabValue').DOCREQUEST.data = res;
					tab.setGroupsForData(res, tab.groups);
					if (save) me.oldData = JSON.stringify(me.dataCollector());
				}
			}
		});

	},

	//загрузка данных
	getExtraDocRequest: function(value) {
		var me = this,
			tabValue = value.DocRequest;
		
		me.sksd('docRequestTabValue', tabValue);
		me.changeTab(me.getTab('DocRequest'), true);

		var docReqTab = me.getTab('DocRequest'),
			docReq = tabValue.DOCREQUEST,
			groups = [];

		Ext.each(tabValue.sRprogs, function(prog, ind) {
			prog.ORD = ind;
			groups.push(prog);
		});

		if (ArrayLib.find(docReq.columns, ['dataIndex'], 'FileColumn') === -1) {
			ArrayLib.insert(docReq.columns, 1, {
				xtype: 'actioncolumn',
				dataIndex: 'FileColumn',
				text: 'Шаблон для заполнения',
				minWidth: 40,
				flex: 1,
				align: 'center',
				items: [
					{
						getClass: function(v, meta, rec) { return getExtStyle(rec.get('TEMP_EXTEXAMPLE')); },
						handler: function(grid, rowIndex) { me.fileGridEdit(grid.getStore().getAt(rowIndex)); }
					}
				]
			});
		}

		var c = ArrayLib.filter(docReq.columns, ['dataIndex'], 'COMMENT')[0];
		if (c) c.editor = 'textfield';

		//Для сортировки
		if (ArrayLib.find(docReq.fields, ['name'], 'ORD') === -1) docReq.fields.push({ name: 'ORD', type: 'int' });

		var iPos = ArrayLib.find(docReq.fields, ['name'], 'FILES_EXAMPLE');
		if (iPos !== -1) docReq.fields[iPos].type = 'string';
		
		docReqTab.correctLinks = value.corrProgLinks;
		docReqTab.setAdaptedFields(docReq.fields);
		docReqTab.setColumns(docReq.columns);
		docReqTab.setGroupsForData(docReq.data, groups);
		
		me.sksd('docReqData', docReq.data);
	},

	//Сборка данных
	dataCollectorDocRequest: function() {
		var me = this;
		return me.getTabVisible('DocRequest') ? me.getTab('DocRequest').store.getClearData() : _;
	},

	//#endregion Документы по запросу

	//#region Корреспондент

	//#region конструктор таба

	createTabCorr: function() {
		var me = this,
			items = [];

		Ext.each([
			{
				key: 'CORR_ORG',
				name: 'Организация',
				code: dnl.S_ORG,
				scrollable: true,
				ksSetValue: function (v) {
					this.setValue(v);
					if (me.objs.CORR_OTDEL) {
						me.objs.CORR_OTDEL.setDisabled(!this.value.length);
						if (!me.isLoaded) me.objs.CORR_OTDEL.setValue();
					}
				}
			},
			{
				key: 'CORR_OTDEL',
				name: 'Подразделение',
				code: dnl.S_OTDEL,
				initWhereArgs: function() {
					return {
						SOrgs: { value: me.gksc('CORR_ORG').getLinks(1), type: 'List_int' },
						HasFilterOnLoad: { value: 'False', type: 'bool' }
					};
				},
				getSOrg: function()
				{
					return me.objs.CORR_ORG.getLink();
				}
			},
			{
				key: 'CORR_PERSON',
				name: 'Сотрудник',
				code: dnl.S_PERSON,
				initWhereArgs: function() {
					let wa = {
						DH1: { value: '1900/01/01', type: 'Date' },
						DH2: { value: '2100/12/31', type: 'Date'}
					},
					orgCorr = me.gksc('CORR_ORG').getLinks(),
					otdelCorr = me.gksc('CORR_OTDEL').getLinks();
					
					if (orgCorr.length) {
						wa.SOrgs = { value: JSON.stringify(orgCorr), type: 'List_int' };
						wa.HasFilterOnLoad = { value: 'False', type: 'bool' };
					}

					if (otdelCorr.length) {
						wa.SOtdel = { value: JSON.stringify(otdelCorr), type: 'List_int' };
					}
					
					return wa;
				}
			}
		], function(el) {
			items.push(me.sksc(el.key, me.createDictEdit({
				key: el.key,
				fieldLabel: el.name,
				initWhereArgs: el.initWhereArgs,
				code: el.code,
				mode: 'SINGL',
				ksSetValue: el.ksSetValue,
				listCfg: {
					getSOrg: el.getSOrg
				}
			})));
		});

		return Ext.create('Ext.panel.Panel', {
			title: 'Корреспондент',
			bodyPadding: 10,
			layout: { type: 'vbox', align: 'stretch' },
			items: items
		});
	},

	//#endregion конструктор таба

	//загрузка данных
	getExtraCorr: function(value) {
		var me = this,
			tabValue = value.Corr;
		
		me.sksd('isCorr', true);
		var arr = [];
		me.sksd('arrCorrKey', arr);
		me.changeTab(me.getTab('Corr'), true);
		for (var key in tabValue) {
			arr.push(key);
			var el = me.gksc(key);
			el.ksSetValue ? el.ksSetValue(tabValue[key]) : el.setValue(tabValue[key]);
		}
	},

	//Сборка данных
	dataCollectorCorr: function() {
		var me = this;
		if (me.getTabVisible('Corr')) {
			var res = {};
			Ext.each(['CORR_ORG', 'CORR_OTDEL', 'CORR_PERSON'], function(key) { res[key] = me.gksc(key).getLink(); });
			return res;
		}
		return _;
	},

	//#endregion Корреспондент

	//#region Реквизиты

	//#region конструктор таба

	createTabProp: function() {
		var me = this;

		return Ext.create('Keysystems.Panel.Prop', {
			parentView: me,
			readOnly: me.readOnly,
			decimalData: me.gksd('decimalData')
		});
	},

	//#endregion конструктор таба

	//загрузка данных
	getExtraProp: function(value) {
		var me = this,
			tabValue = value.Prop;
		
		me.changeTab(me.getTab('Prop'), true);
		me.getTab('Prop').loadData(tabValue);
	},

	//#endregion Реквизиты

	//#region Email-уведомления

	//#region конструктор таба

	fillDocMail:function(mailLink, text) {
		let me = this,
			grid = me.gksc('mailGrid'),
			store = grid.store;
		
		me.showLoadMask({
			msg: text,
			rid: ajaxRequest({
				url: me.linkCode + '/FillDocMail_A',
				params: {
					mailLink,
					data: SignalR.pack(me.dataCollector()),
					osnov: me.osnov || 0,
					taskDocType: me.f === 'new' ? me.taskDocType || 0 : 0,
					taskDocLink: me.f === 'new' ? me.taskDocVidLink || 0 : 0
				},
				success: function(res) {
					if (res.errMsg) {
						showError(res.errMsg);
					} else if (res.rowMail) {
						if (mailLink === 0) {
							me.docMailLink = res.rowMail.LINK - 1;
							// Добавляем данные по получателям сообщения
							if (res.DOCMAILCORR.length > 0 ) {
								me.gksd('DOCMAILCORR').push(res.DOCMAILCORR[0]);
							}
							store.add(res.rowMail);
							grid.getSelectionModel().selectByPosition({
								row: store.data.length - 1
							});
						} else {
							me.gksc('mailEMAIL').setValue(res.rowMail.EMAIL);
							me.gksc('mailCORR').ksSetValue(res.userData);
							me.gksc('mailTEMA').setValue(res.rowMail.TEMA);
							me.gksc('mailBODY').setValue(res.rowMail.BODY);
							me.gksc('mailDT').setValue(res.rowMail.DT);
							me.gksc('mailSENDDIRECT').setValue(res.rowMail.SENDDIRECT)
						}
					}
				},
				callback: function() {
					me.hideLoadMask();
				}
			})
		});
	},
	
	selFunc: function(grid, rec) {
		let me = this,
			readOnly = grid.readOnly || rec.get('DTSEND');

		me.gksc('btnMailNew').setDisabled(grid.readOnly);
		me.gksc('btnMailSame').setDisabled(grid.readOnly);

		Ext.each(['btnMailDelete', 'btnMailFill', 'btnMailSend', 'mailEMAIL', 'mailTEMA',
			'mailBODY', 'mailCORR', 'mailDT', 'mailSENDDIRECT'], key => {
			me.gksc(key).setDisabled(readOnly);
		});

		Ext.each(['EMAIL', 'TEMA', 'BODY', 'DT', 'SENDDIRECT', 'DTSEND'], function(key) {
			me.gksc('mail' + key).setValue(rec.get(key));
		});
		me.gksc('mailCORR').setValue(me.getMailCorr(rec.get('LINK')));
	},
	
	createTabDocMail: function() {
		let me = this,
			selFunc = (grid, rec) => me.selFunc(grid, rec);

		return Ext.create('Ext.panel.Panel', {
			title: 'Email-уведомления',
			layout: { type: 'vbox', align: 'stretch' },
			scrollable: true,
			items: [
				me.sksc('mailGrid', Ext.create('Ext.grid.Panel', {
					flex: 1,
					border: 0,
					features: [
						{
							ftype: 'summary',
							showSummaryRow: false
						}
					],
					store: Ext.create('Ext.data.Store', { fields: [], data: [], proxy: 'memory' }),
					columns: [],
					columnLines: true,
					listeners: {
						select: function(th, rec) {
							let grid = me.gksc('mailGrid');
							
							selFunc(grid, rec);
						},
						deselect: function() {
							Ext.each(['btnMailSame', 'btnMailDelete', 'btnMailFill', 'btnMailSend', 'mailEMAIL', 'mailTEMA',
								'mailBODY', 'mailCORR', 'mailDT', 'mailSENDDIRECT'], key => {
								me.gksc(key).setDisabled(true);
							});
						}
					},
					tbar:
						me.sksc('mailToolbar', Ext.create('Ext.toolbar.Toolbar', {
							items: [
								me.sksc('btnMailNew', Ext.create('Ext.Button', {
									iconCls: 'x_btn_new',
									tooltip: KS.L10n.DocumentsEditView_InitializeComponent_Создать,
									tooltipType: 'title',
									handler: function() {
										me.fillDocMail(0, 'Создание');
									}
								})),
								me.sksc('btnMailSame', Ext.create('Ext.Button', {
									iconCls: 'x_btn_copy',
									tooltip: KS.L10n.DocumentsEditView_InitializeComponent_Создать_подобную,
									tooltipType: 'title',
									handler: function() {
										let grid = me.gksc('mailGrid'),
											selModel = grid.getSelectionModel(),
											activeRecs = selModel.getSelection(),
											newRec = grid.store.add({})[0];
		
										newRec.beginEdit();
										newRec.set('LINK', me.docMailLink--);
										Ext.each(Object.keys(newRec.data), field => {
											if (['LINK', 'DTSEND', 'id'].indexOf(field) === -1 && activeRecs[0].data.hasOwnProperty(field)) {
												newRec.set(field, activeRecs[0].data[field]);
											}
										});
										newRec.endEdit();
										
										selModel.selectByPosition({
											row: grid.store.data.length - 1
										});
									}
								})),
								me.sksc('btnMailDelete', Ext.create('Ext.Button', {
									iconCls: 'x_btn_delete',
									tooltip: KS.L10n.DocumentsEditView_InitializeComponent_Удалить,
									tooltipType: 'title',
									handler: function() {
										let grid = me.gksc('mailGrid');
										
										grid.store.remove(grid.getSelectionModel().getSelection());
		
										if (!grid.store.getData().length) {
											Ext.each(['mailEMAIL', 'mailTEMA', 'mailBODY', 'mailCORR', 'mailDT', 'mailSENDDIRECT'], key => {
												me.gksc(key).setValue();
											});
										}
									}
								})),
								{
									xtype: 'tbseparator'
								},
								me.sksc('btnMailFill', Ext.create('Ext.Button', {
									iconCls: 'x_btn_fill',
									tooltip: KS.L10n.DocumentsEditView_InitializeComponent_Заполнить,
									tooltipType: 'title',
									handler: function() {
										let grid = me.gksc('mailGrid'),
											selRecs = grid.getSelectionModel().getSelection();
										
										if (!selRecs.length) return;
										
										me.fillDocMail(selRecs[0].data.LINK, 'Заполнение');
									}
								})),
								me.sksc('btnMailSend', Ext.create('Ext.Button', {
							iconCls: 'x_btn_message_send',
							tooltip: 'Отправить',
							tooltipType: 'title',
							handler: function() {
								let grid = me.gksc('mailGrid'),
									selRecs = grid.getSelectionModel().getSelection();

								if (!selRecs.length) return;

								me.showLoadMask({
									msg: 'Отправление',
									rid: ajaxRequest({
										url: me.linkCode + '/SendDocMail_A',
										params: {
											link: me.getLink(),
											revizLink: me.ksData.row.REVIZ,
											// в string, чтобы не потерять отрицательный линк
											mailLink: JSON.stringify(selRecs[0].data.LINK),
											tabDocMail: me.dataCollectorDocMail()
										},
										success: function (res) {
											if (res.errMsg) {
												showError(res.errMsg);
											} else if (res.rowMail) {
												selRecs[0].beginEdit();
												Ext.each(Object.keys(res.rowMail), field => {
													if (selRecs[0].data.hasOwnProperty(field)) {
														selRecs[0].set(field, res.rowMail[field]);
													}
												});
												selRecs[0].endEdit();
												
												selFunc(grid, selRecs[0]);
											}
										},
										callback: function(){
											me.hideLoadMask();
										}
									})
								});
							}
						}))
							]
						})),
					plugins: ['gridclipboard']
				})),
				me.sksc('mailEditPanel', Ext.create('Ext.panel.Panel', {
					flex: 1,
					border: 0,
					layout: { type: 'vbox', align: 'stretch' },
					bodyPadding: 5,
					items: [
						me.sksc('mailEMAIL', Ext.create('Ext.form.field.Text', {
							labelWidth: me.labelWidth,
							fieldLabel: 'Email',
							listeners: {
								change: function(th, v) {
									var rec = me.gksc('mailGrid').getFrstSelect();
									if (rec) rec.set('EMAIL', v);
								}
							}
						})),
						me.createDictEdit({
							key: 'mailCORR',
							code: dnl.S_LOGIN,
							whereArgs1: {
								IncludeGroups: { value: 'False', type: 'bool' },
								MarkBusy: { value: 'True', type: 'bool' }
							},
							labelWidth: me.labelWidth,
							fieldLabel: 'Получатели',
							ksSetValue: function(v) {
								var rec = me.gksc('mailGrid').getFrstSelect();
								if (rec) {
									var link = rec.get('LINK');
									me.bindData(
										ArrayLib.filter(me.gksd('DOCMAILCORR'), ['DOCMAIL'], link),
										v,
										me.gksd('DOCMAILCORR'),
										function(l, d) { return ArrayLib.find(l, ['S_USERS'], d.LINK); },
										function(d) { return { S_USERS: d.LINK, S_USERS_CODE: d.CODE, S_USERS_NAME: d.NAME, DOCMAIL: link }; }
									);
								}
								this.setValue(v);
							}
						}),
						me.sksc('mailTEMA', Ext.create('Ext.form.field.Text', {
							labelWidth: me.labelWidth,
							fieldLabel: 'Тема',
							listeners: {
								change: function(th, v) {
									var rec = me.gksc('mailGrid').getFrstSelect();
									if (rec) rec.set('TEMA', v);
								}
							}
						})),
						me.sksc('mailBODY', Ext.create('Ext.form.field.TextArea', {
							flex: 1,
							labelWidth: me.labelWidth,
							fieldLabel: 'Текст письма',
							listeners: {
								change: function(th, v) {
									var rec = me.gksc('mailGrid').getFrstSelect();
									if (rec) rec.set('BODY', v);
								}
							}
						})),
						[
							me.sksc('mailDT', Ext.create('Ext.form.field.Date', {
								labelWidth: me.labelWidth,
								fieldLabel: 'Срок отправки',
								listeners: {
									change: function(th, v) {
										var rec = me.gksc('mailGrid').getFrstSelect();
										if (rec) rec.set('DT', v);
									}
								}
							})),
							me.sksc('mailSENDDIRECT', Ext.create('Ext.form.field.Checkbox', {
								boxLabel: 'Отправлять автоматически',
								padding: '0 0 0 10',
								listeners: {
									change: function(th, v) {
										var rec = me.gksc('mailGrid').getFrstSelect();
										if (rec) rec.set('SENDDIRECT', v);
									}
								}
							})),
							'->',
							me.sksc('mailDTSEND', Ext.create('Ext.form.field.Date', {
								disabled: true,
								//labelWidth: me.labelWidth,
								fieldLabel: 'Отправлено'
							}))
						]
					]
				}))
			]
		});
	},

	//#endregion конструктор таба

	getMailCorr: function(link) {
		var res = [];
		Ext.each(ArrayLib.filter(this.gksd('DOCMAILCORR'), ['DOCMAIL'], link), function(mc) {
			res.push({ LINK: mc.S_USERS, CODE: mc.S_USERS_CODE, NAME: mc.S_USERS_NAME });
		});
		return res;
	},

	//загрузка данных
	getExtraDocMail: function(value) {
		var me = this,
			tabValue = value.DocMail;
		
		me.sksd('DOCMAIL', tabValue.DOCMAIL);
		me.changeTab(me.getTab('DocMail'), true);
		me.sksd('DOCMAILCORR', tabValue.DOCMAILCORR);
		me.gksc('mailGrid').setMetaDate(tabValue.DOCMAIL, {
			profileCode: me.code,
			profileKey: 'mailGrid',
			gateCode: me.keyEdit
		});
	},

	//Сборка данных
	dataCollectorDocMail: function() {
		let me = this;
		
		if (me.getTabVisible('DocMail')) {
			let data = me.gksc('mailGrid').store.getDataExt(function(d) {
				d.CORR = ArrayLib.getLinks(me.getMailCorr(d.LINK), _, 1);
				return d;
			});
			
			return JSON.stringify(data, function (key, value) {
				if (this[key] instanceof Date) {
					return this[key].toDateString();
				}

				return value;
			});
		}		
		
		return '';
	},

	//#endregion Email-уведомления

	//#region Файлы

	//#region редактирование файла

	fileEdit: function() {
		var me = this;

		me.sksc('fileView', Ext.create('Keysystems.File', {	
			readOnly: me.readOnly || me.ksReadOnly || me.objs.btnFile.readOnly,
			iconCls: getExtStyle(me.getMainOrFirstFile()[me.fieldExt]),
			createFile: function(callback) { me.createFile(me.getLink(), callback); },
			updRecord: function (fileObj, isMain) { me.updFileRecord(fileObj, isMain); },
			getFileId: function() {
				var file = me.getFile();
				return file[me.fieldFile] || file.LINK;
			},
			downloadFile: function () { me.downloadFile(); },
			fileExists: function (exist, noExist) { me.fileExists(exist,noExist); },
			clearFile: function() { me.clearFile(); }
		}));
	},
	fileExists: function (exists, notExists) {
		var me = this;
		(me.getFile()[me.fieldExt] ? exists : notExists)();
	},
	createFile: async function(link, callback) {
		if (this.readOnly) return;
		const me = this;
		if (me.saveChangesFn()) {
			const saved = await me.saveMessageShowAsync();
			if (!saved) return;
		}
		UploaderLib.newFile(this.code, link, 0, -1, 0, this.getLoadMaskTarget(), callback);
	},
	clearFile: function() {
		var me = this;
		if (me.readOnly) return;

		me.removeFile();

		var ext = me.getMainOrFirstFile()[me.fieldExt];
		me.gksc('btnFile').setIconCls(getExtStyle(ext));
	},
	removeFile: function (fileLink) {
		var me = this;
		var files = this.gksd('Files');
		
		var res = fileLink
			? ArrayLib.filter(files, [this.fieldFile], fileLink)[0]
			: ArrayLib.filter(files, [this.fieldMain], 1)[0];

		if (res) {
			res[me.fieldFile] = '';
			res[me.fieldExt] = '';
		}
		
		me.getTab('Files').getExtra();
	},
	updFileRecord: function(fileObj, main) {
		var me = this;
		if (me.readOnly) return;
		
		var file = me.getFile(main ? _ : fileObj.id);
		var isEmpty = jQuery.isEmptyObject(file);
		file[me.fieldFile] = fileObj.id;
		file[me.fieldExt] = fileObj.ext;
		file[me.fieldMain] = main;
		file.NAME = fileObj.name || me.getFileName();
		file.DTCREATE = now;
		if (main || !me.gksc('btnFile').iconCls) me.gksc('btnFile').setIconCls(getExtStyle(fileObj.ext));
		if (isEmpty) {
			file.LINK = 0;
			this.gksd('Files').push(file);
		}
		me.getTab('Files').getExtra();
	},

	getFileName: function() {
		var me = this,
			settingFileMask = me.gksd('SettingFileMask'),
			docVidName = me.gksd('S_DOCVID_NAME'),
			number = me.gksc('NUMBER').getValue(),
			dt = me.gksc('DT').getValue(),
			fileName = settingFileMask || '{Документ.Вид.Имя}+" № "+ {Документ.Номер} + " от " + ДАТАПРОП({Документ.Дата},4)';

		fileName = fileName.replace('{Документ.Вид.Имя}', '"' + docVidName + '"');
		fileName = fileName.replace('{Документ.Номер}', '"' + number + '"');
		fileName = fileName.replace('ДАТАПРОП({Документ.Дата},4)', '"' + (Ext.isDate(dt) ? Ext.Date.format(dt, 'd.m.Y') : dt) + '"');

		return eval(fileName);
	},

	downloadFile: function() {
		var me = this,
			file = me.getFile();
		if (!file) return;
		UploaderLib.getFile(file[me.fieldFile] || file.LINK, file['NAME'] || me.getFileName() + '.' + file[me.fieldExt]);
	},

	getMainFile: function () {
		var me = this;
		var files = this.gksd('Files');
		var realFiles = files.filter(function(f) {
			return f[me.fieldFile] !== '';
		});
		return ArrayLib.filter(realFiles, [this.fieldMain], 1)[0];
	},

	getMainOrFirstFile: function () {
		var me = this,
			files = this.gksd('Files');

		var res = this.getMainFile();

		if (!res) {
			var realFiles = files.filter(function(f) {
				return f[me.fieldFile] !== '';
			});
			res = realFiles.sort(function(x, y) { return x - y; })[0];
		}
		
		return res || {};
	},

	getFile: function (fileLink) {
		var files = this.gksd('Files');

		var res = fileLink
			? ArrayLib.filter(files, ['LINK'], fileLink)[0]
			: this.getMainFile();
		return res || {}
	},

	//#endregion редактирование файла

	//#region конструктор таба

	createTabFiles: function() {
		var me = this,
			res = me.fileList = UploaderLib.showFileList({
				getFiles: function(callBack) { callBack(me.gksd('Files')); },
				setFiles: Ext.emptyFn
			}, {
				readOnly: me.readOnly,
				isWindow: false,
				autoRender: false,
				EDSSaveDocBehavior: window.useEDS ? me.gksd('EDSSaveDocBehavior') : 0,
				downloadFile: function(link, name, rec) { return this.callParent([link || rec.get('LINK'), name, rec]); },
				createTBar: function() {
					if (me.data.data.IFC_REGISTER) return null;
					var tbar = this.callParent(arguments);
					tbar.unshift(Ext.create('Ext.Button', {
						key: 'new',
						iconCls: 'x_btn_new',
						tooltip: KS.L10n.DocumentsEditView_InitializeComponent_Создать_по_шаблону,
						tooltipType: 'title',
						handler: function() {
							me.fileExists(function () {
								selectDialogShow(KS.L10n.attention,
										KS.L10n.rewrite_existing_file,
										function() {
											me.createFile(me.getLink(),
												function(fileLink, ext, name) {
													me.updFileRecord({ id: fileLink, ext: ext, name: name }, 1);
												});
										});
								},
								function() {
									me.createFile(me.getLink(),
										function(fileLink, ext, name) {
											me.updFileRecord({ id: fileLink, ext: ext, name: name }, 1);
										});
								});
						}
					}));
					return tbar;
				},
				afterAddFile: function (r) {
					var files = me.gksd('Files');
					files.push(r);
					if (!me.gksc('btnFile').iconCls) me.gksc('btnFile').setIconCls(getExtStyle(r[me.fieldExt]));
				},
				removeSelection: function() {
					var th = this;
					return th.callParent([
						function(rec) {
							th.editingPlugin.cancelEdit();
							me.removeFile(rec.get("FILES"));
							var ext = me.getMainOrFirstFile()[me.fieldExt];
							me.gksc('btnFile').setIconCls(getExtStyle(ext));
							return false;
						}
					]);
				},
				enableTools: function(sels) {
					this.callParent(arguments);
					const sel = sels?.length ? sels[0] : null;
					const mainSigned = me.gksd('EDSSaveDocBehavior') === 3 && sel?.get('MAIN') && sel?.get('TEMP_EDS_DATE');
					this.getToolbarItem('new')?.setDisabled(this.getReadOnly() || mainSigned);
				},
				viewConfig: {
					getRowClass: function(rec) {
						if (!rec.get(me.fieldExt)) return 'ks-hidden';
						return rec.get(me.fieldMain) === 1 ? 'x-bold' : '';
					}
				},
				afterGetExtra: function() {
					this.callParent(arguments);
					let oldData = JSON.parse(me.oldData);
					oldData.tabFiles = JSON.stringify(me.dataCollectorFiles());
					me.oldData = JSON.stringify(oldData);
				},
				//Выполнить после подписи файла на вкладке Файлы
				afterSignCompleted: function (sel) {
					const data = sel.data ?? sel;
					if (!data.MAIN) return;

					//обновим доступность кнопки Файл окна редактирования документоа
					if (me.gksd('EDSSaveDocBehavior') >= 2) {
						me.objs.btnFile.setKsReadOnly(data.TEMP_EDS_DATE);
					}

					//подменим данные на акутальные
					const oldData = JSON.parse(me.oldData);
					const filesData = me.dataCollectorFiles();
					oldData.tabFiles = JSON.stringify(filesData);
					me.oldData = JSON.stringify(oldData);

					//обновим данные по ЭП файла в списке, откуда открыли окно редактирования
					me.updateRecord({
						LINK: data.LINK,
						IS_FILES: true,
						EDS_FILES: data.TEMP_EDS_DATE ? 1 : 0
					});
				}
			});
		res.setTitle('Файлы');
		res.header = {};
		res.setIconCls('');
		
		delete res.header;
		return res;
	},

	//#endregion конструктор таба

	//загрузка данных
	getExtraFiles: function(value) {
		var me = this,
			tabValue = value.Files;
		
		me.sksd('SettingFileMask', value.SettingFileMask);
		me.sksd('Files', tabValue);
		
		var file = me.getMainOrFirstFile();
		
		me.gksc('btnFile').setIconCls(getExtStyle(file[me.fieldExt]));
		
		if (file.MAIN && window.useEDS && me.gksd('EDSSaveDocBehavior') === 3){
			me.objs.btnFile.setKsReadOnly(file.TEMP_EDS_DATE);
		}

		me.changeTab(me.getTab('Files'), true);
	},

	//Сборка данных
	dataCollectorFiles: function() {
		var me = this;
		return me.getTabVisible('Files') ?
			me.getTab('Files').store.getDataExt(function(d) {
				if (!d.LINK) d.LINK = d.FILES;
				return d;
			}) :
			_;
	},

	//#endregion Файлы

	getExtra: function(endFunc, link) {
		var me = this,
			data = me.data.data;

		me.sksd('isPlanProj', !!data.sPlanProj);
		me.baseGetExtra({
			link: link,
			reviz: data.REVIZ || 0,
			plan: data.PLANREVIZ || 0,
			sPlanProj: data.sPlanProj || 0,
			register: data.IFC_REGISTER || 0,
			task: data.S_TASK,
			taskDocLink: me.f === 'new' ? me.taskDocVidLink || 0 : 0,
			taskDocType: me.f === 'new' ? me.taskDocType || 0 : 0,
			linkSelf: me.f === 'new' ? data.parentId === 'root' ? 0 : data.LINK : data.LINK_SELF || 0,
			osnov: me.osnov || 0,
			dfDocuments: me.dfDocuments || 0,
			isGetRow: !me.parentView || me.parentView instanceof Keysystems.Controls.TaskGrid
		}, function(value) {
			const row = value.row;
			
			me.sksd('decimalData', value.decimalData);
			me.sksd('row', row);
			me.sksd('sStatus', value.sStatus);
			me.sksd('statusList', value.statusList);
			me.sksd('statusReadOnly', value.statusReadOnly);
			me.sksd('personClosedAccess', value.PersonClosedAccess);
			me.sksd('personClosedDenyEdit', value.PersonClosedDenyEdit);
			me.gksc('S_STATUS').setValue(row.S_STATUS);
			me.gksc('S_PERSON_CLOSED').setValue(value.S_PERSON_CLOSED);
			me.gksc('CHECK_CLOSE_PERSON').setValue(!me.gksc('S_PERSON_CLOSED').isEmpty());
			me.gksc('S_PERSON_CLOSED').setDisabled(!me.gksc('S_PERSON_CLOSED').getLink());
			me.sksd('IsOutDoc', value.IsOutDoc);
			me.sksd('EDS', value.row.EDS);
			me.sksd('EDSSaveDocBehavior', value.EDSSaveDocBehavior);
			me.sksd('ParentDocAutoDo', value.ParentDocAutoDo);
			me.sksd('disadvantage', value.disadvantage);
				
			if (value.General) me.getExtraGeneral(value);
			if (value.Person) me.getExtraPerson(value);
			if (value.FactNar) me.getExtraFactNar(value);
			if (value.NarRemove) me.getExtraNarRemove(value);
			if (value.Measure) me.getExtraMeasure(value);
			if (value.Respons) me.getExtraRespons(value);
			if (value.DocRequest) me.getExtraDocRequest(value);
			if (value.Corr) me.getExtraCorr(value);
			if (value.Prop) me.getExtraProp(value);
			if (value.DocMail) me.getExtraDocMail(value);
			if (value.Files) me.getExtraFiles(value);
			
			if (value.readOnly){
				me.sksd('readOnlyReason', value.readOnlyReason);
				me.sksd('readOnlyReasonExt', value.readOnlyReasonExt);
				me.sksd('personCloseRevizAccess', value.personCloseRevizAccess);
				me.readOnly = value.readOnly;
			}

			if (me.readOnly || data.readOnly) 
				me.setReadOnly(true, value.readOnlyReason);
			else
				me.setTabsAccess(value.Tabs);

			KsLib.tryRun(endFunc);
		});
	},

	setTabReadOnly: function(tabKey) {
		let me = this,
			key = me.getTabKey(tabKey);
		if (!(me.ksControls || me.objs)[key]) return;
		
		switch (tabKey.toUpperCase()) {
			case "PERSON":
				me.gksc('chbPersonList').setDisabled(true);
				break;
			case "FILES":
				me.objs.btnFile?.setKsReadOnly(true);
				me.getTab('Files').setKsReadOnly(true);
				break;			
			default:
				this.callParent(arguments);
				break;
		}
	},

	setStatusReadOnly: function(readOnly, reason, buttons){
		const me = this;
		if (readOnly) {
			const reasonExt = me.gksd('readOnlyReasonExt');
			if ((reasonExt & +Ext.Object.getKey(miscTypes.ReadOnlyReasonEnum, 'RevizClosed')) !== 0
				&& me.gksd('personCloseRevizAccess')) {
				buttons = [
					{id: "unBlock", text: "Внести изменения", tooltip: "Внести изменения"},
				]
				Keysystems.Base.Edit.prototype.setStatusReadOnly.call(me, readOnly, reason, buttons);
				return;
			}
		}
		me.callParent(arguments);
	},

	statusBtnOnClick: function(btn){
		const me = this;
		if (btn.id === "unBlock"){
			let reasonExt = me.gksd('readOnlyReasonExt');
			reasonExt = reasonExt ^ +Ext.Object.getKey(miscTypes.ReadOnlyReasonEnum, 'RevizClosed');
			me.sksd('readOnlyReasonExt', reasonExt);
			const reason = me.gksd('readOnlyReason');
			if (reasonExt){
				me.setReadOnly(true, reason?.replace(/Мероприятие закрыто;?/, ''))
			}
			else{
				me.setReadOnly(false)
			}
		}
	},

	getFactNarData: function() { return []; },

	saveData: function(endFunc, inputParams) {
		var me = this,
			isNew = me.ksData.link === 0;
		inputParams = inputParams || me.dataCollector();
		if (me.isDeloChanged()){
			let tabGeneral = JSON.parse(inputParams.tabGeneral);
			tabGeneral.needChangeDeloAp = true;
			inputParams.tabGeneral = JSON.stringify(tabGeneral);
		}
		
		me.baseSaveData(inputParams, function (result) {
			// при первом сохранении предложение заполнить "Документы по запросам"
			if (isNew && me.getTabVisible('DocRequest')) {
				Ext.Msg.show({
					title: 'Запрашиваемые документы',
					buttons: Ext.MessageBox.YESNO,
					buttonText: { yes: 'Да', no: 'Нет' },
					msg: 'Заполнить запрашиваемые документы автоматически?',
					fn: function (buttonId) {
						if (buttonId === 'yes') {
							me.fillDocReqGrid(true);
						}
					},
					icon: Ext.MessageBox.QUESTION
				});
			}
			if (endFunc) endFunc(result);
		});
	},

	saveDataAsync: async function(inputParams){
		const me = this;
		return new Ext.Promise(function (resolve) {
			me.saveData((res) => {
				resolve(res);
			}, inputParams);
		});
	},

	isFilledAsync: async function() {		
		const me = this;
		let params = {};

		if (me.gksd('needCheckUnicNumber')) {
			params.unicNumber = {
				link: me.ksData.link,
				linkSelf: me.ksData.row.LINK_SELF,
				dt: me.gksc('DT').getValue(),
				docVid: me.ksData.row.S_DOCVID,
				number: me.gksc('NUMBER').getValue()
			}
		}

		const oldData = JSON.parse(me.oldData);
		const dt = JSON.parse(oldData.tabGeneral).DT;
		const changeDT = new Date(dt) - me.ksControls.DT.getValue() !== 0;
		if (changeDT && me.gksd('nastrChangeEхеcutionDate') !== 2) {
			const ksControls = me.ksControls;
			const ksData = me.ksData;
			const d = me.data.data;
			params.data = {
				link: ksData.link,
				dt: ksControls.DT.getValue()?.toDateString() ?? "",
				dtEnd: ksControls.DTEND.getValue()?.toDateString() ?? "",
				dtUtv: ksControls.DTUTV.getValue()?.toDateString() ?? "",
				revizLink: d.REVIZ || 0,
				task: me.data.data.S_TASK,
				planLink: d.PLANREVIZ || 0,
				sPlanProj: d.sPlanProj || 0,
				isVfa: me.isVfa,
				IFC_REGISTER: me.IFC_REGISTER || 0,
				taskDocLink: me.f === 'new' ? me.taskDocVidLink || 0 : 0,
				taskDocType: me.f === 'new' ? me.taskDocType || 0 : 0,
				osnov: me.osnov || 0,
				linkSelf: me.gksd('row').LINK_SELF
			}
		}

		if (Ext.Object.isEmpty(params)) 
			return true;

		me.showLoadMask({ msg: KS.L10n.preparing_data, closable: true });
		const res = await ajaxRequestAsync({
			url: 'SDocuments/DocCheckSave_A',
			params: {parameters: JSON.stringify(params)}
		});
		me.hideLoadMask();
		
		//#region Уникальность номера 
		if (res.unicNumber) {
			let dialogResult = await dialogShowAsync({
				msg: KS.L10n.DocumentsEditView_CheckSave_Уже_есть_документ_данного_вида_с_таким_номером,
				title: KS.L10n.attention,
				buttons: Ext.MessageBox.YESNO,
				buttonText: {
					yes: 'Отмена',
					no: KS.L10n.DocumentsEditView_CheckSave_Перезаполнить_по_значению_автонумерации
				},
			});
			
			if (dialogResult === "no") {
				me.sksd('numberErrorUnic', me.gksc('NUMBER').getValue());
				me.gksc('NUMBER').fillNextNum();
			}
			return false;
		}
		//#endregion Уникальность номера

		//#region Изменение исполнения при изменении даты
		
		if (me.gksd('nastrChangeEхеcutionDate') === 1)
			res.autoChange = true;
		
		if (!res.autoChange && res.text) {
			let checked = false;
			let dialogResult = await dialogShowAsync({
				msg: res.text,
				title: res.title,
				buttons: Ext.Msg.YESNOCANCEL,
				buttonText: {
					yes: 'Да',
					no: 'Нет'
				},
				checkVisible: !res.readOnlyNastr,				
				checkHandler: function(th, check) {
					checked = check;
				},
				icon: Ext.MessageBox.QUESTION,				
			});

			const dtEnd = new Date(res.dtEnd);
			if (dialogResult === "yes") {
				me.ksControls.DTEND.setValue(dtEnd);
				if (res.autoDo) {
					me.ksControls.DTUTV.setValue(dtEnd);
				}
			}
			if (checked && dialogResult !== "cancel") {
				me.sksd('nastrChangeEхеcutionDate', dialogResult === "yes" ? 1 : 2);
			}
		} else if (res.dtEnd) {
			const dtEnd = new Date(res.dtEnd);
			me.ksControls.DTEND.setValue(dtEnd);
			if (res.autoDo){
				me.ksControls.DTUTV.setValue(dtEnd);
			}
		}
		//#endregion Изменение исполнения при изменении даты
		
		return true;
	},

	isFilled: function() {
		const me = this;
		let res = true;

		if (!me.readOnly && me.gksc("NUMBER").getValue() === '') {
			me.addToInvalidControls(me.gksc("NUMBER"), {
				optional: true,
				parent: me.ksControls.allTab,
				tab: me.getTab('General')
			});
			me.warningMessages.push(KS.L10n.DocumentsEditView_CheckSave_Не_заполнен_номер_документа_);
		}

		let c = me.gksc('DT');
		if (!c.getValue() || !c.isValid()) {
			me.addToInvalidControls(c, {
				title: 'Дата документа',
				parent: me.ksControls.allTab,
				tab: me.getTab('General')
			});
			res = false;
		}

		const revizPeriod = me.gksd('revizPeriod');
		if (revizPeriod) {
			const dtValue = c.getValue();
			const dt1 = new Date(revizPeriod.dt1);
			const dt2 = new Date(revizPeriod.dt2);
			if (dt1 > dtValue || dt2 < dtValue) {
				me.warningMessages.push(wmc.getString(KS.L10n.DocumentsEditView_CheckSave_Дата_документа_не_попадает_в_период_проведения_мероприятия__0_____1__, Ext.Date.format(dt1, 'd.m.Y'), Ext.Date.format(dt2, 'd.m.Y')));
			}
		}

		c = me.gksc('DTEND');
		if (!c.getValue() || !c.isValid()) {
			me.addToInvalidControls(c, {parent: me.ksControls.allTab, tab: me.getTab('General')});
			res = false;
		}

		c = me.gksc('S_ORG_OTV');
		if (c.isEmpty()) {
			me.addToInvalidControls(c, {parent: me.ksControls.allTab, tab: me.getTab('General')});
			res = false;
		}

		if (me.gksd('isRegAp') && (c = me.gksc('S_DELO')) && c.isEmpty()) {
			me.addToInvalidControls(c, {parent: me.ksControls.allTab, tab: me.getTab('General')});
			res = false;
		}

		if (me.isDeloChanged()){
			me.warningMessages.push(KS.L10n.DocumentsEditView_Номер_дела_об_АП_будет_изменен);
		}
		
		const gridMeasure = me.gksc('gridMeasure');
		if (gridMeasure) {
			var measureData = gridMeasure.getStore().getDataExt();
			let valid = true;
			Ext.each(measureData, function (rec) {
				if (!rec.NARREMOVE) {
					valid = false;
				}
			});
			if (!valid) {
				me.addToInvalidControls(gridMeasure, {
					title: 'Требование по устранению',
					parent: me.ksControls.allTab,
					tab: me.getTab('Measure')
				});
				res = false;
			}
		}

		const gridRespons = me.gksc('tabRespons');
		if (gridRespons) {
			var responsData = gridRespons.store.getDataExt(),
				nullFactNar,
				nullRespons;

			Ext.each(responsData, function (rec) {
				if (!rec.FACTNAR) nullFactNar = true;
				if (!rec.S_RESPONS) nullRespons = true;
			});

			if (nullFactNar) {
				me.addToInvalidControls(gridRespons, {
					title: 'Факт нарушения в ответственности',
					parent: me.ksControls.allTab,
					tab: me.getTab('Respons')
				});
				res = false;
			}

			if (nullRespons) {
				me.addToInvalidControls(gridRespons, {
					title: 'Вид ответственности',
					parent: me.ksControls.allTab,
					tab: me.getTab('Respons')
				});
				res = false;
			}
		}

		// Корреспондент
		if (me.getTabVisible('Corr')) {
			let corrEmpty = me.gksd('arrCorrKey')
				.filter(el => me.objs[el].isEmpty && !me.objs[el].isEmpty()).length === 0;
			if (corrEmpty) {
				me.addToInvalidControls(me.gksc("CORR_ORG"), {
					title: 'Корреспондент',
					optional: true,
					parent: me.ksControls.allTab,
					tab: me.getTab('Corr')
				});
				me.warningMessages.push(KS.L10n.DocumentsEditView_CheckSave_Не_заполнен_корреспондент_);
			}
		}

		return res;
	},

	dataCollector: function() {
		var me = this,
			row = me.gksd('row'),
			d = me.data.data,
			res = {
				LINK: me.getLink(),
				PLAN: d.PLANREVIZ,
				REVIZ: d.REVIZ,
				sPlanProj: d.sPlanProj,
				IFC_REGISTER: d.IFC_REGISTER,
				LINK_SELF: row.LINK_SELF,
				S_STATUS: me.gksc('S_STATUS').getValue(),
				S_PERSON_CLOSED: me.gksc('CHECK_CLOSE_PERSON').getValue() ? me.gksc('S_PERSON_CLOSED').getLink() : 0,
				S_TASK: row.S_TASK,
				S_DOCVID: row.S_DOCVID,
				TYPE: row.TYPE,
				STAMP: me.gksd('STAMP'),
				numberErrorUnic: me.gksd('numberErrorUnic'),
				dfDocuments: me.dfDocuments
			},

		data = me.dataCollectorGeneral();
		if (data) res.tabGeneral = JSON.stringify(data);

		data = me.dataCollectorPerson();
		if (data) res.tabPerson = JSON.stringify(data);

		data = me.dataCollectorFactNar();
		if (data) res.tabFactNar = JSON.stringify(data);

		data = me.dataCollectorNarRemove();
		if (data) res.tabNarRemove = JSON.stringify(data);

		data = me.dataCollectorMeasure();
		if (data) res.tabMeasure = JSON.stringify(data);

		data = me.dataCollectorRespons();
		if (data) res.tabRespons = JSON.stringify(data);

		data = me.dataCollectorDocRequest();
		if (data) res.tabDocRequest = JSON.stringify(data);

		data = me.dataCollectorCorr();
		if (data) res.tabCorr = JSON.stringify(data);

		if (me.getTabVisible('Prop')) res.tabProp = me.getTab('Prop').getData(1);

		data = me.dataCollectorDocMail();
		if (data.length) res.tabDocMail = data;
		
		data = me.dataCollectorFiles();
		if (data) res.tabFiles = JSON.stringify(data);

		res.isVfa = me.isVfa;
		res.ParentDocAutoDo =  JSON.stringify(me.gksd('ParentDocAutoDo'));

		return res;
	},

	successSaveFunc: function(result, endFunc, params) {
		const me = this;

		if (result.CheckSaveResult) {
			me.parseCheckSaveResult(result.CheckSaveResult, function (checkSaveResult) {
				params = me.dataCollector();
				params.processCheckSave = false;
				params.checkSaveResult = checkSaveResult;
				me.saveData(endFunc, params);
			})
			return;
		}

		if (result.CheckSaveResultMUC) {
			me.parseCheckSaveResult(result.CheckSaveResultMUC, function (checkSaveResult) {
				params = me.dataCollector();
				params.processCheckSave = false;
				params.CheckSaveResultMUC = checkSaveResult;
				me.saveData(endFunc, params);
			})
			return;
		}		
		
		const tab = (me.ksControls || me.objs)[me.getTabKey('DocRequest')];
		me.narRemoveLink = -1;
		if (me.getTabVisible('NarRemove')) {
			if (result.narRemove) {
				me.sksd('narRemove', result.narRemove);
				me.gksc('dictNarRemove').getStore().loadData(result.narRemove.data);
			}
		}

		//Заменяем линки вновь сохраненных документов
		if (tab && result.DOCREQUEST) {
			var newDocReq = result.DOCREQUEST;
			me.gksd('docRequestTabValue').DOCREQUEST.data = newDocReq;
			tab.setGroupsForData(newDocReq, tab.groups);
		}

		if (result.result && me.getTab('Files')) {
			// убираем удаленные записи
			var toDel = me.gksd('Files').filter(function (f) {
				return f[me.fieldFile] === '';
			});
			if (toDel.length) {
				var notDel = me.gksd('Files').filter(function(f) {
					return f[me.fieldFile] !== '';
				});
				me.sksd('Files', notDel);
				me.getTab('Files').getExtra();
			}

			// проставляем LINK и FILES у сохраненных записей
			if (result.SavedFiles) {
				result.SavedFiles.forEach(function(el) {
					var find = ArrayLib.filter(me.gksd('Files'), [me.fieldFile], el.TEMP)[0];
					if (find) {
						find[me.fieldFile] = el.LINK;
						find.LINK = el.LINK;
					}
				});
				me.getTab('Files').getExtra();
			}
		}
		
		if (result.DocMail && me.getTab('DocMail')) {
			me.sksd('DOCMAILCORR', result.DocMail.DOCMAILCORR);
			me.gksc('mailGrid').loadData(result.DocMail.DOCMAIL.data);
		}

		if (result.readOnly){
			me.sksd('readOnlyReason', result.readOnlyReason);
			me.sksd('readOnlyReasonExt', result.readOnlyReasonExt);
			me.readOnly = result.readOnly;
			me.setReadOnly(me.readOnly, result.readOnlyReason);
		}

		me.callParent(arguments);
	},
	
	updRecord: function (row) {
		const me = this;
		this.callParent(arguments);
		this.data.set(row);
		if (row?.relatedRows) {
			//refs #1067 обновим дату исполнения 
			row.relatedRows.forEach(relatedRow=>{
				let sel = me.parentView.getStore().findNode('LINK', relatedRow.LINK);
				if (sel) {
					sel.set('DTUTV', relatedRow.DTUTV);
				}
			});				
		}
		//обновление длительности регламента
		if (row?.STaskDuration) {
			let node = this.data.parentNode;
			while (node) {
				if (node.data.S_TASK && !node.data.S_DOCVID) {
					node.set('DURATIONCOLUMN', row.STaskDuration);
					node.set('NEXT_DOCVIDS', null);
					break;
				}
				node = node.parentNode;
			}
		}
		
	},

	getParamsForCancel: function() {
		let me = this,
			data = me.data.data,
			params = me.callParent(arguments);

		if (me.parentView && !(me.parentView instanceof Keysystems.Controls.TaskGrid)) {
			params.isVfa = me.isVfa;
			params.reviz = data.REVIZ || 0;
			params.plan = data.PLANREVIZ || 0;
			params.sPlanProj = data.sPlanProj || 0;
			params.IFC_REGISTER = data.IFC_REGISTER || 0;
		}
		
		return params;
	},

	adaptFactNarColumns: function(cols) {
		var me = this;

		me.addFinancCol(cols);

		//Добавляем колонку с отображением суммы
		var pos = ArrayLib.find(cols, ['dataIndex'], 'SUMMA');
		if (pos !== -1) {
			cols[pos].editor = {
				xtype: 'calcfield',
				fieldLabel: '',
				decimalData: me.gksd('decimalData'),
				listeners: {
					blur: function (th) {
						var tabNarGrid = me.gksc('tabNarGrid'),
							sel = tabNarGrid.getSelectionModel().getSelection()[0],
							val = th.getNumValue(),
							max = this.parseTextToNum(sel.get('SUMNAR'));

						if (val > max) {
							selectDialogShow(KS.L10n.attention, wmc.getContinueQuestion(KS.L10n.DocumentsEditView_gridSumms_BeforeExitEditMode_Сумма_больше_суммы_нарушения_), function () {
								sel.set('SUMMA', val);
							}, function () {
								var columns = tabNarGrid.headerCt && tabNarGrid.headerCt.items && tabNarGrid.headerCt.items.items,
									p = ArrayLib.find(columns || [], ['dataIndex'], 'SUMMA');

								if (p !== -1) tabNarGrid.editingPlugin.startEdit(sel, columns[p]);
							}, me);
						}
					}
				},
				getValue: function () {
					return this.parseTextToNum(this.getRawValue());
				}
			}
		}
		
		pos = ArrayLib.find(cols, ['dataIndex'], 'ORD');
		if (pos !== -1){
			cols[pos].renderer = function(val) {
				return val ? val : '';
			};
		}
		return cols;
	},

	addFinancCol: function(cols) {
		//Добавляем колонку с отображением финансирования
		cols.push({
			xtype: 'actionimg',
			dataIndex: 'IMG',
			imgHandler: function (grid, rec) {
				if (!rec.data.FINANC) return;
				var fin = dictListController.DOCUMENT_FINANC;
				Ext.create('Keysystems.Financ.Edit', {
					code: dnl.FINANC,
					readOnly: true,
					data: { data: { LINK: rec.get('FINANC') } },
					editClass: fin.editClass,
					f: 'edit',
					iconCls: fin.iconCls,
					linkCode: fin.linkCode,
					title: fin.title
				});
			},
			iconCls: 'x_btn_currency',
			getClass: function (v, meta, rec) { return rec.get('FINANC') ? 'x_btn_currency' : ''; }
		});
	},

	dictData: function(data) { return { data: data, total: data.length }; },

	getFactNarRow: function(link) { return ArrayLib.filter(this.gksc('tabNarGrid').checked, ['LINK'], link)[0]; }
});