﻿Ext.define('Keysystems.Documents.Edit.Reviz', {
	extend: 'Keysystems.Base.Edit',
	title: 'Планы устранения нарушений',
	filledFileCols: { file: 'FILES', ext: 'TEMP_EXT' },
	isFileBtn: true,
	narRemLink: -1,
	profilePrefix: 'DocumentsReviz',
	onlyMainFile: true,
	viewMinSize: [600, 400],

	constructor: function(cfg) {
		if (cfg.code !== dnl.DOCREVIZ) cfg.code = dnl.DOCREVIZ; //без этого вылетает сохранение профиля в отчете
		cfg.GateCode = 'edit'; //без этого вылетает сохранение профиля в отчете
		return this.callParent(arguments);
	},

	//#region Нарушения

	getNarRemoveColumns: function() {
		var me = this;
		return me.narRemoveColumns || (me.narRemoveColumns = [
			{
				text: 'Факт нарушения',
				dataIndex: 'FACTNAR',
				columns: [
					{
						text: 'Код',
						dataIndex: 'S_NAR_CODE',
						flex: 1
					},
					{
						text: 'Вид нарушения',
						dataIndex: 'S_NAR_NAME',
						flex: 3
					},
					{
						text: 'Сумма<br>нарушения',
						dataIndex: 'SUMMA',
						flex: 2
					}
				]
			},
			{
				text: 'Мероприятия по<br>устранению',
				dataIndex: 'CONTENT',
				editor: {
					xtype: 'triggertexteditor',
					maxLength: 8000,
					getEditorTitle: function() { return this.column.text; }
				},
				viewer: {
					xtype: 'triggertexteditor',
					editable: false,
					getEditorTitle: function() { return this.column.text; }
				}
			},
			{
				xtype: 'dictcolumn',
				text: 'Исполнители',
				dataIndex: 'FIO',
				defaultRenderer: function(v, m, r) { 
					return getFI(me.getNarRemPersons(r.get('LINK')), 'S_PERSON_'); 
				},
				code: dnl.S_PERSON,
				mode: 'MULTI',
				initWhereArgs: function() { return me.gksd('fioWhereArgs'); },
				inputDicts: [Ext.create('InputEditDict', { name: 'S_ORG', data: [user.org] })],

				ksGetValue: function() {
					var res = [];
					Ext.each(me.getNarRemPersons(me.getNarRemoveEditRec().get('LINK')), function(p) { res.push(me.convToPerson(p)); });
					return res;
				},
				ksSetValue: function(v) {
					var r = me.getNarRemoveEditRec();
					if (!r) return;
					me.setNarRemPersons(r.get('LINK'), v);
					me.getNarRemoveGrid().view.refresh();
				},
				editor: {
					xtype: 'triggerdict',
					cleaningKey: false,
					clear: function() {
						var r = me.getNarRemoveEditRec();
						if (r) {
							me.setNarRemPersons(r.get('LINK'), []);
							me.getNarRemoveGrid().view.refresh();
						}
					},
					getValue: function() { return me.getPersonsVal(); },
					setValue: function() { this.__setValue(me.getPersonsVal()); },
					valueToRaw: function(v) { return v; }
				},
				viewer: {
					xtype: 'trigger',
					triggerBaseCls: 'x-dict-trigger',
					triggerCls: 'x_btn_dict',
					triggerWidth: 22,
					editable: false,
					setValue: function() { this.__setValue(me.getPersonsVal()); },
					onTriggerClick: function() {
						dictFunc({
							parentView: me,
							checkModel: false,
							inputDicts: [Ext.create('InputEditDict', { name: 'S_ORG', data: [user.org] })],
							whereArgs: {
								InLinksOnly: { value: 'True', type: 'bool' },
								InLinks: {
									value: ArrayLib.getLinks(me.getNarRemPersons(this.ownerCt.context.record.get('LINK')), 'S_PERSON', 1),
									type: 'List_int'
								}
							},
							code: dnl.S_PERSON
						});
					}
				}
			},
			{
				text: 'Срок<br>устранения',
				dataIndex: 'DTSROK',
				xtype: 'datecolumn',
				format: 'd.m.Y',
				editor: { xtype: 'datefield', format: 'd.m.Y' },
				viewer: { xtype: 'datefield', editable: false }
			},
			{
				text: 'Примечание',
				dataIndex: 'COMMENT',
				editor: {
					xtype: 'triggertexteditor',
					maxLength: 8000,
					getEditorTitle: function() { return this.column.text; }
				},
				viewer: {
					xtype: 'triggertexteditor',
					editable: false,
					getEditorTitle: function() { return this.column.text; }
				}
			},
			{
				text: 'Комментарии',
				dataIndex: 'COMMENT2',
				editor: {
					xtype: 'triggertexteditor',
					editable: false,
					getEditorTitle: function() { return this.column.text; }
				},
				viewer: {
					xtype: 'triggertexteditor',
					editable: false,
					getEditorTitle: function() { return this.column.text; }
				}
			}
		]);
	},

	getPersonsVal: function() {
		var me = this,
			r = me.getNarRemoveEditRec();
		return r ? getFI(me.getNarRemPersons(r.get('LINK')), 'S_PERSON_') : '';
	},

	convToPerson: function(p) {
		return {
			LINK: p.S_PERSON,
			LASTNAME: p.S_PERSON_LASTNAME,
			FIRSTNAME: p.S_PERSON_FIRSTNAME,
			PATRONYMIC: p.S_PERSON_PATRONYMIC
		};
	},

	getNarRemPersons: function(link) { 
		return ArrayLib.filter(this.objs.narRemPersons || [], ['NARREMOVE'], link);
	},

	setNarRemPersons: function(link, v) {
		var me = this;
		me.bindData(
			me.getNarRemPersons(link),
			v,
			me.objs.narRemPersons,
			function(l, d) { return ArrayLib.find(l, ['S_PERSON'], (d.data || d).LINK); },
			function(d) {
				d = d.data || d;
				return {
					NARREMOVE: link,
					S_PERSON: d.LINK,
					S_PERSON_LASTNAME: d.LASTNAME,
					S_PERSON_FIRSTNAME: d.FIRSTNAME,
					S_PERSON_PATRONYMIC: d.PATRONYMIC
				};
			}
		);

		return ArrayLib.filter(this.objs.narRemPersons, ['NARREMOVE'], link);
	},

	getNarRemoveFields: function() {
		var me = this;
		return me.narRemoveFields || (me.narRemoveFields = ['LINK', 'FACTNAR', 'FACTNAR_CONTENT', 'S_NAR', 'S_NAR_CODE', 'S_NAR_NAME', 'SUMMA', 'CONTENT', 'DTSROK', 'COMMENT', 'FIO', 'COMMENT2']);
	},

	_arrTextEditorColumns: ['CONTENT', 'COMMENT'],
	_arrSetNarRem: ['FACTNAR', 'S_NAR', 'S_NAR_CODE', 'S_NAR_NAME', 'SUMMA'],

	getNarRemoveTBar: function() {
		var me = this,
			objs = me.objs;
		return objs.narRemoveTBar || (objs.narRemoveTBar = [
			objs.btnNewNarRemove = Ext.create('Ext.Button', {
				iconCls: 'x_btn_new',
				tooltip: 'Создать',
				tooltipType: 'title',
				disabled: true,
				handler: function() {
					var grid = me.getNarRemoveGrid(),
						selModel = grid.getSelectionModel(),
						sel = selModel.getSelection()[0];
					if (!sel) return;
					selModel.select(grid.store.add(ArrayLib.copyByKeys(me._arrSetNarRem, sel.getData(), { LINK: me.narRemLink-- })));
				}
			}),
			objs.btnCopyNarRemove = Ext.create('Ext.Button', {
				iconCls: 'x_btn_copy',
				tooltip: 'Создать подобную',
				tooltipType: 'title',
				disabled: true,
				handler: function() {
					var grid = me.getNarRemoveGrid(),
						selModel = grid.getSelectionModel(),
						sel = selModel.getSelection()[0];
					if (!sel) return;
					var r = sel.getData(),
						p = [];
					Ext.each(me.getNarRemPersons(r.LINK), function(e) { p.push(me.convToPerson(e)); });
					r.LINK = me.narRemLink--;
					me.setNarRemPersons(r.LINK, p);
					delete r.id;
					selModel.select(grid.store.add(r));
				}
			}),
			objs.btnDelNarRemove = Ext.create('Ext.Button', {
				iconCls: 'x_btn_delete',
				tooltip: 'Удалить',
				tooltipType: 'title',
				disabled: true,
				handler: function() {
					var grid = me.getNarRemoveGrid();
					grid.removeSelection(function(rec) {
						return ArrayLib.filter(grid.store.data.items, ['data', 'FACTNAR'], rec.data.FACTNAR).length > 1;
					});
				}
			})
		]);
	},

	getNarRemoveEditRec: function() {
		var context = this.getNarRemoveGrid().editingPlugin.context;
		return context ? context.record : _;
	},

	getNarRemoveGrid: function() {
		var me = this,
			objs = me.objs;

		if (!objs.NARREMOVE) {
			objs.NARREMOVE = Ext.create('Ext.grid.Panel', {
				autoScroll: true,
				autoRender: true,
				//region: 'center',
				plugins: [Ext.create('Keysystems.grid.plugin.RowEditing', { getReadOnly: function() { return objs.isDisable; } }), 'gridclipboard'],
				columns: me.getNarRemoveColumns(),
				listeners: { selectionchange: function(th, sels) { me.onNarRemoveSelectionChange(sels[0]); } },
				tbar: me.getNarRemoveTBar(),
				store: Ext.create('Ext.data.Store', {
					fields: me.getNarRemoveFields(),
					data: [],
					sorters: [{ property: 'FACTNAR', direction: 'ASC' }],
					proxy: 'memory'
				}),
				columnLines: true,
				flex: 1
			});

			Ext.each(me.getNarRemoveGrid().getColumnManager().getColumns(), function(col) { col.flex = col.dataIndex === 'FACTNAR' ? 3 : 1; });
		}

		return objs.NARREMOVE;
	},

	onNarRemoveSelectionChange: function(rec) {
		var me = this,
			objs = me.objs;
		if (!objs.isDisable) {
			objs.btnNewNarRemove.setDisabled(!rec);
			objs.btnCopyNarRemove.setDisabled(!rec);
			objs.btnDelNarRemove.setDisabled(!rec || ArrayLib.filter(me.getNarRemoveGrid().store.data.items, ['data', 'FACTNAR'], rec.data.FACTNAR).length < 2);
		}
		objs.FACTNAR_CONTENT.setDisabled(!rec);
		objs.FACTNAR_CONTENT.setValue(rec ? rec.get('FACTNAR_CONTENT') : _);
	},

	//#endregion Нарушения

	createItems: function() {
		var me = this,
			objs = me.objs,
			items = [
				Ext.create('Ext.form.FieldContainer', {
					layout: 'hbox',
					items: [
						objs.NUMBER = Ext.create('Ext.form.field.Text', {
							width: 130,
							labelWidth: 30,
							disabledCls: '',
							fieldLabel: '№',
							maxLength: 25,
							enforceMaxLength: true
						}),
						objs.DT = Ext.create('Ext.form.field.Date', {
							width: 130,
							padding: '0 0 0 20',
							disabledCls: '',
							labelWidth: 30,
							ksAllowEmpty: true,
							allowEmpty: false,
							fieldLabel: 'от'
						}),
						'->',
						objs.S_STATUS = Ext.create('Ext.form.field.ComboBox', {
							editable: false,
							value: 0,
							disabledCls: '',
							queryMode: 'local',
							fieldLabel: 'Статус',
							labelWidth: 80,
							displayField: CBDataLib.displayField,
							valueField: CBDataLib.valueField,
							store: objs.statusStore = Ext.create('Ext.data.Store', {
								fields: CBDataLib.getFields(),
								data: [],
								proxy: 'memory'
							})
						})
					]
				}),
				Ext.create('Ext.form.FieldSet', {
					title: 'Нарушения',
					collapsible: true,
					//layout: 'border',
					layout: { type: 'vbox', align: 'stretch' },
					flex: 1,
					height: 300,
					items: [
						me.getNarRemoveGrid(),
						{ xtype: 'splitter' },
						Ext.create('Ext.panel.Panel', {
							title: 'Характер нарушения и обстоятельства нарушения',
							region: 'south',
							split: true,
							layout: { type: 'vbox', align: 'stretch' },
							collapsible: true,
							bodyPadding: me.bodyPadding,
							flex: 1,
							items: [
								objs.FACTNAR_CONTENT = Ext.create('Ext.form.field.TextArea', {
									labelWidth: me.labelWidth,
									disabled: true,
									readOnly: true,
									flex: 1,
									fieldLabel: 'Характер нарушения и обстоятельства нарушения'
								})
							]
						})
					]
				})
			];

		return me.callParent([items]);
	},

	fileEdit: function() {
		var me = this,
			objs = me.objs;
		if (objs.isDisable) {
			me.downloadFile();
		} else {
			me.callParent();
		}
	},

	createFile: function(link, callback) { this.runCreateFile(callback); },

	//сообщение о наличии несохраненных данных при создании файла
	createFileMsgShow: function(cfg) {
		Ext.Msg.show({
			title: wmc.get('Attention'),
			msg: wmc.get('NeedSaveChange'),
			buttons: Ext.MessageBox.OKCANCEL,
			buttonText: { ok: 'Сохранить', },
			fn: function(buttonId) {
				var fn = cfg[buttonId] || cfg.default;
				if (fn) fn();
			},
			icon: Ext.MessageBox.INFO
		});
	},

	runCreateFile: function(callback) {
		if (this.beforeCreateFile(callback) !== false) {
			UploaderLib.newFile('DOCUMENTS', this.data.data.DOCUMENTS_LINK || 0, 0, -1, 0, this.getLoadMaskTarget(), callback);
		}
	},

	beforeCreateFile: function(callback) {
		var me = this;
		me.checkFilled(res => {
			if (!res) return;
			
			var newData = me.saveChangesFn();
			if (newData || !me.data.data.DOCUMENTS_LINK) {
				me.createFileMsgShow({
					ok: function() { me.saveData(function() { me.runCreateFile(callback); }, newData); }
				});
				return false;
			}
			return _;
		});		
	},

	//конфигурация основого окна
	viewCfg: function() {
		var result = this.callParent(arguments);
		result.resizable = true;
		result.maximizable = true;
		//result.minWidth = 600;
		//result.minHeight = 300;
		//result.width = this.width;
		return result;
	},

	dataCollector: function() {
		var me = this,
			objs = me.objs,
			d = objs.DT.getValue(),
			data = me.callParent(arguments);

		if (me.data) {
			var objData = me.data.data;
			data.docLink = objData.DOCUMENTS_LINK || 0;
			data.NUMBER = objs.NUMBER.getValue();
			data.DT = Ext.isDate(d) ? d.toDateString() : null;
			data.S_STATUS = objs.S_STATUS.getValue();
			data.FILES = objData.FILES;
			data.T_REVIZ_OBJECTS = objData.T_REVIZ_OBJECTS;
			data.narRem = JSON.stringify(me.getNarRemoveGrid().store.getDataExt(function(r) {
				var f = (r.persons = JSON.stringify(ArrayLib.getLinks(me.getNarRemPersons(r.LINK), 'S_PERSON'))) === '[]';
				f = f && !r.DTSROK;
				Ext.each(me._arrTextEditorColumns, function(k) { return f = f && !r[k]; });
				return f ? _ : r;
			}));

			var dtEnd;
			me.getNarRemoveGrid().store.each(function(r) {
				var dtSrok = r.get('DTSROK') ? new Date(r.get('DTSROK')) : dtEnd;
				if (!dtEnd || dtSrok > dtEnd) dtEnd = dtSrok;
			});
			data.DTEND = dtEnd || data.DT;

			data.isVfa = me.isVfa;
		}

		return data;
	},

	getExtra: function(callBack) {
		var me = this,
			objs = me.objs,
			data = me.data ? me.data.data : {};

		me.baseGetExtra({
			revizLink: data.LINK,
			docLink: data.DOCUMENTS_LINK || 0,
			tro: data.T_REVIZ_OBJECTS,
			isVfa: !!me.isVfa
		}, function(value) {
			if (value.Error) {
				info(value.Error);
				me.isExit = true;
				LoadMask.hide();
				return;
			}

			me.NAME = value.NAME;
			me.narRemLink = value.narRemLink;

			var status = '';
			for (var s in value.statusList) {
				status = s * 1;
				break;
			}
			if (me.readOnly || value.docVid === null || status === '') {
				objs.isDisable = true;
				objs.view.setTitle(me.getReadOnlyTitle());
				objs.NUMBER.disable();
				objs.DT.editable = false;
				objs.S_STATUS.disable();
				objs.saveBtn.disable();
			}

			me.getNarRemoveGrid().store.loadData(value.narRem, false);
			objs.narRemPersons = value.narRemPersons;

			objs.NUMBER.setValue(value.NUMBER);
			objs.DT.setValue(value.DT ? new Date(value.DT) : _);
			me.data.data.FILES = value.FILES;
			me.data.data.TEMP_EXT = value.tempExt;
			objs.btnFile.setIconCls(getExtStyle(value.tempExt));

			//Статус
			if (value.sStatus) {
				value.statusList[value.sStatus.index] = value.sStatus.value;
				status = value.sStatus.index * 1;
			}
			objs.statusStore.loadData(CBDataLib.get(_, _, value.statusList), false);

			objs.S_STATUS.setValue(status);

			me.sksd('fioWhereArgs', {
				SOrgs: { value: JSON.stringify([user.org.data.LINK]), type: 'List_int' },
				SOtdel: { value: JSON.stringify(value.otdelFamaly), type: 'List_int' }
			});

			if (callBack) callBack();
		});
	},

	profileListeners: [{ name: 'view', method: 'FormParam' }],

	//{Документ.Вид.Имя}+' № '+ {Документ.Номер} + ' от ' + ДАТАПРОП({Документ.Дата},4)
	getFileName: function() {
		var me = this,
			objs = me.objs,
			d = objs.DT.getValue();
		return Ext.String.format('{0} № {1} от {2}', me.NAME, objs.NUMBER.getValue(), Ext.isDate(d) ? Ext.Date.format(d, 'd_m_Y') : d);
	},

	isFilled: function() {
		var c = this.objs.DT,
			d = c.getValue();
		if (!(d && Ext.isDate(d))) {
			me.addToInvalidControls(c);
			return false;
		}
		return true;
	},

	getParamsForCancel: function() {
		let me = this,
			data = me.data.data,
			params = me.callParent(arguments);

		params.code = dnl.REVIZ;
		params.docLink = data.DOCUMENTS_LINK || 0;

		return params;
	}
});