﻿Ext.define('Keysystems.Documents.Edit.Request', {
	extend: 'Keysystems.Base.Edit',
	title: 'Запросы документов',
	profilePrefix: 'Document.Request',
	fieldFile: 'FILES_FILLED',
	fieldExt: 'EXTENTION',
	isFileBtn: true,
	filterField: 'S_RDOC_NAME',

	viewMinSize: [700, 600],
	profileListeners: [{ name: 'view', method: 'FormParam' }],

	constructor: function(cfg) {
		if (cfg.code !== dnl.DOCREQUEST) cfg.code = dnl.DOCREQUEST; //без этого вылетает сохранение профиля в ВФА
		cfg.GateCode = 'edit'; //без этого вылетает сохранение профиля в ВФА
		return this.callParent(arguments);
	},

	createItems: function() {
		var me = this,
			objs = me.objs;
		me.createDOCREQUESTGrids();
		var items = [
			Ext.create('Ext.form.FieldContainer', {
				layout: 'hbox',
				padding: me.bodyPadding + ' ' + me.bodyPadding + ' 0 ' + me.bodyPadding,
				items: [
					objs.NUMBER = Ext.create('Ext.form.field.Text', {
						width: 130,
						labelWidth: 30,
						disabled: true,
						disabledCls: '',
						fieldLabel: '№',
						maxLength: 25,
						enforceMaxLength: true
					}),
					objs.DT = Ext.create('Ext.form.field.Date', {
						width: 130,
						disabled: true,
						disabledCls: '',
						padding: '0 0 0 20',
						labelWidth: 30,
						fieldLabel: 'от'
					}),
					'->',
					objs.S_STATUS = Ext.create('Ext.form.field.ComboBox', {
						editable: false,
						value: 0,
						queryMode: 'local',
						fieldLabel: 'Статус',
						labelWidth: 80,
						displayField: CBDataLib.displayField,
						valueField: CBDataLib.valueField,
						store: objs.statusStore = Ext.create('Ext.data.Store', {
							fields: CBDataLib.getFields(),
							data: [],
							proxy: 'memory'
						})
					})
				]
			}),
			Ext.create('Ext.form.FieldContainer', {
				layout: { type: 'hbox', align: 'stretch' },
				padding: '0 ' + me.bodyPadding + ' 0 0',
				items: [
					objs.DTEND = Ext.create('Ext.form.field.Date', {
						maxWidth: 280,
						disabled: true,
						disabledCls: '',
						padding: '0 0 0 ' + me.bodyPadding,
						labelWidth: 180,
						fieldLabel: 'Срок исполнения'
					}) /*,
					'->',
					objs.btnFile = Ext.create('Ext.Button', {
						text: 'Файл',
						maxWidth: 100,
						width: 100,
						scope: me,
						handler: me.downloadFile
					})*/
				]
			}),
			objs.DOCREQUEST,
			objs.DOCREQUEST_RPROG
		];

		return me.callParent([items]);
	},

	fileGridEdit: function() { this.downloadFile(); },
	fileEdit: function() { this.downloadFile(); },

	downloadFile: function() {
		var me = this;
		UploaderLib.getFile(me.data.data.FILES, me.getFileName());
	},

	//{Документ.Вид.Имя}+' № '+ {Документ.Номер} + ' от ' + ДАТАПРОП({Документ.Дата},4)
	getFileName: function() {
		var me = this,
			objs = me.objs,
			d = objs.DT.getValue();
		return Ext.String.format('{0} № {1} от {2}', me.NAME, objs.NUMBER.getValue(), Ext.isDate(d) ? Ext.Date.format(d, 'd_m_Y') : d);
	},

	//конфигурация основого окна
	viewCfg: function() {
		var result = this.callParent(arguments);
		result.resizable = true;
		result.maximizable = true;
		result.minWidth = 500;
		result.minHeight = 400;
		return result;
	},
	
	dataCollector: function() {
		var me = this,
			objs = me.objs;

		var data = me.callParent([false]);
		data.DOCREQUEST = JSON.stringify(objs.DOCREQUEST.store.getDataExt());
		data.S_STATUS = objs.S_STATUS.getValue();
		data.T_DOCREQUEST_FILES = JSON.stringify(objs.T_DOCREQUEST_FILES);
		return data;
	},

	_setFileColumn: function(c, text, extCol) {
		var me = this;

		c.xtype = 'actioncolumn';
		c.width = 150;
		c.text = text;
		c.align = 'center';
		c.items = [
			{
				getClass: function(v, m, r) { return getExtStyle(r.get(extCol)); },
				handler: function(grid, rowIndex) {
					var rec = grid.getStore().getAt(rowIndex);
					if (!rec.get(c.dataIndex)) return;
					UploaderLib.getFile(rec.get(c.dataIndex), me.getDocFileName(rec));
				}
			}
		];
	},

	onFilterChange: function(th, v) {
		var me = this;
			
		let store = me.objs.DOCREQUEST.getStore(),
			val = v !== _ ? v.toLowerCase() : '';
		store.filter([{
			property: me.filterField,
			value: val,
			filterFn: function (item) {
				return item.get(me.filterField).toLowerCase().indexOf(val) !== -1;
			}
		}]);
	},

	// сейчас режим группировка по вопросам отключена, если понадобится включить, то надо исправить места,
	// где используется fieldFile
	createDOCREQUESTBtns: function() {
		var me = this,
			objs = me.objs;
		objs.btnsCfg = {
			AddFile: {
				tooltip: 'Прикрепить файл',
				tooltipType: 'title',
				disabled: true,
				iconCls: 'x_btn_attach',
				listeners: {
					change: function(th, e) {
						var files = e.target.files,
							sel = objs.DOCREQUEST.getSelectionModel().getSelection()[0];
						if (!sel) return;

						UploaderLib.uploadFiles([files[0]], _, function(id, ext, callback) {
							sel.set(me.fieldFile, id);
							sel.set(me.fieldExt, ext);
							me.docselectionchange(sel);
							callback();
						});
					},
					afterrender: function(th) {
						UploaderLib.bind(th.el.dom, function(link, ext, callback) {
							var sel = objs.DOCREQUEST.getSelectionModel().getSelection()[0];
							if (!sel) return;
							sel.set(me.fieldFile, link);
							sel.set(me.fieldExt, ext);
							me.docselectionchange(sel);
							callback();
						});
					}
				}
			},
			OpenFile: {
				tooltip: 'Открыть файл',
				hidden: true,
				tooltipType: 'title',
				handler: function() {
					var sel = objs.DOCREQUEST.getSelectionModel().getSelection()[0];
					if (!sel) return;
					UploaderLib.getFile(sel.get(me.fieldFile), me.getDocFileName(sel));
				}
			},
			DelFile: {
				iconCls: 'x_btn_attach_del',
				tooltip: 'Удалить файл',
				disabled: true,
				tooltipType: 'title',
				handler: function() {
					var sel = objs.DOCREQUEST.getSelectionModel().getSelection()[0];
					if (!(sel && sel.get(me.fieldFile))) return;

					selectDialogShow(KS.L10n.attention, KS.L10n.delete_existing_file, function() {
						sel.set(me.fieldFile, 0);
						sel.set(me.fieldExt, '');
						me.docselectionchange(sel);
					});
				}
			}
		};

		objs.btnOpenFile = Ext.create('Ext.Button', {
			tooltip: 'Открыть файл',
			hidden: true,
			tooltipType: 'title',
			handler: function() {
				var sel = objs.DOCREQUEST.getSelectionModel().getSelection()[0];
				if (!sel) return;
				UploaderLib.getFile(sel.get(me.fieldFile), me.getDocFileName(sel));
			}
		});
		objs.btnDelFile = Ext.create('Ext.Button', {
			iconCls: 'x_btn_attach_del',
			tooltip: 'Удалить файл',
			disabled: true,
			tooltipType: 'title',
			handler: function() {
				var sel = objs.DOCREQUEST.getSelectionModel().getSelection()[0];
				if (!(sel && sel.get(me.fieldFile))) return;

				selectDialogShow(KS.L10n.attention, KS.L10n.delete_existing_file, function() {
					sel.set(me.fieldFile, 0);
					sel.set(me.fieldExt, '');
					me.docselectionchange(sel);
				});
			}
		});
	},

	createDOCREQUESTGrids: function() {
		var me = this,
			objs = me.objs,
			store = Ext.create('Ext.data.Store', {
				fields: [],
				data: [],
				proxy: 'memory'
			});

		me.createDOCREQUESTBtns();

		objs.DOCREQUEST = Ext.create('Ext.grid.Panel', {
			autoScroll: true,
			autoRender: true,
			plugins: [Ext.create('Ext.grid.plugin.CellEditing', { clicksToEdit: 1 }), 'gridclipboard'],
			listeners: {
				selectionchange: function(th, sels) { me.docselectionchange(sels[0]); },
				itemdblclick: function(th, rec) { me.showFileList(rec); }
			},
			columns: [],
			tbar: [
				/*objs.btnAddFile = Ext.create('Ext.form.field.FileButton', objs.btnsCfg.AddFile),
				objs.btnOpenFile = Ext.create('Ext.Button', objs.btnsCfg.OpenFile),
				objs.btnDelFile = Ext.create('Ext.Button', objs.btnsCfg.DelFile),*/
				objs.btnEditFiles = Ext.create('Ext.Button', {
					tooltip: 'Файлы',
					tooltipType: 'title',
					disabled: true,
					iconCls: 'x_btn_folder_open',
					handler: function() { me.showFileList(objs.DOCREQUEST.getSelectionModel().getSelection()[0]); }
				}),
				'-',
				Ext.create('Ext.form.field.Text', {
					flex: 1,
					triggers:{
						clear:{
							cls: 'x_btn_clean x-dict-trigger',
							tooltip: 'Очистить',
							handler: function() {
								this.setValue('');
								me.onFilterChange(me);
							}
						},
						search:{
							cls: 'x_btn_search x-dict-trigger',
							tooltip: 'Поиск',
							handler: function() {
								me.onFilterChange(me, this.getValue());
							}
						}
					},
					listeners: {
						change: { fn: me.onFilterChange.bind(me), buffer: 500 }
					}
				}),
				'->'
			],
			store: store,
			columnLines: true,
			flex: 1
		});

		objs.DOCREQUEST_RPROG = Ext.create('Ext.grid.Panel', {
			hidden: true,
			autoScroll: true,
			autoRender: true,
			features: [
				objs.groupFeature = Ext.create('Ext.grid.feature.Grouping', {
					groupHeaderTpl: '{name}', //'{name}({rows.length})',
					enableGroupingMenu: false,
					hideGroupedHeader: true
				})
			],
			listeners: { selectionchange: function(th, sels) { me.docselectionchange(sels[0]); } },
			columns: [],
			tbar: [
				Ext.create('Ext.Button', {
					iconCls: 'x_btn_treeexpand',
					tooltip: 'Развернуть все узлы',
					tooltipType: 'title',
					handler: function() { objs.groupFeature.expandAll(); }
				}),
				Ext.create('Ext.Button', {
					iconCls: 'x_btn_treecollapse',
					tooltip: 'Свернуть все узлы',
					tooltipType: 'title',
					handler: function() { objs.groupFeature.collapseAll(); }
				}),
				'-',
				objs.btnAddFile_RPROG = Ext.create('Ext.form.field.FileButton', objs.btnsCfg.AddFile),
				objs.btnOpenFile_RPROG = Ext.create('Ext.Button', objs.btnsCfg.OpenFile),
				objs.btnDelFile_RPROG = Ext.create('Ext.Button', objs.btnsCfg.DelFile)
			],
			store: store,
			columnLines: true,
			flex: 1,
			plugins: ['gridclipboard']
		});
	},

	successSaveFunc: function(res) {
		if (res.T_DOCREQUEST_FILES) this.objs.T_DOCREQUEST_FILES = res.T_DOCREQUEST_FILES;
		this.callParent(arguments);
	},

	getExtra: function(callBack, link) {
		var me = this,
			objs = me.objs;

		me.baseGetExtra({ link: link }, function(value) {
			var status = '';
			for (var s in value.statusList) {
				status = s * 1;
				break;
			}
			if (status === '') {
				objs.isDisable = true;
				objs.view.setTitle(me.getReadOnlyTitle());
				/*objs.btnAddFile.disable();
				objs.btnDelFile.disable();*/
				objs.saveBtn.disable();
			}

			me.NAME = value.NAME;
			objs.NUMBER.setValue(value.NUMBER);
			objs.DT.setValue(value.DT ? new Date(value.DT) : _);
			objs.DTEND.setValue(value.DTEND ? new Date(value.DTEND) : _);

			if (!me.data) me.data = { data: {} };

			me.data.data.FILES = value.FILES;
			me.data.data.TEMP_EXT = value.tempExt;
			objs.btnFile.setIconCls(getExtStyle(value.tempExt));

			//Статус
			if (value.sStatus) {
				value.statusList[value.sStatus.index] = value.sStatus.value;
				status = value.sStatus.index * 1;
			}
			objs.statusStore.loadData(CBDataLib.get(_, _, value.statusList), false);

			objs.S_STATUS.setValue(status);

			//Таблица
			objs.T_DOCREQUEST_FILES = value.T_DOCREQUEST_FILES;

			var data = value.DOCREQUEST,
				store = objs.DOCREQUEST.store;

			if (value.isRPROG) { //нормальный режим
				objs.fileForm = objs.fileForm_RPROG;
				objs.btnAddFile = objs.btnAddFile_RPROG;
				objs.btnOpenFile = objs.btnOpenFile_RPROG;
				objs.btnDelFile = objs.btnDelFile_RPROG;

				objs.DOCREQUEST.hide();
				objs.DOCREQUEST_RPROG.show();
				objs.DOCREQUEST = objs.DOCREQUEST_RPROG;
				store = objs.DOCREQUEST_RPROG.store;
			} else {
				var docData = JSON.parse(JSON.stringify(data.data)),
					rdocDict = objs.rdocDict = {};

				Ext.each(docData, function(row) { (rdocDict[row.S_RDOC] || (rdocDict[row.S_RDOC] = [])).push(row); });

				docData = [];
				for (var rdoc in rdocDict) {
					var d = rdocDict[rdoc],
						r = d[0];
					if (!r.FILES_EXAMPLE) {
						Ext.Array.filter(d, function(r1) {
							if (!r.FILES_EXAMPLE && r1.FILES_EXAMPLE) {
								r.FILES_EXAMPLE = r1.FILES_EXAMPLE;
								r.TEMP_EXTEXAMPLE = r1.TEMP_EXTEXAMPLE;
							}
							if (!r.COMMENT && r1.COMMENT) r.COMMENT = r1.COMMENT;

							return !(r.FILES_EXAMPLE && r.COMMENT);
						});
					}
					docData.push(r);
				}

				data.data = docData;
			}

			store.setFields(data.fields);			
			//store.setFields(data.fields);
			
			Ext.Array.filter(data.columns, function(c) {
				switch (c.dataIndex) {
				case 'S_RDOC_NAME':
					c.flex = 1;
					break;
				case 'FILES_EXAMPLE':
					me._setFileColumn(c, 'Шаблон для заполнения', 'TEMP_EXTEXAMPLE');
					break;
				case me.fieldFile:
					c.xtype = 'actioncolumn';
					c.width = 150;
					c.text = 'Заполненный документ';
					c.align = 'center';
					c.items = [
						{
							getClass: function(v, m, r) {
								var files = me.getTempFiles(r.get('LINK'));
								return files.length ? files.length === 1 ? getExtStyle(files[0][me.fieldExt]) : 'x_btn_folder' : _;
							},
							handler: function(grid, rowIndex) { me.showFileList(grid.getStore().getAt(rowIndex)); }
						}
					];
					break;
				case 'COMMENT':
					c.text = 'Комментарии';
					c.editor = {
						xtype: 'triggertexteditor',
						editable: false,
						getEditorTitle: function() { return this.column.text; }
					};
				}
			});
			objs.DOCREQUEST.reconfigure(store, data.columns);

			store.loadData(data.data, false);

			if (callBack) callBack();
		});
	},
	getTempFiles: function (link) {
		return this.objs.T_DOCREQUEST_FILES.filter(function(d) { return d.DOCREQUEST === link; });
	},
	setTempFiles: function(link, files) {
		var me = this;
		me.bindData(
			me.getTempFiles(link),
			files,
			me.objs.T_DOCREQUEST_FILES,
			function(oldList, d) { return ArrayLib.find(oldList, ['LINK'], d.LINK); },
			function(d) {
				return {
					DOCREQUEST: link,
					FILES: d.LINK,
					EXTENTION: d.EXTENTION,
					NAME: d.NAME,
					DTCREATE: d.DTCREATE
				};
			}
		);
	},

	showFileList: function(rec) {
		var me = this,
			link = rec.get('LINK');
		UploaderLib.showFileList({
			readOnly: me.objs.isDisable,
			getFiles: function(callBack) { callBack(me.getTempFiles(link)); },
			setFiles: function(files) {
				me.setTempFiles(link, files);
				rec.afterEdit(['FILES']);
			}
		}, { fieldFile: 'LINK' });
	},

	//"{Вид док.} № {Номер} от {Дата('дд мм гггг')}"
	getDocFileName: function(rec) {
		var name = rec.get('S_RDOC_NAME'),
			n = rec.get('NUMBER'),
			d = rec.get('DT');

		if (n) name += ' № ' + n;

		if (d) name += ' от ' + (Ext.isDate(d) ? Ext.Date.format(d, 'd m Y') : d);

		return name;
	},

	docselectionchange: function(rec) {
		this.objs.btnEditFiles.setDisabled(!rec);
		/*var objs = this.objs;
		if (!objs.isDisable) {
			objs.btnAddFile.setDisabled(!rec);
			objs.btnDelFile.setDisabled(!rec);
		}
		if (rec) rec = rec.get(this.fieldExt);
		if (rec) {
			objs.btnOpenFile.show();
			objs.btnOpenFile.setIconCls(getExtStyle(rec));
		} else {
			objs.btnOpenFile.hide();
		}*/
	},

	isFilled: Ext.trueFn,
	
	getParamsForCancel: function() {
		let me = this,
			data = me.data.data,
			params = me.callParent(arguments);

		params.code = dnl.DOCUMENTS;

		return params;
	}
});