﻿// Данную форму пока не используем. Создание Требования в Документах происходит через грид
Ext.define('Keysystems.Documents.Edit.NarRemove', {
	extend: 'Keysystems.Base.Edit',
	title: 'Требования',
	createItems: function() {
		var me = this,
			objs = me.objs,
			items = [
				objs.CONTENT = Ext.create('Ext.form.field.Text', {
					labelWidth: me.labelWidth,
					maxLength: 8000,
					enforceMaxLength: true,
					fieldLabel: 'Требование по устранению',
					width: me.width
				}),
				objs.DTDONE = Ext.create('Ext.form.field.Date', {
					fieldLabel: 'Дата устранения',
					labelWidth: me.labelWidth,
					format: 'd.m.Y',
					minValue: '01.01.1900',
					maxValue: '31.12.2100'
				}),
				objs.DTSROK = Ext.create('Ext.form.field.Date', {
					fieldLabel: 'Срок устранения',
					labelWidth: me.labelWidth,
					format: 'd.m.Y',
					minValue: '01.01.1900',
					maxValue: '31.12.2100'
				}),
				objs.RESULT = Ext.create('Ext.form.field.Text', {
					labelWidth: me.labelWidth,
					maxLength: 8000,
					enforceMaxLength: true,
					fieldLabel: 'Результат',
					width: me.width
				}),
				objs.COMMENT = Ext.create('Ext.form.field.Text', {
					labelWidth: me.labelWidth,
					maxLength: 8000,
					enforceMaxLength: true,
					fieldLabel: 'Примечание',
					width: me.width
				}),
				objs.FACTNAR = Ext.create('Keysystems.Controls.Dict.Edit', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Факт нарушения',
					width: me.width,
					code: dnl.DOCUMENTS,
					handler: function() {
						var rcode = 'DOCUMENTS',
							rprefix = 'Document',
							rgateCode = 'edit',
							rprofileKey = 'tabNarRemoveNar',
							getDataFn = function() {
								var res = [];
								Ext.each(me.factNar.data, function(rec) {
									res.push(rec.getData());
								});
								return res;
							};

						objs.dictNar = Ext.create('Keysystems.FactNar.List.Tree', {
							parentView: me.objs.tabRespons,
							title: 'Факт нарушения',
							selectLinks: objs.FACTNAR.getValue(),
							mode: 'SINGL',
							btnsHide: { search: true },
							head: false,
							hideFilterPanel: true,
							hideBottomPanel: true,
							clear: function() { me.setFactNarExtra(0); },
							functions: {
								getData: function(endFunc) {
									loadProfile({
										code: rcode,
										prefix: rgateCode,
										gateCode: rprefix,
										profileKey: rprofileKey,
										callBack: function() {
											var data = getDataFn();
											endFunc({
												columns: me.factNar.columns,
												fields: me.factNar.fields,
												data: {
													data: data,
													total: data.length
												}
											});
										}
									});
								},
								refresh: function(endFunc) {
									var data = getDataFn();
									endFunc({
										data: data,
										total: data.length
									});
								},
								ok: function(value) {
									objs.FACTNAR.setValue(value);
								}
							}
						});
					}
				})
			];

		return me.callParent([items]);
	},

	loadCopyEditData: function() {
		var me = this,
			objs = me.objs,
			data = me.data.data,
			arr = ['COMMENT', 'CONTENT', 'DTDONE', 'DTSROK', 'RESULT'];

		Ext.each(arr, function(key) {
			objs[key].setValue(data[key]);
		});

		objs.FACTNAR.setValue(data.FACTNAR ? {
			LINK: data.FACTNAR,
			CODE: data.FACTNAR_CODE,
			NAME: data.FACTNAR_NAME
		} : null);

		me.callParent();
	},

	isFilled: function() {
		return true;
	},

	dataCollector: function() {
		var me = this,
			objs = me.objs,
			data = me.callParent();

		data.CONTENT = objs.CONTENT.getValue();
		data.DTDONE = objs.DTDONE.getValue();
		data.DTSROK = objs.DTSROK.getValue();
		data.RESULT = objs.RESULT.getValue();
		data.COMMENT = objs.COMMENT.getValue();
		data.FACTNAR = objs.FACTNAR.getValue();

		return data;
	}
});