﻿Ext.define('Keysystems.SyncDictionary.List',
    {
        extend: 'Keysystems.Base.List',

        syncColumn: true,
        syncColumnName: 'Наименование АСП',
        multiChoise: true,
        tableName: '',
        tTableName: '',
        relatedTableName: '',
        DictEditColumn: '',
                
        addedCheckLinks: [], //чтоб много данных не гонять, отслеживаем конкретно только доотмеченные (до сохранения)
        deletedCheckLinks: [],                                                         //и размеченные (до сохранения). после сохранения чистим и копим по новой
        addedCheckLinksCounter: 0,

        getGridCfg: function () {
            var cfg = this.callParent();
            cfg.plugins.push(Ext.create('Ext.grid.plugin.CellEditing', { clicksToEdit: 1 }));
            return cfg;
        },

        baseGetData: function (endFunc, params) {
            var me = this;

            me.callParent([
                function (data) {
                    me.tTableName = me.code.replace('DICTIONARY_S', 'T_S');
                    me.relatedTableName = me.code.replace('DICTIONARY_S', 'S_').replace('_ESGFK', '');
                    me.DictEditColumn = data.DictEditColumn;
                    me.resetTempData();

                    me.relatedTableName = data.RelatedTableName;
                    me.tableName = data.TableName;                    
                    
                    if (endFunc) endFunc(data);
                }, params
            ]);
        },

        columnsAdapted: function() {
            var me = this,
                cols = this.callParent(arguments);

            if (me.syncColumn) {
                var tempColName = 'TEMP_VAL';
                var col = ArrayLib.filter(cols, ['dataIndex'], tempColName)[0];
                var dataIndex = me.tableName;
                if (col) {
                    col.xtype = 'dictcolumn';
                    col.code = dnl[dataIndex];
                    col.renderer = function(v, m) {
                        m.innerCls = 'x_btn_dict';
                        m.style += ' background-repeat: no-repeat; background-position: right; display: block;';
                        return v;
                    };
                    col.defaultRenderer = function(v, m, r) {
                        return (v || (r ? (r.data || r)[dataIndex] : _)) || _;
                    };
                    col.ksGetValue = function(rec) {
                        var th = this;

                        var res = [];
                        var tTable = me.gksd('tTableData');
                        
                        Ext.each(tTable, function(r) {
                            if (r[me.tableName] === rec.data.LINK)
                                res.push({
                                    data: {
                                        LINK: r[me.relatedTableName]
                                    }
                                });
                        });

                        return res;
                    };
                    col.ksSetValue = function(v, rec) {
                        var th = this;

                        me.objs.tbarBtns.save_syncdict.setDisabled(false);
                        if (v.length === 0)
                            rec.set('TEMP_VAL', '');
                        if (v.length === 1)
                            rec.set('TEMP_VAL', v[0].data.CODE + ' — ' + v[0].data.NAME);
                        if (v.length > 1)
                        {
                            var str = '';
                            v.sort(function (a, b) {
                                return ('' + a.data.CODE).localeCompare(b.data.CODE);
                            })
                            
                            if (me.code.indexOf('ARTICLE') !== -1)
                                Ext.each(v, function (z) {
                                    str += z.data.CODE + '; ';
                                });
                            else
                                Ext.each(v, function (z) {
                                   str += z.data.CODE + ' — ' + z.data.NAME + '; '; 
                                });
                            rec.set('TEMP_VAL', str);
                        }
                        
                        //удалим старые сопоставления в T_
                        var tTable = me.gksd('tTableData');
                        var toRemove = tTable.filter(e => e[me.tableName] === rec.data['LINK']);
                        toRemove.forEach(e => Ext.Array.remove(tTable, e));
                        
                        //удалим старые сопоставления в Integration_links
                        var ilTable = me.gksd('integrationLinksData');
                        var table = me.Grid.store.getDataExt();
                        var extId = ArrayLib.filter(table, ['LINK'], rec.data['LINK'])[0]['ID'];
                        var toRemoveIl = ilTable.filter(e => e['EXT_LINK'] === extId);
                        toRemoveIl.forEach(e => Ext.Array.remove(ilTable, e));
                        
                        //вставим новые
                        Ext.each(v, function (z) {
                            me.addedCheckLinksCounter--;

                           // let newRec = tTable.add({})[0];

                            //newRec.beginEdit();
                            //newRec[me.tableName] = rec.data['LINK'];
                            //newRec[me.relatedTableName] = z.data.LINK;
                            //newRec.endEdit();
                            
                            var newRec = { LINK: me.addedCheckLinksCounter };
                            newRec[me.tableName] = rec.data['LINK'];
                            newRec[me.relatedTableName] = z.data.LINK;
                            tTable.push(newRec);

                            var newRecIL = { LINK: me.addedCheckLinksCounter };
                            newRecIL['TLINK'] = z.data.LINK;
                            newRecIL['EXT_LINK'] = extId;
                            ilTable.push(newRecIL);
                        });                         
                        
                        rec.endEdit();
                    };

                    col.editor = Ext.create({
                        xtype: 'triggerdict',
                        cleaningKey: false,
                        dataIndex: dataIndex,
                        handler: function () {
                            var c = this;
                            var tTable = me.gksd('tTableData'),
                                currCheckedLinks = [];

                            Ext.each(tTable,
                                function(rec) {
                                    if (rec[me.tableName] === c.editRecord.data.LINK){
                                        var newRec = { LINK: rec[me.relatedTableName] };
                                        currCheckedLinks.push({ data: newRec});
                                    }
                                }
                            );
                            
                            var wArgs = {
                                InLinksOnly: { value: 'False', type: 'bool' }
                            }
                            if (me.tableName.indexOf('ARTICLE') !== -1)
                            {
                                wArgs.Npa = { value: JSON.stringify([c.editRecord.data.SNPA_LINK ?? 0]), type: 'List_int' };
                            }
                            
                            dictFunc({
                                mode: me.tableName.indexOf('NPA') !== -1 ? 'SINGLE' : 'MULTI',
                                code: me.code.replace('_ESGFK', ''),
                                selectLinks: currCheckedLinks,
                                head: false,
                                hidePagging: true,
                                footerPanel: false,
                                whereArgs: wArgs,
                                btnsHide: {
                                    new: true,
                                    same: true,
                                    edit: true,
                                    delete: true,
                                    settings: true,
                                    profile: true,
                                    wrap: true,
                                    search: true,
                                    relations: true,
                                    journal: true,
                                    galka: true,
                                    unmark: true,
                                    edit_reviz: true,
                                    add_slave: true,
                                    expandall: true,
                                    collapseall: true,
                                    make_child: true,
                                    make_parent: true
                                },
                                linkParent: c.editRecord.data.LINK,
                                codeParent: me.code,
                                tempNewCheckedLinks: JSON.stringify(me.addedCheckLinks),
                                tempUncheckedLinks: JSON.stringify(me.deletedCheckLinks),
                                getGridStoreCfg: function () {
                                    var cfg = this.callParent(arguments);
                                    cfg.proxy = 'memory';
                                    cfg.remoteSort = false;
                                    return cfg;
                                },
                                refresh: function () {
                                    this.getData();
                                }
                            }, 
                            {
                                ok: function (value) {
                                    var oldLinks = me.gksd('tTableData').filter(e => e[me.tableName] === c.editRecord.data.LINK).map(function(v){ return v[me.relatedTableName]; });
                                    var newLinks = value.map(function(v){ return v.data.LINK; });
                                    col.ksSetValue.call(col, value, c.editRecord);
                                    var link = value[0] ? (value[0].data || value[0]).LINK : 0;
                                    c.setValue(link);

                                    var newCheckedLinks = newLinks.filter(x => !oldLinks.includes(x));
                                    var uncheckedLinks = oldLinks.filter(x => !newLinks.includes(x)); 
                                    
                                    Ext.each(newCheckedLinks, function(link) {
                                        if (me.deletedCheckLinks.indexOf(link) !== -1){
                                            var toRemove = me.deletedCheckLinks.filter(e => e === link);
                                            toRemove.forEach(e => Ext.Array.remove(me.deletedCheckLinks, e));    
                                        }
                                        else
                                            me.addedCheckLinks.push(link);
                                    });

                                    Ext.each(uncheckedLinks, function(link) {
                                        if (me.addedCheckLinks.indexOf(link) !== -1){
                                            var toRemove = me.addedCheckLinks.filter(e => e === link);
                                            toRemove.forEach(e => Ext.Array.remove(me.addedCheckLinks, e));
                                        }
                                        else
                                            me.deletedCheckLinks.push(link);
                                    });
                                    
                                    if (newCheckedLinks.length > 1 || uncheckedLinks.length)
                                        me.objs.tbarBtns.save_syncdict.setDisabled(false);
                                }
                            });
                        }
                    });
                }
            }

            return cols;
        },

        fieldsAdapted: function (fields) {
            var me = this;

            if (me.syncColumn) {
                var pos = ArrayLib.find(fields, ['name'], me.syncColumnName);
                if (pos === -1)
                    fields.push(me.syncColumnName);
                else
                    fields[pos].type = 'string';
                if (!me.thereIsField(fields, 'SyncColumn')) fields.push('SyncColumn');
            }
            return fields;
        },

        beforeSetData: function (data, p) {
            var me = this,
                res = me.callParent(arguments);

            me.sksd('tTableData', data.tTableData);
            me.sksd('integrationLinksData', data.integrationLinksData);

            return res;
        },

        saveSyncData: function (endFunc) {
            var me = this;

            Log.sendLog(KS.L10n.saving);
            me.showLoadMask({
                msg: KS.L10n.saving,
                rid: ajaxRequest({
                    url: me.linkCode + '/SaveSyncData_A',
                    params: {
                        gzipData: SignalR.pack({
                            tTableData: JSON.stringify(me.gksd('tTableData')),
                            integrationLinksData: JSON.stringify(me.gksd('integrationLinksData')),
                            code: me.code
                        })
                    },
                    success: function (result) {
                        me.hideLoadMask();

                        me.resetTempData();
                        
                        if (result.type === 'info' || result.type === 'block') {
                            me.gksc('splitterMSG').show();
                            me.gksc('infoBlock').setText(result.text, false);
                            me.gksc('infoBlockPanel').show();
                        } else if (result.type === 'question' && !me.ignoreQuestion) {
                            ChooseBox.ShowHTML({
                                caption: 'Протокол сохранения',
                                text: result.text,
                                warnOrErrorIcon: true,
                                hasIgnoreButton: true,
                                nextFn: function () {
                                    me.ignoreQuestion = true;
                                    me.saveData(endFunc);
                                }
                            });
                        }

                        if (result.result) {
                            me.successSaveFunc(result, endFunc);
                        }
                    },
                    failure: function (val) {
                        me.hideLoadMask();

                        QuickMsgs.notSave();
                        Log.sendLog(wmc.get('SavingError'));
                        failureShow(val, wmc.get('SavingError'));
                    }
                })
            });
        },

        baseRefresh: function (callBack, params) {
            var me = this;
            
            this.callParent([
                function (d) {
                    me.resetTempData();
                    me.sksd('tTableData', d.result.tTableData);
                    me.sksd('integrationLinksData', d.result.integrationLinksData);
                    
                    if (callBack) callBack.apply(this, arguments);
                }, params
            ]);

            me.objs.tbarBtns.save_syncdict.setDisabled(true);
        },

        resetTempData: function () {
            var me = this;

            me.addedCheckLinks = [];
            me.deletedCheckLinks = [];
            me.addedCheckLinksCounter = 0;
        },
        
        autoSyncDict: function () {
            var me = this,
                model = me.objs.selModel,
                sels = [];
            
            Ext.each(model.getSelection(), function(r) {
                sels.push(r.data.LINK);
            });
            
            Ext.Msg.show({
                title: KS.L10n.autoSync,
                msg: Ext.String.format(KS.L10n.autoSync, ''),
                buttons: Ext.MessageBox.YESNOCANCEL,
                buttonText: { yes: KS.L10n.forAllRecords, no: KS.L10n.forCurrentRecords, cancel: KS.L10n.cancel },
                animateTarget: me,
                fn: function(buttonId) {
                    switch (buttonId) {
                        case 'yes':
                            me.autoSyncDictAjax();
                            break;
                        case 'no':
                            if (sels && sels.length === 0)
                                warning('Нет выделенных записей!');
                            me.autoSyncDictAjax(sels);
                            break;
                    }
                    if (callBack) callBack();
                },
                icon: Ext.MessageBox.QUESTION
            });
        },
        
        autoSyncDictAjax: function (selectedLinks) {
            var me = this;
            
            me.showLoadMask({
                msg: 'Автоматическое сопоставление',
                rid: ajaxRequest({
                    url: me.linkCode + '/AutoSyncDictionaryEsgfk_A',
                    params: {
                        gzipData: SignalR.pack({
                            selectedLinks: JSON.stringify(selectedLinks)
                        })
                    },
                    success: function (res) {
                        if (res) {
                            if (res.error) {
                                showError(res.error);
                            }
                            me.refresh(true, 1);
                        } else {
                            me.refresh(true, 1);
                        }
                        me.hideLoadMask();
                    }
                })
            });
        },

        enableToolFilter: function() {
            if (!this.objs.tbarBtns) return;

            let me = this;
            me.objs.tbarBtns.save_syncdict.setDisabled(true);
        }
    });
