﻿Ext.define('Keysystems.Edits.SaveRules', {
	extend: 'Keysystems.Base.Edit',

	//наименования контролов
	keysControl: ['NOTE', 'FORMULA', 'MESSAGE', 'TYPE'],

	//констркутор интерфейса
	createItems: function() {
		var me = this,
			objs = me.objs,
			items = [
				objs.NOTE = Ext.create('Ext.form.field.Text', {
					labelWidth: me.labelWidth,
					ksAllowEmpty: true,
					fieldLabel: 'Описание'
				}),
				objs.FORMULA = Ext.create('Keysystems.Controls.Formula.Edit', {
					fieldLabel: 'Формула',
					ksAllowEmpty: true,
					labelWidth: me.labelWidth,
					height: 80,
					IsMask: true,
					IncludeSCalc: false
				}),
				objs.MESSAGE = Ext.create('Ext.form.field.TextArea', {
					fieldLabel: 'Сообщение об ошибке',
					ksAllowEmpty: true,
					labelWidth: me.labelWidth,
					height: 80
				}),
				objs.TYPE = Ext.create('Ext.form.field.ComboBox', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Тип контроля',
					ksAllowEmpty: true,
					editable: false,
					value: 0,
					store: Ext.create('Ext.data.Store', {
						fields: CBDataLib.getFields(),
						data: CBDataLib.get('SaveRuleType'),
						proxy: 'memory'
					}),
					displayField: 'value',
					valueField: 'index'
				})
			];

		return me.callParent([items]);
	},

	loadCopyEditData: function() {
		var me = this,
			objs = me.objs,
			data = me.data.data;

		Ext.each(me.keysControl, function(key) { objs[key].setValue(data[key]); });

		me.callParent();
	},

	dataCollector: function() {
		var me = this,
			objs = me.objs,
			data = me.callParent(arguments);

		Ext.each(me.keysControl, function(key) { data[key] = objs[key].getValue(); });

		return data;
	},

	isFilled: function() {
		var me = this,
			objs = me.objs,
			res = true;

		Ext.each(me.keysControl, function(key) {
			if (objs[key].getValue() === '') {
				res = false;
				me.addToInvalidControls(objs[key]);
			}
		});
		return res;
	},

	getExtra: function(callback) { callback && callback(); }
});