﻿Ext.define('Keysystems.SVarParam.Edit', {
	extend: 'Keysystems.Base.Edit',
	fstTitle: 'Варианты - ',
	createItems: function() {
		var me = this,
			objs = me.objs,
			items = [
				objs.FORMNAME = Ext.create('Ext.form.field.Text', {
					fieldLabel: 'FORMNAME',
					labelWidth: me.labelWidth,
					width: me.width,
					hidden: true,
					setLock: function() {}
				}),
				objs.S_PLANPROJ = me.createDictEdit({
					key: 'S_PLANPROJ',
					code: dnl.S_PLANPROJ,
					fieldLabel: 'Проект плана',
					mode: 'SINGL'
				}),
				objs.USERNAME = Ext.create('Ext.form.Checkbox', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Для пользователя'
				})
			];

		me.isCodeEdit = true;
		me.codeEditCfg = { maxLength: 50, enforceMaxLength: true };
		me.isNameEdit = true;
		me.nameEditCfg = { maxLength: 150, enforceMaxLength: true };

		return me.callParent([items]);
	},
	dataCollector: function() {
		var me = this,
			objs = me.objs,
			data = me.callParent(arguments);
		data.FORMNAME = objs.FORMNAME.getValue();
		data.USERNAME = objs.USERNAME.getValue();
		data.S_PLANPROJ = objs.S_PLANPROJ.getLink();
		return data;
	},	
	getExtra: function(endFunc, link) {
		var me = this,
			objs = me.objs;

		
		me.baseGetExtra({ link: link }, function (value) {
			const data = value.row;
			me.autoFillControl(data);
			const formName = data.FORMNAME || (objs.FORMNAME.value || '');

			objs.USERNAME.setValue(!!data.USERNAME);
			objs.USERNAME.setVisible(formName.indexOf('FormReport') === -1);
			if (data.FORMNAME) objs.FORMNAME.setValue(data.FORMNAME);
			me.setReadOnly(data.BASE);
			
			objs.S_PLANPROJ.setVisible(formName.indexOf('Rang') >= 0);
			if (value.S_PLANPROJ) objs.S_PLANPROJ.setValue(value.S_PLANPROJ);

			if (endFunc) endFunc();
		})
	}
});