﻿Ext.define('Keysystems.STask.Gantt', {
	extend: 'Keysystems.Base.List',
	fileColumn: true
});
Ext.define('Keysystems.STask.Edit.Gantt', {
	extend: 'Keysystems.Base.Edit',
	title: 'Документ',
	linkCode: 'STaskDoc',
	profilePrefix: 'Task.Gantt',
	keyEdit: 'edit.Task.Gantt',
	f: 'new',
	_arrGeneral: ['TYPE', 'DTMASK', 'DTENDMASK', 'ENDWARN', 'DURATION', 'INITIAL', 'OPTIONAL', 'AUTODO', 'AUTONAR'],
	_arrMail: ['EMAIL', 'TEMA', 'BODY', 'SENDWHEN', 'CNTDAYS', 'NDAYS', 'SENDDIRECT'],
	_arrSave: ['S_WORK', 'TASKDOCC', 'TASKDOCP', 'S_DOCVID', 'PERSONFORMULA', 'S_PERSON', 'AUTOSIGNFORMULA', 'AUTOSIGN', 'AUTOCORR', 'DIRECTORC'],
	_arrCorrSave: ['CORR_ORG', 'CORR_OTDEL', 'CORR_PERSON'],

	viewMinSize: [700, 480],
	bodyPadding: 0,

	createItems: function() {
		var me = this;
		return me.objs.allTab = Ext.create('Ext.tab.Panel', {
			plain: true,
			border: 0,
			flex: 1,
			userCls: me.basePanelCls,
			bodyCls: me.basePanelBodyCls,
			items: me.objs.items = [me.getTab('General')]
		})
	},

	//конструктор таба Общие
	createTabGeneral: function() {
		var me = this,
			objs = me.objs;

		return objs.tabGeneral = Ext.create('Ext.panel.Panel', {
			title: 'Общие',
			layout: { type: 'vbox', align: 'stretch' },
			bodyPadding: 10,
			flex: 1,
			border: 0,
			items: [
				objs.TASKDOCP = Ext.create('Keysystems.Controls.Dict.Edit', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Предыдущий(е)',
					mode: 'MULTI',
					handler: function() { me.taskDocDictFunc('TASKDOCP'); }
				}),
				objs.TASKDOCC = Ext.create('Keysystems.Controls.Dict.Edit', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Следующий(е)',
					mode: 'MULTI',
					handler: function() { me.taskDocDictFunc('TASKDOCC'); }
				}),
				objs.S_DOCVID = Ext.create('Keysystems.Controls.Dict.Edit', {
					fieldLabel: 'Вид документа',
					ksAllowEmpty: true,
					labelWidth: me.labelWidth,
					handler: function() {
						dictFunc({
							mode: 'SINGLE',
							parentView: objs.view,
							selectLinks: objs.S_DOCVID.getValue(),
							code: dnl.S_DOCVID,
							readOnly: objs.S_DOCVID.readOnly,
							control: objs.S_DOCVID,
							contextSearch: objs.S_DOCVID.contextSearch
						},
						{
							ok: function(value) {
								objs.S_DOCVID.setValue(value);
								if (value.length) {
									me.DocVidExt = value[0].data.TEMP_EXT;
									objs.TYPE.setFilterTypes(value[0].data.TYPE);
								}
							}
						});
					}
				}),
				objs.S_WORK = Ext.create('Keysystems.Controls.Dict.Edit', {
					fieldLabel: 'Виды работ',
					labelWidth: me.labelWidth,
					mode: 'MULTI',
					handler: function() {
						dictFunc({
							mode: 'MULTI',
							parentView: objs.view,
							whereArgs: me.workWhereArgs,
							selectLinks: objs.S_WORK.getValue(),
							code: dnl.S_WORK,
							readOnly: objs.S_WORK.readOnly,
							control: objs.S_WORK,
							contextSearch: objs.S_WORK.contextSearch
						}, { ok: function(value) { objs.S_WORK.setValue(value); } });
					}
				}),
				objs.TYPE = Ext.create('Keysystems.Controls.DocVid.Type', {
					labelWidth: me.labelWidth,
					inOutChange: Ext.emptyFn
				}),
				Ext.create('Ext.form.FieldContainer', {
					fieldLabel: 'Ответственный',
					labelWidth: me.labelWidth,
					layout: 'hbox',
					items: [
						objs.S_PERSON = Ext.create('Keysystems.Controls.Dict.Edit', {
							flex: 1,
							code: dnl.S_PERSON,
							handler: function() {
								dictFunc({
									mode: 'SINGLE',
									parentView: objs.view,
									whereArgs: {
										SOrgs: { value: JSON.stringify([window.user.org.data.LINK]), type: 'List_int' }
									},
									selectLinks: objs.S_PERSON.getValue(),
									code: dnl.S_PERSON,
									readOnly: objs.S_PERSON.readOnly,
									control: objs.S_PERSON,
									contextSearch: objs.S_PERSON.contextSearch
								}, {
									ok: function(value) {
										objs.S_PERSON.setValue(value);
									}
								});
							}
						}),
						objs.PERSONFORMULA = Ext.create('Keysystems.Controls.Formula.Edit', {
							flex: 1,
							hidden: true,
							ksAllowEmpty: true
						}),
						objs.FORMULA = Ext.create('Ext.form.field.Checkbox', {
							boxLabel: 'Формула',
							checked: false,
							padding: '0 0 0 10',
							listeners: {
								change: function(th1, newValue) {
									objs.S_PERSON.setVisible(!newValue);
									objs.PERSONFORMULA.setVisible(newValue);
								}
							}
						})
					]
				}),
				objs.DTMASK = Ext.create('Keysystems.Controls.Formula.Edit', {
					fieldLabel: 'Автозаполнение даты',
					labelWidth: me.labelWidth,
				}),
				Ext.create('Ext.form.FieldContainer', {
					layout: 'hbox',
					items: [
						objs.DTENDMASK = Ext.create('Keysystems.Controls.Formula.Edit', {
							fieldLabel: 'Автозаполнение срока',
							labelWidth: me.labelWidth,
							flex: 1,
						}),
						objs.ENDWARN = Ext.create('Ext.form.field.Number', {
							fieldLabel: 'Предупреждать за дн',
							minValue: 0,
							allowExponential: false,
							padding: '0 0 0 10',
							width: 225,
							labelWidth: me.labelWidth
						})
					]
				}),
				Ext.create('Ext.form.FieldContainer', {
					layout: 'hbox',
					items: [
						objs.DURATION = Ext.create('Ext.form.field.Number', {
							fieldLabel: 'Длительность дн.',
							labelWidth: me.labelWidth,
							minValue: 1,
							allowExponential: false,
							width: 300,
							value: 1
						}),
						Ext.create('Ext.form.FieldContainer', { flex: 1 }),
						objs.GROUP = Ext.create('Ext.form.field.Number', {
							minValue: 0,
							maxValue: 255,
							allowExponential: false,
							fieldLabel: 'Группа',
							labelWidth: me.labelWidth,
							hidden: true,
							width: 225,
							listeners: {
								change: function(field, value) {
									if (parseInt(value, 10) > 255) {
										field.setValue(255);
									}
								}
							}
						})
					]
				}),
				Ext.create('Ext.form.FieldContainer', {
					layout: 'hbox',
					padding: '0 0 0 155',
					items: [
						objs.INITIAL = Ext.create('Ext.form.field.Checkbox', {
							boxLabel: 'инициируюший',
							checked: false,
							width: 150,
							listeners: { change: function(th1, newValue) { objs.GROUP.setVisible(newValue); } }
						}),
						objs.OPTIONAL = Ext.create('Ext.form.field.Checkbox', {
							boxLabel: 'необязательный',
							width: 150,
							checked: false
						}),
						objs.AUTODO = Ext.create('Ext.form.field.Checkbox', {
							boxLabel: 'автоисполнение',
							width: 150,
							checked: false
						})
					]
				}),
				objs.AUTONAR = Ext.create('Ext.form.field.Checkbox', {
					//Отображение этого бокса зависит от настроек пользователя.
					//Пока настроек нет прячу;
					checked: true,
					padding: '0 0 0 155',
					boxLabel: 'отмечать нарушения'
				}),
				Ext.create('Ext.form.FieldContainer', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Подписывает',
					layout: { type: 'hbox', align: 'stretch' },
					items: [
						objs.AUTOSIGN = Ext.create('Keysystems.Controls.ComboBoxExtra', {
							editable: false,
							value: null,
							flex: 1,
							store: Ext.create('Ext.data.Store', {
								fields: CBDataLib.getFields(),
								data: CBDataLib.get('AutoSignMethod', 1),
								proxy: 'memory'
							}),
							displayField: CBDataLib.displayField,
							valueField: CBDataLib.valueField
						}),
						objs.AUTOSIGNFORMULA = Ext.create('Keysystems.Controls.Formula.Edit', {
							flex: 1,
							hidden: true,
							ksAllowEmpty: true
						}),
						objs.AUTSIGNFORM = Ext.create('Ext.form.field.Checkbox', {
							boxLabel: 'Формула',
							checked: false,
							padding: '0 0 0 10',
							listeners: {
								change: function(th1, v) {
									objs.AUTOSIGN.setVisible(!v);
									objs.AUTOSIGNFORMULA.setVisible(v);
								}
							}
						})
					]
				}),
				me.sksc('AUTOSIGNDOLGS', Ext.create('Keysystems.Controls.ComboBoxExtra', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Должности для подписания',
					multiSelect: true,
					editable: false,
					value: null,
					store: CBDataLib.getStore(CBDataLib.get('AutoSignMethod', 1)),
					displayField: CBDataLib.displayField,
					valueField: CBDataLib.valueField
				})),
				objs.NOTIF_EMAIL = Ext.create('Ext.form.field.Checkbox', {
					fieldLabel: 'Уведомлять по email',
					labelWidth: me.labelWidth,
					checked: false,
					listeners: { change: function(th1, v) { objs.allTab.changeTab(me.getTab('Mail'), v); } }
				})
			]
		});
	},

	//конструктор таба Корреспондент
	createTabCorr: function() {
		var me = this,
			objs = me.objs,
			arr = [
				{
					key: 'CORR_ORG',
					name: 'Организация',
					code: dnl.S_ORG,
					ok: function() { me.set_CORR_Enable(); },
					setValue: function() {
						me.objs.CORR_OTDEL.setValue();
						me.objs.CORR_PERSON.setValue();
					}
				},
				{
					key: 'CORR_OTDEL',
					name: 'Подразделение',
					code: dnl.S_OTDEL,
					disabled: true,
					getSOrg: function() { return objs.CORR_ORG.getLink(); },
					initWhereArgs: function() {
						return {
							SOrgs: { value: objs.CORR_ORG.getLinks(1), type: 'List_int' },
							HasFilterOnLoad: { value: 'False', type: 'bool' }
						};
					}
				},
				{
					key: 'CORR_PERSON',
					name: 'Сотрудник',
					code: dnl.S_PERSON,
					disabled: true,
					initWhereArgs: function() {
						return {
							HasFilterOnLoad: { value: 'False', type: 'bool' },
							SOrgs: { value: objs.CORR_ORG.getLinks(1), type: 'List_int' },
							SOtdel: { value: objs.CORR_OTDEL.getLinks(1), type: 'List_int' }
						};
					}
				}
			],
			items = [
				Ext.create('Ext.form.FieldContainer', {
					labelWidth: me.labelWidth,
					layout: 'hbox',
					items: [
						objs.AUTOCORR = Ext.create('Keysystems.Controls.ComboBoxExtra', {
							fieldLabel: 'Автозаполнение',
							labelWidth: me.labelWidth,
							editable: false,
							value: null,
							store: Ext.create('Ext.data.Store', {
								fields: CBDataLib.getFields(),
								data: CBDataLib.get('AutoCorrMethod', 1),
								proxy: 'memory'
							}),
							displayField: CBDataLib.displayField,
							valueField: CBDataLib.valueField,
							flex: 5,
							listeners: { change: function(th1, newValue) { me.set_CORR_Enable(newValue === null); } }
						}),
						objs.DIRECTORC = Ext.create('Ext.form.field.Checkbox', {
							boxLabel: ' Руководитель',
							padding: '0 0 0 10',
							flex: 1,
							listeners: { change: function() { me.set_CORR_Enable(); } }
						})
					]
				})
			];

		Ext.each(arr, function(el) {
			items.push(objs[el.key] = Ext.create('Keysystems.Controls.Dict.Edit', {
				labelWidth: me.labelWidth,
				fieldLabel: el.name,
				disabled: el.disabled,
				code: el.code,
				handler: function() {
					dictFunc({
						mode: 'SINGL',
						parentView: objs.view,
						initWhereArgs: el.initWhereArgs,
						getSOrg: el.getSOrg,
						selectLinks: objs[el.key].getValue(),
						readOnly: objs[el.key].readOnly,
						code: el.code,
						control: objs[el.key],
						contextSearch: objs[el.key].contextSearch
					}, {
						ok: function(value) {
							if (el.setValue) el.setValue();
							objs[el.key].setValue(value);
							if (el.ok) el.ok(value);
						}
					});
				}
			}));
		});

		return objs.tabCorr = Ext.create('Ext.panel.Panel', {
			title: 'Корреспондент',
			bodyPadding: 10,
			border: 0,
			layout: { type: 'vbox', align: 'stretch' },
			items: items
		});
	},

	//конструктор таба Email
	createTabMail: function() {
		var me = this,
			objs = me.objs,
			items = [
				objs.EMAIL = Ext.create('Keysystems.Controls.Formula.Edit', {
					fieldLabel: 'Email',
					labelWidth: me.labelWidth,
					IsMask: true
				}),
				Ext.create('Ext.form.FieldContainer', {
					layout: 'hbox',
					labelWidth: me.labelWidth,
					fieldLabel: 'Пользователи',
					items: [
						objs.MAILUSERS = Ext.create('Keysystems.Controls.Dict.Edit', {
							mode: 'MULTI',
							flex: 1,
							handler: function() {
								dictFunc({
									mode: 'MULTI',
									parentView: objs.view,
									whereArgs: {
										IncludeGroups: { value: 'False', type: 'bool' },
										MarkBusy: { value: 'True', type: 'bool' }
									},
									selectLinks: objs.MAILUSERS.getValue(),
									code: dnl.S_LOGIN,
									readOnly: objs.MAILUSERS.readOnly
								},
								{ ok: function(value) { objs.MAILUSERS.setValue(value); } });
							}
						}),
						objs.USERFORMULA = Ext.create('Keysystems.Controls.Formula.Edit', {
							flex: 1,
							hidden: true
						}),
						objs.chbUsers = Ext.create('Ext.form.field.Checkbox', {
							boxLabel: 'Формула',
							checked: false,
							padding: '0 0 0 10',
							listeners: {
								change: function(th1, v) {
									objs.MAILUSERS.setVisible(!v);
									objs.USERFORMULA.setVisible(v);
								}
							}
						})
					]}),
				objs.TEMA = Ext.create('Keysystems.Controls.Formula.Edit', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Тема',
					IsMask: true
				}),
				objs.BODY = Ext.create('Keysystems.Controls.Formula.Edit', {
					fieldLabel: 'Текс письма',
					labelWidth: me.labelWidth,
					flex: 1,
					IsMask: true
				}),
				Ext.create('Ext.form.FieldContainer', {
					layout: 'hbox',
					labelWidth: me.labelWidth,
					fieldLabel: 'Срок отправки (дн)',
					items: [
						objs.SENDWHEN = Ext.create('Ext.form.field.ComboBox', {
							editable: false,
							padding: '0 10 0 0',
							width: 70,
							value: 0,
							queryMode: 'local',
							store: Ext.create('Ext.data.Store', {
								fields: CBDataLib.getFields(),
								data: CBDataLib.get('WhenEnum'),
								proxy: 'memory'
							}),
							displayField: CBDataLib.displayField,
							valueField: CBDataLib.valueField
						}),
						objs.CNTDAYS = Ext.create('Ext.form.field.Number', {
							padding: '0 10 0 0',
							flex: 1,
							minValue: 0,
							allowExponential: false
						}),
						objs.NDAYS = Ext.create('Ext.form.field.ComboBox', {
							editable: false,
							padding: '0 10 0 0',
							value: 0,
							queryMode: 'local',
							displayField: CBDataLib.displayField,
							valueField: CBDataLib.valueField,
							store: Ext.create('Ext.data.Store', {
								fields: CBDataLib.getFields(),
								data: CBDataLib.get('DayType'),
								proxy: 'memory'
							})
						}),
						objs.CNTDAYSFORMULA = Ext.create('Keysystems.Controls.Formula.Edit', {
							flex: 1,
							hidden: true
						}),
						objs.EMAILFORMULA = Ext.create('Ext.form.field.Checkbox', {
							boxLabel: 'Формула',
							checked: false,
							padding: '0 0 0 10',
							listeners: {
								change: function(th1, v) {
									objs.SENDWHEN.setVisible(!v);
									objs.CNTDAYS.setVisible(!v);
									objs.NDAYS.setVisible(!v);
									objs.CNTDAYSFORMULA.setVisible(v);
								}
							}
						})
					]
				}),
				objs.SENDDIRECT = Ext.create('Ext.form.field.Checkbox', {
					boxLabel: 'отправлять автоматически',
					checked: false,
					padding: '0 0 0 ' + (me.labelWidth + 5),
				})
			];

		return objs.tabMail = Ext.create('Ext.panel.Panel', {
			title: 'Email',
			bodyPadding: 10,
			layout: { type: 'vbox', align: 'stretch' },
			items: items
		});
	},

	//конфигурация основого окна
	viewCfg: function() {
		var result = this.callParent(arguments);
		result.resizable = true;
		result.maximizable = true;
		return result;
	},

	loadData: function() {
		var me = this,
			objs = me.objs,
			data = me.data.data;

		objs.S_WORK.setValue(me.work);
		objs.TASKDOCC.setValue(me.cTasks);
		objs.TASKDOCP.setValue(me.pTasks);

		objs.S_DOCVID.setValue({ LINK: data.S_DOCVID, CODE: data.S_DOCVID_CODE, NAME: data.S_DOCVID_NAME, TYPE: data.S_DOCVID_TYPE });
		objs.TYPE.setFilterTypes(data.S_DOCVID_TYPE || 0);

		if (data.PERSONFORMULA) {
			objs.FORMULA.setValue(true);
			objs.PERSONFORMULA.setValue(data.PERSONFORMULA);
		} else {
			objs.FORMULA.setValue(false);
			objs.S_PERSON.setValue(data.personData);
		}

		if (data.AUTOSIGNFORMULA) {
			objs.AUTSIGNFORM.setValue(true);
			objs.AUTOSIGNFORMULA.setValue(data.AUTOSIGNFORMULA);
		} else {
			objs.AUTSIGNFORM.setValue(false);
			objs.AUTOSIGN.setValue(data.AUTOSIGN);
		}

		var asd = [];
		for (var k in miscTypes.AutoSignMethod) if (data.AUTOSIGNDOLGS & k) asd.push(k * 1);
		me.gksc('AUTOSIGNDOLGS').setValue(asd);

		Ext.each(me._arrGeneral, function(key) { objs[key].setValue(data[key]); });

		objs.DURATION.setValue(objs.DURATION.getValue() || 1);

		objs.AUTONAR.setVisible(me.isAutoNar);

		if (data.INITIAL) {
			objs.GROUP.setValue(me.nullSec.XOR);
		}

		//корреспондент
		objs.allTab.changeTab(me.getTab('Corr'), true);

		objs.AUTOCORR.setValue(data.AUTOCORR || data.AUTOCORR === 0 ? data.AUTOCORR : null);
		objs.DIRECTORC.setValue(data.DIRECTORC);
		objs.CORR_ORG.setValue({ LINK: data.S_ORGC, CODE: data.S_ORGC_CODE, NAME: data.S_ORGC_NAME });
		objs.CORR_OTDEL.setValue({ LINK: data.S_OTDELC, CODE: data.S_OTDELC_CODE, NAME: data.S_OTDELC_NAME });
		objs.CORR_PERSON.setValue(data.personCData);

		me.set_CORR_Enable();

		//уведомлять по эмейл
		if (data.mail) {
			objs.NOTIF_EMAIL.setValue(true);

			Ext.each(me._arrMail, function(key) { objs[key].setValue(data.mail[key]); });

			objs.MAILUSERS.setValue(data.mail.users);

			if (data.mail.USERFORMULA) {
				objs.chbUsers.setValue(true);
				objs.USERFORMULA.setValue(data.mail.USERFORMULA);
			}

			if (data.mail.CNTDAYSFORMULA) {
				objs.EMAILFORMULA.setValue(true);
				objs.CNTDAYSFORMULA.setValue(data.mail.CNTDAYSFORMULA);
			}
		}

		me.callParent(arguments);
	},
	dataCollector: function() {
		var me = this,
			objs = me.objs,
			data = me.callParent(arguments);

		data.LINK = data.link;

		if (objs.INITIAL.getValue() && objs.GROUP.getValue()) data.GROUP = objs.GROUP.getValue();

		Ext.each(me._arrSave, function(key) { data[key] = objs[key].getValue(); });
		Ext.each(me._arrGeneral, function(key) { data[key] = objs[key].getValue(); });

		var asd = 0;
		Ext.each(me.gksc('AUTOSIGNDOLGS').getValue(), function(v) { asd += v; });
		data.AUTOSIGNDOLGS = asd;

		if (!objs.TYPE.getCorrDisabled()) {
			Ext.each(me._arrCorrSave, function(key) { data[key] = objs[key].getValue(); });
		}

		if (objs.NOTIF_EMAIL.getValue()) {
			data.mail = {
				LINK: me.data.data.mail ? me.data.data.mail.LINK : 0,
				users: objs.MAILUSERS.getValue()
			};

			Ext.each(me._arrMail, function(key) { data.mail[key] = objs[key].getValue(); });

			data.mail.USERFORMULA = objs.USERFORMULA.getValue();
		
			data.mail.CNTDAYSFORMULA = objs.CNTDAYSFORMULA.getValue();
		}
		return data;
	},
	set_CORR_Enable: function() {
		var me = this,
			objs = me.objs,
			v = objs.AUTOCORR.getValue(),
			org = true,
			otdel = true,
			person = true;
		if (v === null) {
			org = false;
			if (!objs.CORR_ORG.isEmpty()) {
				otdel = false;
				if (!objs.DIRECTORC.getValue()) person = false;
			}
		}
		objs.CORR_ORG.setDisabled(org);
		objs.CORR_OTDEL.setDisabled(otdel);
		objs.CORR_PERSON.setDisabled(person);
	},
	isFilled: function() {
		var me = this,
			objs = me.objs;
		
		let res = true;
		if (objs.S_DOCVID.isEmpty()) {
			me.addToInvalidControls(objs.S_DOCVID);
			res = false;
		}
		if (objs.S_WORK.isEmpty()) {
			me.addToInvalidControls(objs.S_WORK, {optional: true});
			me.warningMessages.push(KS.L10n.Не_заполнены_виды_работ);
		}
		if (me.objs.FORMULA.getValue() && !me.objs.PERSONFORMULA.getValue()) {
			res = false;
			me.addToInvalidControls(me.objs.PERSONFORMULA, {title: 'Ответственный'});
		}
		if (me.objs.AUTSIGNFORM.getValue() && !me.objs.AUTOSIGNFORMULA.getValue()) {
			res = false;
			me.addToInvalidControls(me.objs.AUTOSIGNFORMULA, {title: 'Подписывает'});
		}
		return res;
	},

	taskDocDictFunc: function(key) {
		var me = this,
			objs = me.objs,
			limitLinks = [];

		dictFunc({
			mode: 'MULTI',
			parentView: objs.view,
			selectLinks: objs[key].getValue(),
			code: dnl.S_TASKDOC,
			readOnly: objs[key].readOnly,
			control: objs[key],
			contextSearch: objs[key].contextSearch,
			initWhereArgs: function() {
				let links = [],
					tdData = me.getTaskDocData(objs.link);
				
				Ext.each(tdData, d => {
					links.push(d.LINK);
				});
				
				return {
					InLinksOnly: {value: 'True', type: 'bool'},
					InLinks: {value: JSON.stringify(links), type: 'List_int'}
				};
			}
		}, {
			ok: function(value) { objs[key].setValue(value); },
			getData: function(endFunc, commonData) {
				let contextLinks = [];
				if (commonData.data && commonData.data.data.length) {
					Ext.each(commonData.data.data, d => {
						contextLinks.push(d.LINK);
					});

					limitLinks = contextLinks;
				}
				me.getTaskDocShema(function(shema) {
					let tdData = me.getTaskDocData(objs.link),
						data = contextLinks.length 
							? tdData.filter(d => { return contextLinks.indexOf(d.LINK) !== -1; }) 
							: tdData;
					
					shema = JSON.parse(JSON.stringify(shema));
					shema.data = { data: data, total: data.length };
					endFunc(shema);
				});
			},
			refresh: function(endFunc) {
				let tdData = me.getTaskDocData(objs.link),
					data = limitLinks && limitLinks.length
						? tdData.filter(d => { return limitLinks.indexOf(d.LINK) !== -1; })
						: tdData;
				
				endFunc({ data: data, total: data.length });
			}
		});
	},

	createListeners: function() {
		var me = this;

		me.code = me.code || dnl.S_TASK;
	},

	profileListeners: [{ name: 'view', method: 'FormParam' }],

	getExtra: function(callBack) { if (callBack) callBack(); }
})