﻿Ext.define('Keysystems.STask.Edit', {
	extend: 'Keysystems.Base.Edit',
	secLink: -1,
	mailLink: -1,
	taskGanttLink: -1,
	secText: 'связь',
	viewPreset: 'Keysystems.Gantt.Tasks',
	//profilePrefix: 'Task',
	_arr: ['LINK', 'S_TASK', 'S_DOCVID', 'S_PERSON', 'TYPE', 'TEMP_EXT', 'INITIAL', 'OPTIONAL', 'DURATION', 'AUTOCORR', 'DIRECTORC', 'S_ORGC', 'S_OTDELC', 'S_PERSONC', 'AUTODO', 'AUTOSIGN', 'AUTOSIGNFORMULA', 'AUTOSIGNDOLGS', 'AUTONAR', 'PERSONFORMULA', 'DTMASK', 'DTENDMASK', 'ENDWARN', 'GROUP'],

	viewMinSize: [600, 700],
	bodyPadding: 0,

	createItems: function() {
		var me = this,
			objs = me.objs,
			items = [
				Ext.create('Ext.panel.Panel', {
					layout: { type: 'vbox', align: 'stretch' },
					bodyPadding: 10,
					border: 0,
					items: [
						me.createCodeEdit({ maxLength: 10, enforceMaxLength: true, maxWidth: 150 + me.labelWidth }),
						me.createNameEdit({ maxLength: 100, enforceMaxLength: true }),
						Ext.create('Ext.form.FieldContainer', {
							layout: 'hbox',
							fieldLabel: 'Ответственный сотрудник',
							labelWidth: me.labelWidth,
							padding: '-8 0 5 0',
							items: [
								objs.S_PERSON = Ext.create('Keysystems.Controls.Dict.Edit', {
									flex: 1,
									code: dnl.S_PERSON,
									handler: function() {
										var d = new Date().toDateString();
										dictFunc({
												mode: 'SINGLE',
												parentView: objs.view,
												readOnly: objs.S_PERSON.readOnly,
												whereArgs: {
													SOrgs: { value: JSON.stringify([window.user.org.data.LINK]), type: 'List_int' },
													DH1: { value: d, type: 'Date' },
													DH2: { value: d, type: 'Date' }
												},
												selectLinks: objs.S_PERSON.getValue(),
												code: dnl.S_PERSON,
												control: objs.S_PERSON,
												contextSearch: objs.S_PERSON.contextSearch
											},
											{
												ok: function(value) {
													objs.S_PERSON.setValue(value);
												}
											});
									}
								}),
								objs.PERSONFORMULA = Ext.create('Keysystems.Controls.Formula.Edit', {
									maxLength: 500,
									enforceMaxLength: true,
									padding: '0 0 0 5',
									flex: 1
								})
							]
						}),
						objs.S_WORK = Ext.create('Keysystems.Controls.Dict.Edit', {
							fieldLabel: 'Виды работ',
							labelWidth: me.labelWidth,
							width: me.width,
							mode: 'MULTI',
							handler: function() {
								dictFunc({
										mode: 'MULTI',
										parentView: objs.view,
										selectLinks: objs.S_WORK.getValue(),
										code: dnl.S_WORK,
										readOnly: objs.S_WORK.readOnly,
										control: objs.S_WORK,
										contextSearch: objs.S_WORK.contextSearch
									},
									{ ok: function(value) { objs.S_WORK.setValue(value); } });
							}
						}),
						objs.PREV = Ext.create('Keysystems.Controls.Dict.Edit', {
							fieldLabel: 'Предыдущий(е)',
							labelWidth: me.labelWidth,
							width: me.width,
							mode: 'MULTI',
							handler: function() {
								dictFunc({
									mode: 'MULTI',
									parentView: objs.view,
									whereArgs: {
										NotInLinks: { value: JSON.stringify([objs.link]), type: 'List_int' }
									},
									selectLinks: objs.PREV.getValue(),
									code: dnl.S_TASK,
									readOnly: objs.PREV.readOnly,
									control: objs.PREV,
									contextSearch: objs.PREV.contextSearch
								}, { ok: function(value) { objs.PREV.setValue(value); } });
							}
						}),
						objs.BEGINFORMULA = Ext.create('Keysystems.Controls.Formula.Edit', {
							maxLength: 500,
							enforceMaxLength: true,
							labelWidth: me.labelWidth,
							fieldLabel: 'Начало'
						}),
						Ext.create('Ext.form.FieldContainer', {
							layout: 'hbox',
							items: [
								objs.BEGINIGNOREDOC = Ext.create('Ext.form.field.Checkbox', {
									boxLabel: 'не учитывать документы при расчете даты начала',
									checked: false,
									flex: 1,
									padding: '0 0 0 155'
								}),
								objs.BEGINWARN = Ext.create('Ext.form.field.Number', {
									fieldLabel: 'Предупреждать за дн.',
									width: 250,
									labelWidth: me.labelWidth,
									minValue: 0
								})
							]
						}),
						Ext.create('Ext.form.FieldContainer', {
							layout: 'hbox',
							items: [
								objs.DURATION = Ext.create('Ext.form.field.Number', {
									fieldLabel: 'Длительность дн.',
									ksAllowEmpty: true,
									labelWidth: me.labelWidth,
									minValue: 0
								}),
								objs.NDAYS = Ext.create('Ext.form.field.ComboBox', {
									editable: false,
									padding: '0 0 0 5',
									value: 0,
									queryMode: 'local',
									displayField: CBDataLib.displayField,
									valueField: CBDataLib.valueField,
									store: Ext.create('Ext.data.Store', {
										fields: CBDataLib.getFields(),
										data: CBDataLib.get('DayType'),
										proxy: 'memory'
									})
								})
							]
						}),
						objs.ENDFORMULA = Ext.create('Keysystems.Controls.Formula.Edit', {
							maxLength: 500,
							enforceMaxLength: true,
							fieldLabel: 'Завершение',
							width: me.width,
							labelWidth: me.labelWidth
						}),
						Ext.create('Ext.form.FieldContainer', {
							layout: 'hbox',
							items: [
								objs.ENDIGNOREDOC = Ext.create('Ext.form.field.Checkbox', {
									boxLabel: 'не учитывать документы при расчете даты завершения',
									checked: false,
									flex: 1,
									padding: '0 0 0 155'
								}),
								objs.ENDWARN = Ext.create('Ext.form.field.Number', {
									fieldLabel: 'Предупреждать за дн.',
									labelWidth: me.labelWidth,
									width: 250,
									minValue: 0
								})
							]
						}),
						objs.NEXT = Ext.create('Keysystems.Controls.Dict.Edit', {
							fieldLabel: 'Следующий(е)',
							labelWidth: me.labelWidth,
							width: me.width,
							mode: 'MULTI',
							handler: function() {
								dictFunc({
									mode: 'MULTI',
									parentView: objs.view,
									whereArgs: {
										NotInLinks: { value: JSON.stringify([objs.link]), type: 'List_int' }
									},
									selectLinks: objs.NEXT.getValue(),
									code: dnl.S_TASK,
									readOnly: objs.PREV.readOnly,
									control: objs.NEXT,
									contextSearch: objs.NEXT.contextSearch
								}, { ok: function(value) { objs.NEXT.setValue(value); } });
							}
						}),
						objs.DH = Ext.create('Keysystems.Controls.PeriodEdit', {
							labelWidth: me.labelWidth,
							maxWidth: 400
						})
					]
				}),
				objs.Gantt = me.createGanttPanel()
			];

		return objs.items = items;
	},

	//конструктор гантовской панели
	createGanttPanel: function() {
		var me = this;
		return Ext.create('Keysystems.Panel.Gantt', {
			flex: 1,
			width: 400,
			height: 250,
			dependencyStore: Ext.create('Gnt.data.DependencyStore', { model: 'TaskSeqModel', proxy: 'memory' }),
			taskStore: Ext.create('Gnt.data.TaskStore', { model: 'TaskTaskModel', proxy: 'memory' }),
			leftLabelField: 'NAME',
			zoomLevels: ksGantt.zoomLevels(me.viewPreset),
			viewPreset: me.viewPreset,
			editFn: function(f, value, callBack, parentView) { me.editGntTask(f, value, callBack, parentView); },
			removeFn: function(recs, parentView) { me.removeGntTask(recs, parentView); },
			editSeq: function(from, to) { me.editSeq(from, to); },
			showSeqContextMenu: function(rec, e) {
				if (!me.seqContextMenu) me.createSecContextMenu();
				me.seqContextMenu.setActivRecord(rec);
				me.seqContextMenu.showAt(e.getXY());
			}
		});
	},

	//конструктор контекстного меню связей
	createSecContextMenu: function() {
		var me = this;
		return me.seqContextMenu = Ext.create('Ext.menu.Menu', {
			setActivRecord: function(rec) { this._rec = rec; },
			items: [
				Ext.create('Ext.Action', {
					text: wmc.get('Edit', me.secText),
					iconCls: 'x_btn_edit',
					handler: function() {
						if (me.seqContextMenu._rec) {
							me.editSeq(me.seqContextMenu._rec.data.TASKDOCP, me.seqContextMenu._rec.data.TASKDOCC);
						}
					}
				}),
				Ext.create('Ext.Action', {
					text: wmc.get('Delete', me.secText),
					iconCls: 'x_btn_delete',
					handler: function() {
						selectDialogShow(wmc.get('Deleting'), wmc.getQuestion('Delete', me.secText), function() {
							if (me.seqContextMenu._rec) {
								me.deleteSeq(me.seqContextMenu._rec.data.TASKDOCP, me.seqContextMenu._rec.data.TASKDOCC);
							}
						});
					}
				})
			]
		});
	},

	//конфигурация основого окна
	viewCfg: function() {
		var result = this.callParent(arguments);
		result.resizable = true;
		result.maximizable = true;
		result.minWidth = 750;
		result.minHeight = 500;
		result.width = this.width;
		return result;
	},

	getExtra: function(callBack, link) {
		var me = this,
			objs = me.objs;

		me.baseGetExtra({ link: link }, function(value) {
			objs.isAutoNar = value.isAutoNar;

			me.setCodeValue(value.row.CODE);
			objs.NAME.setValue(value.row.NAME);
			objs.PERSONFORMULA.setValue(value.row.PERSONFORMULA);
			objs.DURATION.setValue(value.row.DURATION);
			objs.NDAYS.setValue(value.row.NDAYS);
			objs.BEGINFORMULA.setValue(value.row.BEGINFORMULA);
			objs.BEGINWARN.setValue(value.row.BEGINWARN);
			objs.BEGINIGNOREDOC.setValue(value.row.BEGINIGNOREDOC);
			objs.ENDFORMULA.setValue(value.row.ENDFORMULA);
			objs.ENDWARN.setValue(value.row.ENDWARN);
			objs.ENDIGNOREDOC.setValue(value.row.ENDIGNOREDOC);
			objs.DH.setValue(value.row.DH1 ? new Date(value.row.DH1) : longPeriod.begin, value.row.DH2 ? new Date(value.row.DH2) : longPeriod.end);

			objs.S_PERSON.setValue(value.sPerson);
			objs.S_WORK.setValue(value.sWork);
			objs.PREV.setValue(value.prev);
			objs.NEXT.setValue(value.next);

			if (value.ganttModel) {
				objs.adaptedData = value.ganttModel;
				objs.Gantt.setGanttData(value.ganttModel);
			};

			objs.tTaskdocWork = value.tTaskdocWork;

			if (callBack) callBack();
		});
	},

	editSeq: function(from, to) {
		var me = this,
			ganttModel = me.objs.adaptedData,
			tasks = ganttModel.tasks,
			rec = false,
			f = 'new';

		var pos = ArrayLib.find(tasks, ['LINK'], to);
		if (pos === -1) return;
		var taskTo = tasks[pos];
		pos = ArrayLib.find(tasks, ['LINK'], from);
		if (pos === -1) return;
		var taskFrom = tasks[pos];

		Ext.each(ganttModel.sequence, function(s) {
			rec = s.TASKDOCC === to && s.TASKDOCP === from;
			if (rec) {
				rec = s;
				return false;
			}
			return true;
		});

		if (rec) {
			f = 'edit';
		} else {
			rec = {
				TASKDOCP: from,
				TASKDOCC: to,
				TYPE: taskTo.TYPE
			};
		}

		Ext.create('Keysystems.STask.Edit.Doc', {
			f: f,
			data: { data: rec },
			S_DOCVID_TYPE: taskTo.S_DOCVID_TYPE,
			baseSaveData: function(sec, callBack) {
				this.oldData = JSON.stringify(sec);
				sec.TASKDOCP = rec.TASKDOCP,
					sec.TASKDOCC = rec.TASKDOCC,
					pos = -1;
				if (rec.LINK) pos = ArrayLib.find(ganttModel.sequence, ['LINK'], rec.LINK);
				if (pos === -1) {
					rec.LINK = me.secLink--;
					ganttModel.sequence.push(sec);
				} else {
					ganttModel.sequence[pos] = sec;
				}
				sec.LINK = rec.LINK;
				me.objs.Gantt.setGanttData(ganttModel);

				this.f = 'edit';
				
				if (callBack) callBack();
			},
			from: taskFrom.NAME,
			to: taskTo.NAME
		});
	},

	deleteSeq: function(from, to) {
		var objs = this.objs,
			sequence = objs.adaptedData.sequence;

		Ext.each(sequence, function(s) {
			if (s.TASKDOCC === to && s.TASKDOCP === from) {
				ArrayLib.remove(sequence, s);
				return false;
			}
			return true;
		});

		objs.Gantt.setGanttData(objs.adaptedData);
	},

	_setDictGnt: function (rec, value, colName) {
		if (!value) return;
		var link = 0,
			code = '',
			name = '';

		if (value.length) {
			var val = value[0].data ? value[0].data : value[0];
			link = val.LINK;
			code = val.CODE;
			name = val.NAME;
		}

		rec[colName] = link;
		rec[colName + '_CODE'] = code;
		rec[colName + '_NAME'] = name;
	},

	editGntTask: function(f, rec, callBack, parentView) {
		var me = this,
			objs = me.objs,
			link = f === 'new' ? 0 : rec.data.LINK,
			tasks = objs.adaptedData.tasks,
			data = ArrayLib.filter(tasks, ['LINK'], link)[0];

		if (f === 'copy') data = JSON.parse(JSON.stringify(data));

		if (!data) data = { child: [], parent: [] };

		let cTasks = Ext.Array.filter(tasks, function(t) { return data.child.indexOf(t.LINK) !== -1; }),
			nullSec = ArrayLib.filter(ArrayLib.filter(objs.adaptedData.sequence, ['TASKDOCC'], link), ['TASKDOCP'], null)[0] || {},
			pTasks;
		if (f === 'new') {
			let sels = objs.Gantt.selModel.getSelected();
			pTasks = sels.items.length ? sels.items[0] : [];
		}
		else{
			pTasks =  Ext.Array.filter(tasks, function(t) { return data.parent.indexOf(t.LINK) !== -1; })
		}
		return Ext.create('Keysystems.STask.Edit.Gantt', {
			f: f,
			work: objs.tTaskdocWork[link] || objs.S_WORK.getValue(),
			workWhereArgs: { InLinks: { value: objs.S_WORK.getLinks(1), type: 'List_int' } },
			data: { data: data },
			readOnly: me.readOnly,
			cTasks: cTasks,
			pTasks: pTasks,
			nullSec: nullSec,
			isAutoNar: objs.isAutoNar,
			saveGanttFunc: function(newTask, closeFunc) { me.saveGanttFunc(f, newTask, closeFunc); },
			endFunc: callBack,
			parentView: parentView,
			getTaskDocShema: function(cb) { me.getTaskDocShema(cb); },
			getTaskDocData: function(l) { return me.getTaskDocData(l); },
			resizeTask: function(duration, tskLink, endFunc) { me.resizeTask(duration, tskLink, endFunc); },
			baseSaveData: function(params, callBack1) {
				if (!params.link) {
					this.objs.link = params.link = data.LINK = me.taskGanttLink--;
					params.LINK = params.link;
					tasks.push(data);
				}
				this.oldData = JSON.stringify(params);

				var arr = ['AUTOCORR', 'AUTODO', 'AUTONAR', 'AUTOSIGN', 'AUTOSIGNFORMULA', 'AUTOSIGNDOLGS', 'DIRECTORC', 'DTENDMASK', 'DTMASK', 'DURATION', 'ENDWARN', 'INITIAL', 'OPTIONAL', 'PERSONFORMULA', 'TYPE'];

				Ext.each(arr, function(key) { data[key] = params[key]; });

				me._setDictGnt(data, params.CORR_ORG, 'S_ORGC');
				me._setDictGnt(data, params.CORR_OTDEL, 'S_OTDELC');
				me._setDictGnt(data, params.CORR_PERSON, 'S_PERSONC');

				var sdv = params.S_DOCVID[0];
				sdv = sdv.data || sdv;
				data.S_DOCVID = sdv.LINK;
				data.S_DOCVID_CODE = sdv.CODE;
				data.S_DOCVID_NAME = sdv.NAME;
				data.S_DOCVID_TYPE = sdv.TYPE;
				data.CODE = sdv.CODE;
				data.NAME = sdv.NAME;

				me._setDictGnt(data, params.S_PERSON, 'S_PERSON');

				objs.tTaskdocWork[params.link] = params.S_WORK;

				var taskdocc = ArrayLib.filter(objs.adaptedData.sequence, ['TASKDOCP'], params.link);
				var taskdoccN = params.TASKDOCC.concat();
				Ext.each(taskdocc, function(seq) {
					var find = 0;
					Ext.each(taskdoccN, function(seqN) {
						if ((seqN.data || seqN).LINK == seq.TASKDOCC) {
							find = seqN;
							return false;
						}
						return true;
					});
					if (find) {
						ArrayLib.remove(taskdoccN, find);
					} else {
						ArrayLib.remove(objs.adaptedData.sequence, seq);
					}
				});
				Ext.each(taskdoccN, function(docc) {
					objs.adaptedData.sequence.push({
						TASKDOCP: params.link,
						TASKDOCC: (docc.data || docc).LINK,
						TYPE: (docc.data || docc).TYPE,
						LINK: me.secLink--
					});
				});

				var taskdocp = ArrayLib.filter(objs.adaptedData.sequence, ['TASKDOCC'], params.link),
					taskdocpN = params.TASKDOCP.concat(),
					group = params.INITIAL && params.GROUP,
					pos = ArrayLib.find(taskdocp, ['TASKDOCP'], null);

				nullSec = pos === -1 ? 0 : taskdocp[pos];

				Ext.each(taskdocp, function(seq) {
					var find = 0;
					Ext.each(taskdocpN, function(seqN) {
						if ((seqN.data || seqN).LINK == seq.TASKDOCP) {
							find = seqN;
							return false;
						}
						return true;
					});
					if (find) {
						ArrayLib.remove(taskdocpN, find);
					} else {
						ArrayLib.remove(objs.adaptedData.sequence, seq);
					}
				});
				Ext.each(taskdocpN, function(docp) {
					objs.adaptedData.sequence.push({
						TASKDOCP: (docp.data || docp).LINK,
						TASKDOCC: params.link,
						TYPE: params.TYPE,
						LINK: me.secLink--
					});
				});

				if (group) {
					if (!nullSec) {
						nullSec = {
							AUTODO: false,
							PMUSTBEDONE: false,
							TASKDOCC: params.link,
							TYPE: params.TYPE,
							LINK: me.secLink--
						};
					}
					nullSec.XOR = group;
					objs.adaptedData.sequence.push(nullSec);
				}

				//mail
				pos = ArrayLib.find(objs.adaptedData.mail, ['TASKDOC'], params.link);
				if (params.mail) {
					params.mail.TASKDOC = params.link;
					if (pos === -1) {
						objs.adaptedData.mail.push(params.mail);
					} else {
						objs.adaptedData.mail[pos] = params.mail;
					}
					if (!params.mail.LINK) params.mail.LINK = me.mailLink--;
					data.mail = params.mail;

					var oldMailUsers = ArrayLib.filter(objs.adaptedData.mailUsers, ['TASKDOCMAIL'], params.mail.LINK);

					Ext.each(params.mail.users, function(user) {
						var userLink = (user.data || user).LINK,
							f1 = true;
						Ext.each(objs.adaptedData.users, function(user1) {
							return f1 = (user1.data || user1).LINK != userLink;
						});
						if (f1) objs.adaptedData.users.push(user);

						f1 = ArrayLib.find(oldMailUsers, ['S_USERS'], userLink);
						if (f1 === -1) {
							objs.adaptedData.mailUsers.push({
								TASKDOCMAIL: params.mail.LINK,
								S_USERS: userLink
							});
						} else {
							oldMailUsers.splice(f1, 1);
						}
					});

					ArrayLib.removeList(objs.adaptedData.mailUsers, oldMailUsers);
				} else {
					if (pos !== -1) {
						objs.adaptedData.mail.splice(pos, 1);
						delete data.mail;
					}
				}

				objs.Gantt.setGanttData(objs.adaptedData);

				this.f = 'edit';
				
				QuickMsgs.save();

				if (callBack1) callBack1();
			}
		});
	},

	removeGntTask: function(recs) {
		var objs = this.objs,
			ad = objs.adaptedData,
			tasks = ad.tasks,
			sequence = ad.sequence,
			remList = [];
		Ext.each(recs, function(r) {
			var pos = ArrayLib.find(tasks, ['LINK'], r.get('LINK'));
			if (pos !== -1) {
				remList.push(tasks[pos]);
			}
		});
		var len = remList.length;
		if (len) {
			selectDialogShow(wmc.getQuestion('Delete'), wmc.get('DeleteMessage', len), function() {
				Ext.each(remList, function(rt) {
					ArrayLib.removeList(sequence, ArrayLib.filter(sequence, ['TASKDOCC'], rt.LINK));
					ArrayLib.removeList(sequence, ArrayLib.filter(sequence, ['TASKDOCP'], rt.LINK));
					delete objs.tTaskdocWork[rt.LINK];
				});
				ArrayLib.removeList(tasks, remList);
				objs.Gantt.setGanttData(ad);
			});
		}
	},

	getTaskDocData: function(link) {
		var me = this,
			score = me.tasksScore;

		if (!score) score = me.tasksScore = {};

		if (score[link]) return score[link];

		return score[link] = Ext.Array.filter(me.objs.adaptedData.tasks, function(t) { return t.LINK !== link; });
	},

	getTaskDocShema: function(callBack) {
		var me = this;
		if (me.shemaTaskDoc) {
			callBack(me.shemaTaskDoc);
		} else {
			let params = { needToolbar: true};
			ajaxRequest({
				url: 'STaskDoc/GetShema_A',
				params: { gzipData: JSON.stringify(params) },
				success: function(result) { callBack(me.shemaTaskDoc = result); },
				failure: function() {
					showError(wmc.get('ErrorGetShema'));
					callBack(null);
				}
			});
		}
	},
	dataCollector: function() {
		var me = this,
			objs = me.objs,
			dh = objs.DH.getValue(),
			taskDoc = [];

		Ext.each(objs.adaptedData.tasks, function(t) {
			var e = {};
			Ext.each(me._arr, function(k) { e[k] = t[k]; });
			taskDoc.push(e);
		});

		var tdw = {};
		for (var td in objs.tTaskdocWork) {
			tdw[td] = [];
			Ext.each(objs.tTaskdocWork[td], function(w) { tdw[td].push(w.LINK || w.data.LINK); });
		}

		var mail = [];
		Ext.each(objs.adaptedData.mail, function(m) {
			var nm = {};
			for (var key in m) {
				if (key !== 'users') {
					nm[key] = m[key];
				}
			}
			mail.push(nm);
		});

		var data = me.callParent([false]);
		data.link = objs.link;
		data.code = objs.CODE.getValue();
		data.name = objs.NAME.getValue();
		data.sperson = objs.S_PERSON.getLink();
		data.personformula = objs.PERSONFORMULA.getValue();

		//Должно уходить в таблицу [T_STASK_SWORK]
		data.swork = objs.S_WORK.getLinks(1);

		data.next = objs.NEXT.getLinks(1);
		data.prev = objs.PREV.getLinks(1);

		data.beginformula = objs.BEGINFORMULA.getValue();
		data.beginignoredoc = objs.BEGINIGNOREDOC.getValue();
		data.beginwarn = objs.BEGINWARN.getValue();
		data.duration = objs.DURATION.getValue();
		data.ndays = objs.NDAYS.getValue();
		data.endformula = objs.ENDFORMULA.getValue();
		data.endignoredoc = objs.ENDIGNOREDOC.getValue();
		data.endwarn = objs.ENDWARN.getValue();
		//gantt= objs.Gantt.getValue();
		data.dh1 = dh.dh1.toDateString();
		data.dh2 = dh.dh2.toDateString();
		data.taskDoc = JSON.stringify(taskDoc);
		data.tTaskdocWork = JSON.stringify(tdw);
		data.taskDocSeq = JSON.stringify(Ext.Array.filter(objs.adaptedData.sequence, function(s) {
			var tasks = objs.adaptedData.tasks;
			return !!(ArrayLib.filter(tasks, ['LINK'], s.TASKDOCC)[0] && ArrayLib.filter(tasks, ['LINK'], s.TASKDOCP)[0]);
		}));
		data.mail = JSON.stringify(mail);
		data.mailUsers = JSON.stringify(objs.adaptedData.mailUsers);
		return data;
	},
	profileListeners: [{ name: 'view', method: 'FormParam' }]
});