﻿Ext.define('Keysystems.STask.Edit.Doc', {
	extend: 'Keysystems.Base.Edit',
	title: 'Связь',
	_arr: ['AUTODO', 'COND', 'LEVEL', 'PMUSTBEDONE', 'XOR', 'TYPE'],

	createItems: function() {
		var me = this,
			objs = me.objs,
			items = [
				objs.from = Ext.create('Ext.form.field.Text', {
					labelWidth: me.labelWidth,
					disabled: true,
					disabledCls: '',
					fieldLabel: 'От'
				}),
				objs.to = Ext.create('Ext.form.field.Text', {
					labelWidth: me.labelWidth,
					disabled: true,
					disabledCls: '',
					fieldLabel: 'К'
				}),
				objs.TYPE = Ext.create('Keysystems.Controls.DocVid.Type', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Тип',
					inOutChange: Ext.emptyFn
				}),
				objs.PMUSTBEDONE = Ext.create('Ext.form.field.Checkbox', {
					boxLabel: 'требуется исполнение предыдущего',
					checked: false,
					padding: '0 0 0 155'
				}),
				objs.AUTODO = Ext.create('Ext.form.field.Checkbox', {
					boxLabel: 'автоисполнение предыдущего',
					checked: false,
					padding: '0 0 0 155'
				}),
				objs.COND = Ext.create('Keysystems.Controls.Formula.Edit', {
					parentView: objs.view,
					labelWidth: me.labelWidth,
					width: me.width,
					fieldLabel: 'Условие',
				}),
				Ext.create('Ext.form.FieldContainer', {
					width: me.width,
					labelWidth: me.labelWidth,
					fieldLabel: 'Группа',
					layout: 'hbox',
					items: [
						objs.XOR = Ext.create('Ext.form.field.Number', {
							width: 100,
							minValue: 0
						}),
						'->',
						objs.LEVEL = Ext.create('Ext.form.field.Number', {
							width: 200,
							fieldLabel: 'Уровень',
							minValue: 0
						})
					]
				})
			];

		return objs.items = items;
	},

	isFilled: Ext.trueFn,

	dataCollector: function() {
		var me = this,
			objs = me.objs,
			data = me.callParent([false]);

		Ext.each(me._arr, function(key) { data[key] = objs[key].getValue(); });
		return data;
	},

	loadData: function() {
		var me = this,
			objs = me.objs,
			data = me.data.data;

		objs.from.setValue(me.from);
		objs.to.setValue(me.to);
		objs.TYPE.setFilterTypes(me.S_DOCVID_TYPE);

		Ext.each(me._arr, function(key) { objs[key].setValue(data[key]); });

		me.callParent(arguments);
	},
	getExtra: function (callback) { callback && callback(); }
});