﻿Ext.define('Keysystems.SStatus.Object.Edit', {
	extend: 'Keysystems.Base.Edit',
	viewPreset: 'Keysystems.Gantt.Status',
	statusGanttLink: -1,
	secLink: -1,
	_arr: ['INITIAL', 'MAIL_CURRENT_USER', 'MAIL_FORMULA', 'READ_ONLY', 'S_STATUS', 'LAST_STATUS', 'TYPE', 'PREVIOUS_STATUS'],
	_arrUsersMail: ['CODE', 'LINK', 'NAME', 'S_USERS', 'UID'],
	bodyPadding: 0,
	viewMinSize: [600, 400],
	layout: { type: 'vbox', align: 'stretch' },

	createItems: function() {
		var me = this,
			objs = me.objs,
			f,
			items = [
				Ext.create('Ext.panel.Panel', {
					layout: { type: 'vbox', align: 'stretch' },
					bodyPadding: 10,
					border: 0,
					items: [
						me.createCodeEdit({ maxLength: 10, enforceMaxLength: true, maxWidth: 150 + me.labelWidth }),
						me.createNameEdit({ maxLength: 100, enforceMaxLength: true }),
						objs.OBJCODE = Ext.create('Ext.form.field.ComboBox', {
							editable: false,
							ksAllowEmpty: true,
							fieldLabel: 'Объект',
							labelWidth: me.labelWidth,
							value: 0,
							queryMode: 'local',
							maxWidth: 250 + me.labelWidth,
							displayField: CBDataLib.displayField,
							valueField: CBDataLib.valueField,
							store: Ext.create('Ext.data.Store', {
								fields: (f = CBDataLib.getFields(), f[0].type = 'string', f),
								data: [],
								proxy: 'memory'
							}),
							listeners: { change: function(t, v) { me.objCodeChange(v); } }
						}),
						objs.TLINK = Ext.create('Keysystems.Controls.Dict.Edit', {
							fieldLabel: 'Записи',
							labelWidth: me.labelWidth,
							mode: 'MULTI',
							handler: function() {
								dictFunc({
									mode: 'MULTI',
									parentView: objs.view,
									selectLinks: objs.TLINK.getValue(),
									code: objs.TLINKCode,
									readOnly: objs.TLINK.readOnly,
									control: objs.TLINK,
									contextSearch: objs.TLINK.contextSearch
									},
								{ ok: function(value) { objs.TLINK.setValue(value); } });
							}
						}) //,
						//me.createDHEdit({ maxWidth: 300 + me.labelWidth }) //todo #7616
					]
				}),
				objs.Gantt = me.createGanttPanel()
			];

		return objs.items = items;
	},

	//конструктор гантовской панели
	createGanttPanel: function() {
		var me = this,
			res = Ext.create('Keysystems.Panel.Gantt', {
				flex: 1,
				width: 400,
				height: 250,
				isDuration: false,
				fieldDOCC: 'STATUSOBJC',
				fieldDOCP: 'STATUSOBJP',
				initialCls: '',
				optionalCls: '',
				dependencyStore: Ext.create('Gnt.data.DependencyStore', { model: 'StatusSeqModel', proxy: 'memory' }),
				taskStore: Ext.create('Gnt.data.TaskStore', { model: 'StatusTaskModel', proxy: 'memory' }),
				leftLabelField: 'NAME',
				zoomLevels: ksGantt.zoomLevels(me.viewPreset),
				viewPreset: me.viewPreset,
				editFn: function(f, value, callBack, parentView) { me.editGntRow(f, value, callBack, parentView); },
				removeFn: function(recs, parentView) { me.removeGntRow(recs, parentView); },
				editSeq: function(from, to) { me.editSeq(from, to); }
			});
		res.copyBtn.hide();
		return res;
	},

	editGntRow: function(f, value, callBack, parentView) {
		if (f === 'edit' && !value) return;
		var me = this,
			objs = me.objs,
			tasks = objs.adaptedData.tasks,
			data,
			il = [],
			sd = [];

		Ext.each(tasks, function(t) {
			if (f !== 'new' && t.LINK === value.data.LINK) {
				data = t;
				if (f === 'edit') return;
			}

			il.push(t.S_STATUS);
		});

		if (f === 'copy') data = JSON.stringify(JSON.parse(data));
		if (!data) data = {};

		Ext.each(objs._statusList, function(s) {
			if (il.indexOf(s.LINK) !== -1) return;
			var v = {};
			v[CBDataLib.valueField] = s.LINK;
			v[CBDataLib.displayField] = s.NAME;
			sd.push(v);
		});

		var seq = objs.adaptedData.sequence,
			mail,
			users,
			grantUsers,
			statusObjP = [],
			statusObjC = [];
		if (f === 'new') {
			mail = [];
			users = [];	
			grantUsers = [];

			let val = value ? value.data : tasks.length ? tasks[0] : _;
			if (val) {
				statusObjP = [{
					LINK: val.LINK,
					CODE: val.CODE.toString(),
					NAME: val.NAME
				}];
			}
		} else {
			mail = ArrayLib.filter(objs.statusObjMail, ['STATUSOBJ'], value.data.LINK);
			users = ArrayLib.filter(objs.statusObjUsers, ['STATUSOBJ'], value.data.LINK);
			grantUsers = ArrayLib.filter(objs.statusObjGrantUsers, ['STATUSOBJ'], value.data.LINK);

			var tl = ArrayLib.filter(seq, ['STATUSOBJC'], value ? value.data.LINK : 0);
			let statusObjPs = 
				Ext.Array.filter(tasks, function(t) { return ArrayLib.find(tl, ['STATUSOBJP'], t.LINK) !== -1; });
			Ext.each(statusObjPs , so => {
				statusObjP.push({
					LINK: so.LINK,
					CODE: so.CODE.toString(),
					NAME: so.NAME
				});
			});

			tl = ArrayLib.filter(seq, ['STATUSOBJP'], value ? value.data.LINK : 0);
			let statusObjCs = 
				Ext.Array.filter(tasks, function(t) { return ArrayLib.find(tl, ['STATUSOBJC'], t.LINK) !== -1; });
			Ext.each(statusObjCs , so => {
				statusObjC.push({
					LINK: so.LINK,
					CODE: so.CODE.toString(),
					NAME: so.NAME
				});
			});
		}

		var objCodeVal = objs.OBJCODE.getValue();
		Ext.create('Keysystems.Row.Status.Edit', {
			f: f,
			data: { data: data },
			statusData: sd,
			mail: mail,
			users: users,
			grantUsers: grantUsers,
			readOnly: me.readOnly,

			statusObjP: statusObjP, //Предыдущие
			statusObjC: statusObjC, //Следующие

			dictIgnore: me.dictIgnore[data.S_STATUS],
			planMod: objCodeVal === dnl.PLANREVIZ_MOD,
			dictIgnoreHidden: objCodeVal !== 'DICTIONARY_SDOCVID' && objCodeVal !== dnl.PLANREVIZ_MOD,

			endFunc: callBack,
			parentView: parentView,
			getStatusObjectShema: function(cb) { me.getStatusObjectShema(cb); },
			getStatusObjectData: function(l) { return me.getStatusObjectData(l); },
			getExtra: function(callback) { KsLib.tryRun(callback); },
			baseSaveData: function(params, callback) {
				if (!params.link) {
					this.objs.link = params.link = data.LINK = me.statusGanttLink--;
					tasks.push(data);
				}
				this.oldData = JSON.stringify(params);
				params.LINK = params.link;

				ArrayLib.copyByKeys(me._arr, params, data);

				var s = ArrayLib.filter(objs._statusList, ['LINK'], data.S_STATUS)[0] || {};
				data.CODE = s.CODE;
				data.NAME = s.NAME;

				//Предыдущие
				me.bindData(
					ArrayLib.filter(seq, ['STATUSOBJC'], data.LINK),
					params.STATUSOBJP,
					seq,
					function(l, d) { return ArrayLib.find(l, ['STATUSOBJP'], d.LINK); },
					function(d) {
						return {
							LINK: me.secLink--,
							STATUSOBJC: data.LINK,
							STATUSOBJP: d.LINK
						};
					}
				);

				//Следующие
				me.bindData(
					ArrayLib.filter(seq, ['STATUSOBJP'], data.LINK),
					params.STATUSOBJC,
					seq,
					function(l, d) { return ArrayLib.find(l, ['STATUSOBJC'], d.LINK); },
					function(d) {
						return {
							LINK: me.secLink--,
							STATUSOBJP: data.LINK,
							STATUSOBJC: d.LINK
						};
					}
				);

				//users
				me.setUsersMail(data.LINK, params.S_USERS, objs.statusObjUsers);
				//mail
				me.setUsersMail(data.LINK, params.STATUSOBJMAIL, objs.statusObjMail);
				//grantUser
				me.setUsersMail(data.LINK, params.S_GRAND_USERS, objs.statusObjGrantUsers);

				objs.Gantt.setGanttData(objs.adaptedData);

				me.dictIgnore[data.S_STATUS] = params.dictIgnore;
				
				this.f = 'edit';
				
				QuickMsgs.save();
				KsLib.tryRun(callback);
			}
		});
	},

	removeGntRow: function(recs) {
		var me = this,
			objs = this.objs,
			ad = objs.adaptedData,
			tasks = ad.tasks,
			sequence = ad.sequence,
			remList = [];
		Ext.each(recs, function(r) {
			var pos = ArrayLib.find(tasks, ['LINK'], r.get('LINK'));
			if (pos !== -1) {
				remList.push(tasks[pos]);
			}
		});
		var len = remList.length;
		if (len) {
			selectDialogShow(wmc.getQuestion('Delete'), wmc.get('DeleteMessage', len), function() {
				Ext.each(remList, function(rt) {
					ArrayLib.removeList(sequence, ArrayLib.filter(sequence, ['STATUSOBJC'], rt.LINK));
					ArrayLib.removeList(sequence, ArrayLib.filter(sequence, ['STATUSOBJP'], rt.LINK));

					ArrayLib.removeList(objs.statusObjMail, ArrayLib.filter(objs.statusObjMail, ['STATUSOBJ'], rt.LINK));
					ArrayLib.removeList(objs.statusObjUsers, ArrayLib.filter(objs.statusObjUsers, ['STATUSOBJ'], rt.LINK));

					me.dictIgnore[rt.S_STATUS] = [];
				});
				ArrayLib.removeList(tasks, remList);
				objs.Gantt.setGanttData(ad);
			});
		}
	},

	editSeq: function(from, to) {
		var me = this,
			ganttModel = me.objs.adaptedData,
			rec;

		Ext.each(ganttModel.sequence, function(s) {
			rec = s.STATUSOBJC === to && s.STATUSOBJP === from;
			if (rec) {
				rec = s;
				return false;
			}
			return true;
		});

		if (!rec) {
			ganttModel.sequence.push({
				STATUSOBJP: from,
				STATUSOBJC: to,
				LINK: me.secLink--
			});

			me.objs.Gantt.setGanttData(ganttModel);
		}
	},

	setUsersMail: function(statusObj, inObj, outObj) {
		var me = this;
		return me.bindData(
			ArrayLib.filter(outObj, ['STATUSOBJ'], statusObj),
			inObj,
			outObj,
			function(l, d) { return ArrayLib.find(l, ['UID'], d.UID); },
			function(d) { return ArrayLib.copyByKeys(me._arrUsersMail, d, { STATUSOBJ: statusObj }); }
		);
	},

	getStatusObjectData: function(link) { return Ext.Array.filter(this.objs.adaptedData.tasks, function(t) { return t.LINK !== link; }); },

	getStatusObjectShema: function(callBack) {
		var me = this;
		if (me.shemaStatusObject) {
			callBack(me.shemaStatusObject);
		} else {
			ajaxRequest({
				url: 'SSTATUS/GetShema_A',
				params: { gzipData: '{}' },
				success: function(result) { callBack(me.shemaStatusObject = result); },
				failure: function() {
					showError(wmc.get('ErrorGetShema'));
					callBack(null);
				}
			});
		}
	},

	isFilled: function() {
		const me = this;
		const objs = me.objs;
		let res = me.callParent(arguments);
		
		if (objs.OBJCODE.getValue() === '...') {
			me.addToInvalidControls(objs.OBJCODE);
			res = false;			
		}
		return res;
	},

	getExtra: function(callBack, link) {
		var me = this,
			objs = me.objs;

		me.baseGetExtra({ link: link }, function(value) {
			me.setCodeValue(value.row.CODE);
			objs.NAME.setValue(value.row.NAME);
			//me._setDh(objs.DH, value.row.DH1, value.row.DH2); //todo #7616

			objs.statusObjMail = value.statusObjMail;
			objs.statusObjUsers = value.statusObjUsers;
			objs.statusObjGrantUsers = value.statusObjGrantUsers;
			objs.statusList = value.statusList;

			objs.objectDictCode = value.objectDictCode;
			var d = CBDataLib.get(_, _, value.objCodeDesc);
			objs.OBJCODE.store.loadData(d, false);
			objs.OBJCODE.setValue(value.row.OBJCODE || d[0][CBDataLib.valueField]);
			objs.TLINK.setValue(value.TLINK);

			var c = ArrayLib.filter(value.ganttModel.columns, ['dataIndex'], 'CODE')[0];
			if (c) c.hidden = true;

			c = ArrayLib.filter(value.ganttModel.columns, ['dataIndex'], 'NAME')[0];
			if (c) {
				c.renderer = function(v, m, r) {
					if (r.get('INITIAL')) m.style += ' font-weight: bold;';
					return v;
				};
			}

			if (value.ganttModel) objs.Gantt.setGanttData(objs.adaptedData = value.ganttModel);

			me.isCodeEdit = true;
			me.isNameEdit = true;
			//me.isDHEdit = true; //todo #7616

			me.dictIgnore = value.dictIgnore;

			if (callBack) callBack();
		});
	},

	//конфигурация основого окна
	viewCfg: function() {
		var result = this.callParent(arguments);
		result.resizable = true;
		result.maximizable = true;
		result.minWidth = 600;
		result.minHeight = 400;
		result.width = this.width;
		return result;
	},
	dataCollector: function() {
		var me = this,
			objs = me.objs,
			statusObj = [];

		Ext.each(objs.adaptedData.tasks, function(t) { statusObj.push(ArrayLib.copyByKeys(me._arr, t, { LINK: t.LINK })); });
		var data = me.callParent(arguments);
		data.OBJCODE = objs.OBJCODE.getValue();
		data.TLINK = objs.TLINK.getLinks(1);
		data.statusObjMail = JSON.stringify(objs.statusObjMail);
		data.statusObjUsers = JSON.stringify(objs.statusObjUsers);
		data.statusObjGrantUsers = JSON.stringify(objs.statusObjGrantUsers);
		data.STATUSOBJ = JSON.stringify(statusObj);
		data.sequence = JSON.stringify(objs.adaptedData.sequence);

		data.dictIgnore = me.dictIgnore;

		return data;
	},

	objCodeChange: function(v) {
		var objs = this.objs,
			adaptedData = objs.adaptedData;

		if (v) {
			var code = objs.objectDictCode[v];
			if (code) {
				objs.TLINKCode = code;
				objs.TLINK.setValue();
				objs.TLINK.enable();
			} else {
				objs.TLINK.disable();
			}
			objs._statusList = ArrayLib.filter(objs.statusList, ['OBJCODE'], v);
		} else {
			objs.TLINK.setValue();
			objs.TLINK.disable();
			objs._statusList = [];
		}

		if (adaptedData) {
			adaptedData.tasks = [];
			adaptedData.sequence = [];
			objs.Gantt.setGanttData(objs.adaptedData);
		}
	},

	profileListeners: [{ name: 'view', method: 'FormParam' }],

	loadProfile: function(v) { return this.callParent([v || "{\"view_FormParam\":\"{\\\"x\\\":0,\\\"y\\\":0}\"}"]); }
});