Ext.define('Keysystems.Sklon.List', {
    extend: 'Keysystems.Base.List',

    multiSelectGridVisible: false,
    hidePagging: true,
    ignoreLoadNextPrevPages: true,
    profileLinkCode: 'SSklon',
    
    indexLastRec: -1,
    recLink: -1,
    ignoreQuestion: false,

    viewCfg: function() {
        let me = this,
            res = me.callParent(arguments);

        res.tabID = 'PLT_SKLON';

        return res;
    },
    
    createTBar: function() {
        var me = this;
        
        return me.objs.tbar = [
            Ext.create('Ext.Button', {
                tooltip: 'Добавить строку',
                tooltipType: 'title',
                iconCls: 'x_btn_add_element',
                code: 'button_add_element',
                handler: function() {
                    let gridData = me.Grid.store.getDataExt().slice(),
                        selModel = me.Grid.getSelectionModel();

                    gridData.push({
                        CHECKED: false,
                        UPD: 1, 
                        DEL: 0,
                        LINK: me.recLink--,
                        IP: '',
                        RP: '',
                        DP: '',
                        VP: '',
                        TP: '',
                        pp: '',
                        GENDER: '',
                        GENDER_NAME: ''
                    });
                    me.Grid.store.loadData(gridData);

                    selModel.selectByPosition({
                        row: gridData.length - 1
                    });
                }
            }),
            Ext.create('Ext.Button', {
                tooltip: 'Удалить строку',
                tooltipType: 'title',
                iconCls: 'x_btn_delete_element',
                code: 'button_delete_element',
                handler: function() {
                    var recs = [];
                    me.Grid.store.each(rec => { 
                        if (rec.get('CHECKED')) {
                            recs.push(rec);
                        }
                    });
                    
                    if (!recs.length) {
                        recs = me.Grid.selModel.getSelection();
                    }
                            
                    Ext.each(recs, rec => {
                        rec.set('DEL', -1);
                        if(me.Grid.store.indexOf(rec) <= me.indexLastRec) { 
                            me.indexLastRec--;
                        }
                    });
                    
                    if (recs.length) {
                        me.Grid.store.filter();
                    }
                }
            }),
            { xtype: 'tbseparator' },
            Ext.create('Ext.Button', {
                tooltip: 'Сохранить',
                tooltipType: 'title',
                code: 'button_save',
                iconCls: 'x_btn_save',
                handler: function() {
                    if (me.isFilled()) {
                        me.saveData();
                    }
                }
            }),
            Ext.create('Ext.Button', {
                tooltip: 'Обновить',                
                tooltipType: 'title',
                iconCls: 'x_btn_refresh',
                code: 'button_refresh',
                handler: function() {
                    var p = {
                        whereArgs: me.appEndWhereArgs(me.getWhereArgs()),
                        GateCode: me.GateCode,
                        controlName: me.controlName,
                        page: me.startPage,
                        pageSize: me.gridStore.pageSize,
                        reload: true
                    };
                    me.showLoadMask({
                        msg: KS.L10n.loading_data,
                        rid: ajaxRequest({
                            params: { gzipData: SignalR.pack(p) },
                            url: me.linkCode + '/Get_A',
                            success: function (data) {
                                if (data) {
                                    if (me.beforeSetData(data, p) === false) return;
                                    me.setData(data.data);
                                    me.indexLastRec = -1;
                                    me.indexLastRec = -1;
                                    me.ignoreQuestion = false;
                                }
                            },
                            callback: function() { me.hideLoadMask(); }
                        })
                    })
                }
            }),
            Ext.create('Ext.Button', {
                tooltip: 'Выход',
                tooltipType: 'title',
                iconCls: 'x_btn_exit',
                code: 'button_exit',
                handler: function() {
                    me.objs.view.close();
                }
            })
        ];
    },

    getGridCfg: function() {
        var me = this,
            objs = me.objs,
            res = me.callParent(arguments);
        
        res.plugins.push(
            Ext.create('Ext.grid.plugin.CellEditing',
                {
                    clicksToEdit: 1,
                    listeners: {
                        ksAfteredit: function(editor, e) {
                            if (e.originalValue !== e.value){
                                e.record.set('UPD', 1);
                            }
                        }
                    }
                })
        );
        
        return res;
    },

    getGridStoreCfg: function() {
        var me = this,
            res = me.callParent(arguments);

        res.filters = [{
            property: 'DEL',
            value: 0
        }];

        delete res.remoteSort;
        
        return res;
    },

    createItems() {
        var me = this,
            res = me.callParent(arguments);

        res.push(me.sksc('infoBlockPanel', Ext.create('Ext.panel.Panel',
            {
                hidden: true,
                title: 'Протокол сохранения',
                items: [
                    me.sksc('infoBlock', Ext.create('Ext.form.Label',{
                        height: 200
                    }))
            ]})));
        
        return res;
    },

    columnsAdapted: function(columns) {
        var me = this,
            cols = me.callParent(arguments),
            pos = ArrayLib.find(cols, ['dataIndex'], 'GENDER');
        
        if (pos !== -1) {
            cols[pos].editor =  {
                xtype: 'comboextra',
                editable: false,
                displayField: CBDataLib.displayField,
                valueField: CBDataLib.valueField,
                store: Ext.create('Ext.data.ArrayStore', {
                    fields: [CBDataLib.valueField, CBDataLib.displayField],
                    data: me.gksd('genderLst'),
                }),
                listeners: {
                    change: function(th, newValue, oldValue) {
                        var rec = me.Grid.editingPlugin.getActiveRecord();
                        rec.set('UPD', 1);
                    },
                }
            };
            cols[pos].renderer = function(val) {
                var res = '...',
                    genderLst = me.gksd('genderLst');
                
                Ext.each(genderLst, d => {
                    if (d[0] === val) {
                        res = d[1];
                    }
                });
                
                return res;
            };
        }

        Ext.each(['IP', 'RP', 'DP', 'VP', 'TP', 'PP'], p => {
           pos =  ArrayLib.find(cols, ['dataIndex'], p);
            if (pos !== -1) {
                cols[pos].renderer = function(v, meta, rec, rowIndex) {
                    if (rowIndex <= me.indexLastRec && !v.length) {
                        meta.tdCls = 'colorize-empty-grid-cell';
                    }
                    return v;
                };
            }
        });
        
        return cols;
    },
    
    beforeSetData: function(data, p) {
        var me = this,
            res = me.callParent(arguments);
        
        me.sksd('gridData', JSON.parse(JSON.stringify(data.data.data)));
        
        return res;
    },
    
    baseGetData: function(endFunc, params) {
        var me = this;
        
        me.callParent([
            function(data) {
                me.sksd('genderLst', data.genderLst);
            
                if (endFunc) endFunc(data);
            }, params
        ]);
    },

    addViewEvents: function() {
        var me = this,
            view = me.objs.view || me.getKsControl('view');
        
        me.callParent(arguments);

        view.on('beforeclose', function() {
            return me.isClosing ? true: me.beforeExit();
        });
    },

    isFilled: function() {
        var me = this,
            gridData = me.Grid.store.getDataExt(),
            res = true;
        
        Ext.each(gridData, d => {
            if (!d.IP.length || !d.RP.length || !d.DP.length || !d.VP.length || !d.TP.length || !d.PP.length) {
                res = false;
            }
        });
        
        if (!res) {
            me.indexLastRec = me.Grid.store.getDataExt().length - 1;
            info('Проверьте правильность заполнения полей, отмеченных красным!');
            me.Grid.view.refresh();
        }
        
        return res;
    },

    saveData: function(endFunc) {
        var me = this;

        Log.sendLog(wmc.get('Saving'));
        me.showLoadMask({
            msg: KS.L10n.saving,
            rid: ajaxRequest({
                url: me.linkCode + '/Save_A',
                params: { 
                    gzipData: SignalR.pack({
                        gridData: me.Grid.store.getDataExt(),
                        ignoreQuestion: me.ignoreQuestion
                })},
                success: function(result) {
                    if (result.type === 'info' || result.type === 'block') {
                        me.gksc('splitterMSG').show();
                        me.gksc('infoBlock').setText(result.text, false);
                        me.gksc('infoBlockPanel').show();
                    } else if (result.type === 'question' && !me.ignoreQuestion) {
                        ChooseBox.ShowHTML({
                            caption: 'Протокол сохранения',
                            text: result.text,
                            warnOrErrorIcon: true,
                            hasIgnoreButton: true,
                            nextFn: function() {
                                me.ignoreQuestion = true;
                                me.saveData(endFunc);
                            }
                        });
                    }
                    
                    if (result.result) {
                        me.successSaveFunc(result, endFunc);
                    }
                },
                callback: me.hideLoadMask.bind(me),
                failure: function(val) {
                    QuickMsgs.notSave();
                    Log.sendLog(wmc.get('SavingError'));
                    failureShow(val, wmc.get('SavingError'));
                }
            })
        });
    },

    changeMsgShow: function(cfg) {
        Ext.Msg.show({
            title: wmc.get('Attention'),
            msg: wmc.get('SaveChanges'),
            buttons: Ext.MessageBox.YESNOCANCEL,
            fn: function(buttonId) {
                var fn = cfg[buttonId] || cfg.default;
                if (fn) fn();
            },
            icon: Ext.MessageBox.QUESTION
        });
    },

    successSaveFunc: function(result, endFunc) {
        var me = this;
        if (!result.data) return;
        
        me.sksd('gridData', result.data);
        me.Grid.store.loadData(result.data);
        
        me.ignoreQuestion = false;

        QuickMsgs.save();
        
        if (endFunc) endFunc();
    },

    profileOnClear: function() {
        var me = this;
        selectDialogShow(wmc.get('CleanProfileTitle'),
            wmc.get('CleanProfile', this.title),
            function() {
                var code = me.code,
                    dict = getDictParent(dictListController[code]);
                code = dict.profileCode || dict.$parentCode || code;
                ajaxRequest({
                    url: me.linkCode + '/CleanProfile_A',
                    params: { code: code || '' },
                    success: function(result) {
                        if (result) {
                            me.cleanLocalProfile(result.title);
                        }
                    }
                });
            });

    },
    
    beforeExit: function() {
        var me = this,
            oldGridData = me.gksd('gridData').slice(),
            newGridData = me.Grid.store.getDataExt().slice();

        oldGridData.forEach(r=>{delete r.id; delete r.CHECKED});
        newGridData.forEach(r=>{delete r.id; delete r.CHECKED});
        
        me.isClosing = true;
        
        if (JSON.stringify(oldGridData) !== JSON.stringify(newGridData)){
            me.changeMsgShow({
                yes: function() {
                    me.isClosing = false;
                    
                    if (me.isFilled()) {
                        me.saveData(function() {
                            me.objs.view.close();
                        });
                    }
                },
                no: function() {
                    me.objs.view.close();
                },
                cancel: function() {
                    me.isClosing = false;
                }
            });
            
            return false;
        }
        
        return true;
    }
});