﻿Ext.define('Keysystems.SRosnov.Edit', {
	extend: 'Keysystems.Base.Edit',
	tSRosnovSPlanLink: -1,
	createItems: function () {
		var me = this,
			objs = me.objs,
			items = [
				objs.S_PLAN = Ext.create('Keysystems.Controls.Dict.Edit', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Разделы плана',
					width: me.width,
					mode: 'MULTI',
					handler: function () {
						dictFunc({
							mode: 'MULTI',
							parentView: objs.view,
							selectLinks: objs.S_PLAN.getValue(),
							code: dnl.S_PLAN,
							readOnly: objs.S_PLAN.readOnly,
							control: objs.S_PLAN,
							contextSearch: objs.S_PLAN.contextSearch,
							createItems: function () {
								var th = this,
									res = th.callParent(arguments);
								if (this.f) return res;

								th.chbNotPlan = Ext.create('Ext.form.field.Checkbox', {
									labelSeparator: '',
									hideLabel: true,
									boxLabel: 'Внеплановый',
									fieldLabel: 'Внеплановый',
									padding: '0 0 0 5',
									listeners: { change: function (_, v) { th.chbCheckChanged(v); } }
								})

								res.splice(1, 0, th.chbNotPlan);

								th.Grid.on('selectionchange',
									function (_, sels) {
										if (th.isLoaded) return;
										th.activeRow = sels[0];
										th.refreshExtendedRow(sels[0]);
									});

								if (th.functions.ok) {
									th.functions.__ok = th.functions.ok;
									th.functions.ok = function (value) {
										objs.S_PLAN_VALUE = [];
										if (value) {
											value.forEach(rec => {
												let rowT = th.getT(rec.get('LINK'));
												objs.S_PLAN_VALUE.push(
													{
														LINK: rowT ? rowT.LINK : me.tSRosnovSPlanLink--,
														S_PLAN: rec.get('LINK'),
														S_PLAN_CODE: rec.get('CODE'),
														S_PLAN_NAME: rec.get('NAME'),
														NOTPLAN: rowT.NOTPLAN
													});
											});
										}
										th.functions.__ok(value);
									};
								}

								th.T_SROSNOV_SPLAN = [];
								objs.S_PLAN_VALUE.forEach(r => th.T_SROSNOV_SPLAN.push(r));

								return res;
							},
							afterRefresh: function () {
								var th = this;
								th.activeRow = th.Grid.getSelectionModel().getSelection()[0];
								th.refreshExtendedRow(th.activeRow);
							},
							chbCheckChanged: function (value) {
								let th = this;
								if (!th.activeRow) return;
								let sPlan = th.activeRow.get('LINK'),
									rowT = th.getT(sPlan);
								if (rowT) rowT.NOTPLAN = value;
							},
							createCheckColumn: function () {
								var th = this,
									res = th.callParent(arguments);
								th.mColumn.on('checkchange',
									function (_, __, checked, rec) {
										th.updateT(rec);
										th.refreshExtendedRow(rec);
									});
								return res;
							},
							createT: function (rec) {
								return {
									LINK: me.tSRosnovSPlanLink--,
									S_PLAN: rec.get('LINK'),
									S_PLAN_CODE: rec.get('CODE'),
									S_PLAN_NAME: rec.get('NAME'),
									NOTPLAN: false
								};
							},
							getT: function (sPlan) {
								var value = ArrayLib.filter(this.T_SROSNOV_SPLAN || [], ['S_PLAN'], sPlan)[0];
								return value;
							},
							updateT: function (rec) {
								let th = this,
									sPlan = rec.get('LINK');
								if (rec.get('M')) {
									let rowT = th.getT(sPlan);
									if (!rowT) {
										rowT = th.createT(rec);
										th.T_SROSNOV_SPLAN.push(rowT);
									}
								} else {
									let rowT = th.getT(sPlan);
									if (rowT) {
										ArrayLib.remove(th.T_SROSNOV_SPLAN, rowT);
									}
								}
							},
							refreshExtendedRow: function (rec) {
								let th = this;
								if (th.activeRow != rec) return;

								if (rec) {
									if (rec.get('M') === '') {
										th.chbNotPlan.disable();
										return;
									}
									let sPlan = rec.get('LINK');
									let rowT = th.getT(sPlan);
									if (rec.get('M')) {
										th.chbNotPlan.enable();
										th.chbNotPlan.setValue(rowT.NOTPLAN);
										return;
									} else {
										th.chbNotPlan.disable();
										th.chbNotPlan.setValue(false);
									}
								} else {
									delete th.activeRow;
									th.chbNotPlan.disable();
									th.chbNotPlan.setValue(false);
								}
							}

						}, {
							ok: function (value) { objs.S_PLAN.setValue(value); }
						});
					}
				}),
				objs.S_DOCVID = Ext.create('Keysystems.Controls.Dict.Edit', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Виды документов',
					width: me.width,
					mode: 'MULTI',
					handler: function () {
						dictFunc({
							mode: 'MULTI',
							parentView: objs.view,
							whereArgs: objs.DocVidArgs,
							readOnly: objs.S_DOCVID.readOnly,
							selectLinks: objs.S_DOCVID.getValue(),
							code: dnl.S_DOCVID,
							control: objs.S_DOCVID,
							contextSearch: objs.S_DOCVID.contextSearch
						}, { ok: function (value) { objs.S_DOCVID.setValue(value); } });
					}
				})
			];

		me.isCodeEdit = true;
		me.codeEditCfg = { maxLength: 7, enforceMaxLength: true };
		me.isNameEdit = true;
		me.nameEditCfg = { maxLength: 500, enforceMaxLength: true };
		me.isDHEdit = true;

		return me.callParent([items]);
	},
	dataCollector: function () {
		var me = this,
			objs = me.objs,
			data = me.callParent(arguments);

		data.sPlan = JSON.stringify(objs.S_PLAN_VALUE);
		data.sDocVid = objs.S_DOCVID.getLinks(1);
		return data;
	},

	getExtra: function (callBack, link) {
		var me = this,
			objs = me.objs;
		me.baseGetExtra({ link: link }, function (value) {
			me.setCodeValue(value.row.CODE);
			objs.NAME.setValue(value.row.NAME);
			if (value.row.DH1 && value.row.DH2) {
				objs.DH.setValue(new Date(value.row.DH1), new Date(value.row.DH2));
			}

			objs.S_PLAN_VALUE = value.sPlan;
			objs.S_PLAN.setValue(me.convertListToDictList(value.sPlan, 'S_PLAN'));

			objs.S_DOCVID.setValue(value.sDocVid);
			objs.DocVidArgs = {
				InLinksOnly: { value: 'True', type: 'bool' },
				InLinks: { value: value.DocVidInLinks, type: 'List_int' }
			};
			if (callBack) callBack();
		});
	}
});