﻿Ext.define('Keysystems.SRegion.Edit', {
	extend: 'Keysystems.Base.Edit',
	bodyPadding: 0,
	profileListeners: [{ name: 'view', method: 'FormParam' }],

	createItems: function() {
		var me = this;
		me.isCodeEdit = true;
		me.isNameEdit = true;
		me.isDHEdit = true;
		return me.objs.allTab = Ext.create('Ext.tab.Panel', {
			border: 0,
			flex: 1,
			userCls: me.basePanelCls,
			bodyCls: me.basePanelBodyCls,
			items: me.objs.items = [me.getTab('General')]
		});		
	},
	//конструктор таба Общие 
	createTabGeneral: function() {
		var me = this,
			objs = me.objs;

		return objs.tabGeneral = Ext.create('Ext.panel.Panel', {
			title: 'Общие',
			layout: { type: 'vbox', align: 'stretch' },
			bodyPadding: 10,
			flex: 1,
			border: 0,
			items: [
				objs.CODE = me.createCodeEdit({ maxLength: 12, enforceMaxLength: true, maxWidth: 150 + me.labelWidth }),
				objs.NAME = me.createNameEdit({ maxLength: 250, enforceMaxLength: true }),
				objs.OKATO = Ext.create('Ext.form.field.Text', {
					maxLength: 11,
					maxWidth: 150 + me.labelWidth,
					enforceMaxLength: true,
					fieldLabel: 'ОКАТО',
					labelWidth: me.labelWidth
				}),
				objs.OKTMO = Ext.create('Ext.form.field.Text', {
					maxLength: 11,
					maxWidth: 150 + me.labelWidth,
					enforceMaxLength: true,
					fieldLabel: 'OKTMO',
					labelWidth: me.labelWidth
				}),
				objs.DH = me.createDHEdit({ labelWidth: me.labelWidth, maxWidth: 400 })
			]
		});
	},	
	viewCfg: function() {
		var result = this.callParent(arguments);
		result.maximizable = true;
		result.resizable = true;
		result.minHeight = 240;
		result.minWidth = 600;
		return result;
	},
	//конструктор таба Реквизиты
	createTabProp: function() {
		var me = this;
		
		return me.objs.tabProp = Ext.create('Keysystems.Panel.Prop', {
			parentView: me,
			decimalData: me.gksd('decimalData')
		});
	},
	dataCollector: function() {
		var me = this,
			objs = me.objs,
			data = me.callParent(arguments);

		data.OKATO = objs.OKATO.getValue();
		data.OKTMO = objs.OKTMO.getValue();

		data.tabProp = JSON.stringify(me.dataCollectorProp());

		return data;
	},
	//Сборка данных таба "Реквизиты" 
	dataCollectorProp: function() {
		var me = this;
		return me.getTabVisible('Prop') ? me.getTab('Prop').getData() : _;
	},
	getExtra: function(endFunc, link) {
		var me = this,
			objs = me.objs;

		me.baseGetExtra({ link: link }, function(value) {
			me.sksd('decimalData', value.decimalData);
			me.autoFillControl(value.row);
			objs.OKATO.setValue(value.row.OKATO);
			objs.OKTMO.setValue(value.row.OKTMO);

			me.getExtraProp(value);

			if (endFunc) endFunc();
		});
	},

	//загрузка данных таба "Реквизиты" 
	getExtraProp: function(value) {
		if (value.tabProp) {
			var me = this;
			me.objs.allTab.changeTab(me.getTab('Prop').loadData(value.tabProp), true);
		}
	}
});