﻿Ext.define('Keysystems.SRTema.Edit', {
	extend: 'Keysystems.Base.Edit',
	profilePrefix: 'RTema',

	viewMinSize: [600, 300],
	profileListeners: [{ name: 'view', method: 'FormParam' }],
	bodyPadding: 0,
	createItems: function() {
		var me = this;
		return me.objs.allTab = Ext.create('Ext.tab.Panel', {
			plain: true,
			border: 0,
			flex: 1,
			userCls: me.basePanelCls,
			bodyCls: me.basePanelBodyCls,
			items: me.getTab('General')
		});
	},

	//конструктор таба Общие
	createTabGeneral: function() {
		var me = this,
			objs = me.objs;

		objs.tabGeneral = Ext.create('Ext.panel.Panel', {
			title: 'Общие',
			layout: { type: 'vbox', align: 'stretch' },
			flex: 1,
			border: 0,
			padding: 10,
			items: [
				Ext.create('Ext.form.FieldContainer', {
					layout: { type: 'vbox', align: 'stretch' },
					padding: me.bodyPadding,
					items: [
						me.createCodeEdit(),
						me.createNameEdit({ maxLength: 2000 }),
						me.createSNameEdit({ maxLength: 700 }),
						me.createDictEdit({
							key: 'S_RPROG',
							code: dnl.S_RPROG,
							fieldLabel: 'Вопросы программы'
						}),
						me.createDictEdit({
							key: 'S_NPA',
							code: dnl.S_NPA,
							fieldLabel: 'НПА'
						}),
						me.createDictEdit({
							key: 'S_PLAN',
							code: dnl.S_PLAN,
							fieldLabel: 'Раздел плана'
						}),
						me.createDHEdit({ maxWidth: 400 })
					]
				}),
				me.sksc('vfaContainer', Ext.create('Ext.form.FieldContainer', {
					layout: { type: 'hbox'},
					flex: 1,
					visible: me.isVfa,
					items: me.isVfa ? me.createVfaPanels() : []
				}))
			]
		});

		return objs.tabGeneral;
	},

	//конструктор таба Реквизиты
	createTabProp: function() {
		var me = this,
			objs = me.objs;

		return objs.tabProp = Ext.create('Keysystems.Panel.Prop', {
			border: 0,
			parentView: me,
			decimalData: me.gksd('decimalData')
		});
	},
	
	createVfaToolBar: function(gridKey) {
		var me = this;
		return [
			Ext.create('Ext.Button', {
				iconCls: 'x_btn_dict',
				tooltip: 'Выбрать',
				tooltipType: 'title',
				handler: function() {
					var grid = me.gksc(gridKey),
						whereArgs = {},
						sel = [];

					if (gridKey === 'gridOtdels' && !me.gksc('gridOrgs').getStore().getData().length) return;
					
					grid.store.each(function(r) { sel.push({ LINK: r.get('LINK') }); });

					if (grid.code === dnl.S_OTDEL) {
						var selOrg = me.gksc('gridOrgs').getFrstSelect();
						whereArgs.SOrgs = {
							value: JSON.stringify([(selOrg && selOrg.get('LINK')) || 0]),
							type: 'List_int'
						}
					}

					dictFunc({
						settings: 'MULTI',
						whereArgs: whereArgs,
						selectLinks: sel,
						code: grid.code,
						getSOrg: function() {
							return me.gksc('gridOrgs').getFrstSelect().get('LINK');
						}
					}, {
						ok: function(value) {
							grid.store.loadData(value);

							if (grid.code === dnl.S_OTDEL) {
								var allOtdels = me.gksd('allOtdels'),
									data = grid.store.getDataExt(),
									filtered = ArrayLib.filter(allOtdels, ['S_ORG'], selOrg.get('LINK'));

								Ext.each(filtered, function(d) {
									var pos = ArrayLib.find(data, ['LINK'], d.LINK);

									if (pos === -1) {
										var delPos = ArrayLib.find(allOtdels, ['LINK'], d.LINK);
										allOtdels.splice(delPos, 1);
									} else {
										data.splice(pos, 1);
									}
								});

								Ext.each(data, function(newData) {
									allOtdels.push(newData);
								});

								me.gksc('gridOrgs').getSelectionModel().select(selOrg);
							}
						}
					});
				}
			}),
			Ext.create('Ext.Button', {
				key: 'delete',
				iconCls: 'x_btn_delete',
				tooltip: 'Удалить',
				tooltipType: 'title',
				disabled: true,
				handler: function() {
					var grid = me.gksc(gridKey),
						sel = grid.getFrstSelect();

					grid.removeSelection(_, function() {
						var allOtdels = me.gksd('allOtdels');

						if (grid.code === dnl.S_ORG) {
							var filtered = ArrayLib.filter(allOtdels, ['S_ORG'], sel.get('LINK'));
							ArrayLib.removeList(allOtdels, filtered);
							if (!me.gksc('gridOrgs').getSelectionModel().getSelection().length)
								me.gksc('gridOtdels').loadData([]);
						} else {
							var pos = ArrayLib.find(allOtdels, ['LINK'], sel.get('LINK'));
							allOtdels.splice(pos, 1);
						}
					});
				}
			})
		];
	},

	//конструктор панелей Объекты аудита и Подразделения
	createVfaPanels: function() {
		var me = this;

		return [
			me.sksc('gridOrgs', Ext.create('Ext.grid.Panel', {
				title: 'Объекты аудита',
				userCls: 'rks-filter-panel',
				flex: 1,
				code: dnl.S_ORG,
				columns: [],
				columnLines: true,
				store: Ext.create('Ext.data.Store', {
					fields: [],
					data: [],
					proxy: 'memory'
				}),
				listeners: {
					select: function(grid, record) {
						var sorgLink = record.get('LINK'),
							gridOtdels = me.gksc('gridOtdels'),
							allOtdels = me.gksd('allOtdels'),
							otdelsByOrg = ArrayLib.filter(allOtdels, ['S_ORG'], sorgLink);

						gridOtdels.store.loadData(otdelsByOrg, false);
					},
					selectionchange: (_, sels) => me.enableToolsGrid(me.gksc('gridOrgs'), sels)
				},
				tbar: me.createVfaToolBar('gridOrgs'),
				plugins: ['gridclipboard']
			})),
			{ xtype: 'splitter' },
			me.sksc('gridOtdels', Ext.create('Ext.grid.Panel', {
				title: 'Подразделения',
				userCls: 'rks-filter-panel',
				flex: 1,
				code: dnl.S_OTDEL,
				columns: [],
				columnLines: true,
				store: Ext.create('Ext.data.Store', {
					fields: [],
					data: [],
					proxy: 'memory'
				}),
				tbar: me.createVfaToolBar('gridOtdels'),
				listeners: {
					selectionchange: (_, sels) => me.enableToolsGrid(me.gksc('gridOtdels'), sels)
				},
				plugins: ['gridclipboard']
			}))
		];
	},

	//конфигурация основого окна
	viewCfg: function () {
		var me = this;
		if (me.isVfa) {
			me.profilePrefix = 'RTemaVFA';
			me.viewMinSize[1] = 500;
		} else {
			me.profilePrefix = 'RTema';
			me.viewMinSize[1] = 300;
		}
		var result = this.callParent(arguments);
		result.resizable = true;
		result.maximizable = true;
		
		return result;
	},

	dataCollector: function() {
		var me = this,
			objs = me.objs;

		me.isCodeEdit = true;
		me.isNameEdit = true;
		me.isSNameEdit = true;
		me.isDHEdit = true;
		var data = me.callParent(arguments);
		data.S_RPROG = objs.S_RPROG.getLinks(1);
		data.S_NPA = objs.S_NPA.getLinks(1);
		data.S_PLAN = me.gksc('S_PLAN').getLinks(1);
		data.prop = objs.isTabProp ? me.getTab('Prop').getData(1) : _;

		if (me.isVfa) {
			var sOrgLinks = me.gksc('gridOrgs').store.getLinks(),
				sOtdelLinks = [],
				allOtdels = me.gksd('allOtdels');

			data.sOrgLinks = JSON.stringify(sOrgLinks);

			Ext.each(sOrgLinks, function(link) {
				var otdels = ArrayLib.filter(allOtdels, ['S_ORG'], link);
				Ext.each(otdels, function(otdel) {
					sOtdelLinks.push({
						S_ORG: link,
						S_OTDEL: otdel.LINK
					});
				});
			});

			data.sOtdelLinks = JSON.stringify(sOtdelLinks);
		}

		return data;
	},

	getExtra: function(endFunc, link) {
		var me = this,
			objs = me.objs;

		me.baseGetExtra({ link: link }, function(value) {
			var row = value.row;
			me.sksd('decimalData', value.decimalData);
			me._setDh(objs.DH, row.DH1, row.DH2);
			me.setCodeValue(value.row.CODE);
			objs.NAME.setValue(row.NAME);
			objs.SNAME.setValue(row.SNAME);

			objs.S_RPROG.setValue(value.S_RPROG);
			objs.S_NPA.setValue(value.S_NPA);
			me.gksc('S_PLAN').setValue(value.S_PLAN);

			if (value.tabProp) {
				objs.isTabProp = true;
				objs.allTab.changeTab(me.getTab('Prop').loadData(value.tabProp), true);
			}
			
			if (me.isVfa) {
				me.sksd('allOtdels', value.gridOtdels.data);
				me.gksc('gridOtdels').setMetaDate(value.gridOtdels);
				me.gksc('gridOrgs').setMetaDate(value.gridOrgs);
			}

			if (endFunc) endFunc();
		});
	}
});