﻿Ext.define('Keysystems.SRProg.Edit', {
	extend: 'Keysystems.Base.Edit',
	tSNarSNpaLink: -1,
	viewMinSize: [600, 380],	
	labelWidth: 170,
	profileListeners: [{ name: 'view', method: 'FormParam' }],
	bodyPadding: 0,
	//конфигурация основого окна
	viewCfg: function () {
		var result = this.callParent(arguments);
		result.resizable = true;
		result.maximizable = true;
		return result;
	},

	createItems: function () {
		var me = this;
		return me.objs.allTab = Ext.create('Ext.tab.Panel', {
			plain: true,
			border: 0,
			flex: 1,
			userCls: me.basePanelCls,
			bodyCls: me.basePanelBodyCls,
			items: me.objs.items = [me.getTab('General')]
		});
	},
	//конструктор таба Общие
	createTabGeneral: function () {
		var me = this,
			objs = me.objs;

		objs.tabGeneral = Ext.create('Ext.panel.Panel', {
			title: 'Общие',
			layout: {type: 'vbox', align: 'stretch'},
			flex: 1,
			border: 0,
			bodyPadding: 10,
			items: [
				me.createCodeEdit({maxLength: 10}),
				me.createNameEdit({maxLength: 3000}),
				me.createDictEdit({
					key: 'S_RDOC',
					mode: 'MULTI',
					code: dnl.S_RDOC,
					labelWidth: me.labelWidth,
					fieldLabel: 'Проверяемые документы',
					width: me.width,
				}),
				me.createDictEdit({
					key: 'S_NPA',
					mode: 'MULTI',
					code: dnl.S_NPA,
					width: me.width,
					fieldLabel: 'НПА',
					listCfg: {
						isArticle: true,
						getT_SNPA: function () {
							return me.objs.S_NPA_VALUE;
						},
						getT_SNPA_SARTICLE: function () {
							return me.objs.PROGNPA_ARTICLE;
						},
						fieldTSNarSNar: 'T_SRPROG_SNPA',
						creTSNpa: function (rec) {
							return {
								LINK: me.tSNarSNpaLink--,
								S_NPA: rec.LINK || rec.get('LINK'),
								S_NPA_CODE: rec.CODE || rec.get('CODE'),
								S_NPA_NAME: rec.NAME || rec.get('NAME')
							};
						}
					}
				}),
				objs.CONTENT = Ext.create('Ext.form.field.TextArea',
					{
						labelWidth: me.labelWidth,
						fieldLabel: 'Содержание',
						flex: 1,
						width: me.width,
						height: 100
					}),
				objs.METHOD = Ext.create('Keysystems.Controls.ComboBoxExtra',
					{
						fieldLabel: 'Способ контрольных действий',
						labelWidth: me.labelWidth,
						editable: false,
						enableKeyEvents: true,
						value: null,
						store: Ext.create('Ext.data.Store',
							{
								fields: CBDataLib.getFields(),
								data: CBDataLib.get('SRProgMethod'),
								proxy: 'memory'
							}),
						displayField: 'value',
						valueField: 'index'
					}),
				me.createDHEdit({maxWidth: 400})
			]
		});
		return objs.tabGeneral;
	},

	//конструктор таба Реквизиты
	createTabProp: function () {
		var me = this,
			objs = me.objs;

		return objs.tabProp = Ext.create('Keysystems.Panel.Prop', {
			border: 0,
			parentView: me,
			decimalData: me.gksd('decimalData')
		});
	},
	
	dataCollector: function() {
		var me = this,
			objs = me.objs;

		me.isCodeEdit = true;
		me.isNameEdit = true;
		me.isDHEdit = true;

		var data = me.callParent([false]);
		data.CONTENT = objs.CONTENT.getValue();
		data.METHOD = objs.METHOD.getValue();
		data.S_RDOC = objs.S_RDOC.getLinks(1);
		
		var l = [];
		Ext.each(objs.S_NPA_VALUE, function (v) {
			l.push(ArrayLib.copyByKeys(['LINK', 'S_NPA'], v, {
				S_ARTICLE: JSON.stringify(ArrayLib.getLinks(ArrayLib.filter(objs.PROGNPA_ARTICLE, ['T_SRPROG_SNPA'], v.LINK), 'S_ARTICLE'))
			}));
		});
		data.S_NPA = JSON.stringify(l);
		data.prop = objs.isTabProp ? me.getTab('Prop').getData(1) : _;
		return data;
	},

	getExtra: function(callBack, link) {
		var me = this,
			objs = me.objs;

		me.baseGetExtra({ link: link }, function (value) {
			me.sksd('decimalData', value.decimalData);
			me.setCodeValue(value.row.CODE);
			objs.NAME.setValue(value.row.NAME);
			objs.CONTENT.setValue(value.row.CONTENT);
			objs.METHOD.setValue(value.row.METHOD);
			objs.S_RDOC.setValue(value.S_RDOC);
			objs.S_NPA.setValue(me.convertListToDictList(objs.S_NPA_VALUE = value.S_NPA, 'S_NPA'));
			objs.PROGNPA_ARTICLE = value.PROGNPA_ARTICLE;
			if (value.tabProp) {
				objs.isTabProp = true;
				objs.allTab.changeTab(me.getTab('Prop').loadData(value.tabProp), true);
			}
			me.setTabsAccess(value.Tabs);
			if (callBack) callBack();
		});
	}
});