﻿Ext.define('Keysystems.SRNorm.Edit', {
	extend: 'Keysystems.Base.Edit',
	createItems: function() {
		var me = this,
			objs = me.objs,
			minText = 'Минимальное значение 0',
			items = [
				objs.VAL = Ext.create('Keysystems.Controls.CalcField', {
					fieldLabel: 'Значение',
					labelWidth: me.labelWidth,
					maxWidth: 300,
					minVal: 0
				}),
				//objs.VAL = Ext.create('Ext.form.field.Number', {
				//	fieldLabel: 'Значение',
				//	labelWidth: me.labelWidth,
				//	value: 0,
				//	minValue: 0,
				//	minText: minText,
				//	negativeText: minText
				//}),
				objs.UNIT = Ext.create('Ext.form.field.ComboBox', {
					fieldLabel: 'Ед. измерения',
					labelWidth: me.labelWidth,
					editable: false,
					maxWidth: 300,
					store: Ext.create('Ext.data.Store', {
						fields: [
							{ name: 'index', type: 'int' },
							{ name: 'value', type: 'string' }
						],
						data: CBDataLib.get('RNormUnitType')
					}),
					displayField: CBDataLib.displayField,
					valueField: CBDataLib.valueField,
				}),
				objs.S_ST = me.createDictEdit({
					mode: 'MULTI',
					code: dnl.S_ST,
					labelWidth: me.labelWidth,
					fieldLabel: 'КОСГУ',
				})
			];

		me.isCodeEdit = true;
		me.codeEditCfg = { maxLength: 10, enforceMaxLength: true };
		me.isNameEdit = true;
		me.nameEditCfg = { maxLength: 100, enforceMaxLength: true };
		me.isDHEdit = true;

		return me.callParent([items]);
	},
	dataCollector: function() {
		var me = this,
			objs = me.objs,
			data = me.callParent(arguments);
		data.val = objs.VAL.getValue() || 0;
		data.unit = objs.UNIT.getValue();
		data.S_ST = objs.S_ST.getLinks(1);
		return data;
	},
	getExtra: function(endFunc, link) {
		var me = this,
			objs = me.objs;
		me.baseGetExtra({ link: link }, function(value) {
			me.autoFillControl(value.row);
			objs.VAL.setValue(value.row.VAL);
			objs.UNIT.setValue(value.row.UNIT || 0);
			objs.S_ST.setValue(value.S_ST);
			if (endFunc) endFunc();
		});
	}
});