﻿Ext.define('Keysystems.SProp.Edit', {
	extend: 'Keysystems.Base.Edit',
	isDHEdit: true,

	createItems: function() {
		var me = this,
			objs = me.objs,
			items = [
				Ext.create('Ext.form.FieldContainer', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Тип',
					ksAllowEmpty: true,
					width: me.width,
					layout: 'hbox',
					items: [
						objs.TYPE = Ext.create('Ext.form.field.ComboBox', {
							editable: false,
							store: Ext.create('Ext.data.Store', {
								fields: CBDataLib.getFields(),
								data: CBDataLib.get('CalcType'),
								proxy: 'memory'
							}),
							displayField: 'value',
							valueField: 'index',
							value: 0,
							width: 120,
							listeners: {
								change: function(th, val) {
									var t = miscTypes.CalcType[val];
									objs.DICT.setVisible(t === 'Справочник');
									objs.COND.setVisible(t === 'Справочник');
									objs.LIST.setVisible(t === 'Список');
								}
							}
						}),
						objs.DICT = Ext.create('Keysystems.Controls.DictName.Edit', {
							flex: 4,
							padding: '0 0 0 10',
							hidden: true,
							handler: function() {
								dictFunc({
									mode: 'SINGL',
									parentView: objs.view,
									whereArgs: { DictOnly: { value: 'True', type: 'bool' } },
									selectLinks: objs.DICT.getValue(),
									code: dnl.S_TABLELIST,
									readOnly: objs.DICT.readOnly,
									control: objs.DICT,
									contextSearch: objs.DICT.contextSearch
								}, {
									ok: function(value) {
										let val = value.length ? value[0].data || value[0] : null,
											v = value.length 
												? [{ data: { LINK: val.LINK, NAME: val.NAME, CODE: val.OBJCODE } }] 
												: null;
										objs.DICT.setValue(v);
									}
								});
							}
						}),
						objs.LIST = Ext.create('Ext.form.field.Text', {
							flex: 4,
							padding: '0 0 0 10',
							hidden: true,
							triggers: {
								dict: {
									cls: 'x-dict-trigger x_btn_keysystems',
									handler: function () {
										let editor = Ext.create('RevizorListEditor', {
											list: objs.LIST.list,
											okFunc: function(list) {
												objs.LIST.setValue(list);
												objs.LIST.list = list;
											}
										});
										editor.show();
									}
								}
							}							
						})
					]
				}),
				objs.COND = Ext.create('Keysystems.Controls.Formula.Edit', {
					labelWidth: me.labelWidth,
					hidden: true,
					fieldLabel: 'Условие фильтра',
					width: me.width
				}),
				objs.COMMENT = Ext.create('Ext.form.field.TextArea', {
					fieldLabel: 'Примечание',
					labelWidth: me.labelWidth,
					width: me.width,
					height: 100
				}),
				objs.READONLY = Ext.create('Ext.form.field.Checkbox', {
					labelWidth: me.labelWidth,
					boxLabel: 'Только на чтение',
					padding: '0 0 0 155'
				})
			];

		me.codeEditCfg = {
			maxLength: 40,
			enforceMaxLength: true,
			fieldLabel: 'Ключевое слово'
		};
		me.isCodeEdit = true;
		me.isNameEdit = true;
		me.nameEditCfg = { maxLength: 150, enforceMaxLength: true };

		return me.callParent([items]);
	},

	isFilled: function() {
		const me = this;
		const objs = me.objs;
		let res = me.callParent(arguments);

		switch (miscTypes.CalcType[objs.TYPE.getValue()]) {
			case 'Список':
				if (!objs.LIST.list || !objs.LIST.list.length) {
					me.addToInvalidControls(objs.LIST, {title: 'Список'});
					res = false;
				}
				break;
			case 'Справочник':
				const dict = objs.DICT.getValue();
				if ((!dict.length) || (!dict[0].data.LINK)) {
					me.addToInvalidControls(objs.DICT, {title: 'Справочник'});
					res = false;
				}
				break;
		}
		return res;
	},
	dataCollector: function() {
		var me = this,
			objs = me.objs,
			type = objs.TYPE.getValue(),
			list = null,
			dict = '';


		switch (miscTypes.CalcType[type]) {
		case 'Справочник':
			dict = objs.DICT.getValue();
			dict = dict.length ? dict[0].data.CODE : '';
			list = objs.COND.getValue();
			break;
		case 'Список':
			list = objs.LIST.list;
			break;
		}

		var data = me.callParent([false]);
		data.type = type;
		data.list = list || "";
		data.dict = dict;
		data.comment = objs.COMMENT.getValue();
		data.READONLY = objs.READONLY.getValue();
		
		return data;
	},
	getExtraNew: function(callBack) { if (callBack) callBack(); },
	getExtra: function(endFunc) {
		var me = this,
			data = me.data.data;

		me.baseGetExtra({
			link: me.getLink(),
			linkSelf: data.LINK_SELF || 0,
			dict_code: data.DICT_CODE
		}, function(value) {
			
			me.objs.DICT.setValue(value.dict);
			me.objs.READONLY.setValue(value.row.READONLY);
			me.objs.TYPE.setValue(value.row.TYPE);
			me.objs.COMMENT.setValue(value.row.COMMENT);

			if (value.list) {
				switch (miscTypes.CalcType[value.row.TYPE]) {
				case 'Справочник':
					me.objs.COND.setValue(value.list);
					break;
				case 'Список':
					me.objs.LIST.setValue(me.objs.LIST.list = value.list);
					break;
				}
			}

			me._setDh(me.objs.DH, value.row.DH1, value.row.DH2);
			me.sksd('STAMP', value.row.STAMP);

			if (endFunc) {
				endFunc();
			}
		});
	},

	viewCfg: function() {
		var result = this.callParent(arguments);
		result.resizable = true;
		result.minWidth = 600;
		result.minHeight = 360;
		return result;
	},
});