﻿Ext.define('Keysystems.SPlan.Edit', {
	extend: 'Keysystems.Base.Edit',
	bodyPadding: 0,
	
	//конфигурация основного окна
	viewCfg: function() {
		var result = this.callParent(arguments);
		result.resizable = true;
		result.minWidth = 600;
		result.minHeight = 220;
		return result;
	},
	
	createItems: function() {
		var me = this;
		return me.objs.allTab = Ext.create('Ext.tab.Panel', {
			plain: true,
			border: 0,
			flex: 1,
			userCls: me.basePanelCls,
			bodyCls: me.basePanelBodyCls,
			items: me.objs.items = [me.getTab('General')]
		});
	},

	//конструктор таба Общие
	createTabGeneral: function() {
		var me = this,
			objs = me.objs;

		objs.tabGeneral = Ext.create('Ext.panel.Panel', {
			title: 'Общие',
			layout: { type: 'vbox', align: 'stretch' },
			flex: 1,
			border: 0,
			bodyPadding: 10,
			items: [
				Ext.create('Ext.form.FieldContainer', {
					layout: { type: 'vbox', align: 'stretch' },
					padding: me.bodyPadding,
					items: [
						me.createCodeEdit({ maxLength: 10 }),
						me.createNameEdit({ maxLength: 250 }),
						objs.CONFIRM = Ext.create('Ext.form.Checkbox', {
							labelWidth: me.labelWidth,
							fieldLabel: 'Утверждаемый'
						}),
						me.createDHEdit({ maxWidth: 400 })
					]
				})				
			]
		});

		return objs.tabGeneral;
	},

	//конструктор таба Реквизиты
	createTabProp: function() {
		var me = this,
			objs = me.objs;

		return objs.tabProp = Ext.create('Keysystems.Panel.Prop', {
			border: 0,
			parentView: me,
			decimalData: me.gksd('decimalData')
		});
	},
	
	dataCollector: function() {
		var me = this,
			objs = me.objs;

		me.isCodeEdit = true;
		me.isNameEdit = true;
		me.isDHEdit = true;

		var data = me.callParent([false]);
		data.confirm = objs.CONFIRM.getValue() ? 1 : 0;
		data.prop = objs.isTabProp ? me.getTab('Prop').getData(1) : _;
		
		return data;
	},
	
	getExtra: function(endFunc, link) {
		var me = this,
			objs = me.objs;

		me.baseGetExtra({ link: link }, function(value) {
			var row = value.row;
			me.sksd('decimalData', value.decimalData);
			me._setDh(objs.DH, row.DH1, row.DH2);
			me.setCodeValue(row.CODE);
			objs.NAME.setValue(row.NAME);
			objs.CONFIRM.setValue(row.CONFIRM);			

			if (value.tabProp) {
				objs.isTabProp = true;
				objs.allTab.changeTab(me.getTab('Prop').loadData(value.tabProp), true);
			}
			me.setTabsAccess(value.Tabs);
			if (endFunc) endFunc();
		});
	}
});