﻿Ext.define('Keysystems.Edits.Person', {
	extend: 'Keysystems.Base.Edit',
	otdelSettings: { tabMode: true, closable: false },
	outLink: -1,
	contractLink: -1,

	viewMinSize: [600, 500],
	bodyPadding: 0,
	profileListeners: [{ name: 'view', method: 'FormParam' }],

	createItems: function () {
		let me = this;
		return me.objs.allTab = Ext.create('Ext.tab.Panel', {
			plain: true,
			border: 0,
			flex: 1,
			userCls: me.basePanelCls,
			bodyCls: me.basePanelBodyCls,
			items: this.objs.items = []
		})
	},

	filledInSurNumber: function () {
		var v = this.objs.INSURNUMBER.getValue();
		if (v) {
			//Длинна Страхового номера должна быть 14 символов
			if (v.length < 14) return false;

			var sv = v.split(' '),
				nv = sv[0].replace(/-/g, ''),
				cv = sv[1];

			//Проверка контрольного числа Страхового номера проводится только для номеров больше номера 001-001-998
			if (nv * 1 < 1001998) return true;

			var cv0 = 0;
			//Каждая цифра СНИЛС умножается на номер своей позиции (позиции отсчитываются с конца)
			//Полученные произведения суммируются
			for (var i = 0; i < 9; i++) cv0 += nv[i] * (9 - i);

			//Если сумма больше 101, то сумма делится по остатку на 101 и контрольное число определяется остатком от деления
			cv0 %= 101;

			//Если сумма меньше 100, то контрольное число равно самой сумме
			if (cv0 === 100) cv0 = 0;

			return cv == cv0;
		}
		return true;
	},

	saveData: function (endFunc, inputParams) {
		var me = this,
			objs = me.objs;
		if (!(objs.notCheckInSurNumber || me.filledInSurNumber())) {
			selectDialogShow(KS.L10n.attention, wmc.get('SnilsError'), function () {
				objs.notCheckInSurNumber = true;
				me.saveData(endFunc, inputParams);
			});
			return;
		}
		delete objs.notCheckInSurNumber;
		this.callParent(arguments);
	},

	isFilled: function () {
		const me = this;
		const objs = me.objs;
		let res = true;
		for (let key in objs.ksAllowEmpty) {
			if (objs[key] && !objs[key].isHidden() && objs[key].ksAllowEmpty && objs[key].isEmpty()) {
				me.addToInvalidControls(objs[key], {parent: objs.allTab, tab: me.getTab('General')});
				res = false;
			}
		}

		me.isHistoryFilled();

		if (me.getTabVisible('Out')) {
			if (objs.PERSON_OUT.store.getDataExt().filter(r=>!r.DT1 || !r.DT2).length) {
				me.addToInvalidControls(objs.PERSON_OUT, {title: 'Период отсутствия', parent: objs.allTab, tab: me.getTab('Out')});
				res = false;
			}
		}
		return res;
	},

	//#region Общие

	//конструктор таба Общие
	createTabGeneral: function () {
		var me = this,
			objs = me.objs;

		return objs.tabGeneral = Ext.create('Ext.panel.Panel', {
			title: 'Общие',
			layout: { type: 'vbox', align: 'stretch' },
			bodyPadding: 10,
			flex: 1,
			border: 0,
			items: [
				Ext.create('Ext.panel.Panel', {
					layout: { type: 'hbox', align: 'stretch' },
					border: 0,
					padding: '0 0 5 0',
					items: [
						objs.CODE = Ext.create('Ext.form.field.Text', {
							maxLength: 20,
							fieldLabel: 'Табельный номер',
							ksAllowEmpty: true,
							labelWidth: me.labelWidth,							
							enforceMaxLength: true
						}),
						'->',
						me.createDictEdit({
							key: 'USERID',
							mode: 'SINGL',
							code: dnl.S_LOGIN,
							labelWidth: 120,
							fieldLabel: 'Пользователь БД',
							width: 250,
							className: 'Keysystems.Controls.DictCode.Edit',
							whereArgs: {
								IncludeGroups: { value: 'False', type: 'bool' },
								MarkBusy: { value: 'True', type: 'bool' },
								IgnoreHierarchy: { value: 'True', type: 'bool' }
							}
						})
					]
				}),
				objs.LASTNAME = Ext.create('Ext.form.field.Text', {
					maxLength: 100,
					enforceMaxLength: true,
					fieldLabel: 'Фамилия',
					ksAllowEmpty: true,
					labelWidth: me.labelWidth,					
					listeners: {
						blur: function (t, ev) {
							//выставляем пол человека, если он не выбран
							if (objs.SEX != null && objs.SEX.getValue() == null) {
								var gender = null;
								if (t.value.length > 4) {
									var chech4letter = t.value.substring(t.value.length - 4).toUpperCase();
									switch (chech4letter) {
										case 'ЦКИЙ':
										case 'СКИЙ':
										case 'ЦКОЙ':
										case 'СКОЙ':
											gender = 'М';
											break;
										case 'ЕКАЯ':
										case 'ЦКАЯ':
											gender = 'Ж';
											break;
									}
								}
								if (t.value.length > 3 && gender == null) {
									var chech3letter = t.value.substring(t.value.length - 3).toUpperCase();
									switch (chech3letter) {
										case 'ОВА':
										case 'ЕВА':
										case 'ИНА':
											gender = 'Ж';
											break;
									}
								}
								if (t.value.length > 2 && gender == null) {
									var chech2letter = t.value.substring(t.value.length - 2).toUpperCase();
									switch (chech2letter) {
										case 'ОВ':
										case 'ЕВ':
										case 'ЁВ':
										case 'ИН':
										case 'ИЙ':
										case 'ЫН':
										case 'ЫЙ':
										case 'ОЙ':
											gender = 'М';
											break;
										case 'АЯ':
										case 'ВА':
										case "НА":
										case 'ЯЯ':
											gender = 'Ж';
											break;
									}
								}

								if (gender != null)
									objs.SEX.setValue(gender);
							}
							//обновим ФИО в актуальной записи истории
							me.refreshHistFIO('LASTNAME');
						},
						scope: this
					}
				}),
				objs.FIRSTNAME = Ext.create('Ext.form.field.Text', {
					maxLength: 30,
					enforceMaxLength: true,
					fieldLabel: 'Имя',
					ksAllowEmpty: true,
					labelWidth: me.labelWidth,
					listeners: {
						blur: function () {
							me.refreshHistFIO('FIRSTNAME');
						}
					}
				}),
				objs.PATRONYMIC = Ext.create('Ext.form.field.Text', {
					maxLength: 30,
					enforceMaxLength: true,
					fieldLabel: 'Отчество',
					ksAllowEmpty: true,
					labelWidth: me.labelWidth,
					listeners: {
						blur: function (t, ev) {
							if (objs.SEX != null && objs.SEX.getValue() == null) {
								var gender = null;
								if (t.value.length > 4) {
									var chech4letter = t.value.substring(t.value.length - 4).toUpperCase();
									switch (chech4letter) {
										case 'ОГЛЫ':
											gender = 'М';
											break;
										case 'КЫЗЫ':
											gender = 'Ж';
											break;
									}
								}
								if (t.value.length > 3 && gender == null) {
									var chech3letter = t.value.substring(t.value.length - 3).toUpperCase();
									switch (chech3letter) {
										case 'ВНА':
										case 'ЧНА':
											gender = 'Ж';
											break;
										case 'ВИЧ':
											gender = 'М';
											break;
									}
								}

								if (gender != null)
									objs.SEX.setValue(gender);
							}
							me.refreshHistFIO('PATRONYMIC');
						}
					}
				}),
				objs.BIRTHDAY = Ext.create('Ext.form.field.Date', {
					fieldLabel: 'Дата рождения',
					labelWidth: me.labelWidth,
					maxWidth: 150 + me.labelWidth,
					minValue: longPeriod.begin,
					maxValue: longPeriod.end
				}),
				objs.BIRTHPLACE = Ext.create('Ext.form.field.Text', {
					maxLength: 254,
					enforceMaxLength: true,
					labelWidth: me.labelWidth,
					fieldLabel: 'Место рождения'
				}),
				objs.PASSPORT = Ext.create('Ext.form.field.Text', {
					maxLength: 500,
					enforceMaxLength: true,
					labelWidth: me.labelWidth,
					fieldLabel: 'Паспортные данные'
				}),
				objs.INN = Ext.create('Ext.form.field.Text', {
					maxLength: 12,
					enforceMaxLength: true,
					labelWidth: me.labelWidth,
					fieldLabel: 'ИНН'
				}),
				objs.INSURNUMBER = Ext.create('Ext.form.field.Text', {
					maxLength: 20,
					enforceMaxLength: true,
					labelWidth: me.labelWidth,
					fieldLabel: 'Страховое свидетельство',
					maxWidth: 150 + me.labelWidth,
					listeners: {
						afterrender: function () { if (this.inputEl) $(this.inputEl.dom).mask('000-000-000 00'); },
						blur: {
							buffer: 250,
							fn: function () {
								//Дозапись контрольного числа
								var v = this.getValue(),
									len = v.length;
								if (len < 14 && len > 10) {
									switch (len) {
										case 11:
											v += ' 00';
											break;
										case 12:
											v += '00';
											break;
										case 13:
											v += '0';
											break;
									}
									this.setValue(v);
								}
							}
						}
					}
				}),
				objs.SEX = Ext.create('Keysystems.Controls.ComboBoxExtra', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Пол',
					editable: false,
					value: null,
					store: Ext.create('Ext.data.Store', {
						fields: [{ name: CBDataLib.valueField, type: 'string', useNull: true }, { name: CBDataLib.displayField, type: 'string' }],
						data: CBDataLib.get('', 1, { М: 'М', Ж: 'Ж' }),
						proxy: 'memory'
					}),
					queryMode: 'local',
					displayField: CBDataLib.displayField,
					valueField: CBDataLib.valueField,
					maxWidth: 75 + me.labelWidth
				}),
				me.createDictEdit({
					key: 'S_ADR',
					mode: 'SINGL',
					code: dnl.S_ADR,
					labelWidth: me.labelWidth,
					fieldLabel: 'Адрес (юр.)',
					className: 'Keysystems.Controls.DictName.Edit',
					cleaningKey: false,
					ksSetValue(value) {
						this.setValue(value);
						var newCls = value && value.LINK ? 'x-dict-trigger x_btn_edit' : 'x-dict-trigger x_btn_new',
							trig = objs.S_ADR.fieldName;
						if (trig.triggers && trig.triggers.trigger2) {
							var el = trig.triggers.trigger2;
							if (el.el) {
								el.el.removeCls(el.cls);
								el.el.addCls(el.cls = newCls);
							}
							el.cls = newCls;
						}
					}
				},
					function(o) {
						o.handler = [
							{
								handler: function () {
									if (!objs.S_ADR.readOnly) objs.S_ADRF.setValue(objs.S_ADR.getValue());
								},
								cls: 'x-dict-trigger x_btn_bottom'
							},
							{
								handler: function() {
									if (objs.S_ADR.readOnly) return;
									var link = objs.S_ADR.getLink(),
										cfg = {
											f: link ? 'edit' : 'new',
											link: link,
											data: { data: { LINK: link } },
											code: dnl.S_ADR,
											parentView: me.objs.view,
											readOnly: me.getTab('General').ksReadOnly,
											refreshFunc: function() { me.refresh(); },
											updRecord: function(rec) {
												objs.S_ADR.ksSetValue(rec);
												// обновим Адрес (факт.), если там такая же запись
												if (objs.S_ADRF.getLink() === rec.LINK) {
													objs.S_ADRF.ksSetValue(rec);
												}
											},
											addRecord: Ext.emptyFn
										};
									Ext.apply(cfg, dictListController.DICTIONARY_SADR);
									Ext.create(cfg.editClass, cfg);
								},
								cls: 'x-dict-trigger x_btn_new'
							}
						];
						return o;
					}
				),
				me.createDictEdit({
					key: 'S_ADRF',
					mode: 'SINGL',
					code: dnl.S_ADR,
					labelWidth: me.labelWidth,
					fieldLabel: 'Адрес (факт.)',
					className: 'Keysystems.Controls.DictName.Edit',
					cleaningKey: false,
					ksSetValue(value) {
						this.setValue(value);
						var newCls = value && value.LINK ? 'x-dict-trigger x_btn_edit' : 'x-dict-trigger x_btn_new',
							trig = objs.S_ADRF.fieldName;
						if (trig.triggers && trig.triggers.trigger1) {
							var el = trig.triggers.trigger1;
							if (el.el) {
								el.el.removeCls(el.cls);
								el.el.addCls(el.cls = newCls);
							}
							el.cls = newCls;
						}
					}
				},
					function(o) {
						o.handler = [
							{
								handler: function() {
									if (objs.S_ADRF.readOnly) return;
									var link = objs.S_ADRF.getLink(),
										cfg = {
											f: link ? 'edit' : 'new',
											data: { data: { LINK: link } },
											code: dnl.S_ADR,
											parentView: me.objs.view,
											refreshFunc: function() { me.refresh(); },
											updRecord: function(rec) {
												objs.S_ADRF.ksSetValue(rec);
												// обновим Адрес (юр.), если там такая же запись
												if (objs.S_ADR.getLink() === rec.LINK) {
													objs.S_ADR.ksSetValue(rec);
												}
											},
											addRecord: Ext.emptyFn
										};
									Ext.apply(cfg, dictListController.DICTIONARY_SADR);
									Ext.create(cfg.editClass, cfg);
								},
								cls: 'x-dict-trigger x_btn_OPEN'
							}
						];
						return o;
					}),
				objs.PHONE = Ext.create('Ext.form.field.Text', {
					maxLength: 20,
					enforceMaxLength: true,
					labelWidth: me.labelWidth,
					fieldLabel: 'Телефон'
				})
			]
		});
	},
	
	getExtraGeneral: function(value) {
		var me = this,
			objs = me.objs,
			row = value.row,
			access = row._Access,
			maxLen = row._MaxLength;

		objs.S_ADR.visibleFields = value.adrVf;
		objs.S_ADRF.visibleFields = value.adrVf;
		
		objs.S_ADR.ksSetValue(value.S_ADR);
		objs.S_ADRF.ksSetValue(value.S_ADRF);
		
		Ext.each(me._arr, function(key) {
			var c = me.gksc(key) || objs[key];
			if (c) {
				if (maxLen[key] > 0) c.maxLength = maxLen[key];
				c.setVisible(c.ksAccessEdit = (access[key] || access[key] === _));
				c.setValue(row[key]);
			}
		});

		if (user.isAdmin) {
			objs.USERID.show();
			me.setObjsValuesAndAccess(value, row._Access, ['USERID']);
		} else {
			objs.USERID.hide();
		}

		objs.ksAllowEmpty = value.ksAllowEmpty;
		for (var key in value.ksAllowEmpty) {
			if (objs[key]) {
				objs[key].setKsAllowEmpty(!value.ksAllowEmpty[key]);
				if (!value.ksAllowEmpty[key]){
					objs[key].allowBlank = false;
					objs[key].blankText = wmc.get('Input', objs[key].fieldLabel);
				}
			}
		}
	},

	//#endregion Общие

	//#region История

	//конструктор таба История
	createTabHistory: function () {
		var me = this,
			objs = me.objs,
			histLink = -1; 
			
		return objs.tabHistory = Ext.create('Ext.panel.Panel', {
			title: 'История',			
			layout: { type: 'vbox', align: 'stretch' },
			border: 0,
			items: [
				objs.gridHistory = Ext.create('Ext.grid.Panel',
					{
						flex: 1,
						border: 0,
						store: objs.storeHistory = Ext.create('Ext.data.Store',
							{
								fields: [],
								data: [],
								proxy: 'memory',
								listeners: {
									update: function () {
										if (objs.gridHistory) {
											if (!me.isLoaded) me.showHideMixColumn();
										}
									},
									datachanged: function () {
										if (objs.gridHistory) {
											if (!me.isLoaded) me.showHideMixColumn();
										}
									}
								}
							}),
						columns: [],
						plugins: [
							Ext.create('Ext.grid.plugin.CellEditing',
								{
									clicksToEdit: 1,
									isDhSwap: true,
									listeners: {
										validateedit: async function (editor, e) {
											if (e.record.data.isControl && (e.field === "DH1" || e.field === "DH2" || e.field === "MIX")) {
												const mix = e.field === "MIX" ? e.value : e.record.data.MIX;
												const isOldCurrent = me.isCurrentDates(e.record.data.DH1, e.record.data.DH2) && e.record.data.isControl;
												const isNewCurrent = !mix && me.isCurrentDates(e.field === "DH1" ? e.value : e.record.data.DH1, e.field === "DH2" ? e.value : e.record.data.DH2) && e.record.data.isControl;

												if (isOldCurrent && !isNewCurrent) {
													const res = await me.showMessagePersonOtdel(true, false);
													if (!res) {
														e.record.set(e.field, e.originalValue);
														e.cancel = true;
														return false;
													}
													me.showHidePersonOtdels();
												}
											}
											return true;
										},
										beforeedit: function (_, e) {
											//в firefox когда ячейка переходит в режим редактирования, строка не всегда становится активной
											if (!e?.record) return;
											objs.gridHistory.getSelectionModel().select(e.record);
										}

									}
								}),
							'gridclipboard'
						],
						tbar: [
							Ext.create('Ext.Button',
								{
									key: 'new',
									iconCls: 'x_btn_new',
									tooltip: 'Создать',
									tooltipType: 'title',
									handler: async function () {
										
										addHist(me.getHistTable(),
											async function (hist) {
												var store = objs.storeHistory;
												
												//если 1) закрываем историю, попадающую в текущий период, 2) орг-я была проверяющей и 3) были заданы кур-ие подразделения, 
												// то выводим запрос о необходимости удаления кур-ые подразделения
												const curHist = hist.filter(h => !h.LINK && me.isCurrentDates(h.DH1, h.DH2))[0];
												if (curHist && me.getCurrentOrgsP().length){
													const res = await me.showMessagePersonOtdel(true, false);
													if (!res) return;
												}
												store.each(function (rec) {
													var pos = ArrayLib.find(hist, ['LINK'], rec.data.LINK);
													if (pos !== -1) {
														rec.set('DH1', hist[pos].DH1);
														rec.set('DH2', hist[pos].DH2);
														hist.splice(pos, 1);
													}
												});

												
												var sel;
												me.inAddHist = true;
												Ext.each(hist,
													function (h) {
														h.LINK = histLink--;
														
														sel = store.add(h);
														var rec = sel && sel.length > 0 ? sel[0] : null;

														if (rec) {
															rec.set('LASTNAME', objs.LASTNAME.getValue());
															rec.set('FIRSTNAME', objs.FIRSTNAME.getValue());
															rec.set('PATRONYMIC', objs.PATRONYMIC.getValue());

															if (objs.sOrg) {
																rec.set('S_ORG', objs.sOrg.LINK);
																rec.set('S_ORG_CODE', objs.sOrg.CODE);
																rec.set('S_ORG_NAME', objs.sOrg.NAME);
															}
														}

													});
												if (sel) objs.gridHistory.getSelectionModel().select(sel);
												me.inAddHist = false;
												me.showHidePersonOtdels();
											});
									}
								}),
							Ext.create('Ext.Button',
								{
									key: 'copy',
									iconCls: 'x_btn_copy',
									tooltip: 'Создать подобную',
									tooltipType: 'title',
									handler: function () {
										var r = objs.panelEditHistory.activRec;
										if (!r) return;

										addHist(me.getHistTable(),
											function (hist) {
												me.inAddHist = true;
												var store = objs.storeHistory;
												store.each(function (rec) {
													var pos = ArrayLib.find(hist, ['LINK'], rec.data.LINK);
													if (pos !== -1) {
														rec.set('DH1', hist[pos].DH1);
														rec.set('DH2', hist[pos].DH2);
														hist.splice(pos, 1);
													}
												});
												var sel;
												Ext.each(hist,
													function (h) {
														let d = {};
														Object.assign(d, r.getData());
														delete d.id;
														d.LINK = histLink--;
														d.DH1 = h.DH1;
														d.DH2 = h.DH2;
														d.SWork = r.data.SWork
															? JSON.parse(JSON.stringify(r.data.SWork))
															: [];

														sel = store.add(d);
													});
												objs.gridHistory.view.refresh();
												if (sel) objs.gridHistory.getSelectionModel().select(sel);
												me.inAddHist = false;
											});

									}
								}),
							Ext.create('Ext.Button',
								{
									key: 'delete',
									iconCls: 'x_btn_delete',
									tooltip: 'Удалить',
									tooltipType: 'title',
									handler: async function () {
										const sel = objs.gridHistory.getFrstSelect();
										if (!sel) return;

										const resDel = await selectDialogShowAsync(wmc.get('Deleting'), wmc.get('DeleteMessage', sel));
										if (resDel !== "yes") return;

										//если 1) удаляем историю, попадающую в текущий период, 2) орг-я была проверяющей 
										// то выводим запрос о необходимости удаления кур-ые подразделения
										if (me.isCurrentDates(sel.data.DH1, sel.data.DH2) && sel.data.isControl) {
											const res = await me.showMessagePersonOtdel(true, false);
											if (!res) return false;
										}
										objs.gridHistory.getStore().remove(sel);
										me.showHidePersonOtdels();
									}
								})
						],
						columnLines: true,
						allowDeselect: false, // необходимо, чтобы не терялся selected при перекликивании между эдиторами одной строки
						listeners: {
							selectionchange: function (_, sels) {
								objs.panelEditHistory.setDisabled(!sels.length);
								me.enableToolsGrid(objs.gridHistory, sels);
							},
							select: function (th1, rec) {
								objs.panelEditHistory.setRecord(rec);
							}
						}
					}),
				objs.panelEditHistory = Ext.create('Ext.panel.Panel', {
					layout: { type: 'vbox', align: 'stretch' },
					bodyPadding: 10,
					disabled: true,
					setRecord: function (rec) {
						this.activRec = rec;
						objs.S_ORG.ksSetValue({
							LINK: rec.data.S_ORG,
							CODE: rec.data.S_ORG_CODE,
							NAME: rec.data.S_ORG_NAME
						});
						objs.S_OTDEL.ksSetValue({
							LINK: rec.data.S_OTDEL,
							CODE: rec.data.S_OTDEL_CODE,
							NAME: rec.data.S_OTDEL_NAME
						});
						objs.S_DOLG.ksSetValue({
							LINK: rec.data.S_DOLG,
							CODE: rec.data.S_DOLG_CODE,
							NAME: rec.data.S_DOLG_NAME
						});
						objs.S_RANG.ksSetValue({
							LINK: rec.data.S_RANG,
							CODE: rec.data.S_RANG_CODE,
							NAME: rec.data.S_RANG_NAME
						});
						objs.S_WORK.setVisible(rec.data.isControl);
						objs.S_WORK.ksSetValue(rec.data.SWork);
						objs.HIST_LASTNAME.setValue(rec.data.LASTNAME);
						objs.HIST_FIRSTNAME.setValue(rec.data.FIRSTNAME);
						objs.HIST_PATRONYMIC.setValue(rec.data.PATRONYMIC);
					},
					items: [
						me.createDictEdit({
							key: 'S_ORG',
							mode: 'SINGL',
							disabled: objs.sOrg,
							labelWidth: me.labelWidth,
							fieldLabel: 'Организация',
							code: dnl.S_ORG,
							clear: function () { this.setValue(); },
							ksSetValue: async function (value) {
								const sel = objs.panelEditHistory.activRec;
								
								const linkOld = +sel.data.S_ORG || 0;
								if (value && !Array.isArray(value)) value = [value];
								const linkNew = value ? +(value[0].data || value[0]).LINK : 0;

								//проставим признак контролирующей организации, если не задан
								const rHist = me.objs.gridHistory.getStore().getDataExt().filter(r=>r.S_ORG === linkNew)[0];
								let isControl = rHist ? rHist.isControl : null;
								if (isControl === null  || isControl === undefined) {
									isControl = await ajaxRequestAsync({
										url: 'SOrg/IsControl_A',
										params: {link: linkNew}
									});
								}
								
								//если 1) поменяли орг-ию, 2) запись истории, попадает в текущий период, 3) пред-я орг-я была проверяющей 
								//то выводим запрос о необходимости удаления кур-ые подразделения
								if (!me.isLoaded && linkOld !== linkNew && !me.inAddHist &&
									me.isCurrentDates(sel.data.DH1, sel.data.DH2) && sel.data.isControl) {
									const res = await me.showMessagePersonOtdel(true, false);
									if (!res) return false;
								}
								
								this.setValue(value);
								let v = this.getValue(),
									rec = objs.panelEditHistory.activRec;

								if (v.length) {
									v = v[0].data || v[0];
								} else {
									v = { LINK: 0 };
								}

								if (rec) {
									rec.set('S_ORG', v.LINK);
									rec.set('S_ORG_CODE', v.CODE);
									rec.set('S_ORG_NAME', v.NAME);
									rec.set('isControl', isControl);
								}

								const emptyOrg = this.isEmpty();
								if (emptyOrg) {
									objs.S_OTDEL._clear();
									objs.S_DOLG._clear();
								}
								objs.S_OTDEL.setDisabled(emptyOrg);
								objs.S_DOLG.setDisabled(emptyOrg);
								objs.S_WORK.setVisible(!emptyOrg && isControl);
								if (linkOld !== linkNew) me.showHidePersonOtdels();
							}
						}),
						me.createDictEdit({
							key: 'S_OTDEL',
							mode: 'SINGL',
							labelWidth: me.labelWidth,
							fieldLabel: 'Подразделение',
							code: dnl.S_OTDEL,
							listCfg: {
								getSOrg: function () { return objs.S_ORG.getLink(); }
							},
							clear: function () { this.ksSetValue(); },
							initWhereArgs: function () { return { SOrgs: { value: objs.S_ORG.getLinks(1), type: 'List_int' } }; },
							ksSetValue: function (value) {
								this.setValue(value);
								var v = this.getValue(),
									rec = objs.panelEditHistory.activRec;
								if (v.length) {
									v = v[0].data || v[0];
								} else {
									v = { LINK: 0 };
								}

								rec.set('S_OTDEL', v.LINK);
								rec.set('S_OTDEL_CODE', v.CODE);
								rec.set('S_OTDEL_NAME', v.NAME);
							}
						}),
						me.createDictEdit({
							key: 'S_DOLG',
							mode: 'SINGL',
							labelWidth: me.labelWidth,
							fieldLabel: 'Должность',
							code: dnl.S_DOLG,
							clear: function () { this.ksSetValue(); },
							listCfg: {
								edit: function (f, data, defCfg) {
									return this.callParent([f, data, Ext.apply(defCfg || {}, {
										dataCollector: function () {
											var result = this.callParent(arguments);
											result.SOrg = objs.S_ORG.getLink() || 0;
											return result;
										}
									})]);
								}
							},
							initWhereArgs: function () { return { SOrg: { value: objs.S_ORG.getLink() || 0, type: 'int' } }; },
							ksSetValue: function (value) {
								this.setValue(value);
								var v = this.getValue(),
									rec = objs.panelEditHistory.activRec;
								if (v.length) {
									v = v[0].data || v[0];
								} else {
									v = { LINK: 0 };
								}

								rec.set('S_DOLG', v.LINK);
								rec.set('S_DOLG_CODE', v.CODE);
								rec.set('S_DOLG_NAME', v.NAME);
							}
						}),
						me.createDictEdit({
							key: 'S_RANG',
							mode: 'SINGL',
							labelWidth: me.labelWidth,
							fieldLabel: 'Классный чин',
							code: dnl.S_RANG,
							clear: function () { this.ksSetValue(); },
							ksSetValue: function (value) {
								this.setValue(value);
								var v = this.getValue(),
									rec = objs.panelEditHistory.activRec;
								if (v.length) {
									v = v[0].data || v[0];
								} else {
									v = { LINK: 0 };
								}

								rec.set('S_RANG', v.LINK);
								rec.set('S_RANG_CODE', v.CODE);
								rec.set('S_RANG_NAME', v.NAME);
							}
						}),
						me.createDictEdit({
							key: 'S_WORK',
							mode: 'MULTI',
							labelWidth: me.labelWidth,
							fieldLabel: 'Виды работ',
							code: dnl.S_WORK,
							clear: function () { this.ksSetValue(); },
							ksSetValue: function (value) {
								this.setValue(value);
								objs.panelEditHistory.activRec.data.SWork = this.getValue();
							}
						}),
						Ext.create('Ext.form.FieldContainer', {
							layout: { type: 'hbox', align: 'stretch' },
							items: [
								objs.HIST_LASTNAME = Ext.create('Ext.form.field.Text', {
									maxLength: 100,
									enforceMaxLength: true,
									labelWidth: me.labelWidth,
									fieldLabel: 'ФИО',
									padding: '0 10 0 0',
									listeners: {
										blur: function () {
											me.refreshFIO('LASTNAME', objs.HIST_LASTNAME.getValue());
											//var rec = objs.panelEditHistory.activRec,
											//	now = new Date();
											//rec.data.LASTNAME = objs.HIST_LASTNAME.getValue();

											//if ((new Date(rec.data.DH1 || longPeriod.begin) <= now) && (new Date(rec.data.DH2 || longPeriod.end)  >= now)) {
											//	objs.LASTNAME.setValue(objs.HIST_LASTNAME.getValue());
											//}
										}
									}
								}),
								objs.HIST_FIRSTNAME = Ext.create('Ext.form.field.Text', {
									maxLength: 30,
									enforceMaxLength: true,
									padding: '0 10 0 0',
									listeners: {
										blur: function () {
											me.refreshFIO('FIRSTNAME', objs.HIST_FIRSTNAME.getValue());
										}
									}
								}),
								objs.HIST_PATRONYMIC = Ext.create('Ext.form.field.Text', {
									maxLength: 30,
									enforceMaxLength: true,
									listeners: {
										blur: function () {
											me.refreshFIO('PATRONYMIC', objs.HIST_PATRONYMIC.getValue());
										}
									}
								})
							]
						})
					]
				})
			]
		});
	},

	showHideMixColumn: function () {
		let me = this,
			objs = me.objs;		
		let store = objs.storeHistory;
		if (store.data.items.length > 1) {
			objs.gridHistory.mixColumn.show();
		} else {
			objs.gridHistory.mixColumn.hide();
			store.each(function (rec) {
				rec.set('MIX', false);
			});
		}
	},

	getExtraHistory: function (value) {
		if (!value.hist) return;
		
		var me = this,
			objs = me.objs;

		objs.gridHistory.setMetaDate(value.hist, {
			profileCode: me.code,
			profileKey: 'gridHist',
			GateCode: 'edit'
		});	
		
		objs.gridHistory.columnManager.headerCt.items.each(function (item) {
			switch (item.dataIndex) {
				case 'Период действия':
					item.flex = 1;
					break;
				case 'MIX':
					objs.gridHistory.mixColumn = item;
			}
		});

		me.showHideMixColumn();		
		objs.gridHistory.extraSelectFrst();
	},

	refreshHistFIO: function (column) {
		var me = this,
			objs = me.objs,
			activeRec = objs.panelEditHistory.activRec,
			value = objs[column].getValue(),
			now = new Date();
		objs.storeHistory.each(function (rec) {
			if ((new Date(rec.get('DH1') || longPeriod.begin) <= now) && (new Date(rec.get('DH2') || longPeriod.end) >= now)) {
				rec.set(column, value);

				if (activeRec && rec.get('LINK') === activeRec.data.LINK) {
					objs['HIST_' + column].setValue(value);
				}
			}
		});
	},

	refreshFIO: function (column, value) {
		var me = this,
			objs = me.objs,
			rec = objs.panelEditHistory.activRec,
			now = new Date();

		objs.storeHistory.each(function (r) {
			if (r.get('LINK') === rec.get('LINK')) {
				r.set(column, value);
				return;
			}
		});
		if ((new Date(rec.data.DH1 || longPeriod.begin) <= now) && (new Date(rec.data.DH2 || longPeriod.end) >= now)) {
			objs[column].setValue(value);
		}
	},

	isHistoryFilled: function() {
		const me = this;
		if (!me.getTabVisible('History'))
			return true;
		let res = true;

		var objs = me.objs,
			histData = objs.storeHistory.getDataExt(function (el) {
				return el.MIX ? _ : el;
			});

		Ext.each(histData, function (el) {
			return res = PeriodLib.filterDataByPeriod(histData, el, _, _, _, 'DH').length < 2;
		});

		if (!res)
			me.errorMessages.push(KS.L10n.SPERSONUpdController_CheckPeriodsCrossInHist_В_истории_есть_пересекающиеся_периоды_);

		var min = new Date(histData[0] ? histData[0].DH1 : longPeriod.begin);
		Ext.each(histData, function (el) {
			var d = new Date(el.DH1);
			if (min > d) min = d;
		});
		min.setDate(min.getDate() - 1);
		Ext.each(histData, function (el) {
			var d = new Date(el.DH1);
			d.setDate(d.getDate() - 1);

			if (Ext.Date.isEqual(d, min)) res = 0;

			if (res) {
				res = 0;
				Ext.each(histData, function (r) {
					if (Ext.Date.isEqual(d, new Date(r.DH2))) res = 1;
					return !res;
				});
				res = !res;
			}

			return res = !res;
		});

		if (!res) {
			let msg = KS.L10n.SPERSONUpdController_CheckPeriodsSkipInHist_В_истории_есть_пропуски_между_периодами__0___1__и__2___3__;
			msg = msg.substr(0, msg.indexOf('{0}')).trim() + "!";
			me.errorMessages.push(msg);
		}

		let h = false;
		objs.storeHistory.each(function (rec) { return h = !(!rec.data.MIX && (objs.S_ORG.isLock() ? !objs.S_ORG.isEmpty() : true)); });
		if (h) {			
			me.errorMessages.push(KS.L10n.SPERSONEditView_CheckSave_Введите_основное_место_работы_);
			res = false;
		}
		return res;
	},
	//#endregion История

	//конструктор таба Реквизиты
	createTabProp: function () {
		return this.objs.tabProp = Ext.create('Keysystems.Panel.Prop', {
			parentView: this,
			decimalData: this.gksd('decimalData')
		});
	},

	//#region Курирует подразделения

	//конструктор таба Курирует подразделения
	createTabControl: function () {
		var me = this,
			objs = me.objs;
		objs.tabControl = Ext.create('Ext.panel.Panel', {
			title: 'Курирует подразделения',
			border: 0,
			dontWaitMsg: true,
			layout: 'anchor'
		});

		
		objs.dictControl = Ext.create('Keysystems.Base.List.Tree', {
			closable: false,
			tabMode: true,
			code: dnl.S_OTDEL,
			linkCode: 'SOtdel',
			deleteCode: 'S_OTDEL',
			GateCode: 'edit',
			parentView: objs.tabControl,
			selectLinks: objs.sOtdel,
			profileKey: 'tabControl',
			head: false,
			hidePagging: true,
			pageSize: 1000,
			readOnly: me.getReadOnly(),
			checkListeners: {
				beforecheckchange: function() { 
					return !me.tabControlReadOnly; 
				}
			},
			needToolbar: false,
			btnsShow: {
				galka: true,
				unmark: true
			},
			getWhereArgs: function () {
				const orgsP = me.getCurrentOrgsP();
				return {SOrgs: {value: JSON.stringify(orgsP.length ? orgsP : [0]), type: 'List_int'}}
			}
		});

		return objs.tabControl;
	},

	/** Даты попадают под текущую дату */
	isCurrentDates: function(dh1, dh2){
		const now = new Date(new Date().getFullYear(),new Date().getMonth() , new Date().getDate());
		return now >= new Date(dh1) && now <= new Date(dh2);
	},

	/** Получить  организации с типов Проверяющая, попадающие под текущую дату */
	getCurrentOrgsP: function(){
		const me = this;
		let controlOrgs = [];

		me.objs.gridHistory.getStore().getDataExt().forEach(function (rec) {
			if (!rec.MIX && rec.S_ORG && rec.isControl && me.isCurrentDates(rec.DH1, rec.DH2) ) {
				controlOrgs.push(rec.S_ORG);
			}
		});
		return controlOrgs;
	},

	/** Показать сообщение о необходимости удаления курируемых подразделений */
	showMessagePersonOtdel: async function(isOldOrgP, isNewOrgP) {
		const me = this;
		if (isOldOrgP && !isNewOrgP) {

			const otdels = me.objs.dictControl ? me.objs.dictControl.getChecks() : [];
			if (!otdels || !otdels.length) return true;

			const res = await selectDialogShowAsync(KS.L10n.attention, KS.L10n.SPERSONEditView_ShowMessagePersonOtdel_Удалить_информацию_по_курируемым_подразделениям_);
			if (me.tabControlReadOnly) {
				warning(KS.L10n.SPERSONEditView_ShowMessagePersonOtdel_Нельзя_удалить_курируемые_подразделения___вкладка_доступна_только_для_чтения_);
				return false;
			}
			return res === "yes";
		}
		return false;
	},

	/** Показать/скрыть вкладку Курируемые подразделения
	 * в записях истории, попадающих под текущую дату, должны быть заданы орг-ии с типом Проверяющая */
	showHidePersonOtdels: function () {
		const me = this;
		const objs = me.objs;

		const nowOrgs = me.getCurrentOrgsP();
		if (!me.isLoaded) {
			if (nowOrgs.length === 0 && objs.dictControl.getChecks().length) {
				objs.dictControl.setChecks([]);
			}
			objs.dictControl.pagingTool.doRefresh();
		}
		objs.allTab.changeTab(me.getTab('Control'), nowOrgs.length);
	},

	//#endregion Курирует подразделения

	//#region Трудовые договоры

	//конструктор таба Трудовые договоры
	createTabContract: function () {
		var me = this,
			objs = me.objs;

		return objs.tabContract = Ext.create('Ext.panel.Panel', {
			title: 'Трудовые договоры',
			layout: { type: 'vbox', align: 'stretch' },
			border: 0,			
			items: [
				objs.PERSON_CONTRACT = Ext.create('Ext.grid.Panel', {
					plugins: [
						Ext.create('Ext.grid.plugin.CellEditing', {
							clicksToEdit: 1,
							isDhSwap: true
						}),
						'gridclipboard'
					],
					flex: 1,
					border: 0,
					tbar: [
						Ext.create('Ext.Button', {
							key: 'new',
							iconCls: 'x_btn_new',
							tooltip: 'Создать',
							tooltipType: 'title',
							handler: function () {
								let sel = objs.storeContract.add({ LINK: me.contractLink-- });
								objs.PERSON_CONTRACT.getSelectionModel().select(sel);
							}
						}),
						Ext.create('Ext.Button', {
							key: 'copy',
							iconCls: 'x_btn_copy',
							tooltip: 'Создать подобную',
							tooltipType: 'title',
							disabled: true,
							handler: function () {
								let sel = objs.PERSON_CONTRACT.getFrstSelect();
								if (!sel) return;
								
								let d = sel.getData();
								delete d.id;
								d.LINK = me.contractLink--;
								sel = objs.storeContract.add(d);
								objs.PERSON_CONTRACT.getSelectionModel().select(sel);								
							}
						}),
						Ext.create('Ext.Button', {
							key: 'delete',
							tooltip: 'Удалить',
							tooltipType: 'title',
							iconCls: 'x_btn_delete',
							disabled: true,
							handler: function () { objs.PERSON_CONTRACT.removeSelection(); }
						})
					],
					store: objs.storeContract = Ext.create('Ext.data.Store', {
						fields: [],
						data: [],
						proxy: 'memory'
					}),
					columns: [],
					columnLines: true,
					listeners: {
						celldblclick: function (th, td, cellIndex, rec) {
							var columnMgr = th.panel.getColumnManager(),
								column = columnMgr.getHeaderAtIndex(cellIndex);
							if (column.dataIndex === 'NOTE') {
								showTextEditor(rec.get(column.dataIndex), function (text) { rec.set(column.dataIndex, text); }, column.text);
							}
						},
						selectionchange: (_, sels) => me.enableToolsGrid(objs.PERSON_CONTRACT, sels)
					}
				})
			]
		});
	},

	getExtraContract: function (value) {
		if (!value.tabContract) return;
		var me = this,
			objs = me.objs;

		objs.isTabContract = true;

		Ext.each(value.tabContract.fields, function (field) {
			if (field.name === 'FILES') {
				field.type = 'string';
				return false;
			}
			return true;
		});

		const pos = ArrayLib.find(value.tabContract.columns, ['dataIndex'], 'FILES');
		const fileColumn = {
			xtype: 'actioncolumn',
			dataIndex: 'FILES',
			text: 'Файл',
			width: 40,
			align: 'center',
			items: [
				{
					getClass: function (v, meta, rec) { return getExtStyle(rec.get(me.fieldExt)); },
					handler: (grid, rowIndex) => me.fileGridEdit(grid.getStore().getAt(rowIndex), me.objs.tabContract.ksReadOnly)
				}
			]
		};
		if (pos === -1) {
			value.tabContract.columns.push(fileColumn);
		} else {
			value.tabContract.columns[pos] = fileColumn;
		}

		Ext.each(value.tabContract.columns, function (col) {
			switch (col.dataIndex) {
				case 'NUMBER':
					col.editor = {
						xtype: 'textfield',
						maxLength: 150,
						enforceMaxLength: true
					};
					break;
				case 'DT':
				case 'DH1':
				case 'DH2':
					col.editor = {xtype: 'datefield'};
					break;
			}
		});

		objs.PERSON_CONTRACT.setMetaDate(value.tabContract, {
			profileCode: me.code,
			profileKey: 'gridContract',
			GateCode: 'edit'
		});
	},

	//#endregion Трудовые договоры

	//#region Периоды отсутствия

	//конструктор таба Периоды отсутствия
	createTabOut: function () {
		var me = this,
			objs = me.objs;

		return objs.tabOut = Ext.create('Ext.panel.Panel', {
			title: 'Периоды отсутствия',
			layout: { type: 'vbox', align: 'stretch' },
			border: 0,			
			items: [
				objs.PERSON_OUT = Ext.create('Ext.grid.Panel', {
					flex: 1,
					border: 0,
					plugins: [
						Ext.create('Ext.grid.plugin.CellEditing', {
							clicksToEdit: 1,
							isDhSwap: true,
							dhSwapField: 'DT',
							listeners: {
								ksAfteredit: function (editor, e) {
									var rec = e.record,
										dt1 = rec.get(editor.dhSwapField + '1'),
										dt2 = rec.get(editor.dhSwapField + '2');

									if (dt1 <= dt2 && !Ext.Date.isEqual(e.originalValue, e.value)) {
										rec.set('TEMP_CDAYS', PeriodLib.getCntCDaysInPeriod(dt1, dt2));
										getCntDaysInPeriod(dt1, dt2, objs.S_ORG.getLink(), function (tempDays) {
											rec.set('TEMP_DAYS', tempDays.workDays);
										}, function () {
											rec.set('TEMP_DAYS', 0);
										});
									}


								}
							}
						}),
						'gridclipboard'
					],
					tbar: [
						Ext.create('Ext.Button', {
							key: 'new',
							iconCls: 'x_btn_new',
							tooltip: 'Создать период отсутствия',
							tooltipType: 'title',
							handler: function () {
								let sel = objs.PERSON_OUT.store.add({});
								objs.PERSON_OUT.getSelectionModel().select(sel);
							}
						}),
						Ext.create('Ext.Button', {
							key: 'delete',
							tooltip: 'Удалить период отсутствия',
							tooltipType: 'title',
							iconCls: 'x_btn_delete',
							disabled: true,
							handler: function () {
								objs.PERSON_OUT.removeSelection();
							}
						})
					],
					store: Ext.create('Ext.data.Store', {fields: [], data: [], proxy: 'memory'}),
					columns: [],
					columnLines: true,
					listeners: [
						{selectionchange: (_, sels) => me.enableToolsGrid(objs.PERSON_OUT, sels)}
					]
				})
			]
		});
	},

	getExtraOut: function (value) {
		if (!value.tabPersonOut) return;

		var me = this,
			objs = me.objs,
			po = value.tabPersonOut;

		objs.isTabPersonOut = true;
		Ext.each(po.columns, function (c, i) {
			switch (c.dataIndex) {
				case 'DT1':
				case 'DT2':
					c.xtype = 'datecolumn';
					c.format = 'd.m.Y';
					c.editor = {xtype: 'datefield', format: 'd.m.Y'};
					break;
				case 'TEMP_SREASON_NAME':
					c.width = 150;
					c.flex = 1;
					c.xtype = 'dictcolumn';
					c.cleaningKey = false;
					c.code = dnl.S_REASON;
					c.mode = 'SINGL';
					c.ignoreCodeField = true;
					c.defaultRenderer = function (v, m, r) {
						return (v || (r ? (r.data || r)["TEMP_SREASON_NAME"] : _)) || _;
					};
					c.ksGetValue = function (rec) {
						return [{LINK: rec.get("S_REASON")}];
					};
					c.ksSetValue = function (v, rec) {
						var d = v[0];
						d = d ? (d.data || d) : {LINK: 0};
						rec.beginEdit();
						rec.set('S_REASON', d.LINK);
						rec.set('TEMP_SREASON_NAME', d.NAME);
						rec.endEdit();
					}
			}
		});

		objs.PERSON_OUT.setMetaDate(po, {
			profileCode: me.code,
			profileKey: 'gridPersonOut',
			gateCode: 'edit'
		});

	},

	//#endregion Периоды отсутствия

	//конфигурация основого окна
	viewCfg: function () {
		var result = this.callParent(arguments);
		result.resizable = true;
		result.maximizable = true;
		result.minWidth = 600;
		result.minHeight = 500;
		result.width = this.width;
		return result;
	},
	
	dataCollector: function () {
		var me = this,
			objs = me.objs;

		let hist = null;
		if (me.getTabVisible('History')) {
			hist = [];
			objs.storeHistory.each(function (rec) {
				hist.push({
					DH1: rec.data.DH1.toDateString(),
					DH2: rec.data.DH2.toDateString(),
					MIX: rec.data.MIX,
					LINK: rec.data.LINK,
					S_DOLG: rec.data.S_DOLG || 0,
					S_ORG: (objs.S_ORG.isLock() ? objs.S_ORG.getLink() : rec.data.S_ORG) || 0,
					S_OTDEL: rec.data.S_OTDEL || 0,
					S_RANG: rec.data.S_RANG || 0,
					S_WORK: JSON.stringify(objs.S_WORK.getLinks.call({ value: rec.data.SWork, fieldLink: 'LINK' })),
					LASTNAME: rec.data.LASTNAME,
					FIRSTNAME: rec.data.FIRSTNAME,
					PATRONYMIC: rec.data.PATRONYMIC
				});
			});
		}
		var data = me.callParent([false]);
		var sPersonSOtdel = [];
		if (objs.dictControl) {
			Ext.each(objs.dictControl.getChecks(), function (rec) {
				if (rec) {
					sPersonSOtdel.push((rec.data || rec).LINK);
				}
			});
		}

		if (objs.isTabPersonOut) {
			var personOut = [];
			objs.PERSON_OUT.store.each(function (rec) {
				if (rec.data.DT1 && rec.data.DT2) {
					personOut.push({
						DT1: rec.data.DT1.toDateString(),
						DT2: rec.data.DT2.toDateString(),
						LINK: rec.data.LINK,
						S_PERSON: rec.data.S_PERSON,
						S_REASON: rec.data.S_REASON
					});
				}
			}, _, true);
			data.personOut = JSON.stringify(personOut);
		}

		if (objs.isTabContract) {
			data.tabContract = JSON.stringify(objs.storeContract.getDataExt(function (d) {
				if (!d.DH1) d.DH1 = longPeriod.begin;
				if (!d.DH2) d.DH2 = longPeriod.end;
				return d;
			}));
		}

		data.link = objs.link;
		data.code = objs.CODE.getValue();
		if (user.isAdmin) data.USERID = objs.USERID.getLink();
		data.LASTNAME = objs.LASTNAME.getValue();
		data.FIRSTNAME = objs.FIRSTNAME.getValue();
		data.PATRONYMIC = objs.PATRONYMIC.getValue();
		data.BIRTHDAY = objs.BIRTHDAY.getValue();
		data.BIRTHPLACE = objs.BIRTHPLACE.getValue();
		data.PASSPORT = objs.PASSPORT.getValue();
		data.INN = objs.INN.getValue();
		data.INSURNUMBER = objs.INSURNUMBER.getValue();
		data.SEX = objs.SEX.getValue();
		data.S_ADR = objs.S_ADR.getLink();
		data.S_ADRF = objs.S_ADRF.getLink();
		data.PHONE = objs.PHONE.getValue();
		data.sPersonSOtdel = JSON.stringify(sPersonSOtdel);
		hist && (data.hist = JSON.stringify(hist));
		data.prop = me.getTab('Prop').getData(1);

		return data;
	},
	

	successSaveFunc: function (res) {
		var me = this,
			objs = me.objs;
		if (objs.isTabContract && res.tabContract) objs.storeContract.loadData(res.tabContract, false);
		me.callParent(arguments);
	},

	_arr: ['CODE', 'LASTNAME', 'FIRSTNAME', 'PATRONYMIC', 'BIRTHDAY', 'BIRTHPLACE', 'PASSPORT', 'INN', 'INSURNUMBER', 'SEX', 'PHONE'],

	//value - extraValue
	//tabs - [[tabAccessKey, extraFn, tabKey, getReadFn]]
	extraFillTabs: function (value, tabs) {
		var me = this,
			tabsAccess = me.sksd('Tabs', value.Tabs),
			allTab = me.gksc('allTab') || me.objs.allTab;

		Ext.each(tabs, function (a) {
			var acc = me.getTabAccess(tabsAccess, a[0]);
			if (acc & ObjAccessMask.READ && (a[3] ? a[3].call(me, value) : true)) {
				var tab;
				if (a[2]) {
					tab = me.getTab(a[2]);
					allTab.changeTab(tab, true);
				}
				a[1].call(me, value);
				if (tab && !(acc & ObjAccessMask.EDIT)) me.setTabReadOnly(a[2]);
			}
		});

		if (me.f === 'new' && me.gksc('S_ORG').getLink() === 0) {
			me.gksc('S_ORG').setValue(window.user.org);
		}
	},

	setTabReadOnly: function(tabKey) {
		let me = this;
		switch (tabKey.toUpperCase()) {
			case "CONTROL":
				me.tabControlReadOnly = true;
				this.callParent(arguments);
				break;
			default:
				this.callParent(arguments);
				break;
		}		
	},

	getExtra: function (callBack, link) {
		var me = this,
			objs = me.objs;

		var pos = ArrayLib.find(me.inputDicts, ['name'], 'S_ORG');
		if (pos !== -1) me.SOrg = me.inputDicts[pos].data.LINK;

		me.baseGetExtra({ link: link, SOrg: me.SOrg }, function (value) {
			me.sksd('decimalData', value.decimalData);
			
			objs.sOrg = value.S_ORG ? value.S_ORG.data : null;

			objs.sOtdel = value.sOtdel;

			me.extraFillTabs(value, [
				['COMMON', me.getExtraGeneral, 'General'],
				['HIST', me.getExtraHistory, 'History'],
				['OTDEL', Ext.emptyFn, 'Control'],
				['PROP', function (v) {
					if (!v.prop) return;
					this.getTab('Prop').loadData(v.prop);
				}, 'Prop', v => v.prop ],
				['CONTRACT', me.getExtraContract, 'Contract', v => v.tabContract],
				['OUT', me.getExtraOut, 'Out']
			]);

			me.showHidePersonOtdels();
			if (callBack) callBack();
		});
	},
	
});