﻿import moment from "moment";

Ext.define('Keysystems.SOrg.Edit', {
	extend: 'Keysystems.Base.Edit',
	profilePrefix: 'SOrg',

	//#region для Паспорта организации

	hideEdit: { new: true, same: true, edit: true, delete: true, add_slave: true, make_child: true, make_parent: true },

	//#endregion для Паспорта организации

	egrulNalogColumns: [
		{ text: 'Поле', dataIndex: 'NAME', flex: 1 },
		{ text: 'Текущее значение', dataIndex: 'CURRENT', flex: 1 },
		{ text: 'Актуальное значение', dataIndex: 'ACTUAL', flex: 1 }
	],
	egrulNalogFields: ['LINK', 'NAME', 'FIELD', 'CURRENT', 'ACTUAL'],

	_arrGeneralRow: ['CODE', 'INN', 'KPP', 'NAME', 'SNAME', 'OGRN', 'OKPO', 'DH1', 'DH2', 'PHONE', 'FAX', 'EMAIL'],
	_arrGeneralSingl: ['S_REGION', 'S_OKFS', 'S_OKOPF', 'S_ADRU', 'S_ADRF'],
	_arrGeneralMulti: ['S_TYPEORG'],
	_arrAdditionalRow: ['ABBR', 'LIMIT_BY_KBK', 'CNTPERSON'],
	_arrAdditionalSingl: ['S_KBK', 'S_ORG'],
	_arrAdditionalMulti: ['S_DOLG', 'S_ORGPRED'],

	viewMinSize: [835, 530],
	bodyPadding: 0,

	tabMappings:{
		"CHANGEHISTORY":"ChangeHistory",
		"COMMON":"General",
	},

	directorEgrul: {},

	createItems: function () {
		let me = this;
		return me.sksc('allTab', me.objs.allTab = Ext.create('Ext.tab.Panel', {
			plain: true,
			border: 0,
			bodyBorder: 0,
			userCls: me.basePanelCls,
			bodyCls: me.basePanelBodyCls,
			flex: 1,
			items: me.objs.items = [me.getTab('General')]
		}));
	},

	//конструктор таба Общие
	createTabGeneral: function () {
		var me = this,
			objs = me.objs;

		return objs.tabGeneral = Ext.create('Ext.panel.Panel', {
			title: 'Общие',
			layout: { type: 'vbox', align: 'stretch' },
			bodyPadding: 10,
			border: 0,
			bodyBorder: 0,
			flex: 1,
			items: [
				me.createCodeEdit({
					maxLength: 20,
					enforceMaxLength: true,
					maxWidth: 300
				}),
				[
					objs.INN = Ext.create('Ext.form.field.Text', {
						fieldLabel: 'ИНН',
						labelWidth: me.labelWidth,
						emptyText: 'Введите ИНН',
						enforceMaxLength: true,
						width: 300,
						maxLength: 12,
						listeners: { change: function () { me.visibleSyncCHButton(); } }
					}),
					objs.btnSyncNalog = Ext.create('Ext.Button', {
						iconCls: 'x_btn_extrem',
						tooltip: 'Получить актуальные данные...',
						tooltipType: 'title',
						hidden: true,
						handler: function () { me.getInfoFromEgrulNalog(); }
					}),
					'->',
					objs.KPP = Ext.create('Ext.form.field.Text', {
						fieldLabel: 'КПП',
						emptyText: 'Введите КПП',
						maxLength: 9,
						enforceMaxLength: true,
						labelWidth: 40
					})
				],
				me.createNameEdit({ maxLength: 1000, enforceMaxLength: true }),
				me.createSNameEdit({ maxLength: 300, enforceMaxLength: true }),
				[
					objs.OGRN = Ext.create('Ext.form.field.Text', {
						fieldLabel: 'ОГРН',
						labelWidth: me.labelWidth,
						enforceMaxLength: true,
						width: 300,
						emptyText: 'Введите ОГРН',
						maxLength: 15,
						listeners: { change: function () { me.visibleSyncCHButton(); } }
					}),
					'->',
					objs.DH1 = Ext.create('Ext.form.field.Date', {
						fieldLabel: 'Дата регистрации',
						padding: '0 0 0 10',
						labelWidth: 120,
						maxWidth: 240,
					}),
					objs.DH2 = Ext.create('Ext.form.field.Date', {
						fieldLabel: 'Дата закрытия',
						padding: '0 0 0 10',
						labelWidth: 100,
						maxWidth: 220,
					})
				],
				objs.OKPO = Ext.create('Ext.form.field.Text', {
					maxLength: 10,
					enforceMaxLength: true,
					maxWidth: 300,
					fieldLabel: 'ОКПО',
					emptyText: 'Введите ОКПО',
					labelWidth: me.labelWidth
				}),
				objs.S_ADRU = Ext.create('Keysystems.Controls.DictName.Edit', {
					key: 'S_ADRU',
					labelWidth: me.labelWidth,
					fieldLabel: 'Адрес (юр.)',
					cleaningKey: false,
					clear: function () { this.ksSetValue(); },
					ksSetValue: function (value) {
						this.setValue(value);
						var v = this.getValue(),
							newCls;
						if (v.length) {
							v = v[0].data || v[0];
							newCls = 'x-dict-trigger x_btn_edit'
						} else {
							v = { LINK: 0 };
							newCls = 'x-dict-trigger x_btn_new'
						}

						var trig = objs.S_ADRU.fieldName;
						if (trig.triggers && trig.triggers.trigger2) {
							var el = trig.triggers.trigger2;
							if (el.el) {
								el.el.removeCls(el.cls);
								el.el.addCls(el.cls = newCls);
							}
							el.cls = newCls;
						}

						if (v.LINK && !me.isLoaded) {
							ajaxRequest({
								url: 'SRegion/GetRegionByAddress_A',
								params: { link: v.LINK },
								success: function (region) { me.gksc('S_REGION').ksSetValue(region); }
							});
						}
					},
					handler: [
						{
							handler: function () {if (!objs.S_ADRF.readOnly) objs.S_ADRF.ksSetValue(objs.S_ADRU.getValue()); },
							cls: 'x-dict-trigger x_btn_bottom'
						},
						{
							handler: function () {
								if (objs.S_ADRU.readOnly) return;
								var link = objs.S_ADRU.getLink(),
									cfg = {
										f: link ? 'edit' : 'new',
										link: link,
										data: { data: { LINK: link } },
										code: dnl.S_ADR,
										parentView: me.objs.view,
										refreshFunc: function () { me.refresh(); },
										updRecord: function (rec) {
											objs.S_ADRU.ksSetValue(rec);
											// обновим Адрес (факт.), если там такая же запись
											if (objs.S_ADRF.getLink() === rec.LINK) {
												objs.S_ADRF.ksSetValue(rec);
											}
										},
										saveData: function(endFunc, inputParams){
											var linkSorg = me.ksData.link,
												th = this;
											inputParams = inputParams || th.dataCollector();
											if (inputParams.link && linkSorg){
												th.saveAddress(inputParams, endFunc);
											}
											else{
												th.baseSaveData(inputParams, endFunc);
											}
										},
										addRecord: Ext.emptyFn
									};
								Ext.apply(cfg, dictListController.DICTIONARY_SADR);
								Ext.create(cfg.editClass, cfg);
							},
							cls: 'x-dict-trigger x_btn_new'
						}
					]
				}),
				objs.S_ADRF = Ext.create('Keysystems.Controls.DictName.Edit', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Адрес (факт.)',
					cleaningKey: false,
					clear: function () { this.ksSetValue(); },
					ksSetValue: function (value) {
						this.setValue(value);
						var v = this.getValue(),
							newCls = v.length ? 'x-dict-trigger x_btn_edit' : 'x-dict-trigger x_btn_new',
							trig = objs.S_ADRF.fieldName;
						if (trig.triggers && trig.triggers.trigger1) {
							var el = trig.triggers.trigger1;
							if (el.el) {
								el.el.removeCls(el.cls);
								el.el.addCls(el.cls = newCls);
							}
							el.cls = newCls;
						}
					},
					handler: [
						{
							handler: function () {
								if (objs.S_ADRF.readOnly) return;
								var link = objs.S_ADRF.getLink(),
									cfg = {
										f: link ? 'edit' : 'new',
										link: link,
										data: { data: { LINK: link } },
										code: dnl.S_ADR,
										parentView: me.objs.view,
										refreshFunc: function () { me.refresh(); },
										updRecord: function (rec) {
											objs.S_ADRF.ksSetValue(rec);
											// обновим Адрес (юр.), если там такая же запись
											if (objs.S_ADRU.getLink() === rec.LINK) {
												objs.S_ADRU.ksSetValue(rec);
											}
										},
										addRecord: Ext.emptyFn,
										saveData: function(endFunc, inputParams){
											var linkSorg = me.ksData.link,
												th = this;
											inputParams = inputParams || th.dataCollector();
											if (inputParams.link && linkSorg){
												th.saveAddress(inputParams, endFunc);
											}
											else{
												th.baseSaveData(inputParams, endFunc);
											}
										},
									};
								Ext.apply(cfg, dictListController.DICTIONARY_SADR);
								Ext.create(cfg.editClass, cfg);
							},
							cls: 'x-dict-trigger x_btn_new'
						}
					]

				}),
				me.createDictEdit({
					key: 'S_REGION',
					mode: 'SINGL',
					code: dnl.S_REGION,
					fieldLabel: 'Территория',
					ksSetValue: function (v) {
						this.setValue(v);
						me.showHideTabsRegionsOkveds();
					}
				}),
				me.createDictEdit({
					key: 'S_TYPEORG',
					mode: 'MULTI',
					code: dnl.S_TYPEORG,
					fieldLabel: 'Тип организации',
					ksSetValue: async function (v) {
						const oldLinks = this.getLinks();
						const newLinks = v ? v.map(v => (v.data || v).LINK) : [];
						if (!me.isLoaded && oldLinks.indexOf(me.checkTypeOrg) >= 0 && newLinks.indexOf(me.checkTypeOrg) === -1) {
							const message = me.regionAccessible && me.okvedAccessible
								? KS.L10n.SORGEditView_dictTypeOrg_Changing_Удалить_информацию_по_подконтрольным_территориям_и_подконтрольным_ОКВЭД_
								: (me.regionAccessible ? KS.L10n.SORGEditView_dictTypeOrg_Changing_Удалить_информацию_по_подконтрольным_территориям_ :
									(me.okvedAccessible ? KS.L10n.SORGEditView_dictTypeOrg_Changing_Удалить_информацию_по_подконтрольным_ОКВЭД_ : ""));
							if (message) {
								const res = await selectDialogShowAsync(KS.L10n.attention, message);
								if (res === 'no')
									return;
							}
						}

						this.setValue(v);
						me.showHideTabsRegionsOkveds();
						me.showHideLimitByKbk(this.getValue());
						
						if (!me.isLoaded) {
							if (newLinks.length) {
								const dolgs = await ajaxRequestAsync({
									url: 'STypeOrg/GetDolgLinks_A',
									params: {links: JSON.stringify(newLinks)},
								});
								if (dolgs && Array.isArray(dolgs) && dolgs.length) {
									const res = await selectDialogShowAsync(KS.L10n.attention, KS.L10n.SORGEditView_dictTypeOrg_Changed_Заполнить_набор_должностей_из_типов_организации_);
									if (res === 'yes')
										objs["S_DOLG"].setValue(dolgs);
								}
							}
						}
					}
				}),
				me.createDictEdit({
					key: 'S_OKFS',
					mode: 'SINGL',
					code: dnl.S_OKFS,
					fieldLabel: 'ОКФС',
					listCfg: me.isPasport ? { btnsHide: me.hideEdit } : _
				}),
				me.createDictEdit({
					key: 'S_OKOPF',
					mode: 'SINGL',
					listCfg: me.isPasport ? { btnsHide: me.hideEdit } : _,
					code: dnl.S_OKOPF,
					fieldLabel: 'ОКОПФ'
				}),
				objs.PHONE = Ext.create('Ext.form.field.Text', {
					fieldLabel: 'Телефон',
					maxLength: 250,
					maxWidth: 300,
					labelWidth: me.labelWidth
				}),
				objs.FAX = Ext.create('Ext.form.field.Text', {
					fieldLabel: 'Факс',
					maxLength: 100,
					maxWidth: 300,
					labelWidth: me.labelWidth
				}),
				objs.EMAIL = Ext.create('Ext.form.field.Text', {
					fieldLabel: 'Электронная почта',
					maxLength: 50,
					labelWidth: me.labelWidth,
					maxWidth: 350
				})
			]
		});
	},

	//#region таб Реквизиты

	//конструктор таба Реквизиты

	createTabProp: function () {
		return this.objs.tabProp = Ext.create('Keysystems.Panel.Prop', {
			parentView: this,
			decimalData: this.gksd('decimalData')
		});
	},

	//#endregion таб Реквизиты

	//#region таб История изменений

	//конструктор таба История изменений
	createTabChangeHistory: function () {
		var me = this,
			objs = me.objs;

		return objs.tabChangeHistory = Ext.create('Ext.panel.Panel', {
			title: 'История изменений',
			layout: { type: 'vbox', align: 'stretch' },
			border: 0,
			scrollable: true,
			items: [
				objs.VER_S_ORG = Ext.create('Ext.grid.Panel', {
					flex: 1,
					border: 0,
					plugins: [
						Ext.create('Ext.grid.plugin.CellEditing', {
							clicksToEdit: 1
						}),
						'gridclipboard'
					],
					tbar: [
						Ext.create('Ext.Button', {
							key: 'new',
							iconCls: 'x_btn_new',
							tooltip: 'Добавить',
							tooltipType: 'title',
							handler: function () {
								var row = {};
								me.fillVersionDate(row);
								row.CODE = objs.CODE.getValue();
								row.NAME = objs.NAME.getValue();
								row.SNAME = objs.SNAME.getValue();

								var sKbk = objs.S_KBK.getValue()[0];
								if (sKbk) {
									sKbk = sKbk.data || sKbk;
									row.S_KBK = sKbk.LINK;
									row.TEMP_SKBK_NAME = sKbk.CODE + ' ' + sKbk.NAME;
								}

								var sOkopf = objs.S_OKOPF.getValue()[0];
								if (sOkopf) {
									sOkopf = sOkopf.data || sOkopf;
									row.S_OKOPF = sOkopf.LINK;
									row.TEMP_SOKOPF_NAME = sOkopf.CODE + ' ' + sOkopf.NAME;
								}

								var sAdru = objs.S_ADRU.getValue()[0];
								if (sAdru) {
									sAdru = sAdru.data || sAdru;
									row.S_ADRU = sAdru.LINK;
									row.TEMP_SADRU_NAME = sAdru[objs.S_ADRU.visibleFields];
								}

								var sAdrf = objs.S_ADRF.getValue()[0];
								if (sAdrf) {
									sAdrf = sAdrf.data || sAdrf;
									row.S_ADRF = sAdrf.LINK;
									row.TEMP_SADRF_NAME = sAdrf[objs.S_ADRF.visibleFields];
								}

								var sTypeOrg = objs.S_TYPEORG.getValue();
								if (sTypeOrg) {
									let links = sTypeOrg.map(r => (r.data || r).LINK);
									row.STypeOrg = links;
									let res = sTypeOrg.map(r => (r.data || r).NAME).sort().join('; ');
									row.TEMP_STYPEORG_NAME = res;
								}
								let sel = objs.VER_S_ORG.store.add(row);
								objs.VER_S_ORG.getSelectionModel().select(sel);
								objs.VER_S_ORG.store.sort('DT', 'DESC');
							}
						}),
						Ext.create('Ext.Button', {
							key: 'copy',
							tooltip: 'Копировать',
							tooltipType: 'title',
							iconCls: 'x_btn_copy',
							disabled: true,
							handler: function () {
								let sel = objs.VER_S_ORG.getFrstSelect();
								if (!sel) return;

								let row = sel.getData();
								delete row.id;
								me.fillVersionDate(row);
								sel = objs.VER_S_ORG.store.add(row);
								objs.VER_S_ORG.getSelectionModel().select(sel);
							}
						}),
						Ext.create('Ext.Button', {
							key: 'delete',
							tooltip: 'Удалить',
							tooltipType: 'title',
							iconCls: 'x_btn_delete',
							disabled: true,
							handler: function () { objs.VER_S_ORG.removeSelection(); }
						})
					],
					store: Ext.create('Ext.data.Store',
						{
							fields: [],
							data: [],
							proxy: 'memory',
							sortOnLoad: true,
							sorters:
								[
									{
										sorterFn: function (rec1, rec2) {
											let dt1 = rec1.get('DT');
											let dt2 = rec2.get('DT');

											return Ext.Date.isEqual(dt1, dt2)
												? 0
												: new Date(dt1) > new Date(dt2)
													? -1
													: 1;
										}
									}
								]
						}),

					columns: [],
					columnLines: true,
					listeners: {
						selectionchange: (_, sels) => me.enableToolsGrid(objs.VER_S_ORG, sels)
					},
					setKsReadOnly: function(v){
						var th = this;
						th.getToolbarItem('new').setKsReadOnly(v);
						th.getToolbarItem('copy').setKsReadOnly(v);
						th.getToolbarItem('delete').setKsReadOnly(v);
					}
				})
			]
		});
	},

	fillVersionDate: function (row) {
		var dt = Ext.Date.add(new Date(), Ext.Date.DAY, -1);
		dt = new Date(dt.toDateString());

		var pos = this.objs.VER_S_ORG.store.findBy(rec => rec.data.DT &&
			Ext.Date.isEqual(new Date(rec.data.DT.toDateString()), dt));
		row.DT = pos === -1 ? dt : null;
	},

	//#endregion таб История изменений

	//#region таб Подконтрольные территории

	//конструктор таба Подконтрольные территории
	createTabRegions: function () {
		var me = this,
			objs = me.objs;

		objs.tabRegions = Ext.create('Ext.panel.Panel', {
			title: 'Подконтрольные территории',
			layout: { type: 'vbox', align: 'stretch' },
			border: 0,
			scrollable: true,
			items: [
				Ext.create('Ext.form.FieldContainer', {
					layout: { type: 'hbox', align: 'stretch' },
					padding: 5,
					items: [
						objs.rbRegionOrg = Ext.create('Ext.form.field.Radio', {
							boxLabel: 'Организация',
							name: 'rb1',
							flex: 1,
							checked: true,
							handler: function () { me.updRegion(); }
						}),
						Ext.create('Ext.form.field.Radio', {
							boxLabel: 'Подразделения',
							name: 'rb1',
							width: 140,
						}),
						objs.cmbOtdelRegion = Ext.create('Ext.form.field.ComboBox', {
							editable: false,
							disabled: true,
							flex: 1,
							store: Ext.create('Ext.data.Store', {
								fields: CBDataLib.getFields(),
								data: [],
								proxy: 'memory'
							}),
							displayField: CBDataLib.displayField,
							valueField: CBDataLib.valueField,
							listeners: {
								change: function () {
									objs.dictRegion.pagingTool.doRefresh();
									me.updRNormRegion();
								}
							}
						})
					]
				}),
				objs.dictPanelRegion = Ext.create('Ext.panel.Panel', { layout: 'anchor', flex: 1 }),
				{ xtype: 'splitter' },
				objs.dictPanelRNorm = Ext.create('Ext.panel.Panel', { layout: 'anchor', flex: 1, hidden: true, disabled: true })
			],
			listeners: {
				activate: function () {
					if (!objs.dictRegion) {
						objs.dictRegion = Ext.create('Keysystems.Base.List', {
							closable: false,
							tabMode: true,
							checkModel: false,
							parentView: objs.dictPanelRegion,
							hidePagging: true,
							pageSize: 100000,
							functions: {
								getData: function (endFunc, params) {
									loadProfile({
										gateCode: params.GateCode,
										controlName: params.controlName,
										code: me.code,
										profileKey: 'tabRegion',
										callBack: function () {
											endFunc({
												columns: objs.regionColumns,
												fields: objs.regionFields,
												data: me.getRegionData()
											});
										}
									});
								}
							},							
							createTBar: function () {
								var th = this;
								th.objs.tbarBtns = {
									add_row: Ext.create('Ext.Button', {
										iconCls: 'x_btn_add_element',
										tooltip: 'Добавить',
										tooltipType: 'title',
										scope: this,
										disabled: objs.tabRegionsReadOnly,
										handler: function () {
											dictFunc({
												mode: 'MULTI',
												parentView: objs.view,
												selectLinks: me.getRegionData().data,
												code: dnl.S_REGION,
												whereArgs: me.getWhereArgsRegion(),
												baseGetData: function (callBack, params) {
													this.callParent([
														function (d) {
															me.removeSelfRegion(d.data);
															if (callBack) callBack.apply(this, arguments);
														}, params]);
												},
												baseRefresh: function (callBack, params) {
													this.callParent([
														function (d) {
															me.removeSelfRegion(d);
															if (callBack) callBack.apply(this, arguments);
														}, params
													]);
												}
											}, {
												ok: function (value) {
													me.setRegionData(value);
													objs.dictRegion.pagingTool.doRefresh();
												}
											});
										}
									}),
									delete_row: Ext.create('Ext.Button',
										{
											iconCls: 'x_btn_delete_element',
											tooltip: 'Удалить',
											tooltipType: 'title',
											disabled: true,
											handler: function () {
												if (objs.tabRegionsReadOnly) return;
												var sel = th.Grid.selModel.getSelection()[0];
												if (sel) {
													th.Grid.removeSelection(_,
														function () {
															me.removeRegion(sel.get('LINK'));
														});
												}
											}
										})
								}

								th.objs.tbar = [th.objs.tbarBtns.add_row, th.objs.tbarBtns.delete_row];
							},
							baseRefresh: function (callBack) { if (callBack) callBack(me.getRegionData()); },
							getGridCfg: function () {
								let th = this,
									cfg = th.callParent(arguments);

								cfg.listeners.selectionchange = function (_, sels) {
									me.updRNormRegion();
									th.objs.tbarBtns.delete_row.setDisabled(th.disabled || !sels.length);
								};

								return cfg;
							},
							code: me.code,
							GateCode: 'edit',
							profileKey: 'tabRegion',
							head: false
						});
					}
				}
			}
		});

		return objs.tabRegions;
	},

	getRegionData: function () {
		var me = this,
			objs = me.objs;
		if (objs.rbRegionOrg.getValue()) return { data: objs.tSOrgSRegion, total: objs.tSOrgSRegion.length };

		var otdel = objs.cmbOtdelRegion.getValue();
		if (otdel) {
			var res = objs.tSOtdelSRegion[otdel] || (objs.tSOtdelSRegion[otdel] = []);
			return { data: res, total: res.length };
		}

		return { data: [], total: 0 };
	},

	setRegionData: function (value) {
		var me = this,
			objs = me.objs;
		if (objs.rbRegionOrg.getValue()) {
			var d = [];
			Ext.each(value, function (v) { d.push(v.data || v); });
			objs.tSOrgSRegion = d;
		} else {
			var otdel = objs.cmbOtdelRegion.getValue();
			if (otdel) {
				var list = objs.tSOtdelSRegion[otdel] = [];
				Ext.each(value, function (v) { list.push(v.data || v); });
			}
		}
	},
	removeRegion: function (link) {
		var me = this,
			objs = me.objs;
		if (objs.rbRegionOrg.getValue()) {
			let pos = ArrayLib.find(objs.tSOrgSRegion, ['LINK'], link);
			if (pos !== -1) objs.tSOrgSRegion.splice(pos, 1);
		} else {
			var otdel = objs.cmbOtdelRegion.getValue();
			if (otdel) {
				let list = objs.tSOtdelSRegion[otdel];

				let pos = ArrayLib.find(list, ['LINK'], link);
				if (pos !== -1) list.splice(pos, 1);

			}
		}
	},

	getRegionSelectAndCheck: function () {
		var dictRegion = this.objs.dictRegion;
		return dictRegion ? dictRegion.getSelect()[0] : _;
	},

	removeSelfRegion: function (d) {
		var me = this,
			objs = me.objs;
		if (!objs.rbRegionOrg.getValue()) return;

		var self = getRawRowByLink(d.data, objs.S_REGION.getLink());
		if (self) {
			ArrayLib.remove(self.parent, self.node);
			d.totalMaxCount = d.total = d.data.length;
		}
	},

	getDictRNormRegion: function () {
		var me = this,
			objs = me.objs;

		if ((objs.gridRegionsRnormAccess & ObjAccessMask.READ) === 0)
			return false;

		if (!objs.dictRNormRegion) {
			dictFunc({
				closable: false,
				tabMode: true,
				code: dnl.S_RNORM,
				parentView: objs.dictPanelRNorm,
				GateCode: 'edit',
				profileKey: 'tabRegionRNorm',
				head: false,
				btnsHide: {
					new: true,
					same: true,
					edit: true,
					delete: true,
					search: true,
					show_actual: true,
					relations: true
				},
				checkListeners: {
					beforecheckchange: function () {
						if (!objs.notRiseRNormCheckChange
							&& (objs.tabRegionsReadOnly || (objs.gridRegionsRnormAccess & ObjAccessMask.EDIT) === 0)) return false;
						return true;
					},
					checkchange: function (th, rowIndex, checked, rec) {
						if (objs.notRiseRNormCheckChange) return;
						var otdel = objs.cmbOtdelRegion.getValue(),
							region = me.getRegionSelectAndCheck(),
							rnorm = rec.get('LINK');

						if (!otdel || !region) return;
						region = region.get('LINK');

						var rowORR = null;
						Ext.each(objs.otdelRegionRnorm,
							function (row) {
								if (row.S_OTDEL === otdel && row.S_REGION === region && row.S_RNORM === rnorm) {
									rowORR = row;
									return;
								}
							});
						if (checked) {
							if (!rowORR) {
								objs.otdelRegionRnorm.push({
									S_OTDEL: otdel,
									S_REGION: region,
									S_RNORM: rnorm
								});
							}
						} else {
							if (rowORR) {
								var pos = objs.otdelRegionRnorm.indexOf(rowORR);
								if (pos !== -1) objs.otdelRegionRnorm.splice(pos, 1);
							}
						}
					}
				}
			}, _, function (dict) { objs.dictRNormRegion = dict; });
		}

		return objs.dictRNormRegion;
	},

	updRNormRegion: function () {
		var me = this,
			objs = me.objs,
			region = me.getRegionSelectAndCheck();

		if (!objs.rbRegionOrg.getValue() && objs.dictRNormRegion) {
			var otdel = objs.cmbOtdelRegion.getValue();
			if (otdel && region) {
				objs.dictPanelRNorm.enable();

				var rNorm = [];
				objs.notRiseRNormCheckChange = true;
				objs.dictRNormRegion.setChecks([]);
				Ext.each(
					ArrayLib.filter(ArrayLib.filter(objs.otdelRegionRnorm, ['S_OTDEL'], otdel), ['S_REGION'], region.get('LINK')),
					function (v) {
						rNorm.push({ LINK: v.S_RNORM });
					}
				);
				if (rNorm.length > 0) objs.dictRNormRegion.checkList = rNorm;
				objs.dictRNormRegion.setChecks(rNorm);
				objs.notRiseRNormCheckChange = false;


			} else {
				objs.dictPanelRNorm.disable();
				objs.dictRNormRegion.setChecks([]);
			}
			objs.dictRNormRegion.Grid.view.refresh();
		}
	},

	getWhereArgsRegion: function () {
		var me = this,
			objs = me.objs,
			res = { UseActualData: { value: 'True', type: 'bool' } },
			region = { value: objs.S_REGION.getLink(), type: 'int' };

		res[objs.rbRegionOrg.getValue() ? 'LinkRemove' : 'LinkMaster'] = region;

		return res;
	},

	updRegion: function () {
		var me = this,
			objs = me.objs;

		if (!objs.dictRegion) return;

		if (objs.rbRegionOrg.getValue()) {
			var otdel = objs.cmbOtdelRegion.getValue(),
				region = me.getRegionSelectAndCheck();

			objs.dictRegion.pagingTool.doRefresh();
			objs.dictPanelRNorm.hide();
			objs.cmbOtdelRegion.disable();
		} else {
			objs.dictRegion.pagingTool.doRefresh();
			me.getDictRNormRegion();
			objs.dictPanelRNorm.show();
			objs.cmbOtdelRegion.enable();
		}
	},

	//#endregion таб Подконтрольные территории

	//#region таб Подконтрольные ОКВЭД

	//конструктор таба Подконтрольные ОКВЭД
	createTabOkved: function () {
		var me = this,
			objs = me.objs;

		objs.tabOkved = Ext.create('Ext.panel.Panel', {
			title: 'Подконтрольные ОКВЭД',
			layout: { type: 'vbox', align: 'stretch' },
			border: 0,
			scrollable: true,
			items: [
				objs.cmbOtdelOkved = Ext.create('Ext.form.field.ComboBox',
					{
						editable: false,
						fieldLabel: 'Подразделения',
						padding: 5,
						store: Ext.create('Ext.data.Store',
							{
								fields: CBDataLib.getFields(),
								data: [],
								proxy: 'memory'
							}),
						displayField: CBDataLib.displayField,
						valueField: CBDataLib.valueField,
						listeners: {
							change: function () {
								if (objs.gridOtdelOkved) {
									objs.gridOtdelOkved.refresh();
								}
							}
						}
					}),
				objs.dictPanelOkved = Ext.create('Ext.panel.Panel', { layout: 'anchor', flex: 1 })
			],
			listeners: {
				activate: function () {
					if (!objs.gridOtdelOkved) {
						objs.gridOtdelOkved = Ext.create('Keysystems.Base.List.Tree',
							{
								GateCode: 'DICTIONARY_SOKVED',
								code: dnl.S_OKVED,
								parentView: objs.dictPanelOkved,
								head: false,
								closable: false,
								tabMode: true,
								mode: 'SINGL',
								isItemDblClick: false,
								checkModel: false,
								handler: 'Keysystems.Base.List.Tree',
								linkCode: 'SOkved',
								getWhereArgs: function () {
									return {
										InLinksOnly: { value: 'True', type: 'bool' },
										InLinks: {
											value: JSON.stringify(me.getOtdelOkvedLinks(objs.cmbOtdelOkved.getValue())),
											type: 'List_int'
										}
									};
								},
								profileKey: 'tabOkved',
								hidePagging: true,
								createTBar: function () {
									var th = this;
									th.objs.tbarBtns = {
										add_row: Ext.create('Ext.Button',
											{
												iconCls: 'x_btn_add_element',
												tooltip: 'Выбрать',
												tooltipType: 'title',
												disabled: objs.tabOtdelOkvedReadOnly,
												handler: function () {
													dictFunc({
														mode: 'MULTI',
														parentView: objs.view,
														selectLinks:
															me.getOtdelOkvedValue(objs.cmbOtdelOkved.getValue()),
														code: dnl.S_OKVED
													},
														{
															ok: function (value) {
																me.setOtdelOkvedValue(objs.cmbOtdelOkved.getValue(), value);
																if (value.length !== 0) {
																	th.refresh();
																} else {
																	th.getGrid().getStore().getRootNode().removeAll();
																	th.getGrid().getView().refresh();
																}
															}
														});
												}
											}),
										delete_row: Ext.create('Ext.Button',
											{
												iconCls: 'x_btn_delete_element',
												tooltip: 'Удалить',
												tooltipType: 'title',
												disabled: true,

												handler: function () {
													if (objs.tabOtdelOkvedReadOnly) return;
													var sel = th.Grid.selModel.getSelection()[0];
													if (sel) {
														var childs = sel.childNodes;
														th.Grid.removeSelection(_,
															function () {
																var otdel = objs.cmbOtdelOkved.getValue();
																var rowsToDel = objs.T_SOTDEL_SOKVED.filter(
																	function (row) {
																		return row.S_OTDEL === otdel &&
																			row.S_OKVED === sel.get('LINK');
																	});
																if (rowsToDel.length > 0) {
																	var link = rowsToDel[0].LINK;
																	var pos = ArrayLib.find(objs.T_SOTDEL_SOKVED,
																		['LINK'],
																		link);
																	if (pos !== -1) objs.T_SOTDEL_SOKVED.splice(pos, 1);
																}
																Ext.each(childs, function (c) { th.appendParent(c); });
															});
													}
												}
											}),
										expand: Ext.create('Ext.Button',
											{
												iconCls: 'x_btn_treeexpand',
												tooltip: 'Развернуть все узлы',
												tooltipType: 'title',
												handler: function () {
													th.Grid.expandAll();
												}
											}),
										collapse: Ext.create('Ext.Button',
											{
												iconCls: 'x_btn_treecollapse',
												tooltip: 'Свернуть все узлы',
												tooltipType: 'title',
												handler: function () {
													th.Grid.collapseAll();
												}
											})
									}

									th.objs.tbar = [
										th.objs.tbarBtns.add_row, th.objs.tbarBtns.delete_row, th.objs.tbarBtns.expand,
										th.objs.tbarBtns.collapse
									];

								},
								listeners: {
									ksAfterRefresh: function () {
										objs.gridOtdelOkved.Grid.expandAll();
									}
								},
								getGridCfg: function () {
									let th = this,
										cfg = this.callParent(arguments);

									cfg.listeners.selectionchange = function (_, sels) {
										th.objs.tbarBtns.delete_row.setDisabled(th.disabled || !sels.length);
									};
									return cfg;
								},
							});
					}
				}
			}
		});

		return objs.tabOkved;
	},

	getOtdelOkvedValue: function (otdel) {
		if (otdel) {
			var res = [];
			Ext.each(ArrayLib.filter(this.objs.T_SOTDEL_SOKVED, ['S_OTDEL'], otdel), function (v) { res.push({ LINK: v.S_OKVED }); });
			return res;
		}
		return [];
	},

	getOtdelOkvedLinks: function (otdel) {
		if (otdel) {
			var res = [];
			Ext.each(ArrayLib.filter(this.objs.T_SOTDEL_SOKVED, ['S_OTDEL'], otdel), function (v) { res.push(v.S_OKVED); });
			return res;
		}
		return [];
	},

	setOtdelOkvedValue: function (otdel, okved) {
		var too = this.objs.T_SOTDEL_SOKVED,
			old = ArrayLib.filter(too, ['S_OTDEL'], otdel);
		Ext.each(okved, function (o) {
			o = (o.data || o);
			var pos = ArrayLib.find(old, ['S_OKVED'], o.LINK);
			if (pos === -1) {
				too.push({ 'LINK': o.LINK, 'LINK_SELF': o.LINK_SELF, 'CODE': o.CODE, 'S_OTDEL': otdel, 'S_OKVED': o.LINK });
			} else {
				old.splice(pos, 1);
			}
		});
		ArrayLib.removeList(too, old);
	},


	//#endregion таб Подконтрольные ОКВЭД

	//#region таб ОКВЭД
	//конструктор таба ОКВЭД
	createTabSelfOkved: function () {
		var me = this,
			objs = me.objs;

		objs.tabSelfOkved = Ext.create('Ext.panel.Panel', {
			title: 'ОКВЭД',
			layout: { type: 'vbox', align: 'stretch' },
			border: 0,
			scrollable: true,
			listeners: {
				activate: function () {
					if (!objs.gridSelfOkved) {
						//не смогла добиться, чтобы checkchange у грида ловил событие на колонке MAIN
						//подписываемся отдельно
						//var clmMain = objs.selfOkvedColumns.filter(function (clm) { return clm.dataIndex === "MAIN" });
						var clmMain = objs.selfOkvedColumns.filter(clm => { return clm.dataIndex === "MAIN" });
						if (clmMain.length > 0) {
							clmMain[0].listeners = {
								'beforecheckchange': function () {
									return !me.readOnly && !objs.tabSelfOkvedReadOnly && !me.isPasport;
								},
								'checkchange': function (column, rowIndex, checked) {
									var what = checked ? "основной" : "неосновной";
									var view = objs.gridSelfOkved.Grid.getView(),
										record = view.getRecord(view.getNode(rowIndex));

									selectDialogShow(wmc.get('Question'),
										wmc.getQuestion('CheckOKVED', what),
										function () {
											//у предыдущей основной строки снимаем флаг, у текущей - выставляем 
											var node = objs.gridSelfOkved.Grid.store.getRootNode().findChild('LINK', objs.selfOkvedMain, true);
											if (node) node.set('MAIN', false);
											objs.selfOkvedMain = record.get('LINK');
											var row = getRawRowByLink(objs.T_SORG_SOKVED, objs.selfOkvedMain);
											if (row) row.node.MAIN = true;
										},
										function () {
											record.reject();
										});
								}
							}
						}
						objs.gridSelfOkved = Ext.create('Keysystems.Base.List.Tree',
							{
								code: me.code,
								GateCode: me.keyEdit,
								linkCode: 'SOkved',
								profileKey: 'gridSelfOkved',
								closable: false,
								tabMode: true,
								checkModel: false,
								parentView: objs.tabSelfOkved,
								accessReadOnly: objs.tabSelfOkvedReadOnly || me.isPasport,
								needRefreshAfterSetData: false,
								getWhereArgs: function () {
									return {
										InLinksOnly: { value: 'True', type: 'bool' },
										InLinks: { value: JSON.stringify(me.getSelfOkvedLinks()), type: 'List_int' }
									};
								},
								baseRefresh: function (callBack, params) {
									var th = this;
									th.callParent([
										function (data) {
											//при обновлении с сервера выставим заново признак MAIN
											//если обновлять с локальных данных - не выстраивается иерархия
											if (!data) return;
											
											//сбрасываем флаг MAIN по всей иерархии
											let funcResetMain = (d) => {
												d.MAIN = false;
												d.children.forEach(c => c.MAIN = false);
											}
											data.data.forEach(d => funcResetMain(d));

											var rowMain = getRawRowByLink(data.data, me.objs.selfOkvedMain);
											if (rowMain) rowMain.node.MAIN = true;
											th.objs.Grid.loadData(data.data);
										}, params
									]);
								},
								head: false,
								hidePagging: true,
								getRowClass: function (rec) { return rec.get('MAIN') ? 'ks-main' : ''; },
								createTBar: function () {
									var th = this;
									th.objs.tbarBtns = {
										add_row: Ext.create('Ext.Button',
											{
												iconCls: 'x_btn_add_element',
												tooltip: 'Выбрать',
												tooltipType: 'title',
												hidden: objs.tabSelfOkvedReadOnly || me.isPasport,
												handler: function () {
													var data = th.objs.Grid.store.getDataExt();
													dictFunc({
														mode: 'MULTI',
														code: dnl.S_OKVED,
														checkList: data
													},
														{
															ok: function (value) {
																me.setSelfOkvedData(value);
																th.refresh();
															}
														});
												}
											}),
										delete_row: Ext.create('Ext.Button',
											{
												disabled: true,
												iconCls: 'x_btn_delete_element',
												tooltip: 'Удалить',
												tooltipType: 'title',
												hidden: objs.tabSelfOkvedReadOnly || me.isPasport,
												handler: function () {
													if (objs.tabOtdelOkvedReadOnly) return;
													var sel = th.Grid.selModel.getSelection()[0];
													if (sel) {
														var childs = sel.childNodes;
														th.Grid.removeSelection(_,
															function () {
																var pos = ArrayLib.find(objs.T_SORG_SOKVED,
																	['LINK'],
																	sel.get('LINK'));
																if (pos !== -1)
																	objs.T_SORG_SOKVED.splice(pos, 1);
																Ext.each(childs, function (c) { th.appendParent(c); });
															});
													}
												}
											}),
										expand: Ext.create('Ext.Button',
											{
												iconCls: 'x_btn_treeexpand',
												tooltip: 'Развернуть все узлы',
												tooltipType: 'title',
												handler: function () {
													th.Grid.expandAll();
												}
											}),
										collapse: Ext.create('Ext.Button',
											{
												iconCls: 'x_btn_treecollapse',
												tooltip: 'Свернуть все узлы',
												tooltipType: 'title',
												handler: function () {
													th.Grid.collapseAll();
												}
											})
									}
									th.objs.tbar = [
										th.objs.tbarBtns.add_row, th.objs.tbarBtns.delete_row, th.objs.tbarBtns.expand, th.objs.tbarBtns.collapse
									];
									if (objs.tabSelfOkvedReadOnly || me.isPasport) th.objs.tbarBtns.delete_row.setDisabled(true);
								},
								functions: {
									getData: function (endFunc, params) {
										loadProfile({
											gateCode: params.GateCode,
											controlName: params.controlName,
											code: me.code,
											profileKey: 'gridSelfOkved',
											callBack: function () {
												endFunc({
													columns: objs.selfOkvedColumns,
													fields: objs.selfOkvedFields,
													data: { data: objs.T_SORG_SOKVED, total: objs.T_SORG_SOKVED.length }
												});
											}
										});
									}
								},
								listeners: {
									ksAfterRefresh: function () {
										me.objs.gridSelfOkved && me.objs.gridSelfOkved.Grid.expandAll();
									}
								},
								getGridCfg: function () {
									let th = this,
										cfg = this.callParent(arguments);										

									cfg.listeners.selectionchange = function (_, sels) {
										th.objs.tbarBtns.delete_row.setDisabled(th.disabled || !sels.length);										
									};

									return cfg;
								},
							});
						objs.gridSelfOkved.Grid.expandAll();
					}
				}
			}
		});
		return objs.tabSelfOkved;
	},
	setSelfOkvedData: function (value) {
		var me = this,
			objs = me.objs;

		//одну из записей помечаем как основную. либо имещуюся либо первую из выбранных.
		var d = [];
		var mainFound = false;
		Ext.each(value, function (v) {
			var row = v.data || v;
			if (row.LINK === objs.selfOkvedMain) {
				mainFound = true;
				row.MAIN = true;
			} else
				row.MAIN = false;
			d.push(row);
		});
		if (!mainFound && d.length > 0) {
			objs.selfOkvedMain = d[0].LINK;
			d[0].MAIN = true;
		}
		this.objs.T_SORG_SOKVED = d;
	},

	getSelfOkvedData: function () {
		var res = [];
		Ext.each(this.objs.T_SORG_SOKVED, function (okved) { res.push(okved.data || okved); });
		return { data: res, total: res.length };
	},

	getSelfOkvedValue: function () {
		var res = [];
		Ext.each(this.objs.T_SORG_SOKVED, function (row) { res.push({ LINK: row.LINK }); });
		return res;
	},

	getSelfOkvedLinks: function () {
		var res = [];
		Ext.each(this.objs.T_SORG_SOKVED, function (row) { res.push(row.LINK); });
		return res;
	},

	//#endregion таб ОКВЭД

	//#region таб Дополнительно

	//конструктор таба Дополнительно
	createTabAdditional: function () {
		var me = this,
			objs = me.objs,
			t = 3;
		// ReSharper disable UseOfImplicitGlobalInFunctionScope
		for (var k in miscTypes.TypeOrg) {
			if (miscTypes.TypeOrg[k] === 'Финансирующая') {
				// ReSharper restore UseOfImplicitGlobalInFunctionScope
				t = k * 1;
				break;
			}
		}

		objs.finWhereArgs = { SType: { value: JSON.stringify([t]), type: 'List_int' } };
		objs.predWhereArgs = { NotInLinks: { value: JSON.stringify([objs.link]), type: 'List_int' } };

		return objs.tabAdditional = Ext.create('Ext.panel.Panel', {
			title: 'Дополнительно',
			layout: { type: 'vbox', align: 'stretch' },
			border: 0,
			bodyPadding: 10,
			flex: 1,
			scrollable: true,
			items: [
				objs.ABBR = Ext.create('Ext.form.field.Text', {
					fieldLabel: 'Аббревиатура',
					maxWidth: 300,
					maxLength: 50,
					enforceMaxLength: true,
					labelWidth: me.labelWidth
				}),
				me.createDictEdit({
					key: 'S_DOLG',
					mode: 'MULTI',
					//todo не нашла описания функционала по должностям для паспорта. либо ничего не делаем, либо закрываем все редактирование в hideEdit
					//listCfg: me.isPasport ? { btnsHide: { edit: true }, } : _,
					code: dnl.S_DOLG,
					fieldLabel: 'Должности'
				}),
				[
					me.createDictEdit({
						key: 'S_KBK',
						mode: 'SINGL',
						listCfg: me.isPasport ? { btnsHide: me.hideEdit, } : _,
						code: dnl.S_MINVO,
						fieldLabel: 'Глава',
						flex: 1
					}),
					objs.LIMIT_BY_KBK = Ext.create('Ext.form.field.Checkbox', {
						boxLabel: 'ограничивать объекты контроля',
						hidden: true,
						padding: '0 0 0 10'
					})
				],
				me.createDictEdit({
					key: 'S_ORG',
					mode: 'SINGL',
					whereArgs: objs.finWhereArgs,
					code: dnl['S_ORG'],
					fieldLabel: 'Финансирующая'
				}),
				me.createDictEdit({
					key: 'S_ORGPRED',
					mode: 'MULTI',
					whereArgs: objs.predWhereArgs,
					code: dnl['S_ORG'],
					fieldLabel: 'Правопредшественник',
					setValue: function (val) {
						const links = [];
						Ext.each(val, function (v) { links.push(v.data ? v.data.LINK : v.LINK); });
						
						//отображение/скрытие кнопки иерархии
						const treeBtn = this.fieldCode.getTrigger('trigger1');
						if (treeBtn) {
							//после рендера работаем с dom
							if (treeBtn.el)
								treeBtn.el[links.length ? 'removeCls' : 'addCls']('ks-hidden');
							//до рендера работаем со св-м cls
							else {
								if (!links.length){
									if (treeBtn.cls.indexOf('ks-hidden') < 0) treeBtn.cls += " ks-hidden";
								}
								else
									treeBtn.cls = treeBtn.cls.replace('ks-hidden', '');
							}	
						}
						
						if (!me.isLoaded) {
							me.orgPredChanded = !ArrayLib.equal(this.getLinks(), links);
						}
						this.callParent(arguments);
					},
					clear: Ext.emptyFn
				},
					function (o) {
						o.handler =
							[
								{
									cls: 'x_btn_tree x-dict-trigger',									
									handler: function () {
										if (me.objs.S_ORGPRED.getLinks().length) {
											var func = function (reloadData) {
												dictFunc({
													parentView: objs.view,
													code: dnl.S_ORG,
													checkModel: false,
													isItemDblClick: false,
													reloadData: reloadData,
													btnsHide: {
														new: true,
														edit: true,
														delete: true,
														same: true,
														add_slave: true,
														search: true,
														reset: true,
														show_actual: true,
														make_child: true,
														make_parent: true
													},
													whereArgs: {
														OrgPred: { value: me.data.get('LINK'), type: 'int' }
													}
												});
											}

											if (me.orgPredChanded) {
												me.checkFilled(res => {
													if (!res) return;
													
													me.saveData(function () {
														me.orgPredChanded = false;
														func(true);
													});
												});												
											} else {
												func(false);
											}
										}
									}
								},
								o.handler
							];

						return o;
					}),
				objs.CNTPERSON = Ext.create('Ext.form.field.Number', {
					fieldLabel: 'Количество сотрудников',
					maxWidth: 300,
					maxValue: 32766,
					minValue: 0,
					ksLimitMaxMin: true,
					labelWidth: me.labelWidth
				})
			]
		});
	},

	//#endregion таб Дополнительно

	//#region таб Подразделения

	//конструктор таба Подразделения
	createTabOtdels: function () {
		var me = this,
			objs = me.objs;

		me.sksc('tabOtdels', Ext.create('Ext.panel.Panel', {
			title: 'Подразделения',
			layout: { type: 'vbox', align: 'stretch' },
			border: 0,
			bodyBorder: false,
			items: []
		}));

		// Base.List.Tree для отображения иерархии
		me.sksc('formOtdel', Ext.create('Keysystems.Base.List.Tree',
			{
				code: 'DICTIONARY_SOTDEL',
				GateCode: 'DICTIONARY_SOTDEL',
				title: 'Подразделения',
				parentView: me.gksc('tabOtdels'),
				head: false,
				closable: false,
				tabMode: true,
				checkModel: false,
				handler: 'Keysystems.Base.List.Tree',
				editClass: 'Keysystems.SOtdel.Edit',
				linkCode: 'SOtdel',
				deleteCode: 'S_OTDEL',
				btnsHide: { search: true, relations: true, exit: true },
				hidePagging: true,
				pageSize: 100000,
				accessReadOnly: me.accessReadOnly || me.readOnly,
				getWhereArgs: function () {
					var link = me.getLink();
					return link
						? { SOrgs: { value: JSON.stringify([link]), type: 'List_int' } }
						: { InLinks: { value: '[]', type: 'List_int' }, InLinksOnly: { value: 'True', type: 'bool' } };
				},
				show: function () {
					this.callParent(arguments);
					me.oldData = JSON.stringify(me.dataCollector());
				},
				listeners: {
					ksAfterRefresh: function () {
						if (me.regionAccessible || me.okvedAccessible) {
							const otdels = this.Grid.store.getDataExt();
							let data = {};
							Ext.each(otdels, function (o) {
								let d = (o.data || o);
								data[d.LINK] = d.NAME;
							});

							if (me.okvedAccessible) {
								me.getTab('Okved').setDisabled(!otdels.length);
								objs.cmbOtdelOkved.loadData(CBDataLib.get('', _, data), false);
								objs.cmbOtdelOkved.setValueSelectOrFrst();
							}

							if (me.regionAccessible) {
								objs.cmbOtdelRegion.loadData(CBDataLib.get('', _, data), false);
								me.updRegion();
							}
						}
						
					}
				},
				edit: function (f, data, defCfg) {
					if (!me.getLink()) {
						var dict = this,
							args = arguments;
						me.needSaveMsgShow({
							ok: function () {
								me.checkFilled(res => {
									if (!res) return;
									me.saveData(function () { if (me.getLink()) dict.edit.apply(dict, args); });
								});
							}
						});
						return _;
					}
					defCfg = defCfg || {};
					defCfg.S_ORG = me.getLink();
					return this.callParent([f, data, defCfg]);
				}
			}));
		return me.gksc('tabOtdels');
	},
	
	//#endregion таб Подразделения

	//#region таб Сотрудники

	//конструктор таба Сотрудники
	createTabPersons: function () {
		var me = this,
			objs = me.objs;

		me.sksc('tabPersons', Ext.create('Ext.panel.Panel', {
			title: 'Сотрудники',
			layout: { type: 'vbox', align: 'stretch' },
			border: 0,
			bodyBorder: false,
			items: []
		}));

		me.sksc('formPerson', Ext.create('Keysystems.Base.List',
			{
				code: dnl.S_PERSON,
				GateCode: 'DICTIONARY_SPERSON',
				title: 'Сотрудники',
				parentView: me.gksc('tabPersons'),
				head: false,
				closable: false,
				tabMode: true,
				checkModel: false,
				handler: 'Keysystems.Base.List',
				editClass: 'Keysystems.Edits.Person',
				linkCode: 'SPerson',
				deleteCode: 'S_PERSON',
				btnsHide: { search: true, relations: true, exit: true },
				hidePagging: true,
				pageSize: 100000,
				accessReadOnly: me.accessReadOnly || me.readOnly,
				getRowClass: function (rec) {
					return rec.get('ORGS').toString() === ''
						? 'ks-textgray'
						: (rec.get('IS_RUK').toString() === "1" || rec.get('IS_RUK').toString() === "true"
							? 'ks-main'
							: '');
				},
				getWhereArgs: function () {
					var link = me.getLink();
					return link
						? { SOrgs: { value: JSON.stringify([link]), type: 'List_int' } }
						: { InLinks: { value: '[]', type: 'List_int' }, InLinksOnly: { value: 'True', type: 'bool' } };
				},
				show: function () {
					this.callParent(arguments);
					me.oldData = JSON.stringify(me.dataCollector());
				},
				listeners: {
					ksAfterRefresh: function () {
					}
				},
				edit: function (f, data, defCfg) {
					if (!me.getLink()) {
						var dict = this,
							args = arguments;
						me.needSaveMsgShow({
							ok: function () {
								me.checkFilled(res => {
									if (!res) return;
									me.saveData(function () { if (me.getLink()) dict.edit.apply(dict, args); });
								});
							}
						});
						return _;
					}
					defCfg = defCfg || {};
					defCfg["SOrg"] = me.getLink();
					return this.callParent([f, data, defCfg]);
				}
			}));
		return me.gksc('tabPersons');
	},

	//#endregion Сотрудники

	//конструктор таба Филиалы
	createTabFilials: function () {
		var me = this;

		me.sksc('tabFilials', Ext.create('Ext.panel.Panel', {
			title: 'Филиалы',
			layout: { type: 'vbox', align: 'stretch' },
			border: 0,
			bodyBorder: false,
			items: []
		}));

		// Base.List.Tree для отображения иерархии
		Ext.create('Keysystems.Base.List.Tree',
			{
				code: 'DICTIONARY_SORG',
				GateCode: 'DICTIONARY_SORG',
				parentView: me.gksc('tabFilials'),
				head: false,
				closable: false,
				tabMode: true,
				mode: 'SINGL',
				isItemDblClick: false,
				checkModel: false,
				handler: 'Keysystems.Base.List.Tree',
				linkCode: 'SOrg',
				getWhereArgs: function () {
					return {
						InLinksOnly: { value: 'True', type: 'bool' },
						InLinks: { value: JSON.stringify(me.gksd('filialLinks')), type: 'List_int' }
					};
				},
				createTBar: function () {
					var th = this;

					th.objs.tbarBtns = {
						select: Ext.create('Ext.Button',
							{
								iconCls: 'x_btn_add_element',
								tooltip: 'Выбрать',
								tooltipType: 'title',
								disabled: me.gksd('tabFilial').readOnly,
								handler: function () {
									var data = th.objs.Grid.store.getDataExt();
									dictFunc({
										code: dnl.S_ORG,
										ignoreEditInitialConfig: ['GateCode', 'show', 'readOnly', 'setRecord'],
										checkList: data,
										whereArgs: { MainOrgFilial: { value: me.data.get('LINK'), type: 'int' } },
										setRecord: function (row, cmp) {
											this.callParent(arguments);

											var l = cmp.data.get('LINK_SELF');
											cmp.data.set(row);
											if (l !== row.LINK_SELF) th.appendParent(cmp.data);
											th.refresh(true, 1);
										}
									},
										{
											ok: function (records) {
												var links = [];
												Ext.each(records, function (rec) { links.push(rec.get('LINK')); });
												me.sksd('filialLinks', links);
												if (links.length !== 0) {
													th.refresh();
												} else {
													th.getGrid().getStore().getRootNode().removeAll();
													th.getGrid().getView().refresh();
												}
											}
										});
								}
							}),
						remove: Ext.create('Ext.Button',
							{
								iconCls: 'x_btn_delete_element',
								tooltip: 'Удалить',
								tooltipType: 'title',
								disabled: me.gksd('tabFilial').readOnly,
								handler: function () {
									// в случае возникновения сложностей нижний код можно заменить на лазание на сервак -> th.refresh();
									var sel = th.Grid.selModel.getSelection()[0];
									if (sel) {
										var childs = sel.childNodes;
										th.Grid.removeSelection(_,
											function () {
												var filialLinks = me.gksd('filialLinks');
												var index = filialLinks.indexOf(sel.get('LINK'));
												if (index !== -1) filialLinks.splice(index, 1);

												Ext.each(childs, function (c) { th.appendParent(c); });
											});
									}
								}
							})
					};
					th.objs.tbar = [
						th.objs.tbarBtns.select, th.objs.tbarBtns.remove
					];
				},
				functions: {
					getData: function (endFunc) {
						var tabFilial = me.gksd('tabFilial');
						endFunc({
							columns: tabFilial.columns,
							fields: tabFilial.fields,
							data: { data: tabFilial.data, total: tabFilial.data.length }
						});
					}
				}
			});

		return me.gksc('tabFilials');
	},

	//сообщение о необходимости сохранения
	needSaveMsgShow: function (cfg) {
		Ext.Msg.show({
			title: KS.L10n.attention,
			msg: wmc.get('NeedSaveOrg'),
			buttons: Ext.MessageBox.OKCANCEL,
			buttonText: { ok: 'Сохранить' },
			fn: function (buttonId) {
				var fn = cfg[buttonId] || cfg.default;
				if (fn) fn();
			},
			icon: Ext.MessageBox.INFO
		});
	},

	//конфигурация основого окна
	viewCfg: function () {
		var result = this.callParent(arguments);
		result.resizable = true;
		result.maximizable = true;
		result.width = this.width;
		this.iconCls && (result.iconCls = this.iconCls);
		return result;
	},

	//Сборка данных таба "Общее"
	dataCollectorGeneral: function () {
		var me = this,
			objs = me.objs,
			res = {};

		Ext.each(me._arrGeneralRow, function (key) {
			const c = objs[key];
			if (!c.isHidden()) res[key] = c.getValue();
			if (key === "DH1" || key === "DH2") res[key] = res[key]?.toDateString();
		});
		 

		Ext.each(me._arrGeneralSingl, function (key) {
			var c = objs[key];
			if (!c.isHidden()) res[key] = c.getLink();
		});

		res.LINK_SELF = me.ksData.LINK_SELF;

		if (!objs.S_TYPEORG.isHidden()) {
			res.S_TYPEORG = objs.S_TYPEORG.getLinks(1);
		}

		return res;
	},

	//Сборка данных таба "История"
	dataCollectorHistory: function () {
		var me = this;
		return me.getTabVisible('History') ? me.getTab('History').getData() : _;
	},

	//Сборка данных таба "Реквизиты"
	dataCollectorProp: function () {
		var me = this;

		return me.getTabVisible('Prop') ? me.getTab('Prop').getData() : _;
	},

	//Сборка данных таба "История изменений"
	dataCollectorChangeHistory: function () {
		var me = this,
			objs = me.objs,
			res = {};

		if (objs.isTabChangeHistory) {
			var verSOrg = [];
			objs.VER_S_ORG.store.each(function (rec) {
				let row = {};
				Object.assign(row, rec.data);
				row.DT = rec.data.DT ? rec.data.DT.toDateString() : null;
				row.STypeOrg = JSON.stringify(rec.data.STypeOrg);
				verSOrg.push(row);
			});
			res = verSOrg;
		}
		return res;
	},

	//Сборка данных таба "Подконтрольные ОКВЭД"
	dataCollectorRegions: function () {
		const me = this;

		if (me.regionAccessible) {
			let res = {},
			    objs = me.objs,
				tSOrgSRegion = [];
			Ext.each(objs.tSOrgSRegion, function (or) {
				tSOrgSRegion.push(or.LINK);
			});
			res.tSOrgSRegion = JSON.stringify(tSOrgSRegion);

			let tSOtdelSRegion = {};
			for (let otdel in objs.tSOtdelSRegion) {
				let regions = objs.tSOtdelSRegion[otdel];
				tSOtdelSRegion[otdel] = [];
				Ext.each(regions, function (r) {
					tSOtdelSRegion[otdel].push(r.LINK);
				});
			}

			res.tSOtdelSRegion = JSON.stringify(tSOtdelSRegion);
			res.otdelRegionRnorm = JSON.stringify(objs.otdelRegionRnorm);
			return res;
		}
		return _;
	},

	//Сборка данных таба "Подконтрольные ОКВЭД"
	dataCollectorOkved: function () {
		const me = this;
		if (me.okvedAccessible) {
			const otdel = me.objs.cmbOtdelOkved.getStore().getDataExt().map(r => r.index);
			let res = {};
			Ext.each(otdel, function (ot) {
				var okved = ArrayLib.filter(me.objs.T_SOTDEL_SOKVED, ['S_OTDEL'], ot),
					oks = res[ot] = [];
				Ext.each(okved, function (ok) {
					oks.push(ok.S_OKVED);
				});
			});

			return res;
		}
		return _;
	},

	dataCollectorSelfOkved: function () {
		if (this.getTabVisible('SelfOkved')) {
			let rows = [];
			if (this.objs.gridSelfOkved) {
				rows = this.objs.gridSelfOkved.Grid.store.getDataExt();
			} else {
				const appendArr = function (row) {
					rows.push(row);
					row.children?.forEach(child => {
						appendArr(child);
					})
				}
				this.objs.T_SORG_SOKVED.forEach(r => {
					appendArr(r);
				});
			}

			return rows.map(r => {
				return {
					LINK: r.LINK,
					MAIN: r.MAIN
				}
			});
		}
		return _;
	},

	//Сборка данных таба "Дополнительно"
	dataCollectorAdditional: function () {
		var me = this;

		if (me.getTabVisible('Additional')) {
			var objs = me.objs,
				res = {};

			Ext.each(me._arrAdditionalRow, function (key) {
				var c = objs[key];
				if (!c.isHidden()) res[key] = c.getValue();
			});

			Ext.each(me._arrAdditionalSingl, function (key) {
				var c = objs[key];
				if (!c.isHidden()) res[key] = c.getLink();
			});

			Ext.each(me._arrAdditionalMulti, function (key) {
				var c = objs[key];
				if (!c.isHidden()) res[key] = c.getLinks(1);
			});

			return res;
		}
		return _;
	},

	//Сборка данных таба "Филиалы"
	dataCollectorFilials: function () {
		var me = this, res = _;
		if (me.gksc('tabFilials')) {
			res = { filialLinks: JSON.stringify(me.gksd('filialLinks')) };
		}
		return res;
	},

	//Сборка всех данных
	dataCollector: function () {
		var me = this,
			res = me.callParent(arguments);

		res.tabGeneral = JSON.stringify(me.dataCollectorGeneral());

		var data = me.dataCollectorProp();
		if (data) res.tabProp = JSON.stringify(data);

		data = me.dataCollectorChangeHistory();
		if (data) res.tabChangeHistory = JSON.stringify(data);

		data = me.dataCollectorOkved();
		if (data) res.tabOkved = JSON.stringify(data);

		data = me.dataCollectorSelfOkved();
		if (data) res.tabSelfOkved = JSON.stringify(data);

		data = me.dataCollectorAdditional();
		if (data) res.tabAdditional = JSON.stringify(data);

		data = me.dataCollectorRegions();
		if (data) res.tabRegions = JSON.stringify(data);

		data = me.dataCollectorFilials();
		if (data) res.tabFilials = JSON.stringify(data);

		res.DIRECTOR_EGRUL = JSON.stringify(me.directorEgrul);

		return res;
	},

	//загрузка данных таба "Общее"
	getExtraGeneral: function (value) {
		var me = this,
			objs = me.objs,
			access = value.row._Access;
		
		me.sksd('individ', value.individ);

		me.setObjsValuesAndAccess(value.row, access, me._arrGeneralRow);
		me.setObjsValuesAndAccess(value.tabGeneral, access, me._arrGeneralSingl);
		me.setObjsValuesAndAccess(value.tabGeneral, value.multiAccess, me._arrGeneralMulti);

		me.setObjsAllow(value.dsAllow.S_ORG, me._arrGeneralRow.concat(me._arrGeneralSingl));
		me.setObjsAllow(value.dsAllow.T_STYPEORG_SORG, ['S_TYPEORG']);
		me.setObjsAllow(value.dsAllow.S_ORG, ['S_ADRF', 'S_ADRU']);

		if (objs.S_REGION.isEmpty && me.f === 'new') objs.S_REGION.setValue(user.region);

		me.sksd('adrVf', value.adrVf);
		objs.S_ADRU.visibleFields = value.adrVf;
		objs.S_ADRF.visibleFields = value.adrVf;
		
		objs.S_ADRU.ksSetValue(value.tabGeneral.S_ADRU);
		objs.S_ADRF.ksSetValue(value.tabGeneral.S_ADRF);
		
		me.directorEgrul = {};
	},

	//загрузка данных таба "Реквизиты"
	getExtraProp: function (value) {
		if (value.tabProp) {
			var me = this;
			me.objs.allTab.changeTab(me.getTab('Prop').loadData(value.tabProp), true);
		}
	},

	initEditorHistorySAdr: function(column, adrVf) {
		var th = this,
			editor = th.editor || (th.editor = Ext.create({
				xtype: 'triggerdict',
				cleaningKey: th.cleaningKey,
				dataIndex: th.dataIndex
			}));
		th.column = column;
	
		if (!editor.defaultRenderer) editor.defaultRenderer = th.defaultRenderer.bind(th);
		if (!editor.trgClick) {
			editor.trgClick = editor.handler ||
				(
					editor.handler = function() {
						var e = editor;
						th.beforeHandler(function () {
							var link = editor.editRecord.data[th.column],
								cfg = {
									f: link ? 'edit' : 'new',
									link: link,
									data: { data: { LINK: link } },
									code: dnl.S_ADR,
									readOnly: th.readOnly,
									updRecord: function(row) {
										var el = editor.triggers.dict,
											rec = editor.editRecord,
											newCls = row.LINK ? 'x-dict-trigger x_btn_edit' : 'x-dict-trigger x_btn_new';
										if (el.el){
											el.el.removeCls(el.cls);
											el.el.addCls(el.cls = newCls);
										}
										else{
											el.cls = newCls;
										}
										rec.beginEdit();
										rec.set(th.column, row.LINK);
										rec.set(th.dataIndex, row[adrVf]);
										rec.endEdit();
									}
								};
							Ext.apply(cfg, dictListController.DICTIONARY_SADR);
							Ext.create(cfg.editClass, cfg);
						}, e.editRecord, e);
					});
		}
	},
	getExtraChangeHistory: function(value) {
		var me = this,
			objs = me.objs,
			tab = me.getTab('ChangeHistory'),
			tabVal = value.tabChangeHistory,
			readOnly = me.getReadOnly() || !(me.getTabAccess(value.Tabs, 'CHANGEHISTORY') & ObjAccessMask.EDIT);

		objs.allTab.changeTab(tab, true);

		if (tabVal) {
			objs.isTabChangeHistory = true;
			let pos = ArrayLib.find(tabVal.fields, ['name'], 'DT');
			if (pos !== -1)
				tabVal.fields[pos].sortType = function(v) {
					return v ? v : longPeriod.end;
				};

			Ext.each(tabVal.columns, function(c, i) {
				c.sortable = false;
				if (c.dataIndex.indexOf('TEMP_S') === 0) {
					c.width = 150;
					c.xtype = 'dictcolumn';
					c.cleaningKey = false;
					c.mode = 'SINGL';
					c.readOnly = readOnly;
				}
				if (c.dataIndex !== 'DT') {
					c.renderer = function (v, meta, rec) {
						var cls = me.getChangeHistoryCellCls(c.dataIndex, v, rec);
						if (cls) meta.tdCls = cls;
						return v;
					};
				}
				switch (c.dataIndex) {
					case 'DT':
						c.xtype = 'datecolumn';
						c.format = 'd.m.Y';
						if (!readOnly)
							c.editor = { xtype: 'datefield', format: 'd.m.Y' };
						break;
					case 'TEMP_SKBK_NAME':
						c.code = dnl.S_MINVO;
						c.ksGetValue = function (rec) {
							return [{ LINK: rec.get("S_KBK") }];
						};
						c.defaultRenderer = function (v, m, r) {
							if (v === "0") v = null;
							return (v || (r ? (r.data || r)["TEMP_SKBK_NAME"] : _)) || _;
						};
						c.ksSetValue = function (v, rec) {
							var d = v[0];
							d = d ? (d.data || d) : { LINK: 0 };
							rec.beginEdit();
							rec.set('S_KBK', d.LINK);
							rec.set('TEMP_SKBK_NAME', d.CODE ? d.CODE + ' ' + d.NAME : d.NAME);
							rec.endEdit();
						}
						break;
					case 'TEMP_SOKOPF_NAME':
						c.code = dnl.S_OKOPF;
						c.defaultRenderer = function (v, m, r) {
							if (v === "0") v = null;
							return (v || (r ? (r.data || r)["TEMP_SOKOPF_NAME"] : _)) || _;
						};
						c.ksGetValue = function (rec) { return [{ LINK: rec.get("S_OKOPF") }]; };
						c.ksSetValue = function (v, rec) {
							var d = v[0];
							d = d ? (d.data || d) : { LINK: 0 };
							rec.beginEdit();
							rec.set('S_OKOPF', d.LINK);
							rec.set('TEMP_SOKOPF_NAME', d.CODE ? d.CODE + ' ' + d.NAME : d.NAME);
							rec.endEdit();
						}
						break;
					case 'TEMP_SADRU_NAME':
						c.code = dnl.S_ADR;
						c.ignoreCodeField = true;
						c.defaultRenderer = function(v, m, r) {
							var el = this.editor.triggers.dict,
								newCls = (readOnly && r.data.S_ADRU 
									? 'x_btn_open'
									: r.data.S_ADRU
										? 'x_btn_edit'
										: 'x_btn_new') + ' x-dict-trigger';							
							if (el.el) {
								el.el.removeCls(el.cls);
								el.el.addCls(el.cls = newCls);
								if (readOnly && !r.data.S_ADRU) el.el.addCls('ks-hidden');
							}
							return (v || (r ? (r.data || r)["TEMP_SADRU_NAME"] : _)) || _;
						};
						c.ksGetValue = function(rec) { return [{ LINK: rec.get("S_ADRU") }]; };
						c.initEditor = function() {
							me.initEditorHistorySAdr.call(this, 'S_ADRU', me.gksd('adrVf'));
						};
						break;
					case 'TEMP_SADRF_NAME':
						c.code = dnl.S_ADR;
						c.ignoreCodeField = true;
						c.defaultRenderer = function(v, m, r) {
							var el = this.editor.triggers.dict,
								newCls = (readOnly && r.data.S_ADRF
									? 'x_btn_open'
									: r.data.S_ADRF
										? 'x_btn_edit'
										: 'x_btn_new') + ' x-dict-trigger';
							if (el.el) {
								el.el.removeCls(el.cls);
								el.el.addCls(el.cls = newCls);
								if (readOnly && !r.data.S_ADRF) el.el.addCls('ks-hidden');
							}
							return (v || (r ? (r.data || r)["TEMP_SADRF_NAME"] : _)) || _;
						};
						c.ksGetValue = function(rec) { return [{ LINK: rec.get("S_ADRF") }]; };
						c.initEditor = function() {
							me.initEditorHistorySAdr.call(this, 'S_ADRF', me.gksd('adrVf'));
						};
						break;
					case 'TEMP_STYPEORG_NAME':
						c.code = dnl.S_TYPEORG;
						c.mode = 'MULTI';
						c.ignoreCodeField = true;
						c.defaultRenderer = function (v, m, r) {
							return (v || (r ? (r.data || r)["TEMP_STYPEORG_NAME"] : _)) || _;
						};
						c.ksGetValue = function (rec) {
							let verTypes = rec.data.STypeOrg || [];
							let res = [];
							Ext.each(verTypes, function (t) {
								res.push({ LINK: t });
							});
							return res;
						};
						c.ksSetValue = function (v, rec) {
							let newLinks = v.map(r => r.get("LINK"));
							rec.data.STypeOrg = newLinks;

							let res = v.map(r => r.get('NAME')).sort().join('; ');
							rec.set('TEMP_STYPEORG_NAME', res);
						}
						break;
				}
			});

			objs.VER_S_ORG.setMetaDate(tabVal, {
				profileCode: me.code,
				profileKey: 'gridVersion',
				gateCode: 'edit'
			});	
		}
	},

	getChangeHistoryCellCls: function(column, v, rec) {
		var objs = this.objs,
			hasChangesWitPrev = false,
			hasChangesWithCur = false;

		var posPrev = objs.VER_S_ORG.store.findBy(function(r) {
			return r.data.DT < rec.data.DT;
		});
		if (posPrev !== -1) {
			var prevRow = objs.VER_S_ORG.store.getAt(posPrev);
			if (prevRow) {
				hasChangesWitPrev = prevRow.data[column] !== v;
			}
		}
		var posNext = objs.VER_S_ORG.store.findBy(function(r) {
			return r.data.DT > rec.data.DT;
		});
		if (posNext === -1) {
			switch (column) {
				case 'CODE':
				case 'NAME':
				case 'SNAME':
					hasChangesWithCur = objs[column].getValue() !== v;
					break;
				case 'TEMP_SKBK_NAME':
					var sKbk = objs.S_KBK.getValue()[0];
					hasChangesWithCur = (sKbk ? (sKbk.data || sKbk).LINK : 0) !== (rec.data.S_KBK || 0);
					break;
				case 'TEMP_SOKOPF_NAME':
					var sokopf = objs.S_OKOPF.getValue()[0];
					hasChangesWithCur = (sokopf ? (sokopf.data || sokopf).LINK : 0) !== (rec.data.S_OKOPF || 0);
					break;
				case 'TEMP_SADRF_NAME':
					var sadrf = objs.S_ADRF.getValue()[0];
					hasChangesWithCur = (sadrf ? (sadrf.data || sadrf).LINK : 0) !== (rec.data.S_ADRF || 0);
					break;
				case 'TEMP_SADRU_NAME':
					var sadru = objs.S_ADRU.getValue()[0];
					hasChangesWithCur = (sadru ? (sadru.data || sadru).LINK : 0) !== (rec.data.S_ADRU || 0);
					break;
				case 'TEMP_STYPEORG_NAME':
					var sTypeOrg = objs.S_TYPEORG.getValue();
					if (sTypeOrg) {
						let curLinks = sTypeOrg.map(r => (r.data || r).LINK);
						let verLinks = rec.data.STypeOrg;
						hasChangesWithCur = !ArrayLib.equal(curLinks, verLinks);
					}
					break;
			}
		}

		return hasChangesWitPrev && hasChangesWithCur
			? 'colorize-version-mix'
			: (hasChangesWitPrev
				? 'colorize-version-prev'
				: (hasChangesWithCur
					? 'colorize-version-next'
					: null));
	},

	//загрузка данных таба "Подконтрольные территории"
	getExtraRegions: function (value) {
		var tabVal = value.tabRegions;
		if (tabVal) {
			var me = this;

			me.regionAccessible = true;
			me.checkTypeOrg = 1;

			// ReSharper disable UseOfImplicitGlobalInFunctionScope
			for (var k in miscTypes.TypeOrg) {
				if (miscTypes.TypeOrg[k] === 'Проверяющая') {
					// ReSharper restore UseOfImplicitGlobalInFunctionScope
					me.checkTypeOrg = k * 1;
					break;
				}
			}

			var objs = me.objs,
				tab = me.getTab('Regions');

			objs.allTab.changeTab(tab, true);

			objs.regionColumns = tabVal.columns;
			objs.regionFields = tabVal.fields;

			objs.otdelRegionRnorm = tabVal.otdelRegionRnorm;
			objs.tSOrgSRegion = tabVal.tSOrgSRegion;
			objs.tSOtdelSRegion = tabVal.tSOtdelSRegion;

			objs.gridRegionsRnormAccess = value.multiAccess.GRID_SRNORM;

			var res = {};
			Ext.each(tabVal.tSOtdelSRegion, function (r) {
				var list = res[r.S_OTDEL] || (res[r.S_OTDEL] = []);
				r = ArrayLib.filter(tabVal.tSOtdelSRegionData, ['LINK'], r.S_REGION);
				if (r && list.indexOf(r[0]) === -1) list.push(r[0]);
			});
			objs.tSOtdelSRegion = res;

			me.showHideTabsRegionsOkveds();
		}
	},

	//загрузка данных таба "Подконтрольные ОКВЭД"
	getExtraOkved: function (value) {
		var tabVal = value.tabOkved;
		if (tabVal) {
			var me = this,
				objs = me.objs,
				tab = me.getTab('Okved');

			me.okvedAccessible = true;

			objs.allTab.changeTab(tab, true);

			objs.T_SOTDEL_SOKVED = tabVal.data;
			me.showHideTabsRegionsOkveds();
		}
	},

	//загрузка данных таба "ОКВЭД"
	getExtraSelfOkved: function (value) {
		var tabVal = value.tabSelfOkved;
		if (tabVal) {
			var me = this,
				objs = me.objs,
				tab = me.getTab('SelfOkved');

			objs.allTab.changeTab(tab, true);
			objs.T_SORG_SOKVED = tabVal.data;
			objs.selfOkvedRequired = tabVal.required;
			objs.selfOkvedColumns = tabVal.columns;
			objs.selfOkvedFields = tabVal.fields;
			objs.selfOkvedMain = tabVal.main;
		}
	},

	//загрузка данных таба "Дополнительно"
	getExtraAdditional: function (value) {
		var tabVal = value.tabAdditional;
		if (tabVal) {
			var me = this,
				objs = me.objs,
				access = value.row._Access,
				tab = me.getTab('Additional');

			objs.allTab.changeTab(tab, true);

			me.setObjsValuesAndAccess(value.row, access, me._arrAdditionalRow);
			me.setObjsValuesAndAccess(tabVal, access, me._arrAdditionalSingl);
			me.setObjsValuesAndAccess(tabVal, value.multiAccess, me._arrAdditionalMulti);
			if (me.f === 'copy') tabVal.S_PERSON = [];

			me.setObjsAllow(value.dsAllow.S_ORG, me._arrAdditionalRow.concat(me._arrAdditionalSingl));
			me.setObjsAllow(value.dsAllow.T_SORG_SDOLG, ['S_DOLG']);
			me.setObjsAllow(value.dsAllow.T_SORG_SORGPRED, ['S_ORGPRED']);

			me.showHideLimitByKbk(objs.S_TYPEORG.getValue());
		}
	},

	//загрузка данных таба "Подразделения"
	getExtraOtdels: function (value) {
		var me = this,
			objs = me.objs;

		objs.tabOtdelsReadOnly = me.isTabReadOnly(value.Tabs, 'OTDELS');
		var tab = me.getTab('Otdels');
		objs.allTab.changeTab(tab, true);
	},

	//загрузка данных таба "Сотрудники"
	getExtraPersons: function (value) {
		var me = this,
			objs = me.objs;	
		objs.allTab.changeTab(me.getTab('Persons'), true);
	},

	//загрузка данных таба "Филиалы"
	getExtraFilials: function (value) {
		var tabVal = this.sksd('tabFilial', value.tabFilial);
		if (tabVal) {
			var me = this,
				objs = me.objs,
				tab = me.getTab('Filials');

			objs.allTab.changeTab(tab, true);
		}
	},

	getExtra: function (callBack, link) {
		var me = this;
		me.baseGetExtra({ link: link }, function (value) {
			me.sksd('decimalData', value.decimalData);
			
			me.getExtraGeneral(value);

			me.getExtraProp(value);
			me.getExtraChangeHistory(value);
			me.getExtraRegions(value);
			me.getExtraOkved(value);
			me.getExtraSelfOkved(value);
			me.getExtraAdditional(value);

			if (me.getTabAccess(value.Tabs, 'OTDELS')) {
				me.getExtraOtdels(value);
			}

			if (me.getTabAccess(value.Tabs, 'PERSONS')) {
				me.getExtraPersons(value);
			}

			if (value.multiAccess.FILIALS) {
				me.sksd('tabFilial', value.tabFilial);
				me.sksd('filialLinks', value.tabFilial.filialLinks);

				me.getExtraFilials(value);
			}

			if (me.objs.cmbOtdelOkved) {
				me.objs.cmbOtdelOkved.loadData(CBDataLib.get('', _, value.otdels), false);
				me.objs.cmbOtdelOkved.setValueSelectOrFrst();
			}

			if (me.objs.cmbOtdelRegion)
				me.objs.cmbOtdelRegion.loadData(CBDataLib.get('', _, value.otdels), false);

			me.visibleSyncCHButton();
			me.setTabsAccess(value.Tabs);
			if (callBack) callBack();
		});
	},

	isSelfOkvedFilled: function () {
		var me = this,
			objs = me.objs;
		if (!objs.selfOkvedReqired && objs.storeSelfOkved.length === 0) {
			warning(wmc.get('Input', 'ОКВЭД'));
			return false;
		}
		return true;
	},

	isGeneralFilled: function () {
		var me = this,
			objs = me.objs,
			res = true;
		Ext.each(me._arrGeneralRow.concat(me._arrGeneralSingl.concat(me._arrGeneralMulti)), function (key) {
			var c = me.gksc(key) || objs[key];
			if (c.ksAllowEmpty && KsLib.isEmptyControl(c)) {
				me.addToInvalidControls(c, {parent: me.objs.allTab, tab: me.getTab('General')});
				res = false;
			}			
		});
		return res;
	},

	isAdditionalFilled: function () {
		var me = this,
			res = true;
		if (me.getTabVisible('ChangeHistory')) {
			var objs = me.objs;

			Ext.each(me._arrAdditionalRow.concat(me._arrAdditionalSingl.concat(['S_DOLG', 'S_ORGPRED'])), function (key) {
				var c = me.gksc(key) || objs[key];
				if (c.ksAllowEmpty && KsLib.isEmptyControl(c)) {
					me.addToInvalidControls(c, {parent: me.objs.allTab, tab: me.getTab('Additional')});
					res = false;
				}
				return res;
			});
		}

		return res;
	},

	isChangeHistoryFilled: function () {
		var me = this,
			objs = this.objs;

		var posEmpty = objs.VER_S_ORG.store.findBy(r => !r.data.DT);
		if (posEmpty !== -1) {
			me.addToInvalidControls(objs.VER_S_ORG, {
				parent: me.objs.allTab,
				tab: me.getTab('ChangeHistory'),
				title: 'Конец периода действия'
			});
			return false;
		}
		return true;
	},

	isFilled: function () {
		return this.isGeneralFilled() & this.isChangeHistoryFilled() & this.isAdditionalFilled();		
	},

	profileListeners: [{ name: 'view', method: 'FormParam' }],

	visibleSyncCHButton: function () {
		var me = this,
			objs = me.objs,
			inn = objs.INN.getValue().replace(regSpace, ''),
			ogrn = objs.OGRN.getValue().replace(regSpace, ''),
			individ = me.gksd('individ') !== null && inn.length === 12,
			enabled = (!objs.NAME.readOnly ||
					!objs.SNAME.readOnly ||
					!objs.INN.readOnly ||
					!objs.OGRN.readOnly ||
					!objs.KPP.readOnly ||
					!objs.tabSelfOkvedReadOnly) &&
				(ogrn.length === 13 || inn.length === (individ ? 12 : 10));

		objs.btnSyncNalog.setDisabled(!enabled);
		objs.btnSyncNalog.setVisible(!!(me.getTabVisible('ChangeHistory')));
	},

	getInfoFromEgrulNalog: function () {
		var me = this,
			objs = me.objs;

		me.showLoadMask({
			msg: wmc.getMask('GetEgrulNalogActual'),
			rid: ajaxRequest({
				url: 'SOrg/GetInfoFromEgrulNalog_A',
				params: {
					orgTypes: objs.S_TYPEORG.getLinks(1),
					link: me.getLink(),
					tabGeneral: JSON.stringify(me.dataCollectorGeneral()),
					tabSelfOkved: JSON.stringify(me.dataCollectorSelfOkved())
				},
				success: function (value) { me.successInfoFromEgrulNalog(value); },
				callback: function () { me.hideLoadMask() }
			})
		});
	},

	successInfoFromEgrulNalog: function (value) {
		if (value.Error) {
			showError(value.Error);
			return;
		}
		var me = this,
			objs = me.objs,
			sel = value.data.filter((c) => { return Ext.Array.contains(value.selectedLinks, c.LINK) }),
			data = value.data;

		if (!sel.length) {
			info(wmc.get('EgrulNalogActual'));
			return;
		}

		let endFunc = function() {
			ajaxRequest({
				url: 'SOrg/SetDirectorFromEgrul_A',
				params: {
					link: me.getLink(),
					fio: value.director.FIO,
					dolg: value.sDolg,
				},
				success: function (value) {
					objs["S_DOLG"].setValue(value);
					me.gksc('formPerson').refresh();
				},
				callback: function () { LoadMask.hide(); }
			})
		};

		Ext.create('Keysystems.Base.List', {
			mode: 'MULTI',
			parentView: objs.view,
			selectLinks: sel,
			hidePagging: true,
			title: 'Выбор полей для обновления',
			functions: {
				ok: function (val) {
					Ext.each(val, v => {
						v = v.data || v;
						if (Ext.Array.contains(['INN', 'KPP', 'NAME', 'SNAME', 'OGRN', 'DH1', 'DH2'], v.FIELD)){
							if (v.FIELD === 'DH1' || v.FIELD === 'DH2') {
								var dt = v.ACTUAL.split('.');
								v.ACTUAL = new Date(dt[2].split(' ')[0], dt[1] - 1, dt[0]);
							}
							me.objs[v.FIELD].setValue(v.ACTUAL);
						}		
						if (v.FIELD === "ADRU"){
							objs.S_ADRU.ksSetValue(value.adrData);
						}
						if (v.FIELD === "OKVED_ITEMS"){
							objs.T_SORG_SOKVED = value.okvedData;
						}
					});

					if (value.sTypeOrg.length){
						objs.S_TYPEORG.ksSetValue(value.sTypeOrg);
					}					

					var i = ArrayLib.find(val, ['data', 'FIELD'], 'DIRECTOR');
					if (i !== -1){
						if (value.sDolgs.length){
							objs.S_DOLG.setValue(value.sDolgs);
						}
						if (me.getLink() === 0){
							me.directorEgrul["FIO"] = value.director.FIO;
							me.directorEgrul["DOLG"] = value.sDolg;
						}
						else{
							endFunc();
						}
					}
				},
				getData: function (callBack) {
					callBack({
						columns: me.egrulNalogColumns,
						fields: me.egrulNalogFields,
						data: { data: data, total: data.length }
					});
				},
				refresh: function (callBack) { callBack({ data: data, total: data.length }); }
			}
		});
	},

	showHideTabsRegionsOkveds: function() {
		var me = this,
			objs = me.objs,
			region = objs.S_REGION.getLink();

		if (region && objs.S_TYPEORG.getLinks().indexOf(me.checkTypeOrg) !== -1) {
			if (region !== me.lastRegion) {
				me.lastRegion = region;
				me.updRegion();
			}
			me.setTabVisible('Regions', me.regionAccessible);
			me.setTabVisible('Okved', me.okvedAccessible);
		} else {
			me.setTabVisible('Regions', false);
			me.setTabVisible('Okved', false);
			
			if (!me.isLoaded) {
				objs.T_SOTDEL_SOKVED = [];
				objs.tSOrgSRegion = [];
				objs.tSOtdelSRegion = {};
				objs.otdelRegionRnorm = [];

				if (objs.dictRegion) {
					objs.dictRegion.Grid.getStore().removeAll();
					objs.dictRegion.Grid.getView().refresh();
				}

				if (objs.gridOtdelOkved) {
					objs.gridOtdelOkved.Grid.getStore().removeAll();
					objs.gridOtdelOkved.Grid.getView().refresh();
				}
			}
		}
	},

	showHideLimitByKbk: function (value) {
		var c = this.objs.LIMIT_BY_KBK;
		if (c && c.ksAccessEdit) {
			var f = true;
			Ext.each(value, function (v) {
				if ((v.data || v).NAME === 'Проверяющая') f = false;
				return f;
			});
			c.setVisible(!f);
		}
	},

	//метод сохранения данных
	saveData: function (endFunc, params) {
		var me = this,
			objs = me.objs,
			oldTypeOrg = JSON.parse(JSON.parse(JSON.parse(me.oldData).tabGeneral).S_TYPEORG),
			isDelTypeOrg,
			func = function (result) {
				if (Object.keys(me.directorEgrul).length){
					me.directorEgrul = {};
					objs["S_DOLG"].setValue(result.sDolgs);
					me.oldData = JSON.stringify(me.dataCollector());
				}

				if (result.VER_S_ORG) {
					objs.VER_S_ORG.store.loadData(result.VER_S_ORG, false);
					me.oldData = JSON.stringify(me.dataCollector());
				}
				if (endFunc) endFunc(result);
			};

		for (var i = 0; i < oldTypeOrg.length; i++){
			if (!Ext.Array.contains(objs.S_TYPEORG.getLinks(), oldTypeOrg[i])){
				isDelTypeOrg = true;
				break;
			}
		}
		
		if (isDelTypeOrg){
			me.showLoadMask({
				msg: KS.L10n.preparing_data,
				rid: ajaxRequest({
					url: 'SOrg/GetRelationDocuments_A',
					params: {link: me.getLink()},
					success: function (res) {
						if (res) {
							selectDialogShow(KS.L10n.attention, wmc.getString(KS.L10n.SORGEditView_CheckSave_Организация_отобрана_в_документах_, res), function () {
								me.baseSaveData(params || me.dataCollector(), func);
							});
						} else {
							me.baseSaveData(params || me.dataCollector(), func);
						}
					},
					callback: () => {
						me.hideLoadMask();
					}
				})
			})
		}
		else {
			me.callParent([func, params]);
		}		
	},
	
	setTabReadOnly: function(tabKey) {
		let me = this;
		switch (tabKey.toUpperCase()) {
			case "OKVEDS":
				me.objs.tabOtdelOkvedReadOnly = true;
				break
			case "REGIONS":
				me.objs.tabRegionsReadOnly = true;
				break
			case "SELFOKVEDS":
				me.objs.tabSelfOkvedReadOnly = true;
				break;
			case "OTDELS":
				me.gksc('formOtdel').setAccess(true);
				break;
			case "PERSONS":
				me.gksc('formPerson').setAccess(true);
				break;			
			default:
				this.callParent(arguments);
				break;
		}
	}
});