﻿Ext.define('Keysystems.SOkei.Edit', {
	extend: 'Keysystems.Base.Edit',
	createItems: function() {
		var me = this,
			objs = me.objs,
			items = [
				objs.ENG_NAME = Ext.create('Ext.form.field.Text', {
					fieldLabel: 'Краткое (международное)',
					maxWidth: 300,
					labelWidth: me.labelWidth
				}),
				objs.S_GROUP_EI = Ext.create('Keysystems.Controls.DictName.Edit', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Группа',
					handler: function() {
						dictFunc({
							mode: 'SINGL',
							parentView: objs.view,
							selectLinks: objs.S_GROUP_EI.getValue(),
							code: dnl.S_GROUP_EI,
							readOnly: objs.S_GROUP_EI.readOnly,
							control: objs.S_GROUP_EI,
							contextSearch: objs.S_GROUP_EI.contextSearch
						}, {
							ok: function(value) {
								objs.S_GROUP_EI.setValue(value);
							}
						});
					}
				}),
				objs.UNIT = Ext.create('Ext.form.field.Number', {
					fieldLabel: 'Кратность',
					labelWidth: me.labelWidth,
					maxWidth: 300,
					minValue: 0
				})
			];

		me.isCodeEdit = true;
		me.codeEditCfg = { maxLength: 5, enforceMaxLength: true };
		me.isNameEdit = true;
		me.nameEditCfg = { maxLength: 255, enforceMaxLength: true };
		me.isSNameEdit = true;
		me.isDHEdit = true;

		return me.callParent([items]);
	},
	dataCollector: function() {
		var me = this,
			objs = me.objs;

		var data = me.callParent([false]);
		data.engname = objs.ENG_NAME.getValue();
		data.sGroupEi = objs.S_GROUP_EI.getLink();
		data.unit = objs.UNIT.getValue();
		return data;
	},
	loadCopyEditData: function() {
		var me = this,
			objs = me.objs,
			data = me.data.data;

		objs.ENG_NAME.setValue(data.ENG_NAME);
		objs.S_GROUP_EI.setValue({
			data: {
				LINK: data.S_GROUP_EI,
				NAME: data.S_GROUP_NAME
			}
		});
		objs.UNIT.setValue(data.UNIT);

		me.callParent();
	}
});