﻿Ext.define('Keysystems.SNpa.List', {
	extend: 'Keysystems.Base.List.Tree',
	title: 'Нормативно-правовые акты',
	deleteCode: 'S_NPA',
	labelWidth: 150,
	fileColumn: true,
	isContent: true,
	isCodeName: false,
	articleMode: 'SINGL',

	createItems: function() {
		var me = this,
			res = me.callParent(arguments);

		if (me.isCodeName) {
			me.Grid.on('select', function(th, record) {
				me.gksc('narCode').setValue(record.get('M') ? record.get('CODE') : '');
				me.gksc('narName').setValue(record.get('M') ? record.get('NAME') : '');
			});
		}

		if (me.isArticle) {
			res.push(Ext.create('Ext.resizer.Splitter'));
			res.push(me.getArticleFieldContainer());

			// Используем 'select' вместо'selectionchange' для того, чтобы записи пришли в правильном порядке
			me.Grid.on('select', function(th, sel) { me.getArticleSelect(sel); });

			if (me.functions.ok) {
				me.functions.__ok = me.functions.ok;
				me.functions.ok = function(vals) {
					me.bindData(ArrayLib.copy(me.objs.T_SNPA), vals, me.objs.T_SNPA, function(l, d) {
						d = d.data || d;
						return ArrayLib.find(l, ['S_NPA'], d.LINK);
					}, me.creTSNpa);

					var arr = me.getT_SNPA();
					me.bindData(ArrayLib.copy(arr), me.objs.T_SNPA, arr, function(l, d) { return l.indexOf(d); }, function(v) { return v; });
					arr = me.getT_SNPA_SARTICLE();
					me.bindData(ArrayLib.copy(arr), me.objs.T_SNPA_SARTICLE, arr, function(l, d) { return l.indexOf(d); }, function(v) { return v; });

					me.functions.__ok(vals);
				};
			}
		}

		if (me.useArticleGrid) {
			res.push({ xtype: 'splitter' },
				me.objs.articlePanel = Ext.create('Ext.panel.Panel',
					{
						flex: 2,
						border: 0,
						layout: {type: 'vbox', align: 'stretch'}
					}));

			if (me.functions.ok) {
				me.functions.__ok = me.functions.ok;
				me.functions.ok = function (vals) {
					var ld = me.getArticleListData(),
						checkedLinks = [];
					ld.data = me.objs.articleView.objs.Grid.store.getDataExt();
					Ext.each(me.objs.articleView.getChecks(), function (r) { checkedLinks.push(r.data.LINK); });
					ld.checkedLinks = checkedLinks;

					me.functions.__ok(vals);
				};
			}
		}

		return res;
	},

	baseGetData: function (endFunc, params) {
		var me = this;
		params.code = me.code;
		// Грид Статей для НПА(ответств)
		me.callParent([
			function (data) {
				if (me.useArticleGrid && !me.objs.articleView) {
					me.objs.items.push(
						me.objs.articleView = Ext.create('Keysystems.Base.List',
							{
								tabMode: true,
								closable: false,
								parentView: me.objs.articlePanel,
								readOnly: me.readOnly,
								mode: me.articleMode,
								hidePagging: true,
								checkModel: true,
								head: false,
								code: dnl.S_ARTICLE,
								title: dictListController.DICTIONARY_SARTICLE.title,
								linkCode: dictListController.DICTIONARY_SARTICLE.linkCode,
								editClass: dictListController.DICTIONARY_SARTICLE.editClass,
								btnsHide: {
									new: true,
									edit: true,
									same: true,
									delete: true,
									galka: true,
									unmark: true
								},
								isItemDblClick: false,
								controlName: 'grid' + me.controlName,
								functions: {
									getData: function (callBack) {
										var articleListData = me.getArticleListData();
										if (articleListData.data.length)
											this.checkList = articleListData.data.filter(function(r) {
												return articleListData.checkedLinks.indexOf(r.LINK) !== -1;
											});
										
										callBack({
											columns: articleListData.columns,
											fields: articleListData.fields,
											data: { 
												data: articleListData.data, 
												total: articleListData.data.length,
												pageSize: articleListData.pageSize,
												maxPageSize: articleListData.maxPageSize,
												pagingOn: articleListData.pagingOn
											}
										});
									}
								},
								getWhereArgs: function() {
									const whereArgs = {};
									Object.assign(whereArgs, me.whereArgs);
									whereArgs.Npa =  { value: JSON.stringify(me.getLinks()), type: 'List_int' };									
									return whereArgs;
								}
							})
					);
				}

				if (endFunc) endFunc(data);
			}, params
		]);
	},

	createCheckColumn: function() {
		var me = this,
			res = me.callParent(arguments);
		if (me.isArticle) me.mColumn.on('checkchange', function(th, rowIndex, checked, rec) { me.getArticleSelect(rec); });
		return res;
	},

	getArticleFieldContainer: function() {
		var me = this,
			objs = me.objs;

		if (objs.articleFC) return objs.articleFC;

		objs.T_SNPA = ArrayLib.copy(me.getT_SNPA());
		objs.T_SNPA_SARTICLE = ArrayLib.copy(me.getT_SNPA_SARTICLE());

		var content = objs.S_ARTICLE_NAME = Ext.create('Ext.form.field.TextArea', {
			fieldLabel: 'Содержание',
			labelWidth: me.labelWidth,
			flex: 1,
			readOnly: true
		});

		var items = [
			me.createDictEdit({
				key: 'S_ARTICLE',
				mode: 'MULTI',
				code: dnl.S_ARTICLE,
				className: 'Keysystems.Controls.DictCode.Edit',
				ksSetValue: function (v) {
					this.setValue(v);
					me.bindArticle(v);
				},
				setValue: function (v) {
					this.callParent(arguments);
					if (me.isContent) {
						content.setValue(me.concatArticleName(v));
					}
				},
				fieldLabel: 'Статьи',
				listCfg: {
					initWhereArgs: function() { return { Npa: { value: JSON.stringify([objs.selSNpaRec.get('LINK')]), type: 'List_int' } }; },
					getInputDicts: function() { return [Ext.create('InputEditDict', { name: 'S_NPA', data: [objs.selSNpaRec] })]; }
				}
			})];

		if (me.isContent) {
			items.push(content);
		}

		if (me.isCodeName) {
			items.push(
				me.sksc('narCode', Ext.create('Ext.form.field.TextArea', {
					fieldLabel: 'Код НПА',
					labelWidth: me.labelWidth,
					flex: 1,
					readOnly: true
				})),
				me.sksc('narName', Ext.create('Ext.form.field.TextArea', {
					fieldLabel: 'Наименование НПА',
					labelWidth: me.labelWidth,
					flex: 1,
					readOnly: true
				})));
		}

		return objs.articleFC = Ext.create('Ext.form.FieldContainer', {
			layout: { type: 'vbox', align: 'stretch' },
			padding: me.bodyPadding || 5,
			split: true,
			flex: 1,
			items: items
		});
	},

	bindArticle: function(v) {
		var me = this,
			sNpa = me.objs.selSNpaRec.get('LINK');
		me.bindData(
			me.getArticleValue(sNpa),
			v,
			me.objs.T_SNPA_SARTICLE,
			function(l, d) { return ArrayLib.find(l, ['S_ARTICLE'], (d.data || d).LINK); },
			function(d) {
				d = d.data || d;
				var res = {
					S_ARTICLE: d.LINK,
					S_ARTICLE_CODE: d.CODE,
					S_ARTICLE_NAME: d.NAME,
					S_ARTICLE_REF: d.REF
				};
				res[me.fieldTSNarSNar] = me.getTSNpa(sNpa).LINK;
				return res;
			}
		);
	},

	concatArticleName: function(value) {
		var res = '';
		Ext.each(value, function(v) {
			var n = (v.data || v).NAME;
			if (n) {
				if (res) res += '; ';
				res += n;
			}
		});
		return res;
	},

	getArticleSelect: function(rec) {
		var me = this,
			objs = me.objs,
			fc = me.getArticleFieldContainer();

		if (rec) {
			objs.selSNpaRec = rec;
			if (rec.get('M') === '') {
				fc.disable();
				return;
			}
			let sNpa = rec.get('LINK'),
				// при загрузке формы у записи нет колонки 'M'
				isChecked = !rec.data.hasOwnProperty('M') && me.checkList.filter(d => d.LINK === rec.get('LINK')).length;
				
			if (rec.get('M') || isChecked) {
				if (!me.getTSNpa(sNpa)) me.objs.T_SNPA.push(me.creTSNpa(rec));

				var v = me.convertListToDictList(me.getArticleValue(sNpa), 'S_ARTICLE');
				objs.S_ARTICLE.setValue(v);
				fc.enable();
				return;
			} else {
				var tsnpa = me.getTSNpa(sNpa);
				if (!tsnpa) {
					objs.S_ARTICLE.setValue();
				}
			}
		} else {
			delete objs.selSNpaRec;
		}

		fc.disable();
	},

	fieldTSNarSNar: 'T_SNAR_SNAR',

	getTSNpa: function(sNpa) { return ArrayLib.filter(this.objs.T_SNPA || [], ['S_NPA'], sNpa)[0]; },

	getArticleValue: function(sNpa) {
		var me = this,
			tsnpa = me.getTSNpa(sNpa);

		return tsnpa ? ArrayLib.filter(me.objs.T_SNPA_SARTICLE || [], [me.fieldTSNarSNar], tsnpa.LINK) : [];
	},

	afterCheckAll: function (records) {
		// пользуемся этим методом, т.к. в иерархическом гриде можно чекнуть несколько записей, на которые не сработает событие checkchange
		var me = this;
		if (!me.useArticleGrid) {
            Ext.each(records,
                function (rec) {
                    if (rec.get('M')) {
						if (!me.getTSNpa(rec.get('LINK'))) me.objs.T_SNPA.push(me.creTSNpa(rec));
                    }
                });

            return;
        }

		var store = me.objs.articleView.objs.Grid.store;
		
		// получаем весь store заново
		var npaLinks = [];
		Ext.each(records, function (r) { npaLinks.push(r.data.LINK); });

		if (npaLinks.length) {
			ajaxRequest({
				url: 'SNPA/GetArticleRows_A',
				params: {
					npaLinks: npaLinks,
					narLink: me.whereArgs && me.whereArgs.SNar ? me.whereArgs.SNar.value : 0
				},
				success: function(value) {
					if (value.records.length) {
						store.loadData(value.records);
						// чекаем запись
						if (me.objs.articleView.checkList.length) {
							var checkedLinks = [];
							Ext.each(me.objs.articleView.checkList, function (i) { checkedLinks.push(i.data.LINK); });
							me.objs.articleView.checkList = value.records.filter(function (r) { return checkedLinks.indexOf(r.LINK) !== -1; });
							if (me.objs.articleView.checkList.length) {
								me.objs.articleView.setChecks(me.objs.articleView.checkList);
							}
						}
					} else {
						store.removeAll();
						me.objs.articleView.checkList.length = 0;
					}
				}
			});
		} else {
			store.removeAll();
			me.objs.articleView.checkList.length = 0;
		}
	},

	//#region by Base.Edit

	bindData: Keysystems.Base.Edit.prototype.bindData,

	createDictEdit: Keysystems.Base.Edit.prototype.createDictEdit,

	convertListToDictList: Keysystems.Base.Edit.prototype.convertListToDictList,

	convertToDictRec: Keysystems.Base.Edit.prototype.convertToDictRec,

	//#endregion by Base.Edit

	//#region by override

	getT_SNPA: function() {
		throw new Error(wmc.get('NeedOverride'));
		return [];
	},

	getT_SNPA_SARTICLE: function() {
		throw new Error(wmc.get('NeedOverride'));
		return [];
	},

	creTSNpa: function(rec) {
		throw new Error(wmc.get('NeedOverride'));
		return {};
	},

	getArticleListData: function () {
		throw new Error(wmc.get('NeedOverride'));
		return {};
	}

	//#endregion by override
});