﻿Ext.define('Keysystems.SNpa.Edit', {
	extend: 'Keysystems.Base.Edit',
	isFileBtn: true,
	viewMinSize: [620, 450],
	viewCfg: function() {
		const me = this;
		const cfg = me.callParent(arguments);
		cfg.resizable = true;
		cfg.maximizable = true;
	},	
	createItems: function () {
		var me = this;
		me.isCodeEdit = true;
		me.codeEditCfg = { maxLength: 10, enforceMaxLength: true };
		me.isNameEdit = true;
		me.nameEditCfg = { maxLength: 1100, enforceMaxLength: true };
		me.isSNameEdit = true;
		me.snameEditCfg = { maxLength: 100, enforceMaxLength: true };
		me.isDHEdit = true;
		var objs = me.objs,
			baseItems = me.callParent(),
			items = [
				objs.CODE_PNL = Ext.create('Ext.panel.Panel',
					{
						layout: { type: 'hbox', align: 'stretch' },
						border: 0,
						padding: '0 0 5 0',
						items: [
							objs.CODE,
							'->',
							me.sksc('BTN_REF', Ext.create('Keysystems.RefDropDown', {}))
						]
					}),
				objs.NUM_DT = Ext.create('Ext.form.FieldContainer',
					{
						layout: { type: 'hbox', align: 'stretch' },
						items: [
							me.sksc('NUMBER',
								Ext.create('Ext.form.field.Text',
									{
										labelWidth: me.labelWidth,
										maxLength: 25,
										enforceMaxLength: true,
										fieldLabel: 'Номер',
										emptyText: 'Введите Номер'
									})),
							me.sksc('DT',
								Ext.create('Ext.form.field.Date',
									{
										labelWidth: 35,
										format: 'd.m.Y',
										fieldLabel: 'Дата',
										padding: '0 0 0 15',
										minValue: longPeriod.begin,
										maxValue: longPeriod.end,
										emptyText: 'Введите Дату'
									}))
						]
					}),
				objs.S_ARTICLE = Ext.create('Keysystems.Controls.DictCode.Edit',
					{
						labelWidth: me.labelWidth,
						fieldLabel: 'Статьи',
						width: me.width,
						mode: 'MULTI',
						denyFind: true,
						handler: function() {
							if (objs.link !== 0) {
								dictFunc({
									checkModel: false,
									parentView: objs.view,
									whereArgs: { Npa: { value: JSON.stringify([objs.link]), type: 'List_int' } },
									code: dnl.S_ARTICLE,
									readOnly: objs.S_ARTICLE.readOnly,
									inputDicts: [Ext.create('InputEditDict', { name: 'S_NPA', data: [me.data] })],
									afterClose: function() {
										if (this.objs.Grid) {
											let rows = this.objs.Grid.store.getDataExt();
											objs.S_ARTICLE.setValue(rows);
										}
									}
								});
							} else {
								selectDialogShow(KS.L10n.attention,
									KS.L10n.SNPAEditView_dictSARTICLE_BeforeCallDictionary_Для_продолжения_необходимо_сохранить_НПА,
									() => {
										me.checkFilled(res => {
											if (!res) return;
											me.saveData();
										});
									});
							}
						}
					}),
				objs.S_ORG = me.createDictEdit({
					key: 'S_ORG',
					mode: 'MULTI',
					code: dnl.S_ORG,
					fieldLabel: 'Организации'
				}),
				objs.S_USERS = Ext.create('Keysystems.Controls.Dict.Edit', {
					labelWidth: me.labelWidth,
					fieldLink: 'UID',
					fieldLabel: 'Группы пользователей',
					width: me.width,
					mode: 'MULTI',
					handler: function () {
						dictFunc({
							mode: 'MULTI',
							parentView: objs.view,
							fieldLink: 'UID',
							whereArgs: {
								IncludeGroups: { value: 'True', type: 'bool' },
								OnlyGroups: { value: 'True', type: 'bool' }
							},
							selectLinks: objs.S_USERS.getValue(),
							code: dnl.S_LOGIN,
							readOnly: objs.S_USERS.readOnly,
							control: objs.S_USERS,
							contextSearch: objs.S_USERS.contextSearch
						}, { ok: function (value) { objs.S_USERS.setValue(value); } });
					}
				}),
				objs.ISGROUP = Ext.create('Ext.form.field.Checkbox',
					{
						labelWidth: me.labelWidth,
						labelSeparator: '',
						hideLabel: true,
						boxLabel: 'Группа',
						fieldLabel: 'Группа',
						padding: '0 0 0 155'
					}),

				me.sksc('panelHistory', objs.panelHistory = me.createPanelHistory())
			];

		var result = baseItems.slice();
		var posCode = result.indexOf(objs.CODE);
		if (posCode !== -1) result.splice(posCode, 1);

		result.splice(result.indexOf(objs.NAME), 0, objs.CODE_PNL);

		result.splice(result.indexOf(objs.NAME), 0, objs.NUM_DT);
		result.splice(result.indexOf(objs.DH), 0, objs.S_ARTICLE);
		result.push(objs.S_ORG);
		result.push(objs.S_USERS);
		result.push(objs.ISGROUP);
		result.push(objs.panelHistory);
		return result;
	},
	dataCollector: function() {
		var me = this,
			objs = me.objs,
			objsData = me.data.data,
			data = me.callParent(arguments);
		data.fileLink = objsData.FILES; 
		data.fileExt = objsData.TEMP_EXT;
		data.LINK_SELF = me.config.data && me.config.f === 'new' ? me.config.data.data.LINK : data.LINK_SELF;//если 'new' и data передана в конфиге, то это создание подчиненной
		data.NUMBER = me.gksc('NUMBER').getValue();
		data.DT = me.gksc('DT').getValue();
		data.REF = me.gksc('BTN_REF').getValue();
		if (me.SNar) data.SNar = me.SNar;

		data.S_ORG = objs.S_ORG.getLinks(1);
		data.S_USERS = objs.S_USERS.getLinks(1);
		data.ISGROUP = objs.ISGROUP.getValue(); 

		var dataHist = me.dataCollectorHistory();
		if (dataHist) data.panelHistory = JSON.stringify(dataHist);

		data.whereArgs = me.whereArgs;
		
		return data;
	},
	loadCopyEditData: function() {
		var me = this,
			objs = me.objs,
			data = me.data.data;

		if (me.f === 'copy') {
			data.FILES = 0;
			data.TEMP_EXT = null;
		}
		objs.btnFile.setIconCls(getExtStyle(data.TEMP_EXT));
		me.callParent();
	},
	getExtra: function(endFunc, link) {
		var me = this,
			objs = me.objs;
		me.baseGetExtra({ link: link }, function(value) {
			me.autoFillControl(value.row);
			objs.S_ARTICLE.setValue(value.S_ARTICLE);
			me.gksc('NUMBER').setValue(value.row.NUMBER);
			me.gksc('DT').setValue(value.row.DT);
			me.gksc('BTN_REF').setValue(value.row.REF);
			objs.ISGROUP.setValue(value.row.ISGROUP);
			objs.S_USERS.setValue(value.S_USERS);
			objs.S_ORG.setValue(value.S_ORG);
			if (!value.SHOW_GROUP_INFO) {
				objs.S_ORG.setVisible(false);
				objs.S_USERS.setVisible(false);
				objs.ISGROUP.setVisible(false);
			}
			if (value.readOnly) me.setReadOnly(true);
			me.getExtraHistory(value);
			if (endFunc) endFunc();
		});
	},
	loadNewData: function () {
		let me = this;
		me.callParent();
		if (!me.data) me.data = {data: {}};
		me.data.data.FILES = 0;
	},

	//region история изменений

	//region конструктор панели

	createPanelHistory: function () {
		var me = this,
			objs = me.objs;
		var pH = objs.panelHist = me.sksc('panelHistory', Ext.create('Ext.grid.Panel', {
			title: 'История изменений',
			userCls: 'rks-filter-panel',
			minHeight: 150,
			flex: 1,
			scroll: 'both',
			tbar: [
				me.sksc('tabHistoryBtnNew', Ext.create('Ext.Button', {
					key: 'new',
					iconCls: 'x_btn_new',
					tooltip: 'Создать',
					tooltipType: 'title',
					handler: function () {
						let grid = me.gksc('panelHistory'),
							rec = grid.store.add({})[0];
						rec.data.S_NPA = me.data.data.LINK;
						grid.getSelectionModel().select(rec);
					}
				})),
				me.sksc('tabHistoryBtnDel', Ext.create('Ext.Button', {
					key: 'delete',
					iconCls: 'x_btn_delete',
					tooltip: 'Удалить',
					tooltipType: 'title',
					disabled: true,
					handler: function () { me.gksc('panelHistory').removeSelection(); }
				}))
			],
			features: [
				{
					ftype: 'summary',
					showSummaryRow: false
				}
			],
			plugins: [Ext.create('Ext.grid.plugin.CellEditing', { clicksToEdit: 1 }), 'gridclipboard'],
			store: Ext.create('Ext.data.Store', {
				fields: [],
				data: [],
				proxy: 'memory'
			}),
			columns: [],
			columnLines: true,
			listeners: {
				selectionchange: (_, sels) => me.enableToolsGrid(me.gksc('panelHistory'), sels)
			}
		}));		
		return pH;
	},

	//загрузка данных
	getExtraHistory: function (value) {
		var me = this,
			panelValue = value.changeHistory;

		if (panelValue) {
			//me.sksd('panelHistory', panelValue);
			me.historyColumnsAdapted(panelValue.columns);
			me.gksc('panelHistory').setMetaDate(panelValue, { profileCode: me.code, profileKey: 'panelHistory', gateCode: me.keyEdit });;
		}
	},

	//Сборка данных
	dataCollectorHistory: function () {
		var me = this;
		return me.objs.panelHistory.store.getDataExt();
	},

	fileGridEdit: function(rec) {
		const me = this;
		if (rec.data.LINK === 0)
			selectDialogShow(KS.L10n.attention,
				KS.L10n.SNPAEditView_dictSARTICLE_BeforeCallDictionary_Для_продолжения_необходимо_сохранить_НПА,
				() => {
					me.checkFilled(res => {
						if (!res) return;
						me.saveData();
					});
				});
		else
			me.callParent(arguments);
	},

	updGridFileRecord: function (fileObj, rec) {
		var me = this;
		rec.data[me.fieldFile] = fileObj.id;
		rec.data[me.fieldExt] = fileObj.ext;
		me.objs.panelHistory.view.refresh();
	},

	historyColumnsAdapted: function(columns) {
		var me = this;

		//#region Номер, Дата
		Ext.each(columns,
			function(col) {
				switch (col.dataIndex) {
				case 'NUMBER':
					col.editor = {
						xtype: 'textfield',
						maxLength: 25,
						enforceMaxLength: true
					};
					break;
				case 'DT':
					col.editor = { xtype: 'datefield' };
					break;
				}
			});
		//#endregion Номер, Дата

		columns.push({
			xtype: 'actioncolumn',
			dataIndex: 'FileColumn',
			text: 'Файл',
			width: 60,
			align: 'center',
			items: [
				{
					getClass: function (v, meta, rec) { return getExtStyle(rec.data.TEMP_EXT); },
					handler: function (grid, rowIndex) {
						var rec = grid.getStore().getAt(rowIndex);
						me.fileGridEdit(rec);
					}
				}
			]
		});

	},

	successSaveFunc: function (res) {
		if (res['NpaHist']) this.objs.panelHistory.store.loadData(res['NpaHist'], false);
		this.callParent(arguments);
	}

	//endregion история изменений

});