﻿Ext.define('Keysystems.SNar.Edit', {
	extend: 'Keysystems.Base.Edit',
	_arr: ['S_WORK', 'S_NARP', 'S_NARC', 'S_TYPEORG', 'S_VBUDJ'],
	tSNarSNpaLink: -1,
	tSNarSResponsLink: -1,
	viewMinSize: [600, 490],
	bodyPadding: 0,
	getRowClass: function(r, val) {
		var l = r.get('LINK');
		if (l === this.objs.link) {
			r.readOnly = true;
			return 'ks-snar-self';
		}
		var res = _;
		Ext.each(val, function(v) {
			if ((v.data || v).LINK === l) {
				res = 'ks-snar-useles';
				r.readOnly = true;
				return false;
			}
			return true;
		});
		return res;
	},

	createItems: function () {
		let me = this;
		return me.objs.allTab = Ext.create('Ext.tab.Panel',
			{
				plain: true,
				border: 0,
				flex: 1,
				userCls: me.basePanelCls,
				bodyCls: me.basePanelBodyCls,
				items: me.getTab('General')
			});
	},

	createSNpaDictEdit: function (key, label) {
		var me = this;

		return me.createDictEdit({
			key: key,
			mode: 'MULTI',
			code: dnl.S_NPA,
			fieldLabel: label,
			listCfg: {
				isArticle: true,
				getT_SNPA: function() { return me.objs[key + '_VALUE']; },
				getT_SNPA_SARTICLE: function() { return me.objs[key + '_ARTICLE']; },
				fieldTSNarSNar: 'T_SNAR_S' + key.substring(2),
				creTSNpa: function(rec) {
					return {
						LINK: me.tSNarSNpaLink--,
						S_NPA: rec.get('LINK'),
						S_NPA_CODE: rec.get('CODE'),
						S_NPA_NAME: rec.get('NAME')
					};
				}
			}
		});
	},

	dataCollector: function() {
		var me = this,
			objs = me.objs;
		me.isCodeEdit = true;
		me.isNameEdit = true;
		me.isDHEdit = true;

		var data = me.callParent([false]);

		Ext.each(me._arr,
			function(key) {
				var c = objs[key];
				if (!c.isHidden()) data[key] = c.getLinks(1);
			});

		var l = [];
		Ext.each(objs.S_NPA_NAR_VALUE,
			function(v) {
				l.push(ArrayLib.copyByKeys(['LINK', 'S_NPA'],
					v,
					{
						S_ARTICLE: JSON.stringify(ArrayLib.getLinks(
							ArrayLib.filter(objs.S_NPA_NAR_ARTICLE, ['T_SNAR_SNPA_NAR'], v.LINK),
							'S_ARTICLE'))
					}));
			});
		data.S_NPA_NAR = JSON.stringify(l);

		l = [];
		Ext.each(objs.S_NPA_OTV_VALUE,
			function(v) {
				l.push(ArrayLib.copyByKeys(['LINK', 'S_NPA'],
					v,
					{
						S_ARTICLE: JSON.stringify(ArrayLib.getLinks(
							ArrayLib.filter(objs.S_NPA_OTV_ARTICLE, ['T_SNAR_SNPA_OTV'], v.LINK),
							'S_ARTICLE'))
					}));
			});
		data.S_NPA_OTV = JSON.stringify(l);

		l = [];
		Ext.each(objs.S_RESPONS_VALUE,
			function (v) {
				l.push(ArrayLib.copyByKeys(['LINK', 'S_RESPONS'],
					v,
					{
						VALUES: JSON.stringify(ArrayLib.filter(objs.NAR_RESPONS_VALUES, ['T_SNAR_SRESPONS'], v.LINK))
					}));
			});
		data.S_RESPONS = JSON.stringify(l);

		data.TYPE = 0;
		Ext.each(objs.TYPE.getValue(), function(t) { if (t) data.TYPE += t; });
		data.prop = objs.isTabProp ? me.getTab('Prop').getData(1) : _;
		return data;
	},

	//конструктор таба Общие
	createTabGeneral: function() {
		var me = this,
			objs = me.objs;

		objs.tabGeneral = Ext.create('Ext.panel.Panel',
			{
				title: 'Общие',
				layout: { type: 'vbox', align: 'stretch' },
				flex: 1,
				border: 0,
				padding: 10,
				items: [
					Ext.create('Ext.form.FieldContainer', {
						layout: { type: 'vbox', align: 'stretch' },
						padding: me.bodyPadding,
						items: [
							me.createCodeEdit({ maxLength: 15 }),
							me.createNameEdit({ maxLength: 1500 }),
							me.createDictEdit({
								key: 'S_NARP',
								mode: 'MULTI',
								code: dnl.S_NAR,
								fieldLabel: 'Предшествующие',
								getRowClass: function(rec) { return me.getRowClass(rec, objs.S_NARC.getValue()); },
								checkListeners: {
									beforecheckchange: function(th, inx, check, rec) { return !rec.readOnly; }
								},
								checkRenderer: function(val, meta, rec) {
									if (rec.readOnly) meta.tdCls += ' ' + this.disabledCls;
								}
							}),
							me.createDictEdit({
								key: 'S_NARC',
								mode: 'MULTI',
								code: dnl.S_NAR,
								fieldLabel: 'Последующие',
								getRowClass: function(rec) { return me.getRowClass(rec, objs.S_NARP.getValue()); },
								checkListeners: {
									beforecheckchange: function(th, inx, check, rec) { return !rec.readOnly; }
								},
								checkRenderer: function(val, meta, rec) {
									if (rec.readOnly) meta.tdCls += ' ' + this.disabledCls;
								}
							}),
							me.createDictEdit({
								key: 'S_WORK',
								mode: 'MULTI',
								code: dnl.S_WORK,
								fieldLabel: 'Виды работ'
							}),
							me.createSNpaDictEdit('S_NPA_NAR', 'НПА (Наруш.)'),
							me.createSNpaDictEdit('S_NPA_OTV', 'НПА (Ответств.)'),
							me.createDictEdit({
								key: 'S_RESPONS',
								mode: 'MULTI',
								code: dnl.S_RESPONS,
								fieldLabel: 'Виды ответственности',
								ksSetValue: function(value) { this.setValue(value); },
								listCfg: {
									createItems: function() {
										var th = this,
											res = th.callParent(arguments);
										if (th.f) return res;

										let responsUnitStore = [];
										for (prop in miscTypes.ResponsUnit) {
											responsUnitStore.push(miscTypes.ResponsUnit[prop]);
										}

										th.responsValuesFC = Ext.create('Ext.form.FieldContainer',
											{
												layout: { type: 'vbox', align: 'stretch' },
												items: [
													objs.responsValuesGrid = Ext.create('Ext.grid.Panel',
														{
															flex: 1,
															store: Ext.create('Ext.data.Store',
																{
																	fields: ['TYPE', 'UNIT', 'MIN_VAL', 'MAX_VAL'],
																	data: [],
																	proxy: 'memory'
																}),
															columns: [
																{
																	dataIndex: 'TYPE',
																	text: 'Тип',
																	minWidth: 80,
																	xtype: 'misccolumn',
																	typeName: 'RevizObjType'
																},
																{
																	dataIndex: 'UNIT',
																	text: 'Ед. измерения',
																	minWidth: 200,
																	editor: {
																		store: responsUnitStore,
																		xtype: 'combobox',
																		editable: false,
																		listeners: {
																			change(cell) {
																				th.onValueChanged(cell, 'UNIT');
																			}
																		}
																	}
																},
																{
																	dataIndex: 'MIN_VAL',
																	text: 'Мин. значение',
																	width: '200px',
																	xtype: 'decimalcolumn',
																	decimalData: me.gksd('decimalData'),
																	getEditor: function(rec) {
																		let unit = parseInt(
																			KsLib.getKeyByValue(miscTypes.ResponsUnit,
																				rec.get('UNIT'))),
																			decimalData = JSON.parse(JSON.stringify(me.gksd('decimalData')));
																		
																		if (unit !== 1 && unit !== 2) {
																			// Рубли или %
																			decimalData.decimals = 0;
																		}

																		return editor =
																			Ext.create('Ext.grid.CellEditor',
																				{
																					field: Ext.create(
																						'Keysystems.Controls.CalcField',
																						{
																							fieldLabel: '',
																							decimalData: decimalData,
																							listeners: {
																								blur: function(cell) {
																									th.onValueChanged(
																										cell,
																										'MIN_VAL');
																								}
																							}
																						})
																				});
																	}
																},
																{
																	dataIndex: 'MAX_VAL',
																	text: 'Макс. значение',
																	width: '200px',
																	xtype: 'decimalcolumn',
																	decimalData: me.gksd('decimalData'),
																	getEditor: function(rec) {
																		let unit = parseInt(
																			KsLib.getKeyByValue(miscTypes.ResponsUnit,
																				rec.get('UNIT'))),
																			decimalData = JSON.parse(JSON.stringify(me.gksd('decimalData')));
																		
																		if (unit !== 1 && unit !== 2) {
																			// Рубли или %
																			decimalData.decimals = 0;
																		}

																		return editor =
																			Ext.create('Ext.grid.CellEditor',
																				{
																					field: Ext.create(
																						'widget.calcfield',
																						{
																							fieldLabel: '',
																							decimalData: decimalData,
																							listeners: {
																								blur: function(cell) {
																									th.onValueChanged(
																										cell,
																										'MAX_VAL');
																								}
																							}
																						})
																				});
																	}
																}
															],
															columnLines: true,
															plugins: !th.readOnly
																? [
																	Ext.create('Ext.grid.plugin.CellEditing',
																		{ clicksToEdit: 1 }),
																	'gridclipboard'
																]
																: ['gridclipboard'],
															readOnly: th.readOnly
														})
												]
											});

										let data = [];
										for (let objType in miscTypes.RevizObjType) {
											data.push([objType, miscTypes.ResponsUnit[1], 0, 0]);
										}
										objs.responsValuesGrid.store.loadData(data);

										th.Grid.on('selectionchange',
											function (_, sels) {
												if (th.isLoaded) return;
												th.selectRespons(sels[0]);
											});

										if (th.functions.ok) {
											th.functions.__ok = th.functions.ok;
											th.functions.ok = function (value) {
												//обновим T_SNAR_SRESPONS и NAR_RESPONS_VALUES с локальных копий, выполним обратное преобразование колонки NAR_RESPONS_VALUES.UNIT (текст->число)
												objs.S_RESPONS_VALUE = [];
												objs.NAR_RESPONS_VALUES = [];
												if (value) {
													value.forEach(rec => {
														let recT = th.getTSRespons(rec.get('LINK'));
														objs.S_RESPONS_VALUE.push(
															{
																LINK: recT ? recT.LINK : me.tSNarSResponsLink--,
																S_RESPONS: rec.get('LINK'),
																S_RESPONS_CODE: rec.get('CODE'),
																S_RESPONS_NAME: rec.get('NAME')
															});
														if (recT) {
															th.RESPONS_VALUES
																.filter(r => r.T_SNAR_SRESPONS === recT.LINK && (r.MIN_VAL || r.MAX_VAL))
																.forEach(r => {
																	let row = {};
																	Object.assign(row, r);
																	row.UNIT = parseInt(KsLib.getKeyByValue(miscTypes.ResponsUnit, r.UNIT));
																	objs.NAR_RESPONS_VALUES.push(row);
																});
														}
													});
												}
												th.functions.__ok(value);
											};
										}

										res.splice(1, 0, th.responsValuesFC);
										//локальные копии S_RESPONS_VALUE и NAR_RESPONS_VALUES, с преобразованием колонки UNIT (число->текст)
										th.T_SRESPONS = [];
										objs.S_RESPONS_VALUE.forEach(r => th.T_SRESPONS.push(r));

										th.RESPONS_VALUES = [];
										objs.NAR_RESPONS_VALUES.forEach(r => {
											let row = {};
											Object.assign(row, r);
											row.UNIT = miscTypes.ResponsUnit[r.UNIT];
											th.RESPONS_VALUES.push(row);
										});
										return res;
									},
									//событие изменения значения в гриде значений
									onValueChanged: function (cell, field) {
										let th = this;
										if (!th.selResponsRec) return;
										let sRespons = th.selResponsRec.get('LINK'),
											tNarRespons = th.getTSRespons(sRespons),
											sel = objs.responsValuesGrid.getFrstSelect(),
											type = sel ? parseInt(sel.get('TYPE')) : 0,
											newVal = cell.getValue();
										if (!tNarRespons) return;

										//выполняем обновление данных в локальном источнике
										let row = this.RESPONS_VALUES.filter(
											r => r.T_SNAR_SRESPONS === tNarRespons.LINK &&
												r.TYPE === type)[0];
										if (!row) {
											row = {
												T_SNAR_SRESPONS: tNarRespons.LINK,
												TYPE: type,
												UNIT: miscTypes.ResponsUnit[1],
												MIN_VAL: 0,
												MAX_VAL: 0
											};
											this.RESPONS_VALUES.push(row);
										}
										let parseTextToNum = function(val) { return val ? parseFloat((val + '').replace(regSpace, '')) : 0; };
										if ((field === 'MIN_VAL' && parseTextToNum(row.MAX_VAL) && parseTextToNum(newVal) > parseTextToNum(row.MAX_VAL))
											|| (field === 'MAX_VAL' && parseTextToNum(row.MIN_VAL) && parseTextToNum(newVal) < parseTextToNum(row.MIN_VAL))) {
											warning(wmc.get('CheckMinMaxValuesMessage', 
												field === 'MIN_VAL' ? 'Мин. значение' : 'Макс. значение',
												field === 'MIN_VAL' ? 'меньше' : 'больше',
												field === 'MIN_VAL' ? 'Макс. значение' : 'Мин. значение'));
											cell.setValue(field === 'MIN_VAL' ? row.MIN_VAL : row.MAX_VAL);
										} else {
											row[field] = newVal;
										}
									},
									createCheckColumn: function () {
										var th = this,
											res = th.callParent(arguments);
										th.mColumn.on('checkchange',
											function(_, __, checked, rec) { th.selectRespons(rec); });
										return res;
									},
									creTSRespons: function (rec) {
										return {
											LINK: me.tSNarSResponsLink--,
											S_RESPONS: rec.get('LINK'),
											S_RESPONS_CODE: rec.get('CODE'),
											S_RESPONS_NAME: rec.get('NAME')
										};
									},
									getTSRespons: function (sRespons) {
										return ArrayLib.filter(this.T_SRESPONS || [], ['S_RESPONS'], sRespons)[0];
									},
									getResponsValues: function (tNarRespons) {
										return ArrayLib.filter(this.RESPONS_VALUES || [], ['T_SNAR_SRESPONS'], tNarRespons);
									},
									selectRespons: function(rec) {
										let th = this,
											fc = th.responsValuesFC,
											grid = fc.items.first();

										if (rec) {
											th.selResponsRec = rec;
											if (rec.get('M') === '') {
												grid.disable();
												return;
											}
											let sRespons = rec.get('LINK');
											if (rec.get('M')) {
												let recT = th.getTSRespons(sRespons);
												if (!recT) {
													recT = th.creTSRespons(rec);
													th.T_SRESPONS.push(recT);
												}
												//если отмечаем запись Видов отв-ти, то перебиваем значения в гриде по значениям из источника
												let responsValues = th.getResponsValues(recT.LINK);
												
												grid.store.suspendEvents();
												grid.store.each(function (r) {
													let value = responsValues.length ? ArrayLib.filter(responsValues, ['TYPE'], parseInt(r.data.TYPE))[0] : null;
													r.beginEdit();
													r.set('UNIT', value ? value.UNIT : miscTypes.ResponsUnit[1]);
													r.set('MIN_VAL', value ? value.MIN_VAL : 0);
													r.set('MAX_VAL', value ? value.MAX_VAL : 0);
													r.endEdit();
												});
												grid.store.resumeEvents();
												grid.getView().refresh();
												grid.enable();
												return;
											} else {
												//если размечаем запись Видов отв-ти, то удаляем из источника и зануляем значения в гриде
												var tsrespons = th.getTSRespons(sRespons);
												if (tsrespons) {
													var arr = th.RESPONS_VALUES;
													ArrayLib.removeList(arr, ArrayLib.filter(arr, ["T_SNAR_SRESPONS"], tsrespons.LINK));
													ArrayLib.remove(th.T_SRESPONS, tsrespons);
												}
												
												grid.store.suspendEvents();
												grid.store.each(function (r) {
													r.set('UNIT', miscTypes.ResponsUnit[1]);
													r.set('MIN_VAL', 0);
													r.set('MAX_VAL', 0);
												});
												grid.store.resumeEvents();
												grid.getView().refresh();
											}
										} else {
											delete th.selResponsRec;
										}
										grid.disable();
									}
								}
							}),
							me.createDictEdit({
								key: 'S_TYPEORG',
								mode: 'MULTI',
								code: dnl.S_TYPEORG,
								fieldLabel: 'Типы организаций'
							}),
							me.createDictEdit({
								key: 'S_VBUDJ',
								mode: 'MULTI',
								code: dnl.S_VBUDJ,
								fieldLabel: 'Виды средств'
							}),
							objs.TYPE = Ext.create('Keysystems.Controls.ComboBoxExtra',
								{
									multiSelect: true,
									value: null,
									fieldLabel: 'Тип объекта',
									labelWidth: me.labelWidth,
									maxWidth: 400,
									editable: false,
									displayField: CBDataLib.displayField,
									valueField: CBDataLib.valueField,
									store: Ext.create('Ext.data.Store',
										{
											fields: CBDataLib.getFields(),
											data: CBDataLib.get('RevizObjType', 1),
											proxy: 'memory'
										})
								}),
							me.createDHEdit({ maxWidth: 400 })
						]
					})
				]
			});

		return objs.tabGeneral;
	},
	//конструктор таба Реквизиты
	createTabProp: function () {
		var me = this,
			objs = me.objs;

		return objs.tabProp = Ext.create('Keysystems.Panel.Prop', {
			border: 0,
			parentView: me,
			decimalData: me.gksd('decimalData')
		});
	},

	getExtra: function(callBack, link) {
		var me = this,
			objs = me.objs;
		me.baseGetExtra({ link: link }, function(value) {
			if (value.ErrorMsg) {
				showError(value.ErrorMsg);
				me.isExit = true;
				LoadMask.hide();
				return;
			}

			me.sksd('decimalData', value.decimalData);
			
			objs.S_NPA_NAR.setValue(me.convertListToDictList(objs.S_NPA_NAR_VALUE = value.S_NPA_NAR, 'S_NPA'));
			objs.S_NPA_OTV.setValue(me.convertListToDictList(objs.S_NPA_OTV_VALUE = value.S_NPA_OTV, 'S_NPA'));
			objs.S_NPA_NAR_ARTICLE = value.NARNPA_ARTICLE_NAR;
			objs.S_NPA_OTV_ARTICLE = value.NARNPA_ARTICLE_OTV;

			objs.S_RESPONS.setValue(me.convertListToDictList(objs.S_RESPONS_VALUE = value.S_RESPONS, 'S_RESPONS'));
			objs.NAR_RESPONS_VALUES = value.NAR_RESPONS_VALUES;
			
			var access = value.row._Access;
			me.setObjsValuesAndAccess(value.row, access, ['CODE', 'NAME']);
			//me.setObjsValuesAndAccess(value, access, me._arr.concat(['PARENT']));
			me.setObjsValuesAndAccess(value, value.multiAccess, me._arr);
			//todo Перейти на setFullObjsAccess
			me.setFullObjsAccess(value.multiAccess, ['S_NARP', 'S_NARC']);
			me.setTabsAccess(value.Tabs);
			
			objs.DH.setValue(value.row.DH1, value.row.DH2);

			var t = value.row.TYPE,
				tv = [];
			for (var k in miscTypes.RevizObjType) {
				k *= 1;
				if (t & k) tv.push(k);
			}
			objs.TYPE.setValue(tv);

			if (value.tabProp) {
				objs.isTabProp = true;
				objs.allTab.changeTab(me.getTab('Prop').loadData(value.tabProp), true);
			}

			if (callBack) callBack();
		});
	}
});