﻿Ext.define('Keysystems.SMosnov.Edit', {
	extend: 'Keysystems.Base.Edit',
	viewMinSize: [720, 250],
	
	createItems: function() {
		var me = this,
			objs = me.objs;

		me.isCodeEdit = true;
		me.codeEditCfg = { maxLength: 50, enforceMaxLength: true };
		me.isNameEdit = true;
		me.nameEditCfg = { maxLength: 800, enforceMaxLength: true };
		me.isSNameEdit = false;
		me.isDHEdit = false;

		var items = me.callParent();

		items.push(objs.Type = Ext.create('Keysystems.Controls.ComboBoxExtra',
				{
					fieldLabel: 'Тип',
					editable: false,
					queryMode: 'local',
					value: '...',
					width: 300,
					labelWidth: me.labelWidth,
					ksAllowEmpty: true,
					displayField: CBDataLib.displayField,
					valueField: CBDataLib.valueField,
					store: Ext.create('Ext.data.Store',
						{
							fields: CBDataLib.getFields(),
							data: [],
							proxy: 'memory'
						}),
					listeners: {
						change: function (th, newValue) {
							var sPlan = me.objs.S_PLAN;
							sPlan.setValue([]);
							sPlan.setReadOnly(me.objs.Type.getValue() !== me.planType);
						}
					}
				}),
			me.createDictEdit({
				key: 'S_PLAN',
				mode: 'MULTI',
				code: dnl.S_PLAN,
				fieldLabel: 'Раздел плана'
			}),
			me.createDictEdit({
				key: 'S_ORG',
				mode: 'MULTI',
				code: dnl.S_ORG,
				fieldLabel: 'Проверяющая организация',
				whereArgs: { SType: { value: JSON.stringify([1]), type: 'List_int' } }
			}));

		return items;
	},
	getExtra: function (callBack, link) {
		var me = this;
		me.baseGetExtra({ link: link }, function (value) {
			var row = value.row;

			me.autoFillControl(value.row);

			me.planType = value.planType;
			me.objs.Type.store.loadData(CBDataLib.get(_, !!value.items, value.items));
			me.objs.Type.setValue(row.TYPE);

			me.objs.S_PLAN.setValue(value.planRazdel);
			me.objs.S_ORG.setValue(value.sorg);
			
			if (callBack) callBack();
		});
	},
	dataCollector: function () {
		var me = this,
			data = me.callParent(arguments);

		data.type = me.objs.Type.getValue();
		data.planRazdel = me.objs.S_PLAN.getLinks();
		data.sorg = me.objs.S_ORG.getLinks();

		return data;
	},
	isFilled: function () {
		const me = this;
		let res = me.callParent(arguments);		
		res &= me.checkForEmpty(me.objs, 'Type');
		return res;
	}
});