﻿Ext.define('Keysystems.SLand.Edit', {
	extend: 'Keysystems.Base.Edit',
	fstTitle: 'Кадастровые кварталы - ',

	landRightLink: -1,

	viewMinSize: [700, 500],
	bodyPadding: 0,
	profileListeners: [{ name: 'view', method: 'FormParam' }],

	createItems: function() {
		let me = this,
			objs = me.objs,
			units = Ext.create('Ext.data.Store', { fields: ['val', 'name'], data: [{ "val": 1, "name": "Квадратный метр" }, { "val": 2, "name": "Гектар" }] });
		
		return objs.win = Ext.create('Ext.tab.Panel', {
			border: 0,
			flex: 1,
			userCls: me.basePanelCls,
			bodyCls: me.basePanelBodyCls,
			items: objs.items = [
				Ext.create('Ext.panel.Panel', {
					title: 'Общие',
					layout: { type: 'vbox', align: 'stretch' },
					bodyPadding: 10,
					border: 0,
					items: [
						Ext.create('Ext.form.FieldContainer', {
							layout: 'hbox',
							items: [
								objs.S_KVARTAL = Ext.create('Keysystems.Controls.DictCode.Edit', {
									labelWidth: me.labelWidth,
									fieldLabel: 'Кадастровый номер',
									width: 305,
									ksAllowEmpty: true,
									handler: function() {
										dictFunc({
											mode: 'SINGL',
											parentView: objs.view,
											selectLinks: objs.S_KVARTAL.getValue(),
											code: dnl.S_KVARTAL,
											control: objs.S_KVARTAL,
											contextSearch: objs.S_KVARTAL.contextSearch
										}, {
											ok: function(value) { objs.S_KVARTAL.setValue(value); }
										});
									}
								}),
								objs.CODE = Ext.create('Ext.form.field.Text', {
									padding: '0 0 0 5',
									ksAllowEmpty: true
								})
							]
						}),
						objs.S_LKATEG = Ext.create('Keysystems.Controls.Dict.Edit', {
							labelWidth: me.labelWidth,
							fieldLabel: 'Категория земли',
							ksAllowEmpty: true,
							handler: function() {
								dictFunc({
									mode: 'SINGL',
									parentView: objs.view,
									selectLinks: objs.S_LKATEG.getValue(),
									code: dnl.S_LKATEG,
									readOnly: objs.S_LKATEG.readOnly,
									control: objs.S_LKATEG,
									contextSearch: objs.S_LKATEG.contextSearch
								}, {
									ok: function(value) { objs.S_LKATEG.setValue(value); }
								});
							}
						}),
						objs.S_LUTIL = Ext.create('Keysystems.Controls.Dict.Edit', {
							labelWidth: me.labelWidth,
							fieldLabel: 'Вид использования',
							handler: function() {
								dictFunc({
									mode: 'SINGL',
									parentView: objs.view,
									selectLinks: objs.S_LUTIL.getValue(),
									code: dnl.S_LUTIL,
									readOnly: objs.S_LUTIL.readOnly,
									control: objs.S_LUTIL,
									contextSearch: objs.S_LUTIL.contextSearch
								}, {
									ok: function(value) { objs.S_LUTIL.setValue(value); }
								});
							}
						}),
						Ext.create('Ext.form.FieldContainer', {
							layout: 'hbox',
							border: 1,
							items: [
								objs.AREA = Ext.create('Ext.form.field.Number', {
									labelWidth: me.labelWidth,
									fieldLabel: 'Площадь',
									allowDecimals: true,
									width: 305,
									decimalSeparator: ".",
									decimalPrecision: 8,
									minValue: 0,
									maxValue: 999999999999.99999999
								}),
								Ext.create('Ext.form.Label', { padding: '4 10 0 10', text: 'Единица измерения:' }),
								objs.UNITCOMBO = Ext.create('Ext.form.field.ComboBox', {
									editable: false,
									store: units,
									queryMode: 'local',
									displayField: 'name',
									valueField: 'val',
									listeners: {
										change: function(th, newValue, oldValue) {
											var area = objs.AREA.value;
											objs.AREA.decimalPrecision = newValue === 1 ? 2 : 6;
											if (oldValue && objs.AREA.value) {
												objs.AREA.setValue(newValue === 1 ? area * 10000 : area / 10000);
											}
										}
									}
								})
							]
						}),
						objs.S_REGION = Ext.create('Keysystems.Controls.Dict.Edit', {
							labelWidth: me.labelWidth,
							fieldLabel: 'Территория',
							ksAllowEmpty: true,
							handler: function() {
								dictFunc({
										mode: 'SINGL',
										parentView: objs.view,
										selectLinks: objs.S_REGION.getValue(),
										code: dnl.S_REGION,
										readOnly: objs.S_REGION.readOnly,
										control: objs.S_REGION,
										contextSearch: objs.S_REGION.contextSearch
									}, {
										ok: function(value) { objs.S_REGION.setValue(value); }
									}
								);
							}
						}),
						objs.S_ADR = Ext.create('Keysystems.Controls.DictName.Edit', {
							labelWidth: me.labelWidth,
							fieldLabel: 'Адрес',
							nameField: 'ADRES',
							code: dnl.S_ADR,
							cleaningKey: false,
							handler: function() {
								dictFunc({
										mode: 'SINGL',
										parentView: objs.view,
										selectLinks: objs.S_ADR.getValue(),
										code: dnl.S_ADR,
										readOnly: objs.S_ADR.readOnly,
										control: objs.S_ADR,
										contextSearch: objs.S_ADR.contextSearch
									}, {
										ok: function(value) { objs.S_ADR.setValue(value); }
									}
								);
							}
						}),
						objs.REFMARK = Ext.create('Ext.form.field.Text', {
							labelWidth: me.labelWidth,
							fieldLabel: 'Наименование ориентира'
						}),
						objs.DISTANCE = Ext.create('Ext.form.field.Text', {
							labelWidth: me.labelWidth,
							width: me.width,
							fieldLabel: 'Расстояние от ориентира'
						}),
						objs.DIRECTION = Ext.create('Ext.form.field.Text', {
							labelWidth: me.labelWidth,
							fieldLabel: 'Направление от ориентира'
						}),
						objs.PLACED = Ext.create('Ext.form.field.Text', {
							labelWidth: me.labelWidth,
							maxLength: 6,
							enforceMaxLength: true,
							width: '160',
							fieldLabel: 'Положение на ДКК'
						}),
						objs.NOTE = Ext.create('Ext.form.field.TextArea', {
							fieldLabel: 'Примечание',
							labelWidth: me.labelWidth,
							flex: 1							
						})
					]
				}),
				Ext.create('Ext.panel.Panel', {
					title: 'Правообладатели',
					layout: { type: 'vbox', align: 'stretch' },
					border: 0,
					items: [
						objs.Owners = Ext.create('Ext.grid.Panel', {
							flex: 1,
							border: 0,
							store: Ext.create('Ext.data.Store', {
								fields: [],
								data: [],
								proxy: 'memory'
							}),
							columns: [],
							tbar: [
								Ext.create('Ext.Button', {
									key: 'new',
									iconCls: 'x_btn_new',
									handler: function() { me.createEditLandRight(); }
								}),
								Ext.create('Ext.Button', {
									key: 'edit',
									iconCls: 'x_btn_edit',
									disabled: true,
									handler: function() {
										me.createEditLandRight(objs.Owners.getSelectionModel().getSelection()[0]);
									}
								}),
								Ext.create('Ext.Button', {
									key: 'delete',
									iconCls: 'x_btn_delete',
									disabled: true,
									handler: function() {
										objs.Owners.removeSelection(function(rec) {
											var pos = ArrayLib.find(me.ownerData, ['LINK'], rec.data.LINK);
											if (pos !== -1) me.ownerData.splice(pos, 1);
										});
									}
								})
							],
							columnLines: true,
							listeners: {
								itemdblclick: function(th1, record) { me.createEditLandRight(record); },
								selectionchange: (_, sels) => {
									let toolbar = objs.Owners.getToolbar(),
										tBarItems = toolbar ? toolbar.items.items : null;
									if (!toolbar || !tBarItems) return;

									let btnEdit = tBarItems.filter(item => item.key === 'edit')[0];
									if (btnEdit) btnEdit.setDisabled(!sels.length);

									let btnDelete = tBarItems.filter(item => item.key === 'delete')[0];
									if (btnDelete) btnDelete.setDisabled(me.readOnly || !sels.length);
								}
							}
						})
					],
					setKsReadOnly: function(val) {
						let toolbar = objs.Owners.getToolbar(),
							tBarItems = toolbar ? toolbar.items.items : null;
						if (!toolbar || !tBarItems) return;

						tBarItems.filter(item => ['new', 'delete'].indexOf(item.key) >= 0)
							.forEach(item => item.setDisabled(val));

						if (val) {
							let btnOpen = tBarItems.filter(item => item.key === 'edit')[0];
							if (btnOpen) btnOpen.setIconCls('x_btn_open');
						}
					}
				})
			]
		});
	},

	createEditLandRight: function(ownerRecord) {
		var me = this,
			objs = me.objs;
		Ext.create('Keysystems.Row.LandRights.Edit', {
			f: ownerRecord ? 'edit' : 'new',
			data: ownerRecord,
			ИП: objs.ИП,
			title: 'Правообладатели земельных участков',
			parentView: objs.view,
			readOnly: me.readOnly,
			okFunc: function(result) {
				var link = result.LINK,
					record,
					pos = ArrayLib.find(me.ownerData, ['LINK'], link);
				if (pos === -1) {
					record = { LINK: link = me.landRightLink--, S_LAND: objs.link };
					me.ownerData.push(record);
					this.objs.link = link;
				} else {
					record = me.ownerData[pos];
				}

				record.TEMP_TYPE = result.TEMP_TYPE;
				record.TEMP_TYPE_NAME = result.TEMP_TYPE_NAME;
				record.CHISL = result.CHISL;
				record.ZNAM = result.ZNAM;
				record.S_ORG = result.S_ORG;
				record.S_PERSON = result.S_PERSON;
				record.FIRSTNAME = result.FIRSTNAME;
				record.LASTNAME = result.LASTNAME;
				record.PATRONYMIC = result.PATRONYMIC;
				record.TEMP_INN = result.TEMP_INN;
				record.TEMP_CODE = result.TEMP_CODE;
				record.TEMP_NAME = result.TEMP_NAME;
				record.TEMP_SNAME = result.TEMP_SNAME;
				record.S_RTYPE = result.S_RTYPE;
				record.TEMP_RTYPE_CODE = result.TEMP_RTYPE_CODE;
				record.TEMP_RTYPE_NAME = result.TEMP_RTYPE_NAME;
				record.DATE_BEGIN = result.DATE_BEGIN;
				record.DATE_REG = result.DATE_REG;
				record.DATE_END = result.DATE_END;

				objs.Owners.store.loadData(me.ownerData, false);
				QuickMsgs.save();
				return record;
				
			}
		});
	},

	viewCfg: function() {
		var res = this.callParent(arguments);
		res.resizable = true;
		res.maximizable = true;
		return res;
	},
	
	dataCollector: function() {
		var me = this,
			objs = me.objs,
			owners = [];

		for (var i = 0, len = me.ownerData.length; i < len; i++) {
			var rec = me.ownerData[i];
			var val = {
				LINK: rec.LINK,
				TEMP_TYPE: rec.TEMP_TYPE,
				TEMP_TYPE_NAME: rec.TEMP_TYPE_NAME,
				S_ORG: rec.S_ORG,
				S_PERSON: rec.S_PERSON,
				TEMP_INN: rec.TEMP_INN,
				TEMP_CODE: rec.TEMP_CODE,
				TEMP_NAME: rec.TEMP_NAME,
				TEMP_SNAME: rec.TEMP_SNAME,
				S_RTYPE: rec.S_RTYPE,
				TEMP_RTYPE_CODE: rec.TEMP_RTYPE_CODE,
				TEMP_RTYPE_NAME: rec.TEMP_RTYPE_NAME,
				CHISL: rec.CHISL,
				ZNAM: rec.ZNAM,
				DATE_BEGIN: rec.DATE_BEGIN,
				DATE_REG: rec.DATE_REG,
				DATE_END: rec.DATE_END
			};
			owners.push(val);
		}

		var data = me.callParent([false]);
		data.KVARTAL = objs.S_KVARTAL.getLink();
		data.PART_CODE = objs.CODE.getValue();
		data.S_LKATEG = objs.S_LKATEG.getLink();
		data.S_LUTIL = objs.S_LUTIL.getLink();
		data.S_REGION = objs.S_REGION.getLink();
		data.S_ADR = objs.S_ADR.getLink();
		data.UNIT = objs.UNITCOMBO.value;
		data.AREA = objs.AREA.getValue();
		data.REFMARK = objs.REFMARK.getValue();
		data.DISTANCE = objs.DISTANCE.getValue();
		data.DIRECTION = objs.DIRECTION.getValue();
		data.PLACED = objs.PLACED.getValue();
		data.NOTE = objs.NOTE.getValue();
		data.Owners = JSON.stringify(owners);
		return data;
	},

	loadCopyEditData: function() {
		var me = this,
			objs = me.objs,
			data = me.data.data;
		me.callParent();
		objs.link = data.LINK;
		objs.S_KVARTAL.setValue({ data: { LINK: data.KVARTAL, CODE: data.KVARTAL_CODE } });
		objs.CODE.setValue(data.PART_CODE);
		objs.S_LKATEG.setValue({ data: { LINK: data.S_LKATEG, CODE: data.S_LKATEG_CODE, NAME: data.S_LKATEG_NAME } });
		objs.S_LUTIL.setValue({ data: { LINK: data.S_LUTIL, CODE: data.S_LUTIL_CODE, NAME: data.S_LUTIL_NAME } });
		objs.S_REGION.setValue({ data: { LINK: data.S_REGION, CODE: data.S_REGION_CODE, NAME: data.S_REGION_NAME } });
	},

	getExtra: function(endFunc, link) {
		var me = this;
		me.baseGetExtra({ link: link }, function(value) {
			me.setExtraLandData(value);
			if (endFunc) endFunc();
		});
	},
	
	setExtraLandData: function(value) {
		var me = this,
			objs = me.objs;
		objs.AREA.setValue(value.AREA);
		objs.UNITCOMBO.setValue(value.UNIT);
		objs.S_ADR.visibleFields = value.adrVf;
		objs.S_ADR.setValue(value.S_ADR);
		objs.REFMARK.setValue(value.REFMARK);
		objs.DISTANCE.setValue(value.DISTANCE);
		objs.DIRECTION.setValue(value.DIRECTION);
		objs.PLACED.setValue(value.PLACED);
		objs.NOTE.setValue(value.NOTE);
		// правообладатели
		objs.Owners.store.setFields(value.Owners.fields);
		objs.Owners.reconfigure(objs.Owners.store, value.Owners.columns);
		objs.Owners.store.loadData(value.Owners.data, true);
		me.ownerData = value.Owners.data;
		// whereargs для ИП
		objs.ИП = value.ИП;
	},

	isFilled: function() {
		const me = this;
		const objs = me.objs;
		
		let res = me.checkForEmpty(me.objs, 'S_KVARTAL');		
		if (objs.CODE.getValue() === '') {
			res = false;
			me.addToInvalidControls(objs.CODE, {title: 'Номер земельного участка'});
		}
		res &= me.checkForEmpty(me.objs, 'S_LKATEG', 'S_REGION');		
		return res;
	}
});