﻿Ext.define('Keysystems.SKvartal.Edit', {
	extend: 'Keysystems.Base.Edit',
	fstTitle: 'Кадастровые кварталы - ',
	createItems: function() {
		var me = this,
			objs = me.objs,
			items = [
				objs.S_REGION = Ext.create('Keysystems.Controls.Dict.Edit', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Территория',
					ksAllowEmpty: true,
					width: me.width,
					handler: function() {
						dictFunc({
							mode: 'SINGL',
							parentView: objs.view,
							selectLinks: objs.S_REGION.getValue(),
							code: dnl.S_REGION,
							readOnly: objs.S_REGION.readOnly,
							control: objs.S_REGION,
							contextSearch: objs.S_REGION.contextSearch,
						}, {
							ok: function(value) {
								objs.S_REGION.setValue(value);
							}
						});
					}
				}),
				objs.NOTE = Ext.create('Ext.form.field.TextArea', {
					fieldLabel: 'Примечание',
					labelWidth: me.labelWidth,
					maxLength: 255,
					enforceMaxLength: true,
					width: me.width,
					height: 100,
				})
			];

		me.codeEditCfg = {
			maxLength: 50,
			enforceMaxLength: true,
			fieldLabel: 'Кадастровый квартал'
		};
		me.isCodeEdit = true;

		return me.callParent([items]);
	},
	dataCollector: function() {
		var me = this,
			objs = me.objs;

		var data = me.callParent([false]);
		data.region = objs.S_REGION.getLink();
		data.note = objs.NOTE.getValue();
		return data;
	},
	loadCopyEditData: function() {
		var me = this,
			objs = me.objs,
			data = me.data.data;

		objs.S_REGION.setValue({
			data: {
				LINK: data.S_REGION,
				CODE: data.S_REGION_CODE,
				NAME: data.S_REGION_NAME
			}
		});
		objs.NOTE.setValue(data.NOTE);

		me.callParent();
	},
	isFilled: function() {
		const me = this;
		return me.checkForEmpty(me.objs, 'CODE', 'S_REGION');
	}
});