﻿Ext.define('Keysystems.SKladr.Edit', {
	extend: 'Keysystems.Base.Edit',
	createItems: function() {
		var me = this,
			objs = me.objs,
			items = [
				objs.CODE = Ext.create('Ext.form.field.Text', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Код',
					ksAllowEmpty: true,
					maxLength: 20,
					maxWidth: 320,
					enforceMaxLength: true,
				}),
				me.createNameEdit({ maxLength: 40, enforceMaxLength: true }),
				objs.S_OKSM = me.createDictEdit({
					key: 'S_OKSM',
					mode: 'SINGL',
					code: dnl.S_OKSM,
					fieldLabel: 'Страна'
				}),
				objs.SOCR = Ext.create('Ext.form.field.ComboBox', {
					fieldLabel: 'Сокр. наименование типа объекта',
					labelWidth: me.labelWidth,
					maxLength: 10,
					enforceMaxLength: true,
					store: Ext.create('Ext.data.Store', {
						fields: [{ name: 'value', type: 'string' }],
						data: [],
						proxy: 'memory'
					}),
					queryMode: 'local',
					displayField: 'value'
				}),
				objs.P_INDEX = Ext.create('Ext.form.field.Text', {
					fieldLabel: 'Почтовый индекс',
					labelWidth: me.labelWidth,
					maxLength: 6,
					enforceMaxLength: true
				}),
				objs.GNINMB = Ext.create('Ext.form.field.Text', {
					fieldLabel: 'Код ИФНС',
					labelWidth: me.labelWidth,
					maxLength: 6,
					enforceMaxLength: true
				}),
				objs.UNO = Ext.create('Ext.form.field.Text', {
					fieldLabel: 'Код территориального участка ИФНС',
					labelWidth: me.labelWidth,
					maxLength: 4,
					enforceMaxLength: true
				}),
				objs.OCATD = Ext.create('Ext.form.field.Text', {
					fieldLabel: 'Код ОКАТО',
					labelWidth: me.labelWidth,
					maxLength: 11,
					enforceMaxLength: true
				})
			];

		return objs.items = items;
	},
	createBtns: function() {
		var me = this,
			data = me.data,
			objs = me.objs,
			btns = [
				Ext.create('Ext.Button', {
					width: 75,
					text: 'Закрыть',
					handler: function() { objs.view.close(); }
				})
			];
		me.callParent();
		if (data && data.data.USER_ADDED != 1 && me.f !== 'copy') objs.btns = btns;
	},
	dataCollector: function() {
		var me = this,
			objs = me.objs,
			data = me.callParent(arguments);

		data.code = objs.CODE.getValue();
		data.name = objs.NAME.getValue();
		data.sOksmLink = objs.S_OKSM.getLink();
		data.socr = objs.SOCR.getValue();
		data.p_index = objs.P_INDEX.getValue();
		data.gninmb = objs.GNINMB.getValue();
		data.uno = objs.UNO.getValue();
		data.ocatd = objs.OCATD.getValue();
		return data;
	},
	loadCopyEditData: function() {
		var me = this,
			objs = me.objs,
			data = me.data.data;
		objs.link = data.LINK;
		me.setCodeValue(data.CODE);
		objs.NAME.setValue(data.NAME);
		objs.SOCR.setValue(data.SOCR);
		objs.P_INDEX.setValue(data.P_INDEX);
		objs.GNINMB.setValue(data.GNINMB);
		objs.UNO.setValue(data.UNO);
		objs.OCATD.setValue(data.OCATD);
		if (data.USER_ADDED != 1 && me.f != 'copy') {
			objs.CODE.setReadOnly(true);
			objs.NAME.setReadOnly(true);
			objs.SOCR.setReadOnly(true);
			objs.P_INDEX.setReadOnly(true);
			objs.GNINMB.setReadOnly(true);
			objs.UNO.setReadOnly(true);
			objs.OCATD.setReadOnly(true);
		}
	},
	getExtra: function(endFunc, link) {
		var me = this;
		me.baseGetExtra({ link: link }, function(value) {
			me.objs.S_OKSM.setValue(value.S_OKSM);
			var socr = [];
			switch (me.code) {
			case 'DICTIONARY_SKLADR_REGION':
				socr.push({ value: 'респ' }, { value: 'обл' }, { value: 'край' }, { value: 'АО' });
				break;
			case 'DICTIONARY_SKLADR_RAYON':
				socr.push({ value: 'р-н' });
				break;
			case 'DICTIONARY_SKLADR_CITY':
				socr.push({ value: 'г' });
				break;
			case 'DICTIONARY_SKLADR_NPUNKT':
				socr.push({ value: 'с' }, { value: 'п' }, { value: 'пгт' }, { value: 'д' });
				break;
			case 'DICTIONARY_SKLADR_STREET':
				socr.push({ value: 'ул' }, { value: 'пр-кт' }, { value: 'км' }, { value: 'пер' }, { value: 'проезд' });
				break;
			case 'DICTIONARY_SKLADR_INDEX':
				socr.push({ value: 'ДОМ' });
				break;
			}
			me.objs.SOCR.store.loadData(socr);
			me.objs.SOCR.setValue(value.row.SOCR);

			me.objs.CODE.setValue(value.row.CODE);
			if (endFunc) endFunc();
		});
	}
});