﻿Ext.define('Keysystems.SInfo.Edit', {
	extend: 'Keysystems.Base.Edit',
	bodyPadding: 0,
	createItems: function() {
		var me = this,
			objs = me.objs;
		return me.objs.allTab = Ext.create('Ext.tab.Panel', {
			plain: true,
			width: me.width,
			height: 400,
			border: 0,
			userCls: me.basePanelCls,
			bodyCls: me.basePanelBodyCls,
			items: objs.items = [
				Ext.create('Ext.panel.Panel', {
					title: 'Общие',
					layout: {type: 'vbox', align: 'stretch'},
					bodyPadding: 10,
					border: 0,
					items: [
						me.createCodeEdit({maxLength: 50, enforceMaxLength: true}),
						me.createNameEdit({maxLength: 250, enforceMaxLength: true}),
						objs.S_ORG = me.createDictEdit({
							key: 'S_ORG',
							mode: 'SINGL',
							code: dnl.S_ORG,
							fieldLabel: 'Источник информации'
						}),
						objs.S_ROSNOV = me.createDictEdit({
							key: 'S_ROSNOV',
							mode: 'SINGL',
							code: dnl.S_ROSNOV,
							fieldLabel: 'Основание'
						})
					]
				})
			]
		});
	},

	//конструктор таба Реквизиты
	createTabProp: function() {
		return this.objs.tabProp = Ext.create('Keysystems.Panel.Prop', {
			parentView: this,
			decimalData: this.gksd('decimalData')
		});
	},

	dataCollector: function() {
		var me = this,
			objs = me.objs;

		var data = me.callParent([false]);
		data.link = objs.link;
		data.code = objs.CODE.getValue();
		data.name = objs.NAME.getValue();
		data.org = objs.S_ORG.getLink();
		data.rosnov = objs.S_ROSNOV.getLink();
		data.prop = me.getTab('Prop').getData(1);
		return data;
	},

	getExtra: function(callBack, link) {
		var me = this,
			objs = me.objs;
		
		me.baseGetExtra({ link: link }, function(value) {
			me.sksd('decimalData', value.decimalData);
			me.setCodeValue(value.code);
			objs.NAME.setValue(value.name);
			objs.S_ORG.setValue(value.org);
			objs.S_ROSNOV.setValue(value.rosnov);

			if (value.prop) {
				objs.allTab.changeTab(me.getTab('Prop').loadData(value.prop), true);
			}

			if (callBack) callBack();
		});
	}
});