﻿Ext.define('Keysystems.SEdsLevel.Edit', {
	extend: 'Keysystems.Base.Edit',
	createItems: function() {
		var me = this,
			minText = 'Минимальное значение уровня 0',
			objs = me.objs,
			items = [
				objs.ORDERS = Ext.create('Ext.form.field.Number', {
					fieldLabel: 'Номер уровня',
					labelWidth: me.labelWidth,
					minValue: 0,
					maxLength: 10,
					maxWidth: 300,
					enforceMaxLength: true,
					minText: minText,
					negativeText: minText,
					ksAllowEmpty: true,
					allowExponential: false					
				}),
				me.createNameEdit({ maxLength: 50, enforceMaxLength: true }),
				objs.USERS = Ext.create('Keysystems.Controls.Dict.Edit', {
					labelWidth: me.labelWidth,
					fieldLink: 'UID',
					fieldLabel: 'Пользователи',
					mode: 'MULTI',
					handler: function() {
						dictFunc({
							mode: 'MULTI',
							parentView: objs.view,
							readOnly: objs.USERS.readOnly,
							whereArgs: {
								IncludeGroups: { value: 'False', type: 'bool' }
							},
							selectLinks: objs.USERS.getValue(),
							code: dnl.S_LOGIN,
							control: objs.USERS,
							contextSearch: objs.USERS.contextSearch,
						}, { ok: function(value) { objs.USERS.setValue(value); } });
					}
				})
			];

		return objs.items = items;
	},
	isFilled: function() {
		const me = this;
		const objs = me.objs;
		let res = true;
		
		if (objs.ORDERS.getValue() == null) {
			me.addToInvalidControls(objs.ORDERS);
			res = false;
		}		
		if (objs.NAME.getValue() === '') {			
			me.addToInvalidControls(objs.NAME);
			res = false;
		}
		return res;
	},
	dataCollector: function() {
		var me = this,
			objs = me.objs,
			data = me.callParent(arguments);

		data.NAME = objs.NAME.getValue();
		data.ORDERS = objs.ORDERS.getValue();
		data.USERS = objs.USERS.getLinks(1);
		return data;
	},
	getExtra: function(endFunc, link) {
		var me = this,
			objs = me.objs;
		me.baseGetExtra({ link: link }, function(value) {
			me.autoFillControl(value.row);
			objs.NAME.setValue(value.row.NAME);
			objs.ORDERS.setValue(value.row.ORDERS);
			objs.USERS.setValue(value.USERS);
			if (endFunc) endFunc();
		});
	}
});