﻿Ext.define('Keysystems.Edits.DocVid', {
	extend: 'Keysystems.Base.Edit',
	saveRuleLink: -1,
	isFileBtn: true,
	filesRowLink: -1,
	bodyPadding: 0,
	viewMinSize: [700, 550],
	viewCfg: function () {
		let cfg = this.callParent(arguments);
		cfg.resizable = true;
		return cfg;
	},	
	//констркутор интерфейса
	createItems: function () {
		var me = this,
			objs = me.objs;
		
		me.objs.allTab = Ext.create('Ext.tab.Panel', {
			plain: true,
			border: 0,
			userCls: me.basePanelCls,
			bodyCls: me.basePanelBodyCls,
			flex: 1,
			items:  objs.items = [
				Ext.create('Ext.panel.Panel', {
					title: 'Общие',
					layout: { type: 'vbox', align: 'stretch' },
					border: 0,
					bodyPadding: 10,
					items: [
						Ext.create('Ext.form.FieldContainer', {
							layout: 'hbox',
							items: [
								me.createCodeEdit({
									maxLength: 10,
									enforceMaxLength: true,
									flex: 1,
									padding: '0 10 0 0'
								}),
								objs.btnSaveRules = Ext.create('Ext.Button', {
									iconCls: 'x_btn_docs_unmark',
									tooltip: wmc.get('SaveRulesToolTip'),
									tooltipType: 'title',
									handler: function () { me.btnSaveRulesHandler(); }
								})
							]
						}),
						me.createNameEdit({
							maxLength: 200,
							enforceMaxLength: true
						}),
						objs.TYPE = Ext.create('Keysystems.Controls.DocVid.Type', {
							labelWidth: me.labelWidth,
							inOutChange: function () {
								objs.allTab.changeTab(me.getTab('Corr'), !objs.TYPE.getCorrDisabled());
							}
						}),
						objs.OKUD = Ext.create('Ext.form.field.Text', {
							fieldLabel: 'ОКУД',
							labelWidth: me.labelWidth,
							enforceMaxLength: true,
							maxLength: 8
						}),
						Ext.create('Ext.form.FieldContainer', {
							fieldLabel: 'Подписывает',
							labelWidth: me.labelWidth,
							layout: { type: 'vbox', align: 'stretch' },
							items: [
								objs.AUTOSIGNCOMBOBOX = Ext.create('Keysystems.Controls.ComboBoxExtra', {
									editable: false,
									value: null,
									height: 24,
									store: Ext.create('Ext.data.Store', {
										fields: CBDataLib.getFields(),
										data: CBDataLib.get('AutoSignMethod', 1),
										proxy: 'memory'
									}),
									displayField: 'value',
									valueField: 'index'
								}),
								objs.AUTOSIGNFORMULA = Ext.create('Keysystems.Controls.Formula.Edit', {
									hidden: true,
									ksAllowEmpty: true									
								}),
								objs.AUTOSIGN = Ext.create('Ext.form.field.Checkbox', {
									boxLabel: ' Формула',
									listeners: {
										change: function (th1, newValue) {
											objs.AUTOSIGNCOMBOBOX.setVisible(!newValue);
											objs.AUTOSIGNFORMULA.setVisible(newValue);
										}
									}
								})
							]
						}),
						Ext.create('Ext.form.FieldSet', {
							title: 'Автонумерация',
							layout: { type: 'vbox', align: 'stretch' },
							bodyPadding: me.bodyPadding,
							items: [
								objs.NUMMASK = Ext.create('Keysystems.Controls.Formula.Edit', {
									fieldLabel: 'Маска',
									maxLength: 500,
									enforceMaxLength: true,
									labelWidth: me.labelWidth,
									IsMask: true,
									IncludeThruNumber: true,
									IncludeSCalc: false,
									Code: me.code || dnl.S_DOCVID,
									checkChangeBuffer: 500,
									listeners: {
										change: function (th, val) {
											if (me.isLoaded) return;

											me.showLoadMask({
												msg: KS.L10n.SDOCVIDUpdController_CheckSave_Расчет_маски,
												rid: ajaxRequest({
													url: 'SDocvid/NormalizeMask_A',
													params: { mask: val },
													success: function(response) {
														if (!response) return;
														me.objs.NUM.setDisabled(!response.enabled);
													},
													callback: function() {
														me.hideLoadMask();
													}
												})
											});
										}
									}
								}),
								objs.NUM = Ext.create('Ext.form.field.Number', {
									fieldLabel: 'Текущий номер',
									labelWidth: me.labelWidth,
									maxWidth: 300,
									value: 0,
									minValue: 0,
								}),
								objs.NUMDOCVID = Ext.create('Ext.form.field.Checkbox', {
									boxLabel: ' в пределах вида документа'
								})
							]
						}),
						Ext.create('Ext.form.FieldSet', {
							title: 'Условные шаблоны',
							layout: 'anchor',
							padding: 0,
							flex: 1,
							minHeight: 150,
							items: [
								objs.DOCVIDFILES_Grid = Ext.create('Ext.grid.Panel', {
									layout: { type: 'vbox', align: 'stretch' },
									flex: 1,
									scrollable: true,
									plugins: [
										Ext.create('Ext.grid.plugin.CellEditing', { clicksToEdit: 1 }),
										'gridclipboard'
									],
									tbar: objs.DOCVIDFILES_tbar = [
										Ext.create('Ext.Button', {
											key: 'new',
											iconCls: 'x_btn_new',
											handler: function () {
												var rec = objs.DOCVIDFILES_Grid.getStore().add({ LINK: me.filesRowLink-- });
												objs.DOCVIDFILES_Grid.getSelectionModel().select(rec);
											}
										}),
										Ext.create('Ext.Button', {
											key: 'delete',
											disabled: true,
											iconCls: 'x_btn_delete',
											handler: function () {
												objs.DOCVIDFILES_Grid.removeSelection();
											}
										}),
										{ xtype: 'tbseparator' },
										objs.usl_file_btn = Ext.create('Ext.Button', {
											key: 'template',
											text: 'Шаблон',
											disabled: true,
											handler: function () {
												var sel = objs.DOCVIDFILES_Grid.getSelectionModel().getSelection()[0];
												if (sel) me.fileGridEdit(sel);
											}
										})
									],
									border: 0,
									store: Ext.create('Ext.data.Store', { fields: [], data: [], proxy: 'memory' }),
									columns: [],
									columnLines: true,
									listeners: {
										select: (th1, rec) => {
											objs.usl_file_btn.setIconCls(getExtStyle(rec.get('TEMP_EXT')));
										},
										selectionchange: (_, sels) => me.enableToolsGrid(objs.DOCVIDFILES_Grid, sels)
									}
								})
							]
						})
					]
				})
			]
		});

		me.getTab('Corr'); //первичная инициализация таба коррeспондент

		return me.objs.allTab;
	},

	//Правила предварительного контроля
	btnSaveRulesHandler: function () {
		var me = this,
			objs = me.objs,
			profileKey = 'dictSaveRules',
			gateCode = 'edit',
			prefix = 'docvid',
			saveRules = objs.saveRules,
			columns = saveRules.columns,
			fields = saveRules.fields,
			data = {
				data: saveRules.data,
				total: saveRules.data.length
			};

		Ext.create('Keysystems.Base.List', {
			code: me.code,
			parentView: objs.view,
			title: wmc.get('SaveRulesToolTip'),
			checkModel: false,
			GateCode: gateCode,
			prefix: prefix,
			profileKey: profileKey,
			hidePagging: true,
			pageSize: 1000,
			btnsHide: { search: true },
			functions: {
				getData: function (endFunc) {
					loadProfile({
						code: me.code,
						prefix: prefix,
						gateCode: gateCode,
						profileKey: profileKey,
						callBack: function () {
							endFunc({ columns: columns, fields: fields, data: data });
						}
					});
					this.gridStore.sort([{ property: 'ORD', direction: 'ASC' }]);
				},
				refresh: function (endFunc) { endFunc(data); },
				close: function () {
					let me1 = this,
						res = me1.gridStore.getDataExt();

					objs.saveRules.data = res;
					if (objs.saveRules.data && objs.saveRules.data.filter(r => r.TYPE).length) {
						objs.btnSaveRules.setIconCls('rks-background-contain x_btn_docs_mark');
						objs.btnSaveRules.setTooltip(KS.L10n.Присутствуют_активные_правила);
					} else {
						objs.btnSaveRules.setIconCls('rks-background-contain x_btn_docs_unmark');
						objs.btnSaveRules.setTooltip(KS.L10n.Отсутствуют_активные_правила);
					}
				},
				edit: function (cfg) {
					var c = {
						baseSaveData: function (params) {
							var me1 = this;

							if (!params.link) params.link = me1.objs.link = me.saveRuleLink--;
							me1.oldData = JSON.stringify(params);
							params.LINK = params.link;

							var pos = ArrayLib.find(data.data, ['LINK'], params.link);
							if (pos === -1) {
								var ord = 0;
								Ext.each(data.data, function (rec) { if (rec.ORD > ord) ord = rec.ORD + 1; });
								params.ORD = ord;

								data.data.push(params);
								data.total = data.data.length;
							} else {
								for (var key in params) data.data[pos][key] = params[key];
							}

							me1.refreshFunc();

							me1.f = 'edit';
							
							QuickMsgs.save();
						}
					};
					Ext.apply(c, cfg);
					Ext.create('Keysystems.Edits.SaveRules', c);
				},
				'delete': function (links, callBack) {
					Ext.each(links, function (link) {
						var pos = ArrayLib.find(data.data, ['LINK'], link);
						if (pos !== -1) {
							data.data.splice(pos, 1);
							data.total = data.data.length;
						}
					});
					this.pagingTool.doRefresh();
					if (callBack) callBack();
				}
			}
		});
	},

	btnSaveRulesSetState: function () {
		let me = this,
			objs = me.objs;
		if (objs.saveRules.data && objs.saveRules.data.filter(r => r.TYPE).length) {
			objs.btnSaveRules.setIconCls('rks-background-contain x_btn_docs_mark');
			objs.btnSaveRules.setTooltip(KS.L10n.Присутствуют_активные_правила);
		} else {
			objs.btnSaveRules.setIconCls('rks-background-contain x_btn_docs_unmark');
			objs.btnSaveRules.setTooltip(KS.L10n.Отсутствуют_активные_правила);
		}
	},

	createListeners: function () {
		var me = this,
			objs = me.objs;
		return objs.listeners = {
			beforeclose: function () {
				if (objs.ignoreSaveRulesChange) return true;

				if (objs.saveRulesRaw === JSON.stringify(objs.saveRules.data)) {
					return true;
				}

				selectDialogShow(KS.L10n.attention, wmc.get('SaveRulesChange'), function () {
					objs.ignoreSaveRulesChange = true;
					objs.view.close();
				});

				return false;
			}
		};
	},

	//конструктор таба Реквизиты
	createTabProp: function() { 
		return this.objs.tabProp = Ext.create('Keysystems.Panel.Prop', {
			parentView: this,
			decimalData: this.gksd('decimalData'),
			flex: 1
			
		});
	},

	//конструктор таба Корреспондент
	createTabCorr: function () {
		var me = this,
			objs = me.objs;

		objs.tabCorr = Ext.create('Ext.panel.Panel', {
			title: 'Корреспондент',
			layout: { type: 'vbox', align: 'stretch' },
			bodyPadding: 10,
			border: 0,
			items: [
				Ext.create('Ext.form.FieldContainer', {
					labelWidth: me.labelWidth,
					layout: 'hbox',
					items: [
						objs.AUTOCORR = Ext.create('Keysystems.Controls.ComboBoxExtra', {
							fieldLabel: 'Автозаполнение',
							labelWidth: me.labelWidth,
							editable: false,
							value: null,
							store: Ext.create('Ext.data.Store', {
								fields: CBDataLib.getFields(),
								data: CBDataLib.get('AutoCorrMethod', 1),
								proxy: 'memory'
							}),
							displayField: CBDataLib.displayField,
							valueField: CBDataLib.valueField,
							flex: 5,
							listeners: {
								change: function (th1, newValue) {
									me.set_CORR_Enable(newValue === null);
								}
							}
						}),
						objs.DIRECTORC = Ext.create('Ext.form.field.Checkbox', {
							boxLabel: ' Руководитель',
							padding: '0 0 0 10',
							flex: 1,
							listeners: {
								change: function (th1, newValue) {
									me.set_S_PERSON_Enable(!newValue);
								}
							}
						})
					]
				}),
				objs.S_ORG = Ext.create('Keysystems.Controls.Dict.Edit', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Организация',
					handler: function () {
						dictFunc({
							mode: 'SINGL',
							parentView: objs.view,
							selectLinks: objs.S_ORG.getValue(),
							code: dnl.S_ORG,
							readOnly: objs.S_ORG.readOnly,
							control: objs.S_ORG,
							contextSearch: objs.S_ORG.contextSearch
						}, {
							ok: function (value) {
								objs.S_ORG.setValue(value);
								if (value.length) {
									me.set_CORR_Enable(objs.AUTOCORR.getValue() === null);
								} else {
									objs.S_OTDEL.setDisabled(true);
									objs.S_PERSON.setDisabled(true);
								}
							}
						});
					}
				}),
				objs.S_OTDEL = Ext.create('Keysystems.Controls.Dict.Edit', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Подразделение',
					disabled: true,
					handler: function () {
						dictFunc({
							mode: 'SINGL',
							parentView: objs.view,
							selectLinks: objs.S_OTDEL.getValue(),
							whereArgs: { SOrgs: { value: objs.S_ORG.getLinks(1), type: 'List_int' } },
							code: dnl.S_OTDEL,
							readOnly: objs.S_OTDEL.readOnly,
							control: objs.S_OTDEL,
							contextSearch: objs.S_OTDEL.contextSearch,
							getSOrg: () => me.objs.S_ORG.getLink()
						}, {
							ok: function (value) {
								objs.S_OTDEL.setValue(value);
							}
						});
					}
				}),
				objs.S_PERSON = Ext.create('Keysystems.Controls.Dict.Edit', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Сотрудник',
					disabled: true,
					code: dnl.S_PERSON,
					handler: function () {
						dictFunc({
							mode: 'SINGL',
							parentView: objs.view,
							selectLinks: objs.S_PERSON.getValue(),
							whereArgs: {
								SOrgs: {
									value: objs.S_ORG.getLinks(true),
									type: 'List_int'
								}
							},
							code: dnl.S_PERSON,
							readOnly: objs.S_PERSON.readOnly,
							control: objs.S_PERSON,
							contextSearch: objs.S_PERSON.contextSearch,
							inputDicts: [
								Ext.create('InputEditDict', {
									name: 'S_ORG',
									data: objs.S_ORG.getValue()
								})
							]
						}, {
							ok: function (value) { objs.S_PERSON.setValue(value); }
						});
					}
				})
			]
		});


		return objs.tabCorr;
	},

	//проверка целостности ввода
	isFilled: function () {
		const me = this;
		let res = me.callParent(arguments);
		
		if ((me.objs.AUTOSIGN.getValue()) && (me.objs.AUTOSIGNFORMULA.getValue() == '')) {
			res = false;
			me.addToInvalidControls(me.objs.AUTOSIGNFORMULA, {title: 'Подписывает'});
		}
		if (!me.objs.TYPE.getValue()) {
			res = false;
			me.addToInvalidControls(me.objs.TYPE);
		}
		return res;
	},
	dataCollector: function () {
		var me = this,
			objs = me.objs,
			objsData = me.data.data,
			docVidFiles = objs.DOCVIDFILES_Grid.store.getDataExt(function (d) {
				return { LINK: d.LINK, FILES: d.FILES, COND: d.COND };
			}),
			saveRuleJson = JSON.stringify(objs.saveRules.data);

		var data = me.callParent([false]);
		data.link = objs.link;
		data.code = objs.CODE.getValue();
		data.name = objs.NAME.getValue();
		data.type = objs.TYPE.getValue();
		data.type = objs.TYPE.getValue();
		data.okud = objs.OKUD.getValue();
		data.autosignformula = objs.AUTOSIGN.getValue() ? objs.AUTOSIGNFORMULA.getValue() : null;
		data.autosign = objs.AUTOSIGNCOMBOBOX.getValue();
		data.nummask = objs.NUMMASK.getValue();
		data.num = objs.NUM.getValue();
		data.numdocvid = objs.NUMDOCVID.getValue();
		data.docVidFiles = JSON.stringify(docVidFiles);
		data.tabProp = me.getTab('Prop').getData(1);
		data.autocorr = objs.AUTOCORR.getValue();
		data.director = objs.DIRECTORC.getValue();
		data.org = objs.S_ORG.getLink();
		data.otdel = objs.S_OTDEL.getLink();
		data.person = objs.S_PERSON.getLink();
		data.files = objsData.FILES;
		data.saveRules = saveRuleJson;
		data.narremMask = me.gksc('narremMask').getValue();
		return data;
	},

	successSaveFunc: function (res) {
		if (res.docVidFiles) this.objs.DOCVIDFILES_Grid.store.loadData(res.docVidFiles, false);
		this.callParent(arguments);
	},

	//метод сохранения данных
	saveData: function (endFunc, params) {
		var me = this,
			objs = me.objs,
			saveRuleJson = JSON.stringify(objs.saveRules.data);

		me.callParent([
			function (result) {
				objs.saveRulesRaw = saveRuleJson;
				if (endFunc) endFunc(result);
			}, params
		]);
	},

	set_S_PERSON_Enable: function (value) {
		var me = this;
		if (value) {
			if ((me.objs.AUTOCORR.getValue() === null) && (!me.objs.S_ORG.isEmpty())) {
				me.objs.S_PERSON.setDisabled(false);
			}
		} else {
			me.objs.S_PERSON.setDisabled(true);
		}
	},
	set_CORR_Enable: function (value) {
		var me = this,
			objs = me.objs;
		if (value) {
			objs.S_ORG.setDisabled(false);
			if (!objs.S_ORG.isEmpty()) {
				objs.S_OTDEL.setDisabled(false);
				if (!objs.DIRECTORC.getValue()) {
					objs.S_PERSON.setDisabled(false);
				}
			}
		} else {
			objs.S_ORG.setDisabled(true);
			objs.S_OTDEL.setDisabled(true);
			objs.S_PERSON.setDisabled(true);
		}
	},
	FILES_Grid_column_adapted: function (columns) {
		var me = this,
			col,
			pos = ArrayLib.find(columns, ['dataIndex'], 'COND');

		if (pos === -1) {
			col = { text: 'Условие', dataIndex: 'COND' };
			columns.push(col);
		} else {
			col = columns[pos];
		}
		col.editor = {
			xtype: 'formulaedit',
			listeners: {
				change: function(th, v) {
					var rec = ArrayLib.getByPath(th, 'ownerCt.editingPlugin.context.record');
					if (rec) rec.set('COND', v);
				}
			}
		};
		col.flex = 1;
		
		col = {
			xtype: 'actioncolumn',
			dataIndex: 'FileEdit',
			text: 'Файл',
			width: 60,
			align: 'center',
			items: [
				{
					getClass: function (v, meta, rec) { return getExtStyle(rec.get(me.fieldExt)); },
					handler: function (grid, rowIndex) { me.fileGridEdit(grid.getStore().getAt(rowIndex)); }
				}
			]
		};
		pos = ArrayLib.find(columns, ['dataIndex'], 'fileEdit');
		if (pos === -1) {
			columns.push(col);
		} else {
			columns[pos] = col;
		}
		return columns;
	},

	getExtra: function (callBack, link) {
		var me = this,
			objs = me.objs;

		me.baseGetExtra({ link: link, needResource: true }, function (value) {
			Ext.each(value.docVidFiles.fields, function (f) {
				if (f.name === 'FILES') {
					f.type = 'string';
					return false;
				}
				return true;
			});

			me.sksd('decimalData', value.decimalData);
			
			value.docVidFiles.columns = me.FILES_Grid_column_adapted(value.docVidFiles.columns);
			objs.DOCVIDFILES_Grid.setMetaDate(value.docVidFiles, {
				profileCode: me.code,
				profileKey: 'gridDocvidFiles',
				gateCode: 'edit'
			});
			
			if (value.prop) {
				value.prop.AllowPropMask = true;
				value.prop.AllowPropFill = false;
				objs.allTab.changeTab(me.getTab('Prop').loadData(value.prop), true);
			}

			me.setCodeValue(value.row.CODE);
			objs.NAME.setValue(value.row.NAME);
			objs.TYPE.setValue(value.row.TYPE);
			objs.OKUD.setValue(value.row.OKUD);
			objs.AUTOSIGNFORMULA.setValue(value.row.AUTOSIGNFORMULA);
			objs.NUMMASK.setValue(value.row.NUMMASK);
			objs.NUMDOCVID.setValue(value.row.NUMDOCVID);
			objs.btnFile.setIconCls(getExtStyle(value.tempExt));
			objs.AUTOSIGN.setValue(value.row.AUTOSIGNFORMULA !== null);
			objs.AUTOSIGNCOMBOBOX.setValue(value.row.AUTOSIGN);
			objs.AUTOCORR.setValue(value.row.AUTOCORR);
			objs.DIRECTORC.setValue(value.row.DIRECTORC);

			objs.S_ORG.setValue(value.org);
			objs.S_OTDEL.setValue(value.otdel);
			objs.S_PERSON.setValue(value.person);
			objs.NUM.setValue(value.numVal);
			objs.NUM.setDisabled(!value.canEditNum);

			me.set_CORR_Enable(value.row.AUTOCORR === null);

			objs.saveRules = value.SaveRules;
			objs.saveRulesRaw = JSON.stringify(objs.saveRules.data);
			Ext.each(objs.saveRules.columns, function (col) { col.sortable = false; });

			if (objs.saveRules.data && objs.saveRules.data.filter(r => r.TYPE).length) {
				objs.btnSaveRules.setIconCls('rks-background-contain x_btn_docs_mark');
				objs.btnSaveRules.setTooltip(KS.L10n.Присутствуют_активные_правила);
			} else {
				objs.btnSaveRules.setIconCls('rks-background-contain x_btn_docs_unmark');
				objs.btnSaveRules.setTooltip(KS.L10n.Отсутствуют_активные_правила);
			}

			if (!me.gksc('tabNarrem')) objs.allTab.changeTab(me.getTab('Narrem'), true);
			me.gksc('narremMask').setValue(value.row.NARREMOVE_MASK);
			
			if (callBack) callBack();
		});
	},

	createTabNarrem: function () {
		var me = this;
		return me.sksc('tabNarrem',
			Ext.create('Ext.panel.Panel',
				{
					title: 'Требования',
					layout: { type: 'vbox', align: 'stretch' },
					bodyPadding: 10,
					border: 0,
					items: [
						me.sksc('narremMask',
							Ext.create('Keysystems.Controls.Formula.Edit',
								{
									fieldLabel: 'Маска требования',
									maxLength: 1000,
									enforceMaxLength: true,
									labelWidth: me.labelWidth
								}))
					]
				}));
	},

	loadNewData: function () {
		let me = this;
		me.callParent();
		if (!me.data) me.data = {data: {}};
		me.data.data.FILES = 0;
	},
});