﻿Ext.define('Keysystems.SCheck.Edit', {
	extend: 'Keysystems.Base.Edit',
	createItems: function() {
		var me = this,
			objs = me.objs,
			items = [
				objs.S_WORK = me.createDictEdit({
					mode: 'MULTI',
					code: dnl.S_WORK,
					labelWidth: me.labelWidth,
					fieldLabel: 'Виды работ',
				}),
				objs.FORMULA = Ext.create('Keysystems.Controls.Formula.Edit', {
					fieldLabel: 'Формула',
					maxLength: 500,
					enforceMaxLength: true,
					labelWidth: me.labelWidth
				}),
				objs.ERRMESS = Ext.create('Ext.form.field.TextArea', {
					fieldLabel: 'Сообщение об ошибке',
					labelWidth: me.labelWidth,
					maxLength: 1000,
					enforceMaxLength: true,
					height: 70
				}),
				objs.CRITICAL = Ext.create('Ext.form.field.Checkbox', {
					fieldLabel: 'Критическая ошибка',
					labelWidth: me.labelWidth
				})
			];

		me.isDHEdit = true;

		return me.callParent([items]);
	},
	dataCollector: function() {
		var me = this,
			objs = me.objs,
			data = me.callParent(arguments);
		data.FORMULA = objs.FORMULA.getValue();
		data.ERRMESS = objs.ERRMESS.getValue();
		data.CRITICAL = objs.CRITICAL.getValue();
		data.S_WORK = objs.S_WORK.getLinks(1);
		return data;
	},
	isFilled: function() {
		const me = this;
		let res = true;
		if (me.objs.S_WORK.isEmpty()) {
			me.addToInvalidControls(me.objs.S_WORK, {optional: true});
			me.warningMessages.push(KS.L10n.Не_заполнены_виды_работ);
		}
		return res;
	},
	autoFillControl: function(data) {
		var me = this,
			objs = me.objs;

		objs.FORMULA.setValue(data.FORMULA);
		objs.ERRMESS.setValue(data.ERRMESS);
		objs.CRITICAL.setValue(data.CRITICAL);

		return me.callParent(arguments);
	},
	getExtra: function(callBack, link) {
		var me = this;
		me.baseGetExtra({ link: link }, function(value) {
			me.autoFillControl(value.row);
			me.objs.S_WORK.setValue(value.S_WORK);
			if (callBack) callBack();
		});
	}
});