Ext.define('Keysystems.SCalc.List', {
	extend: 'Keysystems.Base.List.Tree',
	getGridCfg: function () {
		let me = this,
			res = me.callParent(arguments);
		if (!res.viewConfig.plugins) res.viewConfig.plugins = {};
		res.viewConfig.plugins['gridviewdragdrop'] = {};
		return res;
	},
	createGridListeners: function () {
		var me = this,
			objs = me.objs;

		me.callParent(arguments);
		objs.gridListeners.beforedrop = function (node, data, overModel, dropPosition, dropHandlers) {
			dropHandlers.wait = true;
			let target = dropPosition === 'before' ? overModel.previousSibling : overModel;
			selectDialogShow(wmc.get('Question'),
				wmc.getQuestion('MoveSCalc', data.records.length === 1 ? "показатель " : "показатели ", target.data.CODE ? 'с кодом \'' + target.data.CODE + '\'' : 'с наименованием \'' + target.data.NAME + '\''),
				function () {
					dropHandlers.processDrop();
					me.dragDrop(data.records.map(r => r.data.LINK), target.data.LINK, 'Reorder');
				},
				function () {
					dropHandlers.cancelDrop();
				}
			);
		};
	},
})