﻿Ext.define('Keysystems.SCalc.Edit', {
	extend: 'Keysystems.Base.Edit',
	profileListeners: [{ name: 'view', method: 'FormParam' }],
	viewCfg: function () {
		let cfg = this.callParent(arguments);
		cfg.resizable = true;
		cfg.maximizable = true;
		return cfg;
	},
	createItems: function() {
		var me = this,
			objs = me.objs,
			items = [
				me.sksc('TYPE', objs.TYPE = Ext.create('Keysystems.Controls.ComboBoxExtra', {
					fieldLabel: 'Тип',
					labelWidth: me.labelWidth,
					editable: false,
					store: Ext.create('Ext.data.Store', {
						fields: CBDataLib.getFields(),
						data: [],
						proxy: 'memory'
					}),
					queryMode: 'local',
					displayField: 'value',
					valueField: 'index',
					value: '...',
					maxWidth: me.labelWidth + 120,
					listeners: {
						load: function(store) { if (!store.isLoaded()) Ext.loadMask.Msg(); },
						change: function(newValue) {
							var val = newValue.getRawValue();
							var value = newValue.getValue();
							objs.AUTOPERSON.setDisabled((val !== 'Количество') && (val !== 'Сумма'));
							objs.FORMULA.setDisabled(!value && value !== 0);
						}
					}
				})),
				me.sksc('textTYPE', objs.textTYPE = Ext.create('Ext.form.field.Text', {
					fieldLabel: 'Тип',
					hidden: true,
					labelWidth: me.labelWidth,
				})),
				me.createDictEdit({
					key: 'S_WORK',
					ksAllowEmpty: true,
					code: dnl.S_WORK,
					fieldLabel: 'Виды работ'
				}),
				me.sksc('FORMULA', objs.FORMULA = Ext.create('Keysystems.Controls.Formula.Edit', {
					fieldLabel: 'Формула',
					maxLength: 500,
					enforceMaxLength: true,
					labelWidth: me.labelWidth,
					height: 100,
					flex: 1,
					userCls : 'rks-formula-edit',
					onTriggerClick: function() {
						var me1 = this,
							dh = objs.DH.getValue();
						me1.Current = objs.CODE.getValue().trim();
						me1.DH1 = dh.dh1;
						me1.DH2 = dh.dh2;
						me1.SWorkLinks = objs.S_WORK.getLinks();
						me1.execute();
					}
				})),
				me.sksc('LATER', objs.LATER = Ext.create('Ext.form.field.Checkbox', {
					fieldLabel: 'Можно вводить позже',
					labelWidth: me.labelWidth
				})),
				Ext.create('Ext.form.FieldContainer',{
					layout: {type: 'hbox', align: 'stretch'},
					padding: 0,
					bodyPadding: 0,
					items:[
						objs.AUTOPERSON = Ext.create('Keysystems.AutoPersonControl', {
							label: 'По участникам',
							labelWidth: me.labelWidth,
							comboWidth: 400,
							//stretch: true,
							flex: 1
						})
					]
				})

			];

		me.codeEditCfg = { allowBlank: true };
		me.isCodeEdit = true;
		me.codeEditCfg = { maxLength: 20, enforceMaxLength: true };
		me.isNameEdit = true;
		me.nameEditCfg = { maxLength: 500, enforceMaxLength: true };
		me.isDHEdit = true;

		return me.callParent([items]);
	}, /*
    createBtns: function () {
        var me = this,
            btns = [
                me.objs.RECALC = Ext.create('Ext.form.field.Checkbox', {
                    labelWidth: me.labelWidth,
                    fieldLabel: 'Пересчитывать',
                    hidden: true
                }),
                '->'
            ];
        me.callParent();
        me.objs.btns = btns.concat(me.objs.btns);
    },*/
	dataCollector: function() {
		var me = this,
			objs = me.objs,
			data = me.callParent(arguments);
		data.type = objs.TYPE.getValue();
		data.formula = objs.FORMULA.getValue();
		data.later = objs.LATER.getValue();
		data.AUTOPERSON = objs.AUTOPERSON.getValue();
		data.S_WORK = objs.S_WORK.getLinks(1);
		return data;
	},
	isFilled: function() {
		const me = this;
		let res = me.callParent(arguments);
		if (me.objs.S_WORK.isEmpty()) {
			me.addToInvalidControls(me.objs.S_WORK, {optional: true});
			me.warningMessages.push(KS.L10n.Не_заполнены_виды_работ);
		}
		return res;
	},	
	getExtra: function(endFunc, link) {
		var me = this,
			objs = me.objs;

		me.baseGetExtra({ link: link }, function(value) {
			me.autoFillControl(value.row);
			objs.S_WORK.setValue(value.S_WORK);			
			if (value.calcType) {
				objs.TYPE.store.loadData(value.calcType, false);
				objs.TYPE.setValue(value.row.TYPE);
			} else {
				objs.TYPE.setReadOnly(true);
			}			
			objs.AUTOPERSON.setValue(value.row.AUTOPERSON);
			objs.FORMULA.setValue(value.row.FORMULA);
			objs.LATER.setValue(value.row.LATER);
			objs.FORMULA.setDisabled(objs.TYPE.getRawValue() === '...');
			
			if (me.readOnly || (me.data && me.data.data.readOnly)) me.setReadOnly(true);
			if (endFunc) endFunc();
		});
	}
});