﻿Ext.define('Keysystems.SAuthority.Edit', {
	extend: 'Keysystems.Base.Edit',
	createItems: function() {
		var me = this,
			objs = me.objs;

		me.isCodeEdit = true;
		me.codeEditCfg = { maxLength: 10, enforceMaxLength: true };
		me.isNameEdit = true;
		me.nameEditCfg = { maxLength: 1000, enforceMaxLength: true };
		me.isDHEdit = true;
		me.dhEditCfg = { maxWidth: 400 };

		var items = me.callParent();

		items.push(objs.IDENTIFIER = Ext.create('Ext.form.field.Text',
			{
				labelWidth: me.labelWidth,
				maxWidth: 300,
				fieldLabel: 'Идентификатор'
			})
		);

		return items;
	},

	dataCollector: function() {
		var me = this,
			objs = me.objs;

		data = me.callParent([false]);

		data.IDENTIFIER = objs.IDENTIFIER.getValue();

		return data;
	},

	getExtra: function(callBack, link) {
		var me = this;
		me.baseGetExtra({ link: link }, function(value) {

			me.autoFillControl(value.row);
			me.setFullObjsAccess(value.isIdentifierAccess, ['IDENTIFIER']);

			if (callBack) callBack();
		});
	}
});