﻿Ext.define('Keysystems.SArticle.Edit', {
	extend: 'Keysystems.Base.Edit',

	getExtra: function (callBack, link) {
		var me = this;

		me.baseGetExtra({ link: link },
			function(value) {
				me.autoFillControl(value.row);
				me.objs.S_NPA.setValue(value.S_NPA);
				me.gksc('BTN_REF').setValue(value.row.REF);
				if (callBack) callBack();
			});
	},

	createItems: function() {
		var me = this,
			objs = me.objs,
			baseItems = me.callParent(),
			items = [
				objs.PNL = Ext.create('Ext.panel.Panel',
					{
						layout: { type: 'hbox', align: 'stretch' },
						border: 0,
						padding: '0 0 5 0',
						items: [
							objs.CODE,
							'->',
							me.sksc('BTN_REF', Ext.create('Keysystems.RefDropDown', {}))
						]
					})
			];

		var result = baseItems.slice();
		var posCode = result.indexOf(objs.CODE);
		if (posCode !== -1) result.splice(posCode, 1);

		result.splice(result.indexOf(objs.NAME), 0, objs.PNL);
		return result;
	},

	dataCollector: function () {
		var me = this,
			data = me.callParent(arguments);

		data.REF = me.gksc('BTN_REF').getValue();
		return data;
	}

});