﻿Ext.define('Keysystems.SAdr.Edit', {
	extend: 'Keysystems.Base.Edit',
	mKladrCode: ['REGION', 'RAYON', 'CITY', 'NPUNKT', 'STREET', 'INDEX'],
	allKladrCode: ['REGION', 'RAYON', 'CITY', 'NPUNKT', 'STREET', 'INDEX', 'HOUSE', 'CORP', 'FLAT', 'ADDTEXT'],
	fiasColumns: ["POSTAL_CODE", "REGION_KLADR", "REGION_CODE", "REGION_TYPE", "REGION_NAME", "AREA_KLADR", "AREA_TYPE", "AREA_NAME", "CITY_KLADR", "CITY_TYPE", "CITY_NAME", "PLACE_KLADR", "PLACE_TYPE", "PLACE_NAME", "STREET_KLADR", "STREET_TYPE", "CITY_NAME", "STREET_NAME", "HOUSE_NUM", "HOUSE_ADDNUM1", "HOUSE_ADDNUM2", "HOUSE_TYPE", "HOUSE_ADDTYPE1", "HOUSE_ADDTYPE2", "HOUSE_CADNUM", "APARTAMENT_NUMBER", "APARTAMENT_TYPE", "APARTAMENT_CADNUM"],
	hideEdit: { new: true, same: true, edit: true, delete: true },
	createItems: function () {
		var me = this,
			objs = me.objs;

		return objs.items = [me.getTab('General'), me.getTab('Fias')];
	},
	createTabGeneral: function () {
		var me = this,
			objs = me.objs;

		return objs.tabGeneral = Ext.create('Ext.panel.Panel',
			{
				layout: { type: 'vbox', align: 'stretch' },
				flex: 1,
				border: 0,
				items: [
					objs.ADRES = Ext.create('Ext.form.field.Text',
						{
							fieldLabel: 'Адрес',
							listeners: { blur: function () { me.setAdress(this.getValue()); } },
							labelWidth: me.labelWidth,
							width: me.width
						}),
					objs.S_OKSM = Ext.create('Keysystems.Controls.Dict.Edit',
						{
							labelWidth: me.labelWidth,
							fieldLabel: 'Страна',
							width: me.width,
							handler: function() {
								dictFunc({
									mode: 'SINGL',
									parentView: objs.view,
									selectLinks: objs.S_OKSM.getValue(),
									code: dnl.S_OKSM, 
									readOnly: objs.S_OKSM.readOnly,
									control: objs.S_OKSM,
									contextSearch: objs.S_OKSM.contextSearch
								},
									{
										ok: function (value) {
											objs.S_OKSM.setValue(value);
											if (!objs.S_OKSM.getValue().length) {
												objs.REGION.setDisabled(true);
												objs.RAYON.setDisabled(true);
												objs.CITY.setDisabled(true);
												objs.NPUNKT.setDisabled(true);
												objs.STREET.setDisabled(true);
												objs.INDEX.setDisabled(true);
												objs.REGION.setValue();
												objs.RAYON.setValue();
												objs.CITY.setValue();
												objs.NPUNKT.setValue();
												objs.STREET.setValue();
												objs.INDEX.setValue();
											} else {
												objs.REGION.setDisabled(false);
											}
										}
									});
							}
						}),
					objs.REGION = Ext.create('Keysystems.Controls.DictName.Edit',
						{
							labelWidth: me.labelWidth,
							fieldLabel: 'Регион',
							width: me.width,
							code: dnl.S_KLADR_REGION,
							visibleFields: "NAME SOCR",
							cleaningKey: false,
							handler: function () {
								dictFunc({
									mode: 'SINGL',
									parentView: objs.view, 
									accessReadOnly: true, 
									readOnly: objs.REGION.readOnly,
									selectLinks: objs.REGION.getValue(),
									whereArgs: { SOKSM: { value: objs.S_OKSM.getLink(), type: 'int' } },
									code: dnl.S_KLADR_REGION
								},
									{
										ok: function (value) {
											objs.REGION.setValue(value);
											if (!objs.REGION.getValue().length) {
												objs.RAYON.setDisabled(true);
												objs.CITY.setDisabled(true);
												objs.NPUNKT.setDisabled(true);
												objs.STREET.setDisabled(true);
												me.setValueAdres('REGION');
											} else {
												objs.RAYON.setDisabled(false);
												objs.CITY.setDisabled(false);
												objs.NPUNKT.setDisabled(false);
												objs.STREET.setDisabled(false);
											}
											me.getAdres();
										}
									});
							}
						}),
					objs.RAYON = Ext.create('Keysystems.Controls.DictName.Edit',
						{
							labelWidth: me.labelWidth,
							fieldLabel: 'Район',
							width: me.width,
							code: dnl.S_KLADR_RAYON,
							visibleFields: "NAME SOCR",
							cleaningKey: false,
							handler: function () {
								var parentCode = objs.REGION.getValue()[0];
								parentCode = parentCode ? (parentCode.data || parentCode).CODE : '';

								dictFunc({
									mode: 'SINGL',
									parentView: objs.view,
									selectLinks: objs.RAYON.getValue(),
									accessReadOnly: true,
									readOnly: objs.RAYON.readOnly,
									whereArgs: {
										ParentCode: { value: parentCode, type: 'string' },
										LinkSelf: { value: objs.REGION.getLink(), type: 'int' }
									},
									code: dnl.S_KLADR_RAYON
								},
									{
										ok: function (value) {
											objs.RAYON.setValue(value);
											objs.RAYON.fieldName.setFieldStyle('color:black');
											if (!objs.RAYON.getValue().length) {
												me.setValueAdres('RAYON');
											};
											me.getAdres();
										}
									});
							}
						}),
					objs.CITY = Ext.create('Keysystems.Controls.DictName.Edit',
						{
							labelWidth: me.labelWidth,
							fieldLabel: 'Город',
							width: me.width,
							code: dnl.S_KLADR_CITY,
							cleaningKey: false,
							handler: function () {
								var linkSelf = objs.RAYON.getLink() || objs.REGION.getLink(),
									parentCode =
										(objs.RAYON.isEmpty() ? objs.REGION.getValue() : objs.RAYON.getValue())[0];
								parentCode = parentCode ? (parentCode.data || parentCode).CODE : '';

								dictFunc({
										mode: 'SINGL',
										parentView: objs.view,
										selectLinks: objs.CITY.getValue(),
										accessReadOnly: true,
										readOnly: objs.CITY.readOnly,
										whereArgs: {
											ParentCode: {value: parentCode, type: 'string'},
											LinkSelf: {value: linkSelf, type: 'int'}
										},
										code: dnl.S_KLADR_CITY
									},
									{
										ok: function (value) {
											objs.CITY.setValue(value);
											objs.CITY.fieldName.setFieldStyle('color:black');
											if (!objs.CITY.getValue().length) {
												me.setValueAdres('CITY');
											};
											me.getAdres();
										}
									});
							}
						}),
					objs.NPUNKT = Ext.create('Keysystems.Controls.DictName.Edit',
						{
							labelWidth: me.labelWidth,
							fieldLabel: 'Населенный пункт',
							width: me.width,
							code: dnl.S_KLADR_NPUNKT,
							cleaningKey: false,
							handler: function () {
								var linkSelf = objs.CITY.getLink() || objs.RAYON.getLink() || objs.REGION.getLink(),
									parentCode =
										(objs.CITY.isEmpty() ? objs.RAYON.getValue() : objs.CITY.getValue())[0];
								parentCode = parentCode ? (parentCode.data || parentCode).CODE : '';

								dictFunc({
									mode: 'SINGL',
									parentView: objs.view,
									accessReadOnly: true,
									readOnly: objs.NPUNKT.readOnly,
									selectLinks: objs.NPUNKT.getValue(),
									whereArgs: {
										ParentCode: { value: parentCode, type: 'string' },
										LinkSelf: { value: linkSelf, type: 'int' }
									},
									code: dnl.S_KLADR_NPUNKT
								},
									{
										ok: function (value) {
											objs.NPUNKT.setValue(value);
											objs.NPUNKT.fieldName.setFieldStyle('color:black');
											if (!objs.NPUNKT.getValue().length) {
												me.setValueAdres('NPUNKT');
											};
											me.getAdres();
										}
									});
							}
						}),
					objs.STREET = Ext.create('Keysystems.Controls.DictName.Edit',
						{
							labelWidth: me.labelWidth,
							fieldLabel: 'Улица',
							width: me.width,
							code: dnl.S_KLADR_STREET,
							cleaningKey: false,
							handler: function () {
								var linkSelf = objs.NPUNKT.getLink() || objs.CITY.getLink() || objs.REGION.getLink(),
									parentCode = (objs.NPUNKT.isEmpty()
										? objs.CITY.isEmpty()
											? objs.REGION.getValue()
											: objs.CITY.getValue()
										: objs.NPUNKT.getValue())[0];
								parentCode = parentCode ? (parentCode.data || parentCode).CODE : '';

								dictFunc({
									mode: 'SINGL',
									parentView: objs.view,
									accessReadOnly: true,
									readOnly: objs.STREET.readOnly,
									selectLinks: objs.STREET.getValue(),
									whereArgs: {
										ParentCode: { value: parentCode, type: 'string' },
										LinkSelf: { value: linkSelf, type: 'int' }
									},
									code: dnl.S_KLADR_STREET
								},
									{
										ok: function (value) {
											objs.STREET.setValue(value);
											objs.INDEX.setDisabled(!objs.STREET.getLink());
                                            /*if (objs.STREET.isEmpty()) {
                                                        objs.INDEX.setDisabled(true);
                                                        objs.INDEX.setValue();
                                                    } else {
                                                        objs.INDEX.setDisabled(false);
                                                    };*/
											if (!objs.STREET.getValue().length) {
												me.setValueAdres('STREET');
											};
											me.getAdres();
											me.getStreet();
											objs.STREET.fieldName.setFieldStyle('color:black');
										}
									});
							}
						}),
					objs.INDEX = Ext.create('Keysystems.Controls.DictName.Edit',
						{
							labelWidth: me.labelWidth,
							fieldLabel: 'Индекс',
							width: me.width,
							code: dnl.S_KLADR_INDEX,
							visibleFields: "P_INDEX",
							cleaningKey: false,
							handler: function () {
								var linkSelf = objs.STREET.getLink() || objs.NPUNKT.getLink(),
									parentCode = (objs.STREET.isEmpty()
										? objs.NPUNKT.getValue()
										: objs.STREET.getValue())[0];
								parentCode = parentCode ? (parentCode.data || parentCode).CODE : '';

								dictFunc({
									mode: 'SINGL',
									parentView: objs.view,
									accessReadOnly: true,
									readOnly: objs.INDEX.readOnly,
									selectLinks: objs.INDEX.getValue(),
									whereArgs: {
										ParentCode: { value: parentCode, type: 'string' },
										LinkSelf: { value: linkSelf, type: 'int' },
										OrInLinks: { value: objs.STREET.getLinks(1), type: 'List_int' }
									},
									code: dnl.S_KLADR_INDEX
								},
									{
										ok: function (value) {
											objs.INDEX.setValue(value);
											me.getAdres();
											objs.INDEX.fieldName.setFieldStyle('color:black');
										}
									});
							}
						}),
					objs.HOUSE = Ext.create('Ext.form.field.Text',
						{
							labelWidth: me.labelWidth,
							maxLength: 20,
							enforceMaxLength: true,
							fieldLabel: 'Дом',
							listeners: {
								change: function () {
									me.getAdres();
								}
							}
						}),
					objs.CORP = Ext.create('Ext.form.field.Text',
						{
							labelWidth: me.labelWidth,
							fieldLabel: 'Корпус',
							maxLength: 20,
							enforceMaxLength: true,
							listeners: {
								change: function () {
									me.getAdres();
								}
							}
						}),
					objs.FLAT = Ext.create('Ext.form.field.Text',
						{
							labelWidth: me.labelWidth,
							fieldLabel: 'Квартира',
							maxLength: 20,
							enforceMaxLength: true,
							listeners: {
								change: function () {
									me.getAdres();
								}
							}
						}),
					objs.ADDTEXT = Ext.create('Ext.form.field.ComboBox',
						{
							labelWidth: me.labelWidth,
							width: me.width,
							maxLength: 250,
							enforceMaxLength: true,
							fieldLabel: 'Дополнительно',
							store: [],
							listeners: {
								blur: function () {
									me.getAdres();
								}
							}
						})
				]

			});
	},
	createTabFias: function () {
		var me = this,
			objs = me.objs;
		return objs.tabFias = Ext.create('Ext.panel.Panel',
			{
				layout: { type: 'vbox', align: 'stretch' },
				flex: 1,
				border: 0,
				items: [
					objs.ADDRESS = Ext.create('Ext.form.field.ComboBox', {
						fieldLabel: 'Адрес',
						emptyText: 'Введите адрес',
						labelWidth: me.labelWidth,
						maxLength: 2000,
						width: me.width,
						enforceMaxLength: true,
						store: Ext.create('Ext.data.Store', {
							fields: [{ name: 'value', type: 'string' }],
							data: [],
							proxy: 'memory'
						}),
						queryMode: 'remote',
						displayField: 'FullName',
						valueField: 'ObjectId',
						hideTrigger: true,
						level: 0,
						enableKeyEvents: true,
						listeners: {
							change: function(th, val) {
								var v = val ? val : "";
								if (th.isPressChange){
									// запускаем поиск, если ввели больше 3ех символов
									if (v && v.length > 3) {
										if (v.slice(-1) === " " || v.slice(-1) === "," ) return;
										me.searchAddress(v.trim());
									}
									else{
										me.ksData.storeAdr = {};
										th.storeData = _;
									}
									th.isPressChange = false;
								}
							},
							keyup: function (th, e, eOpts){
								th.isPressChange = true;
							},
							keypress: function (th, e, eOpts){
								if (e.getChar() === "," || e.getChar() === " "){
									if (th.storeData && th.storeData.length){
										me.ksData.storeAdr[th.getValue()] = th.storeData;
									}
								}
							},
							select: function (th, rec, e){
								me.ksData.storeAdr = {};
								me.ksData.storeAdr[rec.data.FullName] = [rec.data];
								if (rec.data.Parents){
									rec.data.Parents.forEach(r=>{
										me.ksData.storeAdr[r.FullName] = [r];
									});
								}

								// заполнить элементы адреса
								me.setAddressElements(rec.data);
							}
						}
					}),
					// objs.ADDRESS = Ext.create('Ext.form.field.Text',
					// 	{
					// 		fieldLabel: 'Адрес',
					// 		labelWidth: me.labelWidth,
					// 		width: me.width,
					// 		disabled: true
					// 	}),
					objs.POSTAL_CODE = Ext.create('Ext.form.field.Text',
						{
							fieldLabel: 'Почтовый индекс',
							listeners: {
								blur: function () {
									me.getAdresFias();
								}
							},
							labelWidth: me.labelWidth,
							maxWidth: 350
						}),
					[
						objs.TEMP_ADRES = Ext.create('Ext.form.field.Text',
							{
								fieldLabel: 'Адрес по КЛАДР',
								disabled: true,
								labelWidth: me.labelWidth,
								width: me.width - 25
							}),
						objs.btnStartConvert = Ext.create('Ext.Button', {
							iconCls: 'x_btn_load_data',
							tooltipType: 'title',
							handler: function () {
								me.convertAdres();
							}
						})
					],
					objs.tabFias = Ext.create('Ext.tab.Panel',
						{
							border: 0,
							userCls: 'rks-panel-edit',
							bodyCls: 'rks-panel-edit-body-with-padding',
							items: [
								objs.tabFiasRegion = Ext.create('Ext.panel.Panel',
									{
										title: 'Субъект',
										flex: 1,
										bodyPadding: 10,
										layout: { type: 'vbox', align: 'stretch' },
										items: [
											me.createDictEdit({
												key: 'S_FIASREGION',
												mode: 'SINGL',
												code: dnl.S_FIASREGION,
												labelWidth: me.labelWidth,
												fieldLabel: 'Регион',
												className: 'Keysystems.Controls.DictName.Edit',
												cleaningKey: false,
												ksSetValue: function (value) {
													if (value && value.length) {
														value = value[0].data;
														me.clearElements(dnl.S_FIASREGION);
														me.sksd('REGION_AOGUID', value.AOGUID);
														me.sksd('REGION_OBJECTID', value.OBJECTID);
														objs.REGION_CODE.setValue(value.OBJECTCODE);
														objs.REGION_KLADR.setValue(value.CODE);
														objs.REGION_NAME.setValue(value.OFFNAME);
														objs.REGION_TYPE.setValue(value.SHORTNAME);
														me.getAdresFias();
														me.setEnableBtnConvert();
													}
												}
											},
												function (o) {
													o.handler = [
														{
															handler: function () { 
																if (objs.S_FIASREGION.readOnly) return;
																me.clearElements(dnl.S_FIASREGION);
																me.getAdresFias();
																me.setEnableBtnConvert();
															},
															cls: 'x-dict-trigger x_btn_clean'
														},
														o.handler
													];
													return o;
												}),
											objs.REGION_KLADR = Ext.create('Ext.form.field.Text',
												{
													fieldLabel: 'Код субъекта по КЛАДР',
													labelWidth: me.labelWidth,
													maxWidth: 350
												}),
											objs.REGION_CODE = Ext.create('Ext.form.field.Text',
												{
													fieldLabel: 'Код субъекта',
													labelWidth: me.labelWidth,
													maxWidth: 350
												}),
											objs.REGION_TYPE = Ext.create('Keysystems.Controls.ComboBoxExtra',
												{
													labelWidth: me.labelWidth,
													fieldLabel: 'Тип субъекта',
													value: null,
													editable: false,
													store: Ext.create('Ext.data.Store',
														{
															fields: CBDataLib.getFields(),
															data: [],
															proxy: 'memory'
														}),
													queryMode: 'local',
													displayField: CBDataLib.displayField,
													valueField: CBDataLib.displayField,
													maxWidth: 350,
													listeners: {
														blur: function () {
															me.getAdresFias();
														}
													}
												}),
											objs.REGION_NAME = Ext.create('Ext.form.field.Text',
												{
													fieldLabel: 'Наименование субъекта',
													labelWidth: me.labelWidth,
													width: me.width,
													listeners: {
														blur: function () {
															me.getAdresFias();
															me.setEnableBtnConvert();
														}
													}
												})
										]
									}),
								objs.tabFiasArea = Ext.create('Ext.panel.Panel',
									{
										title: 'Район',
										flex: 1,
										bodyPadding: 10,
										layout: { type: 'vbox', align: 'stretch' },
										items: [
											me.createDictEdit({
												key: 'S_FIASAREA',
												mode: 'SINGL',
												code: dnl.S_FIASAREA,
												labelWidth: me.labelWidth,
												fieldLabel: 'Район',
												className: 'Keysystems.Controls.DictName.Edit',
												cleaningKey: false,
												initWhereArgs: function () {
													return {
														ParentGuid: { value: me.gksd('REGION_AOGUID'), type: 'string' }
													}
												},
												ksSetValue: function (value) {
													if (value && value.length) {
														value = value[0].data;
														me.clearElements(dnl.S_FIASAREA)
														me.sksd('AREA_AOGUID', value.AOGUID);
														me.sksd('AREA_OBJECTID', value.OBJECTID);
														objs.AREA_KLADR.setValue(value.CODE);
														objs.AREA_NAME.setValue(value.OFFNAME);
														objs.AREA_TYPE.setValue(value.SHORTNAME);
														me.getAdresFias();
													}
												}
											},
												function (o) {
													o.handler = [
														{
															handler: function () {
																if (objs.S_FIASAREA.readOnly) return;
																me.clearElements(dnl.S_FIASAREA);
																me.getAdresFias();
															},
															cls: 'x-dict-trigger x_btn_clean'
														},
														o.handler
													];
													return o;
												}),
											objs.AREA_KLADR = Ext.create('Ext.form.field.Text',
												{
													fieldLabel: 'Код района по КЛАДР',
													labelWidth: me.labelWidth,
													maxWidth: 350
												}),
											objs.AREA_TYPE = Ext.create('Keysystems.Controls.ComboBoxExtra',
												{
													labelWidth: me.labelWidth,
													fieldLabel: 'Тип района',
													value: null,
													editable: false,
													store: Ext.create('Ext.data.Store',
														{
															fields: CBDataLib.getFields(),
															data: [],
															proxy: 'memory'
														}),
													queryMode: 'local',
													displayField: CBDataLib.displayField,
													valueField: CBDataLib.displayField,
													maxWidth: 350,
													listeners: {
														blur: function () {
															me.getAdresFias();
														}
													}
												}),
											objs.AREA_NAME = Ext.create('Ext.form.field.Text',
												{
													fieldLabel: 'Наименование района',
													labelWidth: me.labelWidth,
													width: me.width,
													listeners: {
														blur: function () {
															me.getAdresFias();
														}
													}
												})
										]
									}),
								objs.tabFiasCity = Ext.create('Ext.panel.Panel',
									{
										title: 'Город',
										flex: 1,
										bodyPadding: 10,
										layout: { type: 'vbox', align: 'stretch' },
										items: [
											me.createDictEdit({
												key: 'S_FIASCITY',
												mode: 'SINGL',
												code: dnl.S_FIASCITY,
												labelWidth: me.labelWidth,
												fieldLabel: 'Город',
												className: 'Keysystems.Controls.DictName.Edit',
												cleaningKey: false,
												initWhereArgs: function () {
													return {
														ParentGuid: {
															value: me.gksd('AREA_AOGUID')
																? me.gksd('AREA_AOGUID')
																: me.gksd('REGION_AOGUID'),
															type: 'string'
														}
													}
												},
												ksSetValue: function (value) {
													if (value && value.length) {
														value = value[0].data;
														me.clearElements(dnl.S_FIASCITY)
														me.sksd('CITY_AOGUID', value.AOGUID);
														me.sksd('CITY_OBJECTID', value.OBJECTID);
														objs.CITY_KLADR.setValue(value.CODE);
														objs.CITY_NAME.setValue(value.OFFNAME);
														objs.CITY_TYPE.setValue(value.SHORTNAME);
														me.getAdresFias();
													}
												}
											},
												function (o) {
													o.handler = [
														{
															handler: function () {
																if (objs.S_FIASCITY.readOnly) return;
																me.clearElements(dnl.S_FIASCITY);
																me.getAdresFias();
															},
															cls: 'x-dict-trigger x_btn_clean'
														},
														o.handler
													];
													return o;
												}),
											objs.CITY_KLADR = Ext.create('Ext.form.field.Text',
												{
													fieldLabel: 'Код города по КЛАДР',
													labelWidth: me.labelWidth,
													maxWidth: 350
												}),
											objs.CITY_TYPE = Ext.create('Keysystems.Controls.ComboBoxExtra',
												{
													labelWidth: me.labelWidth,
													fieldLabel: 'Тип города',
													value: null,
													editable: false,
													store: Ext.create('Ext.data.Store',
														{
															fields: CBDataLib.getFields(),
															data: [],
															proxy: 'memory'
														}),
													queryMode: 'local',
													displayField: CBDataLib.displayField,
													valueField: CBDataLib.displayField,
													maxWidth: 350,
													listeners: {
														blur: function () {
															me.getAdresFias();
														}
													}
												}),
											objs.CITY_NAME = Ext.create('Ext.form.field.Text',
												{
													fieldLabel: 'Наименование города',
													labelWidth: me.labelWidth,
													width: me.width,
													listeners: {
														blur: function () {
															me.getAdresFias();
														}
													}
												})
										]
									}),
								objs.tabFiasPlace = Ext.create('Ext.panel.Panel',
									{
										title: 'Населенный пункт',
										flex: 1,
										bodyPadding: 10,
										layout: { type: 'vbox', align: 'stretch' },
										items: [
											me.createDictEdit({
												key: 'S_FIASPLACE',
												mode: 'SINGL',
												code: dnl.S_FIASPLACE,
												labelWidth: me.labelWidth,
												fieldLabel: 'Населенный пункт',
												className: 'Keysystems.Controls.DictName.Edit',
												cleaningKey: false,
												initWhereArgs: function () {
													return {
														ParentGuid: {
															value: me.gksd('CITY_AOGUID')
																? me.gksd('CITY_AOGUID')
																: me.gksd('AREA_AOGUID')
																	? me.gksd('AREA_AOGUID')
																	: me.gksd('REGION_AOGUID'),
															type: 'string'
														}
													}
												},
												ksSetValue: function (value) {
													if (value && value.length) {
														value = value[0].data;
														me.clearElements(dnl.S_FIASPLACE)
														me.sksd('PLACE_AOGUID', value.AOGUID);
														me.sksd('PLACE_OBJECTID', value.OBJECTID);
														objs.PLACE_KLADR.setValue(value.CODE);
														objs.PLACE_NAME.setValue(value.OFFNAME);
														objs.PLACE_TYPE.setValue(value.SHORTNAME);
														me.getAdresFias();
													}
												}
											},
												function (o) {
													o.handler = [
														{
															handler: function () {
																if (objs.S_FIASPLACE.readOnly) return;
																me.clearElements(dnl.S_FIASPLACE);
																me.getAdresFias();
															},
															cls: 'x-dict-trigger x_btn_clean'
														},
														o.handler
													];
													return o;
												}),
											objs.PLACE_KLADR = Ext.create('Ext.form.field.Text',
												{
													fieldLabel: 'Код населенного пункта по КЛАДР',
													labelWidth: me.labelWidth,
													maxWidth: 350
												}),
											objs.PLACE_TYPE = Ext.create('Keysystems.Controls.ComboBoxExtra',
												{
													labelWidth: me.labelWidth,
													fieldLabel: 'Тип населенного пункта',
													value: null,
													editable: false,
													store: Ext.create('Ext.data.Store',
														{
															fields: CBDataLib.getFields(),
															data: [],
															proxy: 'memory'
														}),
													queryMode: 'local',
													displayField: CBDataLib.displayField,
													valueField: CBDataLib.displayField,
													maxWidth: 350,
													listeners: {
														blur: function () {
															me.getAdresFias();
														}
													}
												}),
											objs.PLACE_NAME = Ext.create('Ext.form.field.Text',
												{
													fieldLabel: 'Наименование населенного пункта',
													labelWidth: me.labelWidth,
													width: me.width,
													listeners: {
														blur: function () {
															me.getAdresFias();
														}
													}
												})
										]
									}),
								objs.tabFiasStreet = Ext.create('Ext.panel.Panel',
									{
										title: 'Улица',
										flex: 1,
										bodyPadding: 10,
										layout: { type: 'vbox', align: 'stretch' },
										items: [
											me.createDictEdit({
												key: 'S_FIASSTREET',
												mode: 'SINGL',
												code: dnl.S_FIASSTREET,
												labelWidth: me.labelWidth,
												fieldLabel: 'Улица',
												className: 'Keysystems.Controls.DictName.Edit',
												cleaningKey: false,
												initWhereArgs: function () {
													return {
														ParentGuid: {
															value: me.gksd('PLACE_AOGUID')
																? me.gksd('PLACE_AOGUID')
																: me.gksd('CITY_AOGUID')
																	? me.gksd('CITY_AOGUID')
																	: me.gksd('AREA_AOGUID')
																		? me.gksd('AREA_AOGUID')
																		: me.gksd('REGION_AOGUID'),
															type: 'string'
														}
													}
												},
												ksSetValue: function (value) {
													if (value && value.length) {
														value = value[0].data;
														me.clearElements(dnl.S_FIASSTREET)
														me.sksd('STREET_AOGUID', value.AOGUID);
														me.sksd('STREET_OBJECTID', value.OBJECTID);
														objs.STREET_KLADR.setValue(value.CODE);
														objs.STREET_NAME.setValue(value.OFFNAME);
														objs.STREET_TYPE.setValue(value.SHORTNAME);
														me.getAdresFias();
													}
												}
											},
												function (o) {
													o.handler = [
														{
															handler: function () {
																if (objs.S_FIASSTREET.readOnly) return;
																me.clearElements(dnl.S_FIASSTREET);
																me.getAdresFias();
															},
															cls: 'x-dict-trigger x_btn_clean'
														},
														o.handler
													];
													return o;
												}),
											objs.STREET_KLADR = Ext.create('Ext.form.field.Text',
												{
													fieldLabel: 'Код улицы по КЛАДР',
													labelWidth: me.labelWidth,
													maxWidth: 350
												}),
											objs.STREET_TYPE = Ext.create('Keysystems.Controls.ComboBoxExtra',
												{
													labelWidth: me.labelWidth,
													fieldLabel: 'Тип улицы',
													value: null,
													editable: false,
													store: Ext.create('Ext.data.Store',
														{
															fields: CBDataLib.getFields(),
															data: [],
															proxy: 'memory'
														}),
													queryMode: 'local',
													displayField: CBDataLib.displayField,
													valueField: CBDataLib.displayField,
													maxWidth: 350,
													listeners: {
														blur: function () {
															me.getAdresFias();
														}
													}
												}),
											objs.STREET_NAME = Ext.create('Ext.form.field.Text',
												{
													fieldLabel: 'Наименование улицы',
													labelWidth: me.labelWidth,
													width: me.width,
													listeners: {
														blur: function () {
															me.getAdresFias();
														}
													}
												})
										]
									}),
								objs.tabFiasHouse = Ext.create('Ext.panel.Panel',
									{
										title: 'Дом',
										flex: 1,
										bodyPadding: 10,
										layout: { type: 'vbox', align: 'stretch' },
										items: [
											me.createDictEdit({
												key: 'S_FIASHOUSE',
												mode: 'SINGL',
												code: dnl.S_FIASHOUSE,
												labelWidth: me.labelWidth,
												fieldLabel: 'Дом',
												className: 'Keysystems.Controls.DictName.Edit',
												cleaningKey: false,
												initWhereArgs: function () {
													return {
														ParentGuid: {
															value: me.gksd('STREET_AOGUID')
																? me.gksd('STREET_AOGUID')
																: me.gksd('PLACE_AOGUID')
																	? me.gksd('PLACE_AOGUID')
																	: me.gksd('CITY_AOGUID')
																		? me.gksd('CITY_AOGUID')
																		: me.gksd('AREA_AOGUID')
																			? me.gksd('AREA_AOGUID')
																			: me.gksd('REGION_AOGUID'),
															type: 'string'
														}
													}
												},
												ksSetValue: function (value) {
													if (value && value.length) {
														value = value[0].data;
														me.clearElements(dnl.S_FIASHOUSE)
														me.sksd('HOUSE_AOGUID', value.AOGUID);
														me.sksd('HOUSE_OBJECTID', value.OBJECTID);
														objs.HOUSE_NUM.setValue(value.HOUSENUM);
														objs.HOUSE_ADDNUM1.setValue(value.ADDNUM1);
														objs.HOUSE_ADDNUM2.setValue(value.ADDNUM2);
														if (value.TYPEID !== 0)
															objs.HOUSE_TYPE.setValue(value.TYPEID);
														if (value.ADDTYPE1ID !== 0)
															objs.HOUSE_ADDTYPE1.setValue(value.ADDTYPE1ID);
														if (value.ADDTYPE2ID !== 0)
															objs.HOUSE_ADDTYPE2.setValue(value.ADDTYPE2ID);
														objs.HOUSE_CADNUM.setValue(value.CADNUM);
														me.getAdresFias();
													}
												}
											},
												function (o) {
													o.handler = [
														{
															handler: function () {
																if (objs.S_FIASHOUSE.readOnly) return;
																me.clearElements(dnl.S_FIASHOUSE);
																me.getAdresFias();
															},
															cls: 'x-dict-trigger x_btn_clean'
														},
														o.handler
													];
													return o;
												}),
											objs.HOUSE_NUM = Ext.create('Ext.form.field.Text',
												{
													fieldLabel: 'Основной номер дома',
													labelWidth: me.labelWidth,
													maxWidth: 350,
													listeners: {
														blur: function () {
															me.getAdresFias();
														}
													}
												}),
											objs.HOUSE_ADDNUM1 = Ext.create('Ext.form.field.Text',
												{
													fieldLabel: 'Дополнительный номер дома 1',
													labelWidth: me.labelWidth,
													maxWidth: 350,
													listeners: {
														blur: function () {
															me.getAdresFias();
														}
													}
												}),
											objs.HOUSE_ADDNUM2 = Ext.create('Ext.form.field.Text',
												{
													fieldLabel: 'Дополнительный номер дома 2',
													labelWidth: me.labelWidth,
													maxWidth: 350,
													listeners: {
														blur: function () {
															me.getAdresFias();
														}
													}
												}),
											objs.HOUSE_TYPE = Ext.create('Keysystems.Controls.ComboBoxExtra',
												{
													labelWidth: me.labelWidth,
													fieldLabel: 'Основной тип дома',
													editable: false,
													store: Ext.create('Ext.data.Store',
														{
															fields: CBDataLib.getFields(),
															data: [],
															proxy: 'memory'
														}),
													queryMode: 'local',
													displayField: 'value',
													valueField: 'index',
													maxWidth: 350,
													listeners: {
														blur: function () {
															me.getAdresFias();
														}
													}
												}),
											objs.HOUSE_ADDTYPE1 = Ext.create('Keysystems.Controls.ComboBoxExtra',
												{
													labelWidth: me.labelWidth,
													fieldLabel: 'Дополнительный номер дома 1',
													value: null,
													editable: false,
													store: Ext.create('Ext.data.Store',
														{
															fields: CBDataLib.getFields(),
															data: [],
															proxy: 'memory'
														}),
													queryMode: 'local',
													displayField: CBDataLib.displayField,
													valueField: CBDataLib.valueField,
													maxWidth: 350,
													listeners: {
														blur: function () {
															me.getAdresFias();
														}
													}
												}),
											objs.HOUSE_ADDTYPE2 = Ext.create('Keysystems.Controls.ComboBoxExtra',
												{
													labelWidth: me.labelWidth,
													fieldLabel: 'Дополнительный номер дома 2',
													value: null,
													editable: false,
													store: Ext.create('Ext.data.Store',
														{
															fields: CBDataLib.getFields(),
															data: [],
															proxy: 'memory'
														}),
													queryMode: 'local',
													displayField: CBDataLib.displayField,
													valueField: CBDataLib.valueField,
													maxWidth: 350,
													listeners: {
														blur: function () {
															me.getAdresFias();
														}
													}
												}),
											objs.HOUSE_CADNUM = Ext.create('Ext.form.field.Text',
												{
													fieldLabel: 'Кадастровый номер',
													labelWidth: me.labelWidth,
													width: me.width
												})
										]
									}),
								objs.tabFiasRoom = Ext.create('Ext.panel.Panel',
									{
										title: 'Помещение',
										flex: 1,
										bodyPadding: 10,
										layout: { type: 'vbox', align: 'stretch' },
										items: [
											me.createDictEdit({
												key: 'S_FIASROOM',
												mode: 'SINGL',
												code: dnl.S_FIASROOM,
												labelWidth: me.labelWidth,
												fieldLabel: 'Помещение',
												className: 'Keysystems.Controls.DictName.Edit', 
												cleaningKey: false,
												initWhereArgs: function () {
													return {
														ParentGuid: {
															value: me.gksd('HOUSE_AOGUID'),
															type: 'string'
														}
													}
												},
												ksSetValue: function (value) {
													if (value && value.length) {
														value = value[0].data;
														me.clearElements(dnl.S_FIASROOM)
														me.sksd('APARTAMENT_AOGUID', value.AOGUID);
														me.sksd('APARTAMENT_OBJECTID', value.OBJECTID);
														objs.APARTAMENT_NUMBER.setValue(value.FLATNUMBER);
														if (value.FLATTYPEID !== 0)
															objs.APARTAMENT_TYPE.setValue(value.FLATTYPEID);
														objs.APARTAMENT_CADNUM.setValue(value.CADNUM);
														me.getAdresFias();
													}
												}
											},
												function (o) {
													o.handler = [
														{
															handler: function () {
																if (objs.S_FIASROOM.readOnly) return;
																me.clearElements(dnl.S_FIASROOM);
																me.getAdresFias();
															},
															cls: 'x-dict-trigger x_btn_clean'
														},
														o.handler
													];
													return o;
												}),
											objs.APARTAMENT_NUMBER = Ext.create('Ext.form.field.Text',
												{
													fieldLabel: 'Номер комнаты',
													labelWidth: me.labelWidth,
													maxWidth: 350,
													listeners: {
														blur: function () {
															me.getAdresFias();
														}
													}
												}),
											objs.APARTAMENT_TYPE = Ext.create('Keysystems.Controls.ComboBoxExtra',
												{
													labelWidth: me.labelWidth,
													fieldLabel: 'Тип комнаты',
													value: null,
													editable: false,
													store: Ext.create('Ext.data.Store',
														{
															fields: CBDataLib.getFields(),
															data: [],
															proxy: 'memory'
														}),
													queryMode: 'local',
													displayField: CBDataLib.displayField,
													valueField: CBDataLib.valueField,
													maxWidth: 350,
													listeners: {
														blur: function () {
															me.getAdresFias();
														}
													}
												}),
											objs.APARTAMENT_CADNUM = Ext.create('Ext.form.field.Text',
												{
													fieldLabel: 'Кадастровый номер',
													labelWidth: me.labelWidth,
													width: me.width,
													listeners: {
														blur: function () {
															me.getAdresFias();
														}
													}
												})
										]
									})
							]
						})
				]
			});
	},
	isFilled: function () {
		return true;
	},
	dataCollector: function () {
		var me = this,
			objs = me.objs;

		var data = me.callParent([false]);
		data.link = objs.link;
		data.adres = objs.ADRES.getValue();
		data.house = objs.HOUSE.getValue();
		data.corp = objs.CORP.getValue();
		data.flat = objs.FLAT.getValue();
		data.addtext = objs.ADDTEXT.getValue();
		data.sOksm = objs.S_OKSM.getLink();
		data.region = objs.REGION.getLink();
		data.rayon = objs.RAYON.getLink();
		data.city = objs.CITY.getLink();
		data.nPunkt = objs.NPUNKT.getLink();
		data.street = objs.STREET.getLink();
		data.index = objs.INDEX.getLink();
		data.address = objs.ADDRESS.getValue();
		data.postal_code = objs.POSTAL_CODE.getValue();
		data.region_aoguid = me.gksd('REGION_AOGUID');
		data.region_objectid = me.gksd('REGION_OBJECTID');
		data.region_kladr = objs.REGION_KLADR.getValue();
		data.region_code = objs.REGION_CODE.getValue();
		data.region_type = objs.REGION_TYPE.getValue();
		data.region_name = objs.REGION_NAME.getValue();
		data.area_aoguid = me.gksd('AREA_AOGUID');
		data.area_objectid = me.gksd('AREA_OBJECTID');
		data.area_kladr = objs.AREA_KLADR.getValue();
		data.area_type = objs.AREA_TYPE.getValue();
		data.area_name = objs.AREA_NAME.getValue();
		data.city_aoguid = me.gksd('CITY_AOGUID');
		data.city_objectid = me.gksd('CITY_OBJECTID');
		data.city_kladr = objs.CITY_KLADR.getValue();
		data.city_type = objs.CITY_TYPE.getValue();
		data.city_name = objs.CITY_NAME.getValue();
		data.place_aoguid = me.gksd('PLACE_AOGUID');
		data.place_objectid = me.gksd('PLACE_OBJECTID');
		data.place_kladr = objs.PLACE_KLADR.getValue();
		data.place_type = objs.PLACE_TYPE.getValue();
		data.place_name = objs.PLACE_NAME.getValue();
		data.street_aoguid = me.gksd('STREET_AOGUID');
		data.street_objectid = me.gksd('STREET_OBJECTID');
		data.street_kladr = objs.STREET_KLADR.getValue();
		data.street_type = objs.STREET_TYPE.getValue();
		data.street_name = objs.STREET_NAME.getValue();
		data.house_aoguid = me.gksd('HOUSE_AOGUID');
		data.house_objectid = me.gksd('HOUSE_OBJECTID');
		data.house_num = objs.HOUSE_NUM.getValue();
		data.house_addnum1 = objs.HOUSE_ADDNUM1.getValue();
		data.house_addnum2 = objs.HOUSE_ADDNUM2.getValue();
		data.house_type = objs.HOUSE_TYPE.getValue();
		data.house_addtype1 = objs.HOUSE_ADDTYPE1.getValue();
		data.house_addtype2 = objs.HOUSE_ADDTYPE2.getValue();
		data.house_cadnum = objs.HOUSE_CADNUM.getValue();		
		data.apartament_aoguid = me.gksd('APARTAMENT_AOGUID');
		data.apartament_objectid = me.gksd('APARTAMENT_OBJECTID');
		data.apartament_number = objs.APARTAMENT_NUMBER.getValue();
		data.apartament_type = objs.APARTAMENT_TYPE.getValue();
		data.apartament_cadnum = objs.APARTAMENT_CADNUM.getValue();
		return data;
	},
	loadNewCopyEditData: function () {
		var me = this;
		me.isRender = true;
	},
	loadCopyEditData: function () {
		var me = this,
			objs = me.objs,
			data = me.data.data;
		me.isRender = true;
		me.colorRender = true;
		me.adresRender = false;
		me.setLink(data.LINK);
		objs.link = data.LINK;
		objs.ADRES.setValue(data.TEMP_ADRES);
		objs.HOUSE.setValue(data.HOUSE);
		objs.CORP.setValue(data.CORP);
		objs.FLAT.setValue(data.FLAT);
		objs.ADDTEXT.setValue(data.ADDTEXT);
	},
	getExtra: function (endFunc, link) {
		var me = this,
			objs = me.objs;
		me.baseGetExtra({ link: link }, function (value) {
			me.isRender = false;
			me.getTab('General').setVisible(!value.isFias);
			me.getTab('Fias').setVisible(value.isFias);
			me.isEmptySource = value.isEmptySource;
			objs.S_OKSM.setValue(value.S_OKSM);
			objs.REGION.setValue(value.region);
			objs.RAYON.setValue(value.rayon);
			objs.CITY.setValue(value.city);
			objs.NPUNKT.setValue(value.nPunkt);
			objs.STREET.setValue(value.street);
			objs.INDEX.setValue(value.index);
			objs.ADRES.setValue(value.adresString);			

			if (value.isFias) {
				Ext.each(me.fiasColumns, function (c) {
					objs[c].setDisabled(!value.isEmptySource);
				});
				
				objs.ADDRESS.setDisabled(value.isEmptySource);

				if (value.isEmptySource){
					Ext.each(['S_FIASREGION', 'S_FIASAREA', 'S_FIASCITY', 'S_FIASPLACE', 'S_FIASSTREET', 'S_FIASHOUSE', 'S_FIASROOM'], function (key) {
						var trig = objs[key].fieldName;
						if (trig.triggers && trig.triggers.trigger2)
							trig.triggers.trigger2.handler = Ext.emptyFn;
					});
				}

				objs.REGION_TYPE.store.loadData(CBDataLib.get(_, _, value.regionTypes), false);
				objs.AREA_TYPE.store.loadData(CBDataLib.get(_, _, value.areaTypes), false);
				objs.CITY_TYPE.store.loadData(CBDataLib.get(_, _, value.cityTypes), false);
				objs.PLACE_TYPE.store.loadData(CBDataLib.get(_, _, value.placeTypes), false);
				objs.STREET_TYPE.store.loadData(CBDataLib.get(_, _, value.streetTypes), false);
				objs.HOUSE_TYPE.store.loadData(CBDataLib.get(_, _, value.houseTypes), false);
				objs.HOUSE_ADDTYPE1.store.loadData(CBDataLib.get(_, _, value.addHouseTypes), false);
				objs.HOUSE_ADDTYPE2.store.loadData(CBDataLib.get(_, _, value.addHouseTypes), false);
				objs.APARTAMENT_TYPE.store.loadData(CBDataLib.get(_, _, value.apartamentTypes), false);

				me.getExtraFias(value.row);

				objs.TEMP_ADRES.setValue(value.row.TEMP_ADRES);
				me.setObjsAccess(value.access, ['TEMP_ADRES']);
				objs.btnStartConvert.setVisible(value.access.TEMP_ADRES);
				me.setEnableBtnConvert();

			} else {
				var lst = [];
				Ext.each(value.addTextList, function (c) { lst.push([c]); });
				objs.ADDTEXT.store.loadData(lst, true);

				var colorStyle = 'color:#ff0000';
				if (value.colorRegion == -1) {
					objs.REGION.fieldName.fieldStyle = colorStyle;
				}

				if (value.colorRayon == -1) {
					objs.RAYON.fieldName.fieldStyle = colorStyle;
				}

				if (value.colorCity == -1) {
					objs.CITY.fieldName.fieldStyle = colorStyle;
				}

				if (value.colorNPunkt == -1) {
					objs.NPUNKT.fieldName.fieldStyle = colorStyle;
				}

				if (value.colorStreet == -1) {
					objs.STREET.fieldName.fieldStyle = colorStyle;
				}

				if (value.colorIndex == -1) {
					objs.INDEX.fieldName.fieldStyle = colorStyle;
				}
				objs.INDEX.setDisabled(!value.street.length);
				objs.RAYON.setDisabled(!value.region.length);
				objs.CITY.setDisabled(!value.region.length);
				objs.NPUNKT.setDisabled(!value.region.length);
				objs.STREET.setDisabled(!value.region.length);
				objs.REGION.setDisabled(!value.S_OKSM.length);
				me.colorRender = false;
			}
			if (endFunc) endFunc();
		});
	},

	getExtraFias: function (data) {
		var me = this,
			objs = me.objs;

		objs.ADDRESS.setValue(data.ADDRESS);
		Ext.each(me.fiasColumns, function (c) {
			objs[c].setValue(data[c]);
		});

		if (data.HOUSE_TYPE === 0) objs.HOUSE_TYPE.setValue(_);
		if (data.HOUSE_ADDTYPE1 === 0) objs.HOUSE_ADDTYPE1.setValue(_);
		if (data.HOUSE_ADDTYPE2 === 0) objs.HOUSE_ADDTYPE2.setValue(_);
		if (data.APARTAMENT_TYPE === 0) objs.APARTAMENT_TYPE.setValue(_);

		me.sksd('REGION_AOGUID', data.REGION_AOGUID);
		me.sksd('AREA_AOGUID', data.AREA_AOGUID);
		me.sksd('CITY_AOGUID', data.CITY_AOGUID);
		me.sksd('PLACE_AOGUID', data.PLACE_AOGUID);
		me.sksd('STREET_AOGUID', data.STREET_AOGUID);
		me.sksd('HOUSE_AOGUID', data.HOUSE_AOGUID);
		me.sksd('APARTAMENT_AOGUID', data.APARTAMENT_AOGUID);
		me.sksd('REGION_OBJECTID', data.REGION_OBJECTID);
		me.sksd('AREA_OBJECTID', data.AREA_OBJECTID);
		me.sksd('CITY_OBJECTID', data.CITY_OBJECTID);
		me.sksd('PLACE_OBJECTID', data.PLACE_OBJECTID);
		me.sksd('STREET_OBJECTID', data.STREET_OBJECTID);
		me.sksd('HOUSE_OBJECTID', data.HOUSE_OBJECTID);
		me.sksd('APARTAMENT_OBJECTID', data.APARTAMENT_OBJECTID);
		
		me.ksData.storeAdr = {};
	},

	getAdres: function () {
		var me = this;
		if (me.isRender) return;
		var objs = me.objs;

		ajaxRequest({
			url: 'SAdr/GetAdresString_A',
			params: {
				house: objs.HOUSE.getValue(),
				corp: objs.CORP.getValue(),
				flat: objs.FLAT.getValue(),
				addtext: objs.ADDTEXT.getValue(),
				region: objs.REGION.getLink(),
				rayon: objs.RAYON.getLink(),
				city: objs.CITY.getLink(),
				nPunkt: objs.NPUNKT.getLink(),
				street: objs.STREET.getLink(),
				index: objs.INDEX.getLink()
			},
			success: function (value) {
				me.isRender = true;
				objs.ADRES.setValue(value);
				me.isRender = false;
			}
		});
	},

	getAdresFias: function () {
		var me = this;
		if (me.isRender) return;
		var objs = me.objs,
			data = {
				postal_code: objs.POSTAL_CODE.getValue(),
				region_name: objs.REGION_NAME.getValue(),
				region_type: objs.REGION_TYPE.getValue(),
				area_name: objs.AREA_NAME.getValue(),
				area_type: objs.AREA_TYPE.getValue(),
				city_name: objs.CITY_NAME.getValue(),
				city_type: objs.CITY_TYPE.getValue(),
				place_name: objs.PLACE_NAME.getValue(),
				place_type: objs.PLACE_TYPE.getValue(),
				street_name: objs.STREET_NAME.getValue(),
				street_type: objs.STREET_TYPE.getValue(),
				house_num: objs.HOUSE_NUM.getValue(),
				house_addnum1: objs.HOUSE_ADDNUM1.getValue(),
				house_addnum2: objs.HOUSE_ADDNUM2.getValue(),
				house_type: objs.HOUSE_TYPE.getValue(),
				house_addtype1: objs.HOUSE_ADDTYPE1.getValue(),
				house_addtype2: objs.HOUSE_ADDTYPE2.getValue(),
				apartament_number: objs.APARTAMENT_NUMBER.getValue(),
				apartament_type: objs.APARTAMENT_TYPE.getValue()
			}

		ajaxRequest({
			url: 'SAdr/GetAdresFias_A',
			params: {
				data: JSON.stringify(data)
			},
			success: function (value) {
				me.isRender = true;
				objs.ADDRESS.setValue(value);
				me.isRender = false;
			}
		});
	},

	setEnableBtnConvert: function () {
		var me = this,
			objs = me.objs;
		objs.btnStartConvert.setDisabled(me.isEmptySource || objs.REGION_NAME.getValue().length || !objs.TEMP_ADRES.getValue().length);
	},

	convertAdres: function () {
		var me = this;

		me.showLoadMask({
			msg: 'Конвертация адреса ...',
			rid: ajaxRequest({
				url: 'SAdr/ConvertAdres_A',
				params: {
					link: me.data.data.LINK
				},
				success: function (value) {
					me.hideLoadMask();
					me.getExtraFias(value);
					me.setEnableBtnConvert();
					Ext.Msg.show({
						title: wmc.get('Attention'),
						msg: 'Процесс конвертации адреса завершен.',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.INFO
					});
				},
				failure: function () { me.hideLoadMask(); }
			})
		});
	},

	setAddressElements: function (data){
		var th = this,
			objs = th.objs,
			val = [];
		th.clearElements(dnl.S_FIASREGION);

		val.push(data);
		if (data.Parents) val = val.concat(data.Parents);

		val.forEach(r => {			
			if (r.AoLevel === 1){
				th.sksd('REGION_AOGUID', r.AoGuid);
				th.sksd('REGION_OBJECTID', r.ObjectId);
				objs.REGION_CODE.setValue(r.ObjectCode);
				objs.REGION_KLADR.setValue(r.Code);
				objs.REGION_NAME.setValue(r.Name);
				objs.REGION_TYPE.setValue(r.ShortName);
			}
			if (r.AoLevel === 5){
				th.sksd('CITY_AOGUID', r.AoGuid);
				th.sksd('CITY_OBJECTID', r.ObjectId);
				objs.CITY_KLADR.setValue(r.Code);
				objs.CITY_NAME.setValue(r.Name);
				objs.CITY_TYPE.setValue(r.ShortName);
			}
			if (r.AoLevel === 2){
				th.sksd('AREA_AOGUID', r.AoGuid);
				th.sksd('AREA_OBJECTID', r.ObjectId);
				objs.AREA_KLADR.setValue(r.Code);
				objs.AREA_NAME.setValue(r.Name);
				objs.AREA_TYPE.setValue(r.ShortName);
			}
			if (r.AoLevel === 6){
				th.sksd('PLACE_AOGUID', r.AoGuid);
				th.sksd('PLACE_OBJECTID', r.ObjectId);
				objs.PLACE_KLADR.setValue(r.Code);
				objs.PLACE_NAME.setValue(r.Name);
				objs.PLACE_TYPE.setValue(r.ShortName);
			}
			if (r.AoLevel === 8){
				th.sksd('STREET_AOGUID', r.AoGuid);
				th.sksd('STREET_OBJECTID', r.ObjectId);
				objs.STREET_KLADR.setValue(r.Code);
				objs.STREET_NAME.setValue(r.Name);
				objs.STREET_TYPE.setValue(r.ShortName);
			}
			if (r.AoLevel === 10){
				th.sksd('HOUSE_AOGUID', r.AoGuid);
				th.sksd('HOUSE_OBJECTID', r.ObjectId);
				objs.HOUSE_NUM.setValue(r.HouseNum);
				objs.HOUSE_ADDNUM1.setValue(r.AddNum1);
				objs.HOUSE_ADDNUM2.setValue(r.AddNum2);
				if (r.HouseType.Id !== 0)
					objs.HOUSE_TYPE.setValue(r.HouseType.Id);
				if (r.AddType1.Id !== 0)
					objs.HOUSE_ADDTYPE1.setValue(r.AddType1.Id);
				if (r.AddType2.Id !== 0)
					objs.HOUSE_ADDTYPE2.setValue(r.AddType2.Id);
				objs.HOUSE_CADNUM.setValue(r.CadNum);
			}
			if (r.AoLevel === 11){
				th.sksd('APARTAMENT_AOGUID', r.AoGuid);
				th.sksd('APARTAMENT_OBJECTID', r.ObjectId);
				objs.APARTAMENT_NUMBER.setValue(r.FlatNumber);
				if (r.FlatType.Id !== 0)
					objs.APARTAMENT_TYPE.setValue(r.FlatType.Id);
				objs.APARTAMENT_CADNUM.setValue(r.CadNum);
			}

		});

		th.getAdresFias();
	},

	searchAddress: function(text){
		var me = this,
			objs = me.objs,
			startTime = new Date().getTime(),
			parents = [];
		for (var adr in me.ksData.storeAdr){
			let d = [];
			if (adr.length < text.length){
				me.ksData.storeAdr[adr].forEach(r => {
					d.push({text: r.FullName, id: r.ObjectId, level: r.AoLevel});
				});
				parents.push({text: adr, id: d});
			}			
		}

		ajaxRequest({
			url: me.linkCode + '/SearchAddress_A',
			params: {
				text: text,
				parents: JSON.stringify(parents),
				selection: objs.ADDRESS.lastSelectedRecords ? objs.ADDRESS.lastSelectedRecords[0].data.FullName : ''
			},
			success: function(res) {
				var values = [];

				Ext.Array.each(res, function (r) {
					var val = r.FullName,
						parents = r.Parents;
					// если дом или квартира, надо объеденить с родителем
					if (r.AoLevel === 10 || r.AoLevel === 11) {
						for (var adr in me.ksData.storeAdr) {
							var data = me.ksData.storeAdr[adr].filter(d => d.ObjectId === r.ParentId);
							if (data.length){
								data = data[0];
								r.FullName = data.FullName + ", " + r.FullName.trim();
								parents = data.Parents.slice();
								parents.push(data);
								r.Parents = parents;
								break;
							}
						}
					}
					values.push(r);
					//values.push({ObjectId: r.ObjectId, FullName: val, AoLevel: r.AoLevel, Parents: parents, AddressObject: r.AddressObject, House: r.House, Apartament: r.Apartament});
				});
				objs.ADDRESS.store.loadData(values);
				objs.ADDRESS.storeData = objs.ADDRESS.getStore().getDataExt();
				
				var endTime = new Date().getTime();
				console.log('Потраченное время: ' + (endTime - startTime) + ' msec');
			}
		});
	},

	clearElements: function (code) {
		var me = this,
			objs = me.objs;

		me.sksd('APARTAMENT_AOGUID', _);
		me.sksd('APARTAMENT_OBJECTID', _);
		Ext.each(["APARTAMENT_NUMBER", "APARTAMENT_TYPE", "APARTAMENT_CADNUM", "POSTAL_CODE"], function (c) {
			objs[c].setValue(_);
		});

		if (code !== 'DICTIONARY_SFIASROOM') {
			me.sksd('HOUSE_AOGUID', _);
			me.sksd('HOUSE_OBJECTID', _);
			Ext.each(["HOUSE_NUM", "HOUSE_ADDNUM1", "HOUSE_ADDNUM2", "HOUSE_TYPE", "HOUSE_ADDTYPE1", "HOUSE_ADDTYPE2", "HOUSE_CADNUM"], function (c) {
				objs[c].setValue(_);
			});

			if (code !== 'DICTIONARY_SFIASHOUSE') {
				me.sksd('STREET_AOGUID', _);
				me.sksd('STREET_OBJECTID', _);
				Ext.each(["STREET_KLADR", "STREET_TYPE", "STREET_NAME"], function (c) {
					objs[c].setValue(_);
				});

				if (code !== 'DICTIONARY_SFIASSTREET') {
					me.sksd('PLACE_AOGUID', _);
					me.sksd('PLACE_OBJECTID', _);
					Ext.each(["PLACE_KLADR", "PLACE_TYPE", "PLACE_NAME"], function (c) {
						objs[c].setValue(_);
					});

					if (code !== 'DICTIONARY_SFIASPLACE') {
						me.sksd('CITY_AOGUID', _);
						me.sksd('CITY_OBJECTID', _);
						Ext.each(["CITY_KLADR", "CITY_TYPE", "CITY_NAME"], function (c) {
							objs[c].setValue(_);
						});

						if (code !== 'DICTIONARY_SFIASCITY') {
							me.sksd('AREA_AOGUID', _);
							me.sksd('AREA_OBJECTID', _);
							Ext.each(["AREA_KLADR", "AREA_TYPE", "AREA_NAME"], function (c) {
								objs[c].setValue(_);
							});

							if (code !== 'DICTIONARY_SFIASAREA') {
								me.sksd('REGION_AOGUID', _);
								me.sksd('REGION_OBJECTID', _);
								Ext.each(["REGION_KLADR", "REGION_CODE", "REGION_TYPE", "REGION_NAME"], function (c) {
									objs[c].setValue(_);
								});
							}
						}
					}
				}
			}
		}
	},

	setAdress: function (newValue) {
		var me = this,
			objs = me.objs;
		if (me.isRender) return;
		ajaxRequest({
			url: 'SAdr/ParserAdresString_A',
			params: {
				adres: newValue
			},
			success: function (value) {
				me.isRender = true;
				objs.REGION.setValue(value.regionAdr);
				objs.RAYON.setValue(value.rayonAdr);
				objs.CITY.setValue(value.cityAdr);
				objs.NPUNKT.setValue(value.npunktAdr);
				objs.STREET.setValue(value.streetAdr);
				objs.INDEX.setValue(value.indexAdr);
				objs.HOUSE.setValue(value.houseAdr);
				objs.CORP.setValue(value.corpAdr);
				objs.FLAT.setValue(value.flatAdr);
				objs.ADDTEXT.setValue(value.addtextAdr);
				me.isRender = false;
			}
		});
	},

	getStreet: function() {
		let me = this,
			objs = me.objs,
			link = objs.STREET.getLink(),
			func = function(value) {
				objs.INDEX.setValue(value);
				objs.INDEX.fieldName.setFieldStyle('color:black');
				me.isRender = false;
				me.getAdres();
			}
		
		if (link) {
			ajaxRequest({
				url: 'SAdr/GetStreet_A',
				params: {
					street: link
				},
				success: function (value) {
					func(value);
				}
			});
		} else {
			func();
		}
	},

	getParentKladr: function (kladr) {
		var me = this,
			iPos = Ext.Array.indexOf(me.mKladrCode, kladr),
			value;
		for (var i = iPos - 1; i > -1; i--) {
			value = me.objs[me.mKladrCode[i]].getValue();
			if (value.length) {
				return value[0];
			}
		}
		return undefined;
	},

	setValueAdres: function (val) {
		var me = this,
			iPos = me.allKladrCode.indexOf(val);
		for (var i = iPos + 1; i < me.allKladrCode.length; i++) {
			me.objs[me.allKladrCode[i]].setValue();
			if ("STREET" == me.allKladrCode[i]) {
				me.objs.INDEX.setDisabled(true);
				me.objs.INDEX.setValue();
			};
		}
	},

	saveAddress: function (inputParams, endFunc) {
		var me = this;
		selectDialogShow(wmc.get('Attention'), 'Добавить в историю измененение фактического/юридического адреса?', function() {
			inputParams.processingBeforeSaving = true;
			me.baseSaveData(inputParams, endFunc);
		}, function () {
			me.baseSaveData(inputParams, endFunc);
		});
	}
});