Ext.tip.QuickTipManager.init();

Ext.define('Keysystems.SActivityIndex.Tree', {
	extend: 'Ext.window.Window',
	modal: true,
	iconCls: 'x_btn_rang',
	layout: {type: 'vbox', align: 'stretch'},
	width: 600,
	height: 400,
	minHeight: 200,
	minWidth: 400,
	result: null,
	maximizable: true,

	labelWidth: 200,
	resizable: true,
	checkedLinks: [],
	submit: function () {
		let me = this,
			res = me.getChecked();
		if (me.ok) me.ok(res);
		me.close();
	},

	createButtons: function () {
		let me = this;
		return [
			{text: 'Выбрать', handler: me.submit, scope: this},
			{text: 'Закрыть', handler: me.close, scope: this}
		];
	},

	initComponent: function () {
		var me = this;

		me.buttons = me.createButtons();
		me.items = [
			me.treePanel = Ext.create('Ext.tree.Panel', {
				hideHeaders: true,
				scrollable: true,
				border: 0,
				flex: 1,
				tbar: [
					Ext.create('Ext.Button',
						{
							tooltip: 'Отметить все',
							tooltipType: 'title',
							iconCls: 'x_btn_galka',
							handler: function () {
								me.checkAll(true);
							}
						}),
					Ext.create('Ext.Button',
						{
							tooltip: 'Разметить все',
							tooltipType: 'title',
							iconCls: 'x_btn_unmark',
							handler: function () {
								me.checkAll(false);
							}
						}),
					Ext.create('Ext.Button',
						{
							tooltip: 'Обновить',
							tooltipType: 'title',
							iconCls: 'x_btn_refresh',
							handler: function () {
								me.refresh(true);
							}
						}),
					Ext.create('Ext.Button',
						{
							tooltip: 'Выход',
							tooltipType: 'title',
							iconCls: 'x_btn_exit',
							handler: function () {
								me.close();
							}
						})
				],
				caseSensitive: false,
				columns: [{
					xtype: 'treecolumn',
					text: 'Name',
					flex: 1,
					dataIndex: 'NAME',
					renderer: (value, rec) => {
						let css = "";
						if (rec.record.data.TEMP_SYS_CALC) {
							css = 'color:green';
						}
						return Ext.String.format('<span style="{0}">{1}. {2}</span>', css, rec.record.data.CODE, rec.record.data.NAME);
					}
				}],
				store: Ext.create('Ext.data.TreeStore', {
					fields: ['NAME', 'CODE'],
					root: {expanded: true, children: []},
					defaultRootText: ''
				}),
				rootVisible: false,
			})
		];
		me.treePanel.addDocked([me.searchField = Ext.create('Keysystems.Tree.SearchPanel', {
			treePanel: me.treePanel
		})]);
		me.callParent(arguments);
		me.on('afterrender', me.refresh.bind(me, false));
	},

	refresh: function (reload) {
		var me = this;
		var params = {
			whereArgs: JSON.stringify({
				'ObjType': {value: 2, type: 'int'},
				'CGroup': {value: 1 | 4, type: 'int'},
				'DetectSysCalc': {value: true, type: 'bool'}
			})
		};
		const loadMask = new Ext.LoadMask({
			msg: reload ? KS.L10n.updating_data : KS.L10n.loading_data,
			target: me,
			autoShow: true,
			rid: ajaxRequest({
				url: 'SActivityIndex/GetData_A',
				params: {gzipData: SignalR.pack(params)},
				success: function (result) {
					me.data = result.data;
					me.treePanel.store.setRootNode({expanded: true, children: me.genData(null)});
				},
				callback: function () {
					loadMask.destroy();
				}
			})
		});
	},

	appendData: function (r) {
		let me = this;
		r.leaf = !r.children.length;
		r.iconCls = 'no-icon';
		r.qtip = 'Код: ' + r.CODE + '<br />' + 'Наименование: ' + r.NAME;

		let typeText = miscTypes.SActivityIndexType[r.TYPE];
		if (typeText && typeText !== 'Пусто' && typeText !== '...') r.qtip += '<br />Тип: ' + typeText;

		let cgroup = r.CGROUP === 1 ? "Вероятность" : (r.CGROUP === 4 ? "Существенность" : "");
		if (cgroup) r.qtip += '<br />Группа критериев: ' + cgroup;
		if (r.TEMP_SYS_CALC && window.systemCalcs) {
			let sysCalc = window.systemCalcs.filter(calc => calc.Key === r.TEMP_SYS_CALC)[0];
			if (sysCalc) r.qtip += '<br />Алгоритм расчета: ' + sysCalc.Caption;
		}
		if (!r.children || !r.children.length) {
			r.checked = me.checkedLinks.indexOf(r.LINK) >= 0;
		}
		Ext.each(r.children, me.appendData, me);
	},

	genData: function (rootId) {
		var me = this,
			res = ArrayLib.filter(me.data, ['LINK_SELF'], rootId);
		Ext.each(res, me.appendData, me);
		return res;
	},
	getChecked: function () {
		const rows = this.treePanel.getChecked().map(node => node.data);
		
		//сортировка  отобранных узлов. формируем поле порядка согласно иерархии вида ORD_родителя[N].ORD_родителя[N-1]..ORD_родителя.ORD
		rows.forEach(row => {
			row.ORD_HIERARCHY = this.getHierarchyOrd(row);
		});
		rows.sort((a, b) => {
			if (a.Group !== b.Group)
				return a.Group - b.Group;

			const partsA = a.ORD_HIERARCHY.toString().split('.');
			const partsB = b.ORD_HIERARCHY.toString().split('.');
			if (partsA.length) {
				for (let i = 0; i < partsA.length; i++) {
					if (i >= partsB.length)
						return 1;
					if (+partsA[i] !== +partsB[i])
						return +partsA[i] - +partsB[i]
				}
			}
			return 0;
		});
		return rows;
	},
	getHierarchyOrd: function (row) {
		const me = this;
		const nodeParent = row.LINK_SELF ? this.treePanel.store.findNode('LINK', row.LINK_SELF) : null;
		const ordParent = nodeParent ? me.getHierarchyOrd(nodeParent.data) : null;
		return ordParent ? `${ordParent}.${row.ORD}` : row.ORD;
	},
	checkAll: function (checked) {
		this.treePanel.getRootNode().cascade(function (node) {
			if (node.data.checked != null) node.set('checked', checked);
		});
	}
});